/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.StyleChooser;

public class LineDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    ReportElement elt;
    ReportMain reportMain;
    JTextField widthField;
    JTextField heightField;
    JTextField xField;
    JTextField yField;
    boolean isModified = false;
    StyleChooser styleChooser;

    public LineDialog(ReportMain reportMain, ReportElement elt) {
        super(reportMain, LanguageEncoder.getText("Lines ..."), true);
        this.reportMain = reportMain;
        this.elt = elt;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Line Style ...")));
        p1.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Line Style")));
        StyleChooser mainPanel = this.styleChooser = new StyleChooser(this.reportMain, this.elt);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        p1.add("West", labelPanel);
        p1.add("Center", mainPanel);
        this.okButton = new JButton(LanguageEncoder.getText("Apply"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    boolean isModified() {
        return this.isModified;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.isModified = true;
            this.styleChooser.setStyle();
        }
        this.setVisible(false);
        this.dispose();
    }
}

