/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;

public class LocaleDateTimeDialog
extends JDialog
implements ActionListener {
    LocaleDateTimeFormat ldtf;
    int instanceType;
    ButtonGroup groupDate;
    ButtonGroup groupTime;
    JRadioButton chkFullDate;
    JRadioButton chkLongDate;
    JRadioButton chkMediumDate;
    JRadioButton chkShortDate;
    JRadioButton chkFullTime;
    JRadioButton chkLongTime;
    JRadioButton chkMediumTime;
    JRadioButton chkShortTime;
    JButton btnOk;
    JButton btnCancel;

    public LocaleDateTimeDialog(JFrame frame, String title, LocaleDateTimeFormat ldtf) {
        super(frame, title, true);
        this.init(ldtf);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(LocaleDateTimeFormat ldtf) {
        JPanel plChoice;
        JPanel plLabel;
        this.ldtf = ldtf;
        this.instanceType = ldtf.getInstanceType();
        this.setBackground(Color.lightGray);
        JPanel plMain = new JPanel();
        plMain.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
        plMain.setLayout(new BorderLayout());
        if (this.showDatePanel()) {
            plLabel = new JPanel(new FlowLayout(0));
            plLabel.add(new JLabel(LanguageEncoder.getText("Date")));
            plChoice = new JPanel(new FlowLayout(0));
            this.groupDate = new ButtonGroup();
            this.chkFullDate = new JRadioButton(LanguageEncoder.getText("Full"), true);
            plChoice.add(this.chkFullDate);
            this.chkLongDate = new JRadioButton(LanguageEncoder.getText("Long"), false);
            plChoice.add(this.chkLongDate);
            this.chkMediumDate = new JRadioButton(LanguageEncoder.getText("Medium"), false);
            plChoice.add(this.chkMediumDate);
            this.chkShortDate = new JRadioButton(LanguageEncoder.getText("Short"), false);
            plChoice.add(this.chkShortDate);
            this.groupDate.add(this.chkFullDate);
            this.groupDate.add(this.chkLongDate);
            this.groupDate.add(this.chkMediumDate);
            this.groupDate.add(this.chkShortDate);
            JPanel plDate = new JPanel(new BorderLayout());
            plDate.add("North", plLabel);
            plDate.add("South", plChoice);
            plMain.add("North", plDate);
        }
        if (this.showTimePanel()) {
            plLabel = new JPanel(new FlowLayout(0));
            plLabel.add(new JLabel(LanguageEncoder.getText("Time")));
            plChoice = new JPanel(new FlowLayout(0));
            this.groupTime = new ButtonGroup();
            this.chkFullTime = new JRadioButton(LanguageEncoder.getText("Full"), true);
            plChoice.add(this.chkFullTime);
            this.chkLongTime = new JRadioButton(LanguageEncoder.getText("Long"), false);
            plChoice.add(this.chkLongTime);
            this.chkMediumTime = new JRadioButton(LanguageEncoder.getText("Medium"), false);
            plChoice.add(this.chkMediumTime);
            this.chkShortTime = new JRadioButton(LanguageEncoder.getText("Short"), false);
            plChoice.add(this.chkShortTime);
            this.groupTime.add(this.chkFullTime);
            this.groupTime.add(this.chkLongTime);
            this.groupTime.add(this.chkMediumTime);
            this.groupTime.add(this.chkShortTime);
            JPanel plTime = new JPanel(new BorderLayout());
            plTime.add("North", plLabel);
            plTime.add("South", plChoice);
            plMain.add("South", plTime);
        }
        JPanel plButton = new JPanel(new FlowLayout(2));
        this.btnOk = new JButton(LanguageEncoder.getText("OK"));
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.btnCancel.addActionListener(this);
        plButton.add(this.btnOk);
        plButton.add(this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", plMain);
        contentPane.add("Center", plButton);
        if (this.showDatePanel()) {
            int dateStyle = ldtf.getDateStyle();
            switch (dateStyle) {
                case 0: {
                    this.chkFullDate.setSelected(true);
                    break;
                }
                case 1: {
                    this.chkLongDate.setSelected(true);
                    break;
                }
                case 2: {
                    this.chkMediumDate.setSelected(true);
                    break;
                }
                case 3: {
                    this.chkShortDate.setSelected(true);
                    break;
                }
            }
        }
        if (this.showTimePanel()) {
            int timeStyle = ldtf.getTimeStyle();
            switch (timeStyle) {
                case 0: {
                    this.chkFullTime.setSelected(true);
                    break;
                }
                case 1: {
                    this.chkLongTime.setSelected(true);
                    break;
                }
                case 2: {
                    this.chkMediumTime.setSelected(true);
                    break;
                }
                case 3: {
                    this.chkShortTime.setSelected(true);
                    break;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            int dateStyle = -1;
            int timeStyle = -1;
            if (this.showDatePanel()) {
                if (this.chkFullDate.isSelected()) {
                    dateStyle = 0;
                } else if (this.chkLongDate.isSelected()) {
                    dateStyle = 1;
                } else if (this.chkMediumDate.isSelected()) {
                    dateStyle = 2;
                } else if (this.chkShortDate.isSelected()) {
                    dateStyle = 3;
                }
            }
            if (this.showTimePanel()) {
                if (this.chkFullTime.isSelected()) {
                    timeStyle = 0;
                } else if (this.chkLongTime.isSelected()) {
                    timeStyle = 1;
                } else if (this.chkMediumTime.isSelected()) {
                    timeStyle = 2;
                } else if (this.chkShortTime.isSelected()) {
                    timeStyle = 3;
                }
            }
            if (this.showDatePanel() && this.showTimePanel()) {
                this.ldtf = LocaleDateTimeFormat.getDateTimeInstance(dateStyle, timeStyle);
            } else if (this.showDatePanel()) {
                this.ldtf = LocaleDateTimeFormat.getDateInstance(dateStyle);
            } else if (this.showTimePanel()) {
                this.ldtf = LocaleDateTimeFormat.getTimeInstance(timeStyle);
            }
        }
        this.dispose();
    }

    public LocaleDateTimeFormat getFormat() {
        return this.ldtf;
    }

    private boolean showDatePanel() {
        return this.instanceType == LocaleDateTimeFormat.DATE || this.instanceType == LocaleDateTimeFormat.DATETIME;
    }

    private boolean showTimePanel() {
        return this.instanceType == LocaleDateTimeFormat.TIME || this.instanceType == LocaleDateTimeFormat.DATETIME;
    }
}

