/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.LoginDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.util.internal.Coder;

public class LoginPanel
extends JPanel
implements ActionListener,
KeyListener {
    private JButton startReport;
    private JTextField nameField;
    private JPasswordField password;
    private LoginDialog loginDialog;
    private boolean login = false;
    private String templates_dir = null;
    private ReportMain reportMain;
    private String loginUser;

    public LoginPanel(LoginDialog loginDialog) {
        this(loginDialog, null);
    }

    public LoginPanel(LoginDialog loginDialog, String templates) {
        this.loginDialog = loginDialog;
        this.templates_dir = templates;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Login")));
        topPanel.setLayout(new FlowLayout());
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new GridLayout(2, 1, 5, 5));
        JLabel nameLbl = new JLabel(LanguageEncoder.getText("Name :") + " ");
        JLabel passLbl = new JLabel(LanguageEncoder.getText("Password :") + " ");
        this.nameField = new JTextField(20);
        this.password = new JPasswordField(20);
        this.nameField.addKeyListener(this);
        this.password.addKeyListener(this);
        if (ServerMessage.isEvalVersion() || LCKey.isFree()) {
            this.nameField.setText("guest");
            this.password.setText("*****");
        }
        namePanel.add(nameLbl);
        namePanel.add(passLbl);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new GridLayout(2, 1, 5, 5));
        fieldPanel.add(this.nameField);
        fieldPanel.add(this.password);
        topPanel.add(namePanel);
        topPanel.add(fieldPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.startReport = new JButton(LanguageEncoder.getText("Start Report Designer"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.startReport);
        buttonPanel.add(Box.createHorizontalGlue());
        this.startReport.addActionListener(this);
        this.add(topPanel);
        this.add(buttonPanel);
    }

    boolean login() {
        return this.login;
    }

    String loginUser() {
        return this.loginUser;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.startReport) {
            String msg = null;
            String userName = this.nameField.getText();
            char[] passChar = this.password.getPassword();
            String pass = Coder.encode(String.valueOf(passChar));
            Arrays.fill(passChar, '0');
            if (userName == null || userName.trim().equals("")) {
                msg = LanguageEncoder.getText("Invalid user name: Please enter the user name!");
            }
            if ((msg = ReportMain.addUser(userName, pass, false, false)) != null) {
                if (this.loginDialog != null) {
                    new JMessageDialog((Dialog)this.loginDialog, "Login", msg);
                } else {
                    new JMessageDialog((Frame)null, "Login", msg);
                }
                return;
            }
            this.login = true;
            this.loginUser = userName;
            if (this.loginDialog != null) {
                this.loginDialog.setVisible(false);
                this.loginDialog.dispose();
            } else {
                if (this.reportMain != null && this.reportMain.isVisible()) {
                    this.reportMain.toFront();
                    return;
                }
                this.reportMain = new ReportMain();
                this.reportMain.setLoginUser(userName);
                if (this.templates_dir != null) {
                    this.reportMain.setTemplatesDirectory(this.templates_dir);
                }
                this.reportMain.setVisible(true);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.startReport.doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

