/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.MasterSectionMenuBar;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportMenuBar;

public class MasterSectionDialog
extends JDialog
implements KeyListener {
    private static final Logger LOGGER = Logger.getLogger(MasterSectionDialog.class.getName());
    private ReportMain reportMain;
    private JScrollPane scrollPane;
    private JPanel parentPanel;

    public MasterSectionDialog(ReportMain rMain) throws Exception {
        super(rMain, LanguageEncoder.getText("Master Section"), true);
        this.reportMain = rMain;
        this.initialize();
        MasterSectionMenuBar menu = new MasterSectionMenuBar(rMain, this);
        this.addKeyListener(this);
        this.setJMenuBar(menu);
        this.setPosition();
    }

    private void initialize() throws Exception {
        if (!this.reportMain.report.isSideBySideLayout() || this.reportMain.designPanel.rulerPanel.getMasterSectionScrollPane() == null) {
            throw new Exception(LanguageEncoder.getText("Failed to edit master section. Please re-open this report and try again."));
        }
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.reportMain.designPanel.rulerPanel.getMasterSectionScrollPane(), "Center");
        this.scrollPane = this.reportMain.designPanel.rulerPanel.getMasterSectionScrollPane();
        this.setDefaultCloseOperation(2);
    }

    private void setPosition() {
        Dimension dim = this.getPreferredSize();
        dim.width = 400;
        dim.height = 300;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    void updateHeight() {
        if (this.scrollPane != null) {
            try {
                JSplitPane splitPane = (JSplitPane)((JPanel)this.scrollPane.getViewport().getComponent(0)).getComponent(0);
                ReportSection elt = ((ReportTreeTable)this.reportMain.report.getReportTables().elementAt(0)).getMasterSection();
                splitPane.setDividerLocation((int)Math.ceil((double)QbUtil.getPixelPerInch() * ((ReportElement)elt).getHeight()));
                this.validate();
                splitPane.repaint();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to update MasterSectionDialog height", ex);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void setVisible(boolean state, boolean pasteMenuState) {
        if (state) {
            try {
                ((ReportMenuBar)this.getJMenuBar()).setPasteEnabled(pasteMenuState);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to update state of the 'Paste' menu item", ex);
            }
        }
        super.setVisible(state);
    }

    @Override
    public void setVisible(boolean state) {
        if (!state && this.reportMain.designPanel.rulerPanel.getMasterSectionPanel() != null) {
            this.reportMain.designPanel.rulerPanel.getMasterSectionPanel().deselectFormatSection();
        }
        super.setVisible(state);
    }

    void updatePanel() {
        if (this.reportMain.designPanel.rulerPanel != null && this.reportMain.designPanel.rulerPanel.getMasterSectionScrollPane() != null) {
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.remove(this.scrollPane);
            this.scrollPane = this.reportMain.designPanel.rulerPanel.getMasterSectionScrollPane();
            contentPane.add((Component)this.scrollPane, "Center");
            this.validate();
            this.repaint();
        }
    }

    void setParentPanel(JPanel p) {
        this.parentPanel = p;
    }

    public JPanel getParentPanel() {
        return this.parentPanel;
    }
}

