/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.MasterSectionDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportMenuBar;

public class MasterSectionMenuBar
extends ReportMenuBar {
    private MasterSectionDialog masterSectionDialog;

    public MasterSectionMenuBar(ReportMain reportMain, MasterSectionDialog mDialog) {
        super(reportMain);
        this.masterSectionDialog = mDialog;
    }

    @Override
    public void setMenuEnabled(boolean b) {
        this.insertMenu.setEnabled(b);
        this.editMenu.setEnabled(b);
        this.formatMenu.setEnabled(b);
        this.setUndoEnabled(false);
    }

    @Override
    void initMenu() {
        this.isReady = false;
        this.addFileMenu();
        this.addEditMenu();
        this.addInsertMenu();
        this.addFormatMenu();
        this.isReady = true;
    }

    @Override
    void addFileMenu() {
        JMenu fileMenu = new JMenu(LanguageEncoder.getText("File"));
        fileMenu.add(this.newMenuItem(LanguageEncoder.getText("Close"), "Close"));
        this.add(fileMenu);
    }

    @Override
    void addInsertMenu() {
        this.insertMenu = new JMenu(LanguageEncoder.getText("Insert"));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Label"), "Insert Label", 76));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Formula"), "Insert Formula", 70));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Column Field"), "Insert Column Field"));
        this.insertChart = this.newMenuItem(LanguageEncoder.getText("Insert Chart"), "Insert Chart");
        this.insertMenu.add(this.insertChart);
        if (LCKey.isFree()) {
            this.insertChart.setEnabled(false);
            this.insertChart.setToolTipText(LanguageEncoder.getText("This feature is only included in full version, please contact sales@quadbase.com for more information."));
        }
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Image"), "Insert Image"));
        this.insertMenu.addSeparator();
        JMenu insertLineMenu = new JMenu(LanguageEncoder.getText("Insert Line"));
        insertLineMenu.add(this.newMenuItem(LanguageEncoder.getText("Horizontal Line"), "Horizontal Line"));
        insertLineMenu.add(this.newMenuItem(LanguageEncoder.getText("Vertical Line"), "Vertical Line"));
        this.insertMenu.add(insertLineMenu);
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Rectangle"), "Insert Grid"));
        this.insertMenu.addSeparator();
        JMenu todayMenu = new JMenu(LanguageEncoder.getText("Today's Date"));
        todayMenu.add(this.newMenuItem(LanguageEncoder.getText("Date"), "Date"));
        todayMenu.add(this.newMenuItem(LanguageEncoder.getText("Date & Time"), "Date & Time"));
        todayMenu.add(this.newMenuItem(LanguageEncoder.getText("Time"), "Time"));
        this.insertMenu.add(todayMenu);
        JMenu pageMenu = new JMenu(LanguageEncoder.getText("Page Number"));
        pageMenu.add(this.newMenuItem(LanguageEncoder.getText("Page Number"), "Page Number"));
        pageMenu.add(this.newMenuItem(LanguageEncoder.getText("Page Number Of Total Pages"), "Page Number Of Total Pages"));
        this.insertMenu.add(pageMenu);
        this.add(this.insertMenu);
    }

    @Override
    void addEditMenu() {
        super.addEditMenu();
        this.setPasteEnabled(this.reportMain.menuBar.paste.isEnabled());
    }

    @Override
    void addFormatMenu() {
        this.formatMenu = new JMenu(LanguageEncoder.getText("Format"));
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Data Format"), "Data Format"));
        this.chartExportFormat = this.newMenuItem(LanguageEncoder.getText("Chart Export Format"), "Chart Export Format");
        this.formatMenu.add(this.chartExportFormat);
        if (LCKey.isFree()) {
            this.chartExportFormat.setEnabled(false);
        }
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Font Style And Size"), "Font Style And Size"));
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Background Color"), "Background Color"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Border"), "Border"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("HyperLink"), "HyperLink"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Bounds"), "Bounds"));
        JMenu alignmentMenu = new JMenu(LanguageEncoder.getText("Alignment"));
        JMenu horizontalMenu = new JMenu(LanguageEncoder.getText("Horizontal"));
        JMenu verticalMenu = new JMenu(LanguageEncoder.getText("Vertical"));
        horizontalMenu.add(this.newMenuItem(LanguageEncoder.getText("Left"), "Left"));
        horizontalMenu.add(this.newMenuItem(LanguageEncoder.getText("Center"), "Center"));
        horizontalMenu.add(this.newMenuItem(LanguageEncoder.getText("Right"), "Right"));
        verticalMenu.add(this.newMenuItem(LanguageEncoder.getText("Top"), "Top"));
        verticalMenu.add(this.newMenuItem(LanguageEncoder.getText("Middle"), "Middle"));
        verticalMenu.add(this.newMenuItem(LanguageEncoder.getText("Bottom"), "Bottom"));
        alignmentMenu.add(horizontalMenu);
        alignmentMenu.add(verticalMenu);
        this.formatMenu.add(alignmentMenu);
        this.add(this.formatMenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String menuStr = e.getActionCommand();
        if (menuStr.equals(LanguageEncoder.getText("Close"))) {
            this.masterSectionDialog.setVisible(false);
            this.masterSectionDialog.dispose();
        } else {
            super.actionPerformed(e);
        }
    }
}

