/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.ReadDatabase;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.InitParamDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SetFontDialog;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.NewScriptParser;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.ParseException;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.ICustomDefinedFunctions;
import quadbase.util.IFunctionConstants;

public class NewEditDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(NewEditDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    JButton testButton;
    JButton saveAsButton;
    JButton insertFontButton;
    JButton insertColorButton;
    JButton browseButton;
    JButton initParamButton;
    JButton plusBtn;
    JButton minusBtn;
    JButton multiplyBtn;
    JButton divideBtn;
    JButton andBtn;
    JButton orBtn;
    JButton leftPar;
    JButton rightPar;
    JButton leftCur;
    JButton rightCur;
    JButton eqBtn;
    JButton ltBtn;
    JButton leBtn;
    JButton gtBtn;
    JButton geBtn;
    JButton neBtn;
    UndoTextArea ta;
    JTree tree;
    ReportMain reportMain;
    int idx = -1;
    Formula formula;
    Formula formula2;
    Script script;
    Script script2;
    String text;
    DBInfoBasic dbInfo;
    ReadDatabase readDB;
    String[] tableName;
    Vector[] displayName;
    boolean isModified;
    Vector formulaParams = new Vector();

    public NewEditDialog(ReportMain reportMain, int idx, boolean isFormula, String title) {
        super(reportMain, title, true);
        this.reportMain = reportMain;
        this.idx = idx;
        this.dbInfo = reportMain.report.dbInfo;
        if (isFormula) {
            this.formula = reportMain.report.formulas.elementAt(idx);
        } else {
            this.script = reportMain.report.scripts.elementAt(idx);
        }
        reportMain.report.cloneFormulaParams(this.formulaParams);
        this.init();
        this.setPosition();
    }

    public NewEditDialog(ReportMain reportMain, Formula formula, Script script, String text, String title) {
        super(reportMain, title, true);
        this.reportMain = reportMain;
        this.formula = formula;
        this.script = script;
        this.text = text;
        this.dbInfo = reportMain.report.dbInfo;
        reportMain.report.cloneFormulaParams(this.formulaParams);
        if (formula != null || script != null) {
            this.init();
        } else {
            this.initText();
        }
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.7);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        JScrollPane editPanel = new JScrollPane();
        if (this.formula != null) {
            this.ta = new UndoTextArea(this.formula.getText(), 25, 100);
            editPanel.getViewport().add(this.ta);
        } else {
            this.ta = new UndoTextArea(this.script.getText(), 25, 100);
            editPanel.getViewport().add(this.ta);
        }
        JSplitPane splitPane = new JSplitPane(1, false);
        splitPane.setLeftComponent(editPanel);
        splitPane.setRightComponent(this.getHelperPanel());
        splitPane.setResizeWeight(0.9);
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        upperPanel.add((Component)splitPane, "Center");
        upperPanel.add((Component)this.getOperatorsPanel(), "South");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)upperPanel, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
    }

    private void initText() {
        JScrollPane editPanel = new JScrollPane();
        this.ta = new UndoTextArea(this.text, 7, 60);
        editPanel.getViewport().add(this.ta);
        if (this.text.equals("NEW LABEL")) {
            this.ta.select(0, 9);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(1));
        btnPanel.add(this.okButton);
        btnPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)editPanel, "Center");
        contentPane.add((Component)btnPanel, "South");
        this.pack();
    }

    public JPanel getOperatorsPanel() {
        JPanel operatorsPanel = new JPanel();
        operatorsPanel.setLayout(new GridLayout(2, 8, 5, 5));
        this.plusBtn = new JButton("+");
        this.minusBtn = new JButton("-");
        this.multiplyBtn = new JButton("*");
        this.divideBtn = new JButton("/");
        this.andBtn = new JButton("AND");
        this.orBtn = new JButton("OR");
        this.leftPar = new JButton("(");
        this.rightPar = new JButton(")");
        this.eqBtn = new JButton("==");
        this.ltBtn = new JButton("<");
        this.leBtn = new JButton("<=");
        this.gtBtn = new JButton(">");
        this.geBtn = new JButton(">=");
        this.neBtn = new JButton("<>");
        this.leftCur = new JButton("{");
        this.rightCur = new JButton("}");
        this.plusBtn.addActionListener(this);
        this.minusBtn.addActionListener(this);
        this.multiplyBtn.addActionListener(this);
        this.divideBtn.addActionListener(this);
        this.andBtn.addActionListener(this);
        this.orBtn.addActionListener(this);
        this.leftPar.addActionListener(this);
        this.rightPar.addActionListener(this);
        this.eqBtn.addActionListener(this);
        this.ltBtn.addActionListener(this);
        this.leBtn.addActionListener(this);
        this.gtBtn.addActionListener(this);
        this.geBtn.addActionListener(this);
        this.neBtn.addActionListener(this);
        this.leftCur.addActionListener(this);
        this.rightCur.addActionListener(this);
        operatorsPanel.add(this.plusBtn);
        operatorsPanel.add(this.minusBtn);
        operatorsPanel.add(this.multiplyBtn);
        operatorsPanel.add(this.divideBtn);
        operatorsPanel.add(this.andBtn);
        operatorsPanel.add(this.orBtn);
        operatorsPanel.add(this.leftPar);
        operatorsPanel.add(this.rightPar);
        operatorsPanel.add(this.eqBtn);
        operatorsPanel.add(this.neBtn);
        operatorsPanel.add(this.ltBtn);
        operatorsPanel.add(this.leBtn);
        operatorsPanel.add(this.gtBtn);
        operatorsPanel.add(this.geBtn);
        operatorsPanel.add(this.leftCur);
        operatorsPanel.add(this.rightCur);
        return operatorsPanel;
    }

    public JScrollPane getHelperPanel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        root.add(this.getFieldNameList());
        root.add(this.getFormulaNameList());
        if (this.script != null) {
            if (this.reportMain.selectedObject instanceof ReportTable) {
                root.add(this.getTableAttributes());
            } else if (this.reportMain.selectedObject instanceof ReportSection) {
                root.add(this.getSectionAttributes());
            } else {
                root.add(this.getCellAttributes());
            }
        }
        root.add(this.getParameterList());
        if (this.dbInfo != null) {
            root.add(this.getDBFieldNameList());
        }
        root.add(this.getNumericFunctions());
        root.add(this.getStringFunctions());
        root.add(this.getDateFunctions());
        root.add(this.getTableDataFunctions());
        root.add(this.getOtherFunctions());
        DefaultMutableTreeNode cFuncNode = this.getCustomDefinedFunctions();
        if (cFuncNode != null) {
            root.add(cFuncNode);
        }
        this.tree = new JTree(root);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = NewEditDialog.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() >= 2) {
                    NewEditDialog.this.insertText(NewEditDialog.this.getSelectedText());
                }
            }
        });
        this.tree.setRootVisible(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tree);
        Dimension size = scrollPane.getPreferredSize();
        size.width = 200;
        scrollPane.setPreferredSize(size);
        return scrollPane;
    }

    public JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(2, 4, 5, 5));
        this.insertFontButton = new JButton(LanguageEncoder.getText("Insert Font"));
        this.insertFontButton.addActionListener(this);
        this.insertColorButton = new JButton(LanguageEncoder.getText("Insert Color"));
        this.insertColorButton.addActionListener(this);
        if (this.script == null) {
            this.insertFontButton.setEnabled(false);
            this.insertColorButton.setEnabled(false);
        }
        this.browseButton = new JButton(LanguageEncoder.getText("Browse Data Field"));
        this.browseButton.addActionListener(this);
        this.initParamButton = new JButton(LanguageEncoder.getText("Initialize Parameter"));
        this.initParamButton.addActionListener(this);
        this.testButton = new JButton(LanguageEncoder.getText("Test"));
        this.testButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.saveAsButton = new JButton(LanguageEncoder.getText("Save As"));
        this.saveAsButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.insertFontButton);
        buttonPanel.add(this.insertColorButton);
        buttonPanel.add(this.browseButton);
        buttonPanel.add(this.initParamButton);
        buttonPanel.add(this.testButton);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.saveAsButton);
        buttonPanel.add(this.cancelButton);
        return buttonPanel;
    }

    private void insertText(String newStr) {
        if (newStr == null) {
            return;
        }
        this.ta.replaceSelection(newStr);
    }

    private DefaultMutableTreeNode getFieldNameList() {
        int i;
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Columns");
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        int ct = table.getColumnCount();
        for (i = 0; i < ct; ++i) {
            ReportColumn col = table.getColumn(i);
            int colInfoIndex = this.reportMain.report.getColInfoIndex(col);
            String name = this.reportMain.report.getDBSourceType() == Manager.DATAVIEW || col.getDBTableName() == null || col.getDBTableName().equals("") ? col.getText() : col.getDBTableName() + "." + col.getText();
            tableNode.add(new DefaultMutableTreeNode(name + " (" + DataType.getTypeName(this.reportMain.report.getSQLType(colInfoIndex)) + ")"));
        }
        for (i = 0; this.reportMain.report.subReports != null && i < this.reportMain.report.subReports.size(); ++i) {
            Report rpt = this.reportMain.report.getSubReportArray()[i];
            if (rpt == null) continue;
            DefaultMutableTreeNode subTableNode = new DefaultMutableTreeNode("SUB" + (i + 1));
            table = rpt.getReportTables().elementAt(0);
            ct = table.getColumnCount();
            for (int j = 0; j < ct; ++j) {
                ReportColumn col = table.getColumn(j);
                int colInfoIndex = rpt.getColInfoIndex(col);
                String name = rpt.getDBSourceType() == Manager.DATAVIEW || col.getDBTableName() == null || col.getDBTableName().equals("") ? col.getText() : col.getDBTableName() + "." + col.getText();
                subTableNode.add(new DefaultMutableTreeNode(name + " (" + DataType.getTypeName(rpt.getSQLType(colInfoIndex)) + ")"));
            }
            tableNode.add(subTableNode);
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getFormulaNameList() {
        int i;
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Formulas");
        Vector<Formula> formulas = this.reportMain.report.formulas;
        for (i = 0; i < formulas.size(); ++i) {
            Formula formula = formulas.elementAt(i);
            tableNode.add(new DefaultMutableTreeNode("@" + formula.getName()));
        }
        for (i = 0; this.reportMain.report.subReports != null && i < this.reportMain.report.subReports.size(); ++i) {
            Report rpt = this.reportMain.report.getSubReportArray()[i];
            if (rpt == null) continue;
            DefaultMutableTreeNode subTableNode = new DefaultMutableTreeNode("SUB" + (i + 1));
            formulas = rpt.formulas;
            for (int j = 0; j < formulas.size(); ++j) {
                Formula formula = formulas.elementAt(j);
                subTableNode.add(new DefaultMutableTreeNode("@" + formula.getName()));
            }
            tableNode.add(subTableNode);
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getParameterList() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Parameters");
        Vector<Parameter> queryParameters = this.reportMain.report.getQueryParameters();
        for (int i = 0; queryParameters != null && i < queryParameters.size(); ++i) {
            Parameter param = queryParameters.elementAt(i);
            tableNode.add(new DefaultMutableTreeNode(":" + param.getName()));
        }
        Vector<Parameter> formulaParameters = this.reportMain.report.getFormulaParameters();
        for (int i = 0; formulaParameters != null && i < formulaParameters.size(); ++i) {
            Parameter param = formulaParameters.elementAt(i);
            tableNode.add(new DefaultMutableTreeNode("?" + param.getName()));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getDBFieldNameList() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Database Fields");
        try {
            int i;
            this.readDB = this.dbInfo.isUseJNDIDataSource() ? new ReadDatabase(this.dbInfo.getJNDIName(), this.dbInfo.getEnvProperties()) : new ReadDatabase(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword());
            this.tableName = QueryParser.getAllTableNames(this.dbInfo.getQuery());
            this.displayName = new Vector[this.tableName.length];
            for (i = 0; i < this.displayName.length; ++i) {
                Object[][] colInfo = this.readDB.getTableInfo(this.tableName[i], false);
                this.displayName[i] = new Vector();
                for (Object[] element : colInfo) {
                    this.displayName[i].add(element[0].toString() + " (" + element[2].toString() + ")");
                }
            }
            for (i = 0; i < this.tableName.length; ++i) {
                DefaultMutableTreeNode tableNameNode = new DefaultMutableTreeNode(this.tableName[i]);
                for (int j = 0; j < this.displayName[i].size(); ++j) {
                    DefaultMutableTreeNode columnNameNode = new DefaultMutableTreeNode(this.displayName[i].elementAt(j).toString());
                    tableNameNode.add(columnNameNode);
                }
                tableNode.add(tableNameNode);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Failed to get database field name list", e);
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getCellAttributes() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Cell Attributes");
        for (String element : Script.CELLATTR) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getSectionAttributes() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Section Attributes");
        for (String element : Script.SECTIONATTR) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getTableAttributes() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Section Attributes");
        for (String element : Script.TABLEATTR) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getNumericFunctions() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Numeric Functions");
        for (String element : IFunctionConstants.NEW_NUM_NAME) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getStringFunctions() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("String Functions");
        for (String element : IFunctionConstants.NEW_STR_NAME) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getDateFunctions() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Date Functions");
        for (String element : IFunctionConstants.NEW_DATE_NAME) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getTableDataFunctions() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Table Data Functions");
        for (String element : IFunctionConstants.TD_FUNC_NAME) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getOtherFunctions() {
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Other Functions");
        for (String element : IFunctionConstants.OTHER_FUNC_NAME) {
            tableNode.add(new DefaultMutableTreeNode(element));
        }
        return tableNode;
    }

    private DefaultMutableTreeNode getCustomDefinedFunctions() {
        ICustomDefinedFunctions funcList = Report.getCustomDefinedFunctions();
        if (funcList == null) {
            return null;
        }
        String[] funcNames = funcList.getAllFunctionNames();
        if (funcNames == null) {
            return null;
        }
        DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode("Custom Defined Functions");
        for (String funcName : funcNames) {
            tableNode.add(new DefaultMutableTreeNode(funcName + "( )"));
        }
        return tableNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block128: {
            Object btn = e.getSource();
            if (btn == this.plusBtn) {
                this.insertText("+");
            } else if (btn == this.minusBtn) {
                this.insertText("-");
            } else if (btn == this.multiplyBtn) {
                this.insertText("*");
            } else if (btn == this.divideBtn) {
                this.insertText("/");
            } else if (btn == this.eqBtn) {
                this.insertText("==");
            } else if (btn == this.neBtn) {
                this.insertText("<>");
            } else if (btn == this.ltBtn) {
                this.insertText("<");
            } else if (btn == this.leBtn) {
                this.insertText("<=");
            } else if (btn == this.gtBtn) {
                this.insertText(">");
            } else if (btn == this.geBtn) {
                this.insertText(">=");
            } else if (btn == this.andBtn) {
                this.insertText("AND");
            } else if (btn == this.orBtn) {
                this.insertText("OR");
            } else if (btn == this.leftPar) {
                this.insertText("(");
            } else if (btn == this.rightPar) {
                this.insertText(")");
            } else if (btn == this.leftCur) {
                this.insertText("{");
            } else if (btn == this.rightCur) {
                this.insertText("}");
            } else if (btn == this.insertFontButton) {
                SetFontDialog setFontDialog = new SetFontDialog(this.reportMain, null, false, Color.BLACK, 5);
                setFontDialog.setVisible(true);
                Font font = setFontDialog.getFont();
                if (setFontDialog.isModified() && font != null) {
                    this.insertText("[\"" + font.getName() + "\"," + this.getStyle(font.getStyle()) + "," + font.getSize() + "," + setFontDialog.isUnderline() + "]");
                }
            } else if (btn == this.insertColorButton) {
                Color color = ColorDialog.showDialog(this.reportMain, "Color Chooser", null);
                this.reportMain.addRecentColor(color);
                if (color != null) {
                    this.insertText("[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]");
                }
            } else if (btn == this.testButton) {
                String s = this.ta.getText();
                if (s.trim().equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please enter formula/script!"));
                    return;
                }
                String oldText = null;
                Operand oldFormula = null;
                Vector oldVar = null;
                Vector oldArray = null;
                Vector oldStmt = null;
                try {
                    InputStreamReader inputStreamReader;
                    Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                    formulaVec.add(this.reportMain.report.formulas);
                    for (int i = 0; this.reportMain.report.subReports != null && i < this.reportMain.report.subReports.size(); ++i) {
                        Report rpt = this.reportMain.report.getSubReportArray()[i];
                        if (rpt == null) continue;
                        formulaVec.add(rpt.formulas);
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes("UTF-8"));
                    if (this.formula != null) {
                        oldFormula = this.formula.getFormula();
                        oldText = this.formula.getText();
                        inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        this.formula.setText(s);
                        this.formula.setFormula(parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.formula.getName()));
                        this.formula.getValue(this.reportMain.report.getReportTables().elementAt(0), 0, 1, 1, 1, 1, this.reportMain.report, new ReportCell(), new Object(), false, null, null, null, true);
                    } else {
                        oldVar = this.script.getVariables();
                        oldArray = this.script.getArrays();
                        oldStmt = this.script.getStatements();
                        inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewScriptParser parser = new NewScriptParser(inputStreamReader);
                        this.script.setScript(parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.script.getName(), this.reportMain.report));
                        try {
                            this.script.testApplyScript(this.reportMain.report.getReportTables().elementAt(0), 0, 1, 1, 1, 1, this.reportMain.report, new ReportCell(), null, null);
                            this.script.testApplyScript(this.reportMain.report.getReportTables().elementAt(0), 1, 1, 1, 1, this.reportMain.report, new ReportSection());
                        }
                        catch (NullPointerException ex) {
                            LOGGER.log(Level.FINEST, "Failed to test apply script", ex);
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            LOGGER.log(Level.FINEST, "Failed to test apply script", ex);
                        }
                    }
                    new JMessageDialog((Dialog)this, "Parsing result", LanguageEncoder.getText("The formula/Script is syntactically correct!"));
                }
                catch (ParseException ex) {
                    if (ex.getMessage().endsWith("does not exist!")) {
                        new JMessageDialog((Dialog)this, "error", ex.getMessage());
                        LOGGER.log(Level.FINEST, "Element doesn't exist ", ex);
                    } else {
                        LOGGER.log(Level.FINEST, "Syntax error", ex);
                        new JMessageDialog((Dialog)this, "Syntax error", this.formatErrorMessage(s, ex.toString()));
                    }
                }
                catch (Throwable t) {
                    if (t.toString().startsWith("java.lang.ClassCastException")) {
                        LOGGER.log(Level.FINEST, "Illegal Argument: argument and its required data type doesn't match", t);
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Illegal Argument: argument and its required data type doesn't match!"));
                    }
                    LOGGER.log(Level.FINEST, "Syntax Error", t);
                    new JMessageDialog((Dialog)this, "Syntax Error", this.formatErrorMessage(s, t.toString()));
                }
                if (this.formula != null) {
                    this.formula.setText(oldText);
                    this.formula.setFormula(oldFormula);
                } else {
                    this.script.setVariables(oldVar);
                    this.script.setArrays(oldArray);
                    this.script.setStatements(oldStmt);
                }
            } else if (btn == this.browseButton) {
                if (this.tree.isSelectionEmpty()) {
                    new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("Select a leaf node from the Database Fields folder in the upper right panel"));
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
                if (!node.isLeaf()) {
                    new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("Select a leaf node from the Database Fields folder in the upper right panel"));
                    return;
                }
                DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)node.getParent();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tableNode.getParent();
                if (parent != null && parent.getUserObject().toString().equals("Database Fields")) {
                    String tableName = tableNode.getUserObject().toString();
                    String columnName = node.getUserObject().toString();
                    int index = columnName.lastIndexOf(40);
                    columnName = columnName.substring(0, index).trim();
                    try {
                        this.readDB = this.dbInfo.isUseJNDIDataSource() ? new ReadDatabase(this.dbInfo.getJNDIName(), this.dbInfo.getEnvProperties()) : new ReadDatabase(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword());
                        String query = QbUtil.buildSelectQuery(this.readDB, columnName, tableName);
                        Vector vec = this.readDB.excuteQuery(query, 0, 20);
                        String[] listData = new String[vec.size()];
                        for (int i = 0; i < vec.size(); ++i) {
                            if (((Vector)vec.elementAt(i)).elementAt(0) == null) continue;
                            listData[i] = ((Vector)vec.elementAt(i)).elementAt(0).toString();
                        }
                        JList<String> list = new JList<String>(listData);
                        new JMessageDialog((Dialog)this, tableName + "." + columnName, list);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Action failed", ex);
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.toString());
                    }
                } else {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), "Highlighted item is not a database field, please select a database field");
                }
            } else if (btn == this.initParamButton) {
                String s = this.ta.getText();
                if (s == null || s.trim().equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("No parameter(s) found"));
                    return;
                }
                try {
                    Vector<Parameter> params;
                    Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                    formulaVec.add(this.reportMain.report.formulas);
                    for (int i = 0; this.reportMain.report.subReports != null && i < this.reportMain.report.subReports.size(); ++i) {
                        Report rpt = this.reportMain.report.getSubReportArray()[i];
                        if (rpt == null) continue;
                        formulaVec.add(rpt.formulas);
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes("UTF-8"));
                    if (this.formula != null) {
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.formula.getName());
                        params = this.reportMain.report.getFormulaParameters(this.formula.getName());
                    } else {
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewScriptParser parser = new NewScriptParser(inputStreamReader);
                        parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.script.getName(), this.reportMain.report);
                        params = this.reportMain.report.getFormulaParameters(this.script.getName());
                    }
                    if (params.size() > 0) {
                        new InitParamDialog(this.reportMain, this, params).setVisible(true);
                        break block128;
                    }
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("No parameter(s) found"));
                }
                catch (ParseException ex) {
                    if (ex.getMessage().endsWith("does not exist!")) {
                        LOGGER.log(Level.FINEST, "Parse error", ex);
                        new JMessageDialog((Dialog)this, "error", ex.getMessage());
                        break block128;
                    }
                    LOGGER.log(Level.FINEST, "Syntax error", ex);
                    new JMessageDialog((Dialog)this, "Syntax error", this.formatErrorMessage(s, ex.toString()));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.FINEST, "Syntax error", t);
                    new JMessageDialog((Dialog)this, "Syntax Error", this.formatErrorMessage(s, t.toString()));
                }
            } else if (btn == this.okButton) {
                String s = this.ta.getText();
                if (s.trim().equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please enter formula/script!"));
                    return;
                }
                Operand oldFormula = null;
                Vector oldVar = null;
                Vector oldArray = null;
                Vector oldStmt = null;
                try {
                    InputStreamReader inputStreamReader;
                    Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                    formulaVec.add(this.reportMain.report.formulas);
                    for (int i = 0; this.reportMain.report.subReports != null && i < this.reportMain.report.subReports.size(); ++i) {
                        Report rpt = this.reportMain.report.getSubReportArray()[i];
                        if (rpt == null) continue;
                        formulaVec.add(rpt.formulas);
                    }
                    this.reportMain.report.deleteUnInitializedParam();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes("UTF-8"));
                    if (this.formula != null) {
                        oldFormula = this.formula.getFormula();
                        inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        this.formula.setFormula(parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.formula.getName()));
                        this.formula.getValue(this.reportMain.report.getReportTables().elementAt(0), 0, 1, 1, 1, 1, this.reportMain.report, new ReportCell(), new Object(), false, null, null, null, true);
                        if (!this.reportMain.report.paramsInitialized()) {
                            throw new Exception("parameter(s) not initialized");
                        }
                        this.formula.setText(s);
                        this.formula.getDatatype(this.reportMain.report);
                        boolean exist = false;
                        for (int i = 0; i < this.reportMain.report.formulas.size(); ++i) {
                            if (this.formula != this.reportMain.report.formulas.elementAt(i)) continue;
                            exist = true;
                            break;
                        }
                        if (!exist) {
                            this.reportMain.report.formulas.addElement(this.formula);
                        }
                    } else if (this.script != null) {
                        if (this.reportMain.report.isCrossTab() && this.reportMain.selectedObject instanceof ColumnBreakColumn && (s.toLowerCase().contains("value=") || s.toLowerCase().contains("value ="))) {
                            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please do NOT change Column Break Value's value!"));
                            return;
                        }
                        oldVar = this.script.getVariables();
                        oldArray = this.script.getArrays();
                        oldStmt = this.script.getStatements();
                        inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewScriptParser parser = new NewScriptParser(inputStreamReader);
                        this.script.setScript(parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.script.getName(), this.reportMain.report));
                        try {
                            if (this.reportMain.selectedObject instanceof ReportTableElement) {
                                this.script.testApplyScript(this.reportMain.report.getReportTables().elementAt(0), 1, 1, 1, 1, this.reportMain.report, new ReportSection());
                            } else {
                                this.script.testApplyScript(this.reportMain.report.getReportTables().elementAt(0), 0, 1, 1, 1, 1, this.reportMain.report, new ReportCell(), null, null);
                            }
                        }
                        catch (NullPointerException ex) {
                            LOGGER.log(Level.FINEST, "Failed to test apply script", ex);
                        }
                        if (!this.reportMain.report.paramsInitialized()) {
                            throw new Exception("parameter(s) not initialized");
                        }
                        this.script.setText(s);
                        boolean exist = false;
                        for (int i = 0; i < this.reportMain.report.scripts.size(); ++i) {
                            if (this.script != this.reportMain.report.scripts.elementAt(i)) continue;
                            exist = true;
                            break;
                        }
                        if (!exist) {
                            this.reportMain.report.scripts.addElement(this.script);
                        }
                    } else {
                        this.text = QbUtil.replaceUnicode(s);
                        this.reportMain.selectedObject.setText(this.text);
                    }
                    this.reportMain.report.deleteUnUsedParam();
                    this.isModified = true;
                    this.setVisible(false);
                    this.dispose();
                }
                catch (ParseException ex) {
                    if (ex.getMessage().endsWith("does not exist!")) {
                        LOGGER.log(Level.FINEST, "Parse error", ex);
                        new JMessageDialog((Dialog)this, "error", ex.getMessage());
                    } else {
                        LOGGER.log(Level.FINEST, "Syntax error", ex);
                        new JMessageDialog((Dialog)this, "Syntax error", this.formatErrorMessage(s, ex.toString()));
                    }
                    if (this.formula != null) {
                        this.formula.setFormula(oldFormula);
                        break block128;
                    }
                    this.script.setVariables(oldVar);
                    this.script.setArrays(oldArray);
                    this.script.setStatements(oldStmt);
                }
                catch (Throwable t) {
                    if (t.toString().startsWith("java.lang.ClassCastException")) {
                        LOGGER.log(Level.FINEST, "Illegal Argument: argument and its required data type doesn't match", t);
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Illegal Argument: argument and its required data type doesn't match!"));
                    } else {
                        LOGGER.log(Level.FINEST, "Syntax error", t);
                        new JMessageDialog((Dialog)this, "Syntax Error", this.formatErrorMessage(s, t.toString()));
                    }
                    if (this.formula != null) {
                        this.formula.setFormula(oldFormula);
                        break block128;
                    }
                    this.script.setVariables(oldVar);
                    this.script.setArrays(oldArray);
                    this.script.setStatements(oldStmt);
                }
            } else if (btn == this.saveAsButton) {
                String s = this.ta.getText();
                if (s.trim().equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please enter formula/script!"));
                    return;
                }
                try {
                    InputStreamReader inputStreamReader;
                    Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                    formulaVec.add(this.reportMain.report.formulas);
                    for (int i = 0; this.reportMain.report.subReports != null && i < this.reportMain.report.subReports.size(); ++i) {
                        Report rpt = this.reportMain.report.getSubReportArray()[i];
                        if (rpt == null) continue;
                        formulaVec.add(rpt.formulas);
                    }
                    this.reportMain.report.deleteUnInitializedParam();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes("UTF-8"));
                    if (this.formula != null) {
                        this.formula2 = new Formula(this.getDefaultFormulaName());
                        inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        this.formula2.setFormula(parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.getDefaultFormulaName()));
                        this.formula2.getValue(this.reportMain.report.getReportTables().elementAt(0), 0, 1, 1, 1, 1, this.reportMain.report, new ReportCell(), new Object());
                        if (!this.reportMain.report.paramsInitialized()) {
                            throw new Exception("parameter(s) not initialized");
                        }
                        this.formula2.setText(s);
                        this.formula2.getDatatype(this.reportMain.report);
                        String inputValue = (String)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter formula name"), LanguageEncoder.getText("Formula Name"), -1, null, null, this.getDefaultFormulaName());
                        if (inputValue == null) {
                            return;
                        }
                        while (this.reportMain.report.formulaExists(inputValue) || !QbUtil.isValidName(inputValue)) {
                            if (this.reportMain.report.formulaExists(inputValue)) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("already exists!"));
                            } else {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("is an invalid formula name!"));
                            }
                            if ((inputValue = (String)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter formula name"), LanguageEncoder.getText("Formula Name"), -1, null, null, this.getDefaultFormulaName())) != null) continue;
                            return;
                        }
                        this.formula2.setName(inputValue);
                        this.reportMain.report.formulas.addElement(this.formula2);
                    } else {
                        this.script2 = new Script(this.getDefaultScriptName());
                        inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewScriptParser parser = new NewScriptParser(inputStreamReader);
                        this.script2.setScript(parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), this.getDefaultScriptName(), this.reportMain.report));
                        try {
                            this.script2.testApplyScript(this.reportMain.report.getReportTables().elementAt(0), 0, 1, 1, 1, 1, this.reportMain.report, new ReportCell(), null, null);
                        }
                        catch (NullPointerException ex) {
                            LOGGER.log(Level.FINEST, "Failed to test apply script", ex);
                        }
                        if (!this.reportMain.report.paramsInitialized()) {
                            throw new Exception("parameter(s) not initialized");
                        }
                        this.script2.setText(s);
                        String inputValue = (String)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter script name"), LanguageEncoder.getText("Script Name"), -1, null, null, this.getDefaultScriptName());
                        while (this.reportMain.report.scriptExists(inputValue) || "".equals(inputValue)) {
                            if (this.reportMain.report.scriptExists(inputValue)) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("already exists!"));
                            } else {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + LanguageEncoder.getText("Script name can not be empty!"));
                            }
                            inputValue = (String)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter script name"), LanguageEncoder.getText("Script Name"), -1, null, null, this.getDefaultScriptName());
                        }
                        if (inputValue == null) {
                            return;
                        }
                        this.script2.setName(inputValue);
                        this.reportMain.report.scripts.addElement(this.script2);
                    }
                    if (this.reportMain.selectedPanel != null) {
                        this.reportMain.repaintPanel(this.reportMain.selectedPanel);
                    }
                    this.setVisible(false);
                    this.dispose();
                }
                catch (ParseException ex) {
                    if (ex.getMessage().endsWith("does not exist!")) {
                        LOGGER.log(Level.FINEST, "Parse error", ex);
                        new JMessageDialog((Dialog)this, "error", ex.getMessage());
                        break block128;
                    }
                    LOGGER.log(Level.FINEST, "Syntax error", ex);
                    new JMessageDialog((Dialog)this, "Syntax error", this.formatErrorMessage(s, ex.toString()));
                }
                catch (Throwable t) {
                    if (t.toString().startsWith("java.lang.ClassCastException")) {
                        LOGGER.log(Level.FINEST, "Illegal Argument: argument and its required data type doesn't match", t);
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Illegal Argument: argument and its required data type doesn't match!"));
                        break block128;
                    }
                    LOGGER.log(Level.FINEST, "Syntax error", t);
                    new JMessageDialog((Dialog)this, "Syntax Error", this.formatErrorMessage(s, t.toString()));
                }
            } else if (btn == this.cancelButton) {
                this.reportMain.report.formulaParameters = this.formulaParams;
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    public static String getNextFormulaName(Vector<Formula> formulas, String formulaName) {
        int i;
        int ending = 2;
        char[] chars = formulaName.toCharArray();
        for (i = chars.length - 1; i >= 0 && Character.isDigit(chars[i]); --i) {
        }
        String base = formulaName.substring(0, ++i);
        for (int j = 0; j < formulas.size(); ++j) {
            String name = formulas.elementAt(j).getName();
            if (!name.startsWith(base)) continue;
            try {
                int k = Integer.parseInt(name.substring(i));
                if (k < ending) continue;
                ending = k + 1;
                continue;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINEST, "Invalid number", e);
            }
        }
        return base + ending;
    }

    private String getDefaultFormulaName() {
        return NewEditDialog.getNextFormulaName(this.reportMain.report.formulas, this.formula.getName());
    }

    private String getDefaultScriptName() {
        int i;
        int ending = 2;
        char[] chars = this.script.getName().toCharArray();
        for (i = chars.length - 1; i >= 0 && Character.isDigit(chars[i]); --i) {
        }
        String base = this.script.getName().substring(0, ++i);
        for (int j = 0; j < this.reportMain.report.scripts.size(); ++j) {
            String name = this.reportMain.report.scripts.elementAt(j).getName();
            if (!name.startsWith(base)) continue;
            try {
                int k = Integer.parseInt(name.substring(i));
                if (k < ending) continue;
                ending = k + 1;
                continue;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINEST, "Invalid number", e);
            }
        }
        return base + ending;
    }

    private String getSelectedText() {
        if (this.tree.isSelectionEmpty()) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        if (!node.isLeaf()) {
            return null;
        }
        DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)node.getParent();
        if (tableNode.getUserObject().toString().equals("Columns")) {
            String columnName = node.getUserObject().toString();
            int idx = columnName.lastIndexOf(40);
            if ((columnName = columnName.substring(0, idx).trim()).startsWith("@")) {
                return columnName;
            }
            return "{" + columnName + "}";
        }
        if (tableNode.getUserObject().toString().startsWith("SUB")) {
            String columnName = node.getUserObject().toString();
            if (columnName.startsWith("@")) {
                return tableNode.getUserObject().toString() + "." + columnName;
            }
            int idx = columnName.lastIndexOf(40);
            columnName = columnName.substring(0, idx).trim();
            return tableNode.getUserObject().toString() + ".{" + columnName + "}";
        }
        if (tableNode.getUserObject().toString().equals("Cell Attributes")) {
            return node.getUserObject().toString();
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tableNode.getParent();
        if (parent != null && parent.getUserObject().toString().equals("Database Fields")) {
            String columnName = node.getUserObject().toString();
            int idx = columnName.lastIndexOf(40);
            columnName = columnName.substring(0, idx).trim();
            String tableName = tableNode.getUserObject().toString();
            return "{" + tableName + "." + columnName + "}";
        }
        return node.getUserObject().toString();
    }

    private String formatErrorMessage(String formulaStr, String exceptionStr) {
        try {
            StringBuffer errMsg = new StringBuffer("Syntax Error:\n");
            int lineIndex = exceptionStr.indexOf("line") + 5;
            int lineIndex2 = exceptionStr.indexOf(",", lineIndex);
            int line = Integer.parseInt(exceptionStr.substring(lineIndex, lineIndex2));
            int columnIndex = exceptionStr.indexOf("column") + 7;
            int columnIndex2 = exceptionStr.indexOf(".", columnIndex);
            int column = Integer.parseInt(exceptionStr.substring(columnIndex, columnIndex2));
            int startIndex = 0;
            int endIndex = -1;
            for (int i = 0; i < line; ++i) {
                startIndex = endIndex + 1;
                endIndex = formulaStr.indexOf("\n", startIndex);
            }
            String lineString = endIndex == -1 ? formulaStr.substring(startIndex) : formulaStr.substring(startIndex, endIndex);
            errMsg.append(lineString).append("\n");
            FontMetrics fm = this.getFontMetrics(new JLabel().getFont());
            int error = lineString.length() - 1 >= column ? column : lineString.length() - 1;
            int strlen = fm.stringWidth(lineString.substring(0, error));
            int spacelen = fm.charWidth(' ');
            int numberOfSpaces = strlen / spacelen;
            for (int i = 0; i < numberOfSpaces; ++i) {
                errMsg.append(' ');
            }
            errMsg.append("^");
            return errMsg.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to format error message", e);
            return exceptionStr;
        }
    }

    private String getStyle(int style) {
        if (style == 1) {
            return "BOLD";
        }
        if (style == 2) {
            return "ITALIC";
        }
        if (style == 0) {
            return "PLAIN";
        }
        if (style == 3) {
            return "BOLD+ITALIC";
        }
        return "PLAIN";
    }
}

