/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class NullDataHandler
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(NullDataHandler.class.getName());
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JTextField optionField;

    public NullDataHandler(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Null Data Handler ..."), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Null Data Handler ...")));
        p1.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(2, 1));
        mainPanel.add(new JLabel(LanguageEncoder.getText("You would like \"Null\" to be shown as:") + " "));
        this.optionField = new JTextField(10);
        mainPanel.add(this.optionField);
        p1.add("Center", mainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.setField();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    private void setField() {
        String str = this.reportMain.report.getNullDataOption();
        this.optionField.setText(str);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String option = " ";
            try {
                option = this.optionField.getText();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Null data message can't be empty", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please input what you would like to be shown for null data!"));
                return;
            }
            this.reportMain.report.setNullDataOption(option, false);
            FormatUtil.setNumericNULLDataValue(option);
            FormatUtil.setDateTimeNULLDataValue(option);
            FormatUtil.setBooleanNULLDataValue(option);
            FormatUtil.setStringNULLDataValue(option);
            this.reportMain.menuBar.setUndoEnabled(false);
            this.reportMain.setModified();
            this.reportMain.do_Refresh();
        }
        this.setVisible(false);
        this.dispose();
    }
}

