/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.TableOfContents;

public class NumberingFormatDialog
extends JDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    private TableOfContents toc;
    private JButton applyButton;
    private JButton closeButton;
    private JComboBox numberFormatBox;
    private JComboBox numberStyleBox;
    private JSpinner startAtBox;
    private JList levelList;

    public NumberingFormatDialog(JDialog parent, TableOfContents toc) {
        super(parent, LanguageEncoder.getText("Numbering Format"), true);
        this.toc = toc;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel setFormatPanel = new JPanel(new FlowLayout(0));
        if (this.toc.getNumberingStyle() == 0) {
            JPanel formatPanel = new JPanel(new GridLayout(2, 2));
            formatPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
            formatPanel.add(new JLabel(LanguageEncoder.getText("Number Format")));
            formatPanel.add(new JLabel(LanguageEncoder.getText("Start at")));
            this.numberFormatBox = new JComboBox<String>(TableOfContents.NUMBERFORMAT);
            formatPanel.add(this.numberFormatBox);
            this.numberFormatBox.setSelectedIndex(this.toc.getSelectedNumberFormat(0));
            SpinnerListModel listModel = new SpinnerListModel(TableOfContents.numericArray);
            this.startAtBox = new JSpinner(listModel);
            this.startAtBox.setValue(this.toc.getStartAt(0) + "");
            formatPanel.add(this.startAtBox);
            setFormatPanel.add(formatPanel);
        } else {
            JPanel levelPanel = new JPanel();
            levelPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Level")));
            String[] list = new String[this.toc.getLevels()];
            for (int i = 0; i < this.toc.getLevels(); ++i) {
                list[i] = i + 1 + "";
            }
            this.levelList = new JList<String>(list);
            this.levelList.setSelectionMode(0);
            this.levelList.setSelectedIndex(0);
            this.levelList.addListSelectionListener(this);
            JScrollPane scrollPane = new JScrollPane(this.levelList);
            levelPanel.add(scrollPane);
            JPanel formatPanel = new JPanel(new BorderLayout());
            JPanel panel1 = new JPanel(new GridLayout(2, 1));
            panel1.add(new JLabel(LanguageEncoder.getText("Number Format")));
            this.numberFormatBox = new JComboBox<String>(TableOfContents.NUMBERFORMAT);
            panel1.add(this.numberFormatBox);
            this.numberFormatBox.setSelectedIndex(this.toc.getSelectedNumberFormat(0));
            JPanel panel2 = new JPanel(new GridLayout(2, 2));
            panel2.add(new JLabel(LanguageEncoder.getText("Number Style")));
            panel2.add(new JLabel(LanguageEncoder.getText("Start at")));
            this.numberStyleBox = new JComboBox<String>(TableOfContents.STYLEFORMAT);
            panel2.add(this.numberStyleBox);
            SpinnerListModel listModel = new SpinnerListModel(TableOfContents.numericArray);
            this.startAtBox = new JSpinner(listModel);
            panel2.add(this.startAtBox);
            this.numberStyleBox.addItemListener(this);
            this.numberStyleBox.setSelectedIndex(this.toc.getSelectedNumberStyle(0));
            formatPanel.add((Component)panel1, "Center");
            formatPanel.add((Component)panel2, "South");
            formatPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
            setFormatPanel.add(levelPanel);
            setFormatPanel.add(formatPanel);
        }
        JPanel applyPanel = new JPanel(new FlowLayout(1));
        this.applyButton = new JButton(LanguageEncoder.getText("Apply"));
        applyPanel.add(this.applyButton);
        this.applyButton.addActionListener(this);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Set Format")));
        mainPanel.add((Component)setFormatPanel, "Center");
        mainPanel.add((Component)applyPanel, "South");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.closeButton = new JButton(LanguageEncoder.getText("Close"));
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.numberStyleBox) {
            if (this.numberStyleBox.getSelectedIndex() == TableOfContents.numeric) {
                this.startAtBox.setModel(new SpinnerListModel(TableOfContents.numericArray));
                this.startAtBox.setValue(this.toc.getStartAt(0) + "");
            }
            if (this.numberStyleBox.getSelectedIndex() == TableOfContents.upper_alphabet) {
                this.startAtBox.setModel(new SpinnerListModel(TableOfContents.upperAlphabet));
                this.startAtBox.setValue(this.toc.getUpperCaseAlphabet(this.toc.getStartAt(0)));
            }
            if (this.numberStyleBox.getSelectedIndex() == TableOfContents.lower_alphabet) {
                this.startAtBox.setModel(new SpinnerListModel(TableOfContents.lowerAlphabet));
                this.startAtBox.setValue(this.toc.getLowerCaseAlphabet(this.toc.getStartAt(0)));
            }
            if (this.numberStyleBox.getSelectedIndex() == TableOfContents.upper_roman) {
                this.startAtBox.setModel(new SpinnerListModel(TableOfContents.upperRoman));
                this.startAtBox.setValue(this.toc.getRomanNumber(this.toc.getStartAt(0)).toUpperCase());
            }
            if (this.numberStyleBox.getSelectedIndex() == TableOfContents.lower_roman) {
                this.startAtBox.setModel(new SpinnerListModel(TableOfContents.lowerRoman));
                this.startAtBox.setValue(this.toc.getRomanNumber(this.toc.getStartAt(0)).toLowerCase());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.levelList.getSelectedIndex();
        this.numberFormatBox.setSelectedIndex(this.toc.getSelectedNumberFormat(index));
        this.numberStyleBox.setSelectedIndex(this.toc.getSelectedNumberStyle(index));
        if (this.numberStyleBox.getSelectedIndex() == TableOfContents.numeric) {
            this.startAtBox.setValue(this.toc.getStartAt(0) + "");
        }
        if (this.numberStyleBox.getSelectedIndex() == TableOfContents.upper_alphabet) {
            this.startAtBox.setValue(this.toc.getUpperCaseAlphabet(this.toc.getStartAt(0)));
        }
        if (this.numberStyleBox.getSelectedIndex() == TableOfContents.lower_alphabet) {
            this.startAtBox.setValue(this.toc.getLowerCaseAlphabet(this.toc.getStartAt(0)));
        }
        if (this.numberStyleBox.getSelectedIndex() == TableOfContents.upper_roman) {
            this.startAtBox.setValue(this.toc.getRomanNumber(this.toc.getStartAt(0)).toUpperCase());
        }
        if (this.numberStyleBox.getSelectedIndex() == TableOfContents.lower_roman) {
            this.startAtBox.setValue(this.toc.getRomanNumber(this.toc.getStartAt(0)).toLowerCase());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.applyButton) {
            if (this.toc.getNumberingStyle() == 0) {
                this.toc.setSelectedNumberFormat(0, (short)this.numberFormatBox.getSelectedIndex());
                this.toc.setStartAt(0, Integer.valueOf((String)this.startAtBox.getValue()));
            } else {
                int index = this.levelList.getSelectedIndex();
                this.toc.setSelectedNumberFormat(index, (short)this.numberFormatBox.getSelectedIndex());
                this.toc.setSelectedNumberStyle(index, (short)this.numberStyleBox.getSelectedIndex());
                this.toc.setStartAt(index, (String)this.startAtBox.getValue());
            }
        } else if (source == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

