/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.FixedPointDialog;
import quadbase.reportdesigner.designer.LocaleFixedPointDialog;
import quadbase.reportdesigner.designer.NumericBarcodeDialog;
import quadbase.reportdesigner.designer.PanelAction;
import quadbase.reportdesigner.designer.ScientificDialog;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.NumericFormat;

public class NumericPanel
extends PanelAction
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(NumericPanel.class.getName());
    JFrame frame;
    ButtonGroup group;
    JRadioButton chkLocaleFixed;
    JRadioButton chkFixed;
    JRadioButton chkBarcode;
    JRadioButton chkScientific;
    JButton btnFormat;
    NumericFormat nf;
    LocaleNumericFormat lnf;
    BarcodeFormat bf;

    public NumericPanel(JFrame frame, IFormat format, boolean allowBarcode) {
        this.frame = frame;
        this.init(format, allowBarcode);
    }

    private void init(IFormat format, boolean allowBarcode) {
        this.group = new ButtonGroup();
        JPanel plLocaleFixed = new JPanel(new FlowLayout(0));
        this.chkLocaleFixed = new JRadioButton(LanguageEncoder.getText("Locale-specific fixed point"), true);
        plLocaleFixed.add(this.chkLocaleFixed);
        this.chkLocaleFixed.addItemListener(this);
        this.group.add(this.chkLocaleFixed);
        JPanel plFixed = new JPanel(new FlowLayout(0));
        this.chkFixed = new JRadioButton(LanguageEncoder.getText("Fixed point"), false);
        plFixed.add(this.chkFixed);
        this.chkFixed.addItemListener(this);
        this.group.add(this.chkFixed);
        this.chkBarcode = new JRadioButton(LanguageEncoder.getText("Barcode"), false);
        if (allowBarcode) {
            plFixed.add(this.chkBarcode);
            this.chkBarcode.addItemListener(this);
        }
        this.group.add(this.chkBarcode);
        JPanel plBottom = new JPanel(new BorderLayout());
        JPanel plScientific = new JPanel(new FlowLayout(0));
        this.chkScientific = new JRadioButton(LanguageEncoder.getText("Scientific"), false);
        plScientific.add(this.chkScientific);
        this.chkScientific.addItemListener(this);
        this.group.add(this.chkScientific);
        JPanel plFormat = new JPanel(new FlowLayout(2));
        this.btnFormat = new JButton(LanguageEncoder.getText("Format..."));
        this.btnFormat.addActionListener(this);
        plFormat.add(this.btnFormat);
        plBottom.add("West", plScientific);
        plBottom.add("East", plFormat);
        this.setLayout(new BorderLayout());
        this.add("North", plLocaleFixed);
        this.add("Center", plFixed);
        this.add("South", plBottom);
        if (format instanceof NumericFormat) {
            this.nf = (NumericFormat)format;
            if (this.nf.sciExp) {
                this.chkScientific.setSelected(true);
            } else {
                this.chkFixed.setSelected(true);
            }
        } else if (format instanceof LocaleNumericFormat) {
            this.lnf = (LocaleNumericFormat)format;
            this.chkLocaleFixed.setSelected(true);
        } else if (format instanceof BarcodeFormat) {
            this.bf = (BarcodeFormat)format;
            this.chkBarcode.setSelected(true);
        } else {
            LOGGER.warning("Invalid format");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.chkFixed.isSelected()) {
            if (this.nf == null) {
                this.nf = new NumericFormat();
            }
            this.nf.sciExp = false;
        } else if (this.chkScientific.isSelected()) {
            if (this.nf == null) {
                this.nf = new NumericFormat();
            }
            this.nf.sciExp = true;
        } else if (this.chkLocaleFixed.isSelected()) {
            if (this.lnf == null) {
                this.lnf = LocaleNumericFormat.getNumberInstance();
            }
        } else if (this.chkBarcode.isSelected() && this.bf == null) {
            this.bf = new BarcodeFormat(0);
        }
        this.fireEvent(this, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showFormatDialog();
        this.fireEvent(this, 0);
    }

    private void showFormatDialog() {
        if (this.chkLocaleFixed.isSelected()) {
            LocaleFixedPointDialog lfpd = new LocaleFixedPointDialog(this.frame, LanguageEncoder.getText("Locale-specific fixed point..."), this.lnf);
            lfpd.setVisible(true);
            this.lnf = lfpd.getFormat();
        } else if (this.chkFixed.isSelected()) {
            FixedPointDialog fpd = new FixedPointDialog(this.frame, LanguageEncoder.getText("Fixed Point..."), this.nf);
            fpd.setVisible(true);
            this.nf = fpd.getFormat();
        } else if (this.chkScientific.isSelected()) {
            ScientificDialog sd = new ScientificDialog(this.frame, LanguageEncoder.getText("Scientific..."), this.nf);
            sd.setVisible(true);
            this.nf = sd.getFormat();
        } else if (this.chkBarcode.isSelected()) {
            NumericBarcodeDialog nbd = new NumericBarcodeDialog(this.frame, LanguageEncoder.getText("Barcode..."), this.bf);
            nbd.setVisible(true);
            this.bf = nbd.getFormat();
        }
    }

    public IFormat getformat() {
        if (this.chkLocaleFixed.isSelected()) {
            return this.lnf;
        }
        if (this.chkFixed.isSelected() || this.chkScientific.isSelected()) {
            return this.nf;
        }
        if (this.chkBarcode.isSelected()) {
            return this.bf;
        }
        return null;
    }

    public String getSampleText() {
        if (this.getformat() != null) {
            if (this.getformat() instanceof BarcodeFormat) {
                return LanguageEncoder.getText("Barcode");
            }
            return this.getformat().format(-9.99999999999999E8);
        }
        LOGGER.finest("Format is null");
        return null;
    }
}

