/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class PageSetupDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(PageSetupDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JTextField widthField;
    JTextField heightField;
    JTextField topField;
    JTextField bottomField;
    JTextField leftField;
    JTextField rightField;
    boolean isModified = false;
    JRadioButton portraitBut;
    JRadioButton landscapeBut;
    boolean isItemListenerEnabled = true;
    int curOrientation;

    public PageSetupDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Page Setup ..."), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel orientPanel = new JPanel();
        orientPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Orientation ...")));
        orientPanel.setLayout(new GridLayout(2, 0));
        this.portraitBut = new JRadioButton(LanguageEncoder.getText("Portrait"), true);
        this.landscapeBut = new JRadioButton(LanguageEncoder.getText("Landscape"), false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.portraitBut);
        bg.add(this.landscapeBut);
        orientPanel.add(this.portraitBut);
        orientPanel.add(this.landscapeBut);
        this.portraitBut.addItemListener(this);
        this.landscapeBut.addItemListener(this);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Dimension ...")));
        p1.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        if (!this.reportMain.isCm) {
            labelPanel.add(new JLabel(LanguageEncoder.getText("Page Width (in inches)")));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Page Height (in inches)")));
        } else {
            labelPanel.add(new JLabel(LanguageEncoder.getText("Page Width (in cms)")));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Page Height (in cms)")));
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        this.widthField = new JTextField(5);
        mainPanel.add(this.widthField);
        this.heightField = new JTextField(5);
        mainPanel.add(this.heightField);
        p1.add("Center", labelPanel);
        p1.add("East", mainPanel);
        JPanel mPanel = new JPanel();
        mPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Margins ...")));
        mPanel.setLayout(new BorderLayout());
        JPanel labelPanel2 = new JPanel();
        labelPanel2.setLayout(new GridLayout(0, 1));
        if (!this.reportMain.isCm) {
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Top Margin (in inches)")));
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Bottom Margin (in inches)")));
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Left Margin (in inches)")));
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Right Margin (in inches)")));
        } else {
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Top Margin (in cms)")));
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Bottom Margin (in cms)")));
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Left Margin (in cms)")));
            labelPanel2.add(new JLabel(LanguageEncoder.getText("Right Margin (in cms)")));
        }
        JPanel mainPanel2 = new JPanel();
        mainPanel2.setLayout(new GridLayout(0, 1));
        this.topField = new JTextField(5);
        mainPanel2.add(this.topField);
        this.bottomField = new JTextField(5);
        mainPanel2.add(this.bottomField);
        this.leftField = new JTextField(5);
        mainPanel2.add(this.leftField);
        this.rightField = new JTextField(5);
        mainPanel2.add(this.rightField);
        mPanel.add("Center", labelPanel2);
        mPanel.add("East", mainPanel2);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.setField();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BorderLayout());
        cPanel.add("North", orientPanel);
        cPanel.add("Center", p1);
        contentPane.add("North", cPanel);
        contentPane.add("Center", mPanel);
        contentPane.add("South", p2);
        this.pack();
    }

    private void setField() {
        if (!this.reportMain.isCm) {
            this.widthField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getPageWidth() * 100.0)) + "");
            this.heightField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getPageHeight() * 100.0)) + "");
            this.topField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getTopMargin() * 100.0)) + "");
            this.bottomField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getBottomMargin() * 100.0)) + "");
            this.leftField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getLeftMargin() * 100.0)) + "");
            this.rightField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getRightMargin() * 100.0)) + "");
        } else {
            this.widthField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getPageWidth() * 2.54 * 100.0)) + "");
            this.heightField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getPageHeight() * 2.54 * 100.0)) + "");
            this.topField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getTopMargin() * 2.54 * 100.0)) + "");
            this.bottomField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getBottomMargin() * 2.54 * 100.0)) + "");
            this.leftField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getLeftMargin() * 2.54 * 100.0)) + "");
            this.rightField.setText(this.setFractionDigits((int)Math.round(this.reportMain.report.getRightMargin() * 2.54 * 100.0)) + "");
        }
        this.curOrientation = this.reportMain.report.getOrientation();
        this.isItemListenerEnabled = false;
        this.landscapeBut.setSelected(this.curOrientation == 1);
        this.isItemListenerEnabled = true;
    }

    boolean isModified() {
        return this.isModified;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isItemListenerEnabled) {
            return;
        }
        int selectedOrientation = this.getOrientation();
        if (selectedOrientation != this.curOrientation) {
            String tmp = this.widthField.getText();
            this.widthField.setText(this.heightField.getText());
            this.heightField.setText(tmp);
            this.curOrientation = selectedOrientation;
        }
    }

    private int getOrientation() {
        if (this.landscapeBut.isSelected()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            double r;
            double l;
            double b;
            double t;
            double h;
            double w;
            try {
                if (!this.reportMain.isCm) {
                    w = Double.parseDouble(this.widthField.getText());
                    h = Double.parseDouble(this.heightField.getText());
                    t = Double.parseDouble(this.topField.getText());
                    b = Double.parseDouble(this.bottomField.getText());
                    l = Double.parseDouble(this.leftField.getText());
                    r = Double.parseDouble(this.rightField.getText());
                } else {
                    w = Double.parseDouble(this.widthField.getText()) / 2.54;
                    h = Double.parseDouble(this.heightField.getText()) / 2.54;
                    t = Double.parseDouble(this.topField.getText()) / 2.54;
                    b = Double.parseDouble(this.bottomField.getText()) / 2.54;
                    l = Double.parseDouble(this.leftField.getText()) / 2.54;
                    r = Double.parseDouble(this.rightField.getText()) / 2.54;
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Dimensions and margin: Invalid number", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Dimension & Margin : Numeric Only!"));
                return;
            }
            if (w <= 0.0 || h <= 0.0 || t < 0.0 || b < 0.0 || l < 0.0 || r < 0.0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Dimension & Margin : Number must be greater than 0!"));
                return;
            }
            if (w > 100.0 || h > 100.0 || t > 100.0 || b > 100.0 || l > 100.0 || r > 100.0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Dimension & Margin : Number must be less than 100 inches/ 254cm!"));
                return;
            }
            if (t + b > h) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Dimension & Margin : Page height must be greater than top margin and bottom margin together!"));
                return;
            }
            if (r + l > w) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Dimension & Margin : Page width must be greater than left margin and right margin together!"));
                return;
            }
            this.reportMain.report.setOrientation(this.curOrientation);
            this.reportMain.report.setPageWidth(w);
            this.reportMain.report.setPageHeight(h);
            this.reportMain.report.setTopMargin(t);
            this.reportMain.report.setBottomMargin(b);
            this.reportMain.report.setLeftMargin(l);
            this.reportMain.report.setRightMargin(r);
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    private String setFractionDigits(int v) {
        String t = Integer.toString(v);
        if (t.endsWith("0")) {
            double d = (double)v / 100.0;
            t = Double.toString(d).concat("0");
            return t;
        }
        double d = (double)v / 100.0;
        t = Double.toString(d);
        return t;
    }
}

