/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.GroupDetailDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public class ParameterShareDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ParameterShareDialog.class.getName());
    public Report mainReport;
    public Report report;
    public int reportIndex;
    private JComboBox[] reportChoices = null;
    private JComboBox[] parameterChoices = null;
    private JCheckBox[] shareParam = null;
    private JButton[] detailButton = null;
    private JButton okButton;
    private JButton cancelButton;
    private boolean modified = false;
    private Vector<Parameter> queryParams;
    private Vector<Parameter> formulaParams;
    private int numberOfQueryParams;
    private int numberOfFormulaParams;
    public ReportMain reportMain;

    public ParameterShareDialog(ReportMain reportMain, Report mainReport, Report report, int reportIndex) throws Exception {
        super((Frame)reportMain, true);
        this.reportMain = reportMain;
        this.mainReport = mainReport;
        this.report = report;
        this.reportIndex = reportIndex;
        try {
            this.init();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to initialize ParamShareDialog", ex);
            throw ex;
        }
    }

    private void init() throws Exception {
        Parameter sharedParam;
        int j;
        int i;
        Parameter param;
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Sub-Report Parameter Sharing"));
        this.setDefaultCloseOperation(2);
        this.queryParams = this.report.getQueryParameters();
        this.formulaParams = this.report.getFormulaParameters();
        this.numberOfQueryParams = this.queryParams.size();
        this.numberOfFormulaParams = this.formulaParams.size();
        JPanel mainPanel = new JPanel(new GridLayout(this.numberOfQueryParams + this.numberOfFormulaParams + 1, 4, 5, 5));
        JScrollPane mainPanelScroller = new JScrollPane(mainPanel);
        mainPanelScroller.setBorder(BorderFactory.createEmptyBorder());
        mainPanel.add(new Label(LanguageEncoder.getText("share parameter")));
        mainPanel.add(new Label(LanguageEncoder.getText("report")));
        mainPanel.add(new Label(LanguageEncoder.getText("parameter")));
        mainPanel.add(new Label(LanguageEncoder.getText("view")));
        Vector<String> vec = new Vector<String>();
        vec.addElement("Main_Report");
        for (int i2 = 1; this.mainReport.subReports != null && i2 <= this.mainReport.subReports.size(); ++i2) {
            if (i2 == this.reportIndex) continue;
            vec.addElement("Sub_Report_" + i2);
        }
        Vector<String> vecQuery = new Vector<String>();
        Vector<Parameter> params = this.mainReport.getQueryParameters();
        for (int j2 = 0; j2 < params.size(); ++j2) {
            Parameter param2 = params.elementAt(j2);
            vecQuery.addElement(param2.getName());
        }
        Vector<String> vecForm = new Vector<String>();
        params = this.mainReport.getFormulaParameters();
        for (int j3 = 0; j3 < params.size(); ++j3) {
            param = params.elementAt(j3);
            vecForm.addElement(param.getName());
        }
        this.shareParam = new JCheckBox[this.numberOfQueryParams + this.numberOfFormulaParams];
        this.reportChoices = new JComboBox[this.numberOfQueryParams + this.numberOfFormulaParams];
        this.parameterChoices = new JComboBox[this.numberOfQueryParams + this.numberOfFormulaParams];
        this.detailButton = new JButton[this.numberOfQueryParams + this.numberOfFormulaParams];
        if (this.numberOfQueryParams == 0 && this.numberOfFormulaParams == 0) {
            throw new IllegalArgumentException(LanguageEncoder.getText("The sub-report doesn't have any parameter to share!"));
        }
        for (i = 0; i < this.numberOfQueryParams; ++i) {
            param = this.queryParams.elementAt(i);
            this.shareParam[i] = new JCheckBox(param.getName());
            this.shareParam[i].addItemListener(this);
            this.shareParam[i].setSelected(param.isShared());
            this.reportChoices[i] = new JComboBox((Vector)vec.clone());
            this.reportChoices[i].addActionListener(this);
            this.parameterChoices[i] = new JComboBox((Vector)vecQuery.clone());
            this.parameterChoices[i].addActionListener(this);
            this.detailButton[i] = new JButton("Group Detail");
            this.detailButton[i].addActionListener(this);
            this.enableChoices(i, param.isShared());
            if (param.isShareReferenced() && !this.verifyShareReference(param, true)) {
                param.setReferenceDegree(0);
            }
            if (param.isShareReferenced() && this.verifyShareReference(param, true)) {
                this.shareParam[i].setSelected(true);
                this.shareParam[i].setEnabled(false);
                this.reportChoices[i].removeAllItems();
                this.reportChoices[i].setEnabled(false);
                this.parameterChoices[i].removeAllItems();
                this.parameterChoices[i].setEnabled(false);
                continue;
            }
            if (!param.isShared()) continue;
            params = new Vector();
            LOGGER.finest("param=" + param);
            LOGGER.finest("param.name=" + param.getName());
            LOGGER.finest("param.getSharedReportName()=" + param.getSharedReportName());
            if (param.getSharedReportName() != null) {
                if ("MAIN_REPORT".equals(param.getSharedReportName()) || param.getSharedReportName().indexOf("_sub") < 0) {
                    LOGGER.finest("share with main report");
                    this.reportChoices[i].setSelectedIndex(0);
                    params = this.mainReport.getQueryParameters();
                } else {
                    for (j = 0; j < this.mainReport.subReports.size(); ++j) {
                        LOGGER.finest("sub report id" + this.mainReport.subReports.elementAt(j).getParamShareReportID());
                        if (!this.mainReport.subReports.elementAt(j).getParamShareReportID().equals(param.getSharedReportName())) continue;
                        params = this.mainReport.getSubReportArray()[j].getQueryParameters();
                        if (j < this.reportIndex) {
                            ++j;
                        }
                        LOGGER.finest("share with sub report " + j);
                        this.reportChoices[i].setSelectedIndex(j);
                        break;
                    }
                }
            }
            this.parameterChoices[i].removeAllItems();
            LOGGER.finest("params.size()=" + params.size());
            for (j = 0; j < params.size(); ++j) {
                sharedParam = params.elementAt(j);
                this.parameterChoices[i].addItem(sharedParam.getName());
            }
            this.parameterChoices[i].setSelectedItem(param.getSharedParamName());
        }
        for (i = 0; i < this.numberOfFormulaParams; ++i) {
            param = this.formulaParams.elementAt(i);
            this.shareParam[i + this.numberOfQueryParams] = new JCheckBox(param.getName());
            this.shareParam[i + this.numberOfQueryParams].addItemListener(this);
            this.shareParam[i + this.numberOfQueryParams].setSelected(param.isShared());
            this.reportChoices[i + this.numberOfQueryParams] = new JComboBox(vec);
            this.reportChoices[i + this.numberOfQueryParams].addActionListener(this);
            this.parameterChoices[i + this.numberOfQueryParams] = new JComboBox(vecForm);
            this.parameterChoices[i + this.numberOfQueryParams].addActionListener(this);
            this.detailButton[i + this.numberOfQueryParams] = new JButton("Group Detail");
            this.detailButton[i + this.numberOfQueryParams].addActionListener(this);
            this.detailButton[i + this.numberOfQueryParams].setEnabled(param.isShareReferenced() || param.isShared());
            if (param.isShareReferenced() && this.verifyShareReference(param, false)) {
                this.shareParam[i + this.numberOfQueryParams].setSelected(true);
                this.shareParam[i + this.numberOfQueryParams].setEnabled(false);
                this.reportChoices[i + this.numberOfQueryParams].setEnabled(false);
                this.parameterChoices[i + this.numberOfQueryParams].setEnabled(false);
                continue;
            }
            if (!param.isShared()) continue;
            params = new Vector();
            if ("MAIN_REPORT".equals(param.getSharedReportName()) || param.getSharedReportName().indexOf("_sub") < 0) {
                this.reportChoices[i + this.numberOfQueryParams].setSelectedIndex(0);
                params = this.mainReport.getFormulaParameters();
            } else {
                for (j = 0; j < this.mainReport.subReports.size(); ++j) {
                    if (!this.mainReport.subReports.elementAt(j).getParamShareReportID().equals(param.getSharedReportName())) continue;
                    params = this.mainReport.getSubReportArray()[j].getFormulaParameters();
                    if (j < this.reportIndex) {
                        ++j;
                    }
                    this.reportChoices[i + this.numberOfQueryParams].setSelectedIndex(j);
                    break;
                }
            }
            this.parameterChoices[i + this.numberOfQueryParams].removeAllItems();
            for (j = 0; j < params.size(); ++j) {
                sharedParam = params.elementAt(j);
                this.parameterChoices[i + this.numberOfQueryParams].addItem(sharedParam.getName());
            }
            this.parameterChoices[i + this.numberOfQueryParams].setSelectedItem(param.getSharedParamName());
        }
        for (i = 0; i < this.numberOfQueryParams + this.numberOfFormulaParams; ++i) {
            mainPanel.add(this.shareParam[i]);
            mainPanel.add(this.reportChoices[i]);
            mainPanel.add(this.parameterChoices[i]);
            mainPanel.add(this.detailButton[i]);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        JPanel borderMainPanel = new JPanel(new BorderLayout());
        borderMainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Parameter Sharing")));
        borderMainPanel.add("Center", mainPanelScroller);
        contentPanel.add((Component)borderMainPanel, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        Dimension screensize = this.getToolkit().getScreenSize();
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
    }

    private void enableChoices(int i, boolean enable) {
        if (this.reportChoices[i] != null) {
            this.reportChoices[i].setEnabled(enable);
        }
        if (this.parameterChoices[i] != null) {
            this.parameterChoices[i].setEnabled(enable);
        }
        if (this.detailButton[i] != null) {
            if (i < this.queryParams.size() && this.queryParams.elementAt(i) != null) {
                Parameter param = this.queryParams.elementAt(i);
                if (param.isShared() || param.isShareReferenced()) {
                    this.detailButton[i].setEnabled(enable);
                } else {
                    this.detailButton[i].setEnabled(false);
                }
            } else {
                this.detailButton[i].setEnabled(false);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        for (int i = 0; i < this.numberOfQueryParams + this.numberOfFormulaParams; ++i) {
            if (e.getItem() != this.shareParam[i]) continue;
            this.enableChoices(i, this.shareParam[i].isSelected());
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        for (int i = 0; i < this.numberOfQueryParams + this.numberOfFormulaParams; ++i) {
            GroupDetailDialog groupDetailDialog;
            Parameter param;
            if (object == this.reportChoices[i]) {
                Parameter param2;
                Vector<Object> params;
                if (i < this.numberOfQueryParams) {
                    params = new Vector();
                    this.parameterChoices[i].removeAllItems();
                    int index = this.reportChoices[i].getSelectedIndex();
                    if (index < 0) continue;
                    if (index == 0) {
                        params = this.mainReport.getQueryParameters();
                    } else {
                        if (index < this.reportIndex) {
                            --index;
                        }
                        params = this.mainReport.getSubReportArray()[index].getQueryParameters();
                    }
                    for (int j = 0; j < params.size(); ++j) {
                        param2 = (Parameter)params.elementAt(j);
                        this.parameterChoices[i].addItem(param2.getName());
                    }
                } else {
                    params = new Vector();
                    this.parameterChoices[i].removeAllItems();
                    int index = this.reportChoices[i].getSelectedIndex();
                    if (index < 0) continue;
                    if (index == 0) {
                        params = this.mainReport.getFormulaParameters();
                    } else {
                        if (index < this.reportIndex) {
                            --index;
                        }
                        params = this.mainReport.getSubReportArray()[index].getFormulaParameters();
                    }
                    for (int j = 0; j < params.size(); ++j) {
                        param2 = (Parameter)params.elementAt(j);
                        this.parameterChoices[i].addItem(param2.getName());
                    }
                }
            }
            if (object == this.okButton) {
                Parameter sharedParam_old;
                Report sharedReport_old;
                SubReportObject sub;
                int index;
                Parameter sharedParam;
                Report sharedReport;
                String sharedParamName_old;
                String sharedReportName_old;
                boolean shared_old;
                Parameter param3;
                if (i < this.numberOfQueryParams) {
                    param3 = this.queryParams.elementAt(i);
                    shared_old = param3.isShared();
                    sharedReportName_old = param3.getSharedReportName();
                    sharedParamName_old = param3.getSharedParamName();
                    sharedReport = null;
                    sharedParam = null;
                    param3.setShared(this.shareParam[i].isSelected() && this.shareParam[i].isEnabled());
                    index = this.reportChoices[i].getSelectedIndex();
                    if (param3.isShared()) {
                        this.mainReport.setupSubReportParamMap();
                        if (this.mainReport.subReports != null && this.mainReport.subReports.get(this.reportIndex - 1).getParameterMap() != null && this.mainReport.subReports.get(this.reportIndex - 1).getParameterMap()[i] != null) {
                            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Parameter") + " " + param3.getName() + " " + LanguageEncoder.getText("is already mapped to a main report column, sharing is not available."));
                            param3.setShared(false);
                            this.shareParam[i].setSelected(false);
                            return;
                        }
                        if (index == 0) {
                            sharedReport = this.mainReport;
                            if (this.mainReport.getQueryParameters() == null || this.mainReport.getQueryParameters().size() == 0) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot share, the report doesn't have any query parameter"));
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            sharedParam = this.mainReport.getQueryParameters().elementAt(this.parameterChoices[i].getSelectedIndex());
                            if (sharedParam.getSQLType() != param3.getSQLType()) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Cannot share, the data type '" + DataType.getTypeName(sharedParam.getSQLType()) + "' doesn't match '" + DataType.getTypeName(param3.getSQLType()) + "'!");
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            if (sharedParam.isMultiValueParam() && !param3.isMultiValueParam() || !sharedParam.isMultiValueParam() && param3.isMultiValueParam()) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot share single value parameter with multi-value parameter!"));
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            if (sharedParam.isShared() && !sharedParam.isShareReferenced()) {
                                param3.setSharedReportName(sharedParam.getSharedReportName());
                                param3.setSharedParamName(sharedParam.getSharedParamName());
                                sharedReport = this.getReportByName(this.mainReport, sharedParam.getSharedReportName());
                                sharedParam = this.getQueryParamByName(sharedReport, sharedParam.getSharedParamName());
                            } else {
                                param3.setSharedReportName("MAIN_REPORT");
                                param3.setSharedParamName(sharedParam.getName());
                            }
                        } else {
                            if (index < this.reportIndex) {
                                --index;
                            }
                            sub = this.mainReport.subReports.elementAt(index);
                            sharedReport = this.mainReport.getSubReportArray()[index];
                            if (sharedReport.getQueryParameters() == null || sharedReport.getQueryParameters().size() == 0) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot share, the report doesn't have any query parameter!"));
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            sharedParam = sharedReport.getQueryParameters().elementAt(this.parameterChoices[i].getSelectedIndex());
                            if (Parameter.mapToOperandType(sharedParam.getSQLType()) != Parameter.mapToOperandType(param3.getSQLType())) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot share, the data type doesn't match!"));
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            if (sharedParam.isMultiValueParam() && !param3.isMultiValueParam() || !sharedParam.isMultiValueParam() && param3.isMultiValueParam()) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Cannot share, the data type '" + DataType.getTypeName(sharedParam.getSQLType()) + "' doesn't match '" + DataType.getTypeName(param3.getSQLType()) + "'!");
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            if (sharedParam.isShared() && !sharedParam.isShareReferenced()) {
                                param3.setSharedReportName(sharedParam.getSharedReportName());
                                param3.setSharedParamName(sharedParam.getSharedParamName());
                                sharedReport = this.getReportByName(this.mainReport, sharedParam.getSharedReportName());
                                sharedParam = this.getQueryParamByName(sharedReport, sharedParam.getSharedParamName());
                            } else {
                                param3.setSharedReportName(sub.getParamShareReportID());
                                param3.setSharedParamName(sharedParam.getName());
                            }
                        }
                        if (!shared_old) {
                            sharedParam.incReferenceDegree();
                            sharedReport.modified = true;
                        } else {
                            sharedReport_old = this.getReportByName(this.mainReport, sharedReportName_old);
                            sharedParam_old = this.getQueryParamByName(sharedReport_old, sharedParamName_old);
                            sharedParam.incReferenceDegree();
                            sharedReport.modified = true;
                            sharedParam_old.decReferenceDegree();
                            sharedReport_old.modified = true;
                        }
                        this.closeDialog();
                    } else if (shared_old) {
                        sharedReport_old = this.getReportByName(this.mainReport, sharedReportName_old);
                        if (sharedReport_old != null && (sharedParam_old = this.getQueryParamByName(sharedReport_old, sharedParamName_old)) != null) {
                            sharedParam_old.decReferenceDegree();
                            sharedReport_old.modified = true;
                            this.closeDialog();
                        }
                        param3.setSharedParamName(null);
                        param3.setSharedReportName(null);
                    }
                } else {
                    param3 = this.formulaParams.elementAt(i - this.numberOfQueryParams);
                    shared_old = param3.isShared();
                    sharedReportName_old = param3.getSharedReportName();
                    sharedParamName_old = param3.getSharedParamName();
                    sharedReport = null;
                    sharedParam = null;
                    param3.setShared(this.shareParam[i].isSelected());
                    index = this.reportChoices[i].getSelectedIndex();
                    if (param3.isShared()) {
                        if (index == 0) {
                            sharedReport = this.mainReport;
                            if (this.mainReport.getFormulaParameters() == null || this.mainReport.getFormulaParameters().size() == 0) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot share, the report doesn't have any formula parameter!"));
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            sharedParam = this.mainReport.getFormulaParameters().elementAt(this.parameterChoices[i].getSelectedIndex());
                            if (sharedParam.getSQLType() != param3.getSQLType()) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Cannot share, the data type '" + DataType.getTypeName(sharedParam.getSQLType()) + "' doesn't match '" + DataType.getTypeName(param3.getSQLType()) + "'!");
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            if (sharedParam.isShared() && !sharedParam.isShareReferenced()) {
                                param3.setSharedReportName(sharedParam.getSharedReportName());
                                param3.setSharedParamName(sharedParam.getSharedParamName());
                                sharedReport = this.getReportByName(this.mainReport, sharedParam.getSharedReportName());
                                sharedParam = this.getFormulaParamByName(sharedReport, sharedParam.getSharedParamName());
                            } else {
                                param3.setSharedReportName("MAIN_REPORT");
                                param3.setSharedParamName(sharedParam.getName());
                            }
                        } else {
                            if (index < this.reportIndex) {
                                --index;
                            }
                            sub = this.mainReport.subReports.elementAt(index);
                            sharedReport = this.mainReport.getSubReportArray()[index];
                            if (sharedReport.getFormulaParameters() == null || sharedReport.getFormulaParameters().size() == 0) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot share, the report doesn't have any formula parameter"));
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            sharedParam = sharedReport.getFormulaParameters().elementAt(this.parameterChoices[i].getSelectedIndex());
                            if (sharedParam.getSQLType() != param3.getSQLType()) {
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Cannot share, the data type '" + DataType.getTypeName(sharedParam.getSQLType()) + "' doesn't match '" + DataType.getTypeName(param3.getSQLType()) + "'!");
                                param3.setShared(false);
                                this.shareParam[i].setSelected(false);
                                return;
                            }
                            if (sharedParam.isShared() && !sharedParam.isShareReferenced()) {
                                param3.setSharedReportName(sharedParam.getSharedReportName());
                                param3.setSharedParamName(sharedParam.getSharedParamName());
                                sharedReport = this.getReportByName(this.mainReport, sharedParam.getSharedReportName());
                                sharedParam = this.getFormulaParamByName(sharedReport, sharedParam.getSharedParamName());
                            } else {
                                param3.setSharedReportName(sub.getParamShareReportID());
                                param3.setSharedParamName(sharedParam.getName());
                            }
                        }
                        if (!shared_old) {
                            sharedParam.incReferenceDegree();
                            sharedReport.modified = true;
                        } else {
                            sharedReport_old = this.getReportByName(this.mainReport, sharedReportName_old);
                            sharedParam_old = this.getFormulaParamByName(sharedReport_old, sharedParamName_old);
                            sharedParam.incReferenceDegree();
                            sharedReport.modified = true;
                            sharedParam_old.decReferenceDegree();
                            sharedReport_old.modified = true;
                        }
                        this.closeDialog();
                    } else if (shared_old && (sharedReport_old = this.getReportByName(this.mainReport, sharedReportName_old)) != null && (sharedParam_old = this.getFormulaParamByName(sharedReport_old, sharedParamName_old)) != null) {
                        sharedParam_old.decReferenceDegree();
                        sharedReport_old.modified = true;
                        this.closeDialog();
                    }
                }
                this.modified = true;
                this.report.modified = true;
                this.closeDialog();
                continue;
            }
            if (object != this.detailButton[i]) continue;
            if (i < this.numberOfQueryParams) {
                param = this.report.getQueryParameters().elementAt(i);
                groupDetailDialog = this.createGroupDetailDialog(param, true);
            } else {
                param = this.report.getFormulaParameters().elementAt(i - this.numberOfQueryParams);
                groupDetailDialog = this.createGroupDetailDialog(param, false);
            }
            if (groupDetailDialog == null) continue;
            groupDetailDialog.setVisible(true);
        }
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    private Report getReportByName(Report report, String reportName) {
        if (reportName == null) {
            return null;
        }
        if (reportName.equals("MAIN_REPORT") || reportName.indexOf("_sub") < 0) {
            return report;
        }
        for (int i = 0; i < report.subReports.size(); ++i) {
            if (!report.subReports.elementAt(i).getParamShareReportID().equals(reportName)) continue;
            return report.getSubReportArray()[i];
        }
        return null;
    }

    private Parameter getQueryParamByName(Report report, String paramName) {
        for (int i = 0; i < report.getQueryParameters().size(); ++i) {
            if (!report.getQueryParameters().elementAt(i).getName().equals(paramName)) continue;
            return report.getQueryParameters().elementAt(i);
        }
        return null;
    }

    private Parameter getFormulaParamByName(Report report, String paramName) {
        for (int i = 0; i < report.getFormulaParameters().size(); ++i) {
            if (!report.getFormulaParameters().elementAt(i).getName().equals(paramName)) continue;
            return report.getFormulaParameters().elementAt(i);
        }
        return null;
    }

    private String getReportName() {
        if (this.reportIndex == 0) {
            return "MAIN_REPORT";
        }
        return this.mainReport.subReports.elementAt(this.reportIndex - 1).getParamShareReportID();
    }

    private GroupDetailDialog createGroupDetailDialog(Parameter param, boolean queryParam) {
        String reportName = this.getReportName();
        if (param.isShared()) {
            if (param.getSharedReportName() == null || param.getSharedParamName() == null) {
                return null;
            }
            return new GroupDetailDialog(this, param.getSharedReportName(), param.getSharedParamName(), queryParam, 2);
        }
        if (param.isShareReferenced()) {
            return new GroupDetailDialog(this, reportName, param.getName(), true, 2);
        }
        return null;
    }

    private boolean verifyShareReference(Parameter param, boolean queryParam) {
        GroupDetailDialog groupDetailDialog = this.createGroupDetailDialog(param, queryParam);
        int count = groupDetailDialog.getParamsInGroupCount();
        return count > 1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        int maxWidth = 600;
        int maxHeight = 250;
        if (dim.width != maxWidth) {
            dim.width = maxWidth;
        }
        if (dim.height != maxHeight) {
            dim.height = maxHeight;
        }
        return dim;
    }
}

