/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Parameter;

public class ParameterValueDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JComboBox nameList;
    String name;
    String formula;
    int sqlType;
    ReportTable tbl;
    boolean isModified = false;
    int queryParamCt;

    public ParameterValueDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Insert"), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Insert Parameter Value")));
        p1.setLayout(new FlowLayout(0));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Parameter")));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(0, 1));
        this.nameList = new JComboBox();
        Vector<Parameter> queryParameters = this.reportMain.report.getQueryParameters();
        this.queryParamCt = queryParameters.size();
        for (int i = 0; i < queryParameters.size(); ++i) {
            this.nameList.addItem(":" + queryParameters.elementAt(i).getName());
        }
        Vector<Parameter> formulaParameters = this.reportMain.report.getFormulaParameters();
        for (int i = 0; i < formulaParameters.size(); ++i) {
            this.nameList.addItem("?" + formulaParameters.elementAt(i).getName());
        }
        mainPanel.add(this.nameList);
        p1.add(labelPanel);
        p1.add(mainPanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFormula() {
        return this.formula;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            int index = this.nameList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            if (index < this.queryParamCt) {
                this.name = ((String)this.nameList.getSelectedItem()).substring(1);
                this.formula = (String)this.nameList.getSelectedItem();
                this.sqlType = this.reportMain.report.getQueryParameters().elementAt(index).getSQLType();
            } else {
                this.name = ((String)this.nameList.getSelectedItem()).substring(1);
                this.formula = (String)this.nameList.getSelectedItem();
                this.sqlType = this.reportMain.report.getFormulaParameters().elementAt(index - this.queryParamCt).getSQLType();
            }
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

