/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.CrossTabReportSection;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.MasterSectionPanel;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.util.ColInfo;

class PopupMenuForReportElement
extends JPopupMenu
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(PopupMenuForReportElement.class.getName());
    private static final String AUTO_RESIZE_WIDTH = "Auto Resize Width";
    protected ReportMain reportMain;
    protected ReportElement reportElement;
    protected boolean isReady = false;
    protected JPanel parent;
    protected JCheckBoxMenuItem repeatOnEveryPage;
    protected JCheckBoxMenuItem printOnNewPage;
    protected JCheckBoxMenuItem resizeCells;
    protected JCheckBoxMenuItem resetPageNumber;
    protected JCheckBoxMenuItem newExcelSheet;
    protected JCheckBoxMenuItem skipFirstValue;
    protected JCheckBoxMenuItem fitGroupOnPage;
    protected JCheckBoxMenuItem skipFirstValueForFitGroup;
    protected JCheckBoxMenuItem skipFirstGroupValue;
    protected JCheckBoxMenuItem lockPosition;
    private JCheckBoxMenuItem wordWrap;
    private JCheckBoxMenuItem resizeToFitContent;
    private JCheckBoxMenuItem autoResizeWidth;
    protected JCheckBoxMenuItem setSectionStyleMenu;
    protected boolean addPasteOp = true;
    private int clickX = -1;
    private int clickY = -1;
    boolean editMasterSection = false;

    public PopupMenuForReportElement(ReportMain reportMain) {
        this.reportMain = reportMain;
    }

    public PopupMenuForReportElement(ReportMain reportMain, JPanel parent) {
        this.parent = parent;
        this.reportMain = reportMain;
    }

    public void addMenu(ReportElement elt, JPanel parent) {
        this.parent = parent;
        this.addMenu(elt);
    }

    public void addInvisibledMenu(ReportElement elt, JPanel parent) {
        this.parent = parent;
        this.reportElement = elt;
        this.isReady = false;
        this.removeAll();
        this.add(this.newMenuItem(LanguageEncoder.getText("Visible"), "Visible"));
        this.isReady = true;
    }

    public void addMenu(ReportElement elt) {
        this.reportElement = elt;
        this.isReady = false;
        this.removeAll();
        if (this.reportElement instanceof ReportSection) {
            if ("Master Section".equals(this.reportElement.getText())) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
                this.addSeparator();
                this.addBackgroundMenu();
                this.addBorderMenu();
            } else {
                this.addBackgroundMenu();
                this.add(this.newMenuItem(LanguageEncoder.getText("Section Height"), "Section Height"));
                if (this.addPasteOp) {
                    this.addSeparator();
                    this.addPasteOption();
                }
                if (this.isInsertable()) {
                    this.addSeparator();
                    this.add(this.newMenuItem(LanguageEncoder.getText("Insert Section"), "Insert Section"));
                    if (this.isSubSection()) {
                        this.add(this.newMenuItem(LanguageEncoder.getText("Remove Section"), "Remove Section"));
                    }
                    this.addSeparator();
                    if (this.isTableSection()) {
                        if (this.isHeaderSection()) {
                            this.addRepeatOnEveryPageMenu();
                        }
                        if (this.isGroupHeaderSection()) {
                            this.addResetPageNumberMenu();
                            this.addNewExcelSheetMenu();
                        }
                        if (this.isHeaderSection()) {
                            this.addFitGroupOnPageMenu();
                        }
                        this.addPrintOnNewPageMenu();
                        this.addSkipFirstValueMenu();
                        if (this.isGroupHeaderSection()) {
                            this.addSkipFirstGroupValueMenu();
                        }
                    } else if (this.reportElement == this.reportMain.report.getReportFooter() || this.isSubSection()) {
                        this.addPrintOnNewPageMenu();
                        this.addNewExcelSheetMenu();
                    }
                }
            }
            this.resizeCells = new JCheckBoxMenuItem(LanguageEncoder.getText("Resize Cells Proportionally"));
            this.resizeCells.setActionCommand("Resize Cells Proportionally");
            this.resizeCells.setSelected(((ReportSection)this.reportElement).isResizeToFitContent());
            this.resizeCells.addItemListener(this);
            this.add(this.resizeCells);
            this.addSeparator();
            if (!this.editMasterSection || !"Master Section".equals(this.reportElement.getText())) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Invisible"), "Invisible"));
                this.addSeparator();
            }
            this.add(this.newMenuItem(LanguageEncoder.getText("HTML Border"), "HTML Border"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof ReportTable) {
            this.addBackgroundMenu();
            this.add(this.newMenuItem(LanguageEncoder.getText("Section Height"), "Section Height"));
            this.addSeparator();
            this.resizeCells = new JCheckBoxMenuItem(LanguageEncoder.getText("Resize Cells Proportionally"));
            this.resizeCells.setActionCommand("Resize Cells Proportionally");
            this.resizeCells.setSelected(((ReportTable)this.reportElement).isResizeToFitContent());
            this.resizeCells.addItemListener(this);
            this.add(this.resizeCells);
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Print On New Page"), "Print On New Page"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Invisible"), "Invisible"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("HTML Border"), "HTML Border"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof ColumnWrap) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Column Wrap"), "Column Wrap"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof GuideLine) {
            if (((GuideLine)this.reportElement).isVertical()) {
                this.addVertSnapMenu();
            } else {
                this.addHorzSnapMenu();
            }
        } else if (this.reportElement instanceof ReportLine) {
            this.addLockPositionMenu();
            this.addLineThicknessMenu();
            this.addLineStyleMenu();
            this.addSeparator();
            this.addCutCopy();
            this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Bounds"), "Set Bounds"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
            this.addSeparator();
            this.addCellAppearanceMenu();
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof ReportGrid) {
            this.addLockPositionMenu();
            this.addBorderMenu();
            this.addBackgroundMenu();
            this.addSeparator();
            this.addCutCopy();
            this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Bounds"), "Set Bounds"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
            this.addSeparator();
            this.addBorderStyleMenu();
            this.addCellAppearanceMenu();
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof ReportImage) {
            this.addLockPositionMenu();
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit Attributes"), "Edit Attributes"));
            if (this.reportElement instanceof ReportChartObject) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Export Format"), "Export Format"));
            }
            this.addSeparator();
            this.addCutCopy();
            this.add(this.newMenuItem(LanguageEncoder.getText("HyperLink"), "HyperLink"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
            if (!this.reportMain.isSecureMode()) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Security..."), "Security"));
            }
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof SubReportObject) {
            this.addLockPositionMenu();
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
            this.addSeparator();
            this.addCutCopy();
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Bounds"), "Set Bounds"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
            this.addResizeToFitContentMenu();
            if (this.isPageHeaderFooterSection()) {
                this.resizeToFitContent.setEnabled(false);
            }
            this.addAutoResizeWidthContentMenu();
            this.addSeparator();
            if (!this.reportMain.isSecureMode()) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Security..."), "Security"));
            }
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof ReportRTFObject) {
            this.addLockPositionMenu();
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit Attributes"), "Edit Attributes"));
            this.addBackgroundMenu();
            this.addSeparator();
            this.addCutCopy();
            this.addResizeToFitContentMenu();
            if (this.isPageHeaderFooterSection()) {
                this.resizeToFitContent.setEnabled(false);
            }
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
            if (!this.reportMain.isSecureMode()) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Security..."), "Security"));
            }
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof ReportCell) {
            this.addLockPositionMenu();
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Edit Attributes"), "Edit Attributes"));
            if (this.reportElement instanceof ColumnHeader) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Original Column Header"), "OriginalColumnHeader"));
            }
            this.addWordwrapMenu();
            this.addSeparator();
            this.addCutCopy();
            this.add(this.newMenuItem(LanguageEncoder.getText("HyperLink"), "HyperLink"));
            this.addResizeToFitContentMenu();
            this.addRotateMenu();
            if (DataType.mapType(((ReportCell)this.reportElement).getSQLType()) != 15) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
            }
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Set Style Class Name"), "Set Style Class Name"));
            this.addSetSectionStyleMenu();
            this.addCellAppearanceMenu();
            if (!this.reportMain.isSecureMode()) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Security..."), "Security"));
            }
            this.addSeparator();
            this.add(this.newMenuItem(LanguageEncoder.getText("Center Across Page"), "Center Across Page"));
            if (!(this.parent instanceof MasterSectionPanel)) {
                this.add(this.newMenuItem(LanguageEncoder.getText("Select Column"), "Select Column"));
                this.add(this.newMenuItem(LanguageEncoder.getText("Select Row"), "Select Row"));
                this.addSeparator();
            }
            this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
        } else if (this.reportElement instanceof ReportColumn) {
            if (this.reportMain.report.getDataType(this.reportMain.report.getColInfoIndex((ReportColumn)this.reportElement)) == 15) {
                this.addLockPositionMenu();
                this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
                this.addSeparator();
                this.addCutCopy();
                this.add(this.newMenuItem(LanguageEncoder.getText("Invisible"), "Invisible"));
                this.addSeparator();
                if (!this.reportMain.isSecureMode()) {
                    this.add(this.newMenuItem(LanguageEncoder.getText("Security..."), "Security"));
                }
                this.add(this.newMenuItem(LanguageEncoder.getText("Center Across Page"), "Center Across Page"));
                this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
                this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
            } else {
                this.addLockPositionMenu();
                int colIndex = this.reportMain.report.getColInfoIndex((ReportColumn)this.reportElement);
                if (colIndex >= 0 && this.reportMain.report.colInfo[colIndex].getFormula() != null) {
                    this.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
                }
                this.add(this.newMenuItem(LanguageEncoder.getText("Edit Attributes"), "Edit Attributes"));
                this.addSeparator();
                this.addCutCopy();
                this.addResizeToFitContentMenu();
                this.addRotateMenu();
                this.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
                this.add(this.newMenuItem(LanguageEncoder.getText("Set Z-index"), "Set Z-index"));
                this.add(this.newMenuItem(LanguageEncoder.getText("Set Style Class Name"), "Set Style Class Name"));
                this.addSetSectionStyleMenu();
                this.addCellAppearanceMenu();
                this.addWordwrapMenu();
                this.add(this.newMenuItem(LanguageEncoder.getText("Invisible"), "Invisible"));
                this.addSeparator();
                if (!this.reportMain.isSecureMode()) {
                    this.add(this.newMenuItem(LanguageEncoder.getText("Security..."), "Security"));
                }
                this.add(this.newMenuItem(LanguageEncoder.getText("Center Across Page"), "Center Across Page"));
                if (!(this.parent instanceof MasterSectionPanel)) {
                    this.add(this.newMenuItem(LanguageEncoder.getText("Select Column"), "Select Column"));
                    this.add(this.newMenuItem(LanguageEncoder.getText("Select Row"), "Select Row"));
                    this.addSeparator();
                }
                this.add(this.newMenuItem(LanguageEncoder.getText("Custom ID"), "CustomID"));
                this.add(this.newMenuItem(LanguageEncoder.getText("Properties"), "Properties"));
            }
        }
        if (elt.getSnap() > 0 || elt.getVSnap() > 0) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Separate from Guidelines"), "Separate from Guidelines"));
        }
        this.isReady = true;
    }

    private boolean isTableSection() {
        return this.parent instanceof ReportElementPanel && ((ReportElementPanel)this.parent).getElement().getID().startsWith("TBL") && !this.isSubSection();
    }

    private boolean isInsertable() {
        if (this.reportElement == this.reportMain.report.getPageHeader()) {
            return false;
        }
        return this.reportElement != this.reportMain.report.getPageFooter();
    }

    private boolean isSubSection() {
        if (this.reportElement instanceof ReportSection) {
            return ((ReportSection)this.reportElement).getParentSection() != null;
        }
        return false;
    }

    private boolean isHeaderSection() {
        return this.parent instanceof ReportElementPanel && (((ReportElementPanel)this.parent).getElement().getID().indexOf("HDR") >= 0 || ((ReportElementPanel)this.parent).getElement().getID().indexOf("H_SEC") >= 0) && !this.isSubSection();
    }

    private boolean isGroupHeaderSection() {
        ReportElementPanel elementPanel;
        return this.parent instanceof ReportElementPanel && (elementPanel = (ReportElementPanel)this.parent).getElement().getID().indexOf("H_SEC") >= 0 && !this.isSubSection();
    }

    private boolean isPageHeaderFooterSection() {
        ReportElementPanel elementPanel;
        return this.parent instanceof ReportElementPanel && ((elementPanel = (ReportElementPanel)this.parent).getElement().getID().equals("PG_HDR") || elementPanel.getElement().getID().equals("PG_FTR"));
    }

    void addBackgroundMenu() {
        JMenuItem bgColorMenuItem = new JMenuItem(LanguageEncoder.getText("Background Color"));
        bgColorMenuItem.setActionCommand("Background Color");
        bgColorMenuItem.addActionListener(this);
        this.add(bgColorMenuItem);
    }

    private void addCutCopy() {
        boolean enable = true;
        int countPanelWithSelectedObj = 0;
        Vector<JPanel> panels = this.reportMain.designPanel.rulerPanel.getVisiblePanel();
        for (JPanel obj : panels) {
            if (obj instanceof ReportElementPanel) {
                ReportElementPanel p = (ReportElementPanel)obj;
                for (ReportElement element : p.groupFormat) {
                    if (!(element instanceof GuideLine)) continue;
                    enable = false;
                }
                if (p.groupFormat.size() != 0) {
                    ++countPanelWithSelectedObj;
                }
            }
            if (countPanelWithSelectedObj <= true) continue;
            enable = false;
        }
        if (enable) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Cut"), "Cut"));
            this.add(this.newMenuItem(LanguageEncoder.getText("Copy"), "Copy"));
            this.addSeparator();
        }
    }

    private void addPasteOption() {
        JMenuItem paste = this.newMenuItem(LanguageEncoder.getText("Paste"), "Paste");
        if (this.reportMain.designPanel.rulerPanel.clipBoard.size() == 0) {
            paste.setEnabled(false);
        } else {
            paste.setEnabled(true);
        }
        this.add(paste);
    }

    void addBorderMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Border"), "Border"));
    }

    private void addSetSectionStyleMenu() {
        this.setSectionStyleMenu = new JCheckBoxMenuItem(LanguageEncoder.getText("Set Attributes as Section Style"));
        this.setSectionStyleMenu.setActionCommand("Set Section Style");
        if (!(this.parent instanceof ReportElementPanel)) {
            return;
        }
        boolean selected = false;
        ReportElement elt = ((ReportElementPanel)this.parent).getElement();
        if (elt instanceof ReportSection && this.reportElement instanceof ReportCell) {
            selected = ((ReportSection)elt).isSectionStyle((ReportCell)this.reportElement);
            this.setSectionStyleMenu.setSelected(selected);
            this.setSectionStyleMenu.addItemListener(this);
            this.add(this.setSectionStyleMenu);
        } else if (elt instanceof ReportTable && this.reportElement instanceof ReportColumn) {
            selected = ((ReportTable)elt).isSectionStyle((ReportColumn)this.reportElement);
            this.setSectionStyleMenu.setSelected(selected);
            this.setSectionStyleMenu.addItemListener(this);
            this.add(this.setSectionStyleMenu);
        }
    }

    private void addRepeatOnEveryPageMenu() {
        this.repeatOnEveryPage = new JCheckBoxMenuItem(LanguageEncoder.getText("Repeat On Every Page"));
        this.repeatOnEveryPage.setActionCommand("Repeat On Every Page");
        this.repeatOnEveryPage.setSelected(((ReportSection)this.reportElement).isRepeatOnEveryPage());
        this.repeatOnEveryPage.addItemListener(this);
        if (this.reportMain.report.getColumnWrap() != null && !this.reportElement.getID().equals("TBL0_HDR")) {
            this.repeatOnEveryPage.setEnabled(false);
        }
        this.add(this.repeatOnEveryPage);
    }

    private void addResetPageNumberMenu() {
        this.resetPageNumber = new JCheckBoxMenuItem(LanguageEncoder.getText("Reset Page Number"));
        this.resetPageNumber.setActionCommand("Reset Page Number");
        this.resetPageNumber.setSelected(((ReportSection)this.reportElement).isResetPageNumber());
        this.resetPageNumber.addItemListener(this);
        if (this.reportMain.report.getColumnWrap() != null) {
            this.resetPageNumber.setEnabled(false);
        }
        this.add(this.resetPageNumber);
    }

    private void addNewExcelSheetMenu() {
        this.newExcelSheet = new JCheckBoxMenuItem(LanguageEncoder.getText("New Excel Sheet"));
        this.newExcelSheet.setActionCommand("New Excel Sheet");
        this.newExcelSheet.setSelected(((ReportSection)this.reportElement).isNewExcelSheet());
        this.newExcelSheet.addItemListener(this);
        if (this.reportMain.report.getColumnWrap() != null) {
            this.newExcelSheet.setEnabled(false);
        }
        this.add(this.newExcelSheet);
    }

    private void addPrintOnNewPageMenu() {
        this.printOnNewPage = new JCheckBoxMenuItem(LanguageEncoder.getText("Print On New Page"));
        this.printOnNewPage.setActionCommand("Print On New Page");
        this.printOnNewPage.setSelected(((ReportTableElement)this.reportElement).isPrintOnNewPage());
        this.printOnNewPage.addItemListener(this);
        if (this.reportMain.report.getColumnWrap() != null) {
            this.printOnNewPage.setEnabled(false);
        }
        this.add(this.printOnNewPage);
    }

    private void addSkipFirstValueMenu() {
        this.skipFirstValue = new JCheckBoxMenuItem(LanguageEncoder.getText("Skip First Value"));
        this.skipFirstValue.setActionCommand("Skip First Value");
        this.skipFirstValue.setEnabled(((ReportTableElement)this.reportElement).isPrintOnNewPage());
        this.skipFirstValue.setSelected(false);
        if (this.skipFirstValue.isEnabled()) {
            this.skipFirstValue.setSelected(((ReportTableElement)this.reportElement).isSkipFirstValue());
        }
        this.skipFirstValue.addItemListener(this);
        this.add(this.skipFirstValue);
    }

    private void addSkipFirstGroupValueMenu() {
        this.skipFirstGroupValue = new JCheckBoxMenuItem(LanguageEncoder.getText("Skip First Group Value"));
        this.skipFirstGroupValue.setActionCommand("Skip First Group Value");
        this.skipFirstGroupValue.setEnabled(((ReportTableElement)this.reportElement).isPrintOnNewPage());
        this.skipFirstGroupValue.setSelected(false);
        if (this.skipFirstGroupValue.isEnabled()) {
            this.skipFirstGroupValue.setSelected(((ReportTableElement)this.reportElement).isSkipFirstGroupValue());
        }
        this.skipFirstGroupValue.addItemListener(this);
        if (this.reportMain.report.getColumnWrap() != null) {
            this.skipFirstGroupValue.setEnabled(false);
        }
        this.add(this.skipFirstGroupValue);
    }

    private void addFitGroupOnPageMenu() {
        ColInfo colInfo = this.reportMain.findMatchingColInfo(this.reportElement);
        if (colInfo != null) {
            this.addSeparator();
            this.fitGroupOnPage = new JCheckBoxMenuItem(LanguageEncoder.getText("Fit Group On Page"));
            this.fitGroupOnPage.setActionCommand("Fit Group On Page");
            this.fitGroupOnPage.setSelected(colInfo.isFitGroupOnPage());
            this.fitGroupOnPage.addItemListener(this);
            this.add(this.fitGroupOnPage);
            this.fitGroupOnPage.setEnabled(!this.resetPageNumber.isSelected());
            this.skipFirstValueForFitGroup = new JCheckBoxMenuItem(LanguageEncoder.getText("Skip First Value"));
            if (colInfo.isFitGroupOnPage()) {
                this.skipFirstValueForFitGroup.setSelected(colInfo.skipFirstValueForFitGroup());
            } else {
                this.skipFirstValueForFitGroup.setEnabled(false);
            }
            this.skipFirstValueForFitGroup.setActionCommand("Skip First Value For Fit Group");
            this.skipFirstValueForFitGroup.addItemListener(this);
            this.add(this.skipFirstValueForFitGroup);
            if (this.reportMain.report.getColumnWrap() != null) {
                this.fitGroupOnPage.setEnabled(false);
                this.skipFirstValueForFitGroup.setEnabled(false);
            }
            this.addSeparator();
        }
    }

    private void addVertSnapMenu() {
        JMenu snapMenu1 = new JMenu(LanguageEncoder.getText("Snap Elements In Range"));
        snapMenu1.add(this.newMenuItem(LanguageEncoder.getText("Left"), "Snap All Left"));
        snapMenu1.add(this.newMenuItem(LanguageEncoder.getText("Midline"), "Snap All Midline V"));
        snapMenu1.add(this.newMenuItem(LanguageEncoder.getText("Right"), "Snap All Right"));
        JMenu snapMenu2 = new JMenu(LanguageEncoder.getText("Snap Selected Elements"));
        snapMenu2.add(this.newMenuItem(LanguageEncoder.getText("Left"), "Snap Left"));
        snapMenu2.add(this.newMenuItem(LanguageEncoder.getText("Midline"), "Snap Midline V"));
        snapMenu2.add(this.newMenuItem(LanguageEncoder.getText("Right"), "Snap Right"));
        snapMenu1.addItemListener(this);
        snapMenu2.addItemListener(this);
        this.add(snapMenu1);
        this.add(snapMenu2);
        this.add(this.newMenuItem(LanguageEncoder.getText("Separate All"), "Separate All"));
        this.add(this.newMenuItem(LanguageEncoder.getText("Delete"), "Delete Guideline"));
    }

    private void addHorzSnapMenu() {
        JMenu snapMenu1 = new JMenu(LanguageEncoder.getText("Snap Elements In Range"));
        snapMenu1.add(this.newMenuItem(LanguageEncoder.getText("Top"), "Snap All Top"));
        snapMenu1.add(this.newMenuItem(LanguageEncoder.getText("Midline"), "Snap All Midline H"));
        snapMenu1.add(this.newMenuItem(LanguageEncoder.getText("Bottom"), "Snap All Bottom"));
        JMenu snapMenu2 = new JMenu(LanguageEncoder.getText("Snap Selected Elements"));
        snapMenu2.add(this.newMenuItem(LanguageEncoder.getText("Top"), "Snap Top"));
        snapMenu2.add(this.newMenuItem(LanguageEncoder.getText("Midline"), "Snap Midline H"));
        snapMenu2.add(this.newMenuItem(LanguageEncoder.getText("Bottom"), "Snap Bottom"));
        snapMenu1.addItemListener(this);
        snapMenu2.addItemListener(this);
        this.add(snapMenu1);
        this.add(snapMenu2);
        this.add(this.newMenuItem(LanguageEncoder.getText("Separate All"), "Separate All"));
        this.add(this.newMenuItem(LanguageEncoder.getText("Delete"), "Delete Guideline"));
    }

    void addLineThicknessMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Line Color & Thickness"), "Line Color & Thickness"));
    }

    void addLineStyleMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Line Style"), "Line Style"));
    }

    void addBorderStyleMenu() {
        this.add(this.newMenuItem(LanguageEncoder.getText("Border Style"), "Border Style"));
    }

    private void addCellAppearanceMenu() {
        JMenu cellAppearanceMenu = new JMenu(LanguageEncoder.getText("Element Appearance"));
        cellAppearanceMenu.add(this.newMenuItem(LanguageEncoder.getText("Copy"), "Copy Element Appearance"));
        JMenuItem mi = this.newMenuItem(LanguageEncoder.getText("Paste"), "Paste Element Appearance");
        cellAppearanceMenu.add(mi);
        if (this.reportMain.getCopiedElement() == null) {
            mi.setEnabled(false);
        }
        this.add(cellAppearanceMenu);
    }

    private void addRotateMenu() {
        JMenu rotateMenu = new JMenu(LanguageEncoder.getText("Rotate"));
        JCheckBoxMenuItem none = new JCheckBoxMenuItem(LanguageEncoder.getText("None"));
        none.setActionCommand("None");
        JCheckBoxMenuItem clockwise = new JCheckBoxMenuItem(LanguageEncoder.getText("Clockwise"));
        clockwise.setActionCommand("Clockwise");
        JCheckBoxMenuItem counter = new JCheckBoxMenuItem(LanguageEncoder.getText("CounterClockwise"));
        counter.setActionCommand("CounterClockwise");
        ReportElement selectedObject = this.reportMain.selectedObject;
        if (selectedObject != null) {
            none.setSelected(selectedObject.getRotateAngle() == 0.0);
            clockwise.setSelected(selectedObject.getRotateAngle() == 90.0);
            counter.setSelected(selectedObject.getRotateAngle() == -90.0);
        }
        none.addItemListener(this);
        clockwise.addItemListener(this);
        counter.addItemListener(this);
        rotateMenu.add(none);
        rotateMenu.add(clockwise);
        rotateMenu.add(counter);
        this.add(rotateMenu);
    }

    private void addLockPositionMenu() {
        this.lockPosition = new JCheckBoxMenuItem(LanguageEncoder.getText("Lock Position"));
        this.lockPosition.setActionCommand("Lock Position");
        if (this.reportElement.getSnap() == 0 && this.reportElement.getVSnap() == 0) {
            this.lockPosition.setEnabled(true);
            this.lockPosition.setSelected(this.reportElement.isLocked());
        } else {
            this.lockPosition.setEnabled(false);
        }
        this.lockPosition.addItemListener(this);
        this.add(this.lockPosition);
    }

    private void addWordwrapMenu() {
        this.wordWrap = new JCheckBoxMenuItem(LanguageEncoder.getText("Wordwrap"));
        this.wordWrap.setActionCommand("Wordwrap");
        ReportElement selectedObject = this.reportMain.selectedObject;
        if (selectedObject != null) {
            this.wordWrap.setSelected(!selectedObject.isNoWrap());
        }
        this.wordWrap.addItemListener(this);
        this.add(this.wordWrap);
    }

    private void addResizeToFitContentMenu() {
        this.resizeToFitContent = new JCheckBoxMenuItem(LanguageEncoder.getText("Resize To Fit Content"));
        this.resizeToFitContent.setActionCommand("Resize To Fit Content");
        ReportElement selectedObject = this.reportMain.selectedObject;
        if (selectedObject != null) {
            this.resizeToFitContent.setSelected(selectedObject.isResizeToFitContent());
        }
        this.resizeToFitContent.addItemListener(this);
        this.add(this.resizeToFitContent);
    }

    private void addAutoResizeWidthContentMenu() {
        this.autoResizeWidth = new JCheckBoxMenuItem(LanguageEncoder.getText(AUTO_RESIZE_WIDTH));
        this.autoResizeWidth.setActionCommand(AUTO_RESIZE_WIDTH);
        ReportElement selectedObject = this.reportMain.selectedObject;
        if (selectedObject != null && selectedObject instanceof SubReportObject) {
            this.autoResizeWidth.setSelected(((SubReportObject)selectedObject).isResizeWidth());
        }
        this.autoResizeWidth.addItemListener(this);
        this.add(this.autoResizeWidth);
    }

    JMenuItem newMenuItem(String s, String command) {
        JMenuItem m = new JMenuItem(s);
        m.setActionCommand(command);
        m.addActionListener(this);
        return m;
    }

    JRadioButtonMenuItem newRadioButtonMenuItem(String s, String command) {
        JRadioButtonMenuItem m = new JRadioButtonMenuItem(s);
        m.setActionCommand(command);
        m.addItemListener(this);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        this.reportMain.createBackupReport();
        String cmd = e.getActionCommand();
        if (cmd.equals("Set Z-index")) {
            this.reportMain.setEltZIndex();
        } else if (cmd.equals("Section Height")) {
            this.reportMain.setEltHeight();
        } else if (cmd.equals("Set Style Class Name")) {
            this.reportMain.setEltStyleClassName();
        } else if (cmd.equals("Background Color")) {
            this.reportMain.setEltBackgroundColor();
        } else if (cmd.equals("Line Color & Thickness")) {
            this.reportMain.setEltLineThickness();
        } else if (cmd.equals("Line Style")) {
            this.reportMain.setLineStyle(this.parent);
        } else if (cmd.equals("Border Style")) {
            this.reportMain.setLineStyle(this.parent);
        } else if (cmd.equals("Edit")) {
            this.reportMain.setEltText(this.parent);
            this.reportMain.menuBar.setUndoEnabled(true);
        } else if (cmd.equals("OriginalColumnHeader")) {
            this.reportMain.setOriginalColumnHeader(true);
        } else if (cmd.equals("Scripting")) {
            this.reportMain.setEltScript();
        } else if (cmd.equals("HTML Border")) {
            this.reportMain.setHTMLBorder((ReportTableElement)this.reportElement);
        } else if (cmd.equals("Print On New Page")) {
            this.reportMain.setPrintOnNewPage((ReportTable)this.reportElement);
        } else if (cmd.equals("Border")) {
            this.reportMain.setEltBorder();
        } else if (cmd.equals("Invisible")) {
            this.reportMain.setEltVisible(false);
        } else if (cmd.equals("Visible")) {
            if (this.reportElement instanceof ReportColumn) {
                this.reportMain.setColumnVisible(this.reportElement, true, this.parent, 0, null);
            }
            if (this.reportElement instanceof ReportTableElement) {
                this.reportMain.setSectionVisible(true, (ReportTableElement)this.reportElement);
            }
        } else if (cmd.equals("Select Column")) {
            this.reportMain.selectColumn(this.reportElement, this.parent);
        } else if (cmd.equals("Select Row")) {
            this.reportMain.selectRow(this.reportElement, this.parent);
        } else if (cmd.equals("Set Bounds")) {
            this.reportMain.setEltBounds();
        } else if (cmd.equals("Column Wrap")) {
            this.reportMain.setColumnWrapInfo();
        } else if (cmd.equals("Security")) {
            this.reportMain.setEltSecurity();
        } else if (cmd.equals("CustomID")) {
            this.reportMain.setEltCustomID();
        } else if (cmd.equals("Properties")) {
            this.reportMain.getEltProperties();
        } else if (cmd.equals("Edit Attributes")) {
            this.reportMain.editEltAttributes();
        } else if (cmd.equals("Export Format")) {
            this.reportMain.setEltImageOptions();
        } else if (cmd.equals("HyperLink")) {
            this.reportMain.setEltWebLink();
        } else if (cmd.equals("Insert Section")) {
            this.reportMain.addSubSection();
        } else if (cmd.equals("Remove Section")) {
            this.reportMain.removeSubSection();
        } else if (cmd.equals("Cut")) {
            this.reportMain.designPanel.rulerPanel.cutToClipBoard();
        } else if (cmd.equals("Copy")) {
            this.reportMain.designPanel.rulerPanel.copyToClipBoard();
        } else if (cmd.equals("Paste")) {
            if ((this.reportMain.selectedPanel.getElement() instanceof CrossTabReportSection || this.reportMain.selectedPanel.getElement() instanceof ReportTable && this.reportMain.report.isCrossTab()) && !this.reportMain.isAllowCrosstabElementMove()) {
                new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You cannot insert element to CrossTab report section!"));
                return;
            }
            if (this.clickX > 0 && this.clickY > 0) {
                this.reportMain.designPanel.rulerPanel.pasteX = this.clickX;
                this.reportMain.designPanel.rulerPanel.pasteY = this.clickY;
            }
            this.reportMain.designPanel.rulerPanel.pasteFromClipBoard(this.reportMain.selectedPanel);
        } else if (cmd.equals("Snap Left")) {
            this.reportMain.designPanel.rulerPanel.snapLeft(this.reportElement);
        } else if (cmd.equals("Snap Midline V")) {
            this.reportMain.designPanel.rulerPanel.snapMidlineV(this.reportElement);
        } else if (cmd.equals("Snap Right")) {
            this.reportMain.designPanel.rulerPanel.snapRight(this.reportElement);
        } else if (cmd.equals("Snap Top")) {
            this.reportMain.selectedPanel.snapTop(this.reportElement);
        } else if (cmd.equals("Snap Midline H")) {
            this.reportMain.selectedPanel.snapMidlineH(this.reportElement);
        } else if (cmd.equals("Snap Bottom")) {
            this.reportMain.selectedPanel.snapBottom(this.reportElement);
        } else if (cmd.equals("Separate from Guidelines")) {
            this.reportMain.report.removeEltFromGuideLine(this.reportElement);
        } else if (cmd.equals("Snap All Left")) {
            this.reportMain.designPanel.rulerPanel.snapAllLeft(this.reportElement);
        } else if (cmd.equals("Snap All Midline V")) {
            this.reportMain.designPanel.rulerPanel.snapAllMidlineV(this.reportElement);
        } else if (cmd.equals("Snap All Right")) {
            this.reportMain.designPanel.rulerPanel.snapAllRight(this.reportElement);
        } else if (cmd.equals("Snap All Top")) {
            this.reportMain.selectedPanel.snapAllTop(this.reportElement);
        } else if (cmd.equals("Snap All Midline H")) {
            this.reportMain.selectedPanel.snapAllMidlineH(this.reportElement);
        } else if (cmd.equals("Snap All Bottom")) {
            this.reportMain.selectedPanel.snapAllBottom(this.reportElement);
        } else if (cmd.equals("Separate All")) {
            this.reportMain.report.removeAllFromGuideLine((GuideLine)this.reportElement);
        } else if (cmd.equals("Delete Guideline")) {
            this.reportMain.deleteElt(this.reportElement, null, true);
        } else if (cmd.equals("Copy Element Appearance")) {
            this.reportMain.setCopiedElement(this.reportElement);
        } else if (cmd.equals("Paste Element Appearance")) {
            this.reportMain.pasteElementAppearance(this.reportElement);
        } else if (cmd.equals("Center Across Page")) {
            this.reportMain.designPanel.rulerPanel.setGroupAlignment((short)0);
        } else {
            LOGGER.warning("Invalid action: " + cmd);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isReady) {
            return;
        }
        JMenuItem target = (JMenuItem)e.getSource();
        String cmd = target.getActionCommand();
        if (cmd.equals("Repeat On Every Page")) {
            ((ReportSection)this.reportElement).setRepeatOnEveryPage(this.repeatOnEveryPage.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("Lock Position")) {
            this.reportElement.setLocked(this.lockPosition.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("Wordwrap")) {
            this.reportMain.selectedObject.setNoWrap(!this.wordWrap.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("None")) {
            this.reportMain.setEltRotate(0.0);
            this.reportMain.setModified();
        } else if (cmd.equals("Clockwise")) {
            this.reportMain.setEltRotate(90.0);
            this.reportMain.setModified();
        } else if (cmd.equals("CounterClockwise")) {
            this.reportMain.setEltRotate(-90.0);
            this.reportMain.setModified();
        } else if (cmd.equals("Resize To Fit Content")) {
            this.reportMain.selectedObject.setResizeToFitContent(this.resizeToFitContent.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals(AUTO_RESIZE_WIDTH)) {
            if (this.reportMain.selectedObject != null && this.reportMain.selectedObject instanceof SubReportObject) {
                ((SubReportObject)this.reportMain.selectedObject).setResizeWidth(this.autoResizeWidth.isSelected());
                this.reportMain.setModified();
            }
        } else if (cmd.equals("Reset Page Number")) {
            this.fitGroupOnPage.setSelected(false);
            ((ReportSection)this.reportElement).setResetPageNumber(this.resetPageNumber.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("New Excel Sheet")) {
            ((ReportSection)this.reportElement).setNewExcelSheet(this.newExcelSheet.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("Print On New Page")) {
            ((ReportTableElement)this.reportElement).setPrintOnNewPage(this.printOnNewPage.isSelected());
            if (!this.printOnNewPage.isSelected()) {
                ((ReportTableElement)this.reportElement).setSkipFirstValue(false);
                ((ReportTableElement)this.reportElement).setSkipFirstGroupValue(false);
            }
            this.reportMain.setModified();
        } else if (cmd.equals("Skip First Value")) {
            ((ReportTableElement)this.reportElement).setSkipFirstValue(this.skipFirstValue.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("Skip First Group Value")) {
            ((ReportTableElement)this.reportElement).setSkipFirstGroupValue(this.skipFirstGroupValue.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("Fit Group On Page")) {
            ColInfo colInfo = this.reportMain.findMatchingColInfo(this.reportElement);
            if (colInfo != null && this.fitGroupOnPage != null) {
                colInfo.setFitGroupOnPage(this.fitGroupOnPage.isSelected());
                this.reportMain.setModified();
            }
        } else if (cmd.equals("Skip First Value For Fit Group")) {
            ColInfo colInfo = this.reportMain.findMatchingColInfo(this.reportElement);
            if (colInfo != null && this.skipFirstValueForFitGroup != null) {
                colInfo.setSkipFirstValueForFitGroup(this.skipFirstValueForFitGroup.isSelected());
                this.reportMain.setModified();
            }
        } else if (cmd.equals("Resize Cells Proportionally")) {
            this.reportElement.setResizeToFitContent(this.resizeCells.isSelected());
            this.reportMain.setModified();
        } else if (cmd.equals("Set Section Style")) {
            this.reportMain.setSectionStyle((ReportElementPanel)this.parent, this.reportElement, this.setSectionStyleMenu.isSelected());
        }
    }

    public void setAddPasteOp(boolean b) {
        this.addPasteOp = b;
    }

    public void setClickLocation(int x, int y) {
        this.clickX = x;
        this.clickY = y;
    }
}

