/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.designer.SelectReportStyle;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.internal.ImageData;

public class PreSelectReportElement
extends JPanel
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(PreSelectReportElement.class.getName());
    JButton backButton;
    JButton cancelButton;
    JButton nextButton;
    JButton doneButton;
    JButton browseButton;
    JCheckBox titleCB;
    JCheckBox logoCB;
    JCheckBox pageCB;
    JCheckBox dateCB;
    JTextField titleTF;
    JTextField logoTF;
    JComboBox logoPosCombo;
    JComboBox pageFormatCombo;
    JComboBox pagePosCombo;
    JComboBox dateFormatCombo;
    JComboBox datePosCombo;
    String[] logoPos = new String[]{LanguageEncoder.getText("Upper Left"), LanguageEncoder.getText("Upper Right")};
    String[] position = new String[]{LanguageEncoder.getText("Upper Left"), LanguageEncoder.getText("Upper Center"), LanguageEncoder.getText("Upper Right"), LanguageEncoder.getText("Lower Left"), LanguageEncoder.getText("Lower Center"), LanguageEncoder.getText("Lower Right")};
    String[] pageNumberFormat = new String[]{LanguageEncoder.getText("page x"), LanguageEncoder.getText("page x of y")};
    String[] dateFormat = new String[]{LanguageEncoder.getText("date"), LanguageEncoder.getText("time"), LanguageEncoder.getText("date & time")};
    ReportWizard wizard;
    JPanel prevPanel;
    Report report;
    boolean titleCheck;
    boolean logoCheck;
    boolean pageCheck;
    boolean dateCheck;
    String title;
    String logoURL;
    int logoPosIndex;
    int pageFormatIndex;
    int pagePosIndex;
    int dateFormatIndex;
    int datePosIndex;

    public PreSelectReportElement(ReportWizard wizard, JPanel prevPanel) {
        this.wizard = wizard;
        this.report = wizard.report;
        this.prevPanel = prevPanel;
        this.setBackground(Color.lightGray);
        JPanel bpanel = new JPanel(new BorderLayout());
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Pre-select Report Elements")));
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new BoxLayout(gridpanel, 1));
        JPanel titlepanel = new JPanel(new FlowLayout(0));
        titlepanel.setBorder(new TitledBorder(LanguageEncoder.getText("Report Title")));
        this.titleCB = new JCheckBox(LanguageEncoder.getText("Add Report Title"));
        titlepanel.add(this.titleCB);
        this.titleCB.addItemListener(this);
        this.titleTF = new JTextField(30);
        titlepanel.add(this.titleTF);
        gridpanel.add(titlepanel);
        JPanel logopanel = new JPanel(new BorderLayout());
        logopanel.setBorder(new TitledBorder(LanguageEncoder.getText("Logo")));
        JPanel logopanel1 = new JPanel(new FlowLayout(0));
        this.logoCB = new JCheckBox(LanguageEncoder.getText("Add Logo"));
        logopanel1.add(this.logoCB);
        this.logoCB.addItemListener(this);
        this.logoTF = new JTextField(30);
        logopanel1.add(this.logoTF);
        this.browseButton = new JButton(LanguageEncoder.getText("Browse"));
        logopanel1.add(this.browseButton);
        this.browseButton.addActionListener(this);
        JPanel logopanel2 = new JPanel(new FlowLayout(0));
        logopanel2.add(new JLabel(LanguageEncoder.getText("Position")));
        this.logoPosCombo = new JComboBox<String>(this.logoPos);
        logopanel2.add(this.logoPosCombo);
        logopanel.add("North", logopanel1);
        logopanel.add("South", logopanel2);
        gridpanel.add(logopanel);
        JPanel pagepanel = new JPanel(new BorderLayout());
        pagepanel.setBorder(new TitledBorder(LanguageEncoder.getText("Page Number")));
        JPanel pagepanel1 = new JPanel(new FlowLayout(0));
        this.pageCB = new JCheckBox(LanguageEncoder.getText("Add Page Number"));
        pagepanel1.add(this.pageCB);
        this.pageCB.addItemListener(this);
        JPanel pagepanel2 = new JPanel(new FlowLayout(0));
        pagepanel2.add(new JLabel(LanguageEncoder.getText("Format")));
        this.pageFormatCombo = new JComboBox<String>(this.pageNumberFormat);
        pagepanel2.add(this.pageFormatCombo);
        pagepanel2.add(new JLabel(LanguageEncoder.getText("Position")));
        this.pagePosCombo = new JComboBox<String>(this.position);
        pagepanel2.add(this.pagePosCombo);
        pagepanel.add("North", pagepanel1);
        pagepanel.add("South", pagepanel2);
        gridpanel.add(pagepanel);
        JPanel datepanel = new JPanel(new BorderLayout());
        datepanel.setBorder(new TitledBorder(LanguageEncoder.getText("Date")));
        JPanel datepanel1 = new JPanel(new FlowLayout(0));
        this.dateCB = new JCheckBox(LanguageEncoder.getText("Add Date"));
        datepanel1.add(this.dateCB);
        this.dateCB.addItemListener(this);
        JPanel datepanel2 = new JPanel(new FlowLayout(0));
        datepanel2.add(new JLabel(LanguageEncoder.getText("Format")));
        this.dateFormatCombo = new JComboBox<String>(this.dateFormat);
        datepanel2.add(this.dateFormatCombo);
        datepanel2.add(new JLabel(LanguageEncoder.getText("Position")));
        this.datePosCombo = new JComboBox<String>(this.position);
        datepanel2.add(this.datePosCombo);
        datepanel.add("North", datepanel1);
        datepanel.add("South", datepanel2);
        gridpanel.add(datepanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.backButton = new JButton(LanguageEncoder.getText("<< Back"));
        buttonPanel.add(this.backButton);
        this.backButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.doneButton = new JButton(LanguageEncoder.getText("Done"));
        buttonPanel.add(this.doneButton);
        this.doneButton.addActionListener(this);
        this.nextButton = new JButton(LanguageEncoder.getText("Next >>"));
        buttonPanel.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.nextButton.requestFocus();
        bpanel.add("Center", gridpanel);
        bpanel.add("South", buttonPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", bpanel);
        if (this.report != null) {
            if (this.report.hasTitle) {
                this.titleCB.setSelected(true);
                this.titleTF.setText(this.report.reportTitle);
            }
            if (this.report.hasLogo) {
                this.logoCB.setSelected(true);
                this.logoTF.setText(this.report.logofile);
                this.logoPosCombo.setSelectedIndex(this.report.logoPos);
            }
            if (this.report.hasPageNumber) {
                this.pageCB.setSelected(true);
                this.pageFormatCombo.setSelectedIndex(this.report.pageNumberFormat);
                this.pagePosCombo.setSelectedIndex(this.report.pageNumberPos);
            }
            if (this.report.hasDate) {
                this.dateCB.setSelected(true);
                this.dateFormatCombo.setSelectedIndex(this.report.dateFormat);
                this.datePosCombo.setSelectedIndex(this.report.datePos);
            }
        }
        this.reset();
    }

    private void reset() {
        if (this.titleCheck) {
            this.titleTF.setEnabled(true);
            this.title = this.titleTF.getText();
        } else {
            this.titleTF.setEnabled(false);
            this.title = null;
        }
        this.titleTF.setText(this.title);
        if (this.logoCheck) {
            this.logoTF.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.logoPosCombo.setEnabled(true);
            this.logoURL = this.logoTF.getText();
            this.logoPosIndex = this.logoPosCombo.getSelectedIndex();
        } else {
            this.logoTF.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.logoPosCombo.setEnabled(false);
            this.logoURL = null;
            this.logoPosIndex = 0;
        }
        this.logoTF.setText(this.logoURL);
        this.logoPosCombo.setSelectedIndex(this.logoPosIndex);
        if (this.pageCheck) {
            this.pageFormatCombo.setEnabled(true);
            this.pagePosCombo.setEnabled(true);
            this.pageFormatIndex = this.pageFormatCombo.getSelectedIndex();
            this.pagePosIndex = this.pagePosCombo.getSelectedIndex();
        } else {
            this.pageFormatCombo.setEnabled(false);
            this.pagePosCombo.setEnabled(false);
            this.pageFormatIndex = 0;
            this.pagePosIndex = 0;
        }
        this.pageFormatCombo.setSelectedIndex(this.pageFormatIndex);
        this.pagePosCombo.setSelectedIndex(this.pagePosIndex);
        if (this.dateCheck) {
            this.dateFormatCombo.setEnabled(true);
            this.datePosCombo.setEnabled(true);
            this.dateFormatIndex = this.dateFormatCombo.getSelectedIndex();
            this.datePosIndex = this.datePosCombo.getSelectedIndex();
        } else {
            this.dateFormatCombo.setEnabled(false);
            this.datePosCombo.setEnabled(false);
            this.dateFormatIndex = 0;
            this.datePosIndex = 0;
        }
        this.dateFormatCombo.setSelectedIndex(this.dateFormatIndex);
        this.datePosCombo.setSelectedIndex(this.datePosIndex);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item = e.getItem();
        if (item == this.titleCB) {
            this.titleCheck = this.titleCB.isSelected();
        } else if (item == this.logoCB) {
            this.logoCheck = this.logoCB.isSelected();
        } else if (item == this.pageCB) {
            this.pageCheck = this.pageCB.isSelected();
        } else if (item == this.dateCB) {
            this.dateCheck = this.dateCB.isSelected();
        }
        this.reset();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block63: {
            Object source = e.getSource();
            if (source == this.browseButton) {
                String fileURL;
                if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                    JFileChooser fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                    fileChooser.setCurrentDirectory(new File(this.wizard.reportmain.getBrowseDirectories().getLogoImagesDir()));
                    fileChooser.showDialog(this.wizard.reportmain, null);
                    if (fileChooser.getSelectedFile() == null) {
                        return;
                    }
                    fileURL = fileChooser.getSelectedFile().getAbsolutePath();
                    this.wizard.reportmain.getBrowseDirectories().setLogoImagesDir(fileChooser.getCurrentDirectory().getAbsolutePath());
                    if (fileURL != null && !fileURL.startsWith("file:/")) {
                        File f = new File(fileURL);
                        try {
                            fileURL = f.toURL().toString();
                        }
                        catch (MalformedURLException ex) {
                            LOGGER.log(Level.WARNING, "Failed to create file URL from selected file", ex);
                        }
                    }
                } else {
                    String res;
                    BrowseDialog browseDialog = null;
                    String[] ext = new String[]{"GIF", "JPEG", "JPG", "PNG"};
                    browseDialog = BrowseDialog.create(this.wizard.reportmain, this.wizard.reportmain.getBrowseDirectories().getLogoImagesDir(), ext, ServerMessage.getApplet() == null, false);
                    browseDialog.setVisible(true);
                    fileURL = browseDialog.getSelectedFile(false);
                    if (fileURL == null) {
                        return;
                    }
                    this.wizard.reportmain.getBrowseDirectories().setLogoImagesDir(browseDialog.getCurrentDirectory());
                    fileURL = fileURL.replace('\\', '/');
                    if (this.wizard.reportmain.isFromOrganizer() && (res = this.wizard.reportmain.getURL(fileURL)) != null) {
                        this.logoTF.setText(res);
                        return;
                    }
                    if (ServerMessage.getApplet() != null) {
                        String codeBase = IOUtil.getCodeBase(ServerMessage.getApplet());
                        fileURL = codeBase + fileURL;
                    } else if (fileURL != null && !fileURL.startsWith("file:/")) {
                        File f = new File(fileURL);
                        try {
                            fileURL = f.toURL().toString();
                        }
                        catch (MalformedURLException ex) {
                            LOGGER.log(Level.WARNING, "Failed to create file URL from selected file", ex);
                        }
                    }
                }
                this.logoTF.setText(fileURL);
            } else if (source == this.doneButton || source == this.nextButton) {
                boolean newReport = this.report == null;
                int reportStyle = -1;
                String customStyleFile = null;
                if (this.report != null) {
                    reportStyle = this.report.reportStyle;
                    customStyleFile = this.report.customStyleFile;
                }
                try {
                    Report rpt;
                    String name;
                    this.report.reportStyle = reportStyle;
                    this.report.customStyleFile = customStyleFile;
                    ReportElement image = null;
                    if (this.logoCB.isSelected() && this.logoTF.getText() != null) {
                        if (this.logoTF.getText().trim().equals("")) {
                            new JMessageDialog((Dialog)this.wizard, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please specify the logo path"));
                            return;
                        }
                        if (this.report.hasLogo) {
                            for (int i = 0; i < this.report.getReportHeader().getCells().length; ++i) {
                                ReportCell cell = this.report.getReportHeader().getCells()[i];
                                if (!(cell instanceof ReportImage)) continue;
                                ReportImage img = (ReportImage)cell;
                                this.report.logofile = this.report.logofile.replace('\\', '/');
                                if (!img.getImageURL().toString().equals(this.report.logofile)) continue;
                                this.report.getReportHeader().removeData(i);
                                break;
                            }
                        }
                        this.report.hasLogo = true;
                        this.report.logofile = this.logoTF.getText().replace('\\', '/');
                        this.report.logoPos = this.logoPosCombo.getSelectedIndex();
                        image = new ReportImage();
                        image.setSnapToGrid(this.report.snapToGrid, this.wizard.reportmain.isCm, this.report.gridStepSize);
                        ((ReportImage)image).setImageURL(new URL(this.logoTF.getText()), false);
                        this.report.getReportHeader().addData((ReportCell)image);
                        Dimension dim = ImageData.getSize(((ReportImage)image).getImageURL(), ServerMessage.getComponent());
                        if (dim != null) {
                            image.setWidth(QbUtil.toInch(dim.getWidth()));
                            image.setHeight(QbUtil.toInch(dim.getHeight()));
                        }
                        if (this.logoPosCombo.getSelectedIndex() == 1) {
                            double pageW = this.report.getActualPageWidth();
                            double imgW = image.getWidth();
                            image.setX(pageW - imgW);
                            image.setWidth(image.getWidth());
                            imgW = image.getWidth();
                            if (image.getX() + imgW > pageW) {
                                if (this.report.snapToGrid) {
                                    image.setX(image.getX() - this.report.gridStepSize);
                                } else {
                                    image.setX(image.getX() - 1.0E-13);
                                }
                            }
                        } else {
                            image.setX(0.0);
                        }
                    }
                    if (this.titleCB.isSelected()) {
                        if (this.report.hasTitle) {
                            for (int i = 0; i < this.report.getReportHeader().getCells().length; ++i) {
                                ReportCell cell = this.report.getReportHeader().getCells()[i];
                                if (!cell.getText().equals(this.report.reportTitle)) continue;
                                this.report.getReportHeader().removeData(i);
                                break;
                            }
                        }
                        this.report.hasTitle = true;
                        this.report.reportTitle = this.titleTF.getText();
                        ReportTitle newCell = new ReportTitle(this.titleTF.getText());
                        if (image != null && image.getX() == 0.0) {
                            newCell.setX(image.getWidth());
                        }
                        newCell.setSnapToGrid(this.report.snapToGrid, this.wizard.reportmain.isCm, this.report.gridStepSize);
                        this.report.getReportHeader().addData(newCell);
                    }
                    if (this.pageCB.isSelected()) {
                        String text;
                        ReportSection section;
                        if (this.report.hasPageNumber) {
                            section = this.report.pageNumberPos < 3 ? this.report.getPageHeader() : this.report.getPageFooter();
                            for (int i = 0; i < section.getCells().length; ++i) {
                                ReportCell cell = section.getCells()[i];
                                if (!cell.getFormulaName().startsWith("pageNumber")) continue;
                                section.removeData(i);
                                break;
                            }
                        }
                        this.report.hasPageNumber = true;
                        this.report.pageNumberFormat = this.pageFormatCombo.getSelectedIndex();
                        this.report.pageNumberPos = this.pagePosCombo.getSelectedIndex();
                        if (this.pageFormatCombo.getSelectedIndex() == 0) {
                            name = "pageNumber";
                            text = "\"Page \"+getPage()";
                        } else {
                            name = "pageNumberOfTotalPages";
                            text = "\"Page \"+getPage()+ \" of \"+getTotalPages()";
                        }
                        Formula formula = new Formula(name, text);
                        Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                        formulaVec.add(this.report.formulas);
                        for (int i = 0; this.report.subReports != null && i < this.report.subReports.size(); ++i) {
                            rpt = this.report.getSubReportArray()[i];
                            if (rpt == null) continue;
                            formulaVec.add(rpt.formulas);
                        }
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        formula.setFormula(parser.parse(formulaVec, this.report.getQueryParameters(), this.report.getFormulaParameters(), name));
                        section = this.pagePosCombo.getSelectedIndex() < 3 ? this.report.getPageHeader() : this.report.getPageFooter();
                        ReportCell cell = new ReportCell(formula);
                        cell.setSnapToGrid(this.report.snapToGrid, this.wizard.reportmain.isCm, this.report.gridStepSize);
                        if (this.pagePosCombo.getSelectedIndex() % 3 == 2) {
                            cell.setX(this.report.getActualPageWidth() - cell.getWidth());
                        } else if (this.pagePosCombo.getSelectedIndex() % 3 == 1) {
                            cell.setX((this.report.getActualPageWidth() - cell.getWidth()) / 2.0);
                        }
                        section.addData(cell);
                        this.report.formulas.addElement(formula);
                    }
                    if (this.dateCB.isSelected()) {
                        int type;
                        String text;
                        if (this.report.hasDate) {
                            ReportSection section = this.report.datePos < 3 ? this.report.getPageHeader() : this.report.getPageFooter();
                            for (int i = 0; i < section.getCells().length; ++i) {
                                ReportCell cell = section.getCells()[i];
                                if (!cell.getFormulaName().startsWith("todays")) continue;
                                section.removeData(i);
                                break;
                            }
                        }
                        this.report.hasDate = true;
                        this.report.dateFormat = this.dateFormatCombo.getSelectedIndex();
                        this.report.datePos = this.datePosCombo.getSelectedIndex();
                        if (this.dateFormatCombo.getSelectedIndex() == 0) {
                            name = "todaysDate";
                            text = "getCurrentDate()";
                            type = 3;
                        } else if (this.dateFormatCombo.getSelectedIndex() == 1) {
                            name = "todaysTime";
                            text = "getCurrentTime()";
                            type = 4;
                        } else {
                            name = "todaysDateTime";
                            text = "getCurrentDateTime()";
                            type = 5;
                        }
                        Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                        formulaVec.add(this.report.formulas);
                        for (int i = 0; this.report.subReports != null && i < this.report.subReports.size(); ++i) {
                            rpt = this.report.getSubReportArray()[i];
                            if (rpt == null) continue;
                            formulaVec.add(rpt.formulas);
                        }
                        Formula formula = new Formula(name, text);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                        formula.setFormula(parser.parse(formulaVec, this.report.getQueryParameters(), this.report.getFormulaParameters(), name));
                        ReportSection section = this.datePosCombo.getSelectedIndex() < 3 ? this.report.getPageHeader() : this.report.getPageFooter();
                        formula.setDatatype(type);
                        ReportCell cell = new ReportCell(formula);
                        cell.setSnapToGrid(this.report.snapToGrid, this.wizard.reportmain.isCm, this.report.gridStepSize);
                        if (this.datePosCombo.getSelectedIndex() % 3 == 2) {
                            cell.setX(this.report.getActualPageWidth() - cell.getWidth());
                            if (this.pageCB.isSelected() && this.pagePosCombo.getSelectedIndex() == this.datePosCombo.getSelectedIndex()) {
                                cell.setX(cell.getX() - cell.getWidth());
                            }
                        } else if (this.datePosCombo.getSelectedIndex() % 3 == 1) {
                            cell.setX((this.report.getActualPageWidth() - cell.getWidth()) / 2.0);
                            if (this.pageCB.isSelected() && this.pagePosCombo.getSelectedIndex() == this.datePosCombo.getSelectedIndex()) {
                                cell.setX(cell.getX() - cell.getWidth());
                            }
                        } else if (this.pageCB.isSelected() && this.pagePosCombo.getSelectedIndex() == this.datePosCombo.getSelectedIndex()) {
                            cell.setX(cell.getX() + cell.getWidth());
                        }
                        section.addData(cell);
                        this.report.formulas.addElement(formula);
                    }
                    this.wizard.report = this.report;
                    if (source == this.doneButton) {
                        if (this.report.reportStyle >= 0 || newReport || this.wizard.isRedoDataMappingOp) {
                            this.wizard.doneWizard(this.report, false);
                            this.wizard.formatReport(this.report.reportStyle);
                            this.wizard.reportmain.autoFitColumns();
                        } else {
                            this.wizard.doneWizard(this.report);
                        }
                        break block63;
                    }
                    this.wizard.swapPanel(this, new SelectReportStyle(this.wizard, this));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to create report", ex);
                    String str = LanguageEncoder.getText("Cannot create report!") + " " + ex.getMessage();
                    new JMessageDialog((Dialog)this.wizard, LanguageEncoder.getText("Warning"), str);
                }
            } else if (source == this.backButton) {
                this.wizard.swapPanel(this, this.prevPanel);
            } else {
                this.wizard.cancel();
            }
        }
    }
}

