/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class PreviewDataOptionDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(PreviewDataOptionDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    JRadioButton useBackupData;
    JRadioButton useLiveData;
    JCheckBox displayRowCheck;
    JTextField indexField;
    ReportMain reportMain;
    int displayRow;
    boolean isUseLiveData;
    boolean isCancel;

    public PreviewDataOptionDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Preview Data Options ..."), true);
        this.reportMain = reportMain;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.displayRow = this.reportMain.getDisplayRow();
        this.isUseLiveData = this.reportMain.useLiveData;
        this.isCancel = true;
        JPanel p1 = new JPanel();
        p1.setBorder(new TitledBorder(LanguageEncoder.getText("Set Preview data options")));
        p1.setLayout(new BorderLayout());
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.useBackupData = new JRadioButton(LanguageEncoder.getText("Use Saved Data"), !this.isUseLiveData);
        optionPanel.add(this.useBackupData);
        this.useLiveData = new JRadioButton(LanguageEncoder.getText("Use Live Data"), this.isUseLiveData);
        optionPanel.add(this.useLiveData);
        ButtonGroup group = new ButtonGroup();
        group.add(this.useBackupData);
        group.add(this.useLiveData);
        p1.add((Component)optionPanel, "North");
        JPanel indexPanel = new JPanel();
        indexPanel.setLayout(new FlowLayout(2));
        boolean check = this.displayRow >= 0;
        indexPanel.add(new JLabel(" "));
        this.displayRowCheck = new JCheckBox(LanguageEncoder.getText("Limit Preview display row"), check);
        indexPanel.add(this.displayRowCheck);
        this.indexField = new JTextField(this.displayRow + "", 5);
        indexPanel.add(this.indexField);
        p1.add((Component)indexPanel, "South");
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.useLiveData.addItemListener(this);
        this.displayRowCheck.addItemListener(this);
        this.setDisplayRowCheckEnabled();
        this.setDisplayRowEnabled();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.useLiveData) {
            this.setDisplayRowCheckEnabled();
        } else if (e.getSource() == this.displayRowCheck) {
            this.setDisplayRowEnabled();
        }
    }

    private void setDisplayRowCheckEnabled() {
        if (this.reportMain.report.sourceData == 1) {
            this.displayRowCheck.setEnabled(this.useLiveData.isSelected());
        } else {
            this.displayRowCheck.setEnabled(false);
        }
        this.setDisplayRowEnabled();
    }

    private void setDisplayRowEnabled() {
        this.indexField.setEnabled(this.displayRowCheck.isSelected() && this.displayRowCheck.isEnabled());
    }

    int getDisplayRow() {
        return this.displayRow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.isCancel = true;
        if (e.getSource() == this.okButton) {
            this.isCancel = false;
            this.isUseLiveData = this.useLiveData.isSelected();
            if (this.isUseLiveData && this.displayRowCheck.isSelected()) {
                try {
                    int tmpIndex;
                    this.displayRow = tmpIndex = Integer.parseInt(this.indexField.getText());
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Enabling this feature may affect report accuracy in preview window"));
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINEST, "Display row: Invalid number", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Display Row: Integer Only!"));
                    return;
                }
            } else {
                this.displayRow = -1;
            }
            this.reportMain.menuBar.setUndoEnabled(true);
        }
        this.setVisible(false);
        this.dispose();
    }
}

