/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportViewer.swing.ReportCanvas;
import quadbase.reportdesigner.ReportViewer.swing.Viewer;
import quadbase.reportdesigner.designer.GoToDialog;
import quadbase.reportdesigner.designer.PreviewToolBar;
import quadbase.reportdesigner.designer.ReportMain;

public class PreviewPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(PreviewPanel.class.getName());
    ReportMain reportMain;
    PreviewToolBar previewToolBar;
    Component previewPanel;
    Viewer viewer;

    public PreviewPanel(ReportMain reportMain) {
        this.reportMain = reportMain;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPreviewToolBar(), "North");
        this.add(this.getPreviewPanel(), "Center");
    }

    private Component getPreviewPanel() {
        this.viewer = new Viewer();
        this.viewer.setReportMain(this.reportMain);
        Component component = this.previewPanel = this.reportMain.report == null ? new JPanel() : this.viewer.getComponent(this.reportMain.report);
        if (this.getReportCanvas() != null) {
            this.viewer.setToolBarMenuVisible(false);
        }
        return this.previewPanel;
    }

    public PreviewToolBar getPreviewToolBar() {
        if (this.previewToolBar != null) {
            return this.previewToolBar;
        }
        this.previewToolBar = new PreviewToolBar(this.reportMain);
        this.previewToolBar.setEnabled(false);
        return this.previewToolBar;
    }

    void updatePanel() {
        try {
            this.getReportCanvas();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get report canvas", ex);
        }
        if (!this.reportMain.isUpdateReport()) {
            return;
        }
        this.remove(this.previewPanel);
        this.add(this.getPreviewPanel(), "Center");
        try {
            this.previewToolBar.resetZoom();
            this.previewToolBar.setEnabled();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to reset zoom or enable toolbar", ex);
        }
    }

    ReportCanvas getReportCanvas() {
        if (this.viewer == null) {
            return null;
        }
        ReportCanvas canvas = this.viewer.getReportCanvas();
        if (canvas != null) {
            canvas.setBrowseDirectories(this.reportMain.getBrowseDirectories());
            canvas.setFromDesigner(true, this.reportMain.isCm);
        }
        return canvas;
    }

    boolean isPrevPageEnabled() {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return false;
        }
        return canvas.isPrevPageEnabled() || canvas.isPrevSectionEnabled();
    }

    public boolean isNextPageEnabled() {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return false;
        }
        return canvas.isNextPageEnabled() || canvas.isNextSectionEnabled();
    }

    public boolean isGotoEnabled() {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return false;
        }
        return canvas.isGotoEnabled();
    }

    public void goToFirstPage() {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return;
        }
        canvas.setPage(1);
        canvas.setSection(1);
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToLastPage() {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return;
        }
        canvas.setPage(canvas.getTotalPages());
        canvas.setSection(canvas.getTotalSections());
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToFirstPage2() {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return;
        }
        canvas.setPage(1);
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToLastPage2() {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return;
        }
        canvas.setPage(canvas.getTotalPages());
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToPreviousAvailPage() {
        if (!this.isPrevPageEnabled()) {
            return;
        }
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas.getSection() == 1) {
            canvas.setSection(canvas.getTotalSections());
            canvas.setPage(canvas.getPage() - 1);
        } else {
            canvas.setSection(canvas.getSection() - 1);
        }
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToPageSection(int page, int section) {
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas == null) {
            return;
        }
        canvas.setPage(page);
        canvas.setSection(section);
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToNextAvailPage() {
        if (!this.isNextPageEnabled()) {
            return;
        }
        ReportCanvas canvas = this.getReportCanvas();
        if (canvas.getSection() == canvas.getTotalSections()) {
            canvas.setSection(1);
            canvas.setPage(canvas.getPage() + 1);
        } else {
            canvas.setSection(canvas.getSection() + 1);
        }
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToPreviousPage() {
        if (!this.isPrevPageEnabled()) {
            return;
        }
        ReportCanvas canvas = this.getReportCanvas();
        canvas.setPage(canvas.getPage() - 1);
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goToNextPage() {
        if (!this.isNextPageEnabled()) {
            return;
        }
        ReportCanvas canvas = this.getReportCanvas();
        canvas.setPage(canvas.getPage() + 1);
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void goTo() {
        new GoToDialog(this.reportMain).setVisible(true);
        this.previewToolBar.setEnabled(true);
    }

    public void goTo(String pageStr) {
        ReportCanvas canvas = this.getReportCanvas();
        int page = canvas.getPage();
        int section = 1;
        String msg = null;
        try {
            page = Integer.parseInt(pageStr);
            if (page <= 0) {
                page = 1;
            }
            if (page > canvas.getTotalPages()) {
                page = canvas.getTotalPages();
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Page field: Invalid number", ex);
            msg = LanguageEncoder.getText("Page Field : Integer Only!");
        }
        if (msg != null) {
            new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Error"), msg);
            return;
        }
        canvas.setPage(page);
        canvas.setSection(section);
        canvas.repaint();
        this.previewToolBar.setEnabled(true);
    }

    public void zoom(double factor) {
        ReportCanvas canvas = this.getReportCanvas();
        canvas.zoom(factor);
        canvas.repaint();
    }

    public int getTotalPages() {
        ReportCanvas canvas = this.getReportCanvas();
        return canvas.getTotalPages();
    }

    public int getCurrentPage() {
        ReportCanvas canvas = this.getReportCanvas();
        return canvas.getPage();
    }
}

