/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;

public class PreviewToolBar
extends JToolBar
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(PreviewToolBar.class.getName());
    private ReportMain reportMain;
    private JButton prevButton;
    private JButton nextButton;
    private JButton saveBt;
    private JButton exportBt;
    private JButton printBt;
    private JButton firstBt;
    private JButton gotoBt;
    private JButton lastBt;
    private JButton refreshBt;
    private JButton launchBt;
    private JComboBox zoom;
    private JTextField pageField;
    private JLabel totalPagesLbl;

    public PreviewToolBar(ReportMain reportMain) {
        this.setFloatable(false);
        this.reportMain = reportMain;
        this.setBorder(new TitledBorder(""));
        this.saveBt = new JButton();
        this.addNewButton(this.saveBt, LanguageEncoder.getText("Save"), "SAVE", "SaveIcon.png");
        this.exportBt = new JButton();
        if (!reportMain.isSaas()) {
            this.addNewButton(this.exportBt, LanguageEncoder.getText("Export"), "EXPORT", "ExportIcon.png");
        }
        if (ServerMessage.useServer) {
            this.launchBt = new JButton();
            this.addNewButton(this.launchBt, LanguageEncoder.getText("Launch PageViewer"), "LAUNCHPAGEVIEWER", "LaunchPageViewerIcon.png");
        }
        this.printBt = new JButton();
        this.addNewButton(this.printBt, LanguageEncoder.getText("Print"), "PRINT", "PrintIcon.png");
        this.addSeparator();
        this.refreshBt = new JButton();
        this.addNewButton(this.refreshBt, LanguageEncoder.getText("Refresh"), "REFRESH", "RefreshIcon.png");
        this.firstBt = new JButton();
        this.addNewButton(this.firstBt, LanguageEncoder.getText("First Page"), "FIRST", "FirstIcon.png");
        this.prevButton = new JButton();
        this.prevButton.setMnemonic(33);
        this.addNewButton(this.prevButton, LanguageEncoder.getText("Previous Page"), "PREVIOUS", "PreviousIcon.png");
        this.pageField = new JTextField("1", 4);
        this.pageField.setHorizontalAlignment(4);
        this.pageField.addActionListener(this);
        this.pageField.setActionCommand("GOTO");
        JPanel pagePanel = new JPanel();
        pagePanel.setLayout(new FlowLayout(1));
        pagePanel.add(new JLabel(LanguageEncoder.getText("Page")));
        pagePanel.add(this.pageField);
        pagePanel.add(new JLabel(" " + LanguageEncoder.getText("of")));
        this.totalPagesLbl = new JLabel("1");
        pagePanel.add(this.totalPagesLbl);
        pagePanel.setMaximumSize(new Dimension(165, 40));
        pagePanel.setMinimumSize(new Dimension(165, 40));
        this.gotoBt = new JButton();
        pagePanel.add(this.createNewButton(this.gotoBt, LanguageEncoder.getText("Go To ..."), "GOTO", "GoToIcon.png"));
        this.add(pagePanel);
        this.nextButton = new JButton();
        this.nextButton.setMnemonic(34);
        this.addNewButton(this.nextButton, LanguageEncoder.getText("Next Page"), "NEXT", "NextIcon.png");
        this.lastBt = new JButton();
        this.addNewButton(this.lastBt, LanguageEncoder.getText("Last Page"), "LAST", "LastIcon.png");
        this.addSeparator();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel(LanguageEncoder.getText("Zoom:")));
        this.zoom = new JComboBox<String>(new String[]{"25%", "50%", "75%", "100%", "150%", "200%"});
        this.zoom.setSelectedIndex(3);
        this.zoom.addItemListener(this);
        panel.add(this.zoom);
        this.add(panel);
        this.setEnabled();
    }

    private void addNewButton(JButton newBtn, String tip, String command, String img) {
        this.add(this.createNewButton(newBtn, tip, command, img));
    }

    private JButton createNewButton(JButton newBtn, String tip, String command, String img) {
        img = ServerMessage.reportImagesPath + img;
        try {
            this.setIcon(newBtn, img);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading icon: " + img, e);
        }
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
        return newBtn;
    }

    private void setIcon(AbstractButton b, String img) throws MalformedURLException {
        b.setIcon(IOUtil.getImageIcon(img));
    }

    @Override
    public void setEnabled(boolean b) {
        if (!b) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.gotoBt.setEnabled(false);
            this.pageField.setEnabled(false);
        } else {
            this.setEnabled();
        }
        this.saveBt.setEnabled(b);
        this.exportBt.setEnabled(b);
        if (ServerMessage.useServer) {
            this.launchBt.setEnabled(b);
        }
        this.firstBt.setEnabled(b);
        this.lastBt.setEnabled(b);
        this.refreshBt.setEnabled(b);
        if (b && ServerMessage.getApplet() == null) {
            this.printBt.setEnabled(true);
        } else {
            this.printBt.setEnabled(false);
        }
        this.setToolbarForSTL();
    }

    public void setEnabled() {
        if (this.reportMain.previewPanel == null) {
            return;
        }
        if (this.reportMain.previewPanel.getReportCanvas() == null) {
            return;
        }
        this.pageField.setText(this.reportMain.previewPanel.getCurrentPage() + "");
        this.totalPagesLbl.setText(this.reportMain.previewPanel.getTotalPages() + "");
        this.prevButton.setEnabled(this.reportMain.previewPanel.isPrevPageEnabled());
        this.nextButton.setEnabled(this.reportMain.previewPanel.isNextPageEnabled());
        this.gotoBt.setEnabled(this.reportMain.previewPanel.isGotoEnabled());
        this.pageField.setEnabled(this.reportMain.previewPanel.isGotoEnabled());
        this.setToolbarForSTL();
    }

    public void setToolbarForSTL() {
        if (!this.reportMain.getTitle().toUpperCase().endsWith(".STL")) {
            return;
        }
        if (this.launchBt != null) {
            this.launchBt.setEnabled(false);
        }
        if (this.exportBt != null) {
            this.exportBt.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.reportMain.isDesignMode = false;
        String command = e.getActionCommand();
        if (command.equals("FIRST")) {
            this.reportMain.previewPanel.goToFirstPage();
        } else if (command.equals("PREVIOUS")) {
            this.reportMain.previewPanel.goToPreviousAvailPage();
        } else if (command.equals("NEXT")) {
            this.reportMain.previewPanel.goToNextAvailPage();
        } else if (command.equals("LAST")) {
            this.reportMain.previewPanel.goToLastPage();
        } else if (command.equals("GOTO")) {
            this.reportMain.previewPanel.goTo(this.pageField.getText());
        } else if (command.equals("SAVE")) {
            this.reportMain.saveFromReportDesigner();
        } else if (command.equals("EXPORT")) {
            this.reportMain.export();
        } else if (command.equals("REFRESH")) {
            this.reportMain.do_Refresh();
        } else if (command.equals("PRINT")) {
            this.reportMain.printReport();
        } else if (command.equals("LAUNCHPAGEVIEWER")) {
            this.reportMain.launchPageViewer();
        } else {
            LOGGER.warning("Invalid command: " + command);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (e.getStateChange() == 1 && obj instanceof JComboBox) {
            Object item = ((JComboBox)obj).getSelectedItem();
            try {
                double zoom;
                String text = item.toString().trim();
                if (text.endsWith("%")) {
                    text = text.substring(0, text.length() - 1);
                }
                if ((zoom = Double.parseDouble(text)) > 1.0) {
                    zoom /= 100.0;
                }
                if (zoom < 0.2) {
                    zoom = 0.2;
                }
                if (zoom > 2.0) {
                    zoom = 2.0;
                }
                this.reportMain.previewPanel.zoom(zoom);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to perform action", ex);
            }
        }
    }

    void resetZoom() {
        this.zoom.setSelectedIndex(3);
    }
}

