/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;

public class PrintOnNewPageDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(PrintOnNewPageDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    ReportMain reportMain;
    JCheckBox setPrintOnNewPage;
    JTextField rowCount;
    ReportTable table;

    public PrintOnNewPageDialog(ReportMain reportMain, ReportTable table) {
        super(reportMain, LanguageEncoder.getText("Set Print On New Page ..."), true);
        this.reportMain = reportMain;
        this.table = table;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel upperPanel = new JPanel();
        upperPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Print On New Page")));
        upperPanel.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        this.setPrintOnNewPage = new JCheckBox(LanguageEncoder.getText("Set print on new page"), this.table.isPrintOnNewPage());
        p1.add(this.setPrintOnNewPage);
        this.setPrintOnNewPage.addItemListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        p2.add(new JLabel(LanguageEncoder.getText("Row count per page")));
        this.rowCount = new JTextField(3);
        p2.add(this.rowCount);
        this.rowCount.setEnabled(this.table.isPrintOnNewPage());
        this.rowCount.setText(this.table.getPrintOnNewPageRowCount() + "");
        upperPanel.add("Center", p1);
        upperPanel.add("South", p2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", upperPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.setPrintOnNewPage && this.rowCount != null) {
            this.rowCount.setEnabled(this.setPrintOnNewPage.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.table.setPrintOnNewPage(this.setPrintOnNewPage.isSelected());
            if (this.setPrintOnNewPage.isSelected()) {
                try {
                    int count = Integer.parseInt(this.rowCount.getText());
                    this.table.setPrintOnNewPageRowCount(count);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Row count: Invalid number", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Integer only"));
                }
            }
            this.setVisible(false);
            this.dispose();
            this.reportMain.setModified(true);
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

