/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import quadbase.chart.designer.IChartIO;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.DataSourceManagerListener;
import quadbase.datasourcemanager.manager.IImportQRYFile;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.reportdesigner.designer.IByPassSaveAsForReport;
import quadbase.reportdesigner.designer.IChartHandle;
import quadbase.reportdesigner.designer.IDrillDownReportIO;
import quadbase.reportdesigner.designer.IReportIO;
import quadbase.reportdesigner.designer.ImagesPath;
import quadbase.reportdesigner.designer.ReportClient;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.ICustomDefinedFunctions;
import quadbase.reportdesigner.util.IDBProvider;

public class QbReportDesigner {
    private static final Logger LOGGER = Logger.getLogger(QbReportDesigner.class.getName());
    private static LookAndFeel lookAndFeel = null;
    private ReportMain reportMain;
    private boolean openFile = false;
    private boolean init = false;
    private boolean newReport = false;
    private boolean exitOnCancel = false;
    private String userName = "";
    private String password = "";
    private boolean isLogin = false;
    public static final int SAVE_RPT_BEFORE_DRILLDOWN = 1;
    public static final int SAVE_RPT_BEFORE_SUBREPORT = 2;
    public static final int SAVE_RPT_BEFORE_PAGEVIEWER = 3;

    public QbReportDesigner(Object parent, ReportMain reportMain) {
        this.reportMain = reportMain;
        this.init = true;
    }

    public QbReportDesigner(Object parent) {
        this(parent, (String)null);
    }

    public QbReportDesigner(Object parent, String rptFile) {
        this(parent, rptFile, -1);
    }

    public QbReportDesigner(Object parent, String rptFile, int displayRow) {
        this(parent, rptFile, displayRow, (ImagesPath)null);
    }

    public QbReportDesigner(Object parent, String rptFile, int displayRow, String[] imagesPath) {
        this(parent, rptFile, displayRow, ImagesPath.createImagesPath(imagesPath));
    }

    public QbReportDesigner(Object parent, String rptFile, int displayRow, ImagesPath imagesPath) {
        if (imagesPath != null) {
            ServerMessage.reportImagesPath = imagesPath.getReportImagesPath();
            ServerMessage.imagesPath = imagesPath.getChartImagesPath();
            ServerMessage.backgroundImagesPath = imagesPath.getBackgroundImagesPath();
        }
        if (ServerMessage.getParent() == null) {
            this.setLookAndFeel();
            ServerMessage.useServer = true;
            ServerMessage.setParent(parent);
        }
        this.startProgram();
        if (this.reportMain == null) {
            return;
        }
        if (rptFile != null && this.reportMain.openFile(null, rptFile)) {
            this.openFile = true;
            this.reportMain.menuBar.setMenuEnabled(true);
            this.reportMain.designPanel.designToolBar.setEnabled(true);
            this.reportMain.designPanel.designToolBar2.setEnabled(true);
            this.reportMain.previewPanel.previewToolBar.setEnabled(true);
        }
        this.reportMain.setDisplayRow(displayRow);
        this.reportMain.displayRowState = this.reportMain.DISPLAY_ROW_CHANGED;
    }

    public QbReportDesigner(Object parent, DBInfoBasic dbInfo, boolean newReport) {
        this(parent, dbInfo, null, newReport, -1);
    }

    public QbReportDesigner(Object parent, DBInfoBasic dbInfo, boolean newReport, int displayRow) {
        this(parent, dbInfo, null, newReport, displayRow);
    }

    public QbReportDesigner(Object parent, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newReport) {
        this(parent, dbInfo, inSet, newReport, -1);
    }

    public QbReportDesigner(Object parent, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newReport, int displayRow) {
        this(parent, dbInfo, inSet, newReport, -1, (ImagesPath)null);
    }

    public QbReportDesigner(Object parent, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newReport, int displayRow, String[] imagesPath) {
        this(parent, dbInfo, inSet, newReport, displayRow, ImagesPath.createImagesPath(imagesPath));
    }

    public QbReportDesigner(Object parent, String classFile, QueryInParamSet inSet, boolean newReport, int displayRow, String[] imagesPath) {
        this(parent, null, classFile, inSet, newReport, displayRow, ImagesPath.createImagesPath(imagesPath));
    }

    public QbReportDesigner(Object parent, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newReport, int displayRow, ImagesPath imagesPath) {
        this(parent, dbInfo, null, inSet, newReport, displayRow, imagesPath);
    }

    private QbReportDesigner(Object parent, DBInfoBasic dbInfo, String classFile, QueryInParamSet inSet, boolean newReport, int displayRow, ImagesPath imagesPath) {
        if (imagesPath != null) {
            ServerMessage.reportImagesPath = imagesPath.getReportImagesPath();
            ServerMessage.imagesPath = imagesPath.getChartImagesPath();
            ServerMessage.backgroundImagesPath = imagesPath.getBackgroundImagesPath();
        }
        if (ServerMessage.getParent() == null) {
            this.setLookAndFeel();
            ServerMessage.useServer = true;
            ServerMessage.setParent(parent);
        }
        this.startProgram();
        if (this.reportMain == null) {
            return;
        }
        this.reportMain.setPresetDBInfo(dbInfo);
        this.reportMain.setPresetClassFile(classFile);
        this.reportMain.setPresetQueryInParamSet(inSet);
        this.reportMain.setDisplayRow(displayRow);
        this.reportMain.displayRowState = this.reportMain.DISPLAY_ROW_CHANGED;
        this.newReport = newReport;
    }

    public QbReportDesigner(Object parent, String dataRegistry, boolean newReport) {
        this(parent, dataRegistry, newReport, -1);
    }

    public QbReportDesigner(Object parent, String dataRegistry, boolean newReport, int displayRow) {
        this(parent, dataRegistry, newReport, -1, (ImagesPath)null);
    }

    public QbReportDesigner(Object parent, String dataRegistry, boolean newReport, int displayRow, String[] imagesPath) {
        this(parent, dataRegistry, newReport, displayRow, ImagesPath.createImagesPath(imagesPath));
    }

    public QbReportDesigner(Object parent, String dataRegistry, boolean newReport, int displayRow, ImagesPath imagesPath) {
        if (imagesPath != null) {
            ServerMessage.reportImagesPath = imagesPath.getReportImagesPath();
            ServerMessage.imagesPath = imagesPath.getChartImagesPath();
            ServerMessage.backgroundImagesPath = imagesPath.getBackgroundImagesPath();
        }
        this.setLookAndFeel();
        ServerMessage.useServer = true;
        ServerMessage.setParent(parent);
        this.startProgram();
        if (this.reportMain == null) {
            return;
        }
        this.reportMain.setPresetDataRegistry(dataRegistry);
        this.reportMain.setDisplayRow(displayRow);
        this.reportMain.displayRowState = this.reportMain.DISPLAY_ROW_CHANGED;
        this.newReport = newReport;
    }

    public void setDataRegistry(String dataRegistry) {
        this.reportMain.setPresetDataRegistry(dataRegistry);
    }

    public static void setLookAndFeel(LookAndFeel newLookAndFeel) {
        lookAndFeel = newLookAndFeel;
    }

    public static LookAndFeel getLookAndFeel() {
        return lookAndFeel;
    }

    void setLookAndFeel() {
        LookAndFeel lnf = QbReportDesigner.getLookAndFeel();
        if (lnf != null) {
            try {
                UIManager.setLookAndFeel(lnf);
                return;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Failed to set UI look and feel", e);
            }
        }
        QbUtil.setWindowsLAF();
    }

    public static void setDebugMode(String mode) {
        QbDebug.setDebugMode(mode);
    }

    public static void setDebugMode(int mode) {
        QbDebug.setDebugMode(mode);
    }

    private void startProgram() {
        try {
            this.reportMain = new ReportMain(false);
            this.reportMain.setLoginUser(this.userName);
            this.reportMain.setQbReportDesigner(this);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Cannot start program", ex);
            JOptionPane.showMessageDialog(ServerMessage.getApplet(), ex.toString(), LanguageEncoder.getText("Error"), 0);
        }
    }

    public JFrame getDesigner() {
        if (!this.isLogin()) {
            return null;
        }
        if (!this.openFile && !this.init) {
            ReportWizard wizard = new ReportWizard(this.reportMain, this.reportMain.getPresetDBInfo(), this.reportMain.getPresetClassFile(), this.reportMain.getPresetQueryInParamSet(), this.newReport, this.exitOnCancel, false);
            wizard.init();
            if (!this.newReport || this.reportMain.getPresetDBInfo() != null || this.reportMain.getPresetClassFile() != null) {
                wizard.setVisible(true);
            }
            this.init = true;
        }
        return this.reportMain;
    }

    public void setVisible(boolean b) {
        if (!this.isLogin()) {
            return;
        }
        this.reportMain.setVisible(b);
        if (b && !this.openFile && !this.init) {
            ReportWizard wizard = new ReportWizard(this.reportMain, this.reportMain.getPresetDBInfo(), this.reportMain.getPresetClassFile(), this.reportMain.getPresetQueryInParamSet(), this.newReport, this.exitOnCancel, false);
            wizard.init();
            if (!this.newReport || this.reportMain.getPresetDBInfo() != null || this.reportMain.getPresetClassFile() != null) {
                wizard.setVisible(true);
            }
            wizard.toFront();
            this.init = true;
        }
    }

    public void login(String userName, String password) {
        if (userName != null) {
            this.userName = userName;
        }
        if (password != null) {
            this.password = password;
        }
    }

    public void login(String designerPassword) {
        this.login("", designerPassword);
    }

    boolean isLogin() {
        if (this.isLogin) {
            return true;
        }
        String errStr = null;
        try {
            errStr = ReportMain.addUser(this.userName, this.password, false, true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to add user", ex);
            errStr = ex.toString();
        }
        if (errStr != null) {
            JOptionPane.showMessageDialog(ServerMessage.getFrame(), errStr, LanguageEncoder.getText("Error"), 0);
            return false;
        }
        this.isLogin = true;
        return true;
    }

    public void dispose() {
        this.reportMain.dispose();
    }

    public void setReportIO(IReportIO rptIO) {
        this.reportMain.setReportIO(rptIO);
    }

    public void setByPassSaveAsIO(IByPassSaveAsForReport saveAsIO) {
        this.reportMain.setByPassSaveAs(saveAsIO);
    }

    public void setDrillDownReportIO(IDrillDownReportIO drptIO) {
        this.reportMain.setDrillDownReportIO(drptIO);
    }

    public void setChartDesignerHandle(IChartHandle cdHandle) {
        this.reportMain.setChartHandle(cdHandle);
    }

    public void modifyWarningMessage(int modifiedMsg, String newMessage) {
        if (modifiedMsg == 1) {
            ReportMain.saveRptBeforeDrill = newMessage;
        } else if (modifiedMsg == 2) {
            ReportMain.saveRptBeforeSub = newMessage;
        } else if (modifiedMsg == 3) {
            ReportMain.saveRptBeforePage = newMessage;
        }
    }

    public JMenuBar getReportMenuBar() {
        return this.reportMain.getReportMenuBar();
    }

    public JToolBar getDesignerToolBar() {
        return this.reportMain.getDesignPanel().getDesignToolBar();
    }

    public JToolBar getDesignerToolBar2() {
        return this.reportMain.getDesignPanel().getDesignToolBar2();
    }

    public JToolBar getPreviewToolBar() {
        return this.reportMain.getPreviewPanel().getPreviewToolBar();
    }

    public void setSaveOnExitEnabled(boolean b) {
        this.reportMain.setSaveOnExitEnabled(b);
    }

    public boolean isSaveOnExitEnabled() {
        return this.reportMain.isSaveOnExitEnabled();
    }

    public void saveAs() {
        this.reportMain.saveAs();
    }

    public void save() {
        this.reportMain.save();
    }

    public void save(String fileLocation) {
        this.reportMain.save(fileLocation);
    }

    public void writeFile(String filename, byte[] content) throws Exception {
        this.reportMain.writeFile(filename, content);
    }

    public void setDisplayRow(int nRow) {
        this.reportMain.setDisplayRow(nRow);
        this.reportMain.displayRowState = this.reportMain.DISPLAY_ROW_CHANGED;
    }

    public void setRootDirectoryForBrowse(String browseRoot) {
        BrowseDialog.setPresetDirectory(browseRoot);
        BrowseDialog.setGoUpEnabled(ServerMessage.isAdmin());
    }

    public BrowseDirectories getBrowseDirectories() {
        return this.reportMain.getBrowseDirectories();
    }

    public void setDirectoryBrowseUpEnabled(boolean state) {
        BrowseDialog.setGoUpEnabled(state);
    }

    public boolean isDirectoryBrowseUpEnabled() {
        return BrowseDialog.isGoUpEnabled();
    }

    public void setDBProvider(IDBProvider provider) {
        this.reportMain.setDBProvider(provider);
    }

    public boolean exit() throws Exception {
        return this.reportMain.softExit();
    }

    public void setExitOnCancel(boolean state) {
        this.exitOnCancel = state;
    }

    public boolean isExitOnCancel() {
        return this.exitOnCancel;
    }

    public void setForceNewReport(boolean state) {
        this.reportMain.setForceNewReport(state);
    }

    public boolean isForceNewReport() {
        return this.reportMain.isForceNewReport();
    }

    public void setDefaultParamNames(String[] names) {
        this.reportMain.setDefaultParamNames(names);
        this.reportMain.setDefaultValueRequiredForParameters(true);
    }

    public String[] getDefaultParamNames() {
        return this.reportMain.getDefaultParamNames();
    }

    public void addDataSourceManagerListener(DataSourceManagerListener listener) {
        this.reportMain.addDataSourceManagerListener(listener);
    }

    public void removeDataSourceManagerListener(DataSourceManagerListener listener) {
        this.reportMain.removeDataSourceManagerListener(listener);
    }

    public void setCustomDefinedFunctions(ICustomDefinedFunctions f) {
        Report.setCustomDefinedFunctions(f);
    }

    public ICustomDefinedFunctions getCustomDefinedFunctions() {
        return Report.getCustomDefinedFunctions();
    }

    public void setImportQRYFile(IImportQRYFile f) {
        Manager.setImportQRYFile(f);
    }

    public IImportQRYFile getImportQRYFile() {
        return Manager.getImportQRYFile();
    }

    public void setChartMenuItemEnabled(int menu, int item, boolean enabled) {
        this.reportMain.setChartMenuItemEnabled(menu, item, enabled);
    }

    public void setChartMenuEnabled(int menu, boolean enabled) {
        this.reportMain.setChartMenuEnabled(menu, enabled);
    }

    public void setChartToolbarEnabled(int button, boolean enabled) {
        this.reportMain.setChartToolbarItemEnabled(button, enabled);
    }

    public void disableChartDataSource() {
        this.reportMain.disableChartDataSource = true;
    }

    public void setChartIO(IChartIO chartIO) {
        this.reportMain.setChartIO(chartIO);
    }

    public static void setMetricSystemUsed(boolean useMetric) {
        ReportClient.isMetricSystem = useMetric;
    }

    public static boolean isMetricSystemUsed() {
        return ReportClient.isMetricSystem;
    }

    public void setSkipQueryResultStep(boolean b) {
        this.reportMain.setSkipQueryResultStep(b);
    }

    public boolean isSkipQueryResultStep() {
        return this.reportMain.isSkipQueryResultStep();
    }

    public void setSkipMultiDataSourceStep(boolean b) {
        this.reportMain.setSkipMultiDataSourceStep(b);
    }

    public boolean isSkipMultiDataSourceStep() {
        return this.reportMain.isSkipMultiDataSourceStep();
    }

    public void setSkipPredefinedTemplatesStep(boolean b) {
        this.reportMain.setSkipPredefinedTemplatesStep(b);
    }

    public boolean isSkipPredefinedTemplatesStep() {
        return this.reportMain.isSkipPredefinedTemplatesStep();
    }

    public void setSecurityLevel(String level) {
        this.reportMain.setSecurityLevel(level);
    }

    public String getSecurityLevel() {
        return this.reportMain.getSecurityLevel();
    }

    @Deprecated
    public void setTemplatesDirectory(String temp_dir) {
        this.reportMain.setTemplatesDirectory(temp_dir);
    }

    @Deprecated
    public String getTemplatesDirectory() {
        return this.reportMain.getTemplatesDirectory();
    }

    public static void setServerAddress(String address) throws UnknownHostException {
        ServerMessage.setAddress(address);
    }

    public static void setServerPortNumber(int port) {
        ServerMessage.setPortNumber(port);
    }

    public static void setServerHosts(Vector hostnames) {
        ServerMessage.setHosts(hostnames);
    }

    public static void setServletRunner(String comm_url) {
        ServerMessage.setConnectServlet(comm_url);
    }

    public static void useServlet(boolean b) {
        if (b) {
            ServerMessage.useServlet();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static void setServletContext(String context) {
        ServerMessage.setServletContext(context);
    }

    public static String getServletContext() {
        return ServerMessage.getServletContext();
    }

    public void setSysExitOnExit(boolean state) {
        this.reportMain.setSysExitOnExit(state);
    }

    public boolean sysExitOnExit() {
        return this.reportMain.sysExitOnExit();
    }

    public static void setUseSysResourceImages(boolean state) {
        ServerMessage.useSysResourceImages = state;
    }

    public static boolean useSysResourceImages() {
        return ServerMessage.useSysResourceImages;
    }

    public JTabbedPane getDesignerTabbedPane() {
        return this.reportMain.reportDesignerPane;
    }

    public void setPathRelativeToERES(String path) {
        if (this.reportMain != null) {
            this.reportMain.relativeDomainPath = path;
        }
    }

    public void loadFile(String reportFileName) {
        this.loadFile(reportFileName, true);
    }

    public void loadFile(String reportFileName, boolean repaint) {
        if (this.reportMain != null) {
            this.openFile = this.reportMain.loadFile(null, reportFileName, reportFileName);
        }
        if (this.openFile && repaint) {
            this.reportMain.setVisible(true);
            this.reportMain.repaint();
        }
    }

    public static void setBrowseRootDirectory(String browseRootDir) {
        BrowseDialog.setPresetDirectory(browseRootDir);
        BrowseDialog.setGoUpEnabled(ServerMessage.isAdmin());
    }

    public static void setServletHttpHeader(String headerName, String headerValue) {
        ServerMessage.setExtraServletHeader(headerName, headerValue);
    }
}

