/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import quadbase.common.util.internal.DataType;
import quadbase.reportdesigner.report.ColData;

public class QueryResultPanel
extends JPanel {
    JScrollPane scroller;

    public QueryResultPanel(ColData[] colData) {
        this(colData, colData[0].getSize());
    }

    public QueryResultPanel(ColData[] colData, int rowNo) {
        int i;
        int actualSize = colData[0].getSize();
        if (rowNo > actualSize) {
            rowNo = actualSize;
        }
        int fieldNo = colData.length - 1;
        Object[] name = new String[fieldNo + 1];
        Object[][] data = new String[rowNo + 1][fieldNo + 1];
        name[0] = "INDEX";
        for (i = 1; i <= fieldNo; ++i) {
            name[i] = colData[i - 1].getName().trim();
        }
        data[0][0] = "TYPE";
        for (i = 1; i <= fieldNo; ++i) {
            data[0][i] = DataType.getTypeName(colData[i - 1].getOriginalDataType());
        }
        for (int i2 = 1; i2 <= rowNo; ++i2) {
            data[i2][0] = i2 + "";
            for (int j = 1; j <= fieldNo; ++j) {
                Object obj = colData[j - 1].getData(i2 - 1);
                data[i2][j] = obj != null ? obj.toString().trim() : "null";
            }
        }
        JTable table = new JTable(data, name);
        table.setGridColor(Color.lightGray);
        table.setCellSelectionEnabled(true);
        table.getTableHeader().setReorderingAllowed(false);
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        DefaultCellEditor noEditor = new DefaultCellEditor(notEditableField);
        table.setCellEditor(noEditor);
        MyRenderer myRenderer = new MyRenderer();
        for (int i3 = 0; i3 < table.getColumnCount(); ++i3) {
            table.getColumnModel().getColumn(i3).setCellRenderer(myRenderer);
            table.getColumnModel().getColumn(i3).setCellEditor(noEditor);
        }
        table.setAutoResizeMode(0);
        this.scroller = new JScrollPane();
        this.scroller.getViewport().add(table);
        this.scroller.getViewport().setBackground(table.getBackground());
        this.setLayout(new BorderLayout());
        this.add("Center", this.scroller);
    }

    private class MyRenderer
    implements TableCellRenderer {
        private JTextField text = new JTextField("TEMP");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == 0 || column == 0) {
                return new JButton(value.toString());
            }
            JLabel label = new JLabel(value.toString());
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(this.text.getSelectionColor());
                label.setForeground(this.text.getSelectedTextColor());
            } else {
                label.setBackground(table.getBackground());
                label.setForeground(table.getForeground());
            }
            return label;
        }
    }
}

