/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class RTFColumnsDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(RTFColumnsDialog.class.getName());
    private int columnCount = 1;
    private double colSpacing = 0.25;
    private JTextField countField;
    private JTextField spaceField;
    private boolean modified = false;

    public RTFColumnsDialog(JDialog parent, int colCount, double colspace) {
        super(parent, "Columns...", true);
        this.columnCount = colCount;
        this.colSpacing = colspace;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel topPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        topPanel.setLayout(gbl);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 5, 5);
        JLabel comp = new JLabel(LanguageEncoder.getText("Number of columns (1 - 4):"));
        gbl.setConstraints(comp, gbc);
        topPanel.add(comp);
        gbc.weightx = 20.0;
        gbc.gridx = 1;
        gbc.insets = new Insets(10, 5, 5, 10);
        this.countField = new JTextField(this.columnCount + "", 10);
        Dimension d = this.countField.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.countField.setMinimumSize(d);
        gbl.setConstraints(this.countField, gbc);
        topPanel.add(this.countField);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 10, 20, 5);
        comp = new JLabel(LanguageEncoder.getText("Spacing between Columns (inches):"));
        gbl.setConstraints(comp, gbc);
        topPanel.add(comp);
        gbc.weightx = 20.0;
        gbc.gridx = 1;
        gbc.insets = new Insets(5, 5, 20, 10);
        this.spaceField = new JTextField(this.colSpacing + "", 10);
        d = this.countField.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.spaceField.setMinimumSize(d);
        gbl.setConstraints(this.spaceField, gbc);
        topPanel.add(this.spaceField);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        JButton b = new JButton(LanguageEncoder.getText("OK"));
        b.setActionCommand("OK");
        b.addActionListener(this);
        bottomPanel.add(b);
        b = new JButton(LanguageEncoder.getText("Cancel"));
        b.setActionCommand("Cancel");
        b.addActionListener(this);
        bottomPanel.add(b);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)topPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        int x = (screenSize.width - dim.width) / 2;
        int y = (screenSize.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
        this.setSize(dim);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("OK")) {
            String string = this.countField.getText();
            try {
                int colcount = Integer.parseInt(string);
                if (colcount < 1 || colcount > 4) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Number of columns: Invalid number", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Number of columns must be an integer between 1 and 4."));
                return;
            }
            string = this.spaceField.getText();
            try {
                double space = Double.parseDouble(string);
                if (space < 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Column spacing: Invalid number", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Column spacing must be a non-negative number."));
                return;
            }
            this.modified = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getColumnCount() {
        String string = this.countField.getText();
        try {
            int colcount = Integer.parseInt(string);
            if (colcount < 1 || colcount > 4) {
                throw new Exception();
            }
            return colcount;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Column count: Invalid number. Must be an integer between 1 and 4", ex);
            return 1;
        }
    }

    public double getColumnSpacing() {
        String string = this.spaceField.getText();
        try {
            double space = Double.parseDouble(string);
            if (space < 0.0) {
                throw new Exception();
            }
            return space;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Column spacing: Invalid number", ex);
            return 0.25;
        }
    }
}

