/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ColorRenderer;
import quadbase.reportdesigner.designer.FormatDialog;
import quadbase.reportdesigner.designer.RTFColumnsDialog;
import quadbase.reportdesigner.designer.RTFFormatReplacementDialog;
import quadbase.reportdesigner.designer.RTFImageSizeDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.StringDialog;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.StringFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ImageData;
import quadbase.reportdesigner.util.internal.ImageResample;
import quadbase.reportdesigner.util.rtf.RTFEditorKit;
import quadbase.reportdesigner.util.rtf.RTFStyledDocument;
import quadbase.reportdesigner.util.rtf.RTFUtil;

public class RTFEditorDialog
extends JDialog
implements ActionListener,
CaretListener,
FocusListener,
MenuListener {
    private static final Logger LOGGER = Logger.getLogger(RTFEditorDialog.class.getName());
    private ReportMain reportMain;
    protected JTextPane m_monitor;
    protected StyleContext m_context;
    protected RTFStyledDocument m_doc;
    protected RTFEditorKit m_kit;
    protected JToolBar m_toolBar;
    protected JComboBox m_cbFonts;
    protected JComboBox m_cbSizes;
    protected JToggleButton m_bBold;
    protected JToggleButton m_bItalic;
    private JToggleButton m_bUnderline;
    protected JComboBox m_cbColors;
    protected JComboBox m_cbFormats;
    protected String m_fontName = "";
    protected int m_fontSize = 0;
    private Color m_color = Color.black;
    private String m_format = "None";
    protected boolean m_skipUpdate;
    protected int m_xStart = 0;
    protected int m_xFinish = 0;
    private int caret_pos = -1;
    protected UndoManager m_undo = new UndoManager();
    protected JMenuItem undo;
    protected JMenuItem redo;
    private AttributeSet paste_attributes = null;
    private boolean modified = false;
    private ReportRTFObject rtf_object = null;
    private JMenu editFormatMenu = null;
    private JMenu removeFormatMenu = null;
    private Vector customFormats = new Vector();
    private boolean isAdjustFont = true;

    public RTFEditorDialog(ReportMain parent, ReportRTFObject obj, boolean isAdjustFont) {
        super(parent, LanguageEncoder.getText("Rich Text Field"), true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                RTFEditorDialog.this.actionPerformed(new ActionEvent(this, 1001, "Exit"));
            }
        });
        this.reportMain = parent;
        this.isAdjustFont = isAdjustFont;
        this.m_monitor = new JTextPane();
        this.m_kit = new RTFEditorKit();
        this.m_monitor.setEditorKit(this.m_kit);
        this.m_context = new StyleContext();
        this.m_monitor.addCaretListener(this);
        this.m_monitor.addFocusListener(this);
        JScrollPane ps = new JScrollPane(this.m_monitor);
        this.getContentPane().add((Component)ps, "Center");
        JMenuBar menuBar = this.createMenuBar();
        this.setJMenuBar(menuBar);
        this.rtf_object = obj;
        if (this.rtf_object != null) {
            this.customFormats = this.rtf_object.getFormats();
            byte[] barray = this.rtf_object.getData();
            if (barray != null) {
                this.m_monitor.grabFocus();
                try {
                    this.m_doc = RTFUtil.getDocument(barray, this.rtf_object.getFormatMap());
                    this.m_doc.setAdjustFont(isAdjustFont);
                    this.m_monitor.setDocument(this.m_doc);
                    AttributeSet aSet = this.getCurrentAttributeSet(this.m_doc.getLength() - 1);
                    this.m_monitor.setCaretPosition(this.m_doc.getLength());
                    this.m_xStart = this.m_doc.getEndPosition().getOffset() - 1;
                    this.m_xFinish = this.m_doc.getEndPosition().getOffset() - 1;
                    this.setAttributeSet(aSet);
                    this.m_monitor.setCaretPosition(0);
                    this.m_xStart = 0;
                    this.m_xFinish = 0;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Exception ex) {
                    this.m_doc = null;
                    LOGGER.log(Level.FINE, "Failed to edit rich text field", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to edit rich text field.\n") + ex.toString());
                }
            }
        }
        if (this.m_doc == null) {
            this.m_doc = new RTFStyledDocument(this.m_context, isAdjustFont);
            this.m_monitor.setDocument(this.m_doc);
            SimpleAttributeSet aSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(aSet, "Dialog");
            StyleConstants.setFontSize(aSet, QbUtil.getAdjustedFont(12, isAdjustFont));
            StyleConstants.setForeground(aSet, Color.black);
            aSet.addAttribute("Data Format", LanguageEncoder.getText("None"));
            this.setAttributeSet(aSet);
        }
        Keymap keymap = this.m_monitor.getKeymap();
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 2), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RTFEditorDialog.this.doCopy();
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 2), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RTFEditorDialog.this.doCut();
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 2), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RTFEditorDialog.this.doPaste();
            }
        });
        this.updateFormatComboBox();
        this.showAttributes(0);
        this.m_doc.addUndoableEditListener(new Undoer());
        this.setPosition();
    }

    private void setPosition() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = screenSize.height * 2 / 3;
        dim.width = screenSize.width * 2 / 3;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu mFile = new JMenu(LanguageEncoder.getText("File"));
        JMenuItem menuitem = new JMenuItem(LanguageEncoder.getText("Import File..."));
        menuitem.setActionCommand("Import...");
        menuitem.addActionListener(this);
        mFile.add(menuitem);
        menuitem = new JMenuItem(LanguageEncoder.getText("Insert Image..."));
        menuitem.setActionCommand("Insert Image");
        menuitem.addActionListener(this);
        mFile.add(menuitem);
        mFile.addSeparator();
        menuitem = new JMenuItem(LanguageEncoder.getText("Exit"));
        menuitem.setActionCommand("Exit");
        menuitem.addActionListener(this);
        mFile.add(menuitem);
        JMenu mEdit = new JMenu(LanguageEncoder.getText("Edit"));
        menuitem = new JMenuItem(LanguageEncoder.getText("Copy"));
        menuitem.setActionCommand("Copy");
        menuitem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuitem.addActionListener(this);
        mEdit.add(menuitem);
        menuitem = new JMenuItem(LanguageEncoder.getText("Cut"));
        menuitem.setActionCommand("Cut");
        menuitem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuitem.addActionListener(this);
        mEdit.add(menuitem);
        menuitem = new JMenuItem(LanguageEncoder.getText("Paste"));
        menuitem.setActionCommand("Paste");
        menuitem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuitem.addActionListener(this);
        mEdit.add(menuitem);
        mEdit.addSeparator();
        this.undo = new JMenuItem(LanguageEncoder.getText("Undo"));
        this.undo.setActionCommand("Undo");
        this.undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undo.addActionListener(this);
        mEdit.add(this.undo);
        this.redo = new JMenuItem(LanguageEncoder.getText("Redo"));
        this.redo.setActionCommand("Redo");
        this.redo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redo.addActionListener(this);
        mEdit.add(this.redo);
        JMenu mInsert = new JMenu(LanguageEncoder.getText("Insert"));
        JMenu menu = new JMenu(LanguageEncoder.getText("Column"));
        this.insertMenuColumn(menu);
        mInsert.add(menu);
        menu = new JMenu(LanguageEncoder.getText("Formula"));
        this.insertMenuFormula(menu);
        mInsert.add(menu);
        menu = new JMenu(LanguageEncoder.getText("Parameter"));
        this.insertMenuParameter(menu);
        mInsert.add(menu);
        JMenu mFormat = new JMenu(LanguageEncoder.getText("Format"));
        menu = new JMenu("New");
        menuitem = new JMenuItem(LanguageEncoder.getText("String Format..."));
        menuitem.setActionCommand("String New Format");
        menuitem.addActionListener(this);
        menu.add(menuitem);
        menuitem = new JMenuItem(LanguageEncoder.getText("Logical Format..."));
        menuitem.setActionCommand("Logical New Format");
        menuitem.addActionListener(this);
        menu.add(menuitem);
        menuitem = new JMenuItem(LanguageEncoder.getText("Numeric Format..."));
        menuitem.setActionCommand("Numeric New Format");
        menuitem.addActionListener(this);
        menu.add(menuitem);
        menuitem = new JMenuItem(LanguageEncoder.getText("Time Format..."));
        menuitem.setActionCommand("Time New Format");
        menuitem.addActionListener(this);
        menu.add(menuitem);
        mFormat.add(menu);
        this.editFormatMenu = new JMenu(LanguageEncoder.getText("Edit"));
        this.editFormatMenu.addMenuListener(this);
        mFormat.add(this.editFormatMenu);
        this.removeFormatMenu = new JMenu(LanguageEncoder.getText("Remove"));
        this.removeFormatMenu.addMenuListener(this);
        mFormat.add(this.removeFormatMenu);
        JMenu mOption = new JMenu(LanguageEncoder.getText("Option"));
        menuitem = new JMenuItem(LanguageEncoder.getText("Columns..."));
        menuitem.setActionCommand("Columns");
        menuitem.addActionListener(this);
        mOption.add(menuitem);
        menuitem = new JMenuItem(LanguageEncoder.getText("Resize Image..."));
        menuitem.setActionCommand("Image Size");
        menuitem.addActionListener(this);
        mOption.add(menuitem);
        menuBar.add(mFile);
        menuBar.add(mEdit);
        menuBar.add(mInsert);
        menuBar.add(mFormat);
        menuBar.add(mOption);
        this.m_toolBar = new JToolBar();
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.m_cbFonts = new JComboBox<String>(fontNames);
        this.m_cbFonts.setMaximumSize(this.m_cbFonts.getPreferredSize());
        this.m_cbFonts.setActionCommand("Font Names");
        this.m_cbFonts.addActionListener(this);
        this.m_toolBar.add(this.m_cbFonts);
        this.m_toolBar.addSeparator();
        this.m_cbSizes = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"});
        this.m_cbSizes.setMaximumSize(this.m_cbSizes.getPreferredSize());
        this.m_cbSizes.setEditable(true);
        this.m_cbSizes.setActionCommand("Font Sizes");
        this.m_cbSizes.addActionListener(this);
        this.m_toolBar.add(this.m_cbSizes);
        this.m_toolBar.addSeparator();
        this.m_bBold = new JToggleButton("B", false);
        this.m_bBold.setActionCommand("Bold");
        this.m_bBold.addActionListener(this);
        this.m_toolBar.add(this.m_bBold);
        this.m_bItalic = new JToggleButton("I", false);
        this.m_bItalic.setActionCommand("Italic");
        this.m_bItalic.addActionListener(this);
        this.m_toolBar.add(this.m_bItalic);
        this.m_bUnderline = new JToggleButton("U", false);
        this.m_bUnderline.setActionCommand("Underline");
        this.m_bUnderline.addActionListener(this);
        this.m_toolBar.add(this.m_bUnderline);
        this.m_cbColors = new JComboBox<Color>(new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow});
        this.m_cbColors.setActionCommand("Colors");
        this.m_cbColors.addActionListener(this);
        this.m_cbColors.setRenderer(new ColorRenderer());
        this.m_cbColors.setMaximumSize(this.m_cbColors.getPreferredSize());
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(this.m_cbColors);
        String[] exist = this.getExistingFormatNames();
        String[] formats = new String[exist.length + 1];
        formats[0] = "None";
        for (int i = 0; i < exist.length; ++i) {
            formats[i + 1] = exist[i];
        }
        this.m_cbFormats = new JComboBox<String>(formats);
        this.m_cbFormats.setActionCommand("Select Format");
        this.m_cbFormats.addActionListener(this);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(this.m_cbFormats);
        this.getContentPane().add((Component)this.m_toolBar, "North");
        return menuBar;
    }

    private void insertMenuColumn(JMenu menu) {
        ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
        int ct = table.getColumnCount();
        for (int i = 0; i < ct; ++i) {
            ReportColumn col = table.getColumn(i);
            String name = this.reportMain.report.getDBSourceType() == Manager.DATAVIEW || col.getDBTableName() == null || col.getDBTableName().equals("") ? col.getText() : col.getDBTableName() + "." + col.getText();
            JMenuItem colName = new JMenuItem(name);
            colName.setActionCommand("<%{" + name + "}%>");
            colName.addActionListener(this);
            menu.add(colName);
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
    }

    private void insertMenuFormula(JMenu menu) {
        Vector<Formula> formulas = this.reportMain.report.formulas;
        for (int i = 0; i < formulas.size(); ++i) {
            Formula formula = formulas.elementAt(i);
            JMenuItem formulaItem = new JMenuItem("@" + formula.getName());
            formulaItem.setActionCommand("<%@" + formula.getName() + "%>");
            formulaItem.addActionListener(this);
            menu.add(formulaItem);
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
    }

    private void insertMenuParameter(JMenu menu) {
        JMenuItem paramItem;
        Vector<Parameter> queryParameters = this.reportMain.report.getQueryParameters();
        for (int i = 0; queryParameters != null && i < queryParameters.size(); ++i) {
            Parameter param = queryParameters.elementAt(i);
            paramItem = new JMenuItem(":" + param.getName());
            paramItem.setActionCommand("<%:" + param.getName() + "%>");
            paramItem.addActionListener(this);
            menu.add(paramItem);
        }
        if (menu.getItemCount() > 0) {
            menu.addSeparator();
        }
        Vector<Parameter> formulaParameters = this.reportMain.report.getFormulaParameters();
        for (int i = 0; formulaParameters != null && i < formulaParameters.size(); ++i) {
            Parameter param = formulaParameters.elementAt(i);
            paramItem = new JMenuItem("?" + param.getName());
            paramItem.setActionCommand("<%?" + param.getName() + "%>");
            paramItem.addActionListener(this);
            menu.add(paramItem);
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
    }

    protected void showAttributes(int p) {
        String format;
        Color color;
        boolean underline;
        boolean italic;
        boolean bold;
        int size;
        this.m_skipUpdate = true;
        AttributeSet a = this.getCurrentAttributeSet(p);
        String name = StyleConstants.getFontFamily(a);
        if (!this.m_fontName.equals(name)) {
            this.m_fontName = name;
            this.m_cbFonts.setSelectedItem(name);
        }
        if (this.m_fontSize != (size = StyleConstants.getFontSize(a))) {
            this.m_fontSize = size;
            this.m_cbSizes.setSelectedItem(Integer.toString(this.m_fontSize));
        }
        if ((bold = StyleConstants.isBold(a)) != this.m_bBold.isSelected()) {
            this.m_bBold.setSelected(bold);
        }
        if ((italic = StyleConstants.isItalic(a)) != this.m_bItalic.isSelected()) {
            this.m_bItalic.setSelected(italic);
        }
        if ((underline = StyleConstants.isUnderline(a)) != this.m_bUnderline.isSelected()) {
            this.m_bUnderline.setSelected(underline);
        }
        if (!(color = StyleConstants.getForeground(a)).equals(this.m_color)) {
            this.m_color = color;
            this.m_cbColors.setSelectedItem(color);
        }
        if (!(format = this.getDataFormat(a)).equals(this.m_format)) {
            this.m_format = format;
            this.m_cbFormats.setSelectedItem(format);
        }
        this.m_skipUpdate = false;
    }

    protected void setAttributeSet(AttributeSet attr) {
        if (this.m_skipUpdate) {
            return;
        }
        attr = new SimpleAttributeSet(attr);
        ((MutableAttributeSet)attr).removeAttribute(StyleConstants.IconAttribute);
        ((MutableAttributeSet)attr).removeAttribute("$ename");
        int xStart = this.m_monitor.getSelectionStart();
        int xFinish = this.m_monitor.getSelectionEnd();
        if (!this.m_monitor.hasFocus()) {
            xStart = this.m_xStart;
            xFinish = this.m_xFinish;
        }
        if (xStart != xFinish) {
            this.m_doc.setCharacterAttributes(xStart, xFinish - xStart, attr, false);
        } else {
            MutableAttributeSet inputAttributes = this.m_kit.getInputAttributes();
            inputAttributes.addAttributes(attr);
            if (xStart == this.m_doc.getEndPosition().getOffset() - 1) {
                SimpleAttributeSet aSet = this.getToolbarAttributes();
                aSet.addAttributes(attr);
                this.m_doc.setCharacterAttributes(xStart, 1, aSet, false);
            }
        }
    }

    protected void setSingleAttributeSet(AttributeSet attr) {
        if (this.m_skipUpdate) {
            return;
        }
        int xStart = this.m_monitor.getSelectionStart();
        if (!this.m_monitor.hasFocus()) {
            xStart = this.m_xStart;
        }
        this.m_doc.setCharacterAttributes(xStart, 1, attr, false);
    }

    private AttributeSet getCurrentAttributeSet(int p) {
        int xStart = this.m_monitor.getSelectionStart();
        int xFinish = this.m_monitor.getSelectionEnd();
        if (!this.m_monitor.hasFocus()) {
            xStart = this.m_xStart;
            xFinish = this.m_xFinish;
        }
        if (xStart != xFinish) {
            return this.m_doc.getCharacterElement(xStart).getAttributes();
        }
        if (this.m_doc.getLength() == 0 || p <= 0) {
            return this.m_doc.getCharacterElement(0).getAttributes();
        }
        return this.m_doc.getCharacterElement(p - 1).getAttributes();
    }

    private SimpleAttributeSet getToolbarAttributes() {
        SimpleAttributeSet aSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(aSet, this.m_cbFonts.getSelectedItem().toString());
        try {
            StyleConstants.setFontSize(aSet, Integer.parseInt(this.m_cbSizes.getSelectedItem().toString()));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Invalid number", ex);
        }
        StyleConstants.setBold(aSet, this.m_bBold.isSelected());
        StyleConstants.setItalic(aSet, this.m_bItalic.isSelected());
        StyleConstants.setForeground(aSet, (Color)this.m_cbColors.getSelectedItem());
        aSet.addAttribute("Data Format", this.m_cbFormats.getSelectedItem());
        return aSet;
    }

    protected void updateUndo() {
        if (this.m_undo.canUndo()) {
            this.undo.setEnabled(true);
        } else {
            this.undo.setEnabled(false);
        }
        if (this.m_undo.canRedo()) {
            this.redo.setEnabled(true);
        } else {
            this.redo.setEnabled(false);
        }
    }

    private void doCopy() {
        int xStart = this.m_monitor.getSelectionStart();
        int xFinish = this.m_monitor.getSelectionEnd();
        if (!this.m_monitor.hasFocus()) {
            xStart = this.m_xStart;
            xFinish = this.m_xFinish;
        }
        if (xStart != xFinish) {
            this.paste_attributes = this.m_doc.getCharacterElement(xStart).getAttributes();
        }
        this.m_monitor.copy();
    }

    private void doCut() {
        int xStart = this.m_monitor.getSelectionStart();
        int xFinish = this.m_monitor.getSelectionEnd();
        if (!this.m_monitor.hasFocus()) {
            xStart = this.m_xStart;
            xFinish = this.m_xFinish;
        }
        if (xStart != xFinish) {
            this.paste_attributes = this.m_doc.getCharacterElement(xStart).getAttributes();
        }
        this.m_monitor.cut();
    }

    private void doPaste() {
        int xStart = this.m_monitor.getSelectionStart();
        this.m_monitor.paste();
        int xFinish = this.m_monitor.getSelectionStart();
        if (xStart >= 0 && xFinish >= 0 && xStart != xFinish && this.paste_attributes != null) {
            if (!this.m_doc.getCharacterElement(xStart).getAttributes().isEqual(this.paste_attributes)) {
                this.m_doc.setCharacterAttributes(xStart, xFinish - xStart, this.paste_attributes, false);
            }
            this.showAttributes(xFinish);
            this.setAttributeSet(this.paste_attributes);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e.getDot() != this.caret_pos) {
            this.caret_pos = e.getDot();
            this.showAttributes(e.getDot());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.m_xStart >= 0 && this.m_xFinish >= 0) {
            if (this.m_monitor.getCaretPosition() == this.m_xStart) {
                this.m_monitor.setCaretPosition(this.m_xFinish);
                this.m_monitor.moveCaretPosition(this.m_xStart);
            } else {
                this.m_monitor.select(this.m_xStart, this.m_xFinish);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.m_xStart = this.m_monitor.getSelectionStart();
        this.m_xFinish = this.m_monitor.getSelectionEnd();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("New")) {
            this.m_doc = new RTFStyledDocument(this.m_context, this.isAdjustFont);
            this.m_xStart = 0;
            this.m_xFinish = 0;
            this.m_monitor.setDocument(this.m_doc);
            SimpleAttributeSet aSet = new SimpleAttributeSet();
            StyleConstants.setFontFamily(aSet, "Arial");
            this.setAttributeSet(aSet);
            this.showAttributes(0);
            this.m_doc.addUndoableEditListener(new Undoer());
            this.m_monitor.grabFocus();
        } else if (command.equals("Import...")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_monitor.grabFocus();
            String directory = "Templates/";
            directory = this.reportMain.getBrowseDirectories().getRichTextDir();
            OpenFileDialog openDialog = new OpenFileDialog(this.reportMain, LanguageEncoder.getText("Open File..."), directory, new String[]{"RTF"}, directory);
            openDialog.setVisible(true);
            if (openDialog.getSelectedFile() == null) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.reportMain.getBrowseDirectories().setRichTextDir(openDialog.getCurrentDirectory());
            this.repaint();
            try {
                ReadDataFile readfile = new ReadDataFile();
                DataInputStream in = readfile.getInputStream(openDialog.getSelectedFile());
                this.m_doc = new RTFStyledDocument(this.m_context, this.isAdjustFont);
                this.m_kit.read(in, (Document)this.m_doc, 0);
                this.m_xStart = 0;
                this.m_xFinish = 0;
                this.m_doc.remove(this.m_doc.getLength() - 1, 1);
                this.m_monitor.setDocument(this.m_doc);
                ((InputStream)in).close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Invalid format. Cannot open file.", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Invalid format. Failed to open file."));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
            AttributeSet aSet = this.getCurrentAttributeSet(this.m_doc.getLength() - 1);
            this.m_monitor.setCaretPosition(this.m_doc.getLength());
            this.setAttributeSet(aSet);
            this.m_monitor.setCaretPosition(0);
            this.showAttributes(0);
            this.m_doc.addUndoableEditListener(new Undoer());
        } else if (command.equals("Insert Image")) {
            this.do_InsertImage();
        } else if (command.equals("Image Size")) {
            this.do_ImageSize();
        } else if (command.equals("Exit")) {
            JMessageDialog msgDialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Do you want to save your changes?"), 1);
            int response = msgDialog.getResponse();
            switch (response) {
                case 4: {
                    this.saveChanges();
                    this.setVisible(false);
                    this.dispose();
                    break;
                }
                case 5: {
                    this.setVisible(false);
                    this.dispose();
                }
            }
        } else if (command.equals("Copy")) {
            this.doCopy();
        } else if (command.equals("Cut")) {
            this.doCut();
        } else if (command.equals("Paste")) {
            this.doPaste();
        } else if (command.equals("Undo")) {
            try {
                this.m_undo.undo();
                this.showAttributes(this.m_monitor.getCaretPosition());
            }
            catch (CannotUndoException ex) {
                LOGGER.log(Level.FINEST, "Cannot undo", ex);
            }
            this.updateUndo();
        } else if (command.equals("Redo")) {
            try {
                this.m_undo.redo();
                this.showAttributes(this.m_monitor.getCaretPosition());
            }
            catch (CannotUndoException ex) {
                LOGGER.log(Level.FINEST, "Cannot undo", ex);
            }
            this.updateUndo();
        } else if (command.equals("Font Names")) {
            this.m_fontName = this.m_cbFonts.getSelectedItem().toString();
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setFontFamily(attr, this.m_fontName);
            this.setAttributeSet(attr);
            this.m_monitor.grabFocus();
        } else if (command.equals("Font Sizes")) {
            int fontSize = 0;
            try {
                fontSize = Integer.parseInt(this.m_cbSizes.getSelectedItem().toString());
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Font size: Invalid number", ex);
                return;
            }
            this.m_fontSize = fontSize;
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setFontSize(attr, fontSize);
            this.setAttributeSet(attr);
            this.m_monitor.grabFocus();
        } else if (command.equals("Bold")) {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setBold(attr, this.m_bBold.isSelected());
            this.setAttributeSet(attr);
            this.m_monitor.grabFocus();
        } else if (command.equals("Italic")) {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setItalic(attr, this.m_bItalic.isSelected());
            this.setAttributeSet(attr);
            this.m_monitor.grabFocus();
        } else if (command.equals("Underline")) {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setUnderline(attr, this.m_bUnderline.isSelected());
            this.setAttributeSet(attr);
            this.m_monitor.grabFocus();
        } else if (command.equals("Colors")) {
            this.m_color = (Color)this.m_cbColors.getSelectedItem();
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, this.m_color);
            this.setAttributeSet(attr);
            this.m_monitor.grabFocus();
        } else if (command.equals("Columns")) {
            RTFColumnsDialog cDialog = new RTFColumnsDialog(this, this.rtf_object.getColumnCount(), this.rtf_object.getColumnSpacing());
            cDialog.setVisible(true);
            if (cDialog.isModified()) {
                this.rtf_object.setColumnCount(cDialog.getColumnCount());
                this.rtf_object.setColumnSpacing(cDialog.getColumnSpacing());
            }
        } else if (command.equals("Select Format")) {
            this.m_format = (String)this.m_cbFormats.getSelectedItem();
            SimpleAttributeSet attr = new SimpleAttributeSet();
            attr.addAttribute("Data Format", this.m_format);
            this.setAttributeSet(attr);
            this.m_monitor.grabFocus();
        } else if (command.endsWith("New Format")) {
            if (command.startsWith("String")) {
                this.defineNewFormat(0);
            } else if (command.startsWith("Logical")) {
                this.defineNewFormat(1);
            } else if (command.startsWith("Numeric")) {
                this.defineNewFormat(2);
            } else if (command.startsWith("Time")) {
                this.defineNewFormat(3);
            }
        } else if (command.endsWith("Edit Format")) {
            try {
                int index = Integer.parseInt(command.substring(0, command.indexOf(32)));
                this.editFormat(index);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot edit format", ex);
            }
        } else if (command.endsWith("Remove Format")) {
            try {
                int index = Integer.parseInt(command.substring(0, command.indexOf(32)));
                this.removeFormat(index);
                this.updateFormatComboBox();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot remove format", ex);
            }
        } else if (command.startsWith("<%")) {
            try {
                this.m_doc.insertString(this.caret_pos == -1 ? 0 : this.caret_pos, command, null);
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "Cannot insert string - problem with caret possition", ex);
            }
        }
    }

    private void saveChanges() {
        this.modified = true;
        this.m_monitor.setCaretPosition(this.m_doc.getLength());
        if (this.rtf_object != null) {
            try {
                ByteArrayOutputStream outstream = new ByteArrayOutputStream();
                this.m_kit.write(outstream, (Document)this.m_doc, 0, this.m_doc.getLength());
                outstream.close();
                this.rtf_object.setData(outstream.toByteArray(), RTFUtil.getFormatMap(this.m_doc));
                this.rtf_object.setFormats(this.customFormats);
                int length = 10;
                if (this.m_doc.getLength() < 10) {
                    length = this.m_doc.getLength();
                }
                String sampleText = this.m_doc.getText(0, length);
                this.rtf_object.setText("Rich Text: " + sampleText + " . . .");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to save the changes", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to save changes.\n") + ex.toString());
            }
        }
    }

    boolean isModified() {
        return this.modified;
    }

    @Override
    public void menuCanceled(MenuEvent menuevent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuevent) {
    }

    @Override
    public void menuSelected(MenuEvent menuevent) {
        block3: {
            block2: {
                if (menuevent.getSource() != this.editFormatMenu) break block2;
                this.editFormatMenu.removeAll();
                for (int i = 0; i < this.customFormats.size(); ++i) {
                    String name = (String)((Object[])this.customFormats.elementAt(i))[0];
                    JMenuItem menuitem = new JMenuItem(name);
                    menuitem.setActionCommand(i + " Edit Format");
                    menuitem.addActionListener(this);
                    this.editFormatMenu.add(menuitem);
                }
                break block3;
            }
            if (menuevent.getSource() != this.removeFormatMenu) break block3;
            this.removeFormatMenu.removeAll();
            for (int i = 0; i < this.customFormats.size(); ++i) {
                String name = (String)((Object[])this.customFormats.elementAt(i))[0];
                JMenuItem menuitem = new JMenuItem(name);
                menuitem.setActionCommand(i + " Remove Format");
                menuitem.addActionListener(this);
                this.removeFormatMenu.add(menuitem);
            }
        }
    }

    private void defineNewFormat(int type) {
        JDialog sfd;
        IFormat newFormat = null;
        if (type == 0) {
            sfd = new StringDialog(this.reportMain, LanguageEncoder.getText("New Format"), (StringFormat)FormatUtil.createFormat(7));
            sfd.setVisible(true);
            if (((StringDialog)sfd).isModified()) {
                newFormat = ((StringDialog)sfd).getFormat();
            }
        } else if (type == 1) {
            sfd = new FormatDialog(this.reportMain, FormatUtil.createFormat(0), 0, LanguageEncoder.getText("New Format"), false);
            sfd.setVisible(true);
            if (((FormatDialog)sfd).isModified()) {
                newFormat = ((FormatDialog)sfd).getFormat();
            }
        } else if (type == 2) {
            sfd = new FormatDialog(this.reportMain, FormatUtil.createFormat(5), 5, LanguageEncoder.getText("New Format"), false);
            sfd.setVisible(true);
            if (((FormatDialog)sfd).isModified()) {
                newFormat = ((FormatDialog)sfd).getFormat();
            }
        } else if (type == 3) {
            sfd = new FormatDialog(this.reportMain, FormatUtil.createFormat(10), 10, LanguageEncoder.getText("New Format"), false);
            sfd.setVisible(true);
            if (((FormatDialog)sfd).isModified()) {
                newFormat = ((FormatDialog)sfd).getFormat();
            }
        }
        String[] existing = this.getExistingFormatNames();
        if (newFormat != null) {
            boolean failed = true;
            String formatName = "";
            String text = LanguageEncoder.getText("Please enter format name:");
            while (failed) {
                formatName = JOptionPane.showInputDialog(this, text, LanguageEncoder.getText("Format Name"), -1);
                if (formatName != null && !formatName.trim().equals("")) {
                    formatName = formatName.trim();
                    boolean ok = true;
                    for (int i = 0; i < existing.length; ++i) {
                        if (!formatName.equals(existing[i])) continue;
                        text = "'" + formatName + LanguageEncoder.getText("' already exists. Please enter another name:");
                        ok = false;
                        i = existing.length;
                    }
                    if (!ok) continue;
                    failed = false;
                    continue;
                }
                if (formatName != null) continue;
                return;
            }
            Object[] f = new Object[]{formatName, newFormat, type};
            this.customFormats.addElement(f);
            this.updateFormatComboBox();
        }
    }

    private void editFormat(int index) {
        if (index < 0 || index >= this.customFormats.size()) {
            return;
        }
        Object[] f = (Object[])this.customFormats.elementAt(index);
        if ((Integer)f[2] == 0) {
            StringDialog sfd = new StringDialog(this.reportMain, "Edit Format: " + (String)f[0], (StringFormat)f[1]);
            sfd.setVisible(true);
            if (sfd.isModified()) {
                f[1] = sfd.getFormat();
            }
        } else if ((Integer)f[2] == 1) {
            FormatDialog sfd = new FormatDialog(this.reportMain, (IFormat)f[1], 0, "Edit Format: " + (String)f[0], false);
            sfd.setVisible(true);
            if (sfd.isModified()) {
                f[1] = sfd.getFormat();
            }
        } else if ((Integer)f[2] == 2) {
            FormatDialog sfd = new FormatDialog(this.reportMain, (IFormat)f[1], 5, "Edit Format: " + (String)f[0], false);
            sfd.setVisible(true);
            if (sfd.isModified()) {
                f[1] = sfd.getFormat();
            }
        } else if ((Integer)f[2] == 3) {
            FormatDialog sfd = new FormatDialog(this.reportMain, (IFormat)f[1], 10, "Edit Format: " + (String)f[0], false);
            sfd.setVisible(true);
            if (sfd.isModified()) {
                f[1] = sfd.getFormat();
            }
        }
    }

    private void removeFormat(int index) {
        if (index < 0 || index >= this.customFormats.size()) {
            return;
        }
        Object[] f = (Object[])this.customFormats.elementAt(index);
        String text = "";
        try {
            text = this.m_doc.getText(0, this.m_doc.getLength());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot get text", ex);
        }
        int beginIndex = 0;
        boolean first = true;
        boolean skipAll = false;
        String applyAll = null;
        while (beginIndex >= 0 && !skipAll) {
            String cur = "";
            int nextIndex = text.indexOf("<%", beginIndex);
            cur = nextIndex < 0 ? text.substring(beginIndex) : text.substring(beginIndex, nextIndex);
            int endIndex = cur.indexOf("%>");
            if (!first && endIndex >= 0) {
                endIndex += beginIndex;
                String formula = "";
                try {
                    formula = text.substring(beginIndex, endIndex).trim();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot get text", ex);
                }
                if (!formula.equals("")) {
                    try {
                        AttributeSet aSet = this.m_doc.getCharacterElement(beginIndex - 2).getAttributes();
                        Object curF = aSet.getAttribute("Data Format");
                        if (curF.equals(f[0])) {
                            if (applyAll == null) {
                                RTFFormatReplacementDialog rDialog = new RTFFormatReplacementDialog(this, (String)f[0], formula, this.getExistingFormatNames());
                                int state = rDialog.getState();
                                if (state == 4) {
                                    return;
                                }
                                if (state == 3) {
                                    skipAll = true;
                                } else if (state == 1) {
                                    applyAll = rDialog.getFormatSelection();
                                } else if (state == 0) {
                                    SimpleAttributeSet attr = new SimpleAttributeSet();
                                    attr.addAttribute("Data Format", rDialog.getFormatSelection());
                                    this.m_doc.setCharacterAttributes(beginIndex - 2, endIndex - beginIndex + 4, attr, false);
                                }
                            }
                            if (applyAll != null) {
                                SimpleAttributeSet attr = new SimpleAttributeSet();
                                attr.addAttribute("Data Format", applyAll);
                                this.m_doc.setCharacterAttributes(beginIndex - 2, endIndex - beginIndex + 4, attr, false);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Action failed", ex);
                    }
                }
            }
            beginIndex = nextIndex < 0 ? -1 : nextIndex + 2;
            if (!first) continue;
            first = false;
        }
        this.customFormats.removeElementAt(index);
    }

    private String[] getExistingFormatNames() {
        String[] ret = new String[this.customFormats.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)((Object[])this.customFormats.elementAt(i))[0];
        }
        return ret;
    }

    private String getDataFormat(AttributeSet aSet) {
        String[] existing;
        String format = (String)aSet.getAttribute("Data Format");
        for (String element : existing = this.getExistingFormatNames()) {
            if (!element.equals(format)) continue;
            return format;
        }
        return "None";
    }

    private void updateFormatComboBox() {
        String[] exist = this.getExistingFormatNames();
        this.m_cbFormats.removeActionListener(this);
        this.m_cbFormats.removeAllItems();
        this.m_cbFormats.addItem(LanguageEncoder.getText("None"));
        for (String element : exist) {
            this.m_cbFormats.addItem(element);
        }
        this.m_cbFormats.setSelectedIndex(0);
        this.m_cbFormats.setSelectedItem(this.m_format);
        this.m_cbFormats.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_InsertImage() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ImageIcon icon;
            this.m_monitor.grabFocus();
            String directory = "";
            directory = this.reportMain.getBrowseDirectories().getRichTextImagesDir();
            OpenFileDialog openDialog = new OpenFileDialog(this.reportMain, LanguageEncoder.getText("Open File..."), directory, new String[]{"GIF", "JPG", "PNG"}, directory);
            openDialog.setVisible(true);
            if (openDialog.getSelectedFile() == null) {
                return;
            }
            this.reportMain.getBrowseDirectories().setRichTextImagesDir(openDialog.getCurrentDirectory());
            this.repaint();
            ReadDataFile readfile = new ReadDataFile();
            DataInputStream ins = readfile.getInputStream(openDialog.getSelectedFile());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int b = ((InputStream)ins).read();
            while (b != -1) {
                bout.write(b);
                b = ((InputStream)ins).read();
            }
            bout.close();
            Image i = ImageData.retrieveImage(bout.toByteArray(), ServerMessage.getComponent());
            int width = i.getWidth(null);
            int height = i.getHeight(null);
            RTFImageSizeDialog sizeDialog = new RTFImageSizeDialog(this, width, height);
            sizeDialog.setVisible(true);
            if (!sizeDialog.isModified()) {
                return;
            }
            if (width != sizeDialog.getImageWidth() || height != sizeDialog.getImageHeight()) {
                i = new ImageResample(i).resample(sizeDialog.getImageWidth(), sizeDialog.getImageHeight());
                i = ImageResample.resetTransparentBackgroundColor(i);
            }
            if ((icon = new ImageIcon(i)).getIconHeight() < 0 || icon.getIconWidth() < 0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to insert image. Image format not recognized."));
                return;
            }
            SimpleAttributeSet aSet = new SimpleAttributeSet(this.getCurrentAttributeSet(this.m_monitor.getCaretPosition() - 1));
            StyleConstants.setIcon(aSet, icon);
            this.m_doc.insertString(this.m_monitor.getCaretPosition(), " ", aSet);
            this.repaint();
            this.m_monitor.validate();
            this.m_monitor.repaint();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to insert image", ex);
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to insert image.\n") + ex.toString());
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void do_ImageSize() {
        this.m_monitor.grabFocus();
        AttributeSet aSet = this.getCurrentAttributeSet(this.m_monitor.getCaretPosition() + 1);
        Icon icon = StyleConstants.getIcon(aSet);
        if (icon != null && icon instanceof ImageIcon) {
            Image i = ((ImageIcon)icon).getImage();
            int width = i.getWidth(null);
            int height = i.getHeight(null);
            RTFImageSizeDialog sizeDialog = new RTFImageSizeDialog(this, width, height);
            sizeDialog.setVisible(true);
            if (!sizeDialog.isModified()) {
                return;
            }
            if (width != sizeDialog.getImageWidth() || height != sizeDialog.getImageHeight()) {
                try {
                    i = new ImageResample(i).resample(sizeDialog.getImageWidth(), sizeDialog.getImageHeight());
                    i = ImageResample.resetTransparentBackgroundColor(i);
                    icon = new ImageIcon(i);
                    if (icon.getIconHeight() < 0 || icon.getIconWidth() < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to resize image", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to resize image.\n") + ex.toString());
                    return;
                }
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setIcon(attributeSet, icon);
                this.setSingleAttributeSet(attributeSet);
                this.repaint();
                this.m_monitor.validate();
                this.m_monitor.repaint();
            }
        } else {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("No image found at the current position."));
        }
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            new RefreshThread(this.m_monitor).start();
        }
        super.setVisible(state);
    }

    private class RefreshThread
    extends Thread {
        private JComponent component;

        public RefreshThread(JComponent comp) {
            this.component = comp;
        }

        @Override
        public void run() {
            if (this.component != null) {
                int count = 0;
                while (!this.component.isShowing() && count < 5) {
                    ++count;
                    try {
                        RefreshThread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.component.repaint();
            }
        }
    }

    class Undoer
    implements UndoableEditListener {
        public Undoer() {
            RTFEditorDialog.this.m_undo.die();
            RTFEditorDialog.this.updateUndo();
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            RTFEditorDialog.this.m_undo.addEdit(e.getEdit());
            RTFEditorDialog.this.updateUndo();
        }
    }
}

