/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import quadbase.common.util.internal.LanguageEncoder;

public class RTFFormatReplacementDialog
extends JDialog
implements ActionListener {
    public static final int APPLY = 0;
    public static final int APPLYALL = 1;
    public static final int SKIP = 2;
    public static final int SKIPALL = 3;
    public static final int CANCEL = 4;
    private JComboBox formats = null;
    private int state = 4;

    public RTFFormatReplacementDialog(JDialog parent, String fname, String formula, String[] cs) {
        super(parent, LanguageEncoder.getText("Remove Format..."), true);
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mainPanel.setLayout(gbl);
        String[] choices = new String[cs.length];
        choices[0] = "None";
        int index = 1;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i].equals(fname)) continue;
            choices[index] = cs[i];
            ++index;
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 17;
        JComponent comp = new JLabel("The following formula uses '" + fname + "':");
        gbl.setConstraints(comp, gbc);
        mainPanel.add(comp);
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 10, 5);
        gbc.anchor = 10;
        gbc.fill = 1;
        comp = new JTextArea(formula, 5, 20);
        ((JTextArea)comp).setEditable(false);
        ((JTextArea)comp).setLineWrap(true);
        gbl.setConstraints(comp, gbc);
        mainPanel.add(comp);
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 5, 0, 5);
        gbc.anchor = 17;
        gbc.fill = 0;
        comp = new JLabel("Would you like to choose a new format for this formula?");
        gbl.setConstraints(comp, gbc);
        mainPanel.add(comp);
        gbc.gridy = 3;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 2;
        this.formats = new JComboBox<String>(choices);
        this.formats.setSelectedIndex(0);
        gbl.setConstraints(this.formats, gbc);
        mainPanel.add(this.formats);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        JButton button = new JButton("Apply");
        button.setActionCommand("Apply");
        button.addActionListener(this);
        bottomPanel.add(button);
        button = new JButton("Apply All");
        button.setActionCommand("Apply All");
        button.addActionListener(this);
        bottomPanel.add(button);
        button = new JButton("Skip");
        button.setActionCommand("Skip");
        button.addActionListener(this);
        bottomPanel.add(button);
        button = new JButton("Skip All");
        button.setActionCommand("Skip All");
        button.addActionListener(this);
        bottomPanel.add(button);
        button = new JButton("Canel");
        button.setActionCommand("Cancel");
        button.addActionListener(this);
        bottomPanel.add(button);
        contentPane.add((Component)bottomPanel, "South");
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
        this.setVisible(true);
    }

    public String getFormatSelection() {
        return (String)this.formats.getSelectedItem();
    }

    public int getState() {
        return this.state;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Apply")) {
            this.state = 0;
        } else if (command.equals("Apply All")) {
            this.state = 1;
        } else if (command.equals("Skip")) {
            this.state = 2;
        } else if (command.equals("Skip All")) {
            this.state = 3;
        } else if (command.equals("Cancel")) {
            this.state = 4;
        }
        this.setVisible(false);
        this.dispose();
    }
}

