/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class RTFImageSizeDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(RTFImageSizeDialog.class.getName());
    private int width;
    private int height;
    private JTextField widthField;
    private JTextField heightField;
    private boolean modified = false;

    public RTFImageSizeDialog(JDialog parent, int width, int height) {
        super(parent, LanguageEncoder.getText("Image Size"), true);
        this.width = width;
        this.height = height;
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel topPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        topPanel.setLayout(gbl);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 10, 5, 5);
        JComponent comp = new JLabel(LanguageEncoder.getText("Width:"));
        gbl.setConstraints(comp, gbc);
        topPanel.add(comp);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 5, 0);
        this.widthField = new JTextField(this.width + "", 10);
        Dimension d = this.widthField.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.widthField.setMinimumSize(d);
        gbl.setConstraints(this.widthField, gbc);
        topPanel.add(this.widthField);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 5, 5, 10);
        comp = new JLabel(LanguageEncoder.getText("pixels"));
        gbl.setConstraints(comp, gbc);
        topPanel.add(comp);
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 10, 10, 5);
        comp = new JLabel(LanguageEncoder.getText("Height:"));
        gbl.setConstraints(comp, gbc);
        topPanel.add(comp);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 10, 0);
        this.heightField = new JTextField(this.height + "", 10);
        d = this.heightField.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.heightField.setMinimumSize(d);
        gbl.setConstraints(this.heightField, gbc);
        topPanel.add(this.heightField);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 10, 10);
        comp = new JLabel(LanguageEncoder.getText("pixels"));
        gbl.setConstraints(comp, gbc);
        topPanel.add(comp);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        comp = new JButton(LanguageEncoder.getText("OK"));
        ((JButton)comp).setActionCommand("OK");
        bottomPanel.add(comp);
        ((JButton)comp).addActionListener(this);
        comp = new JButton(LanguageEncoder.getText("Cancel"));
        ((JButton)comp).setActionCommand("Cancel");
        bottomPanel.add(comp);
        ((JButton)comp).addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)topPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("OK")) {
            try {
                int w = Integer.parseInt(this.widthField.getText());
                int h = Integer.parseInt(this.heightField.getText());
                this.width = w;
                this.height = h;
                this.modified = true;
                this.setVisible(false);
                this.dispose();
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Text width and height: Invalid number", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Width and height must be integers."));
            }
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int getImageWidth() {
        return this.width;
    }

    public int getImageHeight() {
        return this.height;
    }

    public boolean isModified() {
        return this.modified;
    }
}

