/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.designer.LoginDialog;
import quadbase.reportdesigner.designer.LoginPanel;
import quadbase.reportdesigner.designer.ReportMain;

public class ReportClient
extends JApplet {
    private static final Logger LOGGER = Logger.getLogger(ReportClient.class.getName());
    public static boolean isMetricSystem = false;
    private static String servletURL;

    public static void main(String[] args) {
        QbUtil.setWindowsLAF();
        String filename = null;
        String enc = null;
        String address = null;
        String port = null;
        String hosts = null;
        String templates_dir = null;
        String xmlEncoding = null;
        String paperSize = null;
        for (String arg : args) {
            if (arg.startsWith("-file:")) {
                filename = arg.substring(6);
                continue;
            }
            if (arg.startsWith("-enc:")) {
                enc = arg.substring(5);
                continue;
            }
            if (arg.startsWith("-xmlEncoding:")) {
                xmlEncoding = arg.substring(13);
                if (xmlEncoding == null || xmlEncoding.trim().equals("")) continue;
                ServerMessage.setXMLEncoding(xmlEncoding);
                continue;
            }
            if (arg.startsWith("-paperSize:")) {
                paperSize = arg.substring(11);
                ServerMessage.setPaperSize(paperSize);
                continue;
            }
            if (arg.startsWith("-metricSystem:")) {
                isMetricSystem = arg.substring(14).trim().equalsIgnoreCase("true");
                continue;
            }
            if (arg.startsWith("-address:")) {
                address = arg.substring(9);
                continue;
            }
            if (arg.startsWith("-port:")) {
                port = arg.substring(6);
                continue;
            }
            if (arg.startsWith("-hosts:")) {
                hosts = arg.substring(7);
                continue;
            }
            if (arg.startsWith("-templatesDirectory:")) {
                templates_dir = arg.substring(20);
                continue;
            }
            if (arg.startsWith("-debug:")) {
                QbDebug.setDebugMode(arg.substring(7));
                continue;
            }
            if (arg.equalsIgnoreCase("-http")) {
                ServerMessage.useHttp();
                continue;
            }
            if (arg.startsWith("-servlet:")) {
                ServerMessage.useServlet();
                String tmp = arg.substring(9);
                if (tmp.equals("")) continue;
                servletURL = tmp;
                continue;
            }
            if (!arg.equalsIgnoreCase("-servlet")) continue;
            ServerMessage.useServlet();
        }
        if (filename != null && enc != null) {
            try {
                LanguageEncoder.loadFromServer(filename, enc);
            }
            catch (Exception e) {
                LOGGER.warning("Failed to load file from server");
            }
        }
        ServerMessage.useServer = true;
        if (address != null) {
            try {
                ServerMessage.setAddress(address);
            }
            catch (Exception ex) {
                LOGGER.warning("Failed to set server address from the argument");
            }
        }
        if (port != null) {
            try {
                int portno = Integer.parseInt(port);
                ServerMessage.setPortNumber(portno);
            }
            catch (Exception ex) {
                LOGGER.warning("Failed to set port number from the argument");
            }
        }
        if (hosts != null) {
            ServerMessage.setHosts(QbUtil.readMultiValues(hosts));
        }
        ReportClient.startProgram(null, templates_dir);
    }

    @Override
    public void init() {
        String debugMode;
        String hosts;
        String portno;
        String address;
        String tmp1;
        String servletContext;
        String comm_url;
        QbUtil.setWindowsLAF();
        ServerMessage.useServer = true;
        ReportClient.initJNLP();
        String proto = this.getParameter("comm_protocol");
        if (proto != null) {
            if (proto.equalsIgnoreCase("http")) {
                ServerMessage.useHttp();
            } else if (proto.equalsIgnoreCase("servlet")) {
                ServerMessage.useServlet();
            }
        }
        if ((comm_url = this.getParameter("comm_url")) != null) {
            if (ServerMessage.isServlet()) {
                ServerMessage.setConnectServlet(comm_url);
            } else {
                ServerMessage.setConnectURL(comm_url);
            }
        }
        if ((servletContext = this.getParameter("servlet_context")) != null) {
            ServerMessage.setServletContext(servletContext);
        }
        String filename = this.getParameter("file");
        String enc = this.getParameter("enc");
        if (filename != null && enc != null) {
            try {
                LanguageEncoder.loadFromServer(filename, enc);
            }
            catch (Exception e) {
                LOGGER.warning("Failed to load language file");
            }
        }
        if ((tmp1 = this.getParameter("metricSystem")) != null) {
            isMetricSystem = tmp1.trim().equalsIgnoreCase("true");
        }
        if ((address = this.getParameter("server_address")) != null) {
            try {
                ServerMessage.setAddress(address);
            }
            catch (Exception ex) {
                LOGGER.warning("Failed to set server address");
            }
        }
        if ((portno = this.getParameter("server_port_number")) != null) {
            try {
                int portnumber = Integer.parseInt(portno);
                ServerMessage.setPortNumber(portnumber);
            }
            catch (Exception ex) {
                LOGGER.warning("Failed to set port number");
            }
        }
        if ((hosts = this.getParameter("server_hosts")) != null) {
            ServerMessage.setHosts(QbUtil.readMultiValues(hosts));
        }
        String templates_dir = this.getParameter("templates_directory");
        String xml_encoding = this.getParameter("xml_encoding");
        String paper_size = this.getParameter("paper_size");
        if (xml_encoding != null && !xml_encoding.trim().equals("")) {
            ServerMessage.setXMLEncoding(xml_encoding);
        }
        if (paper_size != null && !paper_size.trim().equals("")) {
            ServerMessage.setPaperSize(paper_size);
        }
        if ((debugMode = this.getParameter("debug")) != null) {
            QbDebug.setDebugMode(debugMode);
        }
        ServerMessage.setApplet(this);
        ReportClient.startProgram(this, templates_dir);
    }

    public static void startProgram(JApplet applet, String templates_dir) {
        try {
            if (LCKey.isDashboardOnly()) {
                throw new Exception("Invalid license key for ReportDesigner: Please contact sales@quadbase.com!");
            }
            if (servletURL != null) {
                String tmp = servletURL;
                String servletBaseStr = ServerMessage.getServletBaseString(tmp);
                String servletContext = ServerMessage.getServletContext(tmp);
                ServerMessage.setConnectServlet(servletBaseStr);
                ServerMessage.setServletContext(servletContext);
            }
            ServerMessage.setApplet(applet);
            if (applet == null) {
                LoginDialog loginDialog = new LoginDialog();
                loginDialog.setVisible(true);
                if (loginDialog.login()) {
                    ReportMain reportMain = new ReportMain();
                    if (templates_dir != null) {
                        reportMain.setTemplatesDirectory(templates_dir);
                    }
                    reportMain.setLoginUser(loginDialog.loginUser());
                    reportMain.setVisible(true);
                }
            } else {
                LoginPanel loginPanel = new LoginPanel(null, templates_dir);
                JPanel contentPane = (JPanel)applet.getContentPane();
                contentPane.setLayout(new BorderLayout());
                contentPane.add("Center", loginPanel);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Cannot start program!");
            JOptionPane.showMessageDialog(applet, ex.toString(), LanguageEncoder.getText("Error"), 0);
        }
    }

    private static void initJNLP() {
        if (ServerMessage.isJnlp()) {
            ReportClient.deleteJNLPFile();
            ReportClient.registerJNLPSingleton();
        }
    }

    private static void deleteJNLPFile() {
        File jnlpFile;
        String jnlpPath = System.getProperty("jnlpx.origFilenameArg");
        if (jnlpPath != null && !(jnlpFile = new File(jnlpPath)).delete()) {
            LOGGER.warning("Failed to delete JNLP file " + jnlpPath);
        }
    }

    private static void registerJNLPSingleton() {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(new SingleInstanceListener(){

                public void newActivation(String[] strings) {
                    ReportClient.deleteJNLPFile();
                }
            });
        }
        catch (UnavailableServiceException e) {
            LOGGER.log(Level.WARNING, "Failed to register SingleInstanceService", e);
        }
    }
}

