/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import quadbase.common.client.ReadDatabase;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.querybuilder.query.QueryBuilder;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.CrossTabReportSection;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.designer.DatabaseFieldDialog;
import quadbase.reportdesigner.designer.DesignGraphics;
import quadbase.reportdesigner.designer.GridLine;
import quadbase.reportdesigner.designer.PopupMenuForReportElement;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.RulerPanel;
import quadbase.reportdesigner.designer.adapter.NormalAdapter;
import quadbase.reportdesigner.designer.adapter.RptEltKeyAdapter;
import quadbase.reportdesigner.designer.adapter.RptEltMouseAdapter;
import quadbase.reportdesigner.designer.groupformat.GroupAlignmentDialog;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.PageGraphics;
import quadbase.reportdesigner.report.ParseException;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IAggregateConstants;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class ReportElementPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(ReportElementPanel.class.getName());
    private RptEltMouseAdapter mAdapter = new RptEltMouseAdapter(this);
    private RptEltKeyAdapter kAdapter = new RptEltKeyAdapter(this);
    private boolean skipDrawDraggedObjects = false;
    public int dragDashYOffset = 0;
    public int draggedDy = 0;
    private Vector<ReportElement> resizedLines;
    private Vector<ReportElement> resizedReAdd = new Vector();
    public ReportMain reportMain;
    ReportElement elt;
    ReportUI reportUI;
    ReportTable reportTable;
    public ReportElement selectedObject = null;
    boolean isDragOp = false;
    boolean isResizeOp = false;
    boolean isPopupTrigger = false;
    boolean isDragOpFromRuler = false;
    boolean isResizeOpFromRuler = false;
    boolean isMetricSystem = false;
    int previousX = -1;
    int previousY = -1;
    int diffX = -1;
    int diffY = -1;
    int deltaX = 0;
    int deltaY = 0;
    private boolean isSelectOp = false;
    int selectionDiffX = -1;
    int selectionDiffY = -1;
    boolean isDrawSelectionBoxOp = false;
    int selectionPreviousX = -1;
    int selectionPreviousY = -1;
    int originX = -1;
    int originY = -1;
    int endX = -1;
    int endY = -1;
    int boundingX = 0;
    int boundingY = 0;
    int boundingWidth = 0;
    int boundingHeight = 0;
    ReportElementPanel[] lastSpanPanels;
    boolean isBoundingBoxOp = false;
    boolean isDragBoundingBoxOp = false;
    boolean isResizeBoundingBoxOp = false;
    boolean drawBoundingBox = false;
    Rectangle boundingBox = new Rectangle();
    PopupMenuForReportElement popupMenu;
    String sectionID = LanguageEncoder.getText("Report Designer");
    protected int panelHeight;
    public Vector<ReportElement> groupFormat;
    public Vector<Object> draggedObjects = new Vector();
    public Vector<Object> selectingBox;
    Image offScreenImage;
    AbstractButton button;
    JPanel buttonPanel;
    int BUTTONGAP = 5;
    int row = 0;
    Vector<Integer> treeStructure;
    int selectionOriginX = -1;
    int selectionOriginY = -1;
    double rowHeight;
    Vector<ReportElement> prevSelectedElts = new Vector();
    Vector<ReportElement> curSelectedElts = new Vector();
    int selectedIndex = -1;
    boolean applyScript = false;
    public double[] prevX;
    public double[] prevY;
    public double[] prevW;
    public double[] prevH;
    private int databaseType = -1;

    public ReportElementPanel(ReportMain reportMain, ReportUI reportUI, ReportElement elt, ReportTable reportTable, String sectionID) {
        this(reportMain, reportUI, elt, reportTable, sectionID, 0, Color.white);
    }

    public ReportElementPanel(ReportMain reportMain, ReportUI reportUI, ReportTable reportTable, String sectionID) {
        this(reportMain, reportUI, reportTable, sectionID, 0);
    }

    public ReportElementPanel(ReportMain reportMain, ReportUI reportUI, ReportTable reportTable, String sectionID, int row) {
        this(reportMain, reportUI, reportTable, reportTable, sectionID, row, Color.white);
    }

    public ReportElementPanel(ReportMain reportMain, ReportUI reportUI, ReportElement elt, ReportTable reportTable, String sectionID, Color color) {
        this(reportMain, reportUI, elt, reportTable, sectionID, 0, color);
    }

    public ReportElementPanel(ReportMain reportMain, ReportUI reportUI, ReportElement elt, ReportTable reportTable, String sectionID, int row, Color color) {
        double height;
        if (IOUtil.isJava14()) {
            this.setFocusable(true);
        }
        if (IOUtil.isMac()) {
            this.BUTTONGAP = 6;
        }
        this.setBackground(color);
        this.setBorder(null);
        this.reportMain = reportMain;
        this.elt = elt;
        this.reportTable = reportTable;
        this.reportUI = reportUI;
        this.sectionID = sectionID;
        this.row = row;
        this.treeStructure = null;
        this.isMetricSystem = reportMain.isCm;
        if (elt != null) {
            this.rowHeight = elt.getHeight();
            this.panelHeight = QbUtil.toPixel(elt.getHeight());
        } else {
            this.rowHeight = 0.3;
            this.panelHeight = QbUtil.toPixel(0.3);
        }
        if (elt instanceof ReportTable) {
            FormattedRow formattedRow = ((ReportTable)elt).getFormattedRow(row, this.treeStructure);
            if (formattedRow != null) {
                this.rowHeight = formattedRow.getRowHeight();
                this.panelHeight = QbUtil.toPixel(this.rowHeight);
            }
        } else if (elt instanceof ReportSection && (height = ((ReportSection)elt).getHeight(this.treeStructure)) >= 0.0) {
            this.rowHeight = height;
            this.panelHeight = QbUtil.toPixel(this.rowHeight);
        }
        double panelWidth = RulerPanel.MAX_XWIDTH;
        this.setPreferredSize(new Dimension(QbUtil.toPixel(panelWidth), this.panelHeight));
        this.setMinimumSize(new Dimension(0, 0));
        this.addMouseListener((MouseListener)this.mAdapter);
        this.addMouseMotionListener((MouseMotionListener)this.mAdapter);
        this.addKeyListener((KeyListener)this.kAdapter);
        this.popupMenu = new PopupMenuForReportElement(reportMain, this);
        this.add(this.popupMenu);
        this.groupFormat = new Vector();
        this.selectingBox = new Vector();
    }

    JComponent getButtonPanel() {
        if (this.button == null) {
            this.button = new JToggleButton(this.sectionID);
            this.reportMain.designPanel.rulerPanel.sectionButtonGroup.add(this.button);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BorderLayout());
            this.buttonPanel.add("Center", this.button);
            Dimension dim = this.buttonPanel.getPreferredSize();
            dim.height = this.panelHeight + this.BUTTONGAP;
            this.buttonPanel.setPreferredSize(dim);
            this.button.setToolTipText(this.sectionID);
            this.button.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ReportElementPanel.this.reportMain.explorer != null) {
                        ReportElementPanel.this.reportMain.explorer.clearSelection();
                    }
                    ReportElementPanel.this.reportMain.deselectGroupOption();
                    ReportElementPanel.this.reportMain.setSelectedObject(ReportElementPanel.this.elt instanceof ReportTable ? ReportElementPanel.this.reportTable : ReportElementPanel.this.elt, ReportElementPanel.this);
                    ReportElementPanel.this.reportMain.designPanel.rulerPanel.repaintButtons();
                    ReportElementPanel.this.selectedPanel();
                    this.popupMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.popupMenu(e);
                }

                void popupMenu(MouseEvent e) {
                    if (!ReportElementPanel.this.popupMenu.isVisible()) {
                        ReportElementPanel.this.popupMenu.setAddPasteOp(false);
                        ReportElementPanel.this.popupMenu.addMenu(ReportElementPanel.this.reportMain.getSelectedObject());
                        ReportElementPanel.this.popupMenu.show(ReportElementPanel.this.button, e.getX(), e.getY());
                    }
                }
            });
        }
        return this.buttonPanel;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintComponent(g, false);
    }

    private void paintComponent(Graphics g, boolean drawBackgroundOnly) {
        try {
            if (this.elt == null) {
                this.elt = new ReportTable();
            }
            double orgHeight = this.elt.getHeight();
            int h = QbUtil.toPixel(orgHeight);
            if (this.offScreenImage == null || this.panelHeight != h) {
                if (this.elt instanceof ReportTable && this.elt != this.reportTable) {
                    ((ReportTable)this.elt).copyTemplate(this.reportTable, this.applyScript, false, true);
                }
                this.panelHeight = h;
                this.flushImage();
                this.offScreenImage = this.createImage(QbUtil.toPixel(RulerPanel.MAX_XWIDTH), h);
            }
            Graphics backBuffer = this.offScreenImage.getGraphics();
            super.paintComponent(backBuffer);
            this.reportUI.initCurrentPosition();
            PageGraphics pgg = new PageGraphics(this.reportUI, backBuffer, 0.0, 0.0);
            pgg.setHighlights(this.groupFormat);
            DesignGraphics.drawGrid(backBuffer, RulerPanel.MAX_XWIDTH, orgHeight, this.isMetricSystem);
            DesignGraphics.drawLine(backBuffer, this.reportMain.report.getActualPageWidth(), orgHeight);
            this.drawComponent(pgg);
            DesignGraphics.setGridStepSize(this.reportMain.report.gridStepSize);
            DesignGraphics.setCmGridStepSize(this.reportMain.report.cmGridStepSize);
            DesignGraphics.drawPoint(backBuffer, RulerPanel.MAX_XWIDTH, orgHeight, this.isMetricSystem);
            this.drawGuideLine(pgg);
            if (!drawBackgroundOnly) {
                backBuffer.setColor(Color.black);
                if (this.reportMain.groupFormatFlag()) {
                    this.reportMain.designPanel.designToolBar2.setGroupObject();
                }
                Graphics bufGraphics = backBuffer;
                bufGraphics.drawImage(this.offScreenImage, 0, 0, this);
                this.drawDraggedObjectsBorder(bufGraphics);
                if (this.groupFormat.size() != 0) {
                    this.drawSelectedObjectsBorder(bufGraphics);
                } else if (this.selectedObject != null && !(this.selectedObject instanceof GuideLine)) {
                    if (!this.reportMain.groupFormatFlag()) {
                        this.reportMain.designPanel.designToolBar2.setObject(this.selectedObject);
                    } else {
                        this.reportMain.designPanel.designToolBar2.setGroupObject();
                    }
                }
                if (this.drawBoundingBox) {
                    this.drawBoundingBox(bufGraphics, 0, 0, 0, 0);
                }
                g.drawImage(this.offScreenImage, 0, 0, this);
            }
            if (this.reportMain.updateYRuler) {
                this.reportMain.designPanel.rulerPanel.yRuler.updateYRuler();
            }
            this.reportMain.updateYRuler = false;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to paint component", ex);
        }
        this.flushImage();
    }

    private void flushImage() {
        if (this.offScreenImage == null) {
            return;
        }
        this.offScreenImage.flush();
        this.offScreenImage = null;
    }

    public void resetOffScreenImage() {
        this.offScreenImage = null;
    }

    private void drawComponent(PageGraphics g) throws Exception {
        if (this.elt instanceof ReportTable) {
            this.reportUI.drawCells(g, (ReportTable)this.elt, this.row, this.treeStructure, -1, -1);
        } else if (this.elt instanceof ReportSection) {
            this.reportUI.drawSection((ReportGraphics)g, (ReportSection)this.elt, this.reportTable, this.treeStructure);
        }
    }

    private void drawGuideLine(PageGraphics g) throws Exception {
        this.reportUI.drawGuideLine(g, this.reportTable, this.elt);
    }

    public boolean isReportSection() {
        return this.elt instanceof ReportSection;
    }

    public ReportElement getElement() {
        return this.elt;
    }

    ReportTable getReportTable() {
        if (this.elt instanceof ReportTable) {
            return (ReportTable)this.elt;
        }
        return this.reportTable;
    }

    public ReportTable getOriginalReportTable() {
        return this.reportTable;
    }

    void setHeight(double inches) {
        this.elt.setHeight(inches);
        if (this.elt instanceof ReportTable) {
            this.reportTable.setHeight(inches);
        }
        Dimension dim = this.buttonPanel.getPreferredSize();
        dim.height = QbUtil.toPixel(inches) + this.BUTTONGAP;
        this.buttonPanel.setPreferredSize(dim);
        this.reportMain.designPanel.rulerPanel.updateButtonPanel();
    }

    void setOneRowHeight(double inches) {
        if (this.elt instanceof ReportTable) {
            this.rowHeight = inches;
            this.panelHeight = QbUtil.toPixel(this.rowHeight);
            FormattedRow formattedRow = this.reportTable.getFormattedRow(this.row, this.treeStructure);
            if (formattedRow == null) {
                formattedRow = new FormattedRow(inches, null);
                this.reportTable.addFormattedRow(this.row, this.treeStructure, formattedRow);
            } else {
                formattedRow.setRowHeight(inches);
            }
            ReportTable table = this.reportMain.report.getReportTables().elementAt(0);
            formattedRow = table.getFormattedRow(this.row, this.treeStructure);
            if (formattedRow == null) {
                formattedRow = new FormattedRow(inches, null);
                table.addFormattedRow(this.row, this.treeStructure, formattedRow);
            } else {
                formattedRow.setRowHeight(inches);
            }
        } else if (this.elt instanceof ReportSection) {
            this.rowHeight = inches;
            this.panelHeight = QbUtil.toPixel(this.rowHeight);
            ((ReportSection)this.elt).addToHeightTable(inches, this.treeStructure);
        }
    }

    public void selectedPanel() {
        this.reportMain.editPanel.setLabel(this.sectionID);
        this.reportMain.editPanel.setField(this.sectionID);
        this.reportMain.editPanel.repaint();
        this.buttonPressed();
    }

    private boolean isGridLine(ReportElement cell) {
        return cell != null && (cell instanceof ReportLine || cell instanceof ReportGrid);
    }

    public double getTotalHeight(ReportElement cell) {
        return this.getTotalHeight(cell, false);
    }

    private double getTotalHeight(ReportElement cell, boolean includeY) {
        return ReportElementPanel.getTotalHeight(cell, this.getVisiblePanels(), includeY);
    }

    private static double getTotalHeight(ReportElement cell, Vector<JPanel> visiblePanel, boolean includeY) {
        double tmp = 0.0;
        if (cell instanceof ReportLine) {
            for (ReportLine node = ((ReportLine)cell).getHeadNode(); node != null; node = node.next()) {
                tmp += (double)QbUtil.toPixel(ReportElementPanel.getCellHeight(node, visiblePanel, includeY));
            }
            return QbUtil.toInch(tmp);
        }
        if (cell instanceof ReportGrid) {
            for (ReportGrid node = ((ReportGrid)cell).getHeadNode(); node != null; node = node.next()) {
                tmp += (double)QbUtil.toPixel(ReportElementPanel.getCellHeight(node, visiblePanel, includeY));
            }
            return QbUtil.toInch(tmp);
        }
        return cell.getHeight() + cell.getY();
    }

    private static double getCellHeight(ReportImage node, Vector<JPanel> visiblePanel, boolean includeY) {
        if (includeY && node.getHeight() >= 0.0) {
            return node.getHeight() + node.getY();
        }
        if (node.getHeight() >= 0.0) {
            return node.getHeight();
        }
        for (int i = 0; i < visiblePanel.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)visiblePanel.elementAt(i);
            if (panel.getElement() instanceof ReportSection) {
                if (((ReportSection)panel.getElement()).update(node) <= -1) continue;
                return ((ReportSection)panel.getElement()).getHeight();
            }
            if (panel.getOriginalReportTable().update(node) > -1) {
                return panel.getOriginalReportTable().getHeight();
            }
            if (panel.getReportTable().update(node) <= -1) continue;
            return panel.getReportTable().getHeight();
        }
        return 0.0;
    }

    private double getCellY(ReportElement elt) {
        double y = 0.0;
        Vector<JPanel> visiblePanel = this.getVisiblePanels();
        for (int i = 0; i < visiblePanel.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)visiblePanel.elementAt(i);
            ReportElement[] elems = panel.getPanelElements();
            if (!(panel.getElement() instanceof ReportSection)) {
                elems = panel.getOriginalReportTable().getAllTableElements();
            }
            boolean found = false;
            for (ReportElement elem : elems) {
                if (elem != elt) continue;
                found = true;
            }
            if (found) break;
            if (panel.getElement() instanceof ReportSection) {
                y += ((ReportSection)panel.getElement()).getHeight();
                continue;
            }
            y += panel.getOriginalReportTable().getHeight();
        }
        return y + elt.getY();
    }

    public ReportElement getHeadNode(ReportElement cell) {
        return ReportElementPanel.getHeadNode(cell, this.getVisiblePanels());
    }

    public static ReportElement getHeadNode(ReportElement cell, Vector<JPanel> visiblePanel) {
        if (cell instanceof ReportLine) {
            ReportLine line = ((ReportLine)cell).getHeadNode();
            int i = ReportElementPanel.getPanel(line, visiblePanel);
            while (i < 0 && line.next() != null) {
                line = line.next();
                i = ReportElementPanel.getPanel(line, visiblePanel);
            }
            return line;
        }
        if (cell instanceof ReportGrid) {
            ReportGrid grid = ((ReportGrid)cell).getHeadNode();
            int i = ReportElementPanel.getPanel(grid, visiblePanel);
            while (i < 0 && grid.next() != null) {
                grid = grid.next();
                i = ReportElementPanel.getPanel(grid, visiblePanel);
            }
            return grid;
        }
        return cell;
    }

    public int getPanel(ReportImage node) {
        return ReportElementPanel.getPanel(node, this.getVisiblePanels());
    }

    public static int getPanel(ReportImage node, Vector<JPanel> visiblePanel) {
        for (int i = 0; i < visiblePanel.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)visiblePanel.elementAt(i);
            if (panel.getElement() instanceof ReportSection) {
                if (((ReportSection)panel.getElement()).update(node) <= -1) continue;
                return i;
            }
            if (panel.getOriginalReportTable().update(node) > -1) {
                return i;
            }
            if (panel.getReportTable().update(node) <= -1) continue;
            return i;
        }
        return -1;
    }

    void drawBorder(Graphics g, int diffX, int diffY, int deltaX, int deltaY, ReportElement cell) {
        this.drawBorder(g, diffX, diffY, deltaX, deltaY, cell, true);
    }

    private void drawBorder(Graphics g, int diffX, int diffY, int deltaX, int deltaY, ReportElement cell, boolean dispose) {
        if (!this.reportMain.isDesignMode && cell instanceof ReportColumn) {
            try {
                ReportElement relt = ((ReportColumn)cell).getFormatCell(this.row);
                if (relt instanceof FormattedCell) {
                    cell = relt;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to format cell", ex);
            }
        }
        if (!IOUtil.isMac() || IOUtil.isJava14()) {
            g.setXORMode(this.getBackground());
        }
        GridLine gl = new GridLine(this.getVisiblePanels());
        if (cell == null) {
            ReportGraphics.drawDashRect(diffX, diffY, QbUtil.toPixel(1.0), QbUtil.toPixel(0.3), g);
            if (diffX != deltaX || diffY != deltaY) {
                ReportGraphics.drawDashRect(deltaX, deltaY, QbUtil.toPixel(1.0), QbUtil.toPixel(0.3), g);
            }
        } else if (this.isDragOp) {
            if (!this.reportMain.isAllowCrosstabElementMove() && (this.reportMain.selectedPanel.getElement() instanceof CrossTabReportSection || this.reportMain.selectedPanel.getElement() instanceof ReportTable && this.reportMain.report.isCrossTab())) {
                new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You cannot insert element to CrossTab report section!"));
                return;
            }
            if (!this.skipDrawDraggedObjects || ReportElementPanel.isGridOrVertLine(cell)) {
                int dragY = this.draggedObjects.size() > 0 ? (!ReportElementPanel.isGridOrVertLine(cell) && !ReportElementPanel.contains(this.elt, cell) ? QbUtil.toPixel(cell.getY()) + this.draggedDy - this.dragDashYOffset : QbUtil.toPixel(cell.getY()) + diffY) : QbUtil.toPixel(cell.getY()) + diffY;
                this.drawDashRect(cell, QbUtil.toPixel(cell.getX()) + diffX, dragY, QbUtil.toPixel(cell.getWidth()), QbUtil.toPixel(cell.getHeight()), g);
            }
            if (diffX != deltaX || diffY != deltaY) {
                if (this.draggedObjects.size() == 0 || !ReportElementPanel.isGridOrVertLine(cell) && ReportElementPanel.contains(this.elt, cell)) {
                    this.drawDashRect(cell, QbUtil.toPixel(cell.getX()) + deltaX, QbUtil.toPixel(cell.getY()) + deltaY, QbUtil.toPixel(cell.getWidth()), QbUtil.toPixel(cell.getHeight()), g);
                }
                int i = QbUtil.toPixel(cell.getX());
                int j = QbUtil.toPixel(cell.getY());
                int w = QbUtil.toPixel(cell.getWidth());
                int h = QbUtil.toPixel(this.getTotalHeight(cell) - cell.getY());
                int index = this.getPanelIndex();
                if (this.isGridLine(cell)) {
                    index = this.getPanel((ReportImage)cell);
                }
                int ht = this.getOffSet(index);
                if (QbUtil.toPixel(cell.getX()) + deltaX >= 1) {
                    if (this.selectedObject instanceof ReportLine && !((ReportLine)this.selectedObject).isVertical()) {
                        this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(i + deltaX, i + deltaX + w);
                    }
                    if (!(this.selectedObject instanceof ReportLine)) {
                        this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(i + deltaX, i + deltaX + w);
                    }
                } else {
                    if (this.selectedObject instanceof ReportLine && !((ReportLine)this.selectedObject).isVertical()) {
                        this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(1, 1 + w);
                    }
                    if (!(this.selectedObject instanceof ReportLine)) {
                        this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(1, 1 + w);
                    }
                }
                if (this.isGridLine(cell)) {
                    if (!(this.selectedObject instanceof ReportLine) || ((ReportLine)this.selectedObject).isVertical()) {
                        this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(j + deltaY + ht, j + deltaY + h + ht + gl.getOffset(index, j + deltaY, j + deltaY + h));
                    }
                } else if (QbUtil.toPixel(cell.getY()) + deltaY >= 1) {
                    this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(j + deltaY + ht, j + deltaY + h + ht);
                } else {
                    this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(ht + 1, ht + 1 + h);
                }
            }
        } else if (this.isResizeOp || this.isSelectOp) {
            if (diffX != deltaX || diffY != deltaY) {
                this.drawDashRect(cell, QbUtil.toPixel(cell.getX()), QbUtil.toPixel(cell.getY()), QbUtil.toPixel(cell.getWidth()) + deltaX, QbUtil.toPixel(cell.getHeight()) + deltaY, g);
                int xInPx = QbUtil.toPixel(cell.getX());
                int yInPx = QbUtil.toPixel(cell.getY());
                int w = QbUtil.toPixel(cell.getWidth());
                int h = QbUtil.toPixel(this.getTotalHeight(cell) - cell.getY());
                int index = this.getPanelIndex();
                if (this.isGridLine(cell)) {
                    index = this.getPanel((ReportImage)cell);
                }
                int ht = this.getOffSet(index);
                if (this.selectedObject instanceof ReportLine && !((ReportLine)this.selectedObject).isVertical()) {
                    this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(xInPx, xInPx + deltaX + w);
                }
                if (!(this.selectedObject instanceof ReportLine)) {
                    this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(xInPx, xInPx + deltaX + w + 2);
                    this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(yInPx + ht, yInPx + ht + deltaY + h + 2);
                }
                if (this.selectedObject instanceof ReportLine && ((ReportLine)this.selectedObject).isVertical()) {
                    this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(yInPx + ht, yInPx + ht + deltaY + h + 2 + gl.getOffset(index, yInPx, yInPx + ht + deltaY + h + 2));
                }
            } else {
                this.drawDashRect(cell, QbUtil.toPixel(cell.getX()), QbUtil.toPixel(cell.getY()), QbUtil.toPixel(cell.getWidth()) + diffX, QbUtil.toPixel(cell.getHeight()) + diffY, g);
            }
        } else if (this.isResizeOpFromRuler) {
            ReportGraphics.drawDashRect(QbUtil.toPixel(cell.getX()), QbUtil.toPixel(cell.getY()), QbUtil.toPixel(cell.getWidth()) + diffX, QbUtil.toPixel(cell.getHeight()) + diffY, g);
            if (diffX != deltaX || diffY != deltaY) {
                ReportGraphics.drawDashRect(QbUtil.toPixel(cell.getX()), QbUtil.toPixel(cell.getY()), QbUtil.toPixel(cell.getWidth()) + deltaX, QbUtil.toPixel(cell.getHeight()) + deltaY, g);
            }
        } else if (this.isDragOpFromRuler) {
            ReportGraphics.drawDashRect(QbUtil.toPixel(cell.getX()) + diffX, QbUtil.toPixel(cell.getY()) + diffY, QbUtil.toPixel(cell.getWidth()), QbUtil.toPixel(cell.getHeight()), g);
            if (diffX != deltaX || diffY != deltaY) {
                ReportGraphics.drawDashRect(QbUtil.toPixel(cell.getX()) + deltaX, QbUtil.toPixel(cell.getY()) + deltaY, QbUtil.toPixel(cell.getWidth()), QbUtil.toPixel(cell.getHeight()), g);
            }
        }
        if (dispose) {
            g.dispose();
        }
    }

    public void buttonReleased() {
        if (this.button == null) {
            return;
        }
        this.button.setSelected(false);
    }

    public void buttonPressed() {
        if (this.button == null) {
            return;
        }
        this.button.setSelected(true);
    }

    public int getPanelIndex() {
        Vector<JPanel> vec = this.getVisiblePanels();
        int size = vec.size();
        int i = 0;
        boolean found = false;
        while (i < size && !found) {
            if (vec.elementAt(i) == this) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public int getOffSet(int index) {
        int height = 0;
        for (int i = 0; i < index; ++i) {
            ReportElementPanel ele = (ReportElementPanel)this.getVisiblePanels().elementAt(i);
            boolean isVisible = ele.isElementVisible();
            if (!isVisible) continue;
            height += ele.getHeight() + new JSplitPane().getDividerSize();
        }
        return height;
    }

    public void mousePressedFromRuler(int h, int v, boolean Drag, boolean Resize) {
        this.previousX = h;
        this.previousY = v;
        this.diffY = 0;
        this.diffX = 0;
        this.isDragOpFromRuler = Drag;
        this.isResizeOpFromRuler = Resize;
    }

    public void mouseReleasedFromRuler(int h, int v) {
        this.clearAllDraggedObjects();
        int x = h;
        int y = v;
        if (this.previousX != x || this.previousY != y) {
            if (this.isDragOpFromRuler) {
                if (this.selectedObject == null || NormalAdapter.isNonMovableElement((ReportElementPanel)this)) {
                    this.repaintPanel();
                    return;
                }
                ReportElement cell = this.selectedObject;
                if (this.selectedObject instanceof ColumnWrap) {
                    this.resetSelectedObject();
                    this.updateRulers();
                    return;
                }
                if (Math.abs(this.previousX - x) >= 2 || Math.abs(this.previousY - y) > 2) {
                    this.reportMain.createBackupReport();
                }
                if (!this.reportMain.isShiftSelected) {
                    if (this.isGridLine(cell)) {
                        boolean isVert;
                        boolean bl = isVert = cell instanceof ReportLine && ((ReportLine)cell).isVertical();
                        if (cell.isLocked()) {
                            this.reportMain.setSelectedObject(cell, this.reportMain.selectedPanel);
                            this.updateRulers();
                        } else if (cell instanceof GuideLine) {
                            double xx = cell.getX() + (double)(x - this.previousX) / (double)QbUtil.getPixelPerInch();
                            double yy = cell.getY() + (double)(y - this.previousY) / (double)QbUtil.getPixelPerInch();
                            GuideLine gl = this.reportMain.designPanel.rulerPanel.createGuideLine(xx, yy, isVert, this.elt);
                            gl.copyElts((GuideLine)cell);
                            gl.alignElts();
                            this.reportMain.report.replaceGuideLine((GuideLine)cell, gl);
                            this.reportMain.designPanel.rulerPanel.removeGuideLine((GuideLine)cell);
                            this.reportMain.menuBar.setUndoEnabled(false);
                            this.reportMain.setSelectedObject(gl, this.reportMain.selectedPanel);
                        } else {
                            cell = this.getHeadNode(cell);
                            GridLine gl = new GridLine(this.getVisiblePanels());
                            int deltaY = y - this.previousY;
                            if (cell.getSnap() > 0) {
                                deltaY = 0;
                            }
                            ReportCell newcell = gl.set(this.getPanel((ReportImage)cell), QbUtil.toPixel(cell.getX()) + (x - this.previousX), QbUtil.toPixel(cell.getY()) + deltaY, QbUtil.toPixel(cell.getWidth() + cell.getX()) + (x - this.previousX), QbUtil.toPixel(this.getTotalHeight(cell)) + deltaY, cell instanceof ReportLine, isVert, cell);
                            if (cell.getSnap() > 0 || cell.getVSnap() > 0) {
                                Vector<GuideLine> guidelines = this.findGuideLines(cell);
                                for (int i = 0; i < guidelines.size(); ++i) {
                                    guidelines.elementAt(i).replace(newcell, cell);
                                }
                            }
                            this.reportMain.selectedPanel.select(cell, true);
                            this.reportMain.selectedPanel.select(newcell, false);
                            gl.remove(cell);
                            cell = newcell;
                            this.updateRulers(newcell);
                        }
                    } else {
                        cell.setX(cell.getX() + (double)(x - this.previousX) / (double)QbUtil.getPixelPerInch());
                        cell.setY(cell.getY() + (double)(y - this.previousY) / (double)QbUtil.getPixelPerInch());
                        this.updateRulers();
                    }
                } else {
                    double w = (double)(x - this.previousX) / (double)QbUtil.getPixelPerInch();
                    double h0 = (double)(y - this.previousY) / (double)QbUtil.getPixelPerInch();
                    if (cell instanceof GuideLine) {
                        boolean isVert = (cell = this.getHeadNode(cell)) instanceof ReportLine && ((ReportLine)cell).isVertical();
                        double xx = cell.getX() + w;
                        double yy = cell.getY() + h0;
                        GuideLine gl = this.reportMain.designPanel.rulerPanel.createGuideLine(xx, yy, isVert, this.elt);
                        gl.copyElts((GuideLine)cell);
                        gl.alignEltsWithShift(this.reportMain.designPanel.rulerPanel.getPanelElement(), w, h0);
                        this.reportMain.report.replaceGuideLine((GuideLine)cell, gl);
                        this.reportMain.designPanel.rulerPanel.removeGuideLine((GuideLine)cell);
                        this.reportMain.menuBar.setUndoEnabled(false);
                        this.reportMain.setSelectedObject(gl, this.reportMain.selectedPanel);
                    } else {
                        this.reportMain.createBackupReport();
                        if (this.isReportSection()) {
                            ReportSection rs = (ReportSection)this.elt;
                            rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rs.shiftOnMove(this.selectedObject, true, w);
                            rs.shiftOnMove(this.selectedObject, false, h0);
                        } else {
                            ReportTable rt = this.getOriginalReportTable();
                            rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rt.shiftOnMove(this.selectedObject, true, w);
                            rt.shiftOnMove(this.selectedObject, false, h0);
                        }
                    }
                }
                this.reportMain.setModified();
                if (this.isGridLine(cell) || cell instanceof GuideLine) {
                    this.reportMain.repaintPanel();
                } else {
                    this.repaintPanel();
                }
            } else if (this.isResizeOpFromRuler) {
                if (this.selectedObject == null) {
                    return;
                }
                if (this.selectedObject instanceof GuideLine || this.selectedObject instanceof ColumnWrap) {
                    this.resetSelectedObject();
                    this.updateRulers();
                    return;
                }
                if (!(NormalAdapter.isNonMovableElement((ReportElementPanel)this) || Math.abs(this.previousX - x) < 2 && Math.abs(this.previousY - y) <= 2)) {
                    this.reportMain.createBackupReport();
                }
                ReportElement cell = this.selectedObject;
                if (!this.reportMain.isShiftSelected) {
                    double th;
                    cell = this.getHeadNode(cell);
                    double resW = 0.01;
                    double resH = 0.01;
                    if (cell.getWidth() + (double)(x - this.previousX) / (double)QbUtil.getPixelPerInch() >= 0.02) {
                        resW = cell.getWidth() + (double)(x - this.previousX) / (double)QbUtil.getPixelPerInch();
                    }
                    if ((th = this.getTotalHeight(cell) - cell.getY()) + (double)(y - this.previousY) / (double)QbUtil.getPixelPerInch() >= 0.02) {
                        resH = th + (double)(y - this.previousY) / (double)QbUtil.getPixelPerInch();
                    }
                    if (this.isGridLine(cell) && cell.isLocked()) {
                        this.reportMain.setSelectedObject(cell, this.reportMain.selectedPanel);
                        this.updateRulers();
                    } else if (this.isGridLine(cell)) {
                        boolean isVert = cell instanceof ReportLine && ((ReportLine)cell).isVertical();
                        cell = this.getHeadNode(cell);
                        GridLine gl = new GridLine(this.getVisiblePanels());
                        int index = this.getPanel((ReportImage)cell);
                        ReportCell newcell = gl.set(index, QbUtil.toPixel(cell.getX()), QbUtil.toPixel(cell.getY()), QbUtil.toPixel(resW + cell.getX()), QbUtil.toPixel(resH + cell.getY()), cell instanceof ReportLine, isVert, cell);
                        if (cell.getSnap() > 0 || cell.getVSnap() > 0) {
                            Vector<GuideLine> guidelines = this.findGuideLines(cell);
                            for (int i = 0; i < guidelines.size(); ++i) {
                                guidelines.elementAt(i).replace(newcell, cell);
                            }
                        }
                        this.reportMain.selectedPanel.select(cell, true);
                        gl.remove(cell);
                        cell = newcell;
                        this.reportMain.selectedPanel.select(newcell, false);
                        this.updateRulers(newcell);
                    } else {
                        cell.setWidth(resW);
                        cell.setHeight(resH);
                    }
                } else {
                    double width = cell.getWidth();
                    double height = cell.getHeight();
                    int w = QbUtil.toPixel(width) + (x - this.previousX);
                    int h0 = QbUtil.toPixel(height) + (y - this.previousY);
                    double w1 = (double)(x - this.previousX) / (double)QbUtil.getPixelPerInch();
                    double h1 = (double)(y - this.previousY) / (double)QbUtil.getPixelPerInch();
                    double x0 = cell.getWidth();
                    double y0 = cell.getHeight();
                    this.reportMain.createBackupReport();
                    this.reportMain.menuBar.setUndoEnabled(false);
                    if (w >= 1 && h0 >= 1) {
                        if (this.isReportSection()) {
                            ReportSection rs = (ReportSection)this.elt;
                            rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rs.shift(cell, true, w1);
                            rs.shift(cell, false, h1);
                        } else {
                            ReportTable rt = this.getOriginalReportTable();
                            rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rt.shift(cell, true, w1);
                            rt.shift(cell, false, h1);
                        }
                    } else if (w < 1 && h0 >= 1) {
                        if (this.isReportSection()) {
                            ReportSection rs = (ReportSection)this.elt;
                            rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rs.shift(cell, true, -x0);
                            rs.shift(cell, false, h1);
                        } else {
                            ReportTable rt = this.getOriginalReportTable();
                            rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rt.shift(cell, true, -x0);
                            rt.shift(cell, false, h1);
                        }
                    } else if (w >= 1 && h0 < 1) {
                        if (this.isReportSection()) {
                            ReportSection rs = (ReportSection)this.elt;
                            rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rs.shift(cell, true, w1);
                            rs.shift(cell, false, -y0);
                        } else {
                            ReportTable rt = this.getOriginalReportTable();
                            rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                            rt.shift(cell, true, w1);
                            rt.shift(cell, false, -y0);
                        }
                    } else if (this.isReportSection()) {
                        ReportSection rs = (ReportSection)this.elt;
                        rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                        rs.shift(cell, true, -x0);
                        rs.shift(cell, false, -y0);
                    } else {
                        ReportTable rt = this.getOriginalReportTable();
                        rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                        rt.shift(cell, true, -x0);
                        rt.shift(cell, false, -y0);
                    }
                }
                this.reportMain.setModified();
                if (this.isGridLine(cell) || cell instanceof GuideLine) {
                    this.reportMain.repaintPanel();
                } else {
                    this.repaintPanel();
                }
            }
        }
        this.isDragOpFromRuler = false;
        this.isResizeOpFromRuler = false;
        this.diffY = -1;
        this.diffX = -1;
        this.previousY = -1;
        this.previousX = -1;
    }

    public void deselectFormatSection() {
        this.groupFormat.clear();
    }

    void resetSelectedObject() {
        this.selectedObject = null;
        this.reportMain.setCopyCutEnabled(false);
        this.reportMain.designPanel.designToolBar2.resetObject();
    }

    public ReportElement findSelectedObject(double x, double y, boolean next, String eltID) {
        this.curSelectedElts = new Vector();
        try {
            if (this.elt instanceof ReportTable) {
                int[] iarray = this.reportTable.findImageIndex(x, y);
                if (iarray != null) {
                    for (int element : iarray) {
                        this.curSelectedElts.addElement(this.reportTable.getImage(element));
                    }
                }
                if ((iarray = this.reportTable.findRowElementIndex(x, y, this.row)) != null) {
                    for (int element : iarray) {
                        this.curSelectedElts.addElement(this.reportTable.getRowElement(this.row, element));
                    }
                }
                if ((iarray = this.reportTable.findReportColumnIndex(x, y, this.row)) != null) {
                    for (int element : iarray) {
                        if (!this.reportMain.isDesignMode && this.reportTable.getColumn(element).getFormattedCellAtRow(this.row) != null) {
                            FormattedCell cell = (FormattedCell)this.reportTable.getColumn(element).getFormatCell(this.row);
                            cell.setColumnIndex(element);
                            this.curSelectedElts.addElement(cell);
                        }
                        this.curSelectedElts.addElement(this.reportTable.getColumn(element));
                    }
                }
                if ((iarray = this.reportTable.findSubReportIndex(x, y)) != null) {
                    for (int element : iarray) {
                        this.curSelectedElts.addElement(this.reportTable.getSubReport(element));
                    }
                }
                if ((iarray = this.reportTable.findRTFObjectIndex(x, y)) != null) {
                    for (int element : iarray) {
                        this.curSelectedElts.addElement(this.reportTable.getRTFObject(element));
                    }
                }
                if (this.reportTable.findMasterSection(x, y) != null) {
                    this.curSelectedElts.addElement(this.reportTable.findMasterSection(x, y));
                }
                if (eltID != null) {
                    for (int j = 0; j < this.curSelectedElts.size(); ++j) {
                        ReportElement jElt = this.curSelectedElts.elementAt(j);
                        if (!jElt.getID().equals(eltID)) continue;
                        return this.filterElementForSecurity(jElt);
                    }
                }
                if (this.prevSelectedElts.size() != this.curSelectedElts.size()) {
                    this.prevSelectedElts = this.curSelectedElts;
                    this.selectedIndex = 0;
                    return this.filterElementForSecurity(this.curSelectedElts, 0);
                }
                for (int j = 0; j < this.prevSelectedElts.size(); ++j) {
                    if (this.prevSelectedElts.elementAt(j) == this.curSelectedElts.elementAt(j)) continue;
                    this.prevSelectedElts = this.curSelectedElts;
                    this.selectedIndex = 0;
                    return this.filterElementForSecurity(this.curSelectedElts, 0);
                }
                if (next) {
                    ++this.selectedIndex;
                }
                if (this.selectedIndex == this.prevSelectedElts.size()) {
                    this.selectedIndex = 0;
                }
                return this.filterElementForSecurity(this.curSelectedElts, this.selectedIndex);
            }
            if (this.elt instanceof ReportSection) {
                int[] iarray;
                if (((ReportSection)this.elt).findTOC(x, y) != null) {
                    this.curSelectedElts.addElement(((ReportSection)this.elt).findTOC(x, y));
                }
                if ((iarray = ((ReportSection)this.elt).findImageIndex(x, y, this.treeStructure)) != null) {
                    for (int element : iarray) {
                        this.curSelectedElts.addElement(((ReportSection)this.elt).getData(element));
                    }
                }
                if (!this.reportMain.isDesignMode && (iarray = ((ReportSection)this.elt).findSectionCellIndex(x, y, this.treeStructure)) != null) {
                    for (int element : iarray) {
                        this.curSelectedElts.addElement(((ReportSection)this.elt).getSectionCell(element, this.treeStructure));
                    }
                }
                if ((iarray = ((ReportSection)this.elt).findReportCellIndex(x, y, this.treeStructure)) != null) {
                    for (int element : iarray) {
                        ReportCell cell = ((ReportSection)this.elt).getData(element);
                        if (!this.reportMain.isDesignMode && ((ReportSection)this.elt).hasFormattedCell(cell, this.treeStructure)) {
                            this.curSelectedElts.addElement(((ReportSection)this.elt).getFormattedCell(cell, this.treeStructure));
                            continue;
                        }
                        this.curSelectedElts.addElement(cell);
                    }
                }
                if (eltID != null) {
                    for (int j = 0; j < this.curSelectedElts.size(); ++j) {
                        ReportElement jElt = this.curSelectedElts.elementAt(j);
                        if (!jElt.getID().equals(eltID)) continue;
                        return this.filterElementForSecurity(jElt);
                    }
                }
                if (this.prevSelectedElts.size() != this.curSelectedElts.size()) {
                    this.prevSelectedElts = this.curSelectedElts;
                    this.selectedIndex = 0;
                    return this.filterElementForSecurity(this.curSelectedElts, 0);
                }
                for (int j = 0; j < this.prevSelectedElts.size(); ++j) {
                    if (this.prevSelectedElts.elementAt(j) == this.curSelectedElts.elementAt(j)) continue;
                    this.prevSelectedElts = this.curSelectedElts;
                    this.selectedIndex = 0;
                    return this.filterElementForSecurity(this.curSelectedElts, 0);
                }
                if (next) {
                    ++this.selectedIndex;
                }
                if (this.selectedIndex == this.prevSelectedElts.size()) {
                    this.selectedIndex = 0;
                }
                return this.filterElementForSecurity(this.curSelectedElts, this.selectedIndex);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Cannot find selected object", e);
            return null;
        }
    }

    private ReportElement filterElementForSecurity(Vector<ReportElement> elements, int index) {
        if (elements == null || index < 0 || index >= elements.size()) {
            return null;
        }
        return this.filterElementForSecurity(elements.elementAt(index));
    }

    private ReportElement filterElementForSecurity(ReportElement element) {
        if (this.reportMain != null && element != null && this.reportMain.isSecureMode() && element.isSecurityLevelDefined()) {
            return null;
        }
        return element;
    }

    private ReportElement[] getPanelElements() {
        ReportElement[] elts = null;
        if (this.elt instanceof ReportTable) {
            Vector<ReportColumn> columns = this.reportTable.getColumns();
            elts = new ReportElement[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                elts[i] = columns.elementAt(i);
            }
        } else if (this.elt instanceof ReportSection) {
            elts = ((ReportSection)this.elt).getData();
        }
        return elts;
    }

    boolean isElementVisible() {
        if (this.elt instanceof ReportTableElement) {
            return ((ReportTableElement)this.elt).isVisible();
        }
        return true;
    }

    void setElementVisible(boolean b) {
        if (this.elt instanceof ReportSection) {
            ((ReportTableElement)this.elt).setVisible(b);
        } else if (this.elt instanceof ReportTable) {
            this.reportTable.setVisible(b);
        }
    }

    public String getElementName() {
        return this.sectionID;
    }

    void drawGridAndPointInINCH() {
        this.resetOffScreenImage();
        this.isMetricSystem = false;
        this.repaint();
    }

    void drawGridAndPointInCM() {
        this.resetOffScreenImage();
        this.isMetricSystem = true;
        this.repaint();
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndY() {
        return this.endY;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getOriginX() {
        return this.originX;
    }

    public void setOriginX(int x) {
        this.originX = x;
    }

    private void drawBoundingBox(Graphics g, int diffX, int diffY, int deltaX, int deltaY) {
        if (!IOUtil.isMac() || IOUtil.isJava14()) {
            g.setXORMode(this.getBackground());
        }
        if (this.drawBoundingBox) {
            g.drawRect(this.boundingX, this.boundingY, this.boundingWidth, this.boundingHeight);
        } else if (this.isDragBoundingBoxOp) {
            g.drawRect(this.boundingX + diffX, this.boundingY + diffY, this.boundingWidth, this.boundingHeight);
            if (diffX != deltaX || diffY != deltaY) {
                g.drawRect(this.boundingX + deltaX, this.boundingY + deltaY, this.boundingWidth, this.boundingHeight);
            }
        } else if (this.isResizeBoundingBoxOp) {
            g.drawRect(this.boundingX, this.boundingY, this.boundingWidth + diffX, this.boundingHeight + diffY);
            if (diffX != deltaX || diffY != deltaY) {
                g.drawRect(this.boundingX, this.boundingY, this.boundingWidth + deltaX, this.boundingHeight + deltaY);
            }
        }
        g.dispose();
    }

    public void repaintPanel() {
        this.reportMain.setModified();
        this.resetOffScreenImage();
        this.repaint();
    }

    public void repaintFromScratch() {
        this.offScreenImage = null;
        this.repaint();
    }

    public void setGroupVerticalAlignment(short align) {
        this.setGroupVerticalAlignment(align, true);
    }

    public void setGroupVerticalAlignment(short align, boolean recalcBoundingBox) {
        this.reportMain.createBackupReport();
        this.reportMain.menuBar.setUndoEnabled(false);
        if (recalcBoundingBox) {
            this.setBoundingBoxForGroupAlign();
        }
        Vector<ReportElement> vct = new Vector<ReportElement>();
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement relt = this.groupFormat.elementAt(i);
            if (relt instanceof ReportLine || relt instanceof ReportGrid) continue;
            vct.addElement(relt);
        }
        ReportElement[] re = new ReportElement[vct.size()];
        for (int i = 0; i < vct.size(); ++i) {
            re[i] = (ReportElement)vct.elementAt(i);
        }
        Vector<Object> temp = ReportElement.sortElementHorizontally(re);
        if (temp.size() > 0) {
            ReportElement[] row1;
            if (align == 2) {
                Vector<ReportElement[]> temp2 = new Vector<ReportElement[]>();
                for (int i = 0; i < temp.size(); ++i) {
                    temp2.addElement(temp.elementAt(temp.size() - 1 - i));
                }
                temp = temp2;
            }
            if ((row1 = temp.elementAt(0)) != null && row1.length > 0) {
                double y = this.findYValue(row1, align);
                double h = row1[0].getHeight();
                for (int j = 0; j < Array.getLength(row1); ++j) {
                    ReportElement relt = row1[j];
                    relt.setY(y);
                    if (!(row1[j].getHeight() > h)) continue;
                    h = row1[j].getHeight();
                }
                for (int i = 1; i < temp.size(); ++i) {
                    ReportElement[] row = (ReportElement[])temp.elementAt(i);
                    y = align == 1 ? (y += h) : (y -= h);
                    for (int j = 0; j < Array.getLength(row); ++j) {
                        ReportElement relt = row[j];
                        relt.setY(y);
                        if (!(row[j].getHeight() > h)) continue;
                        h = row[j].getHeight();
                    }
                }
            }
        }
        this.repaintPanel();
    }

    private double findYValue(ReportElement[] row, short align) {
        double y = row[0].getY();
        for (int i = 1; i < Array.getLength(row); ++i) {
            if (align == 1 && row[i].getY() < y) {
                y = row[i].getY();
            }
            if (align != 2 || !(row[i].getY() > y)) continue;
            y = row[i].getY();
        }
        return y;
    }

    public void setGroupAlignment(short align) {
        this.setGroupAlignment(align, true);
    }

    public void setGroupAlignment(short align, boolean recalcBoundingBox) {
        this.reportMain.createBackupReport();
        this.reportMain.menuBar.setUndoEnabled(false);
        if (recalcBoundingBox) {
            this.setBoundingBoxForGroupAlign();
        }
        Vector<ReportElement> vct = new Vector<ReportElement>();
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement relt = this.groupFormat.elementAt(i);
            if (relt instanceof ReportLine || relt instanceof ReportGrid) continue;
            vct.addElement(relt);
        }
        ReportElement[] re = new ReportElement[vct.size()];
        for (int i = 0; i < vct.size(); ++i) {
            re[i] = (ReportElement)vct.elementAt(i);
        }
        Vector<ReportElement[]> temp = ReportElement.sortElementHorizontally(re);
        if (align == 1) {
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement[] r = temp.elementAt(j);
                if (r == null || r.length == 0) continue;
                ReportElement t0 = r[0];
                t0.setX((double)this.boundingX / (double)QbUtil.toPixel(1.0));
                int x_pixel = t0.getXPos() + t0.getWidthOfElement();
                for (int k = 0; k < Array.getLength(r) - 1; ++k) {
                    ReportElement t2 = r[k + 1];
                    t2.setX(QbUtil.toInch(x_pixel));
                    x_pixel += t2.getWidthOfElement();
                }
            }
        } else if (align == 2) {
            for (int j = 0; j < temp.size(); ++j) {
                ReportElement[] r = temp.elementAt(j);
                if (r == null || r.length == 0) continue;
                ReportElement t0 = r[r.length - 1];
                t0.setX(((double)this.boundingX + (double)this.boundingWidth) / (double)QbUtil.toPixel(1.0) - t0.getWidth());
                int x_pixel = t0.getXPos();
                for (int k = r.length - 1; k > 0; --k) {
                    ReportElement t2 = r[k - 1];
                    t2.setX(QbUtil.toInch(x_pixel -= t2.getWidthOfElement()));
                }
            }
        } else if (align == 0) {
            double pageWidth = this.reportMain.report.getActualPageWidth();
            double minX = ReportElement.getMinX(re);
            int page = (int)Math.floor(minX / pageWidth);
            double groupMidPoint = (minX + ReportElement.getMaxXr(re)) / 2.0;
            double difference = pageWidth / 2.0 - (groupMidPoint -= pageWidth * (double)page);
            for (ReportElement element : re) {
                element.setX(element.getX() + difference);
                if (!(element.getX() < 0.0)) continue;
                element.setX(0.0);
            }
        }
        this.repaintPanel();
    }

    void popupAlignmentDialog() {
        GroupAlignmentDialog alignment = new GroupAlignmentDialog(this.reportMain);
        alignment.setVisible(true);
    }

    public void setSelectColumn(ReportElement selectedElt) {
        this.reportMain.createBackupReport();
        Vector<JPanel> panel = this.getVisiblePanels();
        int startPanel = -1;
        for (int i = 0; i < panel.size(); ++i) {
            ReportElementPanel reportElementPanel;
            JPanel temp = panel.elementAt(i);
            if (!(temp instanceof ReportElementPanel) || !this.isTablePanel(reportElementPanel = (ReportElementPanel)temp)) continue;
            ReportElement elt = reportElementPanel.getElement();
            if (elt instanceof ReportSection) {
                ReportCell[] rc = ((ReportSection)elt).getData();
                for (int j = 0; j < Array.getLength(rc); ++j) {
                    ReportElement t = this.filterElementForSecurity(rc[j]);
                    if (t == null || t instanceof GuideLine || selectedElt != t && !this.isOverLapping_in_X(selectedElt, t)) continue;
                    if (startPanel == -1) {
                        startPanel = i;
                    }
                    reportElementPanel.select(t, false);
                }
            }
            if (elt instanceof ReportTable) {
                ReportTable rt = this.getOriginalReportTable();
                ReportElement[] rc = rt.getTableElements();
                for (int j = 0; j < Array.getLength(rc); ++j) {
                    ReportElement t = this.filterElementForSecurity(rc[j]);
                    if (t == null || t instanceof GuideLine || selectedElt != t && !this.isOverLapping_in_X(selectedElt, t)) continue;
                    if (startPanel == -1) {
                        startPanel = i;
                    }
                    reportElementPanel.select(t, false);
                }
            }
            this.selectedObject = null;
            this.reportMain.setModified();
        }
    }

    public void setSelectRow(ReportElement selectedElt) {
        ReportElementPanel panel1;
        this.reportMain.createBackupReport();
        if (this.elt instanceof ReportSection) {
            if (this.reportMain.isDesignMode) {
                ReportCell[] rc = ((ReportSection)this.elt).getData();
                for (int j = 0; j < Array.getLength(rc); ++j) {
                    ReportElement t = this.filterElementForSecurity(rc[j]);
                    if (t == null || t instanceof GuideLine || selectedElt != t && !this.isOverLapping_in_Y(selectedElt, t)) continue;
                    this.select(t, false);
                }
            } else {
                int i;
                ReportCell[] cells = ((ReportSection)this.elt).getData();
                for (int i2 = 0; i2 < cells.length; ++i2) {
                    if (!((ReportSection)this.elt).hasFormattedCell(cells[i2], this.treeStructure)) continue;
                    cells[i2] = ((ReportSection)this.elt).getFormattedCell(cells[i2], this.treeStructure);
                }
                Vector<ReportCell> sectionCells = ((ReportSection)this.elt).getSectionCells(this.treeStructure);
                int sectionCellSize = 0;
                if (sectionCells != null) {
                    sectionCellSize = sectionCells.size();
                }
                ReportCell[] rc = new ReportCell[cells.length + sectionCellSize];
                for (i = 0; i < cells.length; ++i) {
                    rc[i] = cells[i];
                }
                for (i = 0; i < sectionCellSize; ++i) {
                    rc[cells.length + i] = sectionCells.elementAt(i);
                }
                for (int j = 0; j < Array.getLength(rc); ++j) {
                    ReportCell t = rc[j];
                    if (t == null || t instanceof GuideLine || selectedElt != t && !this.isOverLapping_in_Y(selectedElt, t)) continue;
                    this.groupFormat.addElement(t);
                }
            }
        }
        if (this.elt instanceof ReportTable) {
            ReportTable rt;
            if (this.reportMain.isDesignMode) {
                rt = this.getOriginalReportTable();
                ReportElement[] rc = rt.getTableElements();
                for (int j = 0; j < Array.getLength(rc); ++j) {
                    ReportElement t = this.filterElementForSecurity(rc[j]);
                    if (t == null || t instanceof GuideLine || selectedElt != t && !this.isOverLapping_in_Y(selectedElt, t)) continue;
                    this.select(t, false);
                }
            } else {
                Vector<ReportElement> rowElements;
                rt = this.getOriginalReportTable();
                Vector<ReportColumn> col = rt.getColumns();
                Vector<ReportElement> relt = new Vector<ReportElement>();
                for (int i = 0; i < col.size(); ++i) {
                    ReportColumn column = col.elementAt(i);
                    FormattedCell cell = column.getFormattedCellAtRow(this.row);
                    if (cell != null) {
                        relt.addElement(cell);
                        continue;
                    }
                    relt.addElement(column);
                }
                FormattedRow formattedRow = rt.getFormattedRow(this.row, this.treeStructure);
                if (formattedRow != null && (rowElements = formattedRow.getRowElements()) != null) {
                    for (int i = 0; i < rowElements.size(); ++i) {
                        relt.addElement(rowElements.elementAt(i));
                    }
                }
                ReportElement[] rc = new ReportElement[relt.size()];
                for (int i = 0; i < relt.size(); ++i) {
                    rc[i] = (ReportElement)relt.elementAt(i);
                }
                for (int j = 0; j < Array.getLength(rc); ++j) {
                    ReportElement t = rc[j];
                    if (t == null || t instanceof GuideLine || selectedElt != t && !this.isOverLapping_in_Y(selectedElt, t)) continue;
                    this.groupFormat.addElement(t);
                }
            }
        }
        this.reportMain.selectedObject = null;
        this.selectedObject = null;
        this.reportMain.setModified();
        if (this.reportMain.isDesignMode) {
            this.reportMain.groupSetWidth();
            panel1 = this.reportMain.designPanel.rulerPanel.getSinglePanel();
        } else {
            panel1 = this;
        }
        this.reportMain.setSelectedPanel(panel1);
        if (panel1.getElement() instanceof ReportSection) {
            this.reportMain.setCopyCutEnabled();
        }
        ReportElement[] rt = new ReportElement[panel1.groupFormat.size()];
        for (int j = 0; j < panel1.groupFormat.size(); ++j) {
            rt[j] = panel1.groupFormat.elementAt(j);
        }
    }

    private boolean isOverLapping_in_Y(ReportElement elt1, ReportElement elt2) {
        double y11 = elt1.getY();
        double y12 = elt1.getY() + elt1.getHeight();
        double y21 = elt2.getY();
        double y22 = elt2.getY() + elt2.getHeight();
        return y11 >= y21 && y11 < y22 || y21 >= y11 && y21 < y12;
    }

    private boolean isTablePanel(ReportElementPanel panel) {
        if (panel.getElement() instanceof ReportSection) {
            ReportSection rs = (ReportSection)panel.getElement();
            if (this.reportMain.report.getReportHeader().containsSection(rs)) {
                return false;
            }
            if (this.reportMain.report.getPageHeader().containsSection(rs)) {
                return false;
            }
            if (this.reportMain.report.getReportFooter().containsSection(rs)) {
                return false;
            }
            if (this.reportMain.report.getPageFooter().containsSection(rs)) {
                return false;
            }
        }
        return true;
    }

    private boolean isOverLapping_in_X(ReportElement elt1, ReportElement elt2) {
        double x11 = elt1.getX();
        double x12 = elt1.getX() + elt1.getWidth();
        double x21 = elt2.getX();
        double x22 = elt2.getX() + elt2.getWidth();
        return x11 >= x21 && x11 < x22 || x21 >= x11 && x21 < x12;
    }

    public void updateRulers() {
        if (this.reportMain.groupFormatFlag()) {
            this.reportMain.designPanel.rulerPanel.xRuler.repaintNull();
            this.reportMain.designPanel.rulerPanel.yRuler.repaintNull();
            this.reportMain.designPanel.rulerPanel.repaintButtons();
            return;
        }
        if (this.selectedObject != null) {
            this.reportMain.setSelectedObject(this.selectedObject, this);
            this.reportMain.designPanel.rulerPanel.repaintButtons();
            this.buttonPressed();
            ReportElement selObj = this.getHeadNode(this.selectedObject);
            int i = QbUtil.toPixel(selObj.getX());
            int j = QbUtil.toPixel(selObj.getY());
            int w = QbUtil.toPixel(selObj.getWidth());
            int h = QbUtil.toPixel(this.getTotalHeight(selObj) - selObj.getY());
            int index = this.getPanelIndex();
            if (this.isGridLine(selObj)) {
                index = this.getPanel((ReportImage)selObj);
            }
            int ht = this.getOffSet(index);
            if (selObj instanceof ReportLine) {
                if (!((ReportLine)selObj).isVertical()) {
                    this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(i, i + w + 2);
                    this.reportMain.designPanel.rulerPanel.yRuler.repaintNull();
                } else {
                    this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(j + ht, j + ht + h + 2 + new GridLine(this.getVisiblePanels()).getOffset(index, j + ht, j + ht + h + 2));
                    this.reportMain.designPanel.rulerPanel.xRuler.repaintNull();
                }
            } else if (selObj instanceof ReportGrid) {
                this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(i, i + w + 2);
                this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(j + ht, j + ht + h + 2 + new GridLine(this.getVisiblePanels()).getOffset(index, j + ht, j + ht + h + 2));
            } else {
                this.reportMain.designPanel.rulerPanel.xRuler.repaintXRuler(i, i + w + 2);
                this.reportMain.designPanel.rulerPanel.yRuler.repaintYRuler(j + ht, j + ht + h + 2);
            }
        } else {
            this.reportMain.designPanel.rulerPanel.repaintButtons();
            this.selectedPanel();
            this.reportMain.designPanel.rulerPanel.xRuler.repaintNull();
            this.reportMain.designPanel.rulerPanel.yRuler.repaintNull();
        }
    }

    public Vector<JPanel> getVisiblePanels() {
        return this.reportMain.designPanel.rulerPanel.getVisiblePanel();
    }

    public void groupFormatSetDataFormat(IFormat selectedFormat, IFormat initFormat) {
        ReportElement t;
        int i;
        if (this.groupFormat == null) {
            return;
        }
        if (this.elt instanceof ReportTable) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                t = this.groupFormat.elementAt(i);
                if (t instanceof ReportCell && FormatUtil.isFormatAppliabled(selectedFormat, ((ReportCell)t).getDataFormat())) {
                    ((ReportCell)t).setDataFormat(initFormat);
                    continue;
                }
                if (!(t instanceof ReportColumn) || !FormatUtil.isFormatAppliabled(selectedFormat, ((ReportColumn)t).getDataFormat())) continue;
                try {
                    int index;
                    ReportElement relt = ((ReportColumn)t).getFormatCell(this.row);
                    if (!(relt instanceof ReportCell)) continue;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                    cell.setDataFormat(initFormat);
                    ((ReportColumn)t).addFormattedCell(cell);
                    for (index = 0; index < this.reportTable.getColumnCount() && this.reportTable.getColumn(index) != t; ++index) {
                    }
                    ReportTable mainTable = this.reportMain.report.getReportTables().elementAt(0);
                    mainTable.getColumn(index).addFormattedCell(this.row, this.treeStructure, cell);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply format", ex);
                }
            }
        }
        if (this.elt instanceof ReportSection) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                ReportCell newCell;
                t = this.groupFormat.elementAt(i);
                if (!(t instanceof ReportCell) || !FormatUtil.isFormatAppliabled(selectedFormat, ((ReportCell)t).getDataFormat())) continue;
                if (((ReportSection)this.elt).hasThisFormattedCell((ReportCell)t, this.treeStructure) || ((ReportSection)this.elt).hasSectionCell((ReportCell)t, this.treeStructure)) {
                    ((ReportCell)t).setDataFormat(initFormat);
                    continue;
                }
                if (!((ReportSection)this.elt).hasCell((ReportCell)t)) continue;
                if (!(t instanceof ColumnHeader)) {
                    newCell = new ReportCell();
                    newCell.copy((ReportCell)t);
                } else {
                    newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)t);
                }
                newCell.setDataFormat(initFormat);
                ((ReportSection)this.elt).addFormattedCell(newCell, (ReportCell)t, this.treeStructure);
            }
        }
        this.deselectFormatSection();
    }

    public void groupFormatSetFont(Font font) {
        ReportElement t;
        int i;
        if (this.groupFormat == null) {
            return;
        }
        if (this.elt instanceof ReportTable) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                t = this.groupFormat.elementAt(i);
                if (t instanceof ReportCell) {
                    t.setFont(font);
                    continue;
                }
                if (!(t instanceof ReportColumn)) continue;
                try {
                    int index;
                    ReportElement relt = ((ReportColumn)t).getFormatCell(this.row);
                    if (!(relt instanceof ReportCell)) continue;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                    cell.setFont(font);
                    ((ReportColumn)t).addFormattedCell(cell);
                    for (index = 0; index < this.reportTable.getColumnCount() && this.reportTable.getColumn(index) != t; ++index) {
                    }
                    ReportTable mainTable = this.reportMain.report.getReportTables().elementAt(0);
                    mainTable.getColumn(index).addFormattedCell(this.row, this.treeStructure, cell);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply format", ex);
                }
            }
        }
        if (this.elt instanceof ReportSection) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                ReportCell newCell;
                t = this.groupFormat.elementAt(i);
                if (!(t instanceof ReportCell)) continue;
                if (((ReportSection)this.elt).hasThisFormattedCell((ReportCell)t, this.treeStructure) || ((ReportSection)this.elt).hasSectionCell((ReportCell)t, this.treeStructure)) {
                    t.setFont(font);
                    continue;
                }
                if (!((ReportSection)this.elt).hasCell((ReportCell)t)) continue;
                if (!(t instanceof ColumnHeader)) {
                    newCell = new ReportCell();
                    newCell.copy((ReportCell)t);
                } else {
                    newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)t);
                }
                newCell.setFont(font);
                ((ReportSection)this.elt).addFormattedCell(newCell, (ReportCell)t, this.treeStructure);
            }
        }
        this.deselectFormatSection();
    }

    public void groupFormatSetFontUnderline(boolean underline) {
        ReportElement t;
        int i;
        if (this.groupFormat == null) {
            return;
        }
        if (this.elt instanceof ReportTable) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                t = this.groupFormat.elementAt(i);
                if (t instanceof ReportCell) {
                    t.setUnderline(underline);
                    continue;
                }
                if (!(t instanceof ReportColumn)) continue;
                try {
                    int index;
                    ReportElement relt = ((ReportColumn)t).getFormatCell(this.row);
                    if (!(relt instanceof ReportCell)) continue;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                    cell.setUnderline(underline);
                    ((ReportColumn)t).addFormattedCell(cell);
                    for (index = 0; index < this.reportTable.getColumnCount() && this.reportTable.getColumn(index) != t; ++index) {
                    }
                    ReportTable mainTable = this.reportMain.report.getReportTables().elementAt(0);
                    mainTable.getColumn(index).addFormattedCell(this.row, this.treeStructure, cell);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply format", ex);
                }
            }
        }
        if (this.elt instanceof ReportSection) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                ReportCell newCell;
                t = this.groupFormat.elementAt(i);
                if (!(t instanceof ReportCell)) continue;
                if (((ReportSection)this.elt).hasThisFormattedCell((ReportCell)t, this.treeStructure) || ((ReportSection)this.elt).hasSectionCell((ReportCell)t, this.treeStructure)) {
                    t.setUnderline(underline);
                    continue;
                }
                if (!((ReportSection)this.elt).hasCell((ReportCell)t)) continue;
                if (!(t instanceof ColumnHeader)) {
                    newCell = new ReportCell();
                    newCell.copy((ReportCell)t);
                } else {
                    newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)t);
                }
                newCell.setUnderline(underline);
                ((ReportSection)this.elt).addFormattedCell(newCell, (ReportCell)t, this.treeStructure);
            }
        }
        this.deselectFormatSection();
    }

    public void groupFormatSetFontColor(Color color) {
        ReportElement t;
        int i;
        if (this.groupFormat == null) {
            return;
        }
        if (this.elt instanceof ReportTable) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                t = this.groupFormat.elementAt(i);
                if (t instanceof ReportCell) {
                    t.setFontColor(color);
                    continue;
                }
                if (!(t instanceof ReportColumn)) continue;
                try {
                    int index;
                    ReportElement relt = ((ReportColumn)t).getFormatCell(this.row);
                    if (!(relt instanceof ReportCell)) continue;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                    cell.setFontColor(color);
                    ((ReportColumn)t).addFormattedCell(cell);
                    for (index = 0; index < this.reportTable.getColumnCount() && this.reportTable.getColumn(index) != t; ++index) {
                    }
                    ReportTable mainTable = this.reportMain.report.getReportTables().elementAt(0);
                    mainTable.getColumn(index).addFormattedCell(this.row, this.treeStructure, cell);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply format", ex);
                }
            }
        }
        if (this.elt instanceof ReportSection) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                ReportCell newCell;
                t = this.groupFormat.elementAt(i);
                if (!(t instanceof ReportCell)) continue;
                if (((ReportSection)this.elt).hasThisFormattedCell((ReportCell)t, this.treeStructure) || ((ReportSection)this.elt).hasSectionCell((ReportCell)t, this.treeStructure)) {
                    t.setFontColor(color);
                    continue;
                }
                if (!((ReportSection)this.elt).hasCell((ReportCell)t)) continue;
                if (!(t instanceof ColumnHeader)) {
                    newCell = new ReportCell();
                    newCell.copy((ReportCell)t);
                } else {
                    newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)t);
                }
                newCell.setFontColor(color);
                ((ReportSection)this.elt).addFormattedCell(newCell, (ReportCell)t, this.treeStructure);
            }
        }
        this.deselectFormatSection();
    }

    public void groupFormatSetBackgroundColor(Color color, boolean forLine) {
        ReportElement t;
        int i;
        if (this.groupFormat == null) {
            return;
        }
        if (this.elt instanceof ReportTable) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                t = this.groupFormat.elementAt(i);
                if (t instanceof ReportCell) {
                    ReportUtil.setBgColor(t, color, forLine);
                    continue;
                }
                if (!(t instanceof ReportColumn)) continue;
                try {
                    int index;
                    ReportElement relt = ((ReportColumn)t).getFormatCell(this.row);
                    if (!(relt instanceof ReportCell)) continue;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                    ReportUtil.setBgColor(cell, color, forLine);
                    ((ReportColumn)t).addFormattedCell(cell);
                    for (index = 0; index < this.reportTable.getColumnCount() && this.reportTable.getColumn(index) != t; ++index) {
                    }
                    ReportTable mainTable = this.reportMain.report.getReportTables().elementAt(0);
                    mainTable.getColumn(index).addFormattedCell(this.row, this.treeStructure, cell);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply format", ex);
                }
            }
        }
        if (this.elt instanceof ReportSection) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                ReportCell newCell;
                t = this.groupFormat.elementAt(i);
                if (!(t instanceof ReportCell)) continue;
                if (((ReportSection)this.elt).hasThisFormattedCell((ReportCell)t, this.treeStructure) || ((ReportSection)this.elt).hasSectionCell((ReportCell)t, this.treeStructure)) {
                    ReportUtil.setBgColor(t, color, forLine);
                    continue;
                }
                if (!((ReportSection)this.elt).hasCell((ReportCell)t)) continue;
                if (!(t instanceof ColumnHeader)) {
                    newCell = new ReportCell();
                    newCell.copy((ReportCell)t);
                } else {
                    newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)t);
                }
                ReportUtil.setBgColor(newCell, color, forLine);
                ((ReportSection)this.elt).addFormattedCell(newCell, (ReportCell)t, this.treeStructure);
            }
        }
        this.deselectFormatSection();
    }

    public void groupFormatSetBorderColor(Color color) {
        ReportElement t;
        int i;
        if (this.groupFormat == null) {
            return;
        }
        if (this.elt instanceof ReportTable) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                t = this.groupFormat.elementAt(i);
                if (t instanceof ReportCell) {
                    t.setBorderColor(color);
                    continue;
                }
                if (!(t instanceof ReportColumn)) continue;
                try {
                    int index;
                    ReportElement relt = ((ReportColumn)t).getFormatCell(this.row);
                    if (!(relt instanceof ReportCell)) continue;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                    cell.setBorderColor(color);
                    ((ReportColumn)t).addFormattedCell(cell);
                    for (index = 0; index < this.reportTable.getColumnCount() && this.reportTable.getColumn(index) != t; ++index) {
                    }
                    ReportTable mainTable = this.reportMain.report.getReportTables().elementAt(0);
                    mainTable.getColumn(index).addFormattedCell(this.row, this.treeStructure, cell);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply format", ex);
                }
            }
        }
        if (this.elt instanceof ReportSection) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                ReportCell newCell;
                t = this.groupFormat.elementAt(i);
                if (!(t instanceof ReportCell)) continue;
                if (((ReportSection)this.elt).hasThisFormattedCell((ReportCell)t, this.treeStructure) || ((ReportSection)this.elt).hasSectionCell((ReportCell)t, this.treeStructure)) {
                    t.setBorderColor(color);
                    continue;
                }
                if (!((ReportSection)this.elt).hasCell((ReportCell)t)) continue;
                if (!(t instanceof ColumnHeader)) {
                    newCell = new ReportCell();
                    newCell.copy((ReportCell)t);
                } else {
                    newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)t);
                }
                newCell.setBorderColor(color);
                ((ReportSection)this.elt).addFormattedCell(newCell, (ReportCell)t, this.treeStructure);
            }
        }
        this.deselectFormatSection();
    }

    public void groupFormatSetThickness(int thickness, boolean forLine, BorderSide borderSide) {
        ReportElement t;
        int i;
        if (this.groupFormat == null) {
            return;
        }
        if (this.elt instanceof ReportTable) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                t = this.groupFormat.elementAt(i);
                if (t instanceof ReportCell) {
                    ReportUtil.setBorderThickness(t, thickness, forLine, borderSide);
                    continue;
                }
                if (!(t instanceof ReportColumn)) continue;
                try {
                    int index;
                    ReportElement relt = ((ReportColumn)t).getFormatCell(this.row);
                    if (!(relt instanceof ReportCell)) continue;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, this.row);
                    ReportUtil.setBorderThickness(cell, thickness, forLine, borderSide);
                    ((ReportColumn)t).addFormattedCell(cell);
                    for (index = 0; index < this.reportTable.getColumnCount() && this.reportTable.getColumn(index) != t; ++index) {
                    }
                    ReportTable mainTable = this.reportMain.report.getReportTables().elementAt(0);
                    mainTable.getColumn(index).addFormattedCell(this.row, this.treeStructure, cell);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to apply format", ex);
                }
            }
        }
        if (this.elt instanceof ReportSection) {
            for (i = 0; i < this.groupFormat.size(); ++i) {
                ReportCell newCell;
                t = this.groupFormat.elementAt(i);
                if (!(t instanceof ReportCell)) continue;
                if (((ReportSection)this.elt).hasThisFormattedCell((ReportCell)t, this.treeStructure) || ((ReportSection)this.elt).hasSectionCell((ReportCell)t, this.treeStructure)) {
                    ReportUtil.setBorderThickness(t, thickness, forLine, borderSide);
                    continue;
                }
                if (!((ReportSection)this.elt).hasCell((ReportCell)t)) continue;
                if (!(t instanceof ColumnHeader)) {
                    newCell = new ReportCell();
                    newCell.copy((ReportCell)t);
                } else {
                    newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)t);
                }
                ReportUtil.setBorderThickness(newCell, thickness, forLine, borderSide);
                ((ReportSection)this.elt).addFormattedCell(newCell, (ReportCell)t, this.treeStructure);
            }
        }
        this.deselectFormatSection();
    }

    protected void groupSetWidth() {
        this.reportMain.groupSetWidth();
    }

    void snapLeft(ReportElement relt) {
        GuideLine gl = (GuideLine)this.getHeadNode(relt);
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement elt = this.groupFormat.elementAt(i);
            if ((elt = this.filterElementForSecurity(elt)) == null) continue;
            if (!(elt.getVSnap() != 3 || gl.getRightBottomElts() != null && gl.getRightBottomElts().contains(elt))) {
                double x2 = elt.getX() + elt.getWidth();
                elt.setXX(gl.getX());
                elt.setWidth(x2 - gl.getX());
                elt.setVSnap((short)4);
                gl.addLeftTopElt(elt);
                continue;
            }
            elt.setXX(gl.getX());
            elt.setVSnap((short)1);
            gl.addLeftTopElt(elt);
        }
        this.deselectFormatSection();
        this.drawBoundingBox = false;
    }

    void snapMidlineV(ReportElement relt) {
        GuideLine gl = (GuideLine)this.getHeadNode(relt);
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement elt = this.groupFormat.elementAt(i);
            if ((elt = this.filterElementForSecurity(elt)) == null) continue;
            elt.setXX(gl.getX() - elt.getWidth() / 2.0);
            elt.setVSnap((short)2);
            gl.addMidlineElt(elt);
        }
        this.deselectFormatSection();
        this.drawBoundingBox = false;
    }

    void snapRight(ReportElement relt) {
        GuideLine gl = (GuideLine)this.getHeadNode(relt);
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement elt = this.groupFormat.elementAt(i);
            if ((elt = this.filterElementForSecurity(elt)) == null) continue;
            if (!(elt.getVSnap() != 1 || gl.getLeftTopElts() != null && gl.getLeftTopElts().contains(elt))) {
                elt.setWidth(gl.getX() - elt.getX());
                elt.setVSnap((short)4);
                gl.addRightBottomElt(elt);
                continue;
            }
            elt.setXX(gl.getX() - elt.getWidth());
            elt.setVSnap((short)3);
            gl.addRightBottomElt(elt);
        }
        this.deselectFormatSection();
        this.drawBoundingBox = false;
    }

    void snapTop(ReportElement relt) {
        GuideLine gl = (GuideLine)relt;
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement elt = this.groupFormat.elementAt(i);
            if ((elt = this.filterElementForSecurity(elt)) == null) continue;
            if (!(elt.getSnap() != 3 || gl.getRightBottomElts() != null && gl.getRightBottomElts().contains(elt))) {
                double y2 = elt.getY() + elt.getHeight();
                elt.setYY(gl.getY());
                elt.setHeight(y2 - gl.getY());
                elt.setSnap((short)4);
                gl.addLeftTopElt(elt);
                continue;
            }
            elt.setYY(gl.getY());
            elt.setSnap((short)1);
            gl.addLeftTopElt(elt);
        }
        this.deselectFormatSection();
        this.drawBoundingBox = false;
        this.repaintPanel();
    }

    void snapMidlineH(ReportElement relt) {
        GuideLine gl = (GuideLine)relt;
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement elt = this.groupFormat.elementAt(i);
            if ((elt = this.filterElementForSecurity(elt)) == null) continue;
            elt.setYY(gl.getY() - elt.getHeight() / 2.0);
            elt.setSnap((short)2);
            gl.addMidlineElt(elt);
        }
        this.deselectFormatSection();
        this.drawBoundingBox = false;
        this.repaintPanel();
    }

    void snapBottom(ReportElement relt) {
        GuideLine gl = (GuideLine)relt;
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement elt = this.groupFormat.elementAt(i);
            if ((elt = this.filterElementForSecurity(elt)) == null) continue;
            if (!(elt.getSnap() != 1 || gl.getLeftTopElts() != null && gl.getLeftTopElts().contains(elt))) {
                elt.setHeight(gl.getY() - elt.getY());
                elt.setSnap((short)4);
                gl.addRightBottomElt(elt);
                continue;
            }
            elt.setYY(gl.getY() - elt.getHeight());
            elt.setSnap((short)3);
            gl.addRightBottomElt(elt);
        }
        this.deselectFormatSection();
        this.drawBoundingBox = false;
        this.repaintPanel();
    }

    void snapAllLeft(ReportElement relt) {
        GuideLine gl = (GuideLine)this.getHeadNode(relt);
        ReportElement[] elts = this.getPanelElements();
        if (elts == null) {
            return;
        }
        ReportElement[] reportElementArray = elts;
        int n = reportElementArray.length;
        for (int i = 0; i < n; ++i) {
            ReportElement elt2;
            ReportElement elt = elt2 = reportElementArray[i];
            if ((elt = this.filterElementForSecurity(elt)) == null || elt instanceof GuideLine || elt.getX() < gl.getX() - 0.1 || elt.getX() > gl.getX() + 0.1) continue;
            if (!(elt.getVSnap() != 3 || gl.getRightBottomElts() != null && gl.getRightBottomElts().contains(elt))) {
                double x2 = elt.getX() + elt.getWidth();
                elt.setXX(gl.getX());
                elt.setWidth(x2 - gl.getX());
                elt.setVSnap((short)4);
                gl.addLeftTopElt(elt);
                continue;
            }
            elt.setXX(gl.getX());
            elt.setVSnap((short)1);
            gl.addLeftTopElt(elt);
        }
        this.repaintPanel();
    }

    void snapAllMidlineV(ReportElement relt) {
        GuideLine gl = (GuideLine)this.getHeadNode(relt);
        ReportElement[] elts = this.getPanelElements();
        if (elts == null) {
            return;
        }
        ReportElement[] reportElementArray = elts;
        int n = reportElementArray.length;
        for (int i = 0; i < n; ++i) {
            ReportElement elt2;
            ReportElement elt = elt2 = reportElementArray[i];
            if ((elt = this.filterElementForSecurity(elt)) == null || elt instanceof GuideLine || elt.getX() + elt.getWidth() / 2.0 < gl.getX() - 0.1 || elt.getX() + elt.getWidth() / 2.0 > gl.getX() + 0.1) continue;
            elt.setXX(gl.getX() - elt.getWidth() / 2.0);
            elt.setVSnap((short)2);
            gl.addMidlineElt(elt);
        }
        this.repaintPanel();
    }

    void snapAllRight(ReportElement relt) {
        GuideLine gl = (GuideLine)this.getHeadNode(relt);
        ReportElement[] elts = this.getPanelElements();
        if (elts == null) {
            return;
        }
        ReportElement[] reportElementArray = elts;
        int n = reportElementArray.length;
        for (int i = 0; i < n; ++i) {
            ReportElement elt2;
            ReportElement elt = elt2 = reportElementArray[i];
            if ((elt = this.filterElementForSecurity(elt)) == null || elt instanceof GuideLine || elt.getX() + elt.getWidth() < gl.getX() - 0.1 || elt.getX() + elt.getWidth() > gl.getX() + 0.1) continue;
            if (!(elt.getVSnap() != 1 || gl.getLeftTopElts() != null && gl.getLeftTopElts().contains(elt))) {
                elt.setWidth(gl.getX() - elt.getX());
                elt.setVSnap((short)4);
                gl.addRightBottomElt(elt);
                continue;
            }
            elt.setXX(gl.getX() - elt.getWidth());
            elt.setVSnap((short)3);
            gl.addRightBottomElt(elt);
        }
        this.repaintPanel();
    }

    void snapAllTop(ReportElement relt) {
        GuideLine gl = (GuideLine)relt;
        ReportElement[] elts = this.getPanelElements();
        if (elts == null) {
            return;
        }
        ReportElement[] reportElementArray = elts;
        int n = reportElementArray.length;
        for (int i = 0; i < n; ++i) {
            ReportElement elt2;
            ReportElement elt = elt2 = reportElementArray[i];
            if ((elt = this.filterElementForSecurity(elt)) == null || elt instanceof GuideLine || elt.getY() < gl.getY() - 0.1 || elt.getY() > gl.getY() + 0.1) continue;
            if (!(elt.getSnap() != 3 || gl.getRightBottomElts() != null && gl.getRightBottomElts().contains(elt))) {
                double y2 = elt.getY() + elt.getHeight();
                elt.setYY(gl.getY());
                elt.setHeight(y2 - gl.getY());
                elt.setSnap((short)4);
                gl.addLeftTopElt(elt);
                continue;
            }
            elt.setYY(gl.getY());
            elt.setSnap((short)1);
            gl.addLeftTopElt(elt);
        }
        this.repaintPanel();
    }

    void snapAllMidlineH(ReportElement relt) {
        GuideLine gl = (GuideLine)relt;
        ReportElement[] elts = this.getPanelElements();
        if (elts == null) {
            return;
        }
        ReportElement[] reportElementArray = elts;
        int n = reportElementArray.length;
        for (int i = 0; i < n; ++i) {
            ReportElement elt2;
            ReportElement elt = elt2 = reportElementArray[i];
            if ((elt = this.filterElementForSecurity(elt)) == null || elt instanceof GuideLine || elt.getY() + elt.getHeight() / 2.0 < gl.getY() - 0.1 || elt.getY() + elt.getHeight() / 2.0 > gl.getY() + 0.1) continue;
            elt.setYY(gl.getY() - elt.getHeight() / 2.0);
            elt.setSnap((short)2);
            gl.addMidlineElt(elt);
        }
        this.repaintPanel();
    }

    void snapAllBottom(ReportElement relt) {
        GuideLine gl = (GuideLine)relt;
        ReportElement[] elts = this.getPanelElements();
        if (elts == null) {
            return;
        }
        ReportElement[] reportElementArray = elts;
        int n = reportElementArray.length;
        for (int i = 0; i < n; ++i) {
            ReportElement elt2;
            ReportElement elt = elt2 = reportElementArray[i];
            if ((elt = this.filterElementForSecurity(elt)) == null || elt instanceof GuideLine || elt.getY() + elt.getHeight() < gl.getY() - 0.1 || elt.getY() + elt.getHeight() > gl.getY() + 0.1) continue;
            if (!(elt.getSnap() != 1 || gl.getLeftTopElts() != null && gl.getLeftTopElts().contains(elt))) {
                elt.setHeight(gl.getY() - elt.getY());
                elt.setSnap((short)4);
                gl.addRightBottomElt(elt);
                continue;
            }
            elt.setYY(gl.getY() - elt.getHeight());
            elt.setSnap((short)3);
            gl.addRightBottomElt(elt);
        }
        this.repaintPanel();
    }

    public void setApplyScript(boolean apply) {
        this.applyScript = apply;
    }

    public boolean getApplyScript() {
        return this.applyScript;
    }

    private Vector<GuideLine> findGuideLines(ReportElement elt) {
        GuideLine gl;
        int i;
        Vector<GuideLine> guidelines = new Vector<GuideLine>();
        if (this.reportMain.report.vGuideLines != null) {
            for (i = 0; i < this.reportMain.report.vGuideLines.size(); ++i) {
                gl = this.reportMain.report.vGuideLines.elementAt(i);
                if (!gl.containsElement(elt)) continue;
                guidelines.addElement(gl);
            }
        }
        if (this.reportMain.report.hGuideLines != null) {
            for (i = 0; i < this.reportMain.report.hGuideLines.size(); ++i) {
                gl = this.reportMain.report.hGuideLines.elementAt(i);
                if (!gl.containsElement(elt)) continue;
                guidelines.addElement(gl);
            }
        }
        return guidelines;
    }

    public void setSelectedObject(ReportElement selectedObject) {
        this.isSelectOp = selectedObject != null;
        this.selectedObject = selectedObject;
        try {
            this.reportMain.setSelectedObject(selectedObject, this);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to set selected object", e);
        }
        try {
            if (this.isSelectOp && !this.reportMain.groupFormatFlag()) {
                this.reportMain.designPanel.designToolBar2.setObject(selectedObject);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to set selected object", e);
        }
    }

    public void setDrawDragDashBox(boolean state, int dx, int dy) {
        this.setDrawDragDashBox(state, dx, dy, this, 0, 0);
    }

    public void setDrawDragDashBox(boolean state, int dx, int dy, ReportElementPanel destPanel, int destDy, int yOffset) {
        this.isDragOp = state;
        this.dragDashYOffset = yOffset;
        if (this.isDragOp) {
            this.setCursor(Cursor.getPredefinedCursor(13));
            this.setupDraggedVertGridLine(dx, dy);
            if (destPanel != null && destPanel != this) {
                this.setupDraggedDestPanel(destPanel, destDy, yOffset);
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.diffX = dx;
        this.diffY = dy;
        this.paintComponent(this.getGraphics());
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (obj == this || !(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            p.isDragOp = state;
            p.diffX = this.diffX;
            p.diffY = this.diffY;
            p.paintComponent(p.getGraphics());
        }
    }

    public boolean isDrawDragDashBox() {
        return this.isDragOp;
    }

    private void drawDraggedObjectsBorder(Graphics g) {
        if (this.draggedObjects.size() == 0) {
            return;
        }
        for (Object element : this.draggedObjects) {
            ReportElement e = (ReportElement)element;
            if (ReportElementPanel.isGridOrVertLine(e)) {
                this.drawBorder(g, 0, 0, this.deltaX, this.deltaY, e, false);
                continue;
            }
            this.drawBorder(g, this.diffX, this.diffY, this.deltaX, this.deltaY, e, false);
        }
    }

    private void drawSelectedObjectsBorder(Graphics g) {
        for (ReportElement element : this.groupFormat) {
            ReportElement e = element;
            if (ReportElementPanel.isGridOrVertLine(e)) continue;
            this.drawBorder(g, this.diffX, this.diffY, this.deltaX, this.deltaY, e, false);
        }
    }

    public void setDrawBoundingBox(boolean state) {
        this.drawBoundingBox = state;
    }

    public void setDrawBoundingBox(boolean state, int x, int y, int w, int h) {
        this.drawBoundingBox = state;
        if (w < 0) {
            this.boundingX = x + w;
            this.boundingWidth = -w;
        } else {
            this.boundingX = x;
            this.boundingWidth = w;
        }
        if (h < 0) {
            this.boundingY = y + h;
            this.boundingHeight = -h;
        } else {
            this.boundingY = y;
            this.boundingHeight = h;
        }
        this.paintComponent(this.getGraphics());
        this.drawCrossPanelBB();
    }

    private void drawCrossPanelBB() {
        if (!this.drawBoundingBox) {
            Vector<JPanel> visiblePanels = this.getVisiblePanels();
            for (JPanel jPanel : visiblePanels) {
                JPanel obj = jPanel;
                if (obj == this || !(obj instanceof ReportElementPanel)) continue;
                ReportElementPanel p = (ReportElementPanel)obj;
                p.drawBoundingBox = false;
                p.paintComponent(p.getGraphics());
            }
        }
        this.drawSpanningBox(this.boundingX, this.boundingY, this.boundingWidth, this.boundingHeight);
    }

    private boolean spanBottomPanel(int y, int h) {
        return y + h > this.getHeight();
    }

    private void drawSpanningBox(int x, int y, int w, int h) {
        boolean spanTop = y < 0;
        boolean spanBottom = this.spanBottomPanel(y, h);
        if (!spanTop && !spanBottom) {
            return;
        }
        Vector<JPanel> visiblePanels = this.getVisiblePanels();
        ReportElementPanel[] panels = new ReportElementPanel[visiblePanels.size()];
        int count = 0;
        if (spanTop) {
            int i = panels.length - 1;
            for (JPanel obj : visiblePanels) {
                if (obj == this) break;
                if (obj instanceof ReportElementPanel) {
                    panels[i] = (ReportElementPanel)obj;
                    ++count;
                }
                --i;
            }
        } else {
            boolean start = false;
            int i = 0;
            for (JPanel obj : visiblePanels) {
                if (start && obj instanceof ReportElementPanel) {
                    panels[i] = (ReportElementPanel)obj;
                    ++count;
                }
                if (obj == this) {
                    start = true;
                }
                ++i;
            }
        }
        ReportElementPanel[] result = new ReportElementPanel[count];
        int j = 0;
        for (ReportElementPanel panel : panels) {
            if (panel == null) continue;
            result[j] = panel;
            ++j;
        }
        this.undrawSpanningBox(result);
        this.lastSpanPanels = result;
        this.drawSpanningBox(result, spanTop, x, w, spanTop ? -y : h - (this.getHeight() - y));
    }

    private void undrawSpanningBox(ReportElementPanel[] newSpanningPanels) {
        Vector<ReportElementPanel> newSpanPanels = new Vector<ReportElementPanel>();
        for (ReportElementPanel newSpanningPanel : newSpanningPanels) {
            newSpanPanels.add(newSpanningPanel);
        }
        Vector<JPanel> visiblePanels = this.getVisiblePanels();
        for (JPanel jPanel : visiblePanels) {
            ReportElementPanel p;
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel) || (p = (ReportElementPanel)obj) == this || newSpanPanels.contains(p) || !p.drawBoundingBox) continue;
            p.drawBoundingBox = false;
            p.paintComponent(p.getGraphics());
        }
    }

    private void drawSpanningBox(ReportElementPanel[] panels, boolean spanTop, int x, int w, int h) {
        int i;
        h -= this.reportMain.designPanel.rulerPanel.getDividerSize();
        for (i = 0; i < panels.length && h > 0; h -= panels[i].getHeight() + this.reportMain.designPanel.rulerPanel.getDividerSize(), ++i) {
            panels[i].boundingX = x;
            panels[i].boundingWidth = w;
            if (h >= panels[i].getHeight()) {
                panels[i].boundingY = -1;
                panels[i].boundingHeight = panels[i].getHeight() + 1;
            } else if (!spanTop) {
                panels[i].boundingY = -1;
                panels[i].boundingHeight = h;
            } else {
                panels[i].boundingY = panels[i].getHeight() - h;
                panels[i].boundingHeight = h;
            }
            panels[i].drawBoundingBox = true;
            panels[i].paintComponent(panels[i].getGraphics());
        }
        while (i < panels.length) {
            if (panels[i].drawBoundingBox) {
                panels[i].drawBoundingBox = false;
                panels[i].paintComponent(panels[i].getGraphics());
            }
            ++i;
        }
    }

    public void selectBoundedObjects() {
        ReportElement[] rc;
        if (!this.drawBoundingBox) {
            return;
        }
        Rectangle bounded = new Rectangle(this.boundingX, this.boundingY, this.boundingWidth, this.boundingHeight);
        if (this.elt instanceof ReportTable) {
            ReportTable rt = this.getOriginalReportTable();
            rc = rt.getTableElements();
        } else {
            rc = ((ReportSection)this.elt).getData();
        }
        for (int j = 0; j < Array.getLength(rc); ++j) {
            Rectangle r;
            ReportElement t = this.filterElementForSecurity((ReportElement)Array.get(rc, j));
            if (t == null || t instanceof GuideLine) continue;
            int xi = QbUtil.toPixel(t.getX());
            int yi = QbUtil.toPixel(t.getY());
            int wi = QbUtil.toPixel(t.getWidth());
            int hi = QbUtil.toPixel(t.getHeight());
            if ((t instanceof ReportLine || t instanceof ReportGrid) && hi < 0) {
                hi = this.getHeight();
            }
            if (!bounded.intersects(r = new Rectangle(xi, yi, wi, hi))) continue;
            this.select(t, !(t instanceof ReportLine) && !(t instanceof ReportGrid));
        }
    }

    public void select(ReportElement e, boolean toggle) {
        this.buttonPressed();
        if (!ReportElementPanel.masterSection(e) && (e instanceof ReportSection || e instanceof ReportTable)) {
            this.reportMain.setSelectedObject(e instanceof ReportTable ? this.reportTable : this.elt, this);
            return;
        }
        if (this.isExclusiveSelectObject(e) ? !this.reportMain.hasNoSelectedObject() && !this.isSelected(e) : this.selectedExclusiveObject()) {
            return;
        }
        if (ReportElementPanel.isGridOrVertLine(e)) {
            int y2;
            int y1;
            int startPanel;
            boolean isLine = e instanceof ReportLine;
            ReportElement headNode = this.getHeadNode(e);
            Vector<JPanel> panels = this.getVisiblePanels();
            GridLine gl = new GridLine(panels);
            int[] res = gl.findStartEndPanel(startPanel = this.getPanel((ReportImage)headNode), y1 = QbUtil.toPixel(headNode.getY()), y2 = QbUtil.toPixel(this.getTotalHeight(headNode)), false);
            if (res != null) {
                for (int i = res[0]; i <= res[2]; ++i) {
                    JPanel obj;
                    if (headNode == null || !((obj = panels.get(i)) instanceof ReportElementPanel)) continue;
                    ReportElementPanel p = (ReportElementPanel)obj;
                    p.selectHelper(headNode, toggle);
                    if (i + 1 > res[2]) continue;
                    headNode = isLine ? ((ReportLine)headNode).next() : ((ReportGrid)headNode).next();
                }
            }
            for (JPanel obj : panels) {
                if (!(obj instanceof ReportElementPanel)) continue;
                ReportElementPanel panel = (ReportElementPanel)obj;
                panel.draggedObjects.clear();
            }
            this.setupAllDraggedVertGridLine(0, 0);
            return;
        }
        this.selectHelper(e, toggle);
    }

    private void selectHelper(ReportElement e, boolean toggle) {
        if (e == null) {
            ReportElement elt = this.getElement();
            elt = elt instanceof ReportTable ? this.reportTable : elt;
            this.setSelectedObject(elt);
            this.reportMain.updateYRuler = true;
            return;
        }
        if (toggle && this.groupFormat.contains(e)) {
            this.unselect(e);
            if (this.groupFormat.size() > 0) {
                this.setSelectedObject(this.groupFormat.get(this.groupFormat.size() - 1));
            }
        } else {
            if (!this.groupFormat.contains(e)) {
                this.groupFormat.addElement(e);
            }
            this.setSelectedObject(e);
            this.selectItemInExplorer(e, true);
        }
    }

    private boolean isExclusiveSelectObject(ReportElement e) {
        return e instanceof ColumnWrap;
    }

    private boolean isSelected(ReportElement e) {
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel o = jPanel;
            if (!(o instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)o;
            if (!panel.groupFormat.contains(e)) continue;
            return true;
        }
        return false;
    }

    private boolean selectedExclusiveObject() {
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel o = jPanel;
            if (!(o instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)o;
            for (ReportElement element : panel.groupFormat) {
                if (!this.isExclusiveSelectObject(element)) continue;
                return true;
            }
        }
        return false;
    }

    public void unselect(ReportElement e) {
        int i = 0;
        if (this.groupFormat != null) {
            Iterator<ReportElement> it = this.groupFormat.iterator();
            while (it.hasNext()) {
                if (it.next() == e && this.groupFormat.size() > i) {
                    this.groupFormat.remove(i);
                    break;
                }
                ++i;
            }
        }
        this.setSelectedObject(null);
        this.selectItemInExplorer(e, false);
    }

    public void setResizeElement(boolean state, int deltaX, int deltaY) {
        this.isResizeOp = state;
        if (this.selectedObject == null) {
            return;
        }
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        if (state) {
            this.paintComponent(this.getGraphics());
        } else {
            this.repaintPanel();
        }
    }

    public void setElementPosition(int x, int y) {
        if (this.selectedObject == null) {
            return;
        }
        if (ReportElementPanel.isGridOrVertLine(this.selectedObject)) {
            return;
        }
        this.selectedObject.setX((double)x / (double)QbUtil.getPixelPerInch());
        this.selectedObject.setY((double)y / (double)QbUtil.getPixelPerInch());
    }

    public void setElementSize(int w, int h) {
        if (ReportElementPanel.isGridOrVertLine(this.selectedObject)) {
            return;
        }
        this.setElementSize(this.selectedObject, w, h);
    }

    private void setElementSize(ReportElement re, int w, int h) {
        if (re == null) {
            return;
        }
        if (w != -1) {
            re.setWidth((double)w / (double)QbUtil.getPixelPerInch());
        }
        if (h != -1) {
            re.setHeight((double)h / (double)QbUtil.getPixelPerInch());
        }
    }

    public void setElementSize(double w, double h) {
        if (ReportElementPanel.isGridOrVertLine(this.selectedObject)) {
            return;
        }
        this.selectedObject.setWidth(w);
        this.selectedObject.setHeight(h);
    }

    private void clearExplorer() {
        if (this.reportMain.explorer != null) {
            this.reportMain.explorer.clearSelection();
        }
    }

    private void selectItemInExplorer(ReportElement elt, boolean selecting) {
        if (this.reportMain.explorer != null) {
            this.reportMain.explorer.setSelection(elt, selecting);
        }
    }

    public void popupMenu(int x, int y) {
        this.popupMenu(x, y, this.reportMain.getSelectedObject());
    }

    public void popupMenu(int x, int y, ReportElement re) {
        if (!(re instanceof GuideLine) && this.reportMain.groupFormatFlag() && (ReportElementPanel.isMasterSection(re) || !(re instanceof ReportSection))) {
            this.popupAlignmentDialog();
            return;
        }
        this.popupMenu.setClickLocation(x, y);
        this.popupMenu.addMenu(re);
        this.popupMenu.show(this, x, y);
    }

    private static boolean isMasterSection(ReportElement e) {
        if (e == null) {
            return false;
        }
        if (!(e instanceof ReportSection)) {
            return false;
        }
        ReportSection s = (ReportSection)e;
        return s.getID().startsWith("MTR");
    }

    public boolean isInsertObject() {
        return this.reportMain.isInsertObject();
    }

    public boolean isInsertLabel() {
        return this.reportMain.isInsertLabel();
    }

    public boolean isInsertFormula() {
        return this.reportMain.isInsertFormula();
    }

    public boolean isInsertDatabaseField() {
        return this.reportMain.isInsertDatabaseField();
    }

    public boolean isInsertChart() {
        return this.reportMain.isInsertChart();
    }

    public boolean isInsertImage() {
        return this.reportMain.isInsertImage();
    }

    public boolean isInsertLine() {
        return this.reportMain.isInsertLine();
    }

    public boolean isVerticalLine() {
        return this.reportMain.isVerticalLine();
    }

    public boolean isInsertGrid() {
        return this.reportMain.isInsertGrid();
    }

    public boolean isInsertBoundingBox() {
        return this.reportMain.isInsertBoundingBox();
    }

    public boolean isPasteOp() {
        return this.reportMain.isPasteOp();
    }

    public boolean isInsertSubReport() {
        return this.reportMain.isInsertSubReport();
    }

    public boolean isInsertRichTextField() {
        return this.reportMain.isInsertRichTextField();
    }

    public boolean isInsertColumnHeader() {
        return this.reportMain.isInsertColumnHeader();
    }

    public boolean isInsertTOC() {
        return this.reportMain.isInsertTOC();
    }

    public boolean isInsertGuideLine() {
        return this.reportMain.isInsertGuideLine();
    }

    private void insertToExplorer(ReportElement where, ReportElement what) {
        this.reportMain.explorer.insertIntoNode(where, what);
    }

    public void insertObject(int ulX, int ulY) {
        double w = this.getDefaultWidth();
        double h = this.getDefaultHeight();
        this.insertObject(ulX, ulY, QbUtil.toPixel(w), QbUtil.toPixel(h));
    }

    public void insertObject(int ulX, int ulY, int w, int h) {
        int eX = ulX;
        int eY = ulY;
        this.unselectAll();
        ReportCell newCell = null;
        ReportColumn col = null;
        if (!this.reportMain.isAllowCrosstabElementMove() && (this.elt instanceof CrossTabReportSection || this.elt instanceof ReportTable && this.reportMain.report.isCrossTab())) {
            new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You cannot insert element to CrossTab report section!"));
            return;
        }
        if (this.reportMain.isInsertGuideLine()) {
            int x = eX;
            int y = eY;
            GuideLine guideLine = this.reportMain.designPanel.rulerPanel.createGuideLine(QbUtil.toInch(x), QbUtil.toInch(y), this.reportMain.isVerticalGuideLine(), this.elt);
            this.reportMain.report.addGuideLine(guideLine);
            if (this.reportMain.isVerticalGuideLine()) {
                x = QbUtil.toPixel(guideLine.getX());
                this.reportMain.designPanel.rulerPanel.xRuler.addGuideLineToXRuler(x);
            } else {
                y = QbUtil.toPixel(guideLine.getY());
                this.reportMain.designPanel.rulerPanel.yRuler.addGuideLineToYRuler(y += this.getOffSet(this.getPanel(guideLine)));
            }
            this.reportMain.setSelectedPanel(this);
            this.reportMain.setInsertGuideLine(false);
            this.reportMain.setVerticalGuideLine(false);
            this.previousY = -1;
            this.previousX = -1;
            this.reportMain.repaintPanel();
        } else if (this.reportMain.isInsertLabel()) {
            if (this.elt instanceof ReportSection) {
                if (this.reportMain.isDesignMode) {
                    newCell = new ReportCell("NEW LABEL");
                    newCell.applyTemplate(this.reportMain.report.labelSetting);
                    newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                    newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
                    newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
                    ReportElementPanel.setWidthHeight(newCell, w, h);
                    ((ReportSection)this.elt).addData(newCell);
                    this.reportMain.setSelectedObject(newCell, this);
                    this.repaint();
                    if (!this.reportMain.setEltText(this)) {
                        ((ReportSection)this.elt).removeData(newCell);
                        newCell = null;
                        this.repaintPanel();
                    }
                } else {
                    newCell = new ReportCell("NEW LABEL");
                    newCell.applyTemplate(this.reportMain.report.labelSetting);
                    newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                    newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
                    newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
                    ReportElementPanel.setWidthHeight(newCell, w, h);
                    ((ReportSection)this.elt).addSectionCell(newCell, this.treeStructure);
                    this.reportMain.setSelectedObject(newCell, this);
                    this.repaint();
                    if (!this.reportMain.setEltText(this)) {
                        this.reportMain.deleteElt();
                        newCell = null;
                    }
                }
            } else if (this.reportMain.isDesignMode) {
                newCell = new ReportCell("NEW LABEL");
                this.reportMain.setSelectedObject(newCell, this);
                ReportElementPanel.setWidthHeight(newCell, w, h);
                this.repaint();
                if (this.reportMain.setEltText(this)) {
                    String text = this.reportMain.getSelectedObject().getText();
                    int j = 1;
                    String name = "formula" + j;
                    boolean ok = false;
                    while (!ok) {
                        ok = true;
                        for (int i = 0; i < this.reportMain.report.formulas.size(); ++i) {
                            if (!this.reportMain.report.formulas.elementAt(i).getName().equals(name)) continue;
                            name = "formula" + ++j;
                            ok = false;
                        }
                    }
                    Formula formula = new Formula(name, "\"" + QbUtil.escapeFormulaText(text) + "\"");
                    this.reportMain.addColInfo(new ColInfo(formula, name, 12));
                    this.reportMain.report.formulas.addElement(formula);
                    ReportTable tbl = this.reportMain.report.getReportTables().elementAt(0);
                    col = tbl.getColumn(tbl.getColumnCount() - 1);
                    ReportColumn[] column = this.reportMain.report.column;
                    for (int i = 0; i < Array.getLength(column); ++i) {
                        if (!FormatUtil.isFormatAppliabled(col.getDataFormat(), column[i].getDataFormat())) continue;
                        col.applyTemplate(column[i]);
                        break;
                    }
                    col.setBgColor2(tbl.getColumn(0).getBgColor2());
                    col.setAlternateRow(tbl.getColumn(0).getAlternateRow());
                    col.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                    col.setX((double)eX / (double)QbUtil.getPixelPerInch());
                    col.setY((double)eY / (double)QbUtil.getPixelPerInch());
                    ReportElementPanel.setWidthHeight(col, w, h);
                } else {
                    newCell = null;
                }
            } else {
                ReportTable mainTable;
                newCell = new ReportCell("NEW LABEL");
                newCell.applyTemplate(this.reportMain.report.labelSetting);
                newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
                newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
                ReportElementPanel.setWidthHeight(newCell, w, h);
                ReportTable tbl = mainTable = this.reportMain.report.getReportTables().elementAt(0);
                for (int i = 0; i < this.treeStructure.size(); ++i) {
                    if (!(tbl instanceof ReportTreeTable)) continue;
                    int ind = this.treeStructure.elementAt(i);
                    tbl = ((ReportTreeTable)tbl).getSubTable(ind);
                }
                FormattedRow formattedRow = tbl.getFormattedRow(this.row, this.treeStructure);
                if (formattedRow == null) {
                    formattedRow = new FormattedRow(tbl.getHeight(), null);
                }
                formattedRow.addElement(newCell);
                tbl.addFormattedRow(this.row, this.treeStructure, formattedRow);
                if (tbl != mainTable) {
                    formattedRow = mainTable.getFormattedRow(this.row, this.treeStructure);
                    if (formattedRow == null) {
                        formattedRow = new FormattedRow(tbl.getHeight(), null);
                    }
                    formattedRow.addElement(newCell);
                    mainTable.addFormattedRow(this.row, this.treeStructure, formattedRow);
                }
                this.reportMain.setSelectedObject(newCell, this);
                this.repaint();
                if (!this.reportMain.setEltText(this)) {
                    this.reportMain.deleteElt();
                    newCell = null;
                }
            }
            this.reportMain.setInsertLabel(false);
            this.previousY = -1;
            this.previousX = -1;
        } else if (this.reportMain.isInsertColumnHeader()) {
            if (this.elt instanceof ReportSection && this.reportMain.isDesignMode) {
                newCell = new ColumnHeader();
                newCell.applyTemplate(this.reportMain.report.columnHeaderSetting);
                newCell.setFormulaObj(this.reportMain.getSelectedFormula());
                newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
                newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
                ReportElementPanel.setWidthHeight(newCell, w, h);
                ((ReportSection)this.elt).addData(newCell);
                this.reportMain.setSelectedObject(newCell, this);
                this.reportMain.setModified();
                this.repaint();
            }
            this.reportMain.setInsertColumnHeader(false);
            this.reportMain.repaintPanel(this);
        } else if (this.reportMain.isInsertFormula()) {
            this.reportMain.designPanel.rulerPanel.resetDragAndResizeAndPopupOps();
            if (this.elt instanceof ReportSection) {
                newCell = new ReportCell();
                Formula form = this.reportMain.getSelectedFormula();
                form.getDatatype(this.reportMain.report);
                newCell.setFormulaObj(form);
                ReportCell[] formula = this.reportMain.report.formula;
                newCell.setDataFormat(FormatUtil.createFormat(DataType.mapType(newCell.getSQLType())));
                for (int i = 0; i < Array.getLength(formula); ++i) {
                    if (!FormatUtil.isFormatAppliabled(newCell.getDataFormat(), formula[i].getDataFormat())) continue;
                    newCell.applyTemplate(formula[i]);
                    break;
                }
                newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
                newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
                ReportElementPanel.setWidthHeight(newCell, w, h);
                ReportElementPanel.formatCellBaseOnFormula(newCell, form);
                if (this.reportMain.isDesignMode) {
                    ((ReportSection)this.elt).addData(newCell);
                } else {
                    ((ReportSection)this.elt).addSectionCell(newCell, this.treeStructure);
                }
                this.reportMain.setSelectedObject(newCell, this);
                this.reportMain.setModified();
            } else if (this.reportMain.isDesignMode) {
                newCell = new ReportCell();
                ReportElementPanel.setWidthHeight(newCell, w, h);
                newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                Formula formula = this.reportMain.getSelectedFormula();
                formula.getDatatype(this.reportMain.report);
                newCell.setFormulaObj(formula);
                this.reportMain.setSelectedObject(newCell, this);
                String str = newCell.getFormulaName();
                if (str.startsWith("{") && str.endsWith("}")) {
                    str = str.substring(1, str.length() - 1);
                }
                int insertColumnIndex = this.reportMain.addColInfo(new ColInfo(newCell.getFormulaObj(), str, newCell.getSQLType()));
                ReportTable tbl = this.reportMain.report.getReportTables().elementAt(0);
                col = tbl.getColumn(this.reportMain.report.getTableColumn(insertColumnIndex, tbl));
                ReportColumn[] column = this.reportMain.report.column;
                col.setDataFormat(FormatUtil.createFormat(DataType.mapType(newCell.getSQLType())));
                for (int i = 0; i < Array.getLength(column); ++i) {
                    if (!FormatUtil.isFormatAppliabled(col.getDataFormat(), column[i].getDataFormat())) continue;
                    col.applyTemplate(column[i]);
                    break;
                }
                col.setBgColor2(tbl.getColumn(0).getBgColor2());
                col.setAlternateRow(tbl.getColumn(0).getAlternateRow());
                col.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                col.setX((double)eX / (double)QbUtil.getPixelPerInch());
                col.setY((double)eY / (double)QbUtil.getPixelPerInch());
                ReportElementPanel.setWidthHeight(col, w, h);
                ReportElementPanel.formatCellBaseOnFormula(col, formula);
                this.reportMain.setModified();
            } else {
                ReportTable mainTable;
                newCell = new ReportCell();
                newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                Formula form = this.reportMain.getSelectedFormula();
                form.getDatatype(this.reportMain.report);
                newCell.setFormulaObj(form);
                ReportCell[] formula = this.reportMain.report.formula;
                newCell.setDataFormat(FormatUtil.createFormat(DataType.mapType(newCell.getSQLType())));
                for (int i = 0; i < Array.getLength(formula); ++i) {
                    if (!FormatUtil.isFormatAppliabled(newCell.getDataFormat(), formula[i].getDataFormat())) continue;
                    newCell.applyTemplate(formula[i]);
                    break;
                }
                newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
                newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
                ReportElementPanel.setWidthHeight(newCell, w, h);
                ReportTable tbl = mainTable = this.reportMain.report.getReportTables().elementAt(0);
                for (int i = 0; i < this.treeStructure.size(); ++i) {
                    if (!(tbl instanceof ReportTreeTable)) continue;
                    int ind = this.treeStructure.elementAt(i);
                    tbl = ((ReportTreeTable)tbl).getSubTable(ind);
                }
                FormattedRow formattedRow = tbl.getFormattedRow(this.row, this.treeStructure);
                if (formattedRow == null) {
                    formattedRow = new FormattedRow(tbl.getHeight(), null);
                }
                formattedRow.addElement(newCell);
                tbl.addFormattedRow(this.row, this.treeStructure, formattedRow);
                if (tbl != mainTable) {
                    formattedRow = mainTable.getFormattedRow(this.row, this.treeStructure);
                    if (formattedRow == null) {
                        formattedRow = new FormattedRow(tbl.getHeight(), null);
                    }
                    formattedRow.addElement(newCell);
                    mainTable.addFormattedRow(this.row, this.treeStructure, formattedRow);
                }
                this.reportMain.setSelectedObject(newCell, this);
                if (!this.reportMain.setEltText(this)) {
                    this.reportMain.deleteElt();
                    newCell = null;
                }
            }
            this.reportMain.insertFormula = false;
            this.previousY = -1;
            this.previousX = -1;
        } else if (this.reportMain.isInsertDatabaseField()) {
            this.reportMain.designPanel.rulerPanel.resetDragAndResizeAndPopupOps();
            try {
                if (this.elt instanceof ReportSection) {
                    this.insertDatabaseFieldToReportSection(ulX, ulY, w, h);
                } else {
                    this.insertDatabaseFieldToReportTable(ulX, ulY, w, h);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to insert database field into report", ex);
            }
            this.reportMain.insertDatabaseField = false;
            this.previousY = -1;
            this.previousX = -1;
            if (this.reportMain.dbFieldDialog != null) {
                this.reportMain.dbFieldDialog.setVisible(true);
                this.reportMain.dbFieldDialog.toFront();
            }
        } else if (this.reportMain.isInsertChart()) {
            newCell = new ReportChartObject();
            newCell.applyTemplate(this.reportMain.report.chartSetting);
            newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
            newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
            newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
            ReportElementPanel.setWidthHeight(newCell, w, h);
            if (this.elt instanceof ReportSection) {
                ((ReportSection)this.elt).addData(newCell);
            } else {
                this.reportTable.addImage((ReportChartObject)newCell);
            }
            this.select(newCell, false);
            this.repaint();
            if (!this.reportMain.setEltChart(this)) {
                newCell = null;
            }
            this.previousY = -1;
            this.previousX = -1;
        } else if (this.reportMain.isInsertImage()) {
            newCell = new ReportImage();
            if (this.elt instanceof ReportSection) {
                ((ReportSection)this.elt).addData(newCell);
            } else {
                this.reportTable.addImage((ReportImage)newCell);
            }
            this.select(newCell, false);
            this.repaint();
            if (this.reportMain.setEltImage(this)) {
                if (this.reportMain.report.isApplyBoundSelected()) {
                    newCell.applyImageTemplate(this.reportMain.report.imageSetting);
                } else {
                    newCell.applyImageTemplateExceptBound(this.reportMain.report.imageSetting);
                }
                newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
                newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
                this.previousY = -1;
                this.previousX = -1;
            } else {
                newCell = null;
            }
            this.reportMain.setInsertImage(false);
        } else if (this.reportMain.isPasteOp()) {
            this.reportMain.designPanel.rulerPanel.resetDragAndResizeAndPopupOps();
            this.reportMain.designPanel.rulerPanel.pasteX = eX;
            this.reportMain.designPanel.rulerPanel.pasteY = eY;
            this.reportMain.createBackupReport();
            this.reportMain.designPanel.rulerPanel.pasteFromClipBoard(this, QbUtil.toInch(w), QbUtil.toInch(h));
            this.reportMain.setIsPasteOp(false);
            this.previousY = -1;
            this.previousX = -1;
        } else if (this.reportMain.isInsertLine() || this.reportMain.isInsertGrid()) {
            if (this.reportMain.isDesignMode) {
                GridLine gl = new GridLine(this.getVisiblePanels());
                this.reportMain.designPanel.rulerPanel.selectionOriginX = ulX;
                this.reportMain.designPanel.rulerPanel.selectionOriginY = ulY;
                this.reportMain.designPanel.rulerPanel.setStartPanel(this);
                newCell = gl.set(this.reportMain.designPanel.rulerPanel.startPanel, ulX, ulY, ulX + w, ulY + h, this.reportMain.isInsertLine(), this.reportMain.isVerticalLine(), null, true, true);
                newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                this.reportMain.setModified();
            }
            if (newCell instanceof ReportLine) {
                newCell.setBgColor(this.reportMain.report.lineSetting.getBgColor());
                ((ReportLine)newCell).setLineStyle(this.reportMain.report.lineSetting.getLineStyle());
                if (((ReportLine)newCell).isVertical()) {
                    newCell.setWidth(this.reportMain.report.lineSetting.getHeight());
                } else {
                    newCell.setHeight(this.reportMain.report.lineSetting.getHeight());
                }
            } else if (newCell instanceof ReportGrid) {
                newCell.setBorderThickness(this.reportMain.report.gridSetting.getBorderThickness());
                newCell.setBorderColor(this.reportMain.report.gridSetting.getBorderColor());
                newCell.setBgColor(this.reportMain.report.gridSetting.getBgColor());
                ((ReportGrid)newCell).setGridStyle(this.reportMain.report.gridSetting.getGridStyle());
            }
            this.reportMain.setSelectedObject(newCell, this);
            if (!this.reportMain.isDesignMode) {
                this.resetOffScreenImage();
                this.repaint();
            }
            this.reportMain.setInsertGrid(false);
            this.reportMain.setInsertLine(false);
            this.reportMain.setVerticalLine(false);
            this.reportMain.setVerticalGuideLine(false);
        } else if (this.reportMain.isInsertTOC()) {
            ReportSection rs = (ReportSection)this.getElement();
            if (this.reportMain.report.getReportHeader().containsSection(rs) || this.reportMain.report.getReportTables().elementAt(0).getHeader().containsSection(rs)) {
                TableOfContents toc = new TableOfContents(this.reportMain.report);
                ((ReportSection)this.elt).addData(toc);
                this.select(toc, false);
                toc.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                toc.setX((double)eX / (double)QbUtil.getPixelPerInch());
                toc.setY((double)eY / (double)QbUtil.getPixelPerInch());
                ReportElementPanel.setWidthHeight(toc, w, h);
                this.reportMain.setEltTableOfContents(this, true);
                this.reportMain.setModified();
            } else {
                this.reportMain.errorMessage(LanguageEncoder.getText("Table of contents object can be inserted to Report Header/Table Header and sub-sections only"));
            }
            this.previousY = -1;
            this.previousX = -1;
            this.repaint();
        } else if (this.reportMain.isInsertSubReport()) {
            if (this.reportMain.report.currentNode.getFileName() == null || this.reportMain.report.currentNode.getFileName().equals("") || this.reportMain.report.currentNode.getFileName().equals(".rpt")) {
                this.reportMain.report.currentNode.setFileName(this.reportMain.getFileName());
            }
            SubReportObject newSubRepCell = new SubReportObject(this.reportMain.report.currentNode.getFileName(), null, this.reportMain.relativeDomainPath, this.reportMain.getSubFilesTable());
            newSubRepCell.setDomainPath(this.reportMain.relativeDomainPath);
            if (this.elt instanceof ReportSection) {
                ((ReportSection)this.elt).addData(newSubRepCell);
            } else {
                this.reportTable.addSubReport(newSubRepCell);
            }
            this.select(newSubRepCell, false);
            newSubRepCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
            newSubRepCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
            newSubRepCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
            ReportElementPanel.setWidthHeight(newSubRepCell, w, h);
            this.reportMain.setEltSubReport(this);
            this.previousY = -1;
            this.previousX = -1;
            this.repaint();
        } else if (this.reportMain.isInsertRichTextField()) {
            newCell = new ReportRTFObject(null);
            if (this.elt instanceof ReportSection) {
                ((ReportSection)this.elt).addData(newCell);
            } else {
                this.reportTable.addRTFObject((ReportRTFObject)newCell);
            }
            this.select(newCell, false);
            this.repaint();
            newCell.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
            newCell.setX((double)eX / (double)QbUtil.getPixelPerInch());
            newCell.setY((double)eY / (double)QbUtil.getPixelPerInch());
            ReportElementPanel.setWidthHeight(newCell, w, h);
            if (!this.reportMain.setEltRTF(this, true)) {
                newCell = null;
            }
            this.reportMain.setInsertRichTextField(false);
            this.previousY = -1;
            this.previousX = -1;
        }
        if (col != null) {
            this.insertToExplorer(this.elt, col);
        } else if (newCell != null) {
            this.insertToExplorer(this.elt, newCell);
        }
    }

    private void insertDatabaseFieldToReportSection(int ulX, int ulY, int w, int h) {
        String[] tmp = this.reportMain.getSelectedDatabaseField();
        String dbAggr = this.reportMain.getSelectedDatabaseFieldAggr();
        String tblName = tmp[0];
        String colName = tmp[1];
        short colAggr = this.reportMain.getSelectedColumnAggrIndex();
        ColInfo[] colInfo = this.reportMain.report.colInfo;
        ColData[] colData = this.reportMain.report.colData;
        DBInfoBasic dbInfo = this.reportMain.report.dbInfo;
        ReportTable tbl = this.reportMain.report.getReportTables().elementAt(0);
        boolean makeColInvisible = false;
        int colDataIdx = this.getColDataIndex(colName, tblName);
        try {
            if (!QueryParser.isColumnPresent(tblName, colName, dbInfo.getQuery()) || colDataIdx < 0) {
                String newSQL = this.insertFieldToSQL(tblName, colName, dbAggr);
                this.reportMain.report.dbInfo.setQuery(newSQL);
                colData = ReloadReport.getOriginalColData(this.reportMain.report, true, 0, 20);
                colDataIdx = colData.length - 2;
                ColInfo newColInfo = new ColInfo(colDataIdx);
                newColInfo.setVisible(false);
                if (this.reportMain.report.isAggregationOn()) {
                    if (colAggr <= 0) {
                        colAggr = 6;
                    }
                    newColInfo.setAggregation(this.isAggregatedColumn(colInfo), colAggr);
                }
                colDataIdx = colData.length - 2;
                colInfo = this.reportMain.report.getNewColInfoSet(newColInfo);
                Report newReport = this.reportMain.report.setNewData(colData, colInfo, false, this.reportMain.report.getReportType(), false);
                this.reportMain.setReport(newReport);
                makeColInvisible = true;
            } else if (!this.isColumnSelected(colDataIdx)) {
                ColInfo newColInfo = new ColInfo(colDataIdx);
                newColInfo.setVisible(false);
                if (this.reportMain.report.isAggregationOn()) {
                    if (colAggr <= 0) {
                        colAggr = 6;
                    }
                    newColInfo.setAggregation(this.isAggregatedColumn(colInfo), colAggr);
                }
                colInfo = this.reportMain.report.getNewColInfoSet(newColInfo);
                Report newReport = this.reportMain.report.setNewData(colData, colInfo, false, this.reportMain.report.getReportType(), false);
                this.reportMain.setReport(newReport);
                makeColInvisible = true;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to perform action", ex);
        }
        int colInfoIdx = this.getColInfoIndex(colDataIdx);
        int colIndex = this.reportMain.report.getTableColumn(colInfoIdx, tbl);
        tbl = this.reportMain.report.getReportTables().elementAt(0);
        if (makeColInvisible) {
            tbl.getColumn(colIndex).setVisible(false);
        }
        String formula = "";
        int sqlType = this.reportMain.report.getSQLType(this.reportMain.report.getColInfoIndex(colIndex));
        if (colAggr != 0) {
            formula = IAggregateConstants.AGGR[colAggr] + "(";
            if (!(DataType.isNumeric(DataType.mapType(sqlType)) || colAggr != 4 && colAggr != 11)) {
                sqlType = 4;
            }
        }
        String tablename = tbl.getColumn(colIndex).getDBTableName();
        String referencename = tbl.getColumn(colIndex).getText();
        if (tablename != null) {
            referencename = tablename + "." + referencename;
        }
        formula = formula + "{" + referencename + "}";
        if (colAggr != 0) {
            formula = formula + ")";
        }
        this.reportMain.setInsertFormula(true, formula, formula, sqlType);
        this.reportMain.designPanel.rulerPanel.getPanel((ReportTableElement)this.elt).insertObject(ulX, ulY, w, h);
    }

    private void insertDatabaseFieldToReportTable(int ulX, int ulY, int w, int h) {
        ReportColumn col;
        ReportTable tbl;
        block15: {
            String[] tmp = this.reportMain.getSelectedDatabaseField();
            String dbAggr = this.reportMain.getSelectedDatabaseFieldAggr();
            String tblName = tmp[0];
            String colName = tmp[1];
            short colAggr = this.reportMain.getSelectedColumnAggrIndex();
            ColInfo[] colInfo = this.reportMain.report.colInfo;
            ColData[] colData = this.reportMain.report.colData;
            DBInfoBasic dbInfo = this.reportMain.report.dbInfo;
            tbl = this.reportMain.report.getReportTables().elementAt(0);
            int colDataIdx = this.getColDataIndex(colName, tblName);
            col = null;
            try {
                if (!QueryParser.isColumnPresent(tblName, colName, dbInfo.getQuery()) || colDataIdx < 0) {
                    String newSQL = this.insertFieldToSQL(tblName, colName, dbAggr);
                    this.reportMain.report.dbInfo.setQuery(newSQL);
                    colData = ReloadReport.getOriginalColData(this.reportMain.report, true, 0, 20);
                    colDataIdx = colData.length - 2;
                    ColInfo newColInfo = new ColInfo(colDataIdx);
                    newColInfo.setVisible(true);
                    if (this.reportMain.report.isAggregationOn()) {
                        if (colAggr <= 0) {
                            colAggr = 6;
                        }
                        newColInfo.setAggregation(this.isAggregatedColumn(colInfo), colAggr);
                    }
                    colDataIdx = colData.length - 2;
                    colInfo = this.reportMain.report.getNewColInfoSet(newColInfo);
                    Report newReport = this.reportMain.report.setNewData(colData, colInfo, false, this.reportMain.report.getReportType(), false);
                    this.reportMain.setReport(newReport);
                    int colInfoIdx = this.getColInfoIndex(colDataIdx);
                    int colIndex = this.reportMain.report.getTableColumn(colInfoIdx, tbl);
                    tbl = this.reportMain.report.getReportTables().elementAt(0);
                    col = tbl.getColumn(colIndex);
                    break block15;
                }
                if (!this.isColumnSelected(colDataIdx)) {
                    ColInfo newColInfo = new ColInfo(colDataIdx);
                    newColInfo.setVisible(true);
                    if (this.reportMain.report.isAggregationOn()) {
                        if (colAggr <= 0) {
                            colAggr = 6;
                        }
                        newColInfo.setAggregation(this.isAggregatedColumn(colInfo), colAggr);
                    }
                    colInfo = this.reportMain.report.getNewColInfoSet(newColInfo);
                    Report newReport = this.reportMain.report.setNewData(colData, colInfo, false, this.reportMain.report.getReportType(), false);
                    this.reportMain.setReport(newReport);
                    int colInfoIdx = this.getColInfoIndex(colDataIdx);
                    int colIndex = this.reportMain.report.getTableColumn(colInfoIdx, tbl);
                    tbl = this.reportMain.report.getReportTables().elementAt(0);
                    col = tbl.getColumn(colIndex);
                    break block15;
                }
                int colInfoIdx = this.getColInfoIndex(colDataIdx);
                int colIndex = this.reportMain.report.getTableColumn(colInfoIdx, tbl);
                col = tbl.getColumn(colIndex);
                if (!col.isVisible()) {
                    this.reportMain.report.colInfo[colInfoIdx].setVisible(true);
                    col.setVisible(true);
                    break block15;
                }
                String formula = "";
                int sqlType = this.reportMain.report.getSQLType(this.reportMain.report.getColInfoIndex(colIndex));
                if (colAggr != 0) {
                    formula = IAggregateConstants.AGGR[colAggr] + "(";
                    if (!(DataType.isNumeric(DataType.mapType(sqlType)) || colAggr != 4 && colAggr != 11)) {
                        sqlType = 4;
                    }
                }
                String tablename = tbl.getColumn(colIndex).getDBTableName();
                String referencename = tbl.getColumn(colIndex).getText();
                if (tablename != null) {
                    referencename = tablename + "." + referencename;
                }
                formula = formula + "{" + referencename + "}";
                if (colAggr != 0) {
                    formula = formula + ")";
                }
                this.reportMain.setInsertFormula(true, formula, formula, sqlType);
                this.insertObject(ulX, ulY, w, h);
                return;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to perform action", ex);
            }
        }
        ReportColumn[] column = this.reportMain.report.column;
        if (col != null) {
            for (int i = 0; i < Array.getLength(column); ++i) {
                if (!FormatUtil.isFormatAppliabled(col.getDataFormat(), column[i].getDataFormat())) continue;
                col.applyTemplate(column[i]);
                break;
            }
            col.setBgColor2(tbl.getColumn(0).getBgColor2());
            col.setAlternateRow(tbl.getColumn(0).getAlternateRow());
            col.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
            col.setX((double)ulX / (double)QbUtil.getPixelPerInch());
            col.setY((double)ulY / (double)QbUtil.getPixelPerInch());
            ReportElementPanel.setWidthHeight(col, w, h);
        }
    }

    private boolean isAggregatedColumn(ColInfo[] cInfo) {
        for (ColInfo element : cInfo) {
            if (!element.isAggregatedColumn()) continue;
            return true;
        }
        return false;
    }

    private int getColDataIndex(String colName, String tblName) {
        ColData[] colData = this.reportMain.report.colData;
        for (int i = 0; i < colData.length; ++i) {
            if (!colName.equalsIgnoreCase(colData[i].getName()) || !tblName.equalsIgnoreCase(colData[i].getTableName()) && colData[i].getTableName() != null && !colData[i].getTableName().equals("")) continue;
            return i;
        }
        return -1;
    }

    private int getColInfoIndex(int colDataIdx) {
        ColInfo[] colInfo = this.reportMain.report.colInfo;
        for (int i = 0; i < colInfo.length; ++i) {
            if (colInfo[i].getMapping() != colDataIdx || colInfo[i].isColumnBreak() || colInfo[i].isColumnBreakValue()) continue;
            return i;
        }
        return -1;
    }

    private boolean isColumnSelected(int colDataIdx) {
        return this.getColInfoIndex(colDataIdx) != -1;
    }

    private String insertFieldToSQL(String tblName, String colName, String agg) throws Exception {
        DBInfoBasic dbInfo = this.reportMain.report.dbInfo;
        ReadDatabase readDB = null;
        readDB = dbInfo.isUseJNDIDataSource() ? new ReadDatabase(dbInfo.getJNDIName(), dbInfo.getEnvProperties()) : new ReadDatabase(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword());
        if (this.databaseType == -1) {
            this.databaseType = QueryBuilder.mapDatabaseType(readDB.getProductName());
        }
        String sql = dbInfo.getQuery();
        sql = sql.replace('\n', ' ');
        sql = sql.replace('\r', ' ');
        String upperSQL = sql.toUpperCase();
        int idx = upperSQL.indexOf(" FROM ");
        sql = sql.substring(0, idx) + ", " + this.getDisplayName(tblName, colName, agg, this.databaseType) + sql.substring(idx);
        if (agg != null && !agg.trim().equals("") && agg.equals(DatabaseFieldDialog.DBAGGR[DatabaseFieldDialog.GROUPBY])) {
            String val = QueryBuilder.printExpression(this.databaseType, tblName, colName);
            int groupByIdx = upperSQL.indexOf(" GROUP BY ");
            int orderByIdx = upperSQL.indexOf(" ORDER BY ", groupByIdx);
            int havingIdx = upperSQL.indexOf(" HAVING ", groupByIdx);
            int semiIdx = upperSQL.indexOf(";", groupByIdx);
            int lastIdx = upperSQL.length();
            if (orderByIdx > groupByIdx && orderByIdx < lastIdx) {
                lastIdx = orderByIdx;
            }
            if (havingIdx > groupByIdx && havingIdx < lastIdx) {
                lastIdx = havingIdx;
            }
            if (semiIdx > groupByIdx && semiIdx < lastIdx) {
                lastIdx = semiIdx;
            }
            sql = lastIdx == upperSQL.length() ? sql + ", " + val : sql.substring(0, lastIdx) + ", " + val + sql.substring(lastIdx);
        }
        return sql;
    }

    private String getDisplayName(String tblName, String colName, String agg, int databaseType) {
        String val = QueryBuilder.printExpression(databaseType, tblName, colName);
        if (agg != null && !agg.trim().equals("") && !agg.equals(DatabaseFieldDialog.DBAGGR[DatabaseFieldDialog.GROUPBY])) {
            return agg + "(" + QueryBuilder.printExpression(databaseType, tblName, colName) + ") AS NW" + System.currentTimeMillis();
        }
        return val;
    }

    private static void formatCellBaseOnFormula(ReportElement elt, Formula formula) {
        String[] fText = new String[]{"getCurrentDate()", "getCurrentDateTime()", "getCurrentTime()", "\"Page \"+getPage()", "\"Page \"+getPage()+ \" of \"+getTotalPages()"};
        for (int i = 0; i < fText.length; ++i) {
            if (!formula.getText().equals(fText[i])) continue;
            elt.setResizeToFitContent(true);
            if (i == 1 || i == 4) {
                elt.setWidth(elt.getWidth() * 2.0);
            }
            return;
        }
    }

    private static void setWidthHeight(ReportElement elt, int w, int h) {
        if (elt == null) {
            return;
        }
        elt.setWidth((double)w / (double)QbUtil.getPixelPerInch());
        elt.setHeight((double)h / (double)QbUtil.getPixelPerInch());
    }

    private void drawDashRect(ReportElement cell, int x, int y, int w, int h, Graphics g) {
        boolean[] corners = null;
        if (cell instanceof ReportLine) {
            if (h < 0) {
                h = this.getHeight();
            }
            ReportLine line = (ReportLine)cell;
            boolean isVert = ((ReportLine)cell).isVertical();
            if (isVert) {
                if (line.previous() == null && line.next() != null) {
                    h = this.getHeight();
                } else if (line.previous() != null && line.next() != null) {
                    y = 0;
                    h = this.getHeight();
                } else if (line.previous() != null && line.next() == null) {
                    h = y + h;
                    y = 0;
                }
                corners = cell instanceof ColumnWrap ? new boolean[]{false, false, false, false, false, false, false, false} : new boolean[]{false, line.previous() == null, false, false, false, false, line.next() == null, false};
            } else {
                corners = new boolean[]{false, false, false, true, true, false, false, false};
            }
        } else if (cell instanceof ReportGrid) {
            ReportGrid grid;
            if (h < 0) {
                h = this.getHeight();
            }
            if ((grid = (ReportGrid)cell).previous() == null && grid.next() != null) {
                h = this.getHeight();
            } else if (grid.previous() != null && grid.next() != null) {
                y = 0;
                h = this.getHeight();
            } else if (grid.previous() != null && grid.next() == null) {
                h = y + h;
                y = 0;
            }
            boolean top = grid.previous() == null;
            boolean bottom = grid.next() == null;
            corners = new boolean[]{top, top, top, false, false, bottom, bottom, bottom};
        } else if (cell != this.reportMain.selectedObject) {
            corners = new boolean[]{false, false, false, false, false, false, false, false};
        }
        ReportGraphics.drawDashRect(x, y, w, h, corners, g);
    }

    public int getDividerSize() {
        return this.reportMain.designPanel.rulerPanel.getDividerSize();
    }

    public void skipDrawDraggedObjects(boolean state) {
        this.skipDrawDraggedObjects = state;
    }

    public boolean isShiftMode() {
        return this.reportMain.isShiftSelected;
    }

    public void shiftOnMove(int dx, int dy) {
        double w = (double)dx / (double)QbUtil.getPixelPerInch();
        double h = (double)dy / (double)QbUtil.getPixelPerInch();
        if (this.isReportSection()) {
            ReportSection rs = (ReportSection)this.elt;
            rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
            rs.shiftOnMove(this.selectedObject, true, w);
            rs.shiftOnMove(this.selectedObject, false, h);
        } else {
            ReportTable rt = this.getOriginalReportTable();
            rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
            rt.shiftOnMove(this.selectedObject, true, w);
            rt.shiftOnMove(this.selectedObject, false, h);
        }
        this.reportMain.menuBar.setUndoEnabled(true);
    }

    public void shiftOnResize(int dx, int dy) {
        double width = this.selectedObject.getWidth();
        double height = this.selectedObject.getHeight();
        int w = QbUtil.toPixel(width) + dx;
        int h = QbUtil.toPixel(height) + dy;
        double w1 = (double)dx / (double)QbUtil.getPixelPerInch();
        double h1 = (double)dy / (double)QbUtil.getPixelPerInch();
        double x0 = this.selectedObject.getWidth();
        double y0 = this.selectedObject.getHeight();
        this.reportMain.createBackupReport();
        this.reportMain.menuBar.setUndoEnabled(false);
        if (w >= 1 && h >= 1) {
            if (this.isReportSection()) {
                ReportSection rs = (ReportSection)this.elt;
                rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                rs.shift(this.selectedObject, true, w1);
                rs.shift(this.selectedObject, false, h1);
            } else {
                ReportTable rt = this.getOriginalReportTable();
                rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                rt.shift(this.selectedObject, true, w1);
                rt.shift(this.selectedObject, false, h1);
            }
        } else if (w < 1 && h >= 1) {
            if (this.isReportSection()) {
                ReportSection rs = (ReportSection)this.elt;
                rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                rs.shift(this.selectedObject, true, -x0);
                rs.shift(this.selectedObject, false, h1);
            } else {
                ReportTable rt = this.getOriginalReportTable();
                rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                rt.shift(this.selectedObject, true, -x0);
                rt.shift(this.selectedObject, false, h1);
            }
        } else if (w >= 1 && h < 1) {
            if (this.isReportSection()) {
                ReportSection rs = (ReportSection)this.elt;
                rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
                rs.shift(this.selectedObject, true, w1);
                rs.shift(this.selectedObject, false, -y0);
            } else {
                ReportTable rt = this.getOriginalReportTable();
                rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
                rt.shift(this.selectedObject, true, w1);
                rt.shift(this.selectedObject, false, -y0);
            }
        } else if (this.isReportSection()) {
            ReportSection rs = (ReportSection)this.elt;
            rs.setDesignerSecuredMode(this.reportMain.isSecureMode());
            rs.shift(this.selectedObject, true, -x0);
            rs.shift(this.selectedObject, false, -y0);
        } else {
            ReportTable rt = this.getOriginalReportTable();
            rt.setDesignerSecuredMode(this.reportMain.isSecureMode());
            rt.shift(this.selectedObject, true, -x0);
            rt.shift(this.selectedObject, false, -y0);
        }
        this.reportMain.menuBar.setUndoEnabled(true);
    }

    private void setupAllDraggedVertGridLine(int dx, int dy) {
        Vector<ReportElement> skip = new Vector<ReportElement>();
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            p.setupDraggedVertGridLine(dx, dy, skip);
            for (ReportElement element : p.groupFormat) {
                ReportElement e = element;
                if (!ReportElementPanel.isGridOrVertLine(e)) continue;
                ReportElement head = this.getHeadNode(e);
                skip.add(head);
            }
        }
    }

    private void setupDraggedVertGridLine(int dx, int dy) {
        this.setupDraggedVertGridLine(dx, dy, null);
    }

    private void setupDraggedVertGridLine(int dx, int dy, Vector<ReportElement> skip) {
        for (ReportElement element : this.groupFormat) {
            ReportElement obj = element;
            if (!ReportElementPanel.isGridOrVertLine(obj)) continue;
            ReportElement head = this.getHeadNode(obj);
            if (skip != null && skip.contains(head)) continue;
            Vector<JPanel> panels = this.getVisiblePanels();
            GridLine gl = new GridLine(panels);
            int totalHeight = QbUtil.toPixel(this.getTotalHeight(head, true));
            int tempDy = head instanceof ColumnWrap ? 0 : dy;
            int[] res = gl.findStartEndPanel(this.getPanel((ReportImage)head), QbUtil.toPixel(head.getY()) + tempDy, totalHeight + tempDy, false);
            if (res == null) {
                return;
            }
            double newX = head.getX() + (double)dx / (double)QbUtil.getPixelPerInch();
            this.setupGridLine(res, panels, QbUtil.toPixel(head.getHeight()), newX, head);
        }
    }

    private void setupGridLine(int[] res, Vector<JPanel> panels, int headHeight, double newX, ReportElement head) {
        this.setupGridLine(res, panels, headHeight, newX, head, 0.0);
    }

    private void setupGridLine(int[] res, Vector<JPanel> panels, int headHeight, double newX, ReportElement head, double dw) {
        this.setupHead(res, panels, headHeight, newX, head, dw);
        for (int i = res[0] + 1; i < res[2]; ++i) {
            this.setupBody(panels, i, newX, head, dw);
        }
        if (res[0] != res[2]) {
            this.setupTail(res, panels, newX, head, dw);
        }
    }

    private void setupHead(int[] res, Vector<JPanel> panels, int headHeight, double newX, ReportElement head, double dw) {
        ReportElementPanel p = (ReportElementPanel)panels.get(res[0]);
        ReportImage line = null;
        line = head instanceof ColumnWrap ? new ColumnWrap(head.getX()) : (head instanceof ReportLine ? new ReportLine(true) : new ReportGrid());
        line.setX(newX);
        line.setWidth(head.getWidth() + dw);
        line.setY((double)res[1] / (double)QbUtil.getPixelPerInch());
        if (res[0] != res[2]) {
            if (line instanceof ReportLine) {
                ((ReportLine)line).setNext(new ReportLine(true));
            } else if (line instanceof ReportGrid) {
                ((ReportGrid)line).setNext(new ReportGrid());
            }
        }
        if (res[1] + headHeight > p.getHeight()) {
            line.setHeight(-1.0);
        } else if (headHeight < 0) {
            line.setHeight(this.getTotalHeight(head, true) - this.getCellY(head) + this.getCellPanelY(head));
        } else {
            line.setHeight((double)headHeight / (double)QbUtil.getPixelPerInch());
        }
        p.draggedObjects.add(line);
    }

    private double getCellPanelY(ReportElement re) {
        double y = 0.0;
        Vector<JPanel> visiblePanel = this.getVisiblePanels();
        for (int i = 0; i < visiblePanel.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)visiblePanel.elementAt(i);
            ReportElement[] elems = panel.getPanelElements();
            if (!(panel.getElement() instanceof ReportSection)) {
                elems = panel.getOriginalReportTable().getAllTableElements();
            }
            boolean found = false;
            for (ReportElement elem : elems) {
                if (elem != re && !elem.getID().equals(re.getID())) continue;
                found = true;
            }
            if (found) {
                return y;
            }
            if (panel.getElement() instanceof ReportSection) {
                y += ((ReportSection)panel.getElement()).getHeight();
                continue;
            }
            y += panel.getOriginalReportTable().getHeight();
        }
        return 0.0;
    }

    private void setupBody(Vector<JPanel> panels, int i, double newX, ReportElement head, double dw) {
        ReportElementPanel p = (ReportElementPanel)panels.get(i);
        ReportImage line = null;
        line = head instanceof ColumnWrap ? new ColumnWrap(head.getX()) : (head instanceof ReportLine ? new ReportLine(true) : new ReportGrid());
        line.setWidth(head.getWidth() + dw);
        line.setX(newX);
        line.setY(0.0);
        line.setHeight(-1.0);
        if (line instanceof ReportLine) {
            ((ReportLine)line).setNext(new ReportLine(true));
            ((ReportLine)line).setPrevious(new ReportLine(true));
        } else if (line instanceof ReportGrid) {
            ((ReportGrid)line).setNext(new ReportGrid());
            ((ReportGrid)line).setPrevious(new ReportGrid());
        }
        p.draggedObjects.add(line);
    }

    private void setupTail(int[] res, Vector<JPanel> panels, double newX, ReportElement head, double dw) {
        ReportElementPanel p = (ReportElementPanel)panels.get(res[2]);
        ReportImage line = null;
        line = head instanceof ColumnWrap ? new ColumnWrap(head.getX()) : (head instanceof ReportLine ? new ReportLine(true) : new ReportGrid());
        line.setWidth(head.getWidth() + dw);
        line.setX(newX);
        line.setY(0.0);
        line.setHeight((double)res[3] / (double)QbUtil.getPixelPerInch());
        if (line instanceof ReportLine) {
            ((ReportLine)line).setPrevious(new ReportLine(true));
        } else if (line instanceof ReportGrid) {
            ((ReportGrid)line).setPrevious(new ReportGrid());
        }
        p.draggedObjects.add(line);
    }

    private void setupDraggedDestPanel(ReportElementPanel destPanel, int dy, int yOffset) {
        destPanel.dragDashYOffset = yOffset;
        destPanel.draggedDy = dy;
        for (int i = 0; i < this.groupFormat.size(); ++i) {
            ReportElement obj = this.groupFormat.get(i);
            if (ReportElementPanel.isGridOrVertLine(obj)) continue;
            if (!this.reportMain.isAllowCrosstabElementMove() && (destPanel.getElement() instanceof CrossTabReportSection || destPanel.getElement() instanceof ReportTable && this.reportMain.report.isCrossTab())) {
                new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You cannot insert element to CrossTab report section!"));
                return;
            }
            destPanel.draggedObjects.add(obj);
        }
    }

    public static boolean isVerticalLine(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof ReportLine && ((ReportLine)obj).isVertical();
    }

    public void setupDraggedResizeGridLines(int dy, int dh) {
        this.setupDraggedResizeGridLines(0, dy, 0, dh);
    }

    public void setupDraggedResizeGridLines(int dx, int dy, int dw, int dh) {
        this.draggedObjects.clear();
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel)) continue;
            this.setupDraggedResizeGridLines((ReportElementPanel)obj, dx, dy, dw, dh);
        }
    }

    private void setupDraggedResizeGridLines(ReportElementPanel p, int dx, int dy, int dw, int dh) {
        for (ReportElement obj : p.groupFormat) {
            ReportElement line;
            ReportElement head;
            if (!ReportElementPanel.isGridOrVertLine(obj) || (head = this.getHeadNode(line = obj)) != line) continue;
            Vector<JPanel> panels = this.getVisiblePanels();
            GridLine gl = new GridLine(panels);
            int totalHeight = QbUtil.toPixel(this.getTotalHeight(head, true));
            int[] res = gl.findStartEndPanel(this.getPanel((ReportImage)head), QbUtil.toPixel(head.getY()) + dy, totalHeight + dh, false);
            double newX = head.getX() + (double)dx / (double)QbUtil.getPixelPerInch();
            int headHeight = totalHeight;
            if (res[0] == res[2]) {
                headHeight += dh;
            }
            if (headHeight < 0) {
                headHeight = 0;
            }
            if (res[0] == res[2]) {
                if (res[1] >= res[3]) {
                    if (dh == 0) {
                        res[1] = res[3] - 1;
                    } else {
                        res[3] = res[1] + 1;
                    }
                }
                headHeight = res[3] - res[1];
            }
            this.setupGridLine(res, panels, headHeight, newX, head, (double)dw / (double)QbUtil.getPixelPerInch());
        }
    }

    public void resizePropGridOrVertLines(double startX, double startY, double ratioW, double ratioH) {
        this.resizeGridOrVertLines(-1, -1, -1, -1, startX, startY, ratioW, ratioH);
    }

    public void resizeGridOrVertLines(int dx, int dy, int dw, int dh) {
        this.resizeGridOrVertLines(dx, dy, dw, dh, -1.0, -1.0, -1.0, -1.0);
    }

    private void resizeGridOrVertLines(int dx, int dy, int dw, int dh, double startX, double startY, double ratioW, double ratioH) {
        this.resizedReAdd.clear();
        Vector<JPanel> panels = this.getVisiblePanels();
        this.resizedLines = new Vector();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel)) continue;
            this.resizeGridOrVertLines((ReportElementPanel)obj, dx, dy, dw, dh, startX, startY, ratioW, ratioH);
            ((ReportElementPanel)obj).repaint();
        }
        this.selectResizedReAddedLines();
    }

    private void resizeGridOrVertLines(ReportElementPanel p, int dx, int dy, int dw, int dh, double startX, double startY, double ratioW, double ratioH) {
        for (int i = 0; i < p.groupFormat.size(); ++i) {
            ReportElement line;
            ReportElement head;
            ReportElement obj = p.groupFormat.get(i);
            if (!ReportElementPanel.isGridOrVertLine(obj) || this.resizedLines.contains(head = p.getHeadNode(line = obj))) continue;
            ReportElement result = this.resizeGridOrVertLine(head, dx, dy, dw, dh, startX, startY, ratioW, ratioH);
            this.resizedReAdd.add(result);
            this.resizedLines.add(head);
            this.removeFromSelected(head);
            this.removeAllSelectedObjects();
            this.reportMain.explorer.deleteNode(line.getID());
            result.setID(line.getID());
            --i;
        }
    }

    private void removeFromSelected(ReportElement headNode) {
        if (headNode == null) {
            return;
        }
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            if (!p.groupFormat.contains(headNode)) continue;
            p.groupFormat.remove(headNode);
            if (headNode instanceof ReportLine) {
                headNode = ((ReportLine)headNode).next();
                continue;
            }
            headNode = ((ReportGrid)headNode).next();
        }
    }

    private void removeAllSelectedObjects() {
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            p.selectedObject = null;
        }
    }

    private ReportElement resizeGridOrVertLine(ReportElement headNode, int dx, int dy, int dw, int dh, double startX, double startY, double ratioW, double ratioH) {
        if (headNode.isLocked()) {
            return headNode;
        }
        GridLine gl = new GridLine(this.getVisiblePanels());
        ReportCell newCell = null;
        if (startX == -1.0 && startY == -1.0 && ratioW == -1.0 && ratioH == -1.0) {
            newCell = gl.set(this.getPanel((ReportImage)headNode), QbUtil.toPixel(headNode.getX()) + dx, QbUtil.toPixel(headNode.getY()) + dy, QbUtil.toPixel(headNode.getX() + headNode.getWidth()) + dw, QbUtil.toPixel(this.getTotalHeight(headNode, true)) + dh, headNode instanceof ReportLine, ReportElementPanel.isVerticalLine(headNode), null, true);
        } else {
            double offsetX = headNode.getX() - startX;
            double newX = startX + offsetX * ratioW;
            double newY = headNode.getY();
            double newWidth = headNode.getWidth() * ratioW + newX;
            double newHeight = this.getTotalHeight(headNode);
            if (startY != -1.0 && ratioH != -1.0) {
                double offsetY = headNode.getY() - startY;
                newY = startY + offsetY * ratioH;
                newHeight = this.getTotalHeight(headNode) - headNode.getY();
                newHeight = newHeight * ratioH + newY;
            }
            newCell = gl.set(this.getPanel((ReportImage)headNode), QbUtil.toPixel(newX), QbUtil.toPixel(newY), QbUtil.toPixel(newWidth), QbUtil.toPixel(newHeight), headNode instanceof ReportLine, ReportElementPanel.isVerticalLine(headNode), null, true);
        }
        if (newCell != null) {
            if (newCell instanceof ReportLine) {
                newCell.setBgColor(((ReportLine)headNode).getBgColor());
                ((ReportLine)newCell).setLineStyle(((ReportLine)headNode).getLineStyle());
                if (((ReportLine)newCell).isVertical()) {
                    newCell.setWidth(((ReportLine)headNode).getWidth());
                } else {
                    newCell.setHeight(((ReportLine)headNode).getHeight());
                }
            } else if (newCell instanceof ReportGrid) {
                newCell.setBorderThickness(((ReportGrid)headNode).getBorderThickness());
                newCell.setBorderColor(((ReportGrid)headNode).getBorderColor());
                newCell.setBgColor(((ReportGrid)headNode).getBgColor());
                ((ReportGrid)newCell).setGridStyle(((ReportGrid)headNode).getGridStyle());
                ((ReportGrid)newCell).setRoundCornerRadius(((ReportGrid)headNode).getRoundCornerRadius());
                ((ReportGrid)newCell).setRoundCornersArray(((ReportGrid)headNode).getRoundCornersArray());
            }
            gl.remove(headNode);
        }
        return newCell != null ? newCell : headNode;
    }

    private void selectResizedReAddedLines() {
        Vector<JPanel> panels = this.getVisiblePanels();
        for (ReportElement obj : this.resizedReAdd) {
            ReportElement head = this.getHeadNode(obj);
            ReportElementPanel p = (ReportElementPanel)panels.get(this.getPanel((ReportImage)head));
            this.reportMain.explorer.insertIntoNode(p.getElement(), head == null ? obj : head);
            p.select(head, false);
            this.reportMain.setSelectedObject(obj, this);
        }
    }

    static boolean masterSection(ReportElement e) {
        if (e == null) {
            return false;
        }
        if (!(e instanceof ReportSection)) {
            return false;
        }
        return e.getID().startsWith("MTR_");
    }

    public static boolean isGridOrVertLine(Object e) {
        if (e instanceof ReportGrid) {
            return true;
        }
        if (e instanceof ReportLine) {
            return ((ReportLine)e).isVertical();
        }
        return false;
    }

    public void drawInsertObjectBox(int x, int y) {
        this.diffX = 0;
        this.diffY = 0;
        this.deltaX = 0;
        this.deltaY = 0;
        this.dragDashYOffset = 0;
        this.draggedDy = 0;
        this.draggedObjects.clear();
        ReportCell cell = new ReportCell();
        cell.setX(QbUtil.toInch(x));
        cell.setY(QbUtil.toInch(y));
        cell.setWidth(this.getDefaultWidth());
        cell.setHeight(this.getDefaultHeight());
        this.draggedObjects.add(cell);
        this.drawBoundingBox = true;
        this.isDragOp = true;
        this.paintComponent(this.getGraphics());
        this.drawBoundingBox = false;
        this.isDragOp = false;
    }

    private double getDefaultWidth() {
        if (this.reportMain.isInsertLabel()) {
            return this.reportMain.report.labelSetting.getWidth();
        }
        if (this.reportMain.isInsertColumnHeader()) {
            return this.reportMain.report.columnHeaderSetting.getWidth();
        }
        if (this.reportMain.isInsertFormula()) {
            return this.reportMain.report.stringFormulaSetting.getWidth();
        }
        if (this.reportMain.isInsertDatabaseField()) {
            return this.reportMain.report.stringFormulaSetting.getWidth();
        }
        if (this.reportMain.isInsertChart()) {
            return this.reportMain.report.chartSetting.getWidth();
        }
        if (this.reportMain.isInsertImage()) {
            return this.reportMain.report.imageSetting.getWidth();
        }
        return 1.0;
    }

    private double getDefaultHeight() {
        if (this.reportMain.isInsertLabel()) {
            return this.reportMain.report.labelSetting.getHeight();
        }
        if (this.reportMain.isInsertColumnHeader()) {
            return this.reportMain.report.columnHeaderSetting.getHeight();
        }
        if (this.reportMain.isInsertFormula()) {
            return this.reportMain.report.stringFormulaSetting.getHeight();
        }
        if (this.reportMain.isInsertDatabaseField()) {
            return this.reportMain.report.stringFormulaSetting.getHeight();
        }
        if (this.reportMain.isInsertChart()) {
            return this.reportMain.report.chartSetting.getHeight();
        }
        if (this.reportMain.isInsertImage()) {
            return this.reportMain.report.imageSetting.getHeight();
        }
        return 0.3;
    }

    public void addFormula(Formula formulaObj) throws IOException, ParseException {
        Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
        formulaVec.add(this.reportMain.report.formulas);
        for (int i = 0; this.reportMain.report.subReports != null && i < this.reportMain.report.subReports.size(); ++i) {
            Report rpt = this.reportMain.report.getSubReportArray()[i];
            if (rpt == null) continue;
            formulaVec.add(rpt.formulas);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(formulaObj.getText().getBytes("UTF-8"));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
        formulaObj.setFormula(parser.parse(formulaVec, this.reportMain.report.getQueryParameters(), this.reportMain.report.getFormulaParameters(), formulaObj.getName()));
        this.reportMain.report.formulas.addElement(formulaObj);
    }

    public String nextFormulaName() {
        String result = "formula_";
        int i = 0;
        while (this.isDuplicateFormulaName(result + i)) {
            ++i;
        }
        return result + i;
    }

    private boolean isDuplicateFormulaName(String name) {
        Formula f;
        Vector<Formula> formulas = this.reportMain.report.formulas;
        for (Formula formula : formulas) {
            f = formula;
            if (!f.getName().equals(name)) continue;
            return true;
        }
        for (Formula element : this.reportMain.designPanel.rulerPanel.pasteToAddFormula) {
            f = element;
            if (!f.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void editElement() {
        ReportElement selected = this.reportMain.getSelectedObject();
        if (selected instanceof ReportLine || selected instanceof ReportGrid) {
            return;
        }
        this.reportMain.setEltText(this);
    }

    public void unselectAll() {
        this.unselectAll(true, null);
    }

    public void unselectAll(boolean clearExplorer, Vector<ReportElement> skip) {
        if (clearExplorer) {
            this.clearExplorer();
        }
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            ReportElementPanel.unselectAll(p, skip);
            p.repaintFromScratch();
        }
    }

    private static void unselectAll(ReportElementPanel p, Vector<ReportElement> skip) {
        p.draggedObjects.clear();
        if (skip != null) {
            for (int i = 0; i < p.groupFormat.size(); ++i) {
                ReportElement unselElt = p.groupFormat.get(i);
                if (skip.contains(unselElt)) continue;
                p.groupFormat.remove(i);
                p.selectItemInExplorer(unselElt, false);
                --i;
            }
        } else {
            p.groupFormat.clear();
            for (int i = 0; i < p.groupFormat.size(); ++i) {
                ReportElement unselElt = p.groupFormat.get(i);
                p.selectItemInExplorer(unselElt, false);
            }
        }
        p.setSelectedObject(null);
    }

    void setBoundingBoxForGroupAlign() {
        if (this.groupFormat.size() == 0) {
            return;
        }
        ReportElement[] rt = new ReportElement[this.groupFormat.size()];
        int i = 0;
        Iterator<ReportElement> it = this.groupFormat.iterator();
        while (it.hasNext()) {
            rt[i] = it.next();
            ++i;
        }
        ReportElementPanel panel1 = this;
        panel1.boundingX = ReportElement.findMinX(rt);
        panel1.boundingY = ReportElement.findMinY(rt);
        panel1.boundingWidth = ReportElement.findMaxXr(rt) - panel1.boundingX;
        panel1.boundingHeight = ReportElement.findMaxYd(rt) - panel1.boundingY;
    }

    public void setInsertBoundingBox(boolean state) {
        this.reportMain.setInsertBoundingBox(state);
    }

    void clearAllDraggedObjects() {
        Vector<JPanel> panels = this.getVisiblePanels();
        for (JPanel jPanel : panels) {
            JPanel obj = jPanel;
            if (!(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            p.draggedObjects.clear();
        }
    }

    public void markUndoCheckPoint() {
        this.reportMain.markUndoCheckPoint();
    }

    public ReportElement getSelectedObject() {
        return this.reportMain.selectedObject;
    }

    public void updateRulerForGridLine(ReportElement gridVertLine) {
        int startPanel;
        ReportElement headNode = this.getHeadNode(gridVertLine);
        Vector<JPanel> panels = this.getVisiblePanels();
        JPanel obj = panels.get(startPanel = this.getPanel((ReportImage)headNode));
        if (obj instanceof ReportElementPanel) {
            ReportElementPanel p = (ReportElementPanel)obj;
            p.setSelectedObject(headNode);
            p.updateRulers();
        }
    }

    static boolean contains(ReportElement container, ReportElement cell) {
        if (container instanceof ReportSection) {
            if (cell instanceof ReportCell) {
                return ((ReportSection)container).hasCell((ReportCell)cell);
            }
        } else if (container instanceof ReportTable) {
            return ((ReportTable)container).contains(cell);
        }
        return false;
    }

    public void updateRulers(ReportElement selected) {
        if (ReportElementPanel.isGridOrVertLine(selected)) {
            Vector<JPanel> panels = this.getVisiblePanels();
            for (JPanel jPanel : panels) {
                JPanel obj = jPanel;
                if (!(obj instanceof ReportElementPanel)) continue;
                ReportElementPanel p = (ReportElementPanel)obj;
                if (!ReportElementPanel.isGridOrVertLine(p.selectedObject)) continue;
                p.updateRulers();
                return;
            }
        } else if (selected == null) {
            ReportElement nonGridVertLine = null;
            ReportElement gridVertLine = null;
            for (ReportElement element : this.groupFormat) {
                ReportElement e = element;
                if (!ReportElementPanel.isGridOrVertLine(e)) {
                    nonGridVertLine = e;
                    continue;
                }
                gridVertLine = e;
            }
            if (nonGridVertLine == null && gridVertLine != null) {
                this.updateRulerForGridLine(gridVertLine);
                return;
            }
        }
        this.updateRulers();
    }

    public boolean groupFormatFlag() {
        return this.reportMain.groupFormatFlag();
    }

    public ReportElement findPrevElementWithScript(Script script) {
        int i;
        if (this.elt instanceof ReportSection) {
            ReportCell[] cells = ((ReportSection)this.elt).getCells();
            for (i = cells.length - 1; i >= 0; --i) {
                if (cells[i].getScriptObj() == null || !cells[i].getScriptObj().equals(script)) continue;
                return cells[i];
            }
        }
        if (this.elt instanceof ReportTable) {
            ReportElement[] elts = ((ReportTable)this.elt).getXSortedVisibleElements();
            for (i = elts.length - 1; i >= 0; --i) {
                if (elts[i].getScriptObj() == null || !elts[i].getScriptObj().equals(script)) continue;
                return elts[i];
            }
        }
        if (this.elt.getScriptObj() != null && this.elt.getScriptObj().equals(script)) {
            return this.elt;
        }
        return null;
    }

    public ReportElement findPrevElementWithScript(Script script, ReportElement selectedObject, boolean after) {
        if (!after) {
            int i;
            boolean found = false;
            if (this.elt instanceof ReportSection) {
                ReportCell[] cells = ((ReportSection)this.elt).getCells();
                for (i = cells.length - 1; i >= 0; --i) {
                    if (cells[i] == selectedObject) {
                        found = true;
                        continue;
                    }
                    if (!found || cells[i].getScriptObj() == null || !cells[i].getScriptObj().equals(script)) continue;
                    return cells[i];
                }
            }
            if (this.elt instanceof ReportTable) {
                ReportElement[] elts = ((ReportTable)this.elt).getXSortedVisibleElements();
                for (i = elts.length - 1; i >= 0; --i) {
                    if (elts[i] == selectedObject) {
                        found = true;
                        continue;
                    }
                    if (!found || elts[i].getScriptObj() == null || !elts[i].getScriptObj().equals(script)) continue;
                    return elts[i];
                }
            }
            if (found && this.elt == selectedObject) {
                return this.elt;
            }
        } else {
            int i;
            if (this.elt instanceof ReportSection) {
                ReportCell[] cells = ((ReportSection)this.elt).getCells();
                for (i = cells.length - 1; i >= 0; --i) {
                    if (cells[i] == selectedObject) {
                        return null;
                    }
                    if (cells[i].getScriptObj() == null || !cells[i].getScriptObj().equals(script)) continue;
                    return cells[i];
                }
            }
            if (this.elt instanceof ReportTable) {
                ReportElement[] elts = ((ReportTable)this.elt).getXSortedVisibleElements();
                for (i = elts.length - 1; i >= 0; --i) {
                    if (elts[i] == selectedObject) {
                        return null;
                    }
                    if (elts[i].getScriptObj() == null || !elts[i].getScriptObj().equals(script)) continue;
                    return elts[i];
                }
            }
        }
        return null;
    }

    public ReportElement findNextElementWithScript(Script script) {
        if (this.elt.getScriptObj() != null && this.elt.getScriptObj().equals(script)) {
            return this.elt;
        }
        if (this.elt instanceof ReportSection) {
            ReportCell[] cells = ((ReportSection)this.elt).getCells();
            for (ReportElement reportElement : cells) {
                if (reportElement.getScriptObj() == null || !reportElement.getScriptObj().equals(script)) continue;
                return reportElement;
            }
        }
        if (this.elt instanceof ReportTable) {
            ReportElement[] elts = ((ReportTable)this.elt).getXSortedVisibleElements();
            for (ReportElement reportElement : elts) {
                if (reportElement.getScriptObj() == null || !reportElement.getScriptObj().equals(script)) continue;
                return reportElement;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ReportElement findNextElementWithScript(Script script, ReportElement selectedObject, boolean after) {
        block18: {
            block17: {
                void var8_15;
                int n;
                ReportElement[] reportElementArray;
                if (!after) break block17;
                boolean found = false;
                if (this.elt == selectedObject) {
                    found = true;
                }
                if (this.elt instanceof ReportSection) {
                    void var8_13;
                    ReportCell[] cells = ((ReportSection)this.elt).getCells();
                    reportElementArray = cells;
                    n = reportElementArray.length;
                    boolean bl = false;
                    while (var8_13 < n) {
                        ReportElement reportElement = reportElementArray[var8_13];
                        if (reportElement == selectedObject) {
                            found = true;
                        } else if (found && reportElement.getScriptObj() != null && reportElement.getScriptObj().equals(script)) {
                            return reportElement;
                        }
                        ++var8_13;
                    }
                }
                if (!(this.elt instanceof ReportTable)) break block18;
                ReportElement[] elts = ((ReportTable)this.elt).getXSortedVisibleElements();
                reportElementArray = elts;
                n = reportElementArray.length;
                boolean bl = false;
                while (var8_15 < n) {
                    ReportElement reportElement = reportElementArray[var8_15];
                    if (reportElement == selectedObject) {
                        found = true;
                    } else if (found && reportElement.getScriptObj() != null && reportElement.getScriptObj().equals(script)) {
                        return reportElement;
                    }
                    ++var8_15;
                }
                break block18;
            }
            if (this.elt == selectedObject) {
                return null;
            }
            if (this.elt instanceof ReportSection) {
                ReportCell[] cells = ((ReportSection)this.elt).getCells();
                for (ReportElement reportElement : cells) {
                    if (reportElement == selectedObject) {
                        return null;
                    }
                    if (reportElement.getScriptObj() == null || !reportElement.getScriptObj().equals(script)) continue;
                    return reportElement;
                }
            }
            if (this.elt instanceof ReportTable) {
                ReportElement[] elts = ((ReportTable)this.elt).getXSortedVisibleElements();
                for (ReportElement reportElement : elts) {
                    if (reportElement == selectedObject) {
                        return null;
                    }
                    if (reportElement.getScriptObj() == null || !reportElement.getScriptObj().equals(script)) continue;
                    return reportElement;
                }
            }
        }
        return null;
    }
}

