/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.designer.ExplorerTreeCellRenderer;
import quadbase.reportdesigner.designer.PopupMenuForReportElement;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;

public class ReportExplorer
implements TreeSelectionListener,
ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ReportExplorer.class.getName());
    JTree mTree;
    private JPanel mainPane;
    DefaultTreeModel treeModel;
    DefaultMutableTreeNode root;
    JButton closeBut;
    ReportMain reportMain;
    private boolean updateReportExplorer = false;
    private boolean selectingObject = false;
    private boolean unselectingObject = false;
    private Vector<TreePath> expandTreePath = new Vector();

    public ReportExplorer(ReportMain reportMain) {
        this.reportMain = reportMain;
        this.init();
    }

    private void init() {
        this.root = this.setTreeNode();
        this.treeModel = new DefaultTreeModel(this.root);
        this.mTree = new JTree(this.treeModel){

            @Override
            public void paintComponent(Graphics g) {
                try {
                    if (ReportExplorer.this.updateReportExplorer) {
                        this.updateExplorer();
                    }
                    super.paintComponent(g);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to update report explorer", ex);
                }
                ReportExplorer.this.updateReportExplorer = false;
            }

            public void updateExplorer() {
                DefaultMutableTreeNode newNode = ReportExplorer.this.setTreeNode();
                if (!ReportExplorer.this.setRoot(newNode)) {
                    return;
                }
                this.treeModel = new DefaultTreeModel(newNode);
                ReportExplorer.this.mTree.setModel(this.treeModel);
                this.validate();
                this.repaint();
            }
        };
        this.mTree.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.mTree.setRootVisible(true);
        this.mTree.setExpandsSelectedPaths(true);
        this.mTree.setEditable(false);
        this.mTree.getSelectionModel().setSelectionMode(4);
        this.mTree.setSelectionRow(0);
        this.mTree.setCellRenderer(new ExplorerTreeCellRenderer(this.reportMain.currentScript));
        this.mTree.addTreeSelectionListener(this);
        if (this.reportMain.currentScript != null) {
            for (int i = 0; i < this.expandTreePath.size(); ++i) {
                TreePath treePath = this.expandTreePath.elementAt(i);
                this.mTree.expandPath(treePath);
            }
        }
        this.mTree.addMouseListener(new MouseAdapter(){
            private int leftClickMask = 0;
            private boolean isPopup = true;

            @Override
            public void mouseClicked(MouseEvent e) {
                this.popupMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ReportExplorer.this.selectingObject = true;
                this.isPopup = true;
                int mouseMask = e.getModifiers() & 0xFFFFFFEF;
                if (ReportExplorer.this.mTree.isSelectionEmpty() && mouseMask == this.leftClickMask) {
                    ReportExplorer.this.reportMain.deselectGroupOption();
                    this.isPopup = false;
                    return;
                }
                if (mouseMask != this.leftClickMask && ReportExplorer.this.mTree.isEditing()) {
                    ReportExplorer.this.mTree.stopEditing();
                    this.isPopup = false;
                    return;
                }
                this.popupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.selectObject();
                if (this.isPopup && !ReportExplorer.this.mTree.isEditing()) {
                    this.popupMenu(e);
                    ReportExplorer.this.selectingObject = false;
                    return;
                }
                ReportExplorer.this.selectingObject = false;
            }

            void popupMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DefaultMutableTreeNode[] node = ReportExplorer.this.getSelectedNodes();
                    if (node == null) {
                        return;
                    }
                    if (node.length > 1) {
                        return;
                    }
                    ReportElement elt = ReportExplorer.this.getReportElement(node[0]);
                    if (elt == null) {
                        return;
                    }
                    ReportElementPanel panel = ReportExplorer.this.getPanel(node[0]);
                    PopupMenuForReportElement popupMenu = new PopupMenuForReportElement(ReportExplorer.this.reportMain);
                    if (!ReportExplorer.isVisible(node[0])) {
                        popupMenu.addInvisibledMenu(elt, panel);
                    } else {
                        popupMenu.addMenu(elt, panel);
                    }
                    popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }

            void selectObject() {
                DefaultMutableTreeNode[] node = ReportExplorer.this.unselectObject();
                if (node == null) {
                    return;
                }
                for (int i = 0; i < node.length; ++i) {
                    ReportElement elt;
                    if (node[i] == null || (elt = ReportExplorer.this.getReportElement(node[i])) == null) continue;
                    ReportElementPanel panel = ReportExplorer.this.getPanel(node[i]);
                    if (ReportExplorer.this.masterSectionElement(elt)) continue;
                    panel.select(elt, false);
                    ReportExplorer.this.reportMain.designPanel.rulerPanel.setViewPosition(panel, elt);
                }
            }
        });
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.mTree);
        this.closeBut = new JButton("x");
        this.closeBut.addActionListener(this);
        JPanel butPanel = new JPanel();
        butPanel.setLayout(new BorderLayout());
        butPanel.add((Component)new JLabel(" " + LanguageEncoder.getText("Report Explorer") + " "), "Center");
        butPanel.add((Component)this.closeBut, "East");
        this.mainPane.add((Component)butPanel, "North");
        this.mainPane.add((Component)scrollPane, "Center");
    }

    private boolean masterSectionElement(ReportElement e) {
        return e.getID().startsWith("MTR_") && e.getID().indexOf(95) != e.getID().lastIndexOf(95);
    }

    private DefaultMutableTreeNode[] unselectObject() {
        if (this.unselectingObject) {
            return null;
        }
        this.unselectingObject = true;
        DefaultMutableTreeNode[] node = this.getSelectedNodes();
        if (node == null) {
            this.unselectingObject = false;
            return node;
        }
        this.unselectAll(node);
        this.unselectingObject = false;
        return node;
    }

    private void unselectAll(DefaultMutableTreeNode[] skip) {
        Vector<ReportElement> elements = new Vector<ReportElement>();
        for (DefaultMutableTreeNode element : skip) {
            ReportElement elt = this.getReportElement(element);
            elements.add(elt);
        }
        Vector<JPanel> panels = this.reportMain.designPanel.rulerPanel.getVisiblePanel();
        for (int i = 0; i < panels.size(); ++i) {
            JPanel p = panels.get(i);
            if (!(p instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)p;
            panel.unselectAll(false, elements);
            return;
        }
    }

    void clearSelection() {
        this.mTree.setSelectionRow(-1);
        this.mTree.clearSelection();
    }

    void setSelection(ReportElement selElt, boolean selecting) {
        TreePath[] curTreePath = this.mTree.getSelectionPaths();
        if (selElt == null) {
            return;
        }
        if (curTreePath == null) {
            if (!selecting) {
                return;
            }
            curTreePath = new TreePath[]{};
        }
        DefaultMutableTreeNode node = null;
        String id = selElt.getID();
        TreePath[] newTreePath = null;
        if (!selecting) {
            newTreePath = new TreePath[curTreePath.length - 1];
            int k = 0;
            for (TreePath element : curTreePath) {
                node = (DefaultMutableTreeNode)element.getLastPathComponent();
                if (id.equals(this.getNodeID(node))) continue;
                if (k >= newTreePath.length) {
                    return;
                }
                newTreePath[k++] = element;
            }
        } else {
            newTreePath = new TreePath[curTreePath.length + 1];
            newTreePath[0] = this.findPath(id);
            if (newTreePath[0] == null) {
                return;
            }
            for (int i = 0; i < curTreePath.length; ++i) {
                if (curTreePath[i] == newTreePath[0]) {
                    return;
                }
                newTreePath[i + 1] = curTreePath[i];
            }
        }
        this.mTree.setSelectionPaths(newTreePath);
    }

    private TreePath findPath(String id) {
        DefaultMutableTreeNode findNode = this.findNode(id);
        if (findNode == null) {
            return null;
        }
        return new TreePath(findNode.getPath());
    }

    private DefaultMutableTreeNode recFindNode(DefaultMutableTreeNode inNode, String id) {
        String tmpId = this.getNodeID(inNode);
        if (tmpId != null && tmpId.equals(id)) {
            return inNode;
        }
        for (int i = 0; i < inNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)inNode.getChildAt(i);
            DefaultMutableTreeNode tempNode = this.recFindNode(child, id);
            if (tempNode == null) continue;
            return tempNode;
        }
        return null;
    }

    private DefaultMutableTreeNode findNode(String id) {
        if (this.root == null) {
            return null;
        }
        return this.recFindNode(this.root, id);
    }

    public void updateReportExplorer(ReportMain reportMain) {
        if (this.selectingObject) {
            return;
        }
        if (this.updateReportExplorer) {
            return;
        }
        this.reportMain = reportMain;
        this.updateReportExplorer = true;
        this.unselectObject();
        this.mTree.validate();
        this.mTree.repaint();
    }

    public void moveNode(String whatID, String whereID) {
        DefaultMutableTreeNode srcNode = this.findNode(whatID);
        DefaultMutableTreeNode destNode = this.findNode(whereID);
        if (srcNode == null || destNode == null) {
            return;
        }
        this.treeModel.removeNodeFromParent(srcNode);
        this.treeModel.insertNodeInto(srcNode, destNode, destNode.getChildCount());
        this.mTree.expandPath(this.findPath(whereID));
    }

    public void deleteNode(String id) {
        DefaultMutableTreeNode deleteNode = this.findNode(id);
        if (deleteNode == null) {
            return;
        }
        this.treeModel.removeNodeFromParent(deleteNode);
    }

    public JPanel getMainPane() {
        return this.mainPane;
    }

    private boolean setRoot(DefaultMutableTreeNode newNode) {
        if (this.equals(this.root, newNode)) {
            return false;
        }
        this.root = newNode;
        return true;
    }

    private boolean equals(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        String nodeID1 = this.getNodeID(node1);
        String nodeID2 = this.getNodeID(node2);
        if (nodeID1 == null) {
            return nodeID2 == null;
        }
        if (!nodeID1.equals(nodeID2)) {
            return false;
        }
        int count = node1.getChildCount();
        if (node2.getChildCount() != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (this.equals((DefaultMutableTreeNode)node1.getChildAt(i), (DefaultMutableTreeNode)node2.getChildAt(i))) continue;
            return false;
        }
        return true;
    }

    private DefaultMutableTreeNode setTreeNode() {
        Report report = this.reportMain.report;
        if (report == null) {
            return null;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("report");
        TreeNode[] path = new DefaultMutableTreeNode[]{rootNode};
        try {
            rootNode.add(this.getSectionNode(report.getReportHeader(), path));
            rootNode.add(this.getSectionNode(report.getPageHeader(), path));
            ReportTable table = report.getReportTables().elementAt(0);
            rootNode.add(this.getSectionNode(table.getHeader(), path));
            if (table instanceof ReportMultiSectionTable) {
                int i;
                ReportMultiSectionTable mTbl = (ReportMultiSectionTable)table;
                for (i = 0; i < mTbl.countRowBreakHeader(); ++i) {
                    rootNode.add(this.getSectionNode(mTbl.getRowBreakHeader(i), path));
                }
                rootNode.add(this.getTableNode(mTbl, path));
                for (i = mTbl.countRowBreakFooter() - 1; i >= 0; --i) {
                    rootNode.add(this.getSectionNode(mTbl.getRowBreakFooter(i), path));
                }
            } else {
                rootNode.add(this.getTableNode(table, path));
            }
            rootNode.add(this.getSectionNode(table.getFooter(), path));
            rootNode.add(this.getSectionNode(report.getPageFooter(), path));
            rootNode.add(this.getSectionNode(report.getReportFooter(), path));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to set tree node", ex);
        }
        return rootNode;
    }

    private DefaultMutableTreeNode getTableNode(ReportTable table, TreeNode[] path) throws Exception {
        ReportColumn[] inelts;
        ReportElement[] elts;
        DefaultMutableTreeNode tblNode = new DefaultMutableTreeNode(table);
        Object[] newPath = path;
        if (this.reportMain.currentScript != null && table.scriptReferenced(this.reportMain.currentScript, true)) {
            newPath = new DefaultMutableTreeNode[path.length + 1];
            for (int i = 0; i < path.length; ++i) {
                newPath[i] = path[i];
            }
            newPath[path.length] = tblNode;
            this.expandTreePath.addElement(new TreePath(newPath));
        }
        for (ReportElement elt : elts = table.getXSortedVisibleElements()) {
            if (this.skip(elt)) continue;
            if (elt instanceof ReportSection) {
                tblNode.add(this.getSectionNode((ReportSection)elt, (TreeNode[])newPath));
                continue;
            }
            tblNode.add(new DefaultMutableTreeNode(elt));
        }
        for (ReportColumn inelt : inelts = table.getInvisibleColumnList()) {
            tblNode.add(new DefaultMutableTreeNode(inelt));
        }
        return tblNode;
    }

    private DefaultMutableTreeNode getSectionNode(ReportSection section, TreeNode[] path) throws Exception {
        ReportCell[] cells;
        int i;
        DefaultMutableTreeNode secNode = new DefaultMutableTreeNode(section);
        Object[] newPath = path;
        if (section.scriptReferenced(this.reportMain.currentScript)) {
            newPath = new DefaultMutableTreeNode[path.length + 1];
            for (i = 0; i < path.length; ++i) {
                newPath[i] = path[i];
            }
            newPath[path.length] = secNode;
            this.expandTreePath.addElement(new TreePath(newPath));
        }
        for (i = 0; i < section.getSectionCount(); ++i) {
            secNode.add(this.getSectionNode(section.getSection(i), (TreeNode[])newPath));
        }
        for (ReportCell cell : cells = section.getCells()) {
            if (this.skip(cell)) continue;
            secNode.add(new DefaultMutableTreeNode(cell));
        }
        return secNode;
    }

    public void insertIntoNode(ReportElement where, ReportElement what) {
        DefaultMutableTreeNode secNode = this.findNode(where.getID());
        this.treeModel.insertNodeInto(new DefaultMutableTreeNode(what), secNode, secNode.getChildCount());
        this.mTree.expandPath(this.findPath(where.getID()));
    }

    private boolean skip(ReportElement elt) {
        if (elt instanceof ColumnWrap) {
            return true;
        }
        if (elt instanceof GuideLine) {
            return true;
        }
        if (elt instanceof ReportLine && ((ReportLine)elt).previous() != null) {
            return true;
        }
        return elt instanceof ReportGrid && ((ReportGrid)elt).previous() != null;
    }

    private String getNodeID(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof String) {
            return (String)node.getUserObject();
        }
        if (this.getReportElement(node) == null) {
            return null;
        }
        return this.getReportElement(node).getID();
    }

    private ReportElement getReportElement(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof ReportElement) {
            ReportElement elt = (ReportElement)node.getUserObject();
            if (this.reportMain.isSecureMode() && elt.isSecurityLevelDefined()) {
                return null;
            }
            return elt;
        }
        return null;
    }

    private ReportElementPanel getPanel(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof ReportTableElement && !ReportElementPanel.masterSection((ReportElement)node.getUserObject())) {
            return this.reportMain.designPanel.rulerPanel.getPanel((ReportTableElement)node.getUserObject());
        }
        return this.getPanel((DefaultMutableTreeNode)node.getParent());
    }

    static boolean isVisible(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof String) {
            return true;
        }
        if (node.getUserObject() instanceof ReportElement && !((ReportElement)node.getUserObject()).isVisible()) {
            return false;
        }
        if (node.getUserObject() instanceof ReportTableElement) {
            return ((ReportElement)node.getUserObject()).isVisible();
        }
        return ReportExplorer.isVisible((DefaultMutableTreeNode)node.getParent());
    }

    public DefaultMutableTreeNode[] getSelectedNodes() {
        DefaultMutableTreeNode[] currentNode = null;
        if (!this.mTree.isSelectionEmpty()) {
            TreePath[] currentPath = this.mTree.getSelectionPaths();
            currentNode = new DefaultMutableTreeNode[currentPath.length];
            for (int i = 0; i < currentPath.length; ++i) {
                currentNode[i] = (DefaultMutableTreeNode)currentPath[i].getLastPathComponent();
            }
        }
        return currentNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.mTree.expandPath(e.getNewLeadSelectionPath());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.reportMain.setExplorerVisible(false);
    }
}

