/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import quadbase.chart.designer.ChartToolbar;
import quadbase.chart.designer.IChartIO;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.param.Param;
import quadbase.common.param.ParamUtil;
import quadbase.common.paramquery.EnterParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.CustomizeElement;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.QbBrowseDirectories;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.RecentFiles;
import quadbase.datasourcemanager.manager.DataSourceManagerListener;
import quadbase.datasourcemanager.manager.IChangeDataRegistry;
import quadbase.datasourcemanager.manager.IChangeDataRegistryPlus;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.reportdesigner.PageViewer.swing.Viewer;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.CrossTabReportSection;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.ReportViewer.swing.ReportCanvas;
import quadbase.reportdesigner.designer.ApplyTemplateDialog;
import quadbase.reportdesigner.designer.BackgroundImageDialog;
import quadbase.reportdesigner.designer.ChartEditor;
import quadbase.reportdesigner.designer.ChartParameterMappingDialog;
import quadbase.reportdesigner.designer.ColInfoFrame;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ColumnFieldDialog;
import quadbase.reportdesigner.designer.ColumnHeaderDialog;
import quadbase.reportdesigner.designer.ColumnPropertiesDialog;
import quadbase.reportdesigner.designer.ColumnWrapDialog;
import quadbase.reportdesigner.designer.CrossTabDrillDownDialog;
import quadbase.reportdesigner.designer.DataSourceInfoFrame;
import quadbase.reportdesigner.designer.DatabaseFieldDialog;
import quadbase.reportdesigner.designer.DesignPanel;
import quadbase.reportdesigner.designer.DrillDownNavigationFrame;
import quadbase.reportdesigner.designer.DualColorsDialog;
import quadbase.reportdesigner.designer.EditPanel;
import quadbase.reportdesigner.designer.FontMappingDialog;
import quadbase.reportdesigner.designer.FormatDialog;
import quadbase.reportdesigner.designer.FormulaDialog;
import quadbase.reportdesigner.designer.GridLine;
import quadbase.reportdesigner.designer.HTMLTableBorderDialog;
import quadbase.reportdesigner.designer.HeightDialog;
import quadbase.reportdesigner.designer.HyperLinkDialog;
import quadbase.reportdesigner.designer.IByPassSaveAsForReport;
import quadbase.reportdesigner.designer.IChartHandle;
import quadbase.reportdesigner.designer.IDrillDownReportIO;
import quadbase.reportdesigner.designer.IReportIO;
import quadbase.reportdesigner.designer.IReportNavigationIO;
import quadbase.reportdesigner.designer.ImageOptionDialog;
import quadbase.reportdesigner.designer.InsertChartDialog;
import quadbase.reportdesigner.designer.LineDialog;
import quadbase.reportdesigner.designer.LogoDialog;
import quadbase.reportdesigner.designer.LogoWindow;
import quadbase.reportdesigner.designer.MasterSectionDialog;
import quadbase.reportdesigner.designer.NewEditDialog;
import quadbase.reportdesigner.designer.NullDataHandler;
import quadbase.reportdesigner.designer.PageSetupDialog;
import quadbase.reportdesigner.designer.ParameterShareDialog;
import quadbase.reportdesigner.designer.ParameterValueDialog;
import quadbase.reportdesigner.designer.PreviewDataOptionDialog;
import quadbase.reportdesigner.designer.PreviewPanel;
import quadbase.reportdesigner.designer.PrintOnNewPageDialog;
import quadbase.reportdesigner.designer.QbReportDesigner;
import quadbase.reportdesigner.designer.RTFEditorDialog;
import quadbase.reportdesigner.designer.RecordFrame;
import quadbase.reportdesigner.designer.ReportClient;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportExplorer;
import quadbase.reportdesigner.designer.ReportMenuBar;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.designer.RotationDialog;
import quadbase.reportdesigner.designer.SaveDialog;
import quadbase.reportdesigner.designer.ScriptDialog;
import quadbase.reportdesigner.designer.SecurityDialog;
import quadbase.reportdesigner.designer.SecurityQueryParameterDialog;
import quadbase.reportdesigner.designer.ServerPortDialog;
import quadbase.reportdesigner.designer.SetBorderDialog;
import quadbase.reportdesigner.designer.SetBoundsDialog;
import quadbase.reportdesigner.designer.SetCustomIDDialog;
import quadbase.reportdesigner.designer.SetFontDialog;
import quadbase.reportdesigner.designer.SetHTMLPageTitleDialog;
import quadbase.reportdesigner.designer.SetStyleClassNameDialog;
import quadbase.reportdesigner.designer.SnapToGridDialog;
import quadbase.reportdesigner.designer.SubReportParameterDialog;
import quadbase.reportdesigner.designer.TOCWizardStep1;
import quadbase.reportdesigner.designer.TOCWizardStep2;
import quadbase.reportdesigner.designer.UpdateDataSourceWizard;
import quadbase.reportdesigner.designer.UpdateDatabaseWizard;
import quadbase.reportdesigner.designer.UpdateQueryWizard;
import quadbase.reportdesigner.designer.ViewerFontSetupDialog;
import quadbase.reportdesigner.designer.ZIndexDialog;
import quadbase.reportdesigner.designer.elementformat.ElementFormatDialog;
import quadbase.reportdesigner.designer.globalformat.ExportGlobalFormat;
import quadbase.reportdesigner.designer.globalformat.GlobalFormatDialog;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.designer.groupformat.GroupFormatDialog;
import quadbase.reportdesigner.designer.groupformat.SetWholeGroupDataFormat;
import quadbase.reportdesigner.report.CleanUpThread;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.LoadReportStyle;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.PageReport;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.SaveReportStyle;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IDBProvider;
import quadbase.reportdesigner.util.IReportMain;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class ReportMain
extends JFrame
implements WindowListener,
ChangeListener,
KeyListener,
IReportMain {
    private static final Logger LOGGER = Logger.getLogger(ReportMain.class.getName());
    public static final String BACKGROUND_IMG = "backgroundImages/";
    public Report report;
    private FileInMemTable subFilesTable = new FileInMemTable();
    private final Vector<Report> undoReportList = new Vector();
    private final Vector<Report> redoReportList = new Vector();
    private Report reportBackup;
    private final Vector<Boolean> undoRetrieveDataList = new Vector();
    private final Vector<Boolean> redoRetrieveDataList = new Vector();
    private boolean forceRetrieveData = true;
    protected ReportWizard wizard;
    private String title = SaveReport.VERSIONNAME;
    String wait = LanguageEncoder.getText("Please Wait...");
    private boolean isModified = false;
    private boolean updateReport = false;
    private boolean isUpdating = false;
    boolean isUndoEnabled = false;
    public boolean isCm = false;
    public boolean isShiftSelected = false;
    public boolean isMetric = false;
    public boolean isTOCEnabled = true;
    public boolean isDrawBoundingBoxOp = false;
    boolean insertLine = false;
    boolean isVerticalLine = false;
    boolean insertGuideLine = false;
    boolean isVerticalGuideLine = false;
    boolean insertGrid = false;
    boolean isPasteOp = false;
    private LogoWindow logoWindow;
    private boolean saveWithNoData = false;
    UIManager.LookAndFeelInfo[] lookAndFeel = null;
    JTabbedPane reportDesignerPane;
    public ReportMenuBar menuBar;
    public PreviewPanel previewPanel;
    public DesignPanel designPanel;
    public ReportExplorer explorer;
    EditPanel editPanel;
    Cursor currentCursor;
    ReportElement selectedObject;
    ReportElementPanel selectedPanel;
    boolean isForBean = false;
    boolean insertLabel = false;
    boolean insertFormula = false;
    boolean insertDatabaseField = false;
    boolean insertChart = false;
    boolean insertImage = false;
    boolean insertBoundingBox = false;
    boolean insertSubReport = false;
    boolean insertTOC = false;
    boolean insertRichTextField = false;
    boolean insertColumnHeader = false;
    public boolean isDesignMode = true;
    boolean bringChartEditorToFront = false;
    private MasterSectionDialog masterSectionDialog = null;
    String defaultFormula = "STR(\"New Formula\")";
    int defaultType = 12;
    Formula selectedFormula = null;
    Script selectedScript = null;
    String[] selectedDatabaseField = null;
    String selectedDatabaseFieldAggr = null;
    short selectedColumnAggrIndex = (short)-1;
    RecordFrame recordFrame = null;
    ColInfoFrame colInfoFrame = null;
    DataSourceInfoFrame dataSourceInfoFrame = null;
    Object chartEditor;
    public static final int SET_BG_COLOR = 1;
    public static final int SET_FONT_COLOR = 2;
    public static final int SET_BORDER_COLOR = 3;
    public static final int SET_DUAL_COLOR = 4;
    public static final int SET_FONT_NO_COLOR = 5;
    private JTree drillDownTree = null;
    private JTree old_drillDownTree = null;
    protected DrillDownNavigationFrame drillDownNavigationFrame = null;
    private int currentReportIndex = 0;
    protected Vector<SubReportObject> subReports = new Vector();
    private IReportIO reportIO = null;
    private IDrillDownReportIO drillDownReportIO = null;
    private IChartHandle chartHandle = null;
    private IByPassSaveAsForReport byPassSaveAs = null;
    private DBInfoBasic presetDBInfo = null;
    private String presetClassFile = null;
    private Manager presetManager = null;
    private QueryInParamSet presetQueryInParamSet = null;
    private String presetDataRegistry = null;
    private BrowseDirectories browseDir;
    private Vector<String> dataRegHiddenNodes = null;
    public int displayRow = -1;
    public int displayRowState = 0;
    public final int DISPLAY_ROW_INIT = 0;
    public final int DISPLAY_ROW_CHANGED = 1;
    public final int DISPLAY_ROW_APPLIED = 2;
    public boolean useLiveData = false;
    public boolean firstTimePreview = true;
    private boolean isSaveOnExit = true;
    private IDBProvider dbProvider = null;
    private boolean forceNewReport = false;
    public static final String separator = "/";
    private String securityLevel = null;
    private boolean allowCrosstabElementMove = false;
    private boolean enableToc = true;
    private String[] defaultParamNames = null;
    private boolean defaultValueRequiredForParameters = false;
    private boolean skipQueryResultStep = false;
    private boolean skipMultiDataSourceStep = false;
    private boolean skipPredefinedTemplatesStep = false;
    boolean updateYRuler = false;
    private Vector<DataSourceManagerListener> managerListeners = null;
    Vector<Integer> chartMenuItem_menu;
    Vector<Integer> chartMenuItem_item;
    Vector<Boolean> chartMenuItem_enabled;
    Vector<Integer> chartMenu_menu;
    Vector<Boolean> chartMenu_enabled;
    Vector<Integer> chartToolbarItem_item;
    Vector<Boolean> chartToolbarItem_enabled;
    boolean disableChartDataSource = false;
    IChartIO chartIO;
    Vector<Color> recentColors = new Vector();
    private ReportElement copiedElement;
    JFrame pageViewer = null;
    quadbase.reportdesigner.PageViewer.swing.ReportCanvas pageViewerCanvas = null;
    DatabaseFieldDialog dbFieldDialog = null;
    boolean saveAllData;
    boolean isExplorerVisible = true;
    boolean openSubReport = false;
    boolean removeSubReport = false;
    boolean printing = false;
    private boolean sysExitOnExit = true;
    QbReportDesigner qbReportDesigner = null;
    private String loginUser;
    private boolean wasPreviewPanel = false;
    private int prevSelectedPanel;
    private boolean prevPasteEnabled = false;
    private String qLogo = ServerMessage.reportImagesPath + "QuadLogo.png";
    static final String saveRptBeforeOpeningExistingReport = LanguageEncoder.getText("Do you want to save the current report?");
    static String saveRptBeforeDrill = LanguageEncoder.getText("Current Report must be saved before inserting a drill-down report. Continue?");
    static String saveRptBeforeSub = LanguageEncoder.getText("Current Report must be saved before inserting a sub-report. Continue?");
    static final String SAVE_RPT_BEFORE_INSERTING_CHART = LanguageEncoder.getText("Current Report must be saved before inserting a chart. Continue?");
    static final String SAVE_RPT_BEFORE_EDIT_TPL = LanguageEncoder.getText("Current Report must be saved before editing a chart and the qrp file may not be able to open in quickdesigner again.  Continue?");
    static String saveRptBeforePage = LanguageEncoder.getText("Current Report must be saved before launching in PageViewer. Continue?");
    public String relativeDomainPath = "";
    public Script currentScript;
    public ScriptDialog scriptDialog;
    public boolean showWarningDialog = true;
    public static Vector<String> hideReportMenuItems = null;
    protected boolean isReportOpenedInPakFormat = false;
    private String reportMainTitle = null;
    String reportFileName = null;

    public ReportMain() {
        this(true);
    }

    public ReportMain(boolean showLogo) {
        ServerMessage.setFrame(this);
        this.setDefaultCloseOperation(0);
        this.initialize(showLogo);
    }

    public ReportMain(boolean showLogo, String filename, String enc) {
        if (filename != null && enc != null) {
            try {
                if (!ServerMessage.useServer) {
                    LanguageEncoder.load(filename, enc);
                } else {
                    LanguageEncoder.loadFromServer(filename, enc);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load file", e);
            }
        }
        this.reportFileName = filename;
        ServerMessage.setFrame(this);
        this.setDefaultCloseOperation(0);
        this.initialize(showLogo);
    }

    public void setQbReportDesigner(QbReportDesigner qbDesigner) {
        this.qbReportDesigner = qbDesigner;
    }

    public String getReportFile() {
        if (this.title.equals(SaveReport.VERSIONNAME)) {
            return null;
        }
        return this.title;
    }

    public void addRecentColor(Color newColor) {
        if (!this.recentColors.contains(newColor)) {
            this.recentColors.insertElementAt(newColor, 0);
        }
    }

    public Vector<Color> getRecentColors() {
        return this.recentColors;
    }

    public void setRecentColors(Vector<Color> colors) {
        this.recentColors = colors;
    }

    public Color[] getRecentColorArray() {
        Color[] colors = new Color[this.recentColors.size()];
        for (int i = 0; i < this.recentColors.size(); ++i) {
            colors[i] = this.recentColors.elementAt(i);
        }
        return colors;
    }

    public boolean isChangeDataRegistryEnabled() {
        return false;
    }

    public IChangeDataRegistry getChangeDataRegObj() {
        return null;
    }

    public IChangeDataRegistry getChangeDataRegObj(ChartEditor ce) {
        return null;
    }

    public IChangeDataRegistryPlus getChangeDataRegPlusObj() {
        return null;
    }

    public boolean canModify() {
        return true;
    }

    private void initialize(boolean showLogo) {
        try {
            QbUtil.pixelPerInchExport = ServerMessage.getDefaultHtmlDpi();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to get deafult DPI value, using -1", e);
            QbUtil.pixelPerInchExport = -1;
        }
        this.isCm = ReportClient.isMetricSystem;
        CustomizeElement.load();
        this.qLogo = CustomizeElement.getCustomData("[ERES Organizer][Images][Report Designer Frame Icon]", ServerMessage.reportImagesPath + "QuadLogo.png");
        SaveReport.VERSIONNAME = CustomizeElement.getCustomData("[ERES Organizer][Text][Report Designer Title]", SaveReport.VERSIONNAME).replaceAll(":Version", ServerMessage.getProductVersion());
        if (ServerMessage.getFrame() == null) {
            ServerMessage.setFrame(this);
        }
        this.isUpdating = true;
        if (showLogo) {
            this.logoWindow = new LogoWindow(this);
            this.logoWindow.start();
        }
        this.setTitle(this.title);
        this.setIconImage(IOUtil.getImage(this.qLogo));
        this.lookAndFeel = UIManager.getInstalledLookAndFeels();
        this.getRootPane().setJMenuBar(this.getReportMenuBar());
        this.setContentPane(this.getJFrameContentPane());
        this.isModified = false;
        this.setPosition();
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.isUpdating = false;
        this.browseDir = new QbBrowseDirectories();
        this.doHideReportMenuItems();
    }

    void resetLogoWindow() {
        this.logoWindow = null;
    }

    private void reset_displayRow() {
        this.displayRow = -1;
        this.displayRowState = 0;
    }

    void reset_displayOptions() {
        this.useLiveData = false;
        this.firstTimePreview = true;
        this.reset_displayRow();
    }

    private void doHideReportMenuItems() {
        if (hideReportMenuItems == null || hideReportMenuItems.size() == 0) {
            return;
        }
        for (int i = 0; i < hideReportMenuItems.size(); ++i) {
            StringTokenizer st = new StringTokenizer(hideReportMenuItems.get(i), ",");
            try {
                if (st.countTokens() <= 0) continue;
                int menuIndex = Integer.parseInt(st.nextToken().trim());
                int submenuIndex = Integer.parseInt(st.nextToken().trim());
                JMenu menu = this.getReportMenuBar().getMenu(menuIndex);
                menu.remove(submenuIndex);
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Failed to hide menu items", e);
            }
        }
    }

    private JPanel getJFrameContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setName("JFrameContentPane");
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.getDesignerPane(), "Center");
        contentPane.add((Component)this.getStatusPane(), "South");
        return contentPane;
    }

    ReportMenuBar getReportMenuBar() {
        if (this.menuBar != null) {
            return this.menuBar;
        }
        this.menuBar = new ReportMenuBar(this);
        if (!ServerMessage.useServer || this.isFromOrganizer()) {
            this.updateFileMenu();
        }
        this.menuBar.setMenuEnabled(false);
        return this.menuBar;
    }

    private JTabbedPane getExistingDesignerPane() {
        if (this.reportDesignerPane != null) {
            return this.reportDesignerPane;
        }
        return this.getDesignerPane();
    }

    private JTabbedPane getDesignerPane() {
        this.reportDesignerPane = new JTabbedPane();
        this.reportDesignerPane.insertTab(LanguageEncoder.getText("Design"), null, this.getDesignPanel(), null, 0);
        this.reportDesignerPane.insertTab(LanguageEncoder.getText("Preview"), null, this.getPreviewPanel(), null, 1);
        this.reportDesignerPane.addChangeListener(this);
        return this.reportDesignerPane;
    }

    boolean isExplorerVisible() {
        return this.isExplorerVisible;
    }

    void setExplorerVisible(boolean b) {
        if (this.isExplorerVisible == b) {
            return;
        }
        this.isExplorerVisible = b;
        this.explorer.getMainPane().setVisible(b);
        this.getReportMenuBar().setExplorerItemState(b);
        if (this.designPanel != null) {
            this.designPanel.updatePanel();
        }
    }

    public void updateReportExplorer() {
        if (this.explorer != null && this.isExplorerVisible) {
            this.explorer.updateReportExplorer(this);
        }
    }

    DesignPanel getDesignPanel() {
        if (this.designPanel != null) {
            return this.designPanel;
        }
        this.designPanel = new DesignPanel(this);
        return this.designPanel;
    }

    PreviewPanel getPreviewPanel() {
        if (this.previewPanel != null) {
            return this.previewPanel;
        }
        this.previewPanel = new PreviewPanel(this);
        return this.previewPanel;
    }

    EditPanel getEditPanel() {
        this.editPanel = new EditPanel();
        return this.editPanel;
    }

    private JPanel getStatusPane() {
        return new JPanel();
    }

    protected void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.8);
        dim.width = (int)((double)screenSize.width * 0.95);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    void setReportIO(IReportIO rptIO) {
        this.reportIO = rptIO;
    }

    void setByPassSaveAs(IByPassSaveAsForReport byPass) {
        this.byPassSaveAs = byPass;
    }

    void setDrillDownReportIO(IDrillDownReportIO rptIO) {
        this.drillDownReportIO = rptIO;
    }

    void setChartHandle(IChartHandle chtHandle) {
        this.chartHandle = chtHandle;
    }

    IChartHandle getChartHandle() {
        return this.chartHandle;
    }

    void setPresetDBInfo(DBInfoBasic dbInfo) {
        this.presetDBInfo = dbInfo;
    }

    DBInfoBasic getPresetDBInfo() {
        return this.presetDBInfo;
    }

    void setPresetClassFile(String classFile) {
        this.presetClassFile = classFile;
    }

    String getPresetClassFile() {
        return this.presetClassFile;
    }

    public void setPresetManager(Manager manager) {
        this.presetManager = manager;
    }

    public Manager getPresetManager() {
        return this.presetManager;
    }

    void setPresetQueryInParamSet(QueryInParamSet inSet) {
        this.presetQueryInParamSet = inSet;
    }

    QueryInParamSet getPresetQueryInParamSet() {
        return this.presetQueryInParamSet;
    }

    public void setPresetDataRegistry(String dataReg) {
        this.presetDataRegistry = dataReg;
    }

    public String getPresetDataRegistry() {
        return this.presetDataRegistry;
    }

    public BrowseDirectories getBrowseDirectories() {
        return this.browseDir;
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.browseDir = dir;
    }

    public void setDataRegistryHiddenNodes(Vector<String> vec) {
        this.dataRegHiddenNodes = vec;
    }

    public Vector<String> getDataRegistryHiddenNodes() {
        return this.dataRegHiddenNodes;
    }

    void setDisplayRow(int nRow) {
        this.displayRow = nRow;
    }

    int getDisplayRow() {
        return this.displayRow;
    }

    public void setModified() {
        this.setModified(true);
        this.setUpdateReport(true);
    }

    public void setModified(boolean mod) {
        this.isModified = mod;
        if (this.isModified) {
            this.saveBackupReportToUndoList();
            this.enableUndoRedoButtons();
        } else {
            this.clearUndoRedoList();
        }
    }

    public boolean isModified() {
        return this.report == null ? false : this.isModified;
    }

    @Override
    public void setUpdateReport() {
        this.setUpdateReport(true);
    }

    public void setUpdateReport(boolean upd) {
        this.updateReport = upd;
    }

    boolean isUpdateReport() {
        return this.updateReport;
    }

    boolean hasBean() {
        return this.isForBean;
    }

    boolean isUpdating() {
        return this.isUpdating;
    }

    public void setReport(Report rpt) {
        this.setReport(rpt, true);
    }

    void setReport(Report rpt, boolean updateMenu) {
        this.setReport(rpt, updateMenu, true);
    }

    void setReport(Report rpt, boolean updateMenu, boolean createNewExplorer) {
        this.report = rpt;
        if (this.report != null) {
            if (this.securityLevel != null) {
                this.report.setPreviewSecurityLevel(this.securityLevel);
            }
            this.setNullDataOption(this.report.getNullDataOption());
            this.subFilesTable = this.report.getSubFilesTable();
        }
        this.updatePanel(createNewExplorer);
        if (updateMenu) {
            if (this.currentReportIndex == 0) {
                this.menuBar.setMenuEnabled(rpt != null);
            } else {
                this.menuBar.setMenuForSubReport();
            }
        }
        if (this.isPreviewWindow()) {
            this.menuBar.setMenuForPreview();
        }
        if (updateMenu) {
            try {
                this.designPanel.designToolBar.setEnabled(rpt != null);
                this.designPanel.designToolBar2.setEnabled(rpt != null);
                this.previewPanel.previewToolBar.setEnabled(rpt != null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to update menu", ex);
            }
            if (rpt != null) {
                this.menuBar.prevParamPrompt.setSelected(rpt.isPrevParamPrompt);
            }
        }
        if (this.report != null && this.report.isCrossTab()) {
            this.menuBar.allowCrosstabElementMove.setEnabled(true);
        } else {
            this.menuBar.allowCrosstabElementMove.setEnabled(false);
        }
        if (this.report != null) {
            this.menuBar.showCellOutline.setSelected(this.report.showCellOutline);
        }
    }

    void setSubReport(Report rpt, SubReportObject holder) {
        String oldFile = this.getFileName();
        rpt.parentNode = this.report.currentNode;
        rpt.currentNode.setFileName(holder.getFileName());
        SubReportObject cell = new SubReportObject();
        cell.copy(holder);
        if (this.subReports == null) {
            this.subReports = new Vector();
        }
        this.subReports.addElement(cell);
        this.report.subReports = this.subReports;
        SaveReport saveReport = new SaveReport(rpt);
        saveReport.setSaveNoData(this.saveWithNoData);
        saveReport.setSubFilesTable(this.subFilesTable);
        boolean isPAK = this.isReportOpenedInPakFormat();
        String fileName = isPAK ? SaveReport.getPakFileName(cell.getFileName()) : cell.getFileName();
        try {
            saveReport.saveToOutput(this.getPath(fileName), !isPAK, isPAK);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save sub-report.", e);
        }
        this.save(this.isReportOpenedInPakFormat());
        boolean temp = this.openSubReport;
        this.openSubReport = true;
        this.close();
        this.openSubReport = temp;
        if (this.drillDownNavigationFrame != null) {
            this.drillDownNavigationFrame.setVisible(false);
            this.drillDownNavigationFrame.dispose();
        }
        JTabbedPane tabbed = this.getExistingDesignerPane();
        int tabcount = tabbed.getTabCount();
        tabbed.removeTabAt(tabcount - 1);
        this.designPanel = new DesignPanel(this);
        int newSRIndex = 1;
        for (int i = 1; i < tabcount - 1; ++i) {
            String tabTitle = tabbed.getTitleAt(i);
            if (!tabTitle.startsWith(LanguageEncoder.getText("Sub-Report_"))) continue;
            try {
                Integer srCount = Integer.valueOf(tabTitle.substring(11));
                if (srCount < newSRIndex) continue;
                newSRIndex = srCount + 1;
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to set new SRI index", ex);
            }
        }
        tabbed.insertTab(LanguageEncoder.getText("Sub-Report_") + newSRIndex, null, this.designPanel, null, tabcount - 1);
        tabbed.insertTab(LanguageEncoder.getText("Preview"), null, this.getPreviewPanel(), null, tabcount);
        if (this.report != null) {
            this.setNullDataOption(this.report.getNullDataOption());
        }
        this.report = rpt;
        this.old_drillDownTree = this.drillDownTree;
        this.setDrillDownTree(new JTree(this.report.currentNode));
        this.currentReportIndex = tabcount - 1;
        this.menuBar.setMenuForSubReport();
        this.designPanel.designToolBar.setToolbarForSubReport();
        this.setFileName(oldFile);
        this.report.currentNode.setFileName(holder.getFileName());
        SaveReport.copyChildNodes(this.report.currentNode, this.relativeDomainPath, this);
        SaveReport.resaveChildNodes(this.report.currentNode, this.relativeDomainPath, this);
        this.save();
        tabbed.setSelectedIndex(tabcount - 1);
        this.setUpdateReport();
        this.updatePanel();
        this.checkDataSource();
        this.setInsertSubReport(false);
    }

    @Override
    public void updatePanel() {
        this.updatePanel(true);
    }

    public void updatePanel(boolean createNewExplorer) {
        this.isUpdating = true;
        int horizontalScrollValue = this.designPanel.rulerPanel.getHorizontalScrollBar().getValue();
        int verticalScrollValue = this.designPanel.rulerPanel.getVerticalScrollBar().getValue();
        this.designPanel.updatePanel(createNewExplorer);
        if (this.masterSectionDialog != null) {
            this.masterSectionDialog.updatePanel();
        }
        boolean oldvalue = this.isUpdateReport();
        this.setUpdateReport(true);
        if (this.reportDesignerPane.getSelectedIndex() != this.reportDesignerPane.getTabCount() - 1) {
            if (!oldvalue) {
                this.designPanel.updatePanel(createNewExplorer);
            }
        } else {
            this.previewPanel.updatePanel();
        }
        this.setUpdateReport(true);
        this.validate();
        this.repaint();
        this.designPanel.rulerPanel.getHorizontalScrollBar().setValue(horizontalScrollValue);
        this.designPanel.rulerPanel.getVerticalScrollBar().setValue(verticalScrollValue);
        this.isUpdating = false;
    }

    void updateDesignPanelUI() {
        if (this.isUpdateReport()) {
            this.updatePanel();
        } else {
            this.setUpdateReport();
            this.isUpdating = true;
            this.designPanel.updatePanel();
            this.setUpdateReport(false);
            this.validate();
            this.repaint();
            this.isUpdating = false;
        }
    }

    public void newFile() {
        this.reportFileName = null;
        this.setItemName(null);
        try {
            this.reset_displayOptions();
            this.menuBar.setDefaultOptions();
            boolean closed = this.closeReportCompletely();
            if (!closed) {
                return;
            }
            if (this.drillDownNavigationFrame != null) {
                this.drillDownNavigationFrame.setVisible(false);
                this.drillDownNavigationFrame.dispose();
            }
            this.clearUndoRedoList();
            this.setReportOpenedInPakFormat(false);
            if (this.presetDBInfo != null) {
                this.wizard = new ReportWizard(this, this.presetDBInfo, this.presetQueryInParamSet, true, false);
                this.wizard.setVisible(true);
            } else if (this.presetClassFile != null) {
                this.wizard = new ReportWizard(this, this, null, this.presetClassFile, this.presetQueryInParamSet, null, true, false, true, LanguageEncoder.getText("Report Wizard"), null);
                this.wizard.setVisible(true);
            } else if (this.presetManager != null) {
                this.wizard = new ReportWizard(this, this.presetDBInfo, this.presetQueryInParamSet, this.presetManager, false, false, true);
            } else {
                this.wizard = new ReportWizard(this);
                this.wizard.init();
                this.wizard.newReport(false, true, this.wizard.step1);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to perform action - new file", ex);
        }
    }

    boolean openFile() {
        if (this.isModified()) {
            JMessageDialog msgDialog = new JMessageDialog((Frame)this, "Question", saveRptBeforeOpeningExistingReport, 2);
            int response = msgDialog.getResponse();
            if (response == 4) {
                this.saveAs();
            } else {
                this.setModified(false);
            }
        }
        return this.openFile(null);
    }

    protected boolean openFile(String drillDownFile) {
        return this.openFile(drillDownFile, drillDownFile);
    }

    protected boolean openFileFromMemoryTable(String drillDownFile, byte[] data) {
        return this.openFile(drillDownFile, drillDownFile, null, data);
    }

    protected boolean openFile(String drillDownFile, String file) {
        return this.openFile(drillDownFile, file, null, null);
    }

    protected boolean openFile(String drillDownFile, String file, Report parentReport, byte[] data) {
        this.currentCursor = this.getCursor();
        String oldtitle = this.title;
        boolean rememberThisFile = drillDownFile == null && file == null;
        this.reset_displayRow();
        try {
            if (file == null && data == null) {
                this.reset_displayOptions();
                String directory = null;
                directory = this.getTemplatesDirectory();
                directory = directory.replace('\\', '/');
                OpenFileDialog openDialog = new OpenFileDialog(this, LanguageEncoder.getText("Open File..."), null, new String[]{"RPT", "XML", "PAK", "STL", "QRP"}, directory);
                openDialog.setVisible(true);
                if (openDialog.isClosed()) {
                    return false;
                }
                if (openDialog.getSelectedFile() == null) {
                    return false;
                }
                file = openDialog.getSelectedFile();
                this.setTemplatesDirectory(openDialog.getCurrentDirectory());
                this.reportFileName = file;
                this.setItemName(null);
                this.subFilesTable.setFileInMemEnabled(file.toLowerCase().endsWith(".pak"));
                this.setReportOpenedInPakFormat(file.toLowerCase().endsWith(".pak"));
            }
            if (!this.tryClose(drillDownFile)) {
                return false;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Open dialog: action failed", ex);
            try {
                IOUtil.releaseFileLock(file);
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "Failed to release file lock", exc);
            }
            String msg = ex.getMessage();
            this.errorMessage(msg);
            return false;
        }
        try {
            if (file != null && (file.toLowerCase().startsWith("http://") || file.toLowerCase().startsWith("https://"))) {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), "Cannot open URL path file in designer", 6);
                return false;
            }
            return this.loadFile(drillDownFile, file, oldtitle, rememberThisFile, parentReport, data);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to open file", ex);
            String msg = ex.getMessage();
            this.errorMessage(msg);
            return false;
        }
    }

    boolean isSaveItemEnabled() {
        return this.report != null;
    }

    private void setNullDataOption(String option) {
        FormatUtil.setNumericNULLDataValue(option);
        FormatUtil.setDateTimeNULLDataValue(option);
        FormatUtil.setBooleanNULLDataValue(option);
        FormatUtil.setStringNULLDataValue(option);
    }

    public boolean closeReportCompletely() {
        boolean flag1 = this.close(true);
        if (flag1) {
            this.setDrillDownTree(null);
            this.setSubReports(null);
            this.menuBar.showCellOutline.setSelected(false);
            this.menuBar.shift.setSelected(false);
            this.menuBar.formulaName.setSelected(false);
            this.menuBar.prevParamPrompt.setSelected(true);
            this.close(true);
        }
        return flag1;
    }

    boolean close() {
        return this.close(false);
    }

    private boolean close(boolean completely) {
        return this.close(completely, this.isReportOpenedInPakFormat());
    }

    private boolean close(boolean completely, boolean autoSave) {
        this.currentCursor = this.getCursor();
        try {
            if (this.isModified()) {
                if (autoSave) {
                    if (!this.save(true)) {
                        return false;
                    }
                } else {
                    JMessageDialog msgDialog = new JMessageDialog((Frame)this, "Question", LanguageEncoder.getText("Save changes?"), 1);
                    int response = msgDialog.getResponse();
                    if (response == 4) {
                        this.save();
                        if (this.isModified()) {
                            return false;
                        }
                    } else if (response == 7) {
                        return false;
                    }
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (completely && !SaveReport.VERSIONNAME.equals(this.title)) {
                    IOUtil.releaseFileLock(this.title);
                }
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "Cannot release file lock", exc);
            }
            if (this.report != null && this.report.currentNode != null && !this.openSubReport) {
                this.report.currentNode.setSelected(false);
            }
            if (this.report != null) {
                for (ColData element : this.report.colData) {
                    element.cleanup();
                }
            }
            if (this.report != null) {
                this.report.deleteSubReportColDataFiles();
            }
            this.setReport(null);
            ServerMessage.setComponent(null);
            this.closePageViewer();
            this.editPanel.setField("");
            if (this.previewPanel != null) {
                this.previewPanel.updatePanel();
            }
            if (this.masterSectionDialog != null) {
                this.masterSectionDialog = null;
            }
            if (this.wizard != null && this.wizard.manager != null) {
                this.wizard.manager.setVisible(false);
                this.wizard.manager.dispose();
            }
            this.wizard = null;
            new CleanUpThread().start();
            if (this.getFileName() != null) {
                this.setItemName(null);
            }
            this.title = SaveReport.VERSIONNAME;
            this.setTitle(this.title);
            this.setCursor(this.currentCursor);
            return true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to close ReportDesigner", ex);
            this.setCursor(this.currentCursor);
            this.errorMessage(ex);
            return false;
        }
    }

    void applyTemplate() {
        try {
            if (this.report == null) {
                return;
            }
            ApplyTemplateDialog openDialog = new ApplyTemplateDialog(this, LanguageEncoder.getText("Apply Template..."), this.getBrowseDirectories().getApplyTemplateDir(), new String[]{"RPT", "XML", "QRP", "PAK"});
            openDialog.setBrowseDirectories(this.getBrowseDirectories());
            openDialog.setVisible(true);
            if (openDialog.getSelectedFile() == null || openDialog.windowClosed()) {
                return;
            }
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            LoadReport loadReport = new LoadReport(true);
            loadReport.setSubFilesTable(this.subFilesTable);
            loadReport.setCopyEmptySection(openDialog.isEmptySectionApplied());
            this.setReport(loadReport.loadTemplateFromFile(openDialog.getSelectedFile(), openDialog.isFormulaApplied(), this.report));
            this.setCursor(this.currentCursor);
            this.menuBar.setUndoEnabled(true);
            this.report.hGuideLines = null;
            this.report.vGuideLines = null;
            this.designPanel.rulerPanel.yRuler.updateYRuler();
            this.designPanel.rulerPanel.xRuler.updateXRuler();
            this.setModified(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot apply template", ex);
            this.setCursor(this.currentCursor);
            this.errorMessage(ex);
        }
    }

    void setSaveOnExitEnabled(boolean b) {
        this.isSaveOnExit = b;
    }

    boolean isSaveOnExitEnabled() {
        return this.isSaveOnExit;
    }

    public boolean exit() {
        boolean state = false;
        try {
            state = this.softExit();
            if (!this.isFromOrganizer() && state && this.sysExitOnExit) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Exit failed", ex);
        }
        return state;
    }

    public void setSysExitOnExit(boolean state) {
        this.sysExitOnExit = state;
    }

    public boolean sysExitOnExit() {
        return this.sysExitOnExit;
    }

    private static void cleanupTempFilesForURLReport() {
    }

    boolean softExit() throws Exception {
        int response;
        JMessageDialog msgDialog;
        if (this.isModified() && this.isSaveOnExitEnabled()) {
            msgDialog = new JMessageDialog((Frame)this, "Question", LanguageEncoder.getText("Save changes before exit?"), 1);
            response = msgDialog.getResponse();
            if (response == 4) {
                this.saveFromReportDesigner();
                if (this.title.equals(SaveReport.VERSIONNAME)) {
                    this.softExit();
                    return !this.title.equals(SaveReport.VERSIONNAME);
                }
            } else if (response != 5) {
                this.setVisible(true);
                return false;
            }
        } else if (OrgUtil.isReportData(this.title) && this.subFilesTable.isModified() && this.isSaveOnExitEnabled()) {
            msgDialog = new JMessageDialog((Frame)this, "Question", LanguageEncoder.getText("Save changes before exit?"), 1);
            response = msgDialog.getResponse();
            if (response == 4) {
                this.saveToDatabase(null);
                if (this.title.equals(SaveReport.VERSIONNAME)) {
                    this.softExit();
                    return !this.title.equals(SaveReport.VERSIONNAME);
                }
            } else if (response == 7) {
                this.setVisible(true);
                return false;
            }
        }
        if (this.drillDownNavigationFrame != null) {
            this.drillDownNavigationFrame.setVisible(false);
        }
        this.setVisible(false);
        ReportMain.cleanupTempFilesForURLReport();
        if (this.report != null) {
            for (ColData element : this.report.colData) {
                element.cleanup();
            }
        }
        if (!this.isFromOrganizer()) {
            ServerMessage.setComponent(null);
        }
        this.setModified(false);
        this.closeReportCompletely();
        if (this.wizard != null && this.wizard.manager != null) {
            this.wizard.manager.setVisible(false);
            this.wizard.manager.dispose();
        }
        this.wizard = null;
        System.runFinalization();
        System.gc();
        System.runFinalization();
        if (ServerMessage.useServer) {
            ReportMain.removeUser(this.isFromOrganizer(), this.qbReportDesigner != null);
        }
        this.dispose();
        return true;
    }

    @Override
    public boolean isDesignMode() {
        return this.isDesignMode;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public boolean isReportOpenedInPakFormat() {
        return this.isReportOpenedInPakFormat;
    }

    public void setReportOpenedInPakFormat(boolean b) {
        this.isReportOpenedInPakFormat = b;
    }

    void saveFromReportDesigner() {
        if (this.isReportOpenedInPakFormat()) {
            try {
                String tmp = null;
                if (!this.title.equals(SaveReport.VERSIONNAME)) {
                    tmp = this.title;
                    tmp = tmp.substring(0, tmp.length() - 4);
                    if (this.isReportData(this.title)) {
                        this.saveToDatabase(this.getItemName());
                        return;
                    }
                    SaveDialog saveDialog = new SaveDialog(this);
                    saveDialog.setSaveAllData(this.saveAllData);
                    saveDialog.setHTML(false);
                    saveDialog.setSwing(false);
                    saveDialog.setXML(false);
                    saveDialog.setPAK(true);
                    saveDialog.setPageViewer(false);
                    this.saveAs(tmp, saveDialog, false, false);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to initialize Save dialog for PAK", ex);
            }
        } else {
            this.save();
        }
    }

    public void saveRootReportFromMemoryTableIntoFileSystem() throws Exception {
        if (this.subFilesTable != null && this.isReportOpenedInPakFormat) {
            String filename = this.subFilesTable.getTopName();
            LoadReport loadReport = new LoadReport();
            loadReport.setSubFilesTable(this.subFilesTable);
            Report rootReport = loadReport.loadPakReportFromByteArray(filename, this.subFilesTable.get(filename));
            SaveReport saveReport = new SaveReport(rootReport, this.subFilesTable);
            saveReport.setSaveNoData(this.saveWithNoData);
            saveReport.saveToFile(this.subFilesTable.getTopName());
        }
    }

    boolean save() {
        return this.save(null);
    }

    public boolean save(String fileLocation) {
        return this.save(fileLocation, false);
    }

    boolean save(boolean saveToMemoryOnly) {
        return this.save(null, saveToMemoryOnly);
    }

    public boolean save(String fileLocation, boolean saveToMemoryOnly) {
        try {
            SaveReport saveReport;
            Parameter conflictParam;
            try {
                this.deselectGroupOption();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to deselect group option", ex);
            }
            if (this.report == null) {
                return false;
            }
            if (fileLocation != null) {
                fileLocation = this.getPath(fileLocation);
                this.setTitle(fileLocation);
                this.title = fileLocation;
            }
            if (this.title.equals(SaveReport.VERSIONNAME) || this.title.toUpperCase().endsWith(".QRP") || !this.isSaveItemEnabled()) {
                this.saveAs();
                return false;
            }
            if (this.title.toLowerCase().startsWith("http://") || this.title.toLowerCase().startsWith("https://")) {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), "The File cannot save in URL PATH.  Please re-save the chart in file path.", 6);
                this.setModified(false);
                return false;
            }
            if (this.isFileLockOverrided(this.title)) {
                new JMessageDialog((Frame)this, "Question", "The File was overrided by you, you have to reopen the report", 6);
                this.setModified(false);
                return false;
            }
            if (!this.isSubReport() && (conflictParam = new ParamUtil().getShareMapConflict(this.report)) != null) {
                this.setModified(false);
                throw new IllegalArgumentException(LanguageEncoder.getText("The parameter") + " " + conflictParam.getName() + " " + LanguageEncoder.getText("from") + " " + conflictParam.getReportTitle() + " " + LanguageEncoder.getText("is both shared to other parameters and mapped to a field in the main report. This is not allowed, please remove the sharing or mapping and try again."));
            }
            if (this.title.toUpperCase().endsWith(".STL")) {
                this.currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                SaveReportStyle srs = new SaveReportStyle(this.report);
                srs.saveToFile(this.title);
                this.setModified(false);
                this.setCursor(this.currentCursor);
                return false;
            }
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!this.report.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
                saveReport = new SaveReport(this.report, this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                saveReport.setSubFilesTable(this.subFilesTable);
                saveReport.setSaveAllData(this.saveAllData);
                if (this.report.subReports != null && this.report.subReports.size() > 0) {
                    saveReport.setSubReports(this.subReports);
                }
                boolean isPAK = this.isReportOpenedInPakFormat();
                String currentNodeFileName = this.report.currentNode.getFileName();
                if (isPAK && currentNodeFileName != null && SaveReport.isRPTFile(currentNodeFileName)) {
                    this.report.currentNode.setFileName(SaveReport.getPakFileName(currentNodeFileName));
                }
                LOGGER.finest("Save drilldown file:" + this.getPath(this.report.currentNode.getFileName()));
                this.saveToFile(saveReport, this.getPath(this.report.currentNode.getFileName()), isPAK);
                DrillDownNode rootNode = (DrillDownNode)this.drillDownTree.getModel().getRoot();
                this.saveTree(rootNode.getFileName(), rootNode);
            } else if (this.currentReportIndex > 0) {
                saveReport = new SaveReport(this.report, this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                saveReport.setSubFilesTable(this.subFilesTable);
                saveReport.setSaveAllData(this.saveAllData);
                saveReport.setDrillDownNode((DrillDownNode)this.drillDownTree.getModel().getRoot());
                SubReportObject sro = this.subReports.elementAt(this.currentReportIndex - 1);
                if (this.isReportOpenedInPakFormat()) {
                    String fName = this.getPath(SaveReport.getPakFileName(sro.getFileName()));
                    this.saveToFile(saveReport, this.getPath(fName), true);
                    if (this.subFilesTable != null && this.subFilesTable.containsKey(fName)) {
                        sro.setByteArray(this.subFilesTable.get(fName));
                    }
                } else {
                    this.saveToFile(saveReport, this.getPath(sro.getFileName()));
                }
            } else {
                LOGGER.finest("Save main root report ( " + this.report.getFileName() + " )");
                saveReport = new SaveReport(this.report, this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                if (this.subFilesTable.getTopName() == null) {
                    this.subFilesTable.setTopName(this.getFileName());
                }
                saveReport.setSubFilesTable(this.subFilesTable);
                saveReport.setSaveAllData(this.saveAllData);
                saveReport.setSubReports(this.subReports);
                DrillDownNode rootNode = (DrillDownNode)this.drillDownTree.getModel().getRoot();
                if (rootNode.getFileName().equals("")) {
                    rootNode.setFileName(this.title);
                }
                saveReport.setDrillDownNode(rootNode);
                saveReport.setSubFilesTable(this.subFilesTable);
                this.saveToFile(saveReport, this.title, saveToMemoryOnly);
                if (!saveToMemoryOnly) {
                    this.insertFileToReportOrganizer(null, false);
                }
                ReportMain.cleanupTempFilesForURLReport();
            }
            this.setModified(this.isReportOpenedInPakFormat());
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot save report", ex);
            this.setModified(true);
            this.setCursor(this.currentCursor);
            this.errorMessage(ex.toString());
            return false;
        }
        return true;
    }

    private void saveToDatabase(String dbLabel) {
        try {
            try {
                this.deselectGroupOption();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to deselect group option", ex);
            }
            if (this.report == null) {
                return;
            }
            if (this.title == null || !this.isReportData(this.title) || this.title.toUpperCase().endsWith("QRP") || dbLabel != null && this.getItemName() != null && !dbLabel.equals(this.getItemName())) {
                this.title = this.createReportDataName();
                this.setTitle(this.title);
            }
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!this.report.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
                SaveReport saveReport = new SaveReport(this.report, this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                saveReport.generatePAKFile(true);
                saveReport.setSaveAllData(this.saveAllData);
                if (this.report.subReports != null && this.report.subReports.size() > 0) {
                    saveReport.setSubReports(this.subReports);
                }
                LOGGER.finest("Save drilldown file: " + this.getPath(this.report.currentNode.getFileName()));
                this.saveToDatabase(saveReport, this.getPath(this.report.currentNode.getFileName()));
                this.saveTree(((DrillDownNode)this.drillDownTree.getModel().getRoot()).getFileName(), (DrillDownNode)this.drillDownTree.getModel().getRoot());
            } else if (this.currentReportIndex > 0) {
                SaveReport saveReport = new SaveReport(this.report, this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                saveReport.generatePAKFile(true);
                saveReport.setSaveAllData(this.saveAllData);
                saveReport.setDrillDownNode((DrillDownNode)this.drillDownTree.getModel().getRoot());
                SubReportObject sro = this.subReports.elementAt(this.currentReportIndex - 1);
                this.saveToDatabase(saveReport, this.getPath(sro.getFileName()));
            } else {
                LOGGER.finest("Save main root report: " + this.report);
                SaveReport saveReport = new SaveReport(this.report, this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                saveReport.generatePAKFile(true);
                saveReport.setSaveAllData(this.saveAllData);
                saveReport.setSubReports(this.subReports);
                this.subFilesTable.setFileInMemEnabled(true);
                this.setReportOpenedInPakFormat(true);
                this.subFilesTable.setTopName(this.getPath(this.title));
                saveReport.setDrillDownNode((DrillDownNode)this.drillDownTree.getModel().getRoot());
                this.saveToDatabase(saveReport, this.title);
                if (dbLabel != null) {
                    this.setItemName(dbLabel);
                }
                this.insertFileToReportOrganizer(dbLabel, false);
                ReportMain.cleanupTempFilesForURLReport();
            }
            this.setModified(false);
            this.subFilesTable.resetModify();
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Saving to database failed", ex);
            this.setModified(true);
            this.setCursor(this.currentCursor);
            this.errorMessage(ex.toString());
        }
    }

    void saveAs() {
        if (this.byPassSaveAs != null) {
            String tmp = null;
            if (!this.title.equals(SaveReport.VERSIONNAME)) {
                tmp = this.title;
            }
            Properties prop = this.byPassSaveAs.getSaveAsProperties(tmp);
            if ((tmp = this.byPassSaveAs.getFileName(tmp)) != null) {
                if (tmp.toUpperCase().endsWith(".RPT")) {
                    tmp = tmp.substring(0, tmp.length() - 4);
                } else if (tmp.toUpperCase().endsWith(".XML")) {
                    tmp = tmp.substring(0, tmp.length() - 4);
                } else if (tmp.toUpperCase().endsWith(".PAK")) {
                    tmp = tmp.substring(0, tmp.length() - 4);
                }
                SaveDialog saveDialog = new SaveDialog(this);
                if (this.getBoolean(prop.getProperty("CREATE_STL"), false)) {
                    saveDialog.setType(16);
                }
                saveDialog.setSaveAllData(this.getBoolean(prop.getProperty("SAVE_ALL_DATA"), false));
                saveDialog.setHTML(this.getBoolean(prop.getProperty("CREATE_HTML"), false));
                saveDialog.setSwing(this.getBoolean(prop.getProperty("USE_SWINGVIEWER"), false));
                saveDialog.setXML(this.getBoolean(prop.getProperty("CREATE_XML"), false));
                saveDialog.setPAK(this.getBoolean(prop.getProperty("CREATE_PACK"), false));
                saveDialog.setPageViewer(this.getBoolean(prop.getProperty("USE_PAGEVIEWER"), false));
                this.saveAs(tmp, saveDialog);
                return;
            }
        }
        this.saveAs(null, null);
    }

    private boolean getBoolean(String s, boolean b) {
        if (s == null) {
            return b;
        }
        return s.equalsIgnoreCase("true");
    }

    private void saveAs(String newName, SaveDialog sDialog) {
        this.saveAs(newName, sDialog, false);
    }

    void saveAs(String newName, SaveDialog sDialog, boolean pluginDrillDown) {
        this.saveAs(newName, sDialog, pluginDrillDown, false);
    }

    private void saveAs(String newName, SaveDialog sDialog, boolean pluginDrillDown, boolean processingPAKReport) {
        String oldtitle = this.title;
        try {
            Parameter conflictParam;
            String newtitle = newName;
            SaveDialog saveDialog = sDialog;
            boolean useXML = false;
            if (!this.isSubReport() && (conflictParam = new ParamUtil().getShareMapConflict(this.report)) != null) {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("The parameter") + " " + conflictParam.getName() + " " + LanguageEncoder.getText("from") + " " + conflictParam.getReportTitle() + " " + LanguageEncoder.getText("is both shared to other parameters and mapped to a field in the main report.This is not allowed, please remove the sharing or mapping and try again."), 6);
                this.setModified(false);
                return;
            }
            if (newName == null) {
                try {
                    this.deselectGroupOption();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to deselect group option", ex);
                }
                if (this.report == null) {
                    return;
                }
                String directory = "";
                String filename = "";
                if (this.reportFileName == null) {
                    directory = this.getTemplatesDirectory();
                } else {
                    int index = Math.max(this.reportFileName.lastIndexOf(92), this.reportFileName.lastIndexOf(47));
                    filename = this.reportFileName.substring(index + 1);
                    int indexOfDot = filename.lastIndexOf(46);
                    if (indexOfDot != -1) {
                        filename = filename.substring(0, indexOfDot);
                    }
                    if (index != -1) {
                        directory = this.reportFileName.substring(0, index);
                    }
                }
                directory = directory.replace('\\', '/');
                if (!directory.endsWith(separator)) {
                    directory = directory + separator;
                }
                String ext = "";
                int rtype = 10;
                if (SaveReport.isRPTFile(this.title)) {
                    ext = ".rpt";
                    rtype = 1;
                } else if (SaveReport.isPAKFile(this.title)) {
                    ext = ".pak";
                } else if (SaveReport.isXMLFile(this.title)) {
                    ext = ".xml";
                    rtype = 8;
                } else if (this.title.endsWith(".stl")) {
                    ext = ".stl";
                    rtype = 16;
                }
                boolean temp_saveAllData = this.saveAllData;
                if (this.report.getReportType() == 2) {
                    temp_saveAllData = true;
                }
                saveDialog = new SaveDialog(this, LanguageEncoder.getText("Save As"), directory + filename + ext, rtype, new String[]{"RPT", "XML", "PAK", "STL"}, directory, temp_saveAllData);
                saveDialog.setVisible(true);
                if (saveDialog.getSelectedFile() == null) {
                    return;
                }
                if (saveDialog.isSaveToDatabase()) {
                    this.saveToDatabase(saveDialog.getDBLabel());
                    return;
                }
                this.setTemplatesDirectory(saveDialog.getCurrentDirectory());
                this.reportFileName = this.getPath(saveDialog.getSelectedFile());
                String newTitleWithExt = newtitle = this.getPath(saveDialog.getSelectedFile());
                useXML = false;
                if (newtitle.toLowerCase().startsWith("http://") || newtitle.toLowerCase().startsWith("https://")) {
                    new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), "The file cannot save in URL PATH.  Please re-save the chart in file path.", 6);
                    return;
                }
                if (newtitle.toUpperCase().endsWith(".RPT") || newtitle.toUpperCase().endsWith(".PAK")) {
                    newtitle = newtitle.substring(0, newtitle.length() - 4);
                } else if (newtitle.toUpperCase().endsWith(".XML")) {
                    newtitle = newtitle.substring(0, newtitle.length() - 4);
                    useXML = true;
                }
                this.report.setFileName(newtitle);
                this.report.currentNode.setFileName(newTitleWithExt);
                if (saveDialog.isPAK()) {
                    String topName;
                    if (this.report.getSubFilesTable() != null) {
                        this.subFilesTable = this.report.getSubFilesTable();
                    }
                    this.subFilesTable.setFileInMemEnabled(true);
                    if (!newTitleWithExt.toLowerCase().endsWith(".pak")) {
                        newTitleWithExt = newTitleWithExt + ".pak";
                    }
                    if ((topName = this.subFilesTable.getTopName()) != null && this.subFilesTable.containsKey(topName) && !topName.equals(newTitleWithExt)) {
                        this.subFilesTable.put(newTitleWithExt, this.subFilesTable.remove(topName));
                    }
                    this.subFilesTable.setTopName(newTitleWithExt);
                    this.setReportOpenedInPakFormat(true);
                }
            }
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (saveDialog.getExportType() == 16) {
                if (!newtitle.toUpperCase().endsWith(".STL")) {
                    newtitle = newtitle + ".stl";
                }
                SaveReportStyle srs = new SaveReportStyle(this.report);
                srs.saveToFile(newtitle);
                this.title = newtitle;
                this.setTitle(newtitle);
                this.setCursor(this.currentCursor);
                this.insertLastOpenedFile(newtitle);
                return;
            }
            boolean changed = this.saveAllData != saveDialog.isSaveAllData();
            this.saveAllData = saveDialog.isSaveAllData();
            Report newReport = this.report;
            try {
                if (changed && this.saveAllData && (!this.useLiveData || this.displayRow != -1)) {
                    this.displayRow = -1;
                    newReport = this.reloadData(false);
                    this.displayRowState = 0;
                    this.firstTimePreview = true;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to reload data", ex);
            }
            SaveReport saveReport = new SaveReport(newReport, this.isDesignMode);
            saveReport.setSaveNoData(this.saveWithNoData);
            saveReport.generateHtmlFile(saveDialog.isHTML(), saveDialog.useSwing(), saveDialog.usePageViewer());
            saveReport.generateXMLFile(saveDialog.isXML() || useXML);
            saveReport.generatePAKFile(saveDialog.isPAK());
            saveReport.setSaveAllData(this.saveAllData);
            if ((this.subFilesTable == null || this.subFilesTable.size() == 0) && this.report.getSubFilesTable() != null) {
                this.subFilesTable = this.report.getSubFilesTable();
            }
            if (!processingPAKReport) {
                this.setReportOpenedInPakFormat(saveDialog.isPAK());
                this.subFilesTable.setFileInMemEnabled(saveDialog.isPAK());
            }
            if (newReport.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot()) && this.currentReportIndex == 0) {
                if (!saveDialog.isPAK() || pluginDrillDown) {
                    if (saveDialog.isXML() || useXML) {
                        newReport.currentNode.setFileName(newtitle + ".xml");
                    } else if (saveDialog.isPAK()) {
                        newReport.currentNode.setFileName(newtitle + ".pak");
                    } else {
                        newReport.currentNode.setFileName(newtitle + ".rpt");
                    }
                }
                if (!oldtitle.equals(SaveReport.VERSIONNAME) || pluginDrillDown) {
                    LOGGER.finest("Save drilldowns");
                    this.copyChildNodes(newReport.currentNode);
                    this.resaveChildNodes(newReport.currentNode);
                    this.setDrillDownTree(new JTree(newReport.currentNode));
                    if (useXML) {
                        this.copySubReports(newtitle + ".xml");
                    } else {
                        this.copySubReports(newtitle + (saveDialog.isPAK() ? ".pak" : ""));
                    }
                }
            } else {
                if (this.currentReportIndex > 0) {
                    this.openSubReport = true;
                    this.saveChangesInTheReport();
                    return;
                }
                this.saveChangesInTheReport();
                return;
            }
            saveReport.setDrillDownNode(newReport.currentNode);
            saveReport.setSubReports(this.subReports);
            String newTitleBackup = newtitle;
            newtitle = saveReport.getFullFilename(newtitle);
            this.setModified(false);
            this.title = newtitle;
            this.setItemName(this.title);
            this.setTitle(this.title);
            String topFile = null;
            if (!(SaveReport.isPAKFile(newTitleBackup) || SaveReport.isXMLFile(newTitleBackup) || SaveReport.isQRPFile(newTitleBackup) || SaveReport.isRPTFile(newTitleBackup))) {
                topFile = saveDialog.isPAK() ? newTitleBackup + ".pak" : (saveDialog.isXML() ? newTitleBackup + ".xml" : newTitleBackup + ".rpt");
            } else {
                topFile = newTitleBackup.substring(0, newTitleBackup.length() - 4);
                topFile = saveDialog.isPAK() ? topFile + ".pak" : (saveDialog.isXML() ? topFile + ".xml" : topFile + ".rpt");
            }
            if (!processingPAKReport) {
                this.setReportOpenedInPakFormat(this.getPath(topFile).toLowerCase().endsWith(".pak"));
                this.subFilesTable.setTopName(this.getPath(topFile));
            }
            saveReport.setSubFilesTable(this.subFilesTable);
            if (saveReport.isCreateXML()) {
                saveReport.saveAllChartsFromTheMemoryTableToFileSystem();
            }
            this.saveToFile(saveReport, newTitleBackup);
            if (changed) {
                for (int i = 0; this.subReports != null && i < this.subReports.size(); ++i) {
                    Report[] sub = newReport.getSubReportArray();
                    if (sub[i] == null) continue;
                    SaveReport sr = new SaveReport(sub[i], this.isDesignMode);
                    saveReport.setSaveNoData(this.saveWithNoData);
                    sr.setSaveAllData(this.saveAllData);
                    SubReportObject sro = this.subReports.elementAt(i);
                    this.saveToFile(sr, this.getPath(sro.getFileName()));
                }
                this.saveDrillDownReportWithData(newReport.currentNode, this.saveAllData);
            }
            if (SaveReport.isPAKFile(newtitle)) {
                this.insertFileToReportOrganizer(newtitle);
            } else {
                this.insertFileToReportOrganizer(saveDialog.getDBLabel(), saveDialog.isXML() || useXML);
            }
            ReportMain.cleanupTempFilesForURLReport();
            try {
                if (!oldtitle.equalsIgnoreCase(this.title) && !oldtitle.equals(SaveReport.VERSIONNAME)) {
                    IOUtil.releaseFileLock(oldtitle);
                }
            }
            catch (Exception exc) {
                LOGGER.log(Level.FINEST, "File lock can't be released", exc);
            }
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Action failed: save as", ex);
            this.setModified(true);
            this.setCursor(this.currentCursor);
            this.title = oldtitle;
            this.setTitle(this.title);
            this.errorMessage(ex.toString());
        }
        this.insertLastOpenedFile(this.title);
    }

    private void saveChangesInTheReport() throws Exception {
        this.save();
        this.saveRootReportFromMemoryTableIntoFileSystem();
        this.setModified(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void createNewDrillDownTree(Report newReport) {
        this.setDrillDownTree(new JTree(newReport.currentNode));
    }

    private void saveDrillDownReportWithData(DrillDownNode node, boolean saveAllData) {
        try {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DrillDownNode child = node.getChildAt(i);
                LoadReport lr = new LoadReport(true);
                lr.setSubFilesTable(this.subFilesTable);
                lr.setRelativeDomainPath(this.relativeDomainPath);
                Report ddReport = lr.loadReportFromFile(child.getFileName());
                SaveReport sr = new SaveReport(ddReport, this.isDesignMode);
                sr.setSaveNoData(this.saveWithNoData);
                sr.setSubFilesTable(this.subFilesTable);
                sr.setSubReports(lr.getSubReports());
                sr.setSaveAllData(saveAllData);
                this.saveToFile(sr, this.getPath(child.getFileName()));
                this.saveDrillDownReportWithData(child, saveAllData);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to save drilldown report with data", ex);
        }
    }

    @Override
    public void saveToFile(SaveReport saveReport, String fileName) throws Exception {
        this.saveToFile(saveReport, fileName, false);
    }

    public void saveToFile(SaveReport saveReport, String fileName, boolean saveToMemoryOnly) throws Exception {
        fileName = saveReport.getFullFilename(fileName);
        LOGGER.finest("Save to file, filename= " + fileName + ", save to memory only = " + saveToMemoryOnly);
        saveReport.setSubFilesTable(this.subFilesTable);
        if (this.saveAllData && this.displayRow != -1) {
            this.displayRow = -1;
            this.do_retrieve(this.isDesignMode);
            this.displayRowState = 2;
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        if (this.reportIO == null) {
            if (!saveToMemoryOnly) {
                saveReport.saveToFile(this.getPath(fileName));
            }
            saveReport.saveFileToMemory(this.getPath(fileName));
            out.close();
            fstream.close();
            return;
        }
        String name = saveReport.saveToFile(fileName, out);
        out.close();
        fstream.close();
        this.reportIO.saveFile(fstream.toByteArray(), name);
    }

    public void mergeSubFilesTable(FileInMemTable tbl) {
        if (tbl == null) {
            return;
        }
        Enumeration e = tbl.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            byte[] value = tbl.get(key);
            this.subFilesTable.put(key, value);
        }
        if (tbl.getTopName() != null) {
            this.subFilesTable.setTopName(tbl.getTopName());
        }
    }

    public boolean fileExists(String filename) throws Exception {
        return Report.fileExists(this.subFilesTable, filename);
    }

    private void saveToDatabase(SaveReport saveReport, String fileName) throws Exception {
        saveReport.setSubFilesTable(this.subFilesTable);
        if (this.saveAllData && this.displayRow != -1) {
            this.displayRow = -1;
            this.do_retrieve(this.isDesignMode);
            this.displayRowState = 2;
        }
        this.subFilesTable.resetModify();
        saveReport.setSubFilesTable(this.subFilesTable);
        saveReport.generatePAKFile(true);
        ByteArrayOutputStream fstream = saveReport.saveToOutput(fileName, false);
        LOGGER.finest("Save to database, size = " + fstream.toByteArray().length);
        this.saveToDatabase(fstream.toByteArray(), fileName);
    }

    public void saveToDatabase(byte[] data, String fileName) {
    }

    public boolean isReportData(String filename) {
        return false;
    }

    public String createReportDataName() {
        return null;
    }

    void saveTree(String url, DrillDownNode node) throws Exception {
        if (this.reportIO == null) {
            SaveReport.saveTree(url, node, this.subFilesTable, !this.isReportOpenedInPakFormat());
            return;
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        SaveReport.saveTree(url, node, out, this.subFilesTable);
        out.close();
        fstream.close();
        this.reportIO.saveFile(fstream.toByteArray(), url);
    }

    void writeFile(String filename, byte[] content) throws Exception {
        if (filename == null || !SaveReport.isRPTFile(filename) && !SaveReport.isXMLFile(filename) && !SaveReport.isPAKFile(filename)) {
            throw new IllegalArgumentException("Security Exception: Only report files are allowed for writing.");
        }
        WriteDataFile wdfile = new WriteDataFile();
        wdfile.output(this.subFilesTable, content, filename);
    }

    void export() {
        this.export(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export(int type) {
        this.deselectGroupOption();
        DrillDownNode backupNode = null;
        DrillDownNode nodeToCopy = null;
        try {
            if (this.report == null) {
                return;
            }
            Report report = this.report;
            if (this.isDesignMode) {
                if (!this.promptParamValue()) {
                    return;
                }
                this.displayRow = -1;
                report = this.reloadData(false);
            } else if (this.displayRow != -1) {
                this.displayRow = -1;
                report = this.reloadData(false);
            }
            String directory = this.getTemplatesDirectory();
            directory = directory.replace('\\', '/');
            SaveDialog saveDialog = new SaveDialog(this, LanguageEncoder.getText("Export File"), this.getDefaultName(type), type, Report.getExtension(type), directory);
            saveDialog.setVisible(true);
            if (saveDialog.getSelectedFile() == null) {
                return;
            }
            this.setTemplatesDirectory(saveDialog.getCurrentDirectory());
            this.currentCursor = this.getCursor();
            report.setExportToMultiPages(saveDialog.isExportToMultiPages());
            report.setExportToSingleWPagination(saveDialog.isExportToSingleWPagination());
            report.setExpandAndCollapseEnabled(saveDialog.isExpandAndCollapseEnabled());
            report.setDefaultToExpandAll(saveDialog.isDefaultToExpandAll());
            report.setExpandGroupLevelTo(saveDialog.getExpandGroupLevelTo());
            report.setAnimationOnForExpandAndCollapse(saveDialog.isAnimationOn());
            report.setExportDelimiter(saveDialog.getExportDelimiter());
            report.setExportNewlineDelimiter(saveDialog.getExportNewlineDelim());
            report.setApplyExcelFormat(saveDialog.isApplyExcelFormat());
            report.setExternalStyleSheetName(saveDialog.getExternalStyleSheetName());
            report.setUsingAllColorsForRTF(saveDialog.isUsingAllColorsForRTF());
            Report.Excel_fitCell = saveDialog.isExcelFitCell();
            Report.Excel_NonNumericFitCell = saveDialog.isExcelNonNumericFitCell();
            Report.Excel_streaming = saveDialog.isExcelStreaming();
            Report.Excel_window_size = saveDialog.getExcelWindowSize();
            report.useBackupData = false;
            boolean encodePDF = saveDialog.isEncodePDF();
            String userPass = null;
            String ownerPass = null;
            if (encodePDF) {
                userPass = saveDialog.getPDFUserPass();
                ownerPass = saveDialog.getPDFOwnerPass();
            }
            if (!(report.currentNode.getChildCount() <= 0 && !report.hasSubReportDrillDown() || saveDialog.getExportType() != 4 && saveDialog.getExportType() != 2 && saveDialog.getExportType() != 6 || this.setDynamicExport(report))) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.isSubReport() || this.isDrillDownReport()) {
                nodeToCopy = this.isSubReport() ? report.parentNode : report.currentNode;
                backupNode = (DrillDownNode)nodeToCopy.clone();
                if (nodeToCopy.getParent() != null) {
                    backupNode.setParent((MutableTreeNode)nodeToCopy.getParent());
                }
                if (this.isSubReport()) {
                    report.parentNode = null;
                    nodeToCopy = report.currentNode;
                } else if (this.isDrillDownReport()) {
                    nodeToCopy.setParent(null);
                }
            }
            report.export(saveDialog.getExportType(), this.getPath(saveDialog.getSelectedFile()), nodeToCopy, userPass, ownerPass, 3900);
            if (nodeToCopy != null && backupNode != null && backupNode.getParent() != null) {
                nodeToCopy.setParent((MutableTreeNode)backupNode.getParent());
            }
            if (saveDialog.getExportType() == 14 && saveDialog.isHTML()) {
                PageReport.createAppletPage(this.getPath(saveDialog.getSelectedFile()), saveDialog.useSwing());
            }
            this.setCursor(this.currentCursor);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Export failed", ex);
            this.setCursor(this.currentCursor);
            this.errorMessage(ex.toString());
        }
        finally {
            if (this.isSubReport()) {
                this.report.parentNode = backupNode;
            } else if (this.report.isDrillDownReport() && nodeToCopy != null) {
                this.report.currentNode = nodeToCopy;
            }
        }
    }

    protected boolean setDynamicExport(Report report) {
        ServerPortDialog sDialog = new ServerPortDialog(this);
        sDialog.setVisible(true);
        if (sDialog.isModified()) {
            report.setDynamicExport(report.isDynamicExport(), sDialog.getServerName(), sDialog.getPortNumber());
            report.setServletDirectory(sDialog.getServletDirectory());
            return true;
        }
        return false;
    }

    public void addDrillDown() {
        JMessageDialog msgDialog;
        int response;
        String tmp;
        if (this.isModified() && this.reportIO != null && this.reportIO instanceof IReportNavigationIO && (tmp = ((IReportNavigationIO)this.reportIO).isParentReportSaved()) != null) {
            this.setTitle(tmp);
            this.setModified(false);
        }
        if (this.isModified() && (response = (msgDialog = new JMessageDialog((Frame)this, "Question", saveRptBeforeDrill, 2)).getResponse()) == 5) {
            return;
        }
        if (this.isModified() && this.reportIO != null && this.reportIO instanceof IReportNavigationIO && (tmp = ((IReportNavigationIO)this.reportIO).saveParentReport()) != null) {
            this.setTitle(tmp);
        }
        boolean old_state = this.isModified();
        this.setModified(true);
        if (this.drillDownReportIO != null) {
            this.drillDownReportIO.saveReportForDrillDownOp();
        } else {
            this.save(this.isReportOpenedInPakFormat());
        }
        if (this.isModified() && !this.isReportOpenedInPakFormat()) {
            this.setModified(old_state);
            return;
        }
        boolean crosstab_drilldown = false;
        if (this.report.getReportType() == 2) {
            CrossTabDrillDownDialog dialog = new CrossTabDrillDownDialog(this);
            dialog.setVisible(true);
            crosstab_drilldown = dialog.getCrossTabDrillDown();
        }
        this.wizard = new ReportWizard(this, null, null, false, false);
        this.wizard.init();
        this.wizard.setDBProvider(this.dbProvider);
        this.wizard.setDrillDownOp(true);
        this.wizard.setCrossTabDrillDown(crosstab_drilldown);
        this.wizard.setVisible(true);
    }

    public void addTableOfContents() {
        if (this.report.getTableOfContentsObject() == null) {
            this.setInsertTOC(true);
            this.reset_displayRow();
        } else {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Can only have one table of Content Object per report"));
        }
    }

    public void setEltTableOfContents(JPanel panel, boolean insert) {
        TableOfContents toc = (TableOfContents)this.selectedObject;
        this.repaintPanel(panel);
        if (insert) {
            TOCWizardStep1 step1 = new TOCWizardStep1(this, toc);
            step1.setVisible(true);
            if (!toc.isModified()) {
                this.deleteElt(toc, (ReportElementPanel)panel, true);
            }
            this.setInsertTOC(false);
        } else {
            if (toc.isUseGroups() && (this.report.getReportType() == 0 || toc.getLevels() == 0)) {
                TOCWizardStep1 step1 = new TOCWizardStep1(this, toc);
                step1.setVisible(true);
            } else {
                TOCWizardStep2 step2 = new TOCWizardStep2(this, toc);
                step2.setVisible(true);
            }
            if (toc.isModified()) {
                this.setUpdateReport();
            }
        }
    }

    public void addSubReport() {
        JMessageDialog msgDialog;
        int response;
        String tmp;
        if (this.isModified() && this.reportIO != null && this.reportIO instanceof IReportNavigationIO && (tmp = ((IReportNavigationIO)this.reportIO).isParentReportSaved()) != null) {
            this.setTitle(tmp);
            this.setModified(false);
        }
        if (this.isModified() && (this.getFileName() == null || this.getFileName().equals("") || !this.isReportOpenedInPakFormat) && (response = (msgDialog = new JMessageDialog((Frame)this, "Question", saveRptBeforeSub, 2)).getResponse()) == 5) {
            return;
        }
        if (this.isModified() && this.reportIO != null && this.reportIO instanceof IReportNavigationIO && (tmp = ((IReportNavigationIO)this.reportIO).saveParentReport()) != null) {
            this.setTitle(tmp);
        }
        boolean old_state = this.isModified();
        this.setModified(true);
        if (this.drillDownReportIO != null) {
            this.drillDownReportIO.saveReportForSubReportOp();
        } else {
            this.save(this.isReportOpenedInPakFormat());
        }
        if (this.isModified() && !this.isReportOpenedInPakFormat()) {
            this.setModified(old_state);
            return;
        }
        this.setInsertSubReport(true);
    }

    public void addSubReport(String subReportName) {
        if (this.subReports == null || subReportName == null || subReportName.equals("")) {
            return;
        }
        SubReportObject existing = null;
        for (int i = 0; i < this.subReports.size(); ++i) {
            try {
                if (!this.reportDesignerPane.getTitleAt(i + 1).equals(subReportName)) continue;
                existing = this.subReports.elementAt(i);
                existing.setResizeToFitContent(true);
                existing.setResizeWidth(true);
                break;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Searching for sub-report with matching name failed", ex);
            }
        }
        if (existing == null) {
            return;
        }
        if (this.designPanel.rulerPanel.clipBoard.size() != 0) {
            this.designPanel.rulerPanel.resetClipBoard();
        }
        SubReportObject cell = new SubReportObject();
        cell.copy(existing);
        cell.setX(0.0);
        cell.setY(0.0);
        this.designPanel.rulerPanel.isCutOp = true;
        this.designPanel.rulerPanel.clipBoard.addElement(cell);
        this.designPanel.rulerPanel.pastingSubReport = true;
        if (this.designPanel.rulerPanel.clipBoard.size() != 0) {
            this.designPanel.rulerPanel.enablePaste();
        }
        this.setIsPasteOp(true);
    }

    public void removeSubReport(String subReportName) {
        if (this.subReports == null || subReportName == null || subReportName.equals("")) {
            return;
        }
        JMessageDialog msgDialog = new JMessageDialog((Frame)this, "Question", LanguageEncoder.getText("Do you want to permanently remove '") + subReportName + LanguageEncoder.getText(this.isReportOpenedInPakFormat() ? "'?" : "' and save changes?"), 2);
        int response = msgDialog.getResponse();
        if (response == 5) {
            return;
        }
        SubReportObject existing = null;
        int removeIndex = -1;
        for (int i = 0; i < this.subReports.size(); ++i) {
            try {
                if (!this.reportDesignerPane.getTitleAt(i + 1).equals(subReportName)) continue;
                existing = this.subReports.elementAt(i);
                removeIndex = i;
                i = this.subReports.size();
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Searching for sub-report with matching name failed", ex);
            }
        }
        if (existing == null) {
            return;
        }
        this.save();
        this.reportDesignerPane.setSelectedIndex(0);
        Report[] subReportArray = this.report.getSubReportArray();
        if (subReportArray[removeIndex] != null) {
            int i;
            Vector<Parameter> queryParam = subReportArray[removeIndex].getQueryParameters();
            for (int i2 = 0; i2 < queryParam.size(); ++i2) {
                Parameter parameter = queryParam.elementAt(i2);
                Vector<Parameter> mainQueryParam = this.report.getQueryParameters();
                for (int k = 0; k < mainQueryParam.size(); ++k) {
                    Parameter param = mainQueryParam.elementAt(k);
                    if (param.isShared() && existing.getParamShareReportID().equals(param.getSharedReportName())) {
                        param.setShared(false);
                        param.setSharedReportName(null);
                        param.setSharedParamName(null);
                    }
                    if (!param.isShareReferenced() || !parameter.isShared() || !parameter.getSharedReportName().equals("MAIN_REPORT") || !parameter.getSharedParamName().equals(param.getName())) continue;
                    param.decReferenceDegree();
                }
                for (int j = 0; j < subReportArray.length; ++j) {
                    if (j == removeIndex) continue;
                    Vector<Parameter> subQueryParam = subReportArray[j].getQueryParameters();
                    for (int k = 0; k < subQueryParam.size(); ++k) {
                        Parameter param = subQueryParam.elementAt(k);
                        if (param.isShared() && existing.getParamShareReportID().equals(param.getSharedReportName())) {
                            param.setShared(false);
                            param.setSharedReportName(null);
                            param.setSharedParamName(null);
                            subReportArray[j].modified = true;
                        }
                        if (!param.isShareReferenced() || !parameter.isShared() || !parameter.getSharedReportName().equals(this.subReports.elementAt(j).getParamShareReportID()) || !parameter.getSharedParamName().equals(param.getName())) continue;
                        param.decReferenceDegree();
                        subReportArray[j].modified = true;
                    }
                }
            }
            Vector<Parameter> formulaParam = subReportArray[removeIndex].getFormulaParameters();
            for (i = 0; i < formulaParam.size(); ++i) {
                Parameter parameter = formulaParam.elementAt(i);
                Vector<Parameter> mainFormulaParam = this.report.getFormulaParameters();
                for (int k = 0; k < mainFormulaParam.size(); ++k) {
                    Parameter param = mainFormulaParam.elementAt(k);
                    if (param.isShared() && existing.getParamShareReportID().equals(param.getSharedReportName())) {
                        param.setShared(false);
                        param.setSharedReportName(null);
                        param.setSharedParamName(null);
                    }
                    if (!param.isShareReferenced() || !parameter.isShared() || !parameter.getSharedReportName().equals("MAIN_REPORT") || !parameter.getSharedParamName().equals(param.getName())) continue;
                    param.decReferenceDegree();
                }
                for (int j = 0; j < subReportArray.length; ++j) {
                    if (j == removeIndex) continue;
                    Vector<Parameter> subFormulaParam = subReportArray[j].getFormulaParameters();
                    for (int k = 0; k < subFormulaParam.size(); ++k) {
                        Parameter param = subFormulaParam.elementAt(k);
                        if (param.isShared() && existing.getParamShareReportID().equals(param.getSharedReportName())) {
                            param.setShared(false);
                            param.setSharedReportName(null);
                            param.setSharedParamName(null);
                            subReportArray[j].modified = true;
                        }
                        if (!param.isShareReferenced() || !parameter.isShared() || !parameter.getSharedReportName().equals(this.subReports.elementAt(j).getParamShareReportID()) || !parameter.getSharedParamName().equals(param.getName())) continue;
                        param.decReferenceDegree();
                        subReportArray[j].modified = true;
                    }
                }
            }
            try {
                for (i = 0; i < subReportArray.length; ++i) {
                    if (!subReportArray[i].modified) continue;
                    SaveReport sr = new SaveReport(subReportArray[i], this.isDesignMode);
                    sr.setSaveNoData(this.saveWithNoData);
                    SubReportObject sro = this.subReports.elementAt(i);
                    this.saveToFile(sr, sro.getFileName(), this.isReportOpenedInPakFormat);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to save sub-reports", ex);
            }
        }
        this.removeSubReport = true;
        this.reportDesignerPane.removeTabAt(removeIndex + 1);
        this.removeSubReport = false;
        this.subReports.removeElementAt(removeIndex);
        Vector<JPanel> panelList = this.designPanel.rulerPanel.panelList;
        if (panelList != null && panelList.size() > 0) {
            for (int i = 0; i < panelList.size(); ++i) {
                JPanel ePanelObject = panelList.elementAt(i);
                if (!(ePanelObject instanceof ReportElementPanel) || !(((ReportElementPanel)ePanelObject).getElement() instanceof ReportSection)) continue;
                ((ReportSection)((ReportElementPanel)ePanelObject).getElement()).removeSubReportWithFileName(existing.getFileName());
            }
        }
        this.report.getReportTables().elementAt(0).removeSubReportWithFileName(existing.getFileName());
        for (int i = 1; i < this.reportDesignerPane.getTabCount() - 1; ++i) {
            this.reportDesignerPane.setTitleAt(i, LanguageEncoder.getText("Sub-Report_") + i);
        }
        this.menuBar.setUndoEnabled(false);
        this.setUpdateReport();
        this.updatePanel();
        this.save(this.isReportOpenedInPakFormat);
        new DeleteFile(existing.getFileName()).delete();
    }

    public void showDrillDownNavigationFrame() {
        if (this.drillDownNavigationFrame == null) {
            try {
                this.drillDownNavigationFrame = new DrillDownNavigationFrame(this);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Cannot initialize drill-down navigation frame", e);
                this.errorMessage(e.toString());
                return;
            }
        }
        this.drillDownNavigationFrame.updateTree(this.drillDownTree);
        this.drillDownNavigationFrame.setPosition();
        this.drillDownNavigationFrame.setVisible(true);
    }

    void setSelectedObject(ReportElement obj, ReportElementPanel pPanel) {
        if (this.selectedObject != null && this.selectedPanel != null && this.selectedPanel != pPanel) {
            this.selectedPanel.resetSelectedObject();
            this.designPanel.rulerPanel.xRuler.repaintNull();
            this.designPanel.rulerPanel.yRuler.repaintNull();
            this.selectedPanel.repaint();
        }
        if (obj != pPanel.getElement() && obj != pPanel.reportTable) {
            pPanel.selectedObject = obj;
        }
        this.selectedObject = obj;
        this.selectedPanel = pPanel;
        this.designPanel.rulerPanel.xRuler.repaintNull();
        this.designPanel.rulerPanel.yRuler.repaintNull();
        this.selectedPanel.repaint();
        if (this.selectedPanel != null) {
            this.editPanel.setLabel(this.selectedPanel.sectionID);
        }
        if (obj != null) {
            if (obj instanceof ReportCell) {
                String formula = ((ReportCell)obj).getFormula();
                if (formula != null) {
                    this.editPanel.setField(formula);
                } else {
                    this.editPanel.setField(obj.getText());
                }
            } else {
                this.editPanel.setField(obj.getText());
            }
        }
        this.setCopyCutEnabled();
        this.editPanel.repaint();
        if (this.dbFieldDialog != null) {
            this.dbFieldDialog.toFront();
        }
        if (this.scriptDialog != null && this.scriptDialog.isVisible()) {
            this.scriptDialog.update(this);
        }
    }

    ReportElement getSelectedObject() {
        return this.selectedObject;
    }

    void resetSelectedObject() {
        this.resetSelectedObject(false);
    }

    void resetSelectedObject(boolean resetGroupFormat) {
        this.selectedObject = null;
        if (this.designPanel.rulerPanel.xRuler != null) {
            this.designPanel.rulerPanel.xRuler.repaintNull();
        }
        if (this.designPanel.rulerPanel.yRuler != null) {
            this.designPanel.rulerPanel.yRuler.repaintNull();
        }
        this.designPanel.designToolBar2.resetObject();
        if (this.selectedPanel != null) {
            ReportElementPanel sp = this.selectedPanel;
            sp.resetSelectedObject();
            if (resetGroupFormat) {
                sp.groupFormat.clear();
            }
        }
        this.selectedPanel = null;
    }

    void setSelectedPanel(ReportElementPanel panel) {
        this.selectedPanel = panel;
    }

    public ReportElementPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    public ReportElementPanel findPanel(GuideLine gl) {
        Vector<JPanel> list = this.designPanel.rulerPanel.getVisiblePanel();
        for (int i = 0; i < list.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)list.elementAt(i);
            ReportElement elt = panel.getElement();
            if (elt instanceof ReportSection && ((ReportSection)elt).hasCell(gl)) {
                return panel;
            }
            if (!(elt instanceof ReportTable) || ((ReportTable)elt).indexOf(gl) < 0) continue;
            return panel;
        }
        return null;
    }

    private String getDefaultName(int type) {
        String tmp;
        int indexOfDot;
        if (this.title.equals(SaveReport.VERSIONNAME) || this.report == null || this.report.getFileName() == null) {
            return "";
        }
        String filename = this.report.getFileName();
        int backSlashIndex = filename.lastIndexOf(92);
        int forwardSlashIndex = filename.lastIndexOf(47);
        if (backSlashIndex != -1 || forwardSlashIndex != -1) {
            filename = backSlashIndex > forwardSlashIndex ? filename.substring(backSlashIndex + 1, filename.length()) : filename.substring(forwardSlashIndex + 1, filename.length());
        }
        if ((indexOfDot = filename.indexOf(46)) != -1) {
            filename = filename.substring(0, indexOfDot);
        }
        if (!(tmp = this.getBrowseDirectories().getReportTemplatesDirectory()).endsWith(separator) && !tmp.endsWith("\\")) {
            tmp = tmp + separator;
        }
        tmp = tmp + filename;
        boolean XMLtitle = SaveReport.isXMLFile(filename);
        switch (type) {
            case 1: {
                return tmp + ".rpt";
            }
            case 10: {
                return tmp + ".pak";
            }
            case 4: {
                return tmp + ".html";
            }
            case 2: {
                return tmp + ".pdf";
            }
            case 3: {
                return tmp + ".csv";
            }
            case 5: {
                return tmp + ".txt";
            }
            case 9: {
                return tmp + ".xls";
            }
            case 17: {
                return tmp + ".xlsx";
            }
            case 13: {
                return tmp + ".rtf";
            }
            case 14: {
                return tmp + ".view";
            }
            case 6: 
            case 7: {
                if (XMLtitle) {
                    return tmp + "_EXPORT.xml";
                }
                return tmp + ".xml";
            }
        }
        return tmp;
    }

    void setFileName(String fileName) {
        if (fileName == null) {
            fileName = SaveReport.VERSIONNAME;
        }
        this.title = fileName;
        this.setTitle(fileName);
    }

    @Override
    public void setTitle(String t) {
        this.reportMainTitle = t;
        if (SaveReport.isRPTFile(t) && this.isReportOpenedInPakFormat) {
            t = t.substring(0, t.length() - 4) + ".pak";
        }
        super.setTitle(t);
        this.getReportMenuBar().setMenuForSTL();
        if (this.designPanel != null) {
            this.designPanel.designToolBar.setToolbarForSTL();
        }
        if (this.previewPanel != null) {
            this.previewPanel.previewToolBar.setToolbarForSTL();
        }
    }

    @Override
    public String getTitle() {
        if (this.reportMainTitle == null) {
            return super.getTitle();
        }
        return this.reportMainTitle;
    }

    public String getFileName() {
        String fileName = this.getTitle();
        if (fileName.equals(SaveReport.VERSIONNAME)) {
            return null;
        }
        return fileName;
    }

    public String getRPTFileName() {
        return this.getRPTFileName(this.getTitle());
    }

    private String getRPTFileName(String fileName) {
        if (fileName.equals(SaveReport.VERSIONNAME)) {
            return null;
        }
        if (SaveReport.isPAKFile(fileName)) {
            fileName = fileName.substring(0, fileName.length() - 4) + ".rpt";
        }
        return fileName;
    }

    void do_enable() {
        LOGGER.finest("ReportMain: do_enable");
    }

    void aboutReportDesigner() {
        LogoDialog logoDialog = new LogoDialog(this);
        logoDialog.setVisible(true);
    }

    protected void showDocumentation() {
        QbUtil.showDocumentation();
    }

    private void errorMessage(Exception ex) {
        this.errorMessage(IOUtil.getStackTrace(ex));
    }

    void errorMessage(String msg) {
        new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), msg);
    }

    private synchronized void do_retrieve() {
        this.do_retrieve(this.isDesignMode);
    }

    private synchronized void do_retrieve(boolean isDesignMode) {
        try {
            if (this.report == null) {
                return;
            }
            if (this.groupFormatFlag()) {
                this.deselectGroupOption();
            }
            Cursor cursor = this.getCursor();
            this.setTitle(this.wait);
            Report newReport = this.reloadData(isDesignMode);
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (newReport != null) {
                this.setReport(newReport, false);
            }
            this.setCursor(cursor);
            this.setTitle(this.title);
            if (this.reportDesignerPane.getSelectedIndex() == this.reportDesignerPane.getTabCount() - 1) {
                this.menuBar.setMenuForPreview();
            }
        }
        catch (OutOfMemoryError e) {
            LOGGER.log(Level.FINE, "Out of Memory, go to Data menu and change display row", e);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Out of Memory, go to Data menu and change display row."));
        }
    }

    public synchronized void do_retrieveWithoutDataUpdate(boolean isDesignMode) {
        try {
            if (this.report == null) {
                return;
            }
            if (this.groupFormatFlag()) {
                this.deselectGroupOption();
            }
            Cursor cursor = this.getCursor();
            this.setTitle(this.wait);
            Report newReport = this.report.setNewData(this.report.colData, this.report.colInfo, this.report.reportType, this.report.colDataSorted, isDesignMode);
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (newReport != null) {
                this.setReport(newReport, false);
            }
            this.setCursor(cursor);
            this.setTitle(this.title);
            if (this.reportDesignerPane.getSelectedIndex() == this.reportDesignerPane.getTabCount() - 1) {
                this.menuBar.setMenuForPreview();
            }
        }
        catch (OutOfMemoryError e) {
            LOGGER.log(Level.FINE, "Out of Memory, go to Data menu and change display row", e);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Out of Memory, go to Data menu and change display row."));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve report without data update", e);
        }
    }

    private synchronized Report reloadData(boolean isDesignMode) {
        Report newReport = null;
        try {
            newReport = ReloadReport.reloadData(this.report, true, null, 0, this.displayRow, isDesignMode);
        }
        catch (SQLException e) {
            LOGGER.log(Level.FINE, "Failed to reload report data", e);
            try {
                int code = Integer.valueOf(e.getMessage());
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), IOUtil.getErrorString(code));
            }
            catch (NumberFormatException nfex) {
                LOGGER.log(Level.FINER, "Failed to get error code", nfex);
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), e.getMessage());
            }
            newReport = this.report;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to reload report data", e);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), "The report cannot be previewed correctly because of the following:\n" + e.toString());
            newReport = this.report;
        }
        return newReport;
    }

    @Override
    public synchronized void do_Refresh() {
        if (this.report == null) {
            return;
        }
        if (this.groupFormatFlag()) {
            this.deselectGroupOption();
        }
        this.selectedObject = null;
        this.currentCursor = this.getCursor();
        if (IOUtil.isMac()) {
            this.setTitle(this.wait);
        }
        Report newReport = null;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.useLiveData) {
            try {
                this.report.useBackupData = false;
                SubReportObject[] subReportObjects = this.report.getSubReports();
                for (int i = 0; subReportObjects != null && i < subReportObjects.length; ++i) {
                    SubReportObject sro = subReportObjects[i];
                    sro.clearReportCache(1.0);
                }
                newReport = ReloadReport.reloadData(this.report, false, null, 0, this.displayRow, this.isDesignMode);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to refresh report", ex);
                this.errorMessage(ex);
            }
        } else {
            newReport = this.report;
        }
        if (newReport != null) {
            this.setReport(newReport, false);
        }
        this.setCursor(this.currentCursor);
        if (IOUtil.isMac()) {
            this.setTitle(this.title);
        }
        if (this.reportDesignerPane.getSelectedIndex() == this.reportDesignerPane.getTabCount() - 1) {
            this.menuBar.setMenuForPreview();
        }
    }

    void redoDataMapping() {
        String msg = null;
        if (this.report == null) {
            msg = LanguageEncoder.getText("Please open a report first!");
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (this.groupFormatFlag()) {
            this.deselectGroupOption();
        }
        this.wizard = new ReportWizard(this, true);
        this.wizard.setVisible(true);
    }

    void updateDataSource() {
        String msg = null;
        if (this.report == null) {
            msg = LanguageEncoder.getText("Please open a report first!");
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (this.report.dbInfo instanceof QueryFileInfo) {
            Vector<Parameter> vec = this.report.getQueryParameters();
            for (int i = 0; i < vec.size(); ++i) {
                Parameter param = vec.elementAt(i);
                boolean sharedParamFound = false;
                try {
                    Report mr = this.report;
                    String rptShareName = "MAIN_REPORT";
                    if (mr.parentNode != null) {
                        mr = this.getMainReport();
                    }
                    Report[] subs = mr.getSubReportArray(true);
                    if (mr != this.report) {
                        for (int subI = 0; subI < subs.length; ++subI) {
                            if (!subs[subI].currentNode.getFileName().equals(this.report.currentNode.getFileName())) continue;
                            rptShareName = mr.subReports.get(subI).getParamShareReportID();
                        }
                    }
                    for (Report sub : subs) {
                        if (new ParamUtil().findSharedParamsInSubReport(rptShareName, param, sub) == null) continue;
                        sharedParamFound = true;
                        break;
                    }
                    if (param.isShared() || param.isShareReferenced() && sharedParamFound) {
                        new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), "This report contains parameter that shares with other report, please remove the sharing before changing Data Source");
                        return;
                    }
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warning(e.getMessage());
                }
            }
        }
        if (this.groupFormatFlag()) {
            this.deselectGroupOption();
        }
        UpdateDataSourceWizard updateWizard = new UpdateDataSourceWizard(this);
        this.wizard = updateWizard;
        updateWizard.updateReport();
    }

    void updateDatabase() {
        String msg = null;
        if (this.report == null) {
            msg = LanguageEncoder.getText("Please open a report first!");
        } else if (this.report.sourceData != 1 && this.report.getOriginalSourceData() != 1) {
            msg = LanguageEncoder.getText("This report does not use a database data source. Please try changing the data source instead.");
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (this.groupFormatFlag()) {
            this.deselectGroupOption();
        }
        UpdateDatabaseWizard wizard = new UpdateDatabaseWizard(this);
        wizard.updateReport(true);
    }

    void updateQuery() {
        String msg = null;
        if (this.report == null) {
            msg = LanguageEncoder.getText("Please open a report first!");
        } else if (this.report.sourceData != 1 && this.report.getOriginalSourceData() != 1 && this.report.sourceData != 7 && this.report.getOriginalSourceData() != 7) {
            msg = LanguageEncoder.getText("This report does not use a database or XML query as data source. Please try changing the data source instead.");
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (this.groupFormatFlag()) {
            this.deselectGroupOption();
        }
        UpdateQueryWizard wizard = new UpdateQueryWizard(this);
        wizard.updateReport();
    }

    boolean setPreviewDataOptions() {
        PreviewDataOptionDialog dialog = new PreviewDataOptionDialog(this);
        dialog.setVisible(true);
        if (dialog.isCancel) {
            return false;
        }
        this.useLiveData = dialog.isUseLiveData;
        if (this.displayRow != dialog.getDisplayRow()) {
            this.setDisplayRow(dialog.getDisplayRow());
            this.displayRowState = 1;
            this.setModified();
            this.repaintPanel();
        }
        return true;
    }

    void setPreviewSecurityLevel() {
        Object selectedValue;
        this.menuBar.setUndoEnabled(false);
        String[] levels = this.report.getSecurityLevels();
        Object[] choices = new String[levels.length + 1];
        choices[0] = "";
        for (int i = 0; i < levels.length; ++i) {
            choices[i + 1] = levels[i];
        }
        String initialChoice = this.report.getPreviewSecurityLevel();
        if (initialChoice == null) {
            initialChoice = "";
        }
        if ((selectedValue = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Choose Preview Security Level:"), LanguageEncoder.getText("Preview Security Level"), 1, null, choices, initialChoice)) != null) {
            if (selectedValue.toString().equals("")) {
                this.report.setPreviewSecurityLevel(null);
            } else {
                this.report.setPreviewSecurityLevel(selectedValue.toString());
            }
            this.setUpdateReport(true);
        }
    }

    protected void setSecuredQueryParameters() {
        boolean isNotParamQuery;
        if (this.report == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please open a report first!"));
            return;
        }
        boolean bl = isNotParamQuery = this.report.dbInfo == null || !(this.report.dbInfo instanceof QueryFileInfo);
        if (this.report.dbInfo == null || !(this.report.dbInfo instanceof QueryFileInfo)) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("This report does not contain a parameterized query."));
            return;
        }
        SecurityQueryParameterDialog securityDialog = null;
        securityDialog = isNotParamQuery ? new SecurityQueryParameterDialog(this, null, this.report.getSecurityQueryParameterMap()) : new SecurityQueryParameterDialog(this, (QueryFileInfo)this.report.dbInfo, this.report.getSecurityQueryParameterMap());
        securityDialog.setVisible(true);
        if (securityDialog.isModified()) {
            this.report.setSecurityQueryParameterMap(securityDialog.getSecurityMap());
            this.setModified();
        }
    }

    protected void setSecurityLevel(String level) {
        this.securityLevel = level;
    }

    protected String getSecurityLevel() {
        return this.securityLevel;
    }

    public Vector<String> getPresetSecurityLevels() {
        return null;
    }

    void do_ViewRecord() {
        if (this.recordFrame == null) {
            this.recordFrame = new RecordFrame(this, LanguageEncoder.getText("View table"), this.report.colData);
            this.recordFrame.setVisible(true);
        } else {
            this.recordFrame.toFront();
        }
    }

    void do_ColInfoRecord() {
        if (this.colInfoFrame == null) {
            this.colInfoFrame = new ColInfoFrame(this, LanguageEncoder.getText("View Column Mapping"));
            this.colInfoFrame.setVisible(true);
        } else {
            this.colInfoFrame.toFront();
        }
    }

    void do_ViewDataSourceInfo() {
        if (this.dataSourceInfoFrame == null) {
            this.dataSourceInfoFrame = new DataSourceInfoFrame(this, LanguageEncoder.getText("View Data Source Info"));
            this.dataSourceInfoFrame.setVisible(true);
        } else {
            this.dataSourceInfoFrame.toFront();
        }
    }

    void repaintTablePanel() {
        Vector<JPanel> list = this.designPanel.rulerPanel.getVisiblePanel();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.elementAt(i) instanceof ReportElementPanel) || !(((ReportElementPanel)list.elementAt(i)).getElement() instanceof ReportTable)) continue;
            this.repaintPanel(list.elementAt(i));
        }
    }

    void repaintPanel() {
        for (int i = 0; i < this.designPanel.rulerPanel.panelList.size() - 1; ++i) {
            ((ReportElementPanel)this.designPanel.rulerPanel.panelList.elementAt(i)).repaintPanel();
        }
        if (this.designPanel.rulerPanel.getMasterSectionPanel() != null) {
            this.designPanel.rulerPanel.getMasterSectionPanel().repaintPanel();
        }
    }

    void repaintPanel(JPanel panel) {
        if (this.selectedObject != null && (this.selectedObject instanceof ReportLine && ((ReportLine)this.selectedObject).isCrossSection() || this.selectedObject instanceof ReportGrid && ((ReportGrid)this.selectedObject).isCrossSection())) {
            this.repaintPanel();
            return;
        }
        if (panel instanceof ReportElementPanel) {
            ((ReportElementPanel)panel).resetOffScreenImage();
        }
        panel.repaint();
        if (this.dbFieldDialog != null) {
            this.dbFieldDialog.toFront();
        }
    }

    boolean isInsertObject() {
        return this.isInsertChart() || this.isInsertColumnHeader() || this.isInsertDatabaseField() || this.isInsertFormula() || this.isInsertGrid() || this.isInsertGuideLine() || this.isInsertImage() || this.isInsertLabel() || this.isInsertLine() || this.isInsertRichTextField() || this.isInsertSubReport() || this.isInsertTOC() || this.isPasteOp();
    }

    void resetInsertion() {
        this.insertChart = false;
        this.insertColumnHeader = false;
        this.insertDatabaseField = false;
        this.insertFormula = false;
        this.insertGrid = false;
        this.insertGuideLine = false;
        this.insertImage = false;
        this.insertLabel = false;
        this.insertLine = false;
        this.insertRichTextField = false;
        this.insertSubReport = false;
        this.insertTOC = false;
        this.isPasteOp = false;
        this.insertBoundingBox = false;
    }

    void setInsertLine(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertLine = b;
    }

    boolean isInsertLine() {
        return this.insertLine;
    }

    void setVerticalLine(boolean b) {
        this.isVerticalLine = b;
    }

    boolean isVerticalLine() {
        return this.isVerticalLine;
    }

    void setInsertGuideLine(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertGuideLine = b;
    }

    boolean isInsertGuideLine() {
        return this.insertGuideLine;
    }

    void setVerticalGuideLine(boolean b) {
        this.isVerticalGuideLine = b;
    }

    boolean isVerticalGuideLine() {
        return this.isVerticalGuideLine;
    }

    void setInsertGrid(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertGrid = b;
    }

    boolean isInsertGrid() {
        return this.insertGrid;
    }

    public void setInsertBoundingBox(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertBoundingBox = b;
    }

    public boolean isInsertBoundingBox() {
        return this.insertBoundingBox;
    }

    boolean isPasteOp() {
        return this.isPasteOp;
    }

    void setIsPasteOp(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.isPasteOp = b;
    }

    void setInsertChart(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertChart = b;
    }

    boolean isInsertChart() {
        return this.insertChart;
    }

    void setInsertImage(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertImage = b;
    }

    boolean isInsertImage() {
        return this.insertImage;
    }

    void setInsertLabel(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertLabel = b;
    }

    boolean isInsertLabel() {
        return this.insertLabel;
    }

    void setInsertSubReport(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertSubReport = b;
    }

    boolean isInsertSubReport() {
        return this.insertSubReport;
    }

    private void setInsertTOC(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertTOC = b;
    }

    boolean isInsertTOC() {
        return this.insertTOC;
    }

    private void setInsertColumnWrap() {
        double wrapPos = QbUtil.toInch(Math.floor((double)QbUtil.toPixel(this.report.getActualPageWidth()) / 2.0));
        ColumnWrap wrap = this.designPanel.rulerPanel.createColumnWrap(wrapPos);
        this.report.setColumnWrap(wrap);
        this.setFitGroupOnPage(this.report, false);
        this.repaintPanel();
    }

    private void setFitGroupOnPage(Report report, boolean b) {
        Vector<ReportTable> tbls = report.getReportTables();
        if (tbls == null || tbls.size() <= 0 || tbls.elementAt(0) == null) {
            return;
        }
        ReportTable table = tbls.elementAt(0);
        for (int i = 0; i < table.countRowBreakHeader(); ++i) {
            report.colInfo[report.breakColIndex[i]].setFitGroupOnPage(b);
            ReportSection section = table.getRowBreakHeader(i);
            section.setRepeatOnEveryPage(b);
            section.setResetPageNumber(b);
            section.setNewExcelSheet(b);
            section.setPrintOnNewPage(b);
            section.setSkipFirstValue(b);
            section.setSkipFirstGroupValue(b);
            section = table.getRowBreakFooter(i);
            section.setPrintOnNewPage(b);
            section.setSkipFirstValue(b);
        }
        table.setPrintOnNewPage(b);
        table.getHeader().setRepeatOnEveryPage(b);
        table.getHeader().setPrintOnNewPage(b);
        table.getHeader().setSkipFirstValue(b);
        table.getFooter().setPrintOnNewPage(b);
        table.getFooter().setSkipFirstValue(b);
        report.getReportFooter().setPrintOnNewPage(b);
    }

    void setInsertRichTextField(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.insertRichTextField = b;
    }

    boolean isInsertRichTextField() {
        return this.insertRichTextField;
    }

    void setInsertColumnHeader(boolean b) {
        this.insertColumnHeader = b;
    }

    void setInsertFormula(boolean b) {
        if (b) {
            this.resetInsertion();
        }
        this.defaultFormula = LanguageEncoder.getText("New Formula");
        this.defaultType = 12;
        new FormulaDialog(this).setVisible(true);
        this.repaintPanel();
    }

    void setInsertFormula(boolean b, String name, String text, int type) {
        this.setInsertFormula(b, name, text, type, true);
    }

    private void setInsertFormula(boolean b, String name, String text, int type, boolean addToFormulaList) {
        if (b) {
            this.resetInsertion();
        }
        this.insertFormula = b;
        this.defaultType = type;
        if (this.report.formulaExists(name)) {
            name = NewEditDialog.getNextFormulaName(this.report.formulas, name);
        }
        Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
        formulaVec.add(this.report.formulas);
        for (int i = 0; this.report.subReports != null && i < this.report.subReports.size(); ++i) {
            Report rpt = this.report.getSubReportArray()[i];
            if (rpt == null) continue;
            formulaVec.add(rpt.formulas);
        }
        Formula formula = new Formula(name, text);
        formula.getDatatype(this.report);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
            formula.setFormula(parser.parse(formulaVec, this.report.getQueryParameters(), this.report.getFormulaParameters(), name));
            if (addToFormulaList) {
                this.report.formulas.addElement(formula);
            }
            this.setSelectedFormula(formula);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Cannot process formula", e);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), e.getMessage());
        }
    }

    boolean isInsertFormula() {
        return this.insertFormula;
    }

    boolean isInsertDatabaseField() {
        return this.insertDatabaseField;
    }

    boolean isInsertColumnHeader() {
        return this.insertColumnHeader;
    }

    void setInsertColumnField() {
        if (this.report == null) {
            return;
        }
        ColumnFieldDialog columnFieldDialog = new ColumnFieldDialog(this);
        columnFieldDialog.setVisible(true);
        if (columnFieldDialog.isModified()) {
            this.setInsertFormula(true, columnFieldDialog.getFormulaName(), columnFieldDialog.getFormula(), columnFieldDialog.getSQLType());
        }
    }

    void setInsertDatabaseField() {
        if (this.report == null) {
            return;
        }
        if (this.report.dbInfo == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Data is not from database!"));
            return;
        }
        try {
            this.dbFieldDialog = new DatabaseFieldDialog(this);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to initialize DatabaseFieldDialog.", e);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot insert database field when custom SQL query is used."));
            return;
        }
        this.dbFieldDialog.setVisible(true);
    }

    void setInsertParameterValue() {
        if (this.report == null) {
            return;
        }
        ParameterValueDialog parameterValueDialog = new ParameterValueDialog(this);
        parameterValueDialog.setVisible(true);
        if (parameterValueDialog.isModified()) {
            this.setInsertFormula(true, parameterValueDialog.getName(), parameterValueDialog.getFormula(), parameterValueDialog.getSQLType());
        }
    }

    void setInsertColumnHeader() {
        if (this.report == null) {
            return;
        }
        ColumnHeaderDialog columnHeaderDialog = new ColumnHeaderDialog(this);
        columnHeaderDialog.setVisible(true);
        if (columnHeaderDialog.isModified()) {
            this.insertColumnHeader = true;
            Formula formula = new Formula(null, columnHeaderDialog.getColumnHeaderString());
            formula.getDatatype(this.report);
            Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
            formulaVec.add(this.report.formulas);
            for (int i = 0; this.report.subReports != null && i < this.report.subReports.size(); ++i) {
                Report rpt = this.report.getSubReportArray()[i];
                if (rpt == null) continue;
                formulaVec.add(rpt.formulas);
            }
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(columnHeaderDialog.getColumnHeaderString().getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse(formulaVec, this.report.getQueryParameters(), this.report.getFormulaParameters(), null));
                this.setSelectedFormula(formula);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Cannot process column header", e);
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), e.getMessage());
            }
        }
    }

    int addColInfo(ColInfo newCol) {
        this.setModified();
        this.setReport(this.report.addColInfo(newCol, false), true, false);
        for (int i = 0; i < this.report.colInfo.length; ++i) {
            if (this.report.colInfo[i] != newCol) continue;
            return i;
        }
        return this.report.colInfo.length - 1;
    }

    void printReport() {
        String msg = null;
        ReportCanvas canvas = null;
        if (this.reportDesignerPane.getSelectedIndex() == 0) {
            msg = LanguageEncoder.getText("Cannot print in Design Mode!");
        }
        if (msg == null) {
            if (this.report != null && this.previewPanel.viewer != null) {
                canvas = this.previewPanel.viewer.getReportCanvas();
            }
            if (canvas == null) {
                msg = LanguageEncoder.getText("No report to print!");
            }
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (canvas != null) {
            canvas.print();
        }
    }

    public void setEltRotate(double deg) {
        if (this.isDesignMode) {
            this.selectedObject.setRotateAngle(deg);
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltScript() {
        if (this.scriptDialog != null) {
            this.scriptDialog.setVisible(false);
            this.scriptDialog.dispose();
            this.currentScript = null;
        }
        this.scriptDialog = new ScriptDialog(this);
        this.scriptDialog.setVisible(true);
    }

    public void doneSetEltScript() {
        if (this.getSelectedScript() != null) {
            this.selectedObject.setScriptObj(this.getSelectedScript());
        }
        this.setModified();
        if (this.selectedPanel != null) {
            this.selectedPanel.setApplyScript(true);
            this.selectedPanel.repaintFromScratch();
        }
    }

    public void setEltAlign(short align) {
        this.setEltAlign(align, 0, null);
    }

    public void setEltAlign(short align, int row, Vector<Integer> tree) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            if (this.isDesignMode) {
                this.designPanel.rulerPanel.groupFormatSetAlign(align);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.isDesignMode) {
            this.selectedObject.setAlign(align);
        } else if (this.selectedObject instanceof ReportCell) {
            ReportElement elt = this.selectedPanel.getElement();
            if (elt instanceof ReportTable) {
                this.selectedObject.setAlign(align);
            } else if (elt instanceof ReportSection) {
                if (((ReportSection)elt).hasSectionCell((ReportCell)this.selectedObject, tree) || ((ReportSection)elt).hasFormattedCell((ReportCell)this.selectedObject, tree)) {
                    this.selectedObject.setAlign(align);
                } else if (this.selectedObject instanceof ColumnHeader) {
                    ColumnHeader newCell = new ColumnHeader();
                    newCell.copy((ColumnHeader)this.selectedObject);
                    newCell.setAlign(align);
                    ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.selectedObject, tree);
                } else {
                    ReportCell newCell = new ReportCell();
                    newCell.copy((ReportCell)this.selectedObject);
                    newCell.setAlign(align);
                    ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.selectedObject, tree);
                }
            }
        } else if (this.selectedObject instanceof ReportColumn) {
            try {
                ReportElement relt = ((ReportColumn)this.selectedObject).getFormatCell(row);
                if (relt instanceof ReportCell) {
                    int i;
                    ReportTable mainTable;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, row);
                    cell.setAlign(align);
                    ((ReportColumn)this.selectedObject).addFormattedCell(cell);
                    ReportTable table = mainTable = this.report.getReportTables().elementAt(0);
                    for (i = 0; i < tree.size(); ++i) {
                        if (!(table instanceof ReportTreeTable)) continue;
                        table = ((ReportTreeTable)table).getSubTable(tree.elementAt(i));
                    }
                    for (i = 0; i < table.getColumnCount() && table.getColumn(i) != this.selectedObject; ++i) {
                    }
                    mainTable.getColumn(i).addFormattedCell(row, tree, cell);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Failed to add formatted cell", e);
            }
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltFontBold(boolean doBold) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            if (this.isDesignMode) {
                this.designPanel.rulerPanel.groupFormatSetFontBold(doBold);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.isDesignMode) {
            Font font = this.selectedObject.getRefFont();
            int style = 0;
            if (doBold) {
                ++style;
            }
            if (font.isItalic()) {
                style += 2;
            }
            this.selectedObject.setFont(FontTable.newFont(font.getName(), style, font.getSize()));
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltFontItalic(boolean doItalic) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            if (this.isDesignMode) {
                this.designPanel.rulerPanel.groupFormatSetFontItalic(doItalic);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.isDesignMode) {
            Font font = this.selectedObject.getRefFont();
            int style = 0;
            if (doItalic) {
                style += 2;
            }
            if (font.isBold()) {
                ++style;
            }
            this.selectedObject.setFont(FontTable.newFont(font.getName(), style, font.getSize()));
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltUnderline(boolean doUnderline) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            if (this.isDesignMode) {
                this.designPanel.rulerPanel.groupFormatSetFontUnderline(doUnderline);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.isDesignMode) {
            this.selectedObject.setUnderline(doUnderline);
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltFontSize(int size) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            if (this.isDesignMode) {
                this.designPanel.rulerPanel.groupFormatSetFontSize(size);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.isDesignMode) {
            Font font = this.selectedObject.getRefFont();
            this.selectedObject.setFont(FontTable.newFont(font.getName(), font.getStyle(), size));
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltFontFace(String fontFace) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            if (this.isDesignMode) {
                this.designPanel.rulerPanel.groupFormatSetFontFace(fontFace);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.hasNoSelectedObject()) {
            return;
        }
        if (this.isDesignMode) {
            Font font = this.selectedObject.getRefFont();
            this.selectedObject.setFont(FontTable.newFont(fontFace, font.getStyle(), font.getSize()));
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltVAlign(short align) {
        this.setEltVAlign(align, 0, null);
    }

    public void setEltVAlign(short align, int row, Vector<Integer> tree) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            if (this.isDesignMode) {
                this.designPanel.rulerPanel.groupFormatSetVAlign(align);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.isDesignMode) {
            this.selectedObject.setVAlign(align);
        } else if (this.selectedObject instanceof ReportCell) {
            ReportElement elt = this.selectedPanel.getElement();
            if (elt instanceof ReportTable) {
                this.selectedObject.setVAlign(align);
            } else if (elt instanceof ReportSection) {
                if (((ReportSection)elt).hasSectionCell((ReportCell)this.selectedObject, tree) || ((ReportSection)elt).hasFormattedCell((ReportCell)this.selectedObject, tree)) {
                    this.selectedObject.setVAlign(align);
                } else {
                    ReportCell newCell = new ReportCell();
                    newCell.copy((ReportCell)this.selectedObject);
                    newCell.setVAlign(align);
                    ((ReportSection)elt).addFormattedCell(newCell, (ReportCell)this.selectedObject, tree);
                }
            }
        } else if (this.selectedObject instanceof ReportColumn) {
            try {
                ReportElement relt = ((ReportColumn)this.selectedObject).getFormatCell(row);
                if (relt instanceof ReportCell) {
                    int i;
                    ReportTable mainTable;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, row);
                    cell.setVAlign(align);
                    ((ReportColumn)this.selectedObject).addFormattedCell(cell);
                    ReportTable table = mainTable = this.report.getReportTables().elementAt(0);
                    for (i = 0; i < tree.size(); ++i) {
                        if (!(table instanceof ReportTreeTable)) continue;
                        table = ((ReportTreeTable)table).getSubTable(tree.elementAt(i));
                    }
                    for (i = 0; i < table.getColumnCount() && table.getColumn(i) != this.selectedObject; ++i) {
                    }
                    mainTable.getColumn(i).addFormattedCell(row, tree, cell);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Failed to add formated cell", e);
            }
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltBackgroundColor() {
        this.setEltBackgroundColor(0, null, false);
    }

    public void setEltBackgroundColor(boolean forLine) {
        this.setEltBackgroundColor(0, null, forLine);
    }

    public void setEltBackgroundColor(int row, Vector<Integer> tree) {
        this.setEltBackgroundColor(row, tree, false);
    }

    private void setEltBackgroundColor(int row, Vector<Integer> tree, boolean forLine) {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            Color initBgColor = this.designPanel.rulerPanel.groupFormatInitBackgroundColor();
            ColorDialog colorDialog = new ColorDialog(this, true, 1, initBgColor, 0, null, forLine);
            colorDialog.setVisible(true);
            return;
        }
        if (forLine && !(this.selectedObject instanceof ReportLine)) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a line object first!"));
            return;
        }
        if (!forLine && this.selectedObject instanceof ReportLine) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("This option is not available for Line, please use 'Line Color' option!"));
            return;
        }
        ColorDialog colorDialog = new ColorDialog(this, true, 1, this.selectedObject.getBgColor(), row, tree, forLine);
        colorDialog.setVisible(true);
    }

    public void setEltWebLink() {
        if (!(this.selectedObject != null && (this.selectedObject instanceof ReportCell || this.selectedObject instanceof ReportColumn) || this.groupFormatFlag())) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            HyperLinkDialog linkDialog = new HyperLinkDialog(this, "", "", "");
            linkDialog.setVisible(true);
            if (!linkDialog.isModified()) {
                return;
            }
            this.designPanel.rulerPanel.groupFormatSetWebLink(linkDialog.getLink(), linkDialog.getHint(), linkDialog.getTarget());
            this.setModified();
            this.setIsUndoEnabled(false);
            this.menuBar.setUndoEnabled(false);
            return;
        }
        HyperLinkDialog linkDialog = new HyperLinkDialog(this, this.selectedObject.getLink(), this.selectedObject.getHint(), this.selectedObject.getTarget());
        linkDialog.setVisible(true);
        if (!linkDialog.isModified()) {
            return;
        }
        this.selectedObject.setLink(linkDialog.getLink());
        this.selectedObject.setHint(linkDialog.getHint());
        this.selectedObject.setTarget(linkDialog.getTarget());
        this.selectedObject.setDrillDownName(null);
        this.setModified();
        this.setIsUndoEnabled(false);
        this.menuBar.setUndoEnabled(false);
    }

    public void setEltDrillDownLink() {
        if (this.selectedObject == null || this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.report.currentNode.getChildCount() <= 0) {
            String msg = LanguageEncoder.getText("No drill-down report defined.") + "\n" + LanguageEncoder.getText("Please create a drill-down report first.");
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        Vector<DrillDownNode> vec = new Vector<DrillDownNode>();
        for (int i = 0; i < this.report.currentNode.getChildCount(); ++i) {
            if (this.report.currentNode.getChildAt(i).isCrossTabDrillDown()) continue;
            vec.addElement(this.report.currentNode.getChildAt(i));
        }
        Object[] choices = new DrillDownNode[vec.size() + 1];
        choices[0] = new DrillDownNode("");
        choices[0].setDomainPath(this.relativeDomainPath);
        Object defaultSelection = choices[0];
        for (int i = 0; i < vec.size(); ++i) {
            choices[i + 1] = (DrillDownNode)vec.elementAt(i);
            if (this.selectedObject.getDrillDownName() == null || !this.selectedObject.getDrillDownName().equals(((DrillDownNode)choices[i + 1]).getName())) continue;
            defaultSelection = choices[i + 1];
        }
        DrillDownNode selected = (DrillDownNode)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please choose a drill-down report:"), LanguageEncoder.getText("Insert Drill-Down Link"), -1, null, choices, defaultSelection);
        if (selected == null) {
            return;
        }
        if (selected.getUserObject().equals("")) {
            this.selectedObject.setLink("");
            this.selectedObject.setDrillDownName(null);
        } else {
            this.selectedObject.setLink(selected.getFileName());
            this.selectedObject.setDrillDownName(selected.getName());
        }
        this.setModified();
        this.setIsUndoEnabled(false);
        this.menuBar.setUndoEnabled(false);
    }

    public void setEltZIndex() {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            ZIndexDialog dialog = new ZIndexDialog(this, null);
            dialog.setVisible(true);
            if (!dialog.isModified()) {
                return;
            }
            this.designPanel.rulerPanel.groupFormatSetZIndex(dialog.getZIndex());
            this.setModified();
            return;
        }
        ZIndexDialog dialog = new ZIndexDialog(this, this.selectedObject);
        dialog.setVisible(true);
        if (!dialog.isModified()) {
            return;
        }
        this.selectedObject.setZ(dialog.getZIndex());
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltHeight() {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            HeightDialog dialog = new HeightDialog(this, null);
            dialog.setVisible(true);
            if (!dialog.isModified()) {
                return;
            }
            this.designPanel.rulerPanel.groupFormatSetHeight(dialog.getTheHeight());
            this.setModified();
            return;
        }
        HeightDialog dialog = new HeightDialog(this, this.selectedObject);
        dialog.setVisible(true);
        if (!dialog.isModified()) {
            return;
        }
        this.selectedObject.setHeight(dialog.getTheHeight());
        this.setModified();
        this.menuBar.setUndoEnabled(true);
        this.updatePanel();
        this.updateReportExplorer();
        this.designPanel.rulerPanel.yRuler.updateYRuler();
    }

    public void editEltAttributes() {
        if (this.selectedObject == null && this.hasNoSelectedObject()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            int type = this.designPanel.rulerPanel.getGroupEditElementType();
            if (type == -1) {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Group Editing option is not available!"));
                return;
            }
            if (type != -1) {
                if (type != 4 && type != 5 && type != 3 && type != 6) {
                    return;
                }
                GroupFormatDialog dialog = new GroupFormatDialog(this, type);
                dialog.setVisible(true);
                this.setIsUndoEnabled(true);
                this.setModified();
            }
            return;
        }
        if (this.selectedObject == null) {
            return;
        }
        int type = ReportElement.findElementType(this.selectedObject);
        if (type != 3 && type != 0 && type != 10 && type != 11 && type != 4 && type != 5 && type != 6) {
            this.setModified();
            this.menuBar.setUndoEnabled(true);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Attribute editing option is not available for this report element!"));
            return;
        }
        ElementFormatDialog dialog = new ElementFormatDialog(this, this.selectedObject);
        dialog.setVisible(true);
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltCustomID() {
        if (this.selectedObject == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        SetCustomIDDialog dialog = new SetCustomIDDialog(this, this.selectedObject);
        dialog.setVisible(true);
        if (!dialog.isModified()) {
            return;
        }
        if (this.report.customIDExists(dialog.getCustomID())) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("This Custom ID already exists!"));
            return;
        }
        this.selectedObject.setCustomID(dialog.getCustomID());
        this.setModified();
        this.updateReportExplorer();
    }

    public void setEltStyleClassName() {
        if (this.selectedObject == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        SetStyleClassNameDialog dialog = new SetStyleClassNameDialog(this, this.selectedObject);
        dialog.setVisible(true);
        if (!dialog.isModified()) {
            return;
        }
        this.selectedObject.setStyleName(dialog.getStyleName());
        this.setModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStyleSheet() {
        DHTMLReport export = new DHTMLReport(this.report);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(2048);
        try {
            String cssDir = this.getBrowseDirectories().getCSSDir();
            OpenFileDialog fDialog = new OpenFileDialog(this, LanguageEncoder.getText("Export Style Sheet"), cssDir, new String[]{"CSS"}, cssDir);
            fDialog.setVisible(true);
            String selectedFile = fDialog.getSelectedFile();
            if (selectedFile != null) {
                this.getBrowseDirectories().setCSSDir(fDialog.getCurrentDirectory());
                if (!selectedFile.toUpperCase().endsWith(".CSS")) {
                    selectedFile = selectedFile + ".css";
                }
                if (!OverWriteDialog.continueSave(this, selectedFile)) {
                    return;
                }
            } else {
                return;
            }
            PrintStream out = new PrintStream(outstream);
            out.print(export.writeStyleSheet());
            out.flush();
            out.close();
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.output(this.subFilesTable, outstream.toByteArray(), selectedFile);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Failed to export style sheet", ex);
            this.errorMessage(ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to export style sheet", ex);
            this.errorMessage(ex.getMessage());
        }
        finally {
            try {
                outstream.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Cannot close output stream", ex);
                this.errorMessage(ex.getMessage());
            }
        }
    }

    public void setEltDualColors() {
        if (!(this.selectedObject != null && this.selectedObject instanceof ReportColumn || this.groupFormatFlag())) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a column first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            ReportColumn initColumn = this.designPanel.rulerPanel.groupFormatDualColorsInitColumn();
            DualColorsDialog secDialog = new DualColorsDialog(this, initColumn);
            secDialog.setVisible(true);
            if (!secDialog.isModified()) {
                return;
            }
            this.designPanel.rulerPanel.groupFormatSetColumnDualColors(secDialog.getRowIndex(), secDialog.getRowBreak(), secDialog.getDualColorColInfoIndex(), secDialog.getBackgroundColor(), secDialog.getFontColor(), secDialog.getFontStyle(), secDialog.isUnderline());
            this.setModified();
            return;
        }
        ReportColumn col = (ReportColumn)this.selectedObject;
        DualColorsDialog secDialog = new DualColorsDialog(this, col);
        secDialog.setVisible(true);
        if (!secDialog.isModified()) {
            return;
        }
        col.setAlternateRow(secDialog.getRowIndex());
        col.setDualColorOnRowBreak(secDialog.getRowBreak());
        col.setDualColorColInfoIndex(secDialog.getDualColorColInfoIndex());
        col.setBgColor2(secDialog.getBackgroundColor());
        col.setFontColor2(secDialog.getFontColor());
        col.setFont2(secDialog.getFontStyle());
        col.setStyleName2(secDialog.getStyleName());
        col.setUnderline2(secDialog.isUnderline());
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setEltFont() {
        if (!(this.selectedObject != null && (this.selectedObject instanceof ReportCell || this.selectedObject instanceof ReportColumn) || this.groupFormatFlag())) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        SetFontDialog setFontDialog = new SetFontDialog(this);
        setFontDialog.setVisible(true);
    }

    public void setEltLineThickness() {
        if (this.selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            SetBorderDialog setBorderDialog = new SetBorderDialog(this, true);
            setBorderDialog.setVisible(true);
            return;
        }
        if (!(this.selectedObject instanceof ReportLine) && !(this.selectedObject instanceof ReportGrid)) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a Line object first!"));
            return;
        }
        SetBorderDialog setBorderDialog = new SetBorderDialog(this, true);
        setBorderDialog.setVisible(true);
    }

    public void setEltBorder() {
        if (!(this.selectedObject != null && (this.selectedObject instanceof ReportCell || this.selectedObject instanceof ReportColumn) || this.groupFormatFlag())) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            SetBorderDialog setBorderDialog = new SetBorderDialog(this, false);
            setBorderDialog.setVisible(true);
            return;
        }
        if (this.selectedObject instanceof ReportLine || this.selectedObject instanceof ReportGrid) {
            this.setEltLineThickness();
            return;
        }
        if (this.selectedObject instanceof TableOfContents) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("'Border' option is not available for TableOfContents!"));
            return;
        }
        SetBorderDialog setBorderDialog = new SetBorderDialog(this, false);
        setBorderDialog.setVisible(true);
    }

    public void setEltRotation() {
        if (!(this.selectedObject != null && (this.selectedObject instanceof ReportCell || this.selectedObject instanceof ReportColumn) || this.groupFormatFlag())) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a cell / column first!"));
            return;
        }
        if (this.selectedObject != null && this.selectedObject.isLocked()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("The position of this element is locked!"));
            return;
        }
        RotationDialog rotationDialog = new RotationDialog(this, this.selectedObject);
        rotationDialog.setVisible(true);
    }

    public void setEltBounds() {
        this.setEltBounds(0);
    }

    public void setEltBounds(int row) {
        if (!(this.selectedObject != null && (this.selectedObject instanceof ReportCell || this.selectedObject instanceof ReportColumn) || this.groupFormatFlag())) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a cell / column first!"));
            return;
        }
        if (this.selectedObject != null && this.selectedObject.isLocked()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("The position of this element is locked!"));
            return;
        }
        SetBoundsDialog setBoundsDialog = new SetBoundsDialog(this, this.selectedObject, row);
        setBoundsDialog.setVisible(true);
    }

    public void setSectionStyle(ReportElementPanel panel, ReportElement elt, boolean b) {
        if (panel.getElement() instanceof ReportSection) {
            ReportSection rs = (ReportSection)panel.getElement();
            if (elt instanceof ReportCell) {
                if (b) {
                    rs.setSectionStyle((ReportCell)elt);
                } else {
                    rs.setSectionStyle(null);
                }
            } else {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a Report Cell Object"));
            }
        } else if (panel.getElement() instanceof ReportTable) {
            ReportTable rt = (ReportTable)panel.getElement();
            if (elt instanceof ReportColumn) {
                if (b) {
                    rt.setSectionStyle((ReportColumn)elt);
                } else {
                    rt.setSectionStyle(null);
                }
            } else {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a Report Column Object"));
            }
        }
    }

    public void setColumnWrapInfo() {
        if (this.report.getReportType() != 0 && this.report.getReportType() != 4 && this.report.getReportType() != 1) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("This feature only works for columnar report"));
            return;
        }
        if (this.report.getColumnWrap() == null) {
            JMessageDialog msgDialog = new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Original report format will be lost, do you want to proceed?"), 2);
            int response = msgDialog.getResponse();
            if (response == 5) {
                return;
            }
            this.setInsertColumnWrap();
            return;
        }
        ColumnWrapDialog wrapDialog = new ColumnWrapDialog(this);
        wrapDialog.setVisible(true);
    }

    public void setLineStyle(JPanel panel) {
        if (this.selectedObject == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a cell / column first!"));
            return;
        }
        LineDialog lineDialog = new LineDialog(this, this.selectedObject);
        lineDialog.setVisible(true);
        if (lineDialog.isModified()) {
            this.setModified();
            this.repaintPanel(panel);
        }
    }

    public void setEltText() {
        this.markUndoCheckPoint();
        this.setEltText(this.selectedPanel);
    }

    public boolean setEltText(JPanel panel) {
        this.createBackupReport();
        if (this.selectedObject != null && this.selectedObject instanceof ReportSection && "Master Section".equals(this.selectedObject.getText())) {
            try {
                JPanel temp = panel;
                ReportSection ms = (ReportSection)this.selectedObject;
                ReportMenuBar oldMenu = this.menuBar;
                if (this.masterSectionDialog == null) {
                    this.masterSectionDialog = new MasterSectionDialog(this);
                }
                this.masterSectionDialog.setParentPanel(temp);
                this.masterSectionDialog.updateHeight();
                this.resetSelectedObject();
                this.menuBar = (ReportMenuBar)this.masterSectionDialog.getJMenuBar();
                this.masterSectionDialog.setVisible(true, oldMenu.paste.isEnabled());
                oldMenu.setPasteEnabled(this.menuBar.paste.isEnabled());
                this.menuBar = oldMenu;
                if (ms.getMinWidth() > 0.0) {
                    ms.setWidth(ms.getMinWidth());
                }
                this.repaintPanel(temp);
                try {
                    ((ReportElementPanel)temp).updateRulers();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to update rulers", ex);
                }
                return true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to edit master section", ex);
                this.errorMessage(LanguageEncoder.getText("Failed to edit master section, please re-open this report and try again."));
                return false;
            }
        }
        if (this.selectedObject != null && this.selectedObject instanceof SubReportObject) {
            if (this.subReports != null) {
                for (int i = 0; i < this.subReports.size(); ++i) {
                    SubReportObject selectedSub = (SubReportObject)this.selectedObject;
                    SubReportObject tempSub = this.subReports.elementAt(i);
                    if (tempSub == null || selectedSub.getFileName() == null || !selectedSub.getFileName().equals(tempSub.getFileName()) || i > this.reportDesignerPane.getTabCount() - 3) continue;
                    this.reportDesignerPane.setSelectedIndex(i + 1);
                    return true;
                }
            }
            return false;
        }
        if (this.selectedObject != null && this.selectedObject instanceof TableOfContents) {
            this.setEltTableOfContents(panel, false);
            return true;
        }
        if (this.selectedObject == null || this.selectedObject instanceof ReportSection || this.selectedObject instanceof ReportTable) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return false;
        }
        if (this.selectedObject instanceof ReportGrid || this.selectedObject instanceof ReportLine) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return false;
        }
        if (this.selectedObject instanceof ReportChartObject) {
            this.setModified();
            return this.setEltChart(panel);
        }
        if (this.selectedObject instanceof ReportImage) {
            this.setEltImage(panel);
            return true;
        }
        if (this.selectedObject instanceof ReportRTFObject) {
            this.setEltRTF(panel, false);
            return true;
        }
        if (this.selectedObject instanceof ReportCell) {
            ReportCell cell = (ReportCell)this.selectedObject;
            if (this.selectedObject instanceof ColumnHeader) {
                NewEditDialog editDialog = new NewEditDialog(this, null, null, cell.getText(), LanguageEncoder.getText("Edit Formula") + " " + cell.getText());
                editDialog.setVisible(true);
                ((ColumnHeader)this.selectedObject).isFormula = false;
                if (!editDialog.isModified) {
                    return false;
                }
            } else if (this.selectedObject instanceof RBColumnHeader) {
                NewEditDialog editDialog = new NewEditDialog(this, null, null, cell.getText(), LanguageEncoder.getText("Edit Formula") + " " + cell.getText());
                editDialog.setVisible(true);
                ((RBColumnHeader)this.selectedObject).isFormula = false;
                if (!editDialog.isModified) {
                    return false;
                }
            } else {
                String title = LanguageEncoder.getText("Edit") + " ";
                if (cell.getFormulaName() != null) {
                    title = title + LanguageEncoder.getText("Formula") + " " + cell.getFormulaName();
                }
                NewEditDialog editDialog = new NewEditDialog(this, cell.getFormulaObj(), null, cell.getText(), title);
                editDialog.setVisible(true);
                if (!editDialog.isModified) {
                    return false;
                }
            }
        } else if (this.selectedObject instanceof ReportColumn) {
            try {
                ReportColumn col = (ReportColumn)this.selectedObject;
                int colIndex = this.report.getColInfoIndex(col);
                if (colIndex < 0) {
                    return false;
                }
                ColInfo colInfo = this.report.colInfo[colIndex];
                if (colInfo.getFormulaObj() == null) {
                    return false;
                }
                NewEditDialog editDialog = new NewEditDialog(this, colInfo.getFormulaObj(), null, null, LanguageEncoder.getText("Edit Formula") + " " + colInfo.getFormulaObj().getName());
                editDialog.setVisible(true);
                if (!editDialog.isModified) {
                    return false;
                }
                this.setReport(this.report.updateColInfo(this.report.colInfo, false));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to edit formula", ex);
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), IOUtil.getStackTrace(ex));
                return false;
            }
        }
        this.setModified();
        if (!this.isDesignMode) {
            this.repaintPanel(panel);
        }
        this.repaintPanel();
        return true;
    }

    public void setEltSecurity() {
        if (this.selectedObject == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.selectedObject instanceof ReportSection) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Security cannot be set on a report section. Please select an object and try again."));
            return;
        }
        if (this.selectedObject instanceof ReportLine || this.selectedObject instanceof ReportGrid) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Security cannot be set on a line or a rectangle object. Please select an object and try again."));
            return;
        }
        SecurityDialog securityDialog = new SecurityDialog(this, this.selectedObject);
        securityDialog.setVisible(true);
        if (securityDialog.isModified()) {
            this.selectedObject.setSecurityMap(securityDialog.getSecurityMap());
            this.setModified();
            this.repaintPanel(this.selectedPanel);
            this.do_Refresh();
        }
    }

    public void setSectionVisible(boolean b) {
        if (this.selectedPanel == null) {
            return;
        }
        this.selectedPanel.setElementVisible(b);
        this.menuBar.setUndoEnabled(true);
        this.setModified();
        this.designPanel.rulerPanel.yRuler.updateYRuler();
        this.updatePanel();
    }

    public void setSectionVisible(boolean b, ReportTableElement elt) {
        elt.setVisible(b);
        this.menuBar.setUndoEnabled(true);
        this.setModified();
        this.designPanel.rulerPanel.yRuler.updateYRuler();
        this.updatePanel();
    }

    public void setEltVisible(boolean b) {
        this.setEltVisible(b, this.selectedPanel, 0, null);
    }

    public void setEltVisible(boolean b, JPanel panel, int row, Vector<Integer> tree) {
        if (this.selectedObject == null || this.selectedObject instanceof ReportCell) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a column / section first!"));
            return;
        }
        if (this.selectedObject instanceof ReportColumn) {
            this.setColumnVisible(b, panel, row, tree);
        }
        if (this.selectedObject instanceof ReportTableElement) {
            this.setSectionVisible(b);
        }
    }

    public void selectRow(ReportElement elt, JPanel panel) {
        if (this.selectedObject == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a cell first"));
            return;
        }
        ((ReportElementPanel)panel).setSelectRow(elt);
    }

    public void selectColumn(ReportElement elt, JPanel panel) {
        if (this.selectedObject == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a cell first"));
            return;
        }
        ((ReportElementPanel)panel).setSelectColumn(elt);
    }

    private ReportElement[] getCellAndColumns(ReportElement[] elt) {
        if (elt == null) {
            return null;
        }
        Vector<ReportElement> vec = new Vector<ReportElement>();
        for (ReportElement element : elt) {
            if (element instanceof ReportImage || !(element instanceof ReportCell) && !(element instanceof ReportColumn)) continue;
            vec.addElement(element);
        }
        ReportElement[] ret = new ReportElement[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            ret[i] = (ReportElement)vec.elementAt(i);
        }
        return ret;
    }

    public void swapReportCell() {
        ReportElement[] elt;
        ReportElementPanel panel;
        int i;
        Vector<ReportElement[]> eltList = new Vector<ReportElement[]>();
        Vector<ReportElementPanel> eltPanel = new Vector<ReportElementPanel>();
        String msg = null;
        if (this.groupFormatFlag()) {
            for (i = 0; i < this.designPanel.rulerPanel.panelList.size() - 1; ++i) {
                panel = (ReportElementPanel)this.designPanel.rulerPanel.panelList.elementAt(i);
                if (panel.groupFormat.size() == 0) continue;
                elt = this.designPanel.rulerPanel.getSelectedGroup(panel);
                if ((elt = this.getCellAndColumns(elt)) == null || elt.length != 2) continue;
                eltPanel.addElement(panel);
                eltList.addElement(elt);
            }
            if (eltList.size() == 0) {
                msg = LanguageEncoder.getText("Please select 2 cells that you want to swap within a same section!");
            }
        } else {
            ReportElement[] elt2 = this.designPanel.rulerPanel.getSelectedGroup(this.selectedPanel);
            if ((elt2 = this.getCellAndColumns(elt2)) == null || elt2.length != 2) {
                msg = LanguageEncoder.getText("Please select 2 cells that you want to swap within a same section!");
            } else {
                eltPanel.addElement(this.selectedPanel);
                eltList.addElement(elt2);
            }
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        for (i = 0; i < eltList.size(); ++i) {
            panel = (ReportElementPanel)eltPanel.elementAt(i);
            elt = (ReportElement[])eltList.elementAt(i);
            if (panel.getElement() instanceof ReportSection) {
                ReportElement.swapElements(elt[0], elt[1], ((ReportSection)panel.getElement()).getData());
                continue;
            }
            ReportElement.swapElements(elt[0], elt[1], ((ReportTable)panel.getElement()).getTableElements());
        }
        this.setModified();
        if (this.selectedPanel != null) {
            this.repaintPanel(this.selectedPanel);
        }
        this.resetSelectedObject();
        this.deselectGroupOption();
    }

    private void setColumnVisible(boolean b, JPanel panel, int row, Vector<Integer> tree) {
        this.setColumnVisible(this.selectedObject, b, panel, row, tree);
    }

    public void setColumnVisible(ReportElement selectedObject, boolean b, JPanel panel, int row, Vector<Integer> tree) {
        if (selectedObject == null || !(selectedObject instanceof ReportColumn)) {
            return;
        }
        if (this.isDesignMode) {
            ((ReportColumn)selectedObject).setVisible(b);
            this.report.colInfo[this.report.getColInfoIndex((ReportColumn)selectedObject)].setVisible(b);
            ReportElementPanel p = (ReportElementPanel)panel;
            p.unselect(selectedObject);
        } else {
            try {
                ReportElement relt = ((ReportColumn)selectedObject).getFormatCell(row);
                if (relt instanceof ReportCell) {
                    int i;
                    ReportTable mainTable;
                    FormattedCell cell = new FormattedCell((ReportCell)relt, row);
                    cell.setVisible(b);
                    ((ReportColumn)selectedObject).addFormattedCell(cell);
                    ReportTable table = mainTable = this.report.getReportTables().elementAt(0);
                    for (i = 0; i < tree.size(); ++i) {
                        if (!(table instanceof ReportTreeTable)) continue;
                        table = ((ReportTreeTable)table).getSubTable(tree.elementAt(i));
                    }
                    for (i = 0; i < table.getColumnCount() && table.getColumn(i) != selectedObject; ++i) {
                    }
                    mainTable.getColumn(i).addFormattedCell(row, tree, cell);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot add formatted cell", ex);
            }
        }
        this.menuBar.setUndoEnabled(true);
        this.setModified();
        this.repaintPanel(panel);
        this.resetSelectedObject();
    }

    public void setEltFormat() {
        this.setEltFormat(0, null);
    }

    public void setEltFormat(int row, Vector<Integer> tree) {
        if ((this.selectedObject == null || this.selectedObject instanceof ReportSection) && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a cell / column first!"));
            return;
        }
        if (this.groupFormatFlag()) {
            SetWholeGroupDataFormat dataFormat = new SetWholeGroupDataFormat(this);
            dataFormat.setVisible(true);
            return;
        }
        if (this.selectedObject instanceof ReportColumn) {
            if (this.report.getDataType(this.report.getColInfoIndex((ReportColumn)this.selectedObject, tree)) != 15) {
                ReportColumn column = (ReportColumn)this.selectedObject;
                FormatDialog formatDialog = new FormatDialog(this, column.getDataFormat(), this.report.getDataType(this.report.getColInfoIndex(column, tree)));
                formatDialog.setVisible(true);
                if (this.isDesignMode) {
                    column.setDataFormat(formatDialog.getFormat());
                } else {
                    try {
                        ReportElement relt = column.getFormatCell(row);
                        if (relt instanceof ReportCell) {
                            int i;
                            ReportTable mainTable;
                            FormattedCell cell = new FormattedCell((ReportCell)relt, row);
                            cell.setDataFormat(formatDialog.getFormat());
                            column.addFormattedCell(cell);
                            ReportTable table = mainTable = this.report.getReportTables().elementAt(0);
                            for (i = 0; i < tree.size(); ++i) {
                                if (!(table instanceof ReportTreeTable)) continue;
                                table = ((ReportTreeTable)table).getSubTable(tree.elementAt(i));
                            }
                            for (i = 0; i < table.getColumnCount() && table.getColumn(i) != column; ++i) {
                            }
                            mainTable.getColumn(i).addFormattedCell(row, tree, cell);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Failed to add formatted cell", e);
                    }
                }
                this.setModified();
                this.repaintPanel(this.selectedPanel);
            }
        } else if (this.selectedObject instanceof FormattedCell) {
            if (DataType.mapType(((ReportCell)this.selectedObject).getSQLType()) != 15) {
                FormattedCell cell = (FormattedCell)this.selectedObject;
                ReportTable table = this.report.getReportTables().elementAt(0);
                ReportColumn column = table.getColumn(cell.getColumnIndex());
                if (cell.getDataFormat() == null) {
                    cell.setDataFormat(FormatUtil.createFormat(this.report.getDataType(this.report.getColInfoIndex(column)), this.report.getLocale(), this.report.getTimeZone()));
                }
                FormatDialog formatDialog = new FormatDialog(this, cell.getDataFormat(), this.report.getDataType(this.report.getColInfoIndex(column)));
                formatDialog.setVisible(true);
                cell.setDataFormat(formatDialog.getFormat());
                this.setModified();
                this.repaintPanel(this.selectedPanel);
            }
        } else {
            if (this.selectedObject instanceof ColumnHeader) {
                return;
            }
            if (this.selectedObject instanceof ReportCell && DataType.mapType(((ReportCell)this.selectedObject).getSQLType()) != 15) {
                ReportCell cell = (ReportCell)this.selectedObject;
                if (cell.getFormula() == null) {
                    return;
                }
                if (cell.getDataFormat() == null) {
                    cell.setDataFormat(FormatUtil.createFormat(DataType.mapType(cell.getSQLType()), this.report.getLocale(), this.report.getTimeZone()));
                }
                FormatDialog formatDialog = new FormatDialog(this, cell.getDataFormat(), DataType.mapType(cell.getSQLType()));
                formatDialog.setVisible(true);
                if (this.isDesignMode) {
                    cell.setDataFormat(formatDialog.getFormat());
                } else {
                    ReportCell newCell = new ReportCell();
                    newCell.copy(cell);
                    newCell.setDataFormat(formatDialog.getFormat());
                    ReportSection section = (ReportSection)this.selectedPanel.getElement();
                    section.addFormattedCell(newCell, cell, tree);
                }
                this.setModified();
                this.repaintPanel(this.selectedPanel);
            }
        }
    }

    private String createChartFileName(ReportChartObject chartObj) throws Exception {
        if (this.title.equals(SaveReport.VERSIONNAME)) {
            return chartObj.getNewChartName(this.subFilesTable, "CHART_" + System.currentTimeMillis());
        }
        return chartObj.getNewChartName(this.subFilesTable, new File(this.title).getName());
    }

    public boolean isChartEditorVisible() {
        if (this.chartEditor != null && this.chartEditor instanceof ChartEditor) {
            return ((ChartEditor)this.chartEditor).isVisible();
        }
        return false;
    }

    public Object getChartEditor() {
        return this.chartEditor;
    }

    boolean setEltChart(JPanel panel) {
        JMessageDialog msgDialog;
        String rfile;
        String msg = null;
        if (!(this.selectedObject instanceof ReportChartObject)) {
            msg = LanguageEncoder.getText("Please select chart object first!");
        }
        if ((rfile = this.getFileName()) != null && rfile.toUpperCase().endsWith("QRP")) {
            msgDialog = new JMessageDialog((Frame)this, "Question", SAVE_RPT_BEFORE_EDIT_TPL, 2);
            if (!this.saveReportBeforeInsertingChart(msgDialog.getResponse())) {
                return false;
            }
        } else if (rfile == null && this.isModified() && this.isReportOpenedInPakFormat) {
            msgDialog = new JMessageDialog((Frame)this, "Question", SAVE_RPT_BEFORE_INSERTING_CHART, 2);
            if (!this.saveReportBeforeInsertingChart(msgDialog.getResponse())) {
                return false;
            }
            rfile = this.getFileName();
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            this.setInsertChart(false);
            return false;
        }
        try {
            boolean importExistingChart = false;
            boolean createFile = false;
            this.setTitle(this.wait);
            ReportChartObject chartObj = (ReportChartObject)this.selectedObject;
            if (chartObj.getText() == null || chartObj.getText().equals("")) {
                boolean disableSummaryData;
                chartObj.setDomainPath(this.relativeDomainPath);
                ReportCell footerElt = null;
                if (this.selectedPanel.getElement() instanceof ReportSection) {
                    footerElt = ((ReportSection)this.selectedPanel.getElement()).getFirstCBColumnFooter(0);
                }
                boolean bl = disableSummaryData = !this.report.isCrossTabFixedField() || !(this.selectedPanel.getElement() instanceof ReportSection) || footerElt == null || !(footerElt instanceof CBColumnFooter);
                if (!this.report.isShowColumnAggregation()) {
                    disableSummaryData = true;
                }
                InsertChartDialog chartDialog = new InsertChartDialog(this, this.disableChartDataSource, disableSummaryData);
                chartDialog.setVisible(true);
                if (chartDialog.isCancelled()) {
                    this.setTitle(this.title);
                    this.deleteElt();
                    this.setInsertChart(false);
                    return false;
                }
                importExistingChart = chartDialog.importChart();
                String tplName = this.createChartFileName(chartObj);
                chartObj.setText(tplName);
                if (chartDialog.useReportData() || chartDialog.useSummaryData()) {
                    chartObj.setReportDataUsed(true);
                    chartObj.setSummaryDataUsed(chartDialog.useSummaryData());
                    chartObj.setSectionDataIncluded(chartDialog.useSectionData() || chartDialog.useSummaryData());
                } else {
                    chartObj.setReportDataUsed(false);
                }
                createFile = true;
            }
            ReportTable tbl = null;
            ReportCell[] cells = null;
            Report newReport = this.report;
            if (chartObj.isReportDataUsed()) {
                try {
                    if (this.report.isCrossTabFixedField()) {
                        this.displayRow = -1;
                        newReport = this.reloadData(false);
                        newReport.formatTable();
                        this.displayRowState = 2;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to reload data", ex);
                }
                tbl = this.getChartTable(this.selectedPanel, newReport);
                if (chartObj.isSectionDataIncluded()) {
                    cells = this.getChartCells(this.selectedPanel, newReport);
                }
            }
            this.chartEditor = ChartEditor.loadChartEditor(this, newReport, tbl, cells, chartObj.isSummaryDataUsed(), chartObj.getColDataMapping(), this.chartEditor, chartObj.getText(), null, createFile, importExistingChart);
            if (chartObj.getText() == null || chartObj.getText().equals("")) {
                ((ChartEditor)this.chartEditor).reportChartObject = chartObj;
                ((ChartEditor)this.chartEditor).reportChartPanel = this.selectedPanel;
            }
            if (this.masterSectionDialog != null && this.masterSectionDialog.isVisible()) {
                this.masterSectionDialog.setVisible(false);
                if (this.chartEditor instanceof ChartEditor) {
                    ((ChartEditor)this.chartEditor).reopenMasterSection = true;
                    ((ChartEditor)this.chartEditor).reportChartObject = chartObj;
                    ((ChartEditor)this.chartEditor).masterSectionParentPanel = this.masterSectionDialog.getParentPanel();
                }
            }
            if (this.chartEditor instanceof ChartEditor) {
                JMenu menu;
                int j;
                int i;
                JMenuBar chartMenuBar;
                if (((ChartEditor)this.chartEditor).chartPanel.chart != null) {
                    ((ChartEditor)this.chartEditor).chartPanel.setSize(chartObj.getWidthOfElement(), chartObj.getHeightOfElement(), true);
                    ((ChartEditor)this.chartEditor).chartPanel.setRecompute();
                    ((ChartEditor)this.chartEditor).chartPanel.paint(((ChartEditor)this.chartEditor).chartPanel.getGraphics());
                } else if (chartObj.isReportDataUsed()) {
                    ((ChartEditor)this.chartEditor).dispose();
                    this.setTitle(this.title);
                    this.setInsertChart(false);
                    return false;
                }
                if (this.chartMenuItem_menu != null) {
                    chartMenuBar = ((ChartEditor)this.chartEditor).getChartMenuBar();
                    for (i = 0; i < this.chartMenuItem_menu.size(); ++i) {
                        j = this.chartMenuItem_menu.elementAt(i);
                        menu = chartMenuBar.getMenu(j);
                        int k = this.chartMenuItem_item.elementAt(i);
                        JMenuItem item = menu.getItem(k);
                        boolean enabled = this.chartMenuItem_enabled.elementAt(i);
                        item.setEnabled(enabled);
                    }
                }
                if (this.chartMenu_menu != null) {
                    chartMenuBar = ((ChartEditor)this.chartEditor).getChartMenuBar();
                    for (i = 0; i < this.chartMenu_menu.size(); ++i) {
                        j = this.chartMenu_menu.elementAt(i);
                        menu = chartMenuBar.getMenu(j);
                        boolean enabled = this.chartMenu_enabled.elementAt(i);
                        menu.setEnabled(enabled);
                    }
                }
                if (this.chartToolbarItem_item != null) {
                    ChartToolbar chartToolBar = (ChartToolbar)((ChartEditor)this.chartEditor).getChartToolBar();
                    for (i = 0; i < this.chartToolbarItem_item.size(); ++i) {
                        j = this.chartToolbarItem_item.elementAt(i);
                        boolean enabled = this.chartToolbarItem_enabled.elementAt(i);
                        chartToolBar.setEnabled(j, enabled);
                    }
                }
                if (this.chartIO != null) {
                    ((ChartEditor)this.chartEditor).setChartIO(this.chartIO);
                }
                this.setRecentColors(((ChartEditor)this.chartEditor).getRecentColors());
            }
            this.setTitle(this.title);
            this.repaintPanel(panel);
            this.setInsertChart(false);
            return true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to insert chart", ex);
            this.setTitle(this.title);
            this.errorMessage(ex.toString());
            this.setInsertChart(false);
            return false;
        }
    }

    private boolean saveReportBeforeInsertingChart(int response) {
        if (response == 5) {
            this.deleteElt(this.selectedObject, this.selectedPanel, false, 0, null);
            this.deleteElt();
            this.setInsertChart(false);
            return false;
        }
        this.setModified();
        boolean old_state = this.isModified();
        ReportElementPanel tmpPanel = this.selectedPanel;
        ReportElement tmpObject = this.selectedObject;
        this.save(this.isReportOpenedInPakFormat());
        this.selectedObject = tmpObject;
        this.selectedPanel = tmpPanel;
        if (this.isModified()) {
            this.setModified(old_state);
            this.deleteElt(this.selectedObject, this.selectedPanel, false, 0, null);
            this.setInsertChart(false);
            return false;
        }
        return true;
    }

    private ReportTable getChartTable(ReportElementPanel panel, Report newReport) {
        ReportTable tbl = panel.getReportTable();
        if (this.report != newReport) {
            tbl = newReport.getReportTables().elementAt(0);
        }
        if (panel.getElement() instanceof ReportTable) {
            return tbl;
        }
        if (!(tbl instanceof ReportTreeTable)) {
            return tbl;
        }
        if (this.report.getPageHeader().sameSection(panel.getElement(), true) || this.report.getPageFooter().sameSection(panel.getElement(), true) || this.report.getReportHeader().sameSection(panel.getElement(), true) || this.report.getReportFooter().sameSection(panel.getElement(), true)) {
            return tbl;
        }
        for (int i = 0; i < this.report.getReportTables().size(); ++i) {
            ReportTable tmpTbl = this.report.getReportTables().elementAt(i);
            if (!tmpTbl.getHeader().sameSection(panel.getElement(), true) && !tmpTbl.getFooter().sameSection(panel.getElement(), true)) continue;
            return tbl;
        }
        return ((ReportTreeTable)tbl).getSubTable(0);
    }

    private ReportCell[] getChartCells(ReportElementPanel panel, Report newReport) {
        if (panel.getElement() instanceof ReportTable) {
            return null;
        }
        if (this.report == newReport) {
            return ((ReportSection)panel.getElement()).getData();
        }
        if (panel.getElement() == this.report.getPageHeader()) {
            return newReport.getPageHeader().getData();
        }
        if (panel.getElement() == this.report.getPageFooter()) {
            return newReport.getPageFooter().getData();
        }
        if (panel.getElement() == this.report.getReportHeader()) {
            return newReport.getReportHeader().getData();
        }
        if (panel.getElement() == this.report.getReportFooter()) {
            return newReport.getReportFooter().getData();
        }
        for (int i = 0; i < this.report.getReportTables().size(); ++i) {
            ReportTable tmpTbl = this.report.getReportTables().elementAt(i);
            ReportTable tmpTbl2 = newReport.getReportTables().elementAt(i);
            if (tmpTbl.getHeader() == panel.getElement()) {
                return tmpTbl2.getHeader().getData();
            }
            if (tmpTbl.getFooter() == panel.getElement()) {
                return tmpTbl2.getFooter().getData();
            }
            if (!(tmpTbl instanceof ReportMultiSectionTable) || !(tmpTbl2 instanceof ReportMultiSectionTable)) continue;
            LOGGER.finest("Is multi...");
            ReportMultiSectionTable mTable = (ReportMultiSectionTable)tmpTbl;
            ReportMultiSectionTable mTable2 = (ReportMultiSectionTable)tmpTbl2;
            int sectCt = mTable.countRowBreakHeader();
            if (sectCt > mTable2.countRowBreakHeader()) {
                sectCt = mTable2.countRowBreakHeader();
            }
            for (int k = 0; k < sectCt; ++k) {
                if (mTable.getRowBreakHeader(k) == panel.getElement()) {
                    return mTable2.getRowBreakHeader(k).getData();
                }
                if (mTable.getRowBreakFooter(k) != panel.getElement()) continue;
                return mTable2.getRowBreakFooter(k).getData();
            }
        }
        return null;
    }

    boolean setEltImage(JPanel panel) {
        ReportImage image = (ReportImage)this.selectedObject;
        BackgroundImageDialog imageDialog = new BackgroundImageDialog(this, image);
        imageDialog.setVisible(true);
        if (imageDialog.getImageURL() == null) {
            this.deleteElt();
            return false;
        }
        if (imageDialog.isModified()) {
            image.setImageURL(imageDialog.getImageURL(), true);
            if (imageDialog.getRelativeURL() != null) {
                image.setRelativePath(imageDialog.getRelativeURL());
                image.setImagePath(imageDialog.getRelativeURL(), true);
            }
            image.setWidth(imageDialog.getImageWidth(), this.isCm);
            image.setHeight(imageDialog.getImageHeight(), this.isCm);
            this.report.imageSetting = image;
            this.setModified();
            this.repaintPanel(panel);
        }
        return true;
    }

    public void setEltImageOptions() {
        if (this.selectedObject == null || !(this.selectedObject instanceof ReportChartObject)) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a chart object first!"));
            return;
        }
        ReportImage chart = (ReportImage)this.selectedObject;
        ImageOptionDialog imgDialog = new ImageOptionDialog(this, chart);
        imgDialog.setVisible(true);
        chart.setImageType(imgDialog.getImageType());
        chart.setPdfImageType(imgDialog.getPdfImageType());
        chart.setJPEGQuality(imgDialog.getJPEGQuality());
        chart.setPNGCompression(imgDialog.getPNGCompression());
        chart.setGIFTransparent(imgDialog.isGIFTransparent());
        chart.setFlashFrameCount(imgDialog.getFlashFrameCount());
        chart.setFlashFrameRate(imgDialog.getFlashFrameRate());
        if (chart instanceof ReportChartObject) {
            ((ReportChartObject)chart).setExportMapFile(imgDialog.isExportMapFile());
        }
        this.setModified();
    }

    void setEltSubReport(JPanel panel) {
        this.repaintPanel(panel);
        this.wizard = new ReportWizard(this, null, null, false, false);
        this.wizard.init();
        this.wizard.setDBProvider(this.dbProvider);
        this.wizard.setSubReportOp(this.selectedObject, this.selectedPanel);
        if (this.forceNewReport) {
            this.wizard.newReport(false, true, this.wizard.step1);
        } else {
            this.wizard.setVisible(true);
        }
    }

    boolean setEltRTF(JPanel panel, boolean deleteOnCancel) {
        ReportRTFObject rtfObject = (ReportRTFObject)this.selectedObject;
        this.repaintPanel(panel);
        RTFEditorDialog rtfDialog = new RTFEditorDialog(this, rtfObject, this.report != null ? this.report.isAdjustFont() : true);
        rtfDialog.setVisible(true);
        if (rtfDialog.isModified()) {
            this.setModified();
            this.repaintPanel(panel);
        } else if (deleteOnCancel) {
            boolean old_state = this.isModified();
            this.deleteElt();
            this.setModified(old_state);
            return false;
        }
        return true;
    }

    public void getEltProperties() {
        if (this.selectedObject == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        ColumnPropertiesDialog colDialog = new ColumnPropertiesDialog(this, this.selectedObject);
        colDialog.setVisible(true);
    }

    public void deleteElt() {
        this.markUndoCheckPoint();
        this.deleteElt(this.selectedObject, this.selectedPanel, true, 0, null);
    }

    public void deleteElt(int row, Vector<Integer> tree) {
        this.deleteElt(this.selectedObject, this.selectedPanel, true, row, tree);
    }

    public void deleteElt(ReportElement selectedObject, ReportElementPanel selPanel, boolean completeRemove) {
        this.deleteElt(selectedObject, selPanel, completeRemove, 0, null);
    }

    public void deleteElt(ReportElement selectedObject, ReportElementPanel selPanel, boolean completeRemove, int row, Vector<Integer> tree) {
        if (!this.isInsertObject() && this.getFocusOwner() == null && this.masterSectionDialog == null && !this.groupFormatFlag()) {
            return;
        }
        if (selectedObject == null && !this.groupFormatFlag()) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select an object first!"));
            return;
        }
        if (this.report.isCrossTabFixedField()) {
            if (selectedObject instanceof ReportColumn) {
                int colInfoIdx = this.report.getColInfoIndex((ReportColumn)selectedObject);
                ColInfo cInfo = this.report.colInfo[colInfoIdx];
                if (cInfo.isColumnBreakValue() || cInfo.isColumnBreak()) {
                    new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You cannot remove column-break/ column-break value column!"));
                    return;
                }
            } else if (selPanel.getElement() instanceof CrossTabReportSection && !this.isAllowCrosstabElementMove()) {
                new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You cannot remove element from CrossTab report section!"));
                return;
            }
        }
        if (completeRemove && !(selectedObject instanceof GuideLine)) {
            this.designPanel.rulerPanel.deleteGroup();
            this.deleteElt(selectedObject, selPanel, false);
            this.clearAllSelectedObjects();
            selPanel.clearAllDraggedObjects();
            this.resetSelectedObject(true);
            return;
        }
        if (selectedObject instanceof ReportColumn) {
            this.setColumnVisible(selectedObject, false, selPanel, row, tree);
            if (completeRemove) {
                this.resetSelectedObject();
            }
        } else if (selectedObject instanceof ReportSection) {
            if (!"Master Section".equals(selectedObject.getText()) || this.masterSectionDialog == null || !this.masterSectionDialog.isVisible()) {
                this.setSectionVisible(false);
                if (completeRemove) {
                    this.resetSelectedObject();
                }
            }
        } else if (selectedObject instanceof ReportCell) {
            FormattedRow formattedRow;
            if (selectedObject instanceof ColumnWrap) {
                this.report.setColumnWrap(null);
            }
            if (selectedObject instanceof ReportLine || selectedObject instanceof ReportGrid) {
                if (this.isDesignMode) {
                    Vector<JPanel> pList = this.designPanel.rulerPanel.panelList;
                    if (this.designPanel.rulerPanel.getMasterSectionPanel() != null) {
                        pList = new Vector();
                        for (int i = 0; i < this.designPanel.rulerPanel.panelList.size(); ++i) {
                            pList.addElement(this.designPanel.rulerPanel.panelList.elementAt(i));
                        }
                        pList.insertElementAt(this.designPanel.rulerPanel.getMasterSectionPanel(), pList.size() - 1);
                    }
                    if (selectedObject instanceof GuideLine) {
                        GuideLine gl = (GuideLine)selectedObject;
                        if (gl.isVertical()) {
                            ReportLine head = gl.getHeadNode();
                            ((GuideLine)head).removeAll();
                            int index = this.report.vGuideLines.indexOf(head);
                            this.designPanel.rulerPanel.xRuler.xgl.removeElementAt(index);
                            this.report.vGuideLines.removeElementAt(index);
                        } else {
                            gl.removeAll();
                            int index = this.report.hGuideLines.indexOf(gl);
                            this.designPanel.rulerPanel.yRuler.ygl.removeElementAt(index);
                            this.report.hGuideLines.remove(gl);
                        }
                        this.setIsUndoEnabled(false);
                        this.menuBar.setUndoEnabled(false);
                    }
                    new GridLine(pList).remove(selectedObject);
                    if (completeRemove) {
                        this.resetSelectedObject();
                    }
                    this.setModified();
                    this.repaintPanel();
                } else if (selPanel.getElement() instanceof ReportTable) {
                    ReportTable tbl = this.report.getReportTables().elementAt(0);
                    formattedRow = tbl.getFormattedRow(row, tree);
                    if (formattedRow != null) {
                        formattedRow.removeElement(selectedObject);
                        if (formattedRow.getNumberOfElements() == 0) {
                            formattedRow.setRowElements(null);
                        }
                    }
                    if ((formattedRow = ((ReportTable)selPanel.getElement()).getFormattedRow(row, tree)) != null) {
                        formattedRow.removeElement(selectedObject);
                        if (formattedRow.getNumberOfElements() == 0) {
                            formattedRow.setRowElements(null);
                        }
                    }
                    if (completeRemove) {
                        this.resetSelectedObject();
                    }
                    this.setModified();
                    this.repaintPanel(selPanel);
                } else if (selPanel.getElement() instanceof ReportSection) {
                    ((ReportSection)selPanel.getElement()).deleteSectionCell((ReportCell)selectedObject, tree);
                }
            } else if (selPanel.getElement() instanceof ReportSection) {
                ReportSection section = (ReportSection)selPanel.getElement();
                if (this.isDesignMode) {
                    section.removeData((ReportCell)selectedObject);
                } else {
                    section.deleteSectionCell((ReportCell)selectedObject, tree);
                }
                if (completeRemove) {
                    this.resetSelectedObject();
                }
                this.setModified();
                this.repaintPanel(selPanel);
            } else if (selPanel.getElement() instanceof ReportTable && selectedObject instanceof ReportImage) {
                selPanel.getOriginalReportTable().removeImage((ReportImage)selectedObject);
                if (completeRemove) {
                    this.resetSelectedObject();
                }
                this.setModified();
                this.repaintPanel(selPanel);
            } else if (selPanel.getElement() instanceof ReportTable && selectedObject instanceof SubReportObject) {
                selPanel.getOriginalReportTable().removeSubReport((SubReportObject)selectedObject);
                if (completeRemove) {
                    this.resetSelectedObject();
                }
                this.setModified();
                this.repaintPanel(selPanel);
            } else if (selPanel.getElement() instanceof ReportTable && selectedObject instanceof ReportRTFObject) {
                selPanel.getOriginalReportTable().removeRTFObject((ReportRTFObject)selectedObject);
                if (completeRemove) {
                    this.resetSelectedObject();
                }
                this.setModified();
                this.repaintPanel(selPanel);
            } else if (selPanel.getElement() instanceof ReportTable) {
                ReportTable tbl = this.report.getReportTables().elementAt(0);
                formattedRow = tbl.getFormattedRow(row, tree);
                if (formattedRow != null) {
                    formattedRow.removeElement(selectedObject);
                    if (formattedRow.getNumberOfElements() == 0) {
                        formattedRow.setRowElements(null);
                    }
                }
                if ((formattedRow = ((ReportTable)selPanel.getElement()).getFormattedRow(row, tree)) != null) {
                    formattedRow.removeElement(selectedObject);
                    if (formattedRow.getNumberOfElements() == 0) {
                        formattedRow.setRowElements(null);
                    }
                }
                if (completeRemove) {
                    this.resetSelectedObject();
                }
                this.setModified();
                this.repaintPanel(selPanel);
            }
        }
        if (completeRemove && !(selectedObject instanceof GuideLine) && !(selectedObject instanceof ReportSection)) {
            this.menuBar.setUndoEnabled(true);
        }
        if (!(selectedObject instanceof ReportColumn)) {
            this.explorer.deleteNode(selectedObject.getID());
        }
        this.resetSelectedObject(true);
    }

    void autoFitColumns() {
        double pageW;
        if (this.report == null) {
            String msg = LanguageEncoder.getText("Please open a report first!");
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        double minX = this.report.getMinWidth();
        if (minX <= (pageW = this.report.getActualPageWidth())) {
            return;
        }
        JMessageDialog msgDialog = new JMessageDialog((Frame)this, "Auto Fit Columns", LanguageEncoder.getText("Your report exceeds the page width!\n") + LanguageEncoder.getText("Do you want to shrink it to 1 page?"), 2);
        int response = msgDialog.getResponse();
        if (response == 5) {
            return;
        }
        msgDialog = new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("format will be lost, do you want to proceed?"), 2);
        response = msgDialog.getResponse();
        if (response == 5) {
            return;
        }
        this.report.resize(pageW / minX, 1.0);
        this.setModified();
        this.updatePanel();
    }

    private void checkDataSource() {
        if (this.report == null) {
            String msg = LanguageEncoder.getText("Please only a report first!");
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (this.report.sourceData == 0 && this.report.getOriginalSourceData() >= 0) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Data source not found!") + " " + LanguageEncoder.getText("Please update your data source!"));
        }
    }

    void pageSetup() {
        String msg = null;
        ReportCanvas canvas = null;
        if (this.report == null) {
            msg = LanguageEncoder.getText("Please open a report first!");
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (this.report != null && this.previewPanel.viewer != null) {
            canvas = this.previewPanel.viewer.getReportCanvas();
        }
        try {
            PageSetupDialog pageSetup = new PageSetupDialog(this);
            pageSetup.setVisible(true);
            if (pageSetup.isModified()) {
                if (this.groupFormatFlag()) {
                    this.deselectGroupOption();
                }
                this.setModified();
                if (this.reportDesignerPane.getSelectedIndex() == this.reportDesignerPane.getTabCount() - 1) {
                    if (canvas != null) {
                        canvas.resetPages();
                    }
                    this.previewPanel.updatePanel();
                    this.setUpdateReport(false);
                    this.validate();
                    this.repaint();
                } else {
                    this.updateDesignPanelUI();
                }
                this.repaintPanel();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to setup page", ex);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), IOUtil.getStackTrace(ex));
            return;
        }
    }

    @Override
    public void goToNextPage() {
        if (this.previewPanel != null) {
            this.previewPanel.goToNextPage();
        }
    }

    @Override
    public void goToPreviousPage() {
        if (this.previewPanel != null) {
            this.previewPanel.goToPreviousPage();
        }
    }

    @Override
    public void goToFirstPage() {
        if (this.previewPanel != null) {
            this.previewPanel.goToFirstPage2();
        }
    }

    @Override
    public void goToLastPage() {
        if (this.previewPanel != null) {
            this.previewPanel.goToLastPage2();
        }
    }

    @Override
    public void goTo() {
        if (this.previewPanel != null) {
            this.previewPanel.goTo();
        }
    }

    @Override
    public void goToPageSection(int page, int section) {
        if (this.previewPanel != null) {
            this.previewPanel.goToPageSection(page, section);
        }
    }

    @Override
    public void updatePreviewPanel() {
        this.previewPanel.updatePanel();
        this.repaint();
    }

    @Override
    public void updatePreviewToolBar() {
        if (this.previewPanel != null) {
            this.previewPanel.previewToolBar.setEnabled();
        }
    }

    private boolean isPreviewWindow() {
        if (this.reportDesignerPane == null) {
            return false;
        }
        int selectedPanel = this.reportDesignerPane.getSelectedIndex();
        return selectedPanel == this.reportDesignerPane.getTabCount() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            this.deselectGroupOption();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to deselect group option", ex);
        }
        int selectedPanel = this.reportDesignerPane.getSelectedIndex();
        if (selectedPanel == this.reportDesignerPane.getTabCount() - 1) {
            this.prevPasteEnabled = this.menuBar.paste.isEnabled();
            this.wasPreviewPanel = true;
        }
        this.menuBar.updateMenu();
        this.updateFileMenu();
        if (selectedPanel < 0 || this.report == null || !this.title.toUpperCase().endsWith(".STL") && this.subReports == null) {
            return;
        }
        boolean opened = false;
        int oldReportIndex = this.currentReportIndex;
        if (this.removeSubReport) {
            return;
        }
        if (selectedPanel < this.reportDesignerPane.getTabCount() - 1) {
            this.isDesignMode = true;
            this.menuBar.setMenuEnabled(true);
            if (selectedPanel != this.currentReportIndex) {
                SubReportObject subr;
                if (this.currentReportIndex > 0) {
                    this.subReports.elementAt(this.currentReportIndex - 1).clearReportCache();
                }
                if (this.drillDownNavigationFrame != null) {
                    this.drillDownNavigationFrame.setVisible(false);
                    this.drillDownNavigationFrame.dispose();
                }
                this.designPanel = (DesignPanel)this.reportDesignerPane.getSelectedComponent();
                this.editPanel = this.designPanel.editPanel;
                DrillDownNode ddn = this.report.currentNode;
                DrillDownNode pn = this.report.parentNode;
                JTree ddt = this.drillDownTree;
                this.openSubReport = true;
                if (selectedPanel == 0) {
                    opened = this.loadRootReport();
                } else {
                    if (((DrillDownNode)this.drillDownTree.getModel().getRoot()).getFileName().indexOf("SubReport/") < 0) {
                        this.old_drillDownTree = this.drillDownTree;
                    }
                    if (this.subFilesTable.getTopName() == null) {
                        this.subFilesTable.setTopName(this.getFileName());
                    }
                    if ((opened = this.openFile((subr = this.subReports.elementAt(selectedPanel - 1)).getFileName(), subr.getFileName(), this.report, subr.getByteArray())) && this.drillDownTree == ddt) {
                        DrillDownNode newNode;
                        this.report.currentNode = newNode = new DrillDownNode("ROOT");
                        this.setDrillDownTree(new JTree(newNode));
                        newNode.setFileName(subr.getFileName());
                        newNode.setSelected(true);
                        newNode.setDomainPath(this.relativeDomainPath);
                    }
                }
                this.openSubReport = false;
                if (!opened) {
                    this.designPanel = (DesignPanel)this.reportDesignerPane.getComponentAt(this.currentReportIndex);
                    this.editPanel = this.designPanel.editPanel;
                    if (this.report == null) {
                        if (this.currentReportIndex == 0) {
                            opened = this.openFile(null, ddn.getFileName());
                            this.menuBar.setMenuEnabled(true);
                            try {
                                this.designPanel.designToolBar.setEnabled(true);
                                this.designPanel.designToolBar2.setEnabled(true);
                                this.previewPanel.previewToolBar.setEnabled(true);
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINEST, "Failed to initialize toolbars", ex);
                            }
                        } else {
                            subr = this.subReports.elementAt(this.currentReportIndex - 1);
                            opened = this.openFile(subr.getFileName());
                        }
                        if (!opened) {
                            this.close();
                            return;
                        }
                    }
                    this.report.currentNode = ddn;
                    this.drillDownTree = ddt;
                    this.reportDesignerPane.setSelectedIndex(this.currentReportIndex);
                    return;
                }
                if (selectedPanel == 0) {
                    this.report.parentNode = null;
                } else if (oldReportIndex == 0) {
                    if (ddn != null) {
                        this.report.parentNode = ddn;
                    }
                } else if (oldReportIndex > 0) {
                    this.report.parentNode = pn;
                }
            } else if (this.report.isCrossTabFixedField()) {
                this.currentCursor = this.getCursor();
                try {
                    this.do_retrieveWithoutDataUpdate(true);
                    this.displayRowState = 0;
                    this.firstTimePreview = true;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to reload report", ex);
                }
                finally {
                    this.setCursor(this.currentCursor);
                }
            }
            this.currentReportIndex = selectedPanel;
            if (this.currentReportIndex != 0) {
                this.menuBar.setMenuForSubReport();
                this.designPanel.designToolBar.setToolbarForSubReport();
            } else if (this.report.currentNode != null && this.drillDownTree != null && !this.report.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
                this.menuBar.setMenuForDrillDown();
                this.designPanel.designToolBar.setToolbarForDrillDown();
            } else {
                this.menuBar.setMenuEnabled(true);
                try {
                    this.designPanel.designToolBar.setEnabled(true);
                    this.designPanel.designToolBar2.setEnabled(true);
                    this.previewPanel.previewToolBar.setEnabled(true);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot enable toolbars", ex);
                }
            }
            this.menuBar.allowCrosstabElementMove.setSelected(this.isAllowCrosstabElementMove());
            this.menuBar.enableToc.setSelected(this.isEnableToc());
            this.menuBar.showCellOutline.setSelected(this.report.showCellOutline);
            this.menuBar.shift.setSelected(this.isShiftSelected);
            this.menuBar.formulaName.setSelected(this.report.showFormulaNameSelected);
            this.menuBar.prevParamPrompt.setSelected(this.report.isPrevParamPrompt);
            if (this.report != null && this.report.isCrossTab()) {
                this.menuBar.allowCrosstabElementMove.setEnabled(true);
            } else {
                this.menuBar.allowCrosstabElementMove.setEnabled(false);
            }
            this.designPanel.requestFocus();
            if (this.prevSelectedPanel == selectedPanel && this.wasPreviewPanel && this.prevPasteEnabled) {
                this.designPanel.rulerPanel.enablePaste();
            }
            this.prevSelectedPanel = selectedPanel;
            this.wasPreviewPanel = false;
        } else if (selectedPanel == this.reportDesignerPane.getTabCount() - 1) {
            if (this.drillDownNavigationFrame != null) {
                this.drillDownNavigationFrame.setVisible(false);
                this.drillDownNavigationFrame.dispose();
            }
            if (this.firstTimePreview && !this.useLiveData && !this.setPreviewDataOptions()) {
                this.reportDesignerPane.setSelectedIndex(this.currentReportIndex);
                return;
            }
            if (this.useLiveData) {
                this.report.useBackupData = false;
                if (!this.promptParamValue()) {
                    this.reportDesignerPane.setSelectedIndex(this.currentReportIndex);
                    return;
                }
            }
            this.isDesignMode = false;
            boolean old = this.isUpdateReport();
            this.setUpdateReport(false);
            try {
                this.previewPanel.updatePanel();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to update preview panel", ex);
            }
            this.setUpdateReport(old);
            if (this.isUpdateReport()) {
                this.currentCursor = this.getCursor();
                try {
                    if (this.displayRowState == 0 && this.useLiveData) {
                        this.do_retrieve();
                        this.displayRowState = 2;
                    } else if (this.forceRetrieveData && this.useLiveData) {
                        this.do_retrieve();
                    } else if ((this.report.getReportType() != 2 || this.report.dbInfo != null && this.report.dbInfo instanceof QueryFileInfo) && this.displayRowState == 1) {
                        this.do_retrieve();
                        this.displayRowState = 2;
                    } else if (this.report.getReportType() == 2 && this.report.isCrossTabFixedField()) {
                        this.do_retrieveWithoutDataUpdate(this.isDesignMode);
                    } else {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        this.previewPanel.updatePanel();
                    }
                    this.forceRetrieveData = false;
                    this.firstTimePreview = false;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to update report", ex);
                }
                finally {
                    this.setCursor(this.currentCursor);
                }
            }
            this.menuBar.setMenuForPreview();
        }
    }

    private boolean loadRootReport() {
        boolean opened = false;
        String filename = this.getFileName();
        if (this.report.parentNode != null && (filename = this.report.parentNode.getFileName(this.subFilesTable)).indexOf("DrillDown/") > -1) {
            this.setDrillDownTree(this.old_drillDownTree);
        }
        filename = this.isReportOpenedInPakFormat() ? SaveReport.getPakFileName(filename) : this.getFileNameWithExtension(filename, this.getRPTFileName());
        try {
            if (Report.fileExists(this.subFilesTable, filename)) {
                opened = this.openFile(filename);
            } else {
                if (filename.endsWith(".xml")) {
                    filename = filename.substring(0, filename.length() - 4) + ".rpt";
                }
                if (Report.fileExists(this.subFilesTable, filename)) {
                    opened = this.openFile(filename);
                } else {
                    filename = filename.replace('\\', '/');
                    filename = filename.substring(filename.lastIndexOf(47) + 1, filename.length());
                    opened = this.openFile(this.getTemplatesDirectory() + filename);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot open file", ex);
        }
        return opened;
    }

    public void selectDesignPanel() {
        this.reportDesignerPane.setSelectedIndex(0);
    }

    public void selectPreviewPanel() {
        this.reportDesignerPane.setSelectedIndex(this.reportDesignerPane.getTabCount() - 1);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
            this.deleteElt();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
        if (this.logoWindow != null) {
            this.logoWindow.closeWindow();
        }
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        try {
            if (this.bringChartEditorToFront && this.chartEditor != null) {
                ((Frame)this.chartEditor).toFront();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to bring chart editor to front", ex);
        }
        this.bringChartEditorToFront = false;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String addUser(String name, String password, boolean fromOrganizer, boolean fromQbDesigner) {
        String errmessage = null;
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            dout.writeShort(30831);
            dout.writeBoolean(true);
            dout.writeBoolean(fromOrganizer);
            dout.writeBoolean(fromQbDesigner);
            if (!fromOrganizer) {
                IOUtil.writeString(dout, Coder.encode(name));
                IOUtil.writeString(dout, Coder.encode(password));
            }
            IConnection socket = null;
            try {
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Cannot contact Report server", ex);
                try {
                    if (socket == null) return LanguageEncoder.getText("Can't contact Report Server at") + "\n " + ServerMessage.getServerInfo();
                    socket.close();
                    return LanguageEncoder.getText("Can't contact Report Server at") + "\n " + ServerMessage.getServerInfo();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
                }
                return LanguageEncoder.getText("Can't contact Report Server at") + "\n " + ServerMessage.getServerInfo();
            }
            DataInputStream dstream = null;
            try {
                dstream = new DataInputStream(socket.getInputStream());
                int code = dstream.readInt();
                if (code != 0) {
                    errmessage = IOUtil.readString(dstream, true);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to read data", ex);
                String string = IOUtil.getStackTrace(ex);
                return string;
            }
            finally {
                if (dstream != null) {
                    dstream.close();
                }
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
                }
            }
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Can't add user", ex2);
            return IOUtil.getStackTrace(ex2);
        }
        if (errmessage != null) return errmessage;
        if (name == null) return errmessage;
        ServerMessage.setOrgUserName(name);
        return errmessage;
    }

    public static void removeUser(boolean fromOrganizer, boolean fromQbDesigner) throws Exception {
        if (!ServerMessage.useServer) {
            return;
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(30831);
        dout.writeBoolean(false);
        dout.writeBoolean(fromOrganizer);
        dout.writeBoolean(fromQbDesigner);
        IConnection socket = ServerMessage.createConnection();
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to write data to output stream", ex);
            socket.close();
            throw ex;
        }
        String errmessage = null;
        DataInputStream dstream = null;
        try {
            dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                errmessage = IOUtil.readString(dstream, true);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to read data", ex);
            throw ex;
        }
        finally {
            if (dstream != null) {
                dstream.close();
            }
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
        }
        if (errmessage != null) {
            throw new IOException(errmessage);
        }
    }

    public static void main(String[] args) {
        QbUtil.setWindowsLAF();
        try {
            ServerMessage.useServer = false;
            if (LCKey.isDashboardOnly()) {
                throw new Exception("Invalid license key for ReportDesigner: Please contact sales@quadbase.com!");
            }
            String filename = null;
            String enc = null;
            String templates_dir = null;
            boolean metricSys = false;
            String xmlEncoding = null;
            String paperSize = null;
            for (String arg : args) {
                if (arg.startsWith("-file:")) {
                    filename = arg.substring(6);
                    continue;
                }
                if (arg.startsWith("-enc:")) {
                    enc = arg.substring(5);
                    continue;
                }
                if (arg.startsWith("-xmlEncoding:")) {
                    xmlEncoding = arg.substring(13);
                    if (xmlEncoding == null || xmlEncoding.trim().equals("")) continue;
                    ServerMessage.setXMLEncoding(xmlEncoding);
                    continue;
                }
                if (arg.startsWith("-paperSize:")) {
                    paperSize = arg.substring(11);
                    ServerMessage.setPaperSize(paperSize);
                    continue;
                }
                if (arg.startsWith("-metricSystem:")) {
                    metricSys = arg.substring(14).trim().equalsIgnoreCase("true");
                    continue;
                }
                if (arg.startsWith("-templatesDirectory:")) {
                    templates_dir = arg.substring(20);
                    continue;
                }
                if (!arg.startsWith("-debug:")) continue;
                QbDebug.setDebugMode(arg.substring(7));
            }
            ReportMain reportMain = new ReportMain(true, filename, enc);
            reportMain.isCm = metricSys;
            reportMain.setVisible(true);
            if (templates_dir != null) {
                reportMain.setTemplatesDirectory(templates_dir);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Cannot start program", t);
        }
    }

    public void setGlobalFormatLabel() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 6);
        gfd.setVisible(true);
    }

    public void setGlobalFormatChart() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 0);
        gfd.setVisible(true);
    }

    public void setGlobalFormatColumn() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 4);
        gfd.setVisible(true);
    }

    public void setGlobalFormatFormula() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 5);
        gfd.setVisible(true);
    }

    public void setGlobalFormatImage() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 3);
        gfd.setVisible(true);
    }

    public void setGlobalFormatGrid() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 1);
        gfd.setVisible(true);
    }

    public void setGlobalFormatLine() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 2);
        gfd.setVisible(true);
    }

    public void setGlobalFormatColumnHeader() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 12);
        gfd.setVisible(true);
    }

    public void setGlobalFormatTitle() {
        GlobalFormatDialog gfd = new GlobalFormatDialog(this, 13);
        gfd.setVisible(true);
    }

    public void exportGlobalFormat() {
        ExportGlobalFormat export = new ExportGlobalFormat(this.report);
        try {
            String directory = this.getBrowseDirectories().getGlobalFormatDir();
            OpenFileDialog fDialog = new OpenFileDialog(this, LanguageEncoder.getText("Export Global Formats"), directory, new String[]{"XML"}, directory);
            fDialog.setVisible(true);
            String selectedFile = fDialog.getSelectedFile();
            if (selectedFile != null) {
                this.getBrowseDirectories().setGlobalFormatDir(fDialog.getCurrentDirectory());
                if (!selectedFile.toUpperCase().endsWith(".XML")) {
                    selectedFile = selectedFile + ".xml";
                }
                if (!OverWriteDialog.continueSave(this, selectedFile)) {
                    return;
                }
            } else {
                return;
            }
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            export.exportXML(selectedFile);
            this.setCursor(this.currentCursor);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Failed to export global format", ex);
            this.setCursor(this.currentCursor);
            String msg = ex.getMessage();
            this.errorMessage(msg);
        }
    }

    public void importGlobalFormat() {
        ImportGlobalFormat import_xml = new ImportGlobalFormat(this);
        try {
            String directory = this.getBrowseDirectories().getGlobalFormatDir();
            OpenFileDialog fDialog = new OpenFileDialog(this, LanguageEncoder.getText("Import Global Formats"), directory, new String[]{"XML"}, directory);
            fDialog.setVisible(true);
            String selectedFile = fDialog.getSelectedFile();
            if (selectedFile != null) {
                this.getBrowseDirectories().setGlobalFormatDir(fDialog.getCurrentDirectory());
                if (!selectedFile.toUpperCase().endsWith(".XML")) {
                    selectedFile = selectedFile + ".xml";
                }
            } else {
                return;
            }
            this.currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            import_xml.importXML(selectedFile);
            this.setCursor(this.currentCursor);
            this.menuBar.setUndoEnabled(false);
            this.designPanel.rulerPanel.repaintPanel();
            this.setModified();
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Failed to import global format", ex);
            this.setCursor(this.currentCursor);
            String msg = ex.getMessage();
            this.errorMessage(msg);
        }
    }

    public void setNullDataHandler() {
        NullDataHandler handler = new NullDataHandler(this);
        handler.setVisible(true);
    }

    public void setHTMLPageTitle() {
        SetHTMLPageTitleDialog titleDialog = new SetHTMLPageTitleDialog(this);
        titleDialog.setVisible(true);
    }

    public void groupSetWidth() {
        String msg = null;
        if (this.report == null) {
            msg = LanguageEncoder.getText("Please open a report first!");
        }
        if (msg != null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        this.designPanel.rulerPanel.xRuler.groupSetWidth();
    }

    public boolean isUndoEnabled() {
        return this.isUndoEnabled;
    }

    public void setIsUndoEnabled(boolean b) {
        this.isUndoEnabled = b;
    }

    public Report createBackupReport() {
        try {
            if (this.reportBackup == null && this.report != null) {
                this.reportBackup = new Report(this.report, true);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create backup report", ex);
        }
        return this.reportBackup;
    }

    void do_undo() {
        Report previousReport = this.getBackupReport();
        if (previousReport != null) {
            try {
                if (this.reportBackup != null) {
                    this.redoReportList.insertElementAt(this.reportBackup, 0);
                    this.redoRetrieveDataList.insertElementAt(this.forceRetrieveData, 0);
                    if (this.redoReportList.size() > 10) {
                        this.redoReportList.remove(this.redoReportList.size() - 1);
                        this.redoRetrieveDataList.remove(this.redoRetrieveDataList.size() - 1);
                    }
                    this.reportBackup = null;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to undo operation", ex);
            }
            this.setReport(previousReport, false);
            this.setModified();
            this.designPanel.updatePanel();
            this.do_enable();
            this.toFront();
        }
        this.enableUndoRedoButtons();
    }

    void do_redo() {
        Report redoReport = this.getRedoReport();
        if (redoReport != null) {
            try {
                if (this.reportBackup != null) {
                    this.undoReportList.insertElementAt(this.reportBackup, 0);
                    this.undoRetrieveDataList.insertElementAt(this.forceRetrieveData, 0);
                    if (this.undoReportList.size() > 10) {
                        this.undoReportList.remove(this.undoReportList.size() - 1);
                        this.undoRetrieveDataList.remove(this.undoRetrieveDataList.size() - 1);
                    }
                    this.reportBackup = null;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to redo a change", ex);
            }
            this.setReport(redoReport, false);
            this.designPanel.updatePanel();
            this.setModified();
            this.do_enable();
            this.toFront();
        }
        this.enableUndoRedoButtons();
    }

    private void saveBackupReportToUndoList() {
        if (this.reportBackup != null) {
            this.undoReportList.insertElementAt(this.reportBackup, 0);
            this.undoRetrieveDataList.insertElementAt(this.forceRetrieveData, 0);
            if (this.undoReportList.size() > 10) {
                this.undoReportList.remove(this.undoReportList.size() - 1);
                this.undoRetrieveDataList.remove(this.undoReportList.size() - 1);
            }
            this.reportBackup = null;
            this.redoReportList.removeAllElements();
            this.redoRetrieveDataList.removeAllElements();
        } else {
            LOGGER.finest("No backup");
        }
    }

    private Report getBackupReport() {
        if (this.undoReportList.size() > 0) {
            Report newReport = this.undoReportList.elementAt(0);
            this.forceRetrieveData = this.undoRetrieveDataList.elementAt(0);
            this.undoReportList.remove(0);
            this.undoRetrieveDataList.remove(0);
            return newReport;
        }
        return null;
    }

    private Report getRedoReport() {
        if (this.redoReportList.size() > 0) {
            Report newReport = this.redoReportList.elementAt(0);
            this.forceRetrieveData = this.redoRetrieveDataList.elementAt(0);
            this.redoReportList.remove(0);
            this.redoRetrieveDataList.remove(0);
            return newReport;
        }
        return null;
    }

    void enableUndoRedoButtons() {
        this.menuBar.setRedoEnabled(this.redoReportList.size() > 0);
        if (this.designPanel != null) {
            this.designPanel.designToolBar.redoBt.setEnabled(this.redoReportList.size() > 0);
            this.designPanel.designToolBar.undoBt.setEnabled(this.undoReportList.size() > 0);
            this.designPanel.designToolBar.saveBt.setEnabled(this.isSaveItemEnabled());
        }
        this.menuBar.setUndoEnabled(this.undoReportList.size() > 0);
        if (this.menuBar.saveItem != null) {
            this.menuBar.saveItem.setEnabled(this.isSaveItemEnabled());
        }
        if (this.menuBar.saveItemWithNoData != null) {
            this.menuBar.saveItemWithNoData.setEnabled(this.isSaveItemEnabled());
        }
    }

    void clearUndoRedoList() {
        this.reportBackup = null;
        this.redoReportList.removeAllElements();
        this.undoReportList.removeAllElements();
        this.redoRetrieveDataList.removeAllElements();
        this.undoRetrieveDataList.removeAllElements();
        this.enableUndoRedoButtons();
    }

    void clearBackupReport() {
        this.reportBackup = null;
    }

    public void setIsDrawBoundingBoxOp(boolean b) {
        this.isDrawBoundingBoxOp = b;
    }

    public boolean isDrawBoundingBoxOp() {
        return this.isDrawBoundingBoxOp;
    }

    void deselectGroupOption() {
        this.resetSelectedObject();
        int size = this.designPanel.rulerPanel.panelList.size();
        for (int j = 0; j < size - 1; ++j) {
            ReportElementPanel panel = (ReportElementPanel)this.designPanel.rulerPanel.panelList.elementAt(j);
            if (panel.drawBoundingBox) {
                panel.drawBoundingBox = false;
                panel.isBoundingBoxOp = false;
                panel.deselectFormatSection();
                continue;
            }
            if (panel.groupFormat.size() <= 0) continue;
            panel.isResizeOp = false;
            panel.isDragOp = false;
            panel.deselectFormatSection();
        }
        ReportElementPanel masterSectionPanel = this.designPanel.rulerPanel.getMasterSectionPanel();
        if (masterSectionPanel != null && masterSectionPanel.groupFormat.size() > 0) {
            masterSectionPanel.isResizeOp = false;
            masterSectionPanel.isDragOp = false;
            masterSectionPanel.deselectFormatSection();
        }
        this.designPanel.rulerPanel.xRuler.groupSetWidthOp = false;
        this.designPanel.rulerPanel.xRuler.repaintNull();
        this.menuBar.setCopyCutEnabled(false);
        this.designPanel.designToolBar.setCopyCutEnabled(false);
        if (this.isUndoEnabled()) {
            this.menuBar.setUndoEnabled(true);
        }
    }

    public JTree getDrillDownTree() {
        return this.drillDownTree;
    }

    public void setDrillDownTree(JTree t) {
        if (t == null && this.drillDownNavigationFrame != null) {
            this.drillDownNavigationFrame.setVisible(false);
            this.drillDownNavigationFrame.dispose();
            this.drillDownNavigationFrame = null;
        } else if (t != this.drillDownTree && this.drillDownNavigationFrame != null) {
            this.drillDownNavigationFrame.updateTree(t);
        }
        if (t != null) {
            t.validate();
            t.repaint();
        }
        this.drillDownTree = t;
    }

    public void setSubReports(Vector<SubReportObject> sr) {
        this.setSubReports(sr, 0);
    }

    private void setSubReports(Vector<SubReportObject> sr, int index) {
        if (this.reportDesignerPane == null) {
            this.subReports = sr;
            return;
        }
        if (sr == null) {
            for (int i = this.reportDesignerPane.getTabCount() - 2; i > 0; --i) {
                this.removeSubReport = true;
                this.reportDesignerPane.removeTabAt(i);
                this.removeSubReport = false;
            }
        } else if (sr != this.subReports) {
            if (this.reportDesignerPane.getTabCount() - 2 >= sr.size()) {
                for (int i = this.reportDesignerPane.getTabCount() - 2; i > 0; --i) {
                    if (i > sr.size()) {
                        this.removeSubReport = true;
                        this.reportDesignerPane.removeTabAt(i);
                        this.removeSubReport = false;
                        continue;
                    }
                    this.reportDesignerPane.setTitleAt(i, LanguageEncoder.getText("Sub-Report_") + i);
                }
            } else if (this.reportDesignerPane.getTabCount() - 2 < sr.size()) {
                int old_count = this.reportDesignerPane.getTabCount() - 2;
                for (int i = 1; i <= sr.size(); ++i) {
                    if (i <= old_count) {
                        this.reportDesignerPane.setTitleAt(i, LanguageEncoder.getText("Sub-Report_") + i);
                        continue;
                    }
                    this.reportDesignerPane.insertTab(LanguageEncoder.getText("Sub-Report_") + i, null, new DesignPanel(this), null, i);
                }
            }
        }
        this.subReports = sr;
        this.currentReportIndex = index;
        this.reportDesignerPane.setSelectedIndex(index);
        this.designPanel = (DesignPanel)this.reportDesignerPane.getSelectedComponent();
        this.setUpdateReport();
        this.updatePanel();
        this.editPanel = this.designPanel.editPanel;
    }

    private void copyChildNodes(DrillDownNode node) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        node.removeAllChildren();
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode oldChild = (DrillDownNode)children.elementAt(i);
            DrillDownNode newChild = node.createNewChild(oldChild.getName(), this.getSubFilesTable());
            newChild.setCrossTabDrillDown(oldChild.isCrossTabDrillDown());
            newChild.setColumnMapping(oldChild.getColumnMapping());
            try {
                SaveReport sr;
                Report ddReport;
                LoadReport lr = new LoadReport(true);
                lr.setSubFilesTable(this.subFilesTable);
                String oldFileName = oldChild.getFileName(this.subFilesTable);
                lr.loadDataHeaderOnly(oldFileName);
                Vector<SubReportObject> childSRs = lr.getSubReports();
                if (childSRs == null || childSRs.size() <= 0) {
                    lr = new LoadReport(true);
                    lr.setSubFilesTable(this.subFilesTable);
                    lr.setRelativeDomainPath(this.relativeDomainPath);
                    lr.setBackupDataUsed(true);
                    ddReport = lr.loadReportFromFile(oldFileName);
                    ddReport.resetSourceData();
                    if (ddReport.rootNode != null) {
                        ddReport.rootNode.setFileName(node.getRoot().getFileName(this.subFilesTable));
                    }
                    if (this.subFilesTable.containsKey(oldFileName) && newChild.getFileName(this.subFilesTable) != null) {
                        this.subFilesTable.put(newChild.getFileName(this.subFilesTable), this.subFilesTable.remove(oldFileName));
                    }
                    sr = new SaveReport(ddReport, this.isDesignMode);
                    sr.setSaveNoData(this.saveWithNoData);
                    sr.setSubFilesTable(this.subFilesTable);
                    sr.setSubReports(childSRs);
                    this.saveToFile(sr, newChild.getFileName(this.subFilesTable), SaveReport.isPAKFile(node.getFileName()));
                } else {
                    lr = new LoadReport(true);
                    lr.setSubFilesTable(this.subFilesTable);
                    lr.setRelativeDomainPath(this.relativeDomainPath);
                    lr.setBackupDataUsed(true);
                    ddReport = lr.loadReportFromFile(oldFileName);
                    ddReport.resetSourceData();
                    if (ddReport.rootNode != null) {
                        ddReport.rootNode.setFileName(node.getRoot().getFileName());
                    }
                    childSRs = lr.getSubReports();
                    this.copySubReports_Helper(newChild.getFileName(), ddReport, childSRs);
                    sr = new SaveReport(ddReport, this.isDesignMode);
                    sr.setSaveNoData(this.saveWithNoData);
                    sr.setSubFilesTable(this.subFilesTable);
                    sr.setSubReports(childSRs);
                    this.saveToFile(sr, newChild.getFileName(this.subFilesTable), SaveReport.isPAKFile(node.getFileName()));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Renaming drilldown nodes: failed to copy nodes", ex);
            }
            if (oldChild.isLeaf()) continue;
            for (int j = 0; j < oldChild.getChildCount(); ++j) {
                newChild.add(oldChild.getChildAt(j));
            }
            this.copyChildNodes(newChild);
        }
    }

    private void resaveChildNodes(DrillDownNode node) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode child = (DrillDownNode)children.elementAt(i);
            try {
                LoadReport lr = new LoadReport(true);
                lr.setSubFilesTable(this.subFilesTable);
                lr.loadDataHeaderOnly(child.getFileName(this.subFilesTable));
                lr = new LoadReport(true);
                lr.setSubFilesTable(this.subFilesTable);
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(this.relativeDomainPath);
                Report ddReport = lr.loadReportFromFile(child.getFileName(this.subFilesTable));
                ddReport.resetSourceData();
                Vector<SubReportObject> childSRs = lr.getSubReports();
                this.copySubReports_Helper(child.getFileName(this.subFilesTable), ddReport, childSRs);
                if (child.getChildCount() > 0 || ddReport.currentNode.getChildCount() > 0) {
                    ddReport.currentNode.removeAllChildren();
                    for (int j = 0; j < child.getChildCount(); ++j) {
                        DrillDownNode newChild = child.getChildAt(j);
                        DrillDownNode copyNode = (DrillDownNode)newChild.clone();
                        ddReport.currentNode.add(copyNode);
                    }
                }
                SaveReport sr = new SaveReport(ddReport, this.isDesignMode);
                sr.setSaveNoData(this.saveWithNoData);
                sr.setSubFilesTable(this.subFilesTable);
                sr.setSubReports(childSRs);
                this.saveToFile(sr, child.getFileName(this.subFilesTable), SaveReport.isPAKFile(node.getFileName()));
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to re-save drilldown nodes", ex);
            }
            if (child.isLeaf()) continue;
            this.resaveChildNodes(child);
        }
    }

    private void copySubReports(String newtitle) {
        this.copySubReports_Helper(newtitle, this.report, this.subReports);
        this.setUpdateReport();
        this.updatePanel();
    }

    private void copySubReports_Helper(String newtitle, Report mainReport, Vector<SubReportObject> srVector) {
        if (srVector != null && srVector.size() > 0) {
            int i;
            String[] oldnames = new String[srVector.size()];
            String[] newnames = new String[srVector.size()];
            Vector<SubReportObject> newSubReportVector = new Vector<SubReportObject>();
            for (i = 0; i < srVector.size(); ++i) {
                SubReportObject newcell = new SubReportObject(newtitle, srVector.elementAt(i).getParamShareReportID(), this.relativeDomainPath, this.subFilesTable);
                newcell.setParameterMap(srVector.elementAt(i).getParameterMap());
                newSubReportVector.addElement(newcell);
                oldnames[i] = srVector.elementAt(i).getFileName();
                newnames[i] = newcell.getFileName();
                try {
                    LoadReport lr = new LoadReport(true);
                    lr.setSubFilesTable(this.subFilesTable);
                    lr.setBackupDataUsed(true);
                    lr.setRelativeDomainPath(this.relativeDomainPath);
                    Report subR = this.isReportOpenedInPakFormat() && this.subFilesTable.containsKey(oldnames[i]) ? lr.loadReportFromByteArray(this.subFilesTable.get(oldnames[i])) : lr.loadReportFromFile(oldnames[i]);
                    if (subR.parentNode == null) {
                        subR.parentNode = new DrillDownNode();
                        subR.parentNode.setDomainPath(this.relativeDomainPath);
                    }
                    subR.parentNode.setFileName(newtitle);
                    subR.currentNode.setFileName(newnames[i]);
                    if (lr.getDrillDownNode() != null) {
                        this.copyChildNodes(lr.getDrillDownNode());
                    }
                    if (this.subFilesTable != null && this.subFilesTable.containsKey(oldnames[i])) {
                        this.subFilesTable.put(newnames[i], this.subFilesTable.get(oldnames[i]));
                    }
                    SaveReport sr = new SaveReport(subR, this.isDesignMode);
                    sr.setSaveNoData(this.saveWithNoData);
                    sr.setSubFilesTable(this.subFilesTable);
                    sr.setDrillDownNode(lr.getDrillDownNode());
                    this.saveToFile(sr, newnames[i], this.isReportOpenedInPakFormat());
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Renaming failed: cannot copy sub-reports", ex);
                    Report.copyFile(this.subFilesTable, oldnames[i], newnames[i]);
                }
            }
            srVector.removeAllElements();
            for (i = 0; i < newSubReportVector.size(); ++i) {
                srVector.addElement((SubReportObject)newSubReportVector.elementAt(i));
            }
            mainReport.getReportHeader().renameSubReportFileNames(oldnames, newnames);
            mainReport.getPageHeader().renameSubReportFileNames(oldnames, newnames);
            mainReport.getPageFooter().renameSubReportFileNames(oldnames, newnames);
            mainReport.getReportFooter().renameSubReportFileNames(oldnames, newnames);
            ReportTable table = mainReport.getReportTables().elementAt(0);
            table.getHeader().renameSubReportFileNames(oldnames, newnames);
            table.getFooter().renameSubReportFileNames(oldnames, newnames);
            if (table instanceof ReportMultiSectionTable) {
                ReportMultiSectionTable mtbl = (ReportMultiSectionTable)table;
                for (int i2 = 0; i2 < mtbl.countRowBreakHeader(); ++i2) {
                    mtbl.getRowBreakHeader(i2).renameSubReportFileNames(oldnames, newnames);
                    mtbl.getRowBreakFooter(i2).renameSubReportFileNames(oldnames, newnames);
                }
            }
            table.renameSubReportFileNames(oldnames, newnames);
        }
    }

    public String getItemName() {
        return null;
    }

    public void setItemName(String str) {
    }

    public boolean isFileNameExisted(String str) {
        return false;
    }

    public void insertFileToReportOrganizer(String dbLabel, boolean insertXML) {
    }

    public void insertFileToReportOrganizer(String fileLocation) {
    }

    public String getPath(String loc) {
        return loc;
    }

    public String getBackgroundImagesDir() {
        return ServerMessage.backgroundImagesPath;
    }

    public String getFileDialogDefaultDirectory() {
        return System.getProperty("user.dir");
    }

    public String getBrowseDialogDefaultDirectory(String curDir) {
        return curDir;
    }

    public boolean isParameterizedReport() {
        return this.report.queryFilename != null && !this.report.queryFilename.equals("");
    }

    public String getTemplatesDirectory() {
        return this.browseDir.getReportTemplatesDirectory();
    }

    public void setTemplatesDirectory(String dir) {
        if (!(dir = QbUtil.replace(dir, "\\", separator)).endsWith(separator)) {
            dir = dir + separator;
        }
        this.browseDir.setReportTemplatesDirectory(dir);
    }

    public ReportWizard getReportWizard() {
        return this.wizard;
    }

    public boolean isFromOrganizer() {
        return false;
    }

    public String getURL(String file) {
        return null;
    }

    public void setDBProvider(IDBProvider p) {
        this.dbProvider = p;
    }

    private Report getMainReport() throws Exception {
        LoadReport lr = new LoadReport(true);
        lr.setSubFilesTable(this.subFilesTable);
        lr.setRelativeDomainPath(this.relativeDomainPath);
        lr.setBackupDataUsed(true);
        String filename = this.getFileName();
        if (this.report.parentNode != null) {
            filename = this.report.parentNode.getFileName();
        }
        Report mainReport = null;
        try {
            mainReport = this.isReportOpenedInPakFormat() && this.subFilesTable.containsKey(filename) ? lr.loadPakReportFromByteArray(filename, this.subFilesTable.get(filename)) : lr.loadReportFromFile(filename);
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.FINEST, "Failed to load report from file", ex);
            try {
                if (filename.endsWith(".xml")) {
                    filename = filename.substring(0, filename.length() - 4) + ".rpt";
                }
                mainReport = lr.loadReportFromFile(filename);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINEST, "Failed to load report from file", ioe);
                filename = filename.replace('\\', '/');
                filename = filename.substring(filename.lastIndexOf(47) + 1, filename.length());
                mainReport = lr.loadReportFromFile(this.getTemplatesDirectory() + filename);
            }
        }
        return mainReport;
    }

    public void setSubReportParameterSharing() {
        try {
            Report mainReport = this.getMainReport();
            Report[] subArray = mainReport.getSubReportArray();
            subArray[this.currentReportIndex - 1] = this.report;
            ParameterShareDialog pDialog = new ParameterShareDialog(this, mainReport, this.report, this.currentReportIndex);
            pDialog.setVisible(true);
            for (int i = 0; subArray != null && i < subArray.length; ++i) {
                if (subArray[i] == null || !subArray[i].modified) continue;
                SaveReport saveReport = new SaveReport(subArray[i], this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                saveReport.setSubFilesTable(this.subFilesTable);
                SubReportObject sro = this.subReports.elementAt(i);
                this.saveToFile(saveReport, sro.getFileName(), this.isReportOpenedInPakFormat());
                if (this.subFilesTable == null || !this.subFilesTable.containsKey(sro.getFileName())) continue;
                sro.setByteArray(this.subFilesTable.get(sro.getFileName()));
            }
            if (mainReport.modified) {
                SaveReport saveReport = new SaveReport(mainReport, this.isDesignMode);
                saveReport.setSaveNoData(this.saveWithNoData);
                saveReport.setSubReports(this.subReports);
                saveReport.setSubFilesTable(this.subFilesTable);
                saveReport.setDrillDownNode(mainReport.currentNode);
                String filename = this.getFileName();
                this.saveToFile(saveReport, filename, this.isReportOpenedInPakFormat());
            }
            if (pDialog.isModified()) {
                this.setModified();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to set sub-report parameter mapping", ex);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), ex.getMessage());
        }
    }

    public void setSubReportParameters() {
        try {
            SubReportParameterDialog sDialog = new SubReportParameterDialog(this, this.report, this.subReports);
            sDialog.setVisible(true);
            if (sDialog.isModified()) {
                this.setModified();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to set sub-report parameters", ex);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), ex.getMessage());
        }
    }

    public void setChartParametersMapping() {
        try {
            ChartParameterMappingDialog sDialog = new ChartParameterMappingDialog(this, this.report);
            sDialog.setVisible(true);
            if (sDialog.isModified()) {
                this.setModified();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to set chart parameters mapping", ex);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Error"), ex.getMessage());
        }
    }

    public void setForceNewReport(boolean state) {
        this.forceNewReport = state;
    }

    public boolean isForceNewReport() {
        return this.forceNewReport;
    }

    void addSubSection() {
        if (this.selectedObject != null && this.selectedObject instanceof ReportSection) {
            this.createBackupReport();
            this.menuBar.setUndoEnabled(false);
            ReportSection section = (ReportSection)this.selectedObject;
            ReportSection parent = section.getParentSection();
            if (parent != null) {
                try {
                    int index = parent.getSectionIndex(section);
                    index = index < 0 ? parent.getSectionCount() : ++index;
                    parent.insertSection(index);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to insert section, adding it as a new one", ex);
                    parent.addSection();
                }
            } else {
                try {
                    section.insertSection(0);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to insert section, adding it as a new one", ex);
                    section.addSection();
                }
            }
            this.setModified();
            this.menuBar.setUndoEnabled(true);
            this.updatePanel();
            this.updateReportExplorer();
            this.designPanel.rulerPanel.yRuler.updateYRuler();
            if (this.report.vGuideLines == null) {
                return;
            }
            for (int i = 0; i < this.report.vGuideLines.size(); ++i) {
                GuideLine cell = this.report.vGuideLines.elementAt(i);
                GuideLine gl = this.designPanel.rulerPanel.createGuideLine(cell.getX(), cell.getY(), true, null);
                gl.copyElts(cell);
                gl.alignElts();
                this.report.replaceGuideLine(cell, gl);
                this.designPanel.rulerPanel.removeGuideLine(cell);
            }
            this.repaintPanel();
        }
    }

    void removeSubSection() {
        if (this.selectedObject != null && this.selectedObject instanceof ReportSection) {
            this.createBackupReport();
            this.menuBar.setUndoEnabled(false);
            ReportSection section = (ReportSection)this.selectedObject;
            ReportSection parent = section.getParentSection();
            if (parent != null) {
                parent.removeSection(section);
            }
            this.setModified();
            this.menuBar.setUndoEnabled(true);
            this.updatePanel();
            this.designPanel.rulerPanel.yRuler.updateYRuler();
            this.updateReportExplorer();
        }
    }

    public void setSelectedFormula(Formula formula) {
        this.selectedFormula = formula;
    }

    public Formula getSelectedFormula() {
        return this.selectedFormula;
    }

    public void setSelectedScript(Script script) {
        this.selectedScript = script;
    }

    public Script getSelectedScript() {
        return this.selectedScript;
    }

    public void setSelectedDatabaseField(String[] df) {
        this.selectedDatabaseField = df;
    }

    public String[] getSelectedDatabaseField() {
        return this.selectedDatabaseField;
    }

    public void setSelectedDatabaseFieldAggr(String aggr) {
        this.selectedDatabaseFieldAggr = aggr;
    }

    public String getSelectedDatabaseFieldAggr() {
        return this.selectedDatabaseFieldAggr;
    }

    public void setSelectedColumnAggrIndex(short cAggrIdx) {
        this.selectedColumnAggrIndex = cAggrIdx;
    }

    public short getSelectedColumnAggrIndex() {
        return this.selectedColumnAggrIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean promptParamValue() {
        if (this.report.getOriginalSourceData() > 0) {
            return true;
        }
        if (this.report.dbInfo instanceof SalesForceQueryFileInfo && !((SalesForceQueryFileInfo)this.report.dbInfo).isParameterized()) {
            return true;
        }
        Report[] subReportArray = this.report.getSubReportArray();
        if (subReportArray != null) {
            for (Report element : subReportArray) {
                QueryInParam[] masterParams;
                IQueryInParam[] securityParams;
                if (element == null || element.getSecurityQueryParameterMap() == null || this.report.getPreviewSecurityLevel() == null || !(element.dbInfo instanceof QueryFileInfo) || (securityParams = QueryParser.verifyParameters(masterParams = ((QueryFileInfo)element.dbInfo).getInSet().getParameter(), (IQueryInParam[])element.getSecurityQueryParameterMap().get(this.report.getPreviewSecurityLevel()))) == null) continue;
                boolean different = false;
                for (int j = 0; j < masterParams.length; ++j) {
                    Vector<Object> destObj;
                    Vector<Object> sourceObj;
                    if (masterParams[j] instanceof QueryMultiValueInParam) {
                        sourceObj = ((QueryMultiValueInParam)securityParams[j]).getValues();
                        if (!different) {
                            destObj = ((QueryMultiValueInParam)masterParams[j]).getValues();
                            if (sourceObj != null && destObj != null) {
                                if (!((Object)sourceObj).equals(destObj)) {
                                    different = true;
                                }
                            } else if (sourceObj != null || destObj != null) {
                                different = true;
                            }
                        }
                        ((QueryMultiValueInParam)masterParams[j]).setValues(sourceObj);
                        continue;
                    }
                    sourceObj = securityParams[j].getValue();
                    if (!different) {
                        destObj = masterParams[j].getValue();
                        if (sourceObj != null && destObj != null) {
                            if (!((Object)sourceObj).equals(destObj)) {
                                different = true;
                            }
                        } else if (sourceObj != null || destObj != null) {
                            different = true;
                        }
                    }
                    masterParams[j].setValue(sourceObj);
                }
            }
        }
        if (this.report.getPreviewSecurityLevel() != null && this.report.getSecurityQueryParameterMap() != null && this.report.dbInfo != null && this.report.dbInfo instanceof QueryFileInfo) {
            QueryInParam[] masterParams = ((QueryFileInfo)this.report.dbInfo).getInSet().getParameter();
            IQueryInParam[] securityParams = QueryParser.verifyParameters(masterParams, (IQueryInParam[])this.report.getSecurityQueryParameterMap().get(this.report.getPreviewSecurityLevel()));
            Vector<QueryInParam> unselectedParameters = new Vector<QueryInParam>();
            if (securityParams != null) {
                EnterParamDialog dialog;
                boolean different = false;
                for (int i = 0; i < masterParams.length; ++i) {
                    Vector<Object> destObj;
                    Vector<Object> sourceObj;
                    if (masterParams[i] instanceof QueryMultiValueInParam) {
                        sourceObj = ((QueryMultiValueInParam)securityParams[i]).getValues();
                        if (!different) {
                            destObj = ((QueryMultiValueInParam)masterParams[i]).getValues();
                            if (sourceObj != null && destObj != null) {
                                if (!((Object)sourceObj).equals(destObj)) {
                                    different = true;
                                }
                            } else if (sourceObj != null || destObj != null) {
                                different = true;
                            }
                        }
                        if (sourceObj == null) {
                            unselectedParameters.addElement(masterParams[i]);
                        }
                        ((QueryMultiValueInParam)masterParams[i]).setValues(sourceObj);
                        continue;
                    }
                    sourceObj = securityParams[i].getValue();
                    if (!different) {
                        destObj = masterParams[i].getValue();
                        if (sourceObj != null && destObj != null) {
                            if (!((Object)sourceObj).equals(destObj)) {
                                different = true;
                            }
                        } else if (sourceObj != null || destObj != null) {
                            different = true;
                        }
                    }
                    if (sourceObj == null) {
                        unselectedParameters.addElement(masterParams[i]);
                    }
                    masterParams[i].setValue(sourceObj);
                }
                this.setUpdateReport(true);
                boolean showDialog = this.containsParameterInSubReport(this.report);
                if (unselectedParameters.size() > 0 || showDialog) {
                    QueryInParam[] unselectedParams = new QueryInParam[unselectedParameters.size()];
                    for (int i = 0; i < unselectedParams.length; ++i) {
                        unselectedParams[i] = (QueryInParam)unselectedParameters.elementAt(i);
                    }
                    QueryFileInfo reportqfi = (QueryFileInfo)this.report.dbInfo;
                    DBInfoBasic newDBInfo = reportqfi.isUseJNDIDataSource() ? new DBInfoBasic(reportqfi.getJNDIName(), reportqfi.getQuery(), reportqfi.getEnvProperties()) : new DBInfoBasic(reportqfi.getURLString(), reportqfi.getDriverName(), reportqfi.getUserID(), reportqfi.getPassword(), reportqfi.getQuery(), reportqfi.getAdditionalDb());
                    QueryFileInfo qfi = new QueryFileInfo(reportqfi.getProductName(), reportqfi.getVersion(), newDBInfo, new QueryInParamSet(unselectedParams));
                    dialog = new EnterParamDialog(this, this.report, qfi, this.report.getFormulaParameters(), true);
                    dialog.setVisible(true);
                    if (dialog.isCancelled()) {
                        return false;
                    }
                    different = true;
                } else if (this.report.getFormulaParameters() != null && this.report.getFormulaParameters().size() > 0) {
                    dialog = new EnterParamDialog(this, this.report, null, this.report.getFormulaParameters(), true);
                    dialog.setVisible(true);
                    if (dialog.isCancelled()) {
                        return false;
                    }
                    different = true;
                }
                if (!different) return true;
                if (this.displayRowState == 0) return true;
                this.do_retrieve();
                return true;
            }
        }
        if (!this.report.isPrevParamPrompt) {
            return true;
        }
        this.setUpdateReport(true);
        EnterParamDialog dialog = null;
        Vector<Parameter> formulaParams = this.report.getFormulaParameters();
        if (this.report.dbInfo != null && this.report.dbInfo instanceof QueryFileInfo && formulaParams != null && formulaParams.size() > 0) {
            QueryFileInfo queryFileInfo = (QueryFileInfo)this.report.dbInfo;
            dialog = new EnterParamDialog(this, this.report, queryFileInfo, formulaParams, true);
            dialog.setVisible(true);
        } else if (formulaParams != null && formulaParams.size() > 0) {
            dialog = new EnterParamDialog(this, this.report, null, formulaParams, true);
            dialog.setVisible(true);
        } else {
            if (this.report.getParametersInSequence().getParamCount() <= 0) return true;
            boolean bl = true;
            boolean showDialog = bl;
            if (!showDialog) return true;
            dialog = new EnterParamDialog(this, this.report, null, formulaParams, true);
            if (!dialog.hasParameter()) return true;
            dialog.setVisible(true);
        }
        if (dialog.isCancelled()) {
            return false;
        }
        if (!dialog.queryParamHasChanged()) return true;
        if (this.displayRowState == 0) return true;
        this.do_retrieve();
        return true;
    }

    private boolean containsParameterInSubReport(Report report) {
        Vector<Param> vec = report.getNonSharedAvailableSubReportParamsAsParam();
        return vec != null && vec.size() > 0;
    }

    public void setDefaultParamNames(String[] names) {
        this.defaultParamNames = names;
    }

    public String[] getDefaultParamNames() {
        return this.defaultParamNames;
    }

    public void addDataSourceManagerListener(DataSourceManagerListener listener) {
        if (this.managerListeners == null) {
            this.managerListeners = new Vector();
        }
        this.managerListeners.addElement(listener);
    }

    public void removeDataSourceManagerListener(DataSourceManagerListener listener) {
        if (this.managerListeners == null) {
            return;
        }
        for (int i = this.managerListeners.size() - 1; i >= 0; --i) {
            if (this.managerListeners.elementAt(i) == null || !this.managerListeners.elementAt(i).equals(listener)) continue;
            this.managerListeners.removeElementAt(i);
        }
    }

    Vector<DataSourceManagerListener> getDataSourceManagerListeners() {
        return this.managerListeners;
    }

    public void setReportBackgroundColor() {
        if (this.report == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please open a report first."));
        }
        ColorDialog cDialog = new ColorDialog(this, true, -1, this.report.getBackgroundColor());
        cDialog.setVisible(true);
        if (cDialog.isModified()) {
            this.report.setBackgroundColor(cDialog.getColor());
            this.setModified();
        }
    }

    public void setReportBackgroundImage() {
        if (this.report == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please open a report first."));
        }
        ReportImage image = this.report.getBackgroundImage();
        BackgroundImageDialog bgDialog = new BackgroundImageDialog(this, image, true, LanguageEncoder.getText("Choose A Background Image"));
        bgDialog.setVisible(true);
        if (bgDialog.isModified()) {
            if (bgDialog.getImageURL() == null) {
                this.report.setBackgroundImage(null);
                this.setModified();
                return;
            }
            if (image == null) {
                image = new ReportImage();
            }
            image.setImageURL(bgDialog.getImageURL(), true);
            if (bgDialog.getRelativeURL() != null) {
                image.setRelativePath(bgDialog.getRelativeURL());
                image.setImagePath(bgDialog.getRelativeURL(), true);
            }
            image.setWidth(bgDialog.getImageWidth());
            image.setHeight(bgDialog.getImageHeight());
            image.setImageOption(bgDialog.getDisplayOption());
            this.report.setBackgroundImage(image);
            this.setModified();
        }
    }

    public void setFontMapping() {
        if (this.report == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please open a report first."));
        }
        FontMappingDialog fDialog = new FontMappingDialog(this, this.report.getFontMapping());
        fDialog.setBrowseDirectories(this.getBrowseDirectories());
        fDialog.setVisible(true);
        if (fDialog.isModified()) {
            this.report.setFontMapping(fDialog.getFontMapping());
            this.setModified();
        }
    }

    public void setViewerFontProperty() {
        ViewerFontSetupDialog fDialog = new ViewerFontSetupDialog(this);
        fDialog.setVisible(true);
        if (fDialog.isModified()) {
            boolean isAdjustFont = fDialog.isAdjustFont();
            if (this.report.isAdjustFont() != isAdjustFont) {
                Font initFont = this.report.labelSetting.getFont();
                this.report.labelSetting.setFont(this.getGlobalFont(initFont, isAdjustFont));
                initFont = this.report.columnHeaderSetting.getFont();
                this.report.columnHeaderSetting.setFont(this.getGlobalFont(initFont, isAdjustFont));
                initFont = this.report.stringFormulaSetting.getFont();
                this.report.stringFormulaSetting.setFont(this.getGlobalFont(initFont, isAdjustFont));
                initFont = this.report.stringColumnSetting.getFont();
                this.report.labelSetting.setFont(this.getGlobalFont(initFont, isAdjustFont));
            }
            this.report.setAdjustFont(isAdjustFont);
            this.setModified();
        }
        this.repaintPanel();
    }

    private Font getGlobalFont(Font font, boolean isAdjustFont) {
        if (isAdjustFont) {
            return new Font(font.getName(), font.getStyle(), QbUtil.getAdjustedFont(font.getSize(), true));
        }
        return font;
    }

    void setDefaultValueRequiredForParameters(boolean state) {
        this.defaultValueRequiredForParameters = state;
    }

    boolean isDefaultValueRequiredForParameters() {
        return this.defaultValueRequiredForParameters;
    }

    void setOriginalColumnHeader(boolean b) {
        if (this.selectedObject instanceof ColumnHeader) {
            ((ColumnHeader)this.selectedObject).isFormula = b;
        }
        if (this.selectedObject instanceof RBColumnHeader) {
            ((RBColumnHeader)this.selectedObject).isFormula = b;
        }
        this.repaintPanel(this.selectedPanel);
    }

    ColInfo findMatchingColInfo(ReportElement elt) {
        Vector<ReportTable> tbls = this.report.getReportTables();
        if (tbls == null || tbls.size() <= 0 || tbls.elementAt(0) == null) {
            return null;
        }
        ReportTable table = tbls.elementAt(0);
        for (int i = 0; i < table.countRowBreakHeader(); ++i) {
            ReportSection section = table.getRowBreakHeader(i);
            if (section != elt) continue;
            return this.report.colInfo[this.report.breakColIndex[i]];
        }
        return null;
    }

    public void setChartMenuItemEnabled(int menu, int item, boolean enabled) {
        if (this.chartMenuItem_menu == null) {
            this.chartMenuItem_menu = new Vector();
        }
        this.chartMenuItem_menu.addElement(menu);
        if (this.chartMenuItem_item == null) {
            this.chartMenuItem_item = new Vector();
        }
        this.chartMenuItem_item.addElement(item);
        if (this.chartMenuItem_enabled == null) {
            this.chartMenuItem_enabled = new Vector();
        }
        this.chartMenuItem_enabled.addElement(enabled);
    }

    public void setChartMenuEnabled(int menu, boolean enabled) {
        if (this.chartMenu_menu == null) {
            this.chartMenu_menu = new Vector();
        }
        this.chartMenu_menu.addElement(menu);
        if (this.chartMenu_enabled == null) {
            this.chartMenu_enabled = new Vector();
        }
        this.chartMenu_enabled.addElement(enabled);
    }

    public void setChartToolbarItemEnabled(int item, boolean enabled) {
        if (this.chartToolbarItem_item == null) {
            this.chartToolbarItem_item = new Vector();
        }
        this.chartToolbarItem_item.addElement(item);
        if (this.chartToolbarItem_enabled == null) {
            this.chartToolbarItem_enabled = new Vector();
        }
        this.chartToolbarItem_enabled.addElement(enabled);
    }

    public void setChartIO(IChartIO chartIO) {
        this.chartIO = chartIO;
    }

    public void setSnapToGrid() {
        SnapToGridDialog snapToGridDialog = new SnapToGridDialog(this);
        snapToGridDialog.setVisible(true);
        if (snapToGridDialog.isModified()) {
            boolean snapToGrid = snapToGridDialog.isSnapToGrid();
            double stepSize = snapToGridDialog.getStepSize();
            this.report.setSnapToGrid(snapToGrid, this.isCm, stepSize);
        }
        this.repaintPanel();
    }

    protected boolean isSecurityLevelApplied() {
        String[] levels;
        if (this.securityLevel == null) {
            return false;
        }
        if (this.report == null) {
            return false;
        }
        for (String level : levels = this.report.getSecurityLevels()) {
            if (!this.securityLevel.equalsIgnoreCase(level)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecureMode() {
        return this.securityLevel != null;
    }

    public ReportElement getCopiedElement() {
        return this.copiedElement;
    }

    public void setCopiedElement(ReportElement elt) {
        this.copiedElement = elt;
    }

    public void pasteElementAppearance(ReportElement elt) {
        if (this.copiedElement == null) {
            return;
        }
        elt.setFont(this.copiedElement.getFont());
        elt.setBgColor(this.copiedElement.getBgColor());
        elt.setFontColor(this.copiedElement.getFontColor());
        elt.setAlign(this.copiedElement.getAlign());
        elt.setVAlign(this.copiedElement.getVAlign());
        if (!(elt instanceof ReportLine) && !(elt instanceof ReportGrid)) {
            elt.setWidth(this.copiedElement.getWidth());
            elt.setHeight(this.copiedElement.getHeight());
        }
        elt.setBorderThickness(this.copiedElement);
        elt.setBorderColor(this.copiedElement.getBorderColor());
        elt.setRoundCornerRadius(this.copiedElement.getRoundCornerRadius());
        elt.setRoundCornersArray(this.copiedElement.getRoundCornersArray());
        if (elt instanceof ReportGrid && this.copiedElement instanceof ReportGrid) {
            ((ReportGrid)elt).setGridStyle(((ReportGrid)this.copiedElement).getGridStyle());
            if (!elt.isLocked()) {
                elt.setWidth(this.copiedElement.getWidth());
                elt.setHeight(this.copiedElement.getHeight());
            }
        } else if (elt instanceof ReportLine && this.copiedElement instanceof ReportLine) {
            ((ReportLine)elt).setLineStyle(((ReportLine)this.copiedElement).getLineStyle());
            if (!elt.isLocked()) {
                ((ReportLine)elt).setVertical(((ReportLine)this.copiedElement).isVertical());
                ((ReportLine)elt).setWidth(((ReportLine)this.copiedElement).getWidth());
                ((ReportLine)elt).setHeight(((ReportLine)this.copiedElement).getHeight());
            }
        } else if (elt instanceof ReportCell) {
            if (this.copiedElement instanceof ReportCell) {
                if (FormatUtil.isFormatAppliabled(((ReportCell)elt).getDataFormat(), ((ReportCell)this.copiedElement).getDataFormat())) {
                    ((ReportCell)elt).setDataFormat(((ReportCell)this.copiedElement).getDataFormat());
                }
            } else if (this.copiedElement instanceof ReportColumn && FormatUtil.isFormatAppliabled(((ReportCell)elt).getDataFormat(), ((ReportColumn)this.copiedElement).getDataFormat())) {
                ((ReportCell)elt).setDataFormat(((ReportColumn)this.copiedElement).getDataFormat());
            }
        } else if (elt instanceof ReportColumn) {
            if (this.copiedElement instanceof ReportColumn) {
                ((ReportColumn)elt).setBgColor2(((ReportColumn)this.copiedElement).getBgColor2());
                ((ReportColumn)elt).setFontColor2(((ReportColumn)this.copiedElement).getFontColor2());
                ((ReportColumn)elt).setFont2(((ReportColumn)this.copiedElement).getFont2());
                ((ReportColumn)elt).setAlternateRow(((ReportColumn)this.copiedElement).getAlternateRow());
                ((ReportColumn)elt).setDualColorOnRowBreak(((ReportColumn)this.copiedElement).isDualColorOnRowBreak());
                ((ReportColumn)elt).setDualColorColInfoIndex(((ReportColumn)this.copiedElement).getDualColorColInfoIndex());
                if (FormatUtil.isFormatAppliabled(((ReportColumn)elt).getDataFormat(), ((ReportColumn)this.copiedElement).getDataFormat())) {
                    ((ReportColumn)elt).setDataFormat(((ReportColumn)this.copiedElement).getDataFormat());
                }
            } else if (this.copiedElement instanceof ReportCell && FormatUtil.isFormatAppliabled(((ReportColumn)elt).getDataFormat(), ((ReportCell)this.copiedElement).getDataFormat())) {
                ((ReportColumn)elt).setDataFormat(((ReportCell)this.copiedElement).getDataFormat());
            }
        }
        this.setModified();
        this.repaintPanel(this.selectedPanel);
    }

    public void setSkipQueryResultStep(boolean b) {
        this.skipQueryResultStep = b;
    }

    public boolean isSkipQueryResultStep() {
        return this.skipQueryResultStep;
    }

    public void setSkipMultiDataSourceStep(boolean b) {
        this.skipMultiDataSourceStep = b;
    }

    public boolean isSkipMultiDataSourceStep() {
        return this.skipMultiDataSourceStep;
    }

    public void setSkipPredefinedTemplatesStep(boolean b) {
        this.skipPredefinedTemplatesStep = b;
    }

    public boolean isSkipPredefinedTemplatesStep() {
        return this.skipPredefinedTemplatesStep;
    }

    void launchPageViewer() {
        JMessageDialog msgDialog;
        int response;
        String tmp;
        if (this.getFileName() != null && this.getFileName().toUpperCase().endsWith(".STL")) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("PageViewer doesn't support STL file"));
            return;
        }
        if (this.isModified() && this.reportIO != null && this.reportIO instanceof IReportNavigationIO && (tmp = ((IReportNavigationIO)this.reportIO).isParentReportSaved()) != null) {
            this.setTitle(tmp);
            this.setModified(false);
        }
        if (this.isModified() && (response = (msgDialog = new JMessageDialog((Frame)this, "Question", saveRptBeforePage, 2)).getResponse()) == 5) {
            return;
        }
        if (this.isModified() && this.reportIO != null && this.reportIO instanceof IReportNavigationIO && (tmp = ((IReportNavigationIO)this.reportIO).saveParentReport()) != null) {
            this.setTitle(tmp);
        }
        boolean old_state = this.isModified();
        this.setModified(true);
        if (this.drillDownReportIO != null) {
            this.drillDownReportIO.saveReportForDrillDownOp();
        } else {
            try {
                this.saveChangesInTheReport();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot save changes in the report!", e);
            }
        }
        if (this.isModified() && !this.isReportOpenedInPakFormat()) {
            this.setModified(old_state);
            return;
        }
        if (this.pageViewer != null) {
            if (this.getFileName().equals(this.pageViewer.getTitle())) {
                this.refreshPageViewer();
                this.pageViewer.setVisible(true);
                this.pageViewer.toFront();
                return;
            }
            this.closePageViewer();
        }
        this.pageViewerCanvas = Viewer.getReportCanvas((Frame)null, this.getFileName(), 0L, this.report.getPreviewSecurityLevel());
        this.pageViewerCanvas.setInvisibleMenuItemList(new String[]{"Client"});
        this.pageViewerCanvas.setBrowseDirectories(this.getBrowseDirectories());
        this.pageViewerCanvas.setPrintKeyEnabled(this.printing);
        this.createPageViewer(this.getFileName(), this.pageViewerCanvas.getReportComponent());
        this.pageViewerCanvas.setReportToolBarVisible(true);
        this.pageViewer.setVisible(true);
    }

    private void createPageViewer(String title, Component comp) {
        this.pageViewer = new JFrame(title);
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReportMain.this.closePageViewer();
            }
        };
        this.pageViewer.addWindowListener(windowListener);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new PageViewerAction(this));
        JPanel contentPane = (JPanel)this.pageViewer.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", comp);
        contentPane.add("South", closeButton);
        this.pageViewerCanvas.setParent(this.pageViewer);
        this.setPageViewerPosition();
    }

    private void closePageViewer() {
        if (this.pageViewer == null) {
            return;
        }
        this.pageViewer.setVisible(false);
        this.pageViewer.dispose();
        this.pageViewer = null;
        this.pageViewerCanvas = null;
    }

    private void refreshPageViewer() {
        if (this.pageViewerCanvas != null) {
            this.pageViewerCanvas.do_Reload();
        }
    }

    private void setPageViewerPosition() {
        this.pageViewer.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.pageViewer.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.8);
        dim.width = (int)((double)screenSize.width * 0.95);
        int x = (screenSize.width - dim.width) / 2;
        int y = (screenSize.height - dim.height) / 2;
        this.pageViewer.setBounds(x, y, dim.width, dim.height);
        this.pageViewer.setSize(dim);
    }

    public boolean isMainReport() {
        return this.currentReportIndex == 0 && this.report.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot());
    }

    public boolean isSubReport() {
        return this.currentReportIndex > 0;
    }

    public boolean isDrillDownReport() {
        return !this.report.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot());
    }

    public void setHTMLBorder(ReportTableElement elt) {
        if (elt != null) {
            HTMLTableBorderDialog dialog = new HTMLTableBorderDialog(this, elt);
            dialog.setVisible(true);
        }
    }

    public void setPrintOnNewPage(ReportTable table) {
        PrintOnNewPageDialog dialog = new PrintOnNewPageDialog(this, table);
        dialog.setVisible(true);
    }

    private void clearAllSelectedObjects() {
        Vector<JPanel> panels = this.designPanel.rulerPanel.getVisiblePanel();
        for (JPanel jPanel : panels) {
            JPanel o = jPanel;
            if (!(o instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)o;
            panel.groupFormat.clear();
        }
    }

    boolean groupFormatFlag() {
        ReportElementPanel master;
        if (this.masterSectionDialog != null && this.masterSectionDialog.isVisible() && (master = this.designPanel.rulerPanel.getMasterSectionPanel()) != null) {
            return master.groupFormat.size() > 1;
        }
        int count = 0;
        Vector<JPanel> panels = this.designPanel.rulerPanel.getVisiblePanel();
        Vector<ReportElement> linegridheads = new Vector<ReportElement>();
        for (JPanel o : panels) {
            if (!(o instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)o;
            for (ReportElement element : panel.groupFormat) {
                ReportElement obj = element;
                if (ReportElementPanel.isGridOrVertLine(obj)) {
                    ReportElement head = panel.getHeadNode(obj);
                    if (linegridheads.contains(head)) continue;
                    linegridheads.add(head);
                }
                if (++count <= 1) continue;
                return true;
            }
        }
        return count > 1;
    }

    boolean hasNoSelectedObject() {
        Vector<JPanel> panels = this.designPanel.rulerPanel.getVisiblePanel();
        for (JPanel o : panels) {
            if (!(o instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)o;
            if (panel.groupFormat.size() <= 0) continue;
            return false;
        }
        return true;
    }

    private DrillDownNode getCurrentNode(DrillDownNode node, String fileName) {
        if (node == null) {
            return null;
        }
        if (node.getFileName(this.subFilesTable).equals(fileName)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DrillDownNode ddn = this.getCurrentNode(node.getChildAt(i), fileName);
            if (ddn == null) continue;
            return ddn;
        }
        return null;
    }

    public void markUndoCheckPoint(Report backupReport) {
        if (backupReport != null) {
            this.reportBackup = backupReport;
        } else {
            this.createBackupReport();
        }
        this.setIsUndoEnabled(true);
        this.menuBar.setUndoEnabled(true);
    }

    public void markUndoCheckPoint() {
        this.markUndoCheckPoint(null);
    }

    private void insertLastOpenedFile(String fn) {
        RecentFiles.insertFilePath(this.getLoginUser(), 1, fn);
        String[] recentFiles = RecentFiles.getFilePaths(this.getLoginUser(), 1);
        this.updateFileMenu(recentFiles);
        this.menuBar.saveItem.setEnabled(this.isSaveItemEnabled());
        this.menuBar.saveItemWithNoData.setEnabled(this.isSaveItemEnabled());
        this.menuBar.saveItemWithNoData.setEnabled(this.isSaveItemEnabled());
        this.designPanel.designToolBar.saveBt.setEnabled(this.isSaveItemEnabled());
    }

    public void setLoginUser(String username) {
        this.loginUser = username;
        this.updateFileMenu();
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public boolean tryClose(String drillDownFile) {
        boolean completeClose = drillDownFile == null;
        boolean closed = this.close(completeClose);
        if (!closed) {
            return false;
        }
        if (drillDownFile == null) {
            this.closeReportCompletely();
        }
        this.clearUndoRedoList();
        this.menuBar.setDefaultOptions();
        return true;
    }

    public boolean loadFile(String drillDownFile, String file, String oldtitle) {
        return this.loadFile(drillDownFile, file, oldtitle, true, null, null);
    }

    public boolean loadFile(String drillDownFile, String file, String oldtitle, boolean rememberThisFile, Report parentReport, byte[] pakData) {
        this.menuBar.setPasteEnabled(false);
        if (!this.overrideFileLock(file)) {
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LoadReport lr;
            if (oldtitle == null) {
                oldtitle = this.title;
            }
            if (file.toUpperCase().endsWith(".STL")) {
                LoadReportStyle lrs = new LoadReportStyle();
                Report loadedReport = lrs.loadReportFromFile(file);
                this.setReport(loadedReport);
                this.setCursor(this.currentCursor);
                this.title = file;
                this.setTitle(this.title);
                if (rememberThisFile) {
                    this.insertLastOpenedFile(file);
                }
                return true;
            }
            LoadReport loadReport = new LoadReport(true);
            loadReport.setSubFilesTable(this.subFilesTable);
            loadReport.setBackupDataUsed(true);
            loadReport.setDesignerDesignMode(this.isDesignMode);
            loadReport.setSecurityLevel(this.securityLevel);
            loadReport.setRelativeDomainPath(this.relativeDomainPath);
            loadReport.setDesignerDesignMode(true);
            loadReport.setShowWarningDialog(this.showWarningDialog);
            Report loadedReport = pakData != null ? loadReport.loadPakReportFromByteArray(file, pakData) : loadReport.loadReportFromFile(file);
            if (loadedReport == null) {
                this.setCursor(Cursor.getDefaultCursor());
                try {
                    IOUtil.releaseFileLock(file);
                }
                catch (Exception exc) {
                    LOGGER.log(Level.FINEST, "Cannot release file lock", exc);
                }
                this.setCursor(this.currentCursor);
                return false;
            }
            if (LCKey.isFree() && (loadedReport.getSubReports().length > 0 || loadedReport.currentNode.children().hasMoreElements() || loadedReport.getReportChartObjects().length > 0)) {
                this.setCursor(Cursor.getDefaultCursor());
                new JMessageDialog((Frame)this, LanguageEncoder.getText("EspressReport"), "This report contains charts/subreports/drilldowns,\nand only can be opened in full version,\nplease contact sales@quadbase.com for more information.");
                this.setCursor(this.currentCursor);
                return false;
            }
            loadedReport.setFileName(file);
            this.showWarningDialog = loadReport.getShowWarningDialog();
            loadedReport.resetSourceData();
            String original_file = file;
            this.saveAllData = loadedReport.saveAllData;
            LOGGER.finest("loadFile:" + file);
            if (drillDownFile == null && (loadedReport.parentNode != null || loadReport.getDrillDownNode() == null)) {
                throw new Exception(LanguageEncoder.getText("Sub-reports and drill-down reports cannot be opened individually.\n") + LanguageEncoder.getText("Please first open the root report and select the sub report tab or navigate to the specific drill-down for editing."));
            }
            boolean isDrillDownFromSubReport = false;
            if (this.drillDownTree != null && ((DrillDownNode)this.drillDownTree.getModel().getRoot()).getFileName().indexOf("SubReport/") >= 0) {
                isDrillDownFromSubReport = true;
            }
            if ((loadReport.getDrillDownNode() != null || loadedReport.isSubReport()) && loadReport.getDrillDownNode() != null && !isDrillDownFromSubReport) {
                loadReport.getDrillDownNode().setSelected(true);
                this.setDrillDownTree(new JTree(loadReport.getDrillDownNode()));
                loadedReport.currentNode = loadReport.getDrillDownNode();
                if (!file.equals(loadedReport.currentNode.getFileName(this.subFilesTable))) {
                    loadedReport.currentNode.setFileName(file);
                    this.updateChildrenRootNode(loadedReport.currentNode, loadedReport);
                    SaveReport sr = new SaveReport(loadedReport);
                    sr.setSaveNoData(this.saveWithNoData);
                    sr.setDrillDownNode(loadedReport.currentNode);
                    sr.setSubReports(loadedReport.subReports);
                    sr.setSubFilesTable(loadedReport.getSubFilesTable());
                    file = ServerMessage.getSaveFileLink(file);
                    if (SaveReport.isPAKFile(loadedReport.getFileName())) {
                        sr.saveFileToMemory(file);
                    } else {
                        sr.saveToFile(file);
                    }
                }
            } else if (loadedReport.rootNode != null && Report.fileExists(this.subFilesTable, loadedReport.rootNode.getFileName(loadedReport.getSubFilesTable()))) {
                lr = new LoadReport(true);
                lr.setSubFilesTable(this.subFilesTable);
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(this.relativeDomainPath);
                String fname = loadedReport.rootNode.getFileName(loadedReport.getSubFilesTable());
                if (SaveReport.isPAKFile(fname) && this.subFilesTable.containsKey(fname)) {
                    lr.loadPakReportFromByteArray(fname, this.subFilesTable.get(fname));
                } else {
                    lr.loadReportFromFile(fname);
                }
                this.setDrillDownTree(new JTree(lr.getDrillDownNode()));
                loadedReport.currentNode = this.getCurrentNode(lr.getDrillDownNode(), file);
                if (loadedReport.currentNode != null) {
                    loadedReport.currentNode.setSelected(true);
                }
            } else {
                if (this.old_drillDownTree == null) {
                    this.old_drillDownTree = this.drillDownTree;
                }
                DrillDownNode ddn = null;
                if (this.old_drillDownTree != null) {
                    ddn = this.getCurrentNode((DrillDownNode)this.old_drillDownTree.getModel().getRoot(), file);
                }
                if (ddn != null) {
                    loadedReport.currentNode = ddn;
                    this.drillDownTree = this.old_drillDownTree;
                    this.old_drillDownTree = null;
                } else {
                    loadedReport.currentNode = new DrillDownNode();
                    loadedReport.currentNode.setFileName(file);
                }
            }
            if (loadedReport.isSubReport()) {
                lr = new LoadReport(true);
                lr.setRelativeDomainPath(this.relativeDomainPath);
                lr.setBackupDataUsed(true);
                lr.setSubFilesTable(this.subFilesTable);
                String s = loadedReport.parentNode.getFileName(this.subFilesTable);
                s = this.getFileNameWithExtension(s, oldtitle);
                if (parentReport == null || parentReport != null && parentReport.subReports != null && this.subReports != null && parentReport.subReports.size() != this.subReports.size()) {
                    try {
                        parentReport = lr.loadReportFromFile(s);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to load report from file", ex);
                        try {
                            if (s.endsWith(".xml")) {
                                s = s.substring(0, s.length() - 4) + ".rpt";
                                parentReport = lr.loadReportFromFile(s);
                            } else {
                                parentReport = lr.loadReportFromFile(oldtitle);
                            }
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.FINEST, "Failed to load report from file", ex);
                            s = s.replace('\\', '/');
                            s = s.substring(s.lastIndexOf(47) + 1, s.length());
                            parentReport = lr.loadReportFromFile(this.getTemplatesDirectory() + s);
                        }
                    }
                }
                if (parentReport.subReports != null) {
                    int index;
                    boolean found = false;
                    for (index = 0; !found && index < parentReport.subReports.size(); ++index) {
                        SubReportObject sro = parentReport.subReports.elementAt(index);
                        if (!sro.getFileName().equals(original_file)) continue;
                        found = true;
                    }
                    this.setSubReports(parentReport.subReports, index);
                }
            } else if (loadReport.getSubReports() != null) {
                if ((this.drillDownTree == null || drillDownFile == null) && this.isSubReport()) {
                    loadedReport.subReports = this.subReports;
                    SubReportObject sro = this.subReports.elementAt(this.currentReportIndex - 1);
                    loadedReport.setSubReportParameterMap(sro.getFileName(), sro.getParameterMap());
                } else {
                    this.setSubReports(loadReport.getSubReports());
                }
            } else if (loadReport.getDrillDownNode() != null || loadedReport.rootNode != null) {
                this.setSubReports(new Vector<SubReportObject>());
            }
            int idx = this.reportDesignerPane.getSelectedIndex() - 1;
            if ((this.drillDownTree == null || drillDownFile == null) && this.subReports != null && idx >= 0 && this.subReports.elementAt(idx) != null) {
                loadedReport.subReportObject = this.subReports.elementAt(idx);
            }
            this.setReport(loadedReport);
            if (loadedReport.vGuideLines != null) {
                for (int i = 0; i < loadedReport.vGuideLines.size(); ++i) {
                    this.designPanel.rulerPanel.xRuler.addGuideLineToXRuler(QbUtil.toPixel(loadedReport.vGuideLines.elementAt(i).getX()));
                }
            }
            if (loadedReport.hGuideLines != null) {
                for (int i = 0; i < loadedReport.hGuideLines.size(); ++i) {
                    GuideLine gl = loadedReport.hGuideLines.elementAt(i);
                    int y = QbUtil.toPixel(gl.getY());
                    int index = ReportElementPanel.getPanel(gl, this.designPanel.rulerPanel.getVisiblePanel());
                    if (index >= 0) {
                        ReportElementPanel panel = (ReportElementPanel)this.designPanel.rulerPanel.panelList.elementAt(index);
                        y += panel.getOffSet(index);
                    }
                    this.designPanel.rulerPanel.yRuler.addGuideLineToYRuler(y);
                }
            }
            if (this.drillDownTree != null && drillDownFile == null) {
                this.menuBar.setMenuEnabled(true);
                try {
                    this.designPanel.designToolBar.setEnabled(true);
                    this.designPanel.designToolBar2.setEnabled(true);
                    this.previewPanel.previewToolBar.setEnabled(true);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Can't enable toolbars", ex);
                }
                this.title = file;
                this.setTitle(this.title);
                if (this.reportFileName == null) {
                    this.reportFileName = this.title;
                }
            } else if (this.drillDownTree != null && drillDownFile != null) {
                if (this.isReportOpenedInPakFormat() && !drillDownFile.equals(this.subFilesTable.getTopName()) || !this.isReportOpenedInPakFormat()) {
                    this.designPanel.designToolBar.setToolbarForDrillDown();
                    this.menuBar.setMenuForDrillDown();
                }
                this.title = oldtitle;
                this.setTitle(this.title);
            }
            this.checkDataSource();
            this.setCursor(this.currentCursor);
            if (!this.isReportOpenedInPakFormat()) {
                this.setModified(false);
            }
            this.designPanel.rulerPanel.repaintPanel();
            if (rememberThisFile) {
                this.insertLastOpenedFile(original_file);
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot load file", ex);
            this.setCursor(this.currentCursor);
            String msg = ex.getMessage();
            this.errorMessage(msg);
            return false;
        }
    }

    private void updateChildrenRootNode(DrillDownNode rootNode, Report loadedReport) {
        if (loadedReport.currentNode == null || loadedReport.currentNode.children() == null) {
            return;
        }
        Enumeration<TreeNode> children = loadedReport.currentNode.children();
        while (children.hasMoreElements()) {
            DrillDownNode child = (DrillDownNode)children.nextElement();
            LoadReport loadReport = new LoadReport(true);
            loadReport.setBackupDataUsed(true);
            loadReport.setRelativeDomainPath(this.relativeDomainPath);
            loadReport.setShowWarningDialog(false);
            loadReport.setSubFilesTable(loadedReport.getSubFilesTable());
            try {
                Report r = loadReport.loadReportFromFile(child.getFileName(this.subFilesTable));
                if (r.rootNode != null && !rootNode.getFileName(this.subFilesTable).equals(r.rootNode.getFileName())) {
                    r.rootNode.setFileName(rootNode.getFileName(this.subFilesTable));
                    SaveReport sr = new SaveReport(r);
                    sr.setSaveNoData(this.saveWithNoData);
                    sr.setSubReports(r.subReports);
                    sr.setSubFilesTable(this.subFilesTable);
                    String fName = child.getFileName(this.subFilesTable);
                    boolean isPak = fName.toLowerCase().endsWith(".pak");
                    sr.saveToOutput(fName, !isPak, isPak);
                }
                this.updateChildrenRootNode(rootNode, r);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to update drill-down nodes", e);
            }
        }
    }

    private void updateFileMenu() {
        String[] recentFiles = RecentFiles.getFilePaths(this.getLoginUser(), 1);
        this.updateFileMenu(recentFiles);
    }

    private void updateFileMenu(String[] recentFiles) {
        this.menuBar.updateRecentFiles(recentFiles);
    }

    public void setCopyCutEnabled() {
        int countPanelWithSelectedObj = 0;
        Vector<JPanel> panels = this.designPanel.rulerPanel.getVisiblePanel();
        if (this.masterSectionDialog != null && this.masterSectionDialog.isVisible()) {
            panels.removeAllElements();
            panels.addElement(this.designPanel.rulerPanel.getMasterSectionPanel());
        }
        for (JPanel obj : panels) {
            if (obj instanceof ReportElementPanel) {
                ReportElementPanel p = (ReportElementPanel)obj;
                for (ReportElement element : p.groupFormat) {
                    if (!(element instanceof GuideLine)) continue;
                    this.setCopyCutEnabled(false);
                    return;
                }
                if (p.groupFormat.size() != 0) {
                    ++countPanelWithSelectedObj;
                }
            }
            if (countPanelWithSelectedObj <= 1) continue;
            this.setCopyCutEnabled(false);
            return;
        }
        this.setCopyCutEnabled(countPanelWithSelectedObj > 0);
    }

    public void setCopyCutEnabled(boolean state) {
        this.menuBar.setCopyCutEnabled(state);
        this.designPanel.designToolBar.setCopyCutEnabled(state);
    }

    public void clearAllDraggedObjects() {
        Vector<JPanel> panels = this.designPanel.rulerPanel.getVisiblePanel();
        for (JPanel obj : panels) {
            if (!(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            p.clearAllDraggedObjects();
            return;
        }
    }

    private String getFileNameWithExtension(String s, String title) {
        if (title != null && title.toUpperCase().endsWith(".XML")) {
            if (s.toUpperCase().endsWith(".RPT")) {
                s = s.substring(0, s.length() - 4) + ".xml";
            } else if (!s.toUpperCase().endsWith(".XML")) {
                s = s + ".xml";
            }
        } else if (title != null && title.toUpperCase().endsWith(".RPT")) {
            if (s.toUpperCase().endsWith(".XML") || s.toUpperCase().endsWith(".PAK")) {
                s = s.substring(0, s.length() - 4) + ".rpt";
            } else if (!s.toUpperCase().endsWith(".RPT")) {
                s = s + ".rpt";
            }
        } else if (title == null && !s.endsWith(".rpt") && !s.endsWith(".xml")) {
            s = s + ".rpt";
        }
        return s;
    }

    @Override
    public String getRelativeDomainPath() {
        return this.relativeDomainPath;
    }

    public boolean findFirstElementWithCurrentScript() {
        Vector<JPanel> panelList = this.designPanel.rulerPanel.panelList;
        if (panelList != null && panelList.size() > 0) {
            for (int i = 0; i < panelList.size(); ++i) {
                ReportElement relt;
                JPanel ePanelObject = panelList.elementAt(i);
                if (!(ePanelObject instanceof ReportElementPanel) || !((ReportElementPanel)ePanelObject).isVisible() || (relt = ((ReportElementPanel)ePanelObject).findNextElementWithScript(this.currentScript)) == null) continue;
                if (this.selectedObject != null) {
                    this.selectedPanel.unselect(this.selectedObject);
                }
                ((ReportElementPanel)ePanelObject).select(relt, false);
                this.selectedPanel.repaintFromScratch();
                ((ReportElementPanel)ePanelObject).repaintFromScratch();
                ((ReportElementPanel)ePanelObject).updateRulers(relt);
                return true;
            }
        }
        new JMessageDialog((Frame)this, "info", LanguageEncoder.getText("Script is not applied to any cell/section"));
        return false;
    }

    public boolean findNextElementWithCurrentScript() {
        Vector<JPanel> panelList = this.designPanel.rulerPanel.panelList;
        if (panelList != null && panelList.size() > 0) {
            ReportElement relt;
            JPanel ePanelObject;
            int i;
            int currentPanelIndex = 0;
            for (i = 0; i < panelList.size(); ++i) {
                if (panelList.elementAt(i) != this.selectedPanel) continue;
                currentPanelIndex = i;
                break;
            }
            for (i = currentPanelIndex; i < panelList.size(); ++i) {
                ePanelObject = panelList.elementAt(i);
                if (!(ePanelObject instanceof ReportElementPanel) || !((ReportElementPanel)ePanelObject).isVisible()) continue;
                relt = null;
                relt = i == currentPanelIndex ? ((ReportElementPanel)ePanelObject).findNextElementWithScript(this.currentScript, this.selectedObject, true) : ((ReportElementPanel)ePanelObject).findNextElementWithScript(this.currentScript);
                if (relt == null) continue;
                if (this.selectedObject != null) {
                    this.selectedPanel.unselect(this.selectedObject);
                    this.selectedPanel.repaintFromScratch();
                }
                this.selectedObject = null;
                while (this.selectedObject == null) {
                    ((ReportElementPanel)ePanelObject).select(relt, false);
                }
                ((ReportElementPanel)ePanelObject).repaintFromScratch();
                ((ReportElementPanel)ePanelObject).updateRulers(relt);
                return true;
            }
            for (i = 0; i <= currentPanelIndex; ++i) {
                ePanelObject = panelList.elementAt(i);
                if (!(ePanelObject instanceof ReportElementPanel) || !((ReportElementPanel)ePanelObject).isVisible()) continue;
                relt = null;
                relt = i == currentPanelIndex ? ((ReportElementPanel)ePanelObject).findNextElementWithScript(this.currentScript, this.selectedObject, false) : ((ReportElementPanel)ePanelObject).findNextElementWithScript(this.currentScript);
                if (relt == null) continue;
                if (this.selectedObject != null) {
                    this.selectedPanel.unselect(this.selectedObject);
                    this.selectedPanel.repaintFromScratch();
                }
                this.selectedObject = null;
                while (this.selectedObject == null) {
                    ((ReportElementPanel)ePanelObject).select(relt, false);
                }
                ((ReportElementPanel)ePanelObject).repaintFromScratch();
                ((ReportElementPanel)ePanelObject).updateRulers(relt);
                return true;
            }
        }
        new JMessageDialog((Frame)this, "info", LanguageEncoder.getText("No more element has this script applied!"));
        return false;
    }

    public boolean findPreviousElementWithCurrentScript() {
        Vector<JPanel> panelList = this.designPanel.rulerPanel.panelList;
        if (panelList != null && panelList.size() > 0) {
            ReportElement relt;
            JPanel ePanelObject;
            int i;
            int currentPanelIndex = 0;
            for (i = 0; i < panelList.size(); ++i) {
                if (panelList.elementAt(i) != this.selectedPanel) continue;
                currentPanelIndex = i;
            }
            for (i = currentPanelIndex; i >= 0; --i) {
                ePanelObject = panelList.elementAt(i);
                if (!(ePanelObject instanceof ReportElementPanel) || !((ReportElementPanel)ePanelObject).isVisible()) continue;
                relt = null;
                relt = i == currentPanelIndex ? ((ReportElementPanel)ePanelObject).findPrevElementWithScript(this.currentScript, this.selectedObject, false) : ((ReportElementPanel)ePanelObject).findPrevElementWithScript(this.currentScript);
                if (relt == null) continue;
                if (this.selectedObject != null) {
                    this.selectedPanel.unselect(this.selectedObject);
                    this.selectedPanel.repaintFromScratch();
                }
                this.selectedObject = null;
                while (this.selectedObject == null) {
                    ((ReportElementPanel)ePanelObject).select(relt, false);
                }
                ((ReportElementPanel)ePanelObject).repaintFromScratch();
                ((ReportElementPanel)ePanelObject).updateRulers(relt);
                return true;
            }
            for (i = panelList.size() - 1; i >= currentPanelIndex; --i) {
                ePanelObject = panelList.elementAt(i);
                if (!(ePanelObject instanceof ReportElementPanel) || !((ReportElementPanel)ePanelObject).isVisible()) continue;
                relt = null;
                relt = i == currentPanelIndex ? ((ReportElementPanel)ePanelObject).findPrevElementWithScript(this.currentScript, this.selectedObject, true) : ((ReportElementPanel)ePanelObject).findPrevElementWithScript(this.currentScript);
                if (relt == null) continue;
                if (this.selectedObject != null) {
                    this.selectedPanel.unselect(this.selectedObject);
                    this.selectedPanel.repaintFromScratch();
                }
                this.selectedObject = null;
                while (this.selectedObject == null) {
                    ((ReportElementPanel)ePanelObject).select(relt, false);
                }
                ((ReportElementPanel)ePanelObject).repaintFromScratch();
                ((ReportElementPanel)ePanelObject).updateRulers(relt);
                return true;
            }
        }
        new JMessageDialog((Frame)this, "info", LanguageEncoder.getText("No more element has this script applied!"));
        return false;
    }

    public static Vector<String> getHideReportMenuItems() {
        return hideReportMenuItems;
    }

    public static void setHideReportMenuItems(Vector<String> v) {
        hideReportMenuItems = v;
    }

    @Override
    public FileInMemTable getSubFilesTable() {
        return this.subFilesTable;
    }

    @Override
    public void resetSubFilesTable() {
        this.subFilesTable = new FileInMemTable();
    }

    protected boolean overrideFileLock(String infile) {
        String fileLockString = this.getFileLockString(infile);
        if (fileLockString == null || fileLockString.equals("")) {
            return true;
        }
        boolean isMyFileLock = this.compareFileLock(fileLockString);
        if (!isMyFileLock) {
            JMessageDialog msgDialog;
            int response;
            int loc = fileLockString.indexOf(63);
            String fromMachineName = fileLockString;
            if (loc > 0) {
                fromMachineName = fileLockString.substring(0, loc);
            }
            if ((response = (msgDialog = JMessageDialog.optionDialog(this, "Question", "The File is Locked by you on '" + fromMachineName + "',do you want to override the lock?", 2)).getResponse()) == 5) {
                return false;
            }
            this.overrideFileLockOnServer(infile);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getFileLockString(String infile) {
        if (!ServerMessage.useServer) {
            return "";
        }
        try {
            String machineStr;
            IConnection socket = null;
            try {
                socket = ServerMessage.createConnection();
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                dout.writeShort(26004);
                dout.writeBoolean(false);
                IOUtil.writeString(dout, infile);
                machineStr = ServerMessage.getHostAddress() + "?OrgUserName=" + ServerMessage.getOrgUserName() + "&OrgUserToken=" + ServerMessage.getOrgUserToken();
                IOUtil.writeString(dout, machineStr);
                dout.writeInt(1);
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Communication with server failed", ex);
                try {
                    if (socket == null) return "";
                    socket.close();
                    return "";
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
                }
                return "";
            }
            String fileLockInfo = "";
            DataInputStream dstream = null;
            try {
                dstream = new DataInputStream(socket.getInputStream());
                machineStr = fileLockInfo = IOUtil.readString(dstream, true);
                return machineStr;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to read file lock string", ex);
                String string = "";
                return string;
            }
            finally {
                if (dstream != null) {
                    dstream.close();
                }
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
                }
            }
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Cannot get file lock string", ex2);
            return "";
        }
    }

    protected boolean compareFileLock(String fileLockStr) {
        int loc = fileLockStr.indexOf(63);
        if (loc < 0) {
            return true;
        }
        if (ServerMessage.getOrgUserName() == null || ServerMessage.getOrgUserName() == "") {
            return true;
        }
        String paramStr = fileLockStr.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(paramStr, "&");
        String fileLockUserName = "";
        String fileLockUserToken = "";
        while (st.hasMoreTokens()) {
            String kvStr = st.nextToken();
            loc = kvStr.indexOf(61);
            String key = kvStr.substring(0, loc);
            String val = kvStr.substring(loc + 1);
            if (key.equals("OrgUserName")) {
                fileLockUserName = val;
                continue;
            }
            if (!key.equals("OrgUserToken")) continue;
            fileLockUserToken = val;
        }
        if (fileLockUserName == "" || fileLockUserToken == "") {
            return true;
        }
        return !fileLockUserName.equals(ServerMessage.getOrgUserName()) || fileLockUserToken.equals(ServerMessage.getOrgUserToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String overrideFileLockOnServer(String infile) {
        String string;
        if (!ServerMessage.useServer) {
            return "";
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(26004);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, infile);
        String machineStr = ServerMessage.getHostAddress() + "?OrgUserName=" + ServerMessage.getOrgUserName() + "&OrgUserToken=" + ServerMessage.getOrgUserToken();
        IOUtil.writeString(dout, machineStr);
        dout.writeInt(3);
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Override file lock on server: connection failed", ex);
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            return "";
        }
        String fileLockInfo = "";
        DataInputStream dstream = null;
        try {
            dstream = new DataInputStream(socket.getInputStream());
            string = fileLockInfo = IOUtil.readString(dstream, true);
        }
        catch (Exception ex) {
            String string2;
            try {
                LOGGER.log(Level.FINE, "Failed to read file lock string", ex);
                string2 = "";
            }
            catch (Throwable throwable) {
                try {
                    CloseUtils.close(dstream);
                    CloseUtils.close(socket);
                    throw throwable;
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINE, "Overriding file lock on server failed", ex2);
                    return "";
                }
            }
            CloseUtils.close(dstream);
            CloseUtils.close(socket);
            return string2;
        }
        CloseUtils.close(dstream);
        CloseUtils.close(socket);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileLockOverrided(String filename) {
        boolean bl;
        if (!ServerMessage.useServer) {
            return false;
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(26004);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, filename);
        String machineStr = ServerMessage.getHostAddress() + "?OrgUserName=" + ServerMessage.getOrgUserName() + "&OrgUserToken=" + ServerMessage.getOrgUserToken();
        IOUtil.writeString(dout, machineStr);
        dout.writeInt(7);
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Check for file lock: connection failed", ex);
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            return false;
        }
        String fileOverrideStr = "";
        DataInputStream dstream = null;
        try {
            dstream = new DataInputStream(socket.getInputStream());
            fileOverrideStr = IOUtil.readString(dstream, true);
            bl = !fileOverrideStr.equals("");
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                LOGGER.log(Level.FINE, "Failed to read file lock string", ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    CloseUtils.close(dstream);
                    CloseUtils.close(socket);
                    throw throwable;
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINE, "Checking for file lock failed", ex2);
                    return false;
                }
            }
            CloseUtils.close(dstream);
            CloseUtils.close(socket);
            return bl2;
        }
        CloseUtils.close(dstream);
        CloseUtils.close(socket);
        return bl;
    }

    public boolean isInReadOnlyFolder() {
        return false;
    }

    public boolean isSaas() {
        return false;
    }

    public boolean isSaveWithNoData() {
        return this.saveWithNoData;
    }

    public void setSaveWithNoData(boolean saveWithNoData) {
        this.saveWithNoData = saveWithNoData;
    }

    public String getAbsoluteDataRegistryPath() {
        return null;
    }

    public boolean isAllowCrosstabElementMove() {
        return this.allowCrosstabElementMove;
    }

    public void setAllowCrosstabElementMove(boolean allowCrosstabElementMove) {
        this.allowCrosstabElementMove = allowCrosstabElementMove;
    }

    public boolean isEnableToc() {
        return this.enableToc;
    }

    public void setEnableToc(boolean enableToc) {
        this.enableToc = enableToc;
    }

    private class PageViewerAction
    implements ActionListener {
        ReportMain reportMain;

        public PageViewerAction(ReportMain rm) {
            this.reportMain = rm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.reportMain.closePageViewer();
        }
    }
}

