/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ColInfoMappingPanel;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.designer.SelectReportFormat;
import quadbase.reportdesigner.designer.UpdateDataSourceWizard;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.util.ColInfo;

public class ReportMapping
extends JPanel
implements ActionListener {
    private JButton next;
    private JButton cancel;
    private JButton back;
    private JButton add;
    private JButton remove;
    private JButton up;
    private JButton down;
    private JButton addAll;
    private JButton removeAll;
    private ReportWizard reportWizard;
    private JPanel prevPanel;
    private JList availList;
    private JList selectedList;
    private String[] availName;
    private Vector selectedName = new Vector();
    private Vector selectedIndex = new Vector();
    private boolean isRedoDataMappingOp = false;
    private int selected;

    public ReportMapping(ReportWizard reportWizard, JPanel prevPanel) {
        this.reportWizard = reportWizard;
        this.prevPanel = prevPanel;
        this.init();
    }

    public ReportMapping(ReportWizard reportWizard, boolean isRedoDataMappingOp) {
        this.reportWizard = reportWizard;
        this.isRedoDataMappingOp = isRedoDataMappingOp;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Set Report Mapping")));
        topPanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new GridLayout(1, 4, 5, 5));
        titlePanel.add(new JLabel(LanguageEncoder.getText("Available Column Fields")));
        titlePanel.add(new JLabel(""));
        titlePanel.add(new JLabel(LanguageEncoder.getText("Selected Column Fields")));
        titlePanel.add(new JLabel(""));
        this.availName = new String[this.reportWizard.colData.length - 1];
        for (int i = 0; i < this.availName.length; ++i) {
            this.availName[i] = this.reportWizard.colData[i].getName() + "(" + DataType.getTypeName(this.reportWizard.colData[i].getOriginalDataType()) + ")";
        }
        this.availList = new JList<String>(this.availName);
        MouseAdapter addListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int idx = ReportMapping.this.availList.locationToIndex(e.getPoint());
                    ReportMapping.this.selectedName.addElement(ReportMapping.this.availName[idx]);
                    ReportMapping.this.selectedIndex.addElement(idx);
                    ReportMapping.this.selectedList.setListData(ReportMapping.this.selectedName);
                }
            }
        };
        this.availList.addMouseListener(addListener);
        if (this.isRedoDataMappingOp) {
            String[] selNames = new String[this.reportWizard.colInfo.length];
            for (int i = 0; i < this.reportWizard.colInfo.length; ++i) {
                selNames[i] = this.reportWizard.colData[this.reportWizard.colInfo[i].getMapping()].getName() + "(" + DataType.getTypeName(this.reportWizard.colData[this.reportWizard.colInfo[i].getMapping()].getOriginalDataType()) + ")";
                this.selectedName.add(selNames[i]);
                this.selectedIndex.add(this.reportWizard.colInfo[i].getMapping());
            }
            this.selectedList = new JList<String>(selNames);
        } else {
            this.selectedList = new JList<String>(new String[]{""});
        }
        MouseAdapter removeListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int idx = ReportMapping.this.selectedList.locationToIndex(e.getPoint());
                    ReportMapping.this.selectedName.removeElementAt(idx);
                    ReportMapping.this.selectedIndex.removeElementAt(idx);
                    ReportMapping.this.selectedList.setListData(ReportMapping.this.selectedName);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ReportMapping.this.selected = ReportMapping.this.selectedList.locationToIndex(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int idx = ReportMapping.this.selectedList.locationToIndex(e.getPoint());
                if (idx != ReportMapping.this.selected) {
                    Object obj = ReportMapping.this.selectedName.remove(ReportMapping.this.selected);
                    Object obj2 = ReportMapping.this.selectedIndex.remove(ReportMapping.this.selected);
                    ReportMapping.this.selectedName.add(idx, obj);
                    ReportMapping.this.selectedIndex.add(idx, obj2);
                    ReportMapping.this.selectedList.setListData(ReportMapping.this.selectedName);
                    ReportMapping.this.selectedList.setSelectedIndex(idx);
                }
            }
        };
        this.selectedList.addMouseListener(removeListener);
        JPanel listButtonPanel = new JPanel();
        listButtonPanel.setLayout(new GridLayout(6, 1, 5, 5));
        listButtonPanel.add(new JLabel(""));
        this.add = new JButton(LanguageEncoder.getText("ADD >>"));
        listButtonPanel.add(this.add);
        this.add.addActionListener(this);
        this.addAll = new JButton(LanguageEncoder.getText("ADD ALL>>"));
        listButtonPanel.add(this.addAll);
        this.addAll.addActionListener(this);
        this.remove = new JButton(LanguageEncoder.getText("<< REMOVE"));
        listButtonPanel.add(this.remove);
        this.remove.addActionListener(this);
        this.removeAll = new JButton(LanguageEncoder.getText("<< REMOVE ALL"));
        listButtonPanel.add(this.removeAll);
        this.removeAll.addActionListener(this);
        listButtonPanel.add(new JLabel(""));
        JPanel updownButtonPanel = new JPanel();
        updownButtonPanel.setLayout(new GridLayout(5, 1, 5, 5));
        updownButtonPanel.add(new JLabel(""));
        this.up = new JButton(LanguageEncoder.getText("UP"));
        updownButtonPanel.add(this.up);
        this.up.addActionListener(this);
        updownButtonPanel.add(new JLabel(""));
        this.down = new JButton(LanguageEncoder.getText("DOWN"));
        updownButtonPanel.add(this.down);
        this.down.addActionListener(this);
        updownButtonPanel.add(new JLabel(""));
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridLayout(1, 4));
        listPanel.add(new JScrollPane(this.availList));
        listPanel.add(listButtonPanel);
        listPanel.add(new JScrollPane(this.selectedList));
        listPanel.add(updownButtonPanel);
        topPanel.add("North", titlePanel);
        topPanel.add("Center", listPanel);
        this.add("Center", topPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new FlowLayout(2));
        this.next = new JButton(LanguageEncoder.getText("Next >>"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.back = new JButton(LanguageEncoder.getText("<< Back"));
        buttonPanel.add(this.back);
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.next);
        this.next.addActionListener(this);
        this.cancel.addActionListener(this);
        this.back.addActionListener(this);
        this.add("South", buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancel) {
            this.reportWizard.cancel();
        }
        if (target == this.back) {
            if (this.isRedoDataMappingOp) {
                this.reportWizard.swapPanel(this, new SelectReportFormat(this.reportWizard, this.isRedoDataMappingOp));
            } else {
                this.reportWizard.swapPanel(this, this.prevPanel);
            }
        } else if (target == this.next) {
            int i;
            String str = null;
            if ((this.reportWizard.reportType == 0 || this.reportWizard.reportType == 4) && this.selectedIndex.size() < 1) {
                str = LanguageEncoder.getText("Please add at least 1 field for Columnar / Mailing Labels report!");
            }
            if (this.reportWizard.reportType == 1 && this.selectedIndex.size() < 2) {
                str = LanguageEncoder.getText("Please add at least 2 fields for Summary Break report!");
            }
            if (this.reportWizard.reportType == 2 && this.selectedIndex.size() < 3) {
                str = LanguageEncoder.getText("Please add at least 3 fields for Cross Tab report!");
            }
            if (this.reportWizard.reportType == 3 && this.selectedIndex.size() < 2) {
                str = LanguageEncoder.getText("Please add at least 2 fields for Master Details report!");
            }
            if (str != null) {
                new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Warning"), str);
                return;
            }
            ColInfo[] colInfo = new ColInfo[this.selectedIndex.size()];
            for (i = 0; i < this.selectedIndex.size(); ++i) {
                colInfo[i] = new ColInfo((Integer)this.selectedIndex.elementAt(i));
            }
            if (this.isRedoDataMappingOp) {
                if (colInfo.length == this.reportWizard.colInfo.length) {
                    for (i = 0; i < colInfo.length; ++i) {
                        if (this.reportWizard.colInfo[i].getMapping() == colInfo[i].getMapping()) continue;
                        this.reportWizard.setModified();
                        this.changeDrillDownColumnMapping(colInfo);
                        this.reportWizard.colInfo = colInfo;
                        break;
                    }
                } else {
                    this.reportWizard.setModified();
                    this.changeDrillDownColumnMapping(colInfo);
                    this.reportWizard.colInfo = colInfo;
                }
            } else {
                this.reportWizard.colInfo = colInfo;
            }
            if (this.isRedoDataMappingOp) {
                this.reportWizard.swapPanel(this, new ColInfoMappingPanel(this.reportWizard, this.isRedoDataMappingOp));
            } else if (this.reportWizard instanceof UpdateDataSourceWizard) {
                this.reportWizard.swapPanel(this, new ColInfoMappingPanel(this.reportWizard, this, true));
            } else {
                this.reportWizard.swapPanel(this, new ColInfoMappingPanel(this.reportWizard, this));
            }
        } else if (target == this.add) {
            int[] tmp = this.availList.getSelectedIndices();
            this.availList.clearSelection();
            this.selectedList.clearSelection();
            if (tmp == null || tmp.length == 0) {
                return;
            }
            for (int element : tmp) {
                this.selectedName.addElement(this.availName[element]);
                this.selectedIndex.addElement(element);
            }
            this.selectedList.setListData(this.selectedName);
        } else if (target == this.remove) {
            int[] tmp = this.selectedList.getSelectedIndices();
            this.selectedList.clearSelection();
            if (tmp == null || tmp.length == 0) {
                return;
            }
            for (int i = tmp.length - 1; i >= 0; --i) {
                this.selectedName.removeElementAt(tmp[i]);
                this.selectedIndex.removeElementAt(tmp[i]);
            }
            this.selectedList.setListData(this.selectedName);
        } else if (target == this.addAll) {
            this.availList.clearSelection();
            this.selectedList.clearSelection();
            this.selectedName.removeAllElements();
            this.selectedIndex.removeAllElements();
            for (int i = 0; i < this.availName.length; ++i) {
                this.selectedName.addElement(this.availName[i]);
                this.selectedIndex.addElement(i);
            }
            this.selectedList.setListData(this.selectedName);
        } else if (target == this.removeAll) {
            this.availList.clearSelection();
            this.selectedList.clearSelection();
            for (int i = 0; i < this.selectedName.size(); ++i) {
                this.selectedName.removeAllElements();
                this.selectedIndex.removeAllElements();
            }
            this.selectedList.setListData(this.selectedName);
        } else if (target == this.up) {
            int[] tmp = this.selectedList.getSelectedIndices();
            if (tmp == null || tmp.length == 0) {
                return;
            }
            int prev = this.selectedList.getMinSelectionIndex() - 1;
            if (prev < 0) {
                prev = 0;
            }
            for (int i = 0; i < tmp.length; ++i) {
                Object nameObj = this.selectedName.remove(tmp[i]);
                Object indexObj = this.selectedIndex.remove(tmp[i]);
                this.selectedName.add(prev + i, nameObj);
                this.selectedIndex.add(prev + i, indexObj);
            }
            this.selectedList.setListData(this.selectedName);
            int[] tmp2 = new int[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp2[i] = prev + i;
            }
            this.selectedList.setSelectedIndices(tmp2);
        } else if (target == this.down) {
            int[] tmp = this.selectedList.getSelectedIndices();
            if (tmp == null || tmp.length == 0) {
                return;
            }
            int con = this.selectedList.getMaxSelectionIndex() + 1;
            if (con > this.selectedIndex.size() - 1) {
                con = this.selectedIndex.size() - 1;
            }
            for (int i = 0; i < tmp.length; ++i) {
                Object nameObj = this.selectedName.remove(tmp[i] - i);
                Object indexObj = this.selectedIndex.remove(tmp[i] - i);
                this.selectedName.add(con, nameObj);
                this.selectedIndex.add(con, indexObj);
            }
            this.selectedList.setListData(this.selectedName);
            int[] tmp2 = new int[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp2[i] = con - tmp.length + i + 1;
            }
            this.selectedList.setSelectedIndices(tmp2);
        }
    }

    private void changeDrillDownColumnMapping(ColInfo[] colInfo) {
        DrillDownNode root = this.reportWizard.report.currentNode;
        if (root == null) {
            return;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DrillDownNode node = root.getChildAt(i);
            int[] columnMapping = new int[node.getColumnMapping().length];
            for (int j = 0; j < node.getColumnMapping().length; ++j) {
                int colDataMapping = this.reportWizard.colInfo[node.getColumnMapping()[j]].getMapping();
                for (int k = 0; k < colInfo.length; ++k) {
                    if (colInfo[k].getMapping() != colDataMapping) continue;
                    columnMapping[j] = k;
                }
            }
            node.setColumnMapping(columnMapping);
        }
    }
}

