/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.JLongMenu;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.RulerPanel;
import quadbase.reportdesigner.designer.SortByDialog;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.util.ColInfo;

public class ReportMenuBar
extends JMenuBar
implements ActionListener,
MenuListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ReportMenuBar.class.getName());
    private static final String GENERATE_PAK_FILE = LanguageEncoder.getText("Generate PAK File");
    protected boolean isReady = false;
    ReportMain reportMain;
    JMenuItem delete;
    JMenuItem copy;
    JMenuItem cut;
    JMenuItem paste;
    JMenuItem undo;
    JMenuItem redo;
    JMenu fileMenu;
    JMenu insertMenu;
    JMenu editMenu;
    JMenu formatMenu;
    JMenu viewMenu;
    JMenu dataMenu;
    JMenu optionMenu;
    JMenu drillMenu;
    JLongMenu visibleColumnMenu;
    JLongMenu visibleSectionMenu;
    JCheckBoxMenuItem showCellOutline;
    JCheckBoxMenuItem shift;
    JCheckBoxMenuItem enableToc;
    JCheckBoxMenuItem formulaName;
    JCheckBoxMenuItem allowPreviewEdit;
    JCheckBoxMenuItem allowCrosstabElementMove;
    JMenuItem saveItem;
    JMenuItem saveItemWithNoData;
    JMenuItem saveAs;
    JMenuItem refresh;
    JMenuItem drillDownLink;
    JMenuItem columnWrap;
    JMenuItem dualColors;
    JMenuItem applyTemplate;
    JMenuItem cellProp;
    JMenuItem security;
    JMenuItem datamapping;
    JMenuItem datasource;
    JMenuItem database;
    JMenuItem dataquery;
    JMenuItem setDisplayRow;
    JMenuItem setSecurityLevel;
    JMenuItem setSecuredQuery;
    JMenuItem chartParamMap;
    JMenuItem subReportParamMap;
    JMenuItem subReportParamShare;
    JMenuItem multiDrillDown;
    JMenuItem insertTableOfContents;
    JMenuItem chartExportFormat;
    JMenuItem insertChart;
    JCheckBoxMenuItem prevParamPrompt;
    JCheckBoxMenuItem explorerItem;
    JMenu insertSubReport;
    JMenu removeSubReport;
    JMenu sortMenu;
    JMenu sortMenu2;
    JMenu exportMenu;
    JMenuItem exportToPakFileMenuItem;
    boolean isAsc;
    RecentFileOpener recentFileOpener = new RecentFileOpener();
    private Vector columnList = new Vector();
    private JCheckBoxMenuItem wordWrap;
    private JCheckBoxMenuItem resizeToFitContent;

    public ReportMenuBar(ReportMain reportmain) {
        this.reportMain = reportmain;
        this.initMenu();
    }

    void updateMenu() {
        this.removeAll();
        this.initMenu(false);
        if (this.reportMain.report == null) {
            this.setMenuEnabled(false);
        }
    }

    public void setMenuEnabled(boolean flag) {
        this.insertMenu.setEnabled(flag);
        this.editMenu.setEnabled(flag);
        this.formatMenu.setEnabled(flag);
        this.viewMenu.setEnabled(false);
        this.dataMenu.setEnabled(flag);
        this.multiDrillDown.setEnabled(false);
        this.optionMenu.setEnabled(flag);
        this.subReportParamShare.setEnabled(false);
        if (!LCKey.isFree()) {
            this.insertSubReport.setEnabled(flag);
            this.drillMenu.setEnabled(flag);
            this.drillDownLink.setEnabled(flag);
            this.subReportParamMap.setEnabled(flag);
            this.chartParamMap.setEnabled(flag);
        } else {
            this.insertSubReport.setEnabled(false);
            this.insertSubReport.setText(LanguageEncoder.getText("Insert Sub-Report (Full version only)"));
            this.insertSubReport.setToolTipText(LanguageEncoder.getText("This feature is only included in full version, please contact sales@quadbase.com for more information."));
            this.drillMenu.setEnabled(false);
            this.drillMenu.setToolTipText(LanguageEncoder.getText("This feature is only included in full version, please contact sales@quadbase.com for more information."));
            this.drillDownLink.setEnabled(false);
            this.subReportParamMap.setEnabled(false);
            this.chartParamMap.setEnabled(false);
        }
        if (this.reportMain.subReports != null && this.reportMain.subReports.size() > 0 && !LCKey.isFree()) {
            this.removeSubReport.setEnabled(flag);
        } else {
            this.removeSubReport.setEnabled(false);
        }
        this.insertTableOfContents.setEnabled(flag);
        this.enableToc.setEnabled(flag);
        this.saveItem.setEnabled(flag && this.reportMain.isSaveItemEnabled());
        this.saveItemWithNoData.setEnabled(flag && this.reportMain.isSaveItemEnabled());
        if (this.reportMain.report != null && this.reportMain.report.currentNode != null && this.reportMain.getDrillDownTree() != null) {
            this.saveAs.setEnabled(this.reportMain.isMainReport());
        } else {
            this.saveAs.setEnabled(flag);
        }
        this.exportToPakFileMenuItem.setVisible(!flag);
        if (this.reportMain.report == null) {
            this.setColumnWrapEnabled(false);
        } else {
            this.setColumnWrapEnabled(this.reportMain.report.getReportType() == 0 || this.reportMain.report.getReportType() == 4 || this.reportMain.report.getReportType() == 1);
        }
        if (this.reportMain.designPanel != null) {
            this.reportMain.designPanel.designToolBar.setEnabled(flag);
            this.reportMain.designPanel.designToolBar2.setEnabled(flag);
        }
        if (this.reportMain.previewPanel != null) {
            this.reportMain.previewPanel.previewToolBar.setEnabled(flag);
        }
        this.exportMenu.setEnabled(flag);
        this.applyTemplate.setEnabled(flag);
        this.cellProp.setEnabled(flag);
        this.security.setEnabled(flag);
        this.setDisplayRow.setEnabled(flag);
        this.setSecurityLevel.setEnabled(flag);
        this.prevParamPrompt.setEnabled(flag);
        this.explorerItem.setEnabled(flag);
        boolean securityState = flag && !this.reportMain.isSecureMode();
        boolean securityState2 = flag && !this.reportMain.isSecurityLevelApplied();
        this.security.setEnabled(securityState);
        this.applyTemplate.setEnabled(securityState2);
        this.setSecurityLevel.setEnabled(securityState);
        this.setSecuredQuery.setEnabled(securityState);
        this.datamapping.setEnabled(securityState2);
        this.datasource.setEnabled(securityState2);
        this.database.setEnabled(securityState2);
        this.dataquery.setEnabled(securityState2);
        if (flag) {
            this.reportMain.enableUndoRedoButtons();
        }
        this.setMenuForSTL();
    }

    public void setMenuForPreview() {
        if (this.reportMain.report == null) {
            this.setMenuEnabled(false);
        }
        this.editMenu.setEnabled(false);
        this.insertMenu.setEnabled(false);
        this.formatMenu.setEnabled(false);
        this.viewMenu.setEnabled(true);
        this.multiDrillDown.setEnabled(true);
        this.drillMenu.setEnabled(false);
        this.optionMenu.setEnabled(false);
        this.applyTemplate.setEnabled(false);
        this.cellProp.setEnabled(false);
        this.security.setEnabled(false);
        this.setDisplayRow.setEnabled(false);
        this.setSecurityLevel.setEnabled(false);
        this.setSecuredQuery.setEnabled(false);
        this.prevParamPrompt.setEnabled(false);
        this.subReportParamShare.setEnabled(false);
        boolean securityState2 = !this.reportMain.isSecurityLevelApplied();
        this.datamapping.setEnabled(securityState2);
        this.datasource.setEnabled(securityState2);
        this.database.setEnabled(securityState2);
        this.dataquery.setEnabled(securityState2);
        this.setMenuForSTL();
    }

    public void setMenuForDrillDown() {
        if (LCKey.isFree()) {
            return;
        }
        this.setMenuEnabled(true);
        this.exportToPakFileMenuItem.setVisible(true);
        this.saveItem.setEnabled(this.reportMain.isSaveItemEnabled());
        this.saveItemWithNoData.setEnabled(this.reportMain.isSaveItemEnabled());
        this.saveAs.setEnabled(false);
    }

    public void setMenuForSubReport() {
        if (LCKey.isFree()) {
            return;
        }
        this.setMenuEnabled(true);
        this.exportToPakFileMenuItem.setVisible(true);
        this.drillMenu.setEnabled(true);
        this.drillDownLink.setEnabled(true);
        this.insertSubReport.setEnabled(false);
        this.removeSubReport.setEnabled(false);
        this.saveItem.setEnabled(this.reportMain.isSaveItemEnabled());
        this.saveItemWithNoData.setEnabled(this.reportMain.isSaveItemEnabled());
        this.saveAs.setEnabled(false);
        this.subReportParamMap.setEnabled(false);
        this.chartParamMap.setEnabled(false);
        this.subReportParamShare.setEnabled(true);
        this.insertTableOfContents.setEnabled(false);
        this.enableToc.setSelected(false);
        this.enableToc.setEnabled(false);
    }

    public void setMenuForSTL() {
        if (!this.reportMain.getTitle().toUpperCase().endsWith(".STL")) {
            return;
        }
        this.drillMenu.setEnabled(false);
        this.drillDownLink.setEnabled(false);
        this.insertSubReport.setEnabled(false);
        this.removeSubReport.setEnabled(false);
        this.saveItem.setEnabled(this.reportMain.isSaveItemEnabled());
        this.saveItemWithNoData.setEnabled(this.reportMain.isSaveItemEnabled());
        this.saveAs.setEnabled(false);
        this.subReportParamMap.setEnabled(false);
        this.chartParamMap.setEnabled(false);
        this.subReportParamShare.setEnabled(false);
        this.exportMenu.setEnabled(false);
        this.multiDrillDown.setEnabled(false);
    }

    void initMenu() {
        this.initMenu(true);
    }

    private void initMenu(boolean createFileMenu) {
        this.isReady = false;
        this.addFileMenu(createFileMenu);
        this.addEditMenu();
        this.addInsertMenu();
        this.addFormatMenu();
        this.addViewMenu();
        this.addDataMenu();
        this.addDrillDownMenu();
        this.addOptionMenu();
        this.addHelpMenu();
        this.setMenuForSTL();
        this.addHiddenEscapeItem();
        this.isReady = true;
    }

    private void addHiddenEscapeItem() {
        JMenuItem escapeHiddenItem = new JMenuItem();
        escapeHiddenItem.setVisible(false);
        escapeHiddenItem.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        escapeHiddenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportMenuBar.this.reportMain.resetInsertion();
                ReportMenuBar.this.reportMain.repaint();
            }
        });
        this.add(escapeHiddenItem);
    }

    void addFileMenu() {
        this.addFileMenu(true);
    }

    private void addFileMenu(boolean createFileMenu) {
        if (!createFileMenu) {
            this.add(this.fileMenu);
            return;
        }
        JMenu jmenu = new JMenu(LanguageEncoder.getText("File"));
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("New..."), "New...", 78));
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("Open..."), "Open...", 79));
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("Close"), "Close"));
        this.applyTemplate = this.newMenuItem(LanguageEncoder.getText("Apply Template..."), "Apply Template...");
        jmenu.add(this.applyTemplate);
        jmenu.addSeparator();
        this.saveItem = this.newMenuItem(LanguageEncoder.getText("Save"), "Save", 83);
        this.saveItem.setEnabled(this.reportMain.isSaveItemEnabled());
        jmenu.add(this.saveItem);
        this.saveItemWithNoData = this.newMenuItem(LanguageEncoder.getText("Save With No Data"), "Save With No Data");
        this.saveItemWithNoData.setEnabled(this.reportMain.isSaveItemEnabled());
        jmenu.add(this.saveItemWithNoData);
        this.saveAs = this.newMenuItem(LanguageEncoder.getText("Save As..."), "Save As...");
        jmenu.add(this.saveAs);
        this.exportMenu = new JMenu(LanguageEncoder.getText("Export"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate DHTML"), "Generate DHTML"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate PDF"), "Generate PDF"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate CSV"), "Generate CSV"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate Excel (XLS)"), "Generate EXCEL (XLS)"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate Excel 2007 (XLSX)"), "Generate EXCEL 2007 (XLSX)"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate TXT"), "Generate TXT"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate XML"), "Generate XML"));
        this.exportMenu.add(this.newMenuItem(LanguageEncoder.getText("Generate Rich Text"), "Generate Rich Text"));
        this.exportToPakFileMenuItem = this.newMenuItem(GENERATE_PAK_FILE, GENERATE_PAK_FILE);
        this.exportMenu.add(this.exportToPakFileMenuItem);
        if (!this.reportMain.isSaas()) {
            jmenu.add(this.exportMenu);
        }
        if (ServerMessage.getApplet() == null) {
            jmenu.add(this.newMenuItem(LanguageEncoder.getText("Print"), "Print", 80));
        }
        jmenu.addSeparator();
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("Exit"), "Exit"));
        this.add(jmenu);
        this.fileMenu = jmenu;
    }

    void addEditMenu() {
        this.editMenu = new JMenu(LanguageEncoder.getText("Edit"));
        this.undo = this.newMenuItem(LanguageEncoder.getText("Undo"), "Undo", 90);
        this.redo = this.newMenuItem(LanguageEncoder.getText("Redo"), "Redo", 89);
        this.editMenu.add(this.undo);
        this.editMenu.add(this.redo);
        this.undo.setEnabled(false);
        this.redo.setEnabled(false);
        this.editMenu.addSeparator();
        this.editMenu.add(this.newMenuItem(LanguageEncoder.getText("Edit"), "Edit"));
        this.copy = this.newMenuItem(LanguageEncoder.getText("Copy"), "Copy", 67);
        this.cut = this.newMenuItem(LanguageEncoder.getText("Cut"), "Cut", 88);
        this.paste = this.newMenuItem(LanguageEncoder.getText("Paste"), "Paste", 86);
        this.editMenu.add(this.copy);
        this.editMenu.add(this.cut);
        this.editMenu.add(this.paste);
        if (this.reportMain.designPanel != null) {
            try {
                this.reportMain.setCopyCutEnabled();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Failed to set cut/copy enabled", e);
            }
        }
        this.setPasteEnabled(false);
        this.editMenu.addSeparator();
        this.delete = IOUtil.isMac() ? this.newMenuItem(LanguageEncoder.getText("Delete"), "Delete", 8) : this.newMenuItem(LanguageEncoder.getText("Delete"), "Delete", 127);
        this.editMenu.add(this.delete);
        this.removeSubReport = new JMenu(LanguageEncoder.getText("Remove Sub-Report"));
        this.removeSubReport.setActionCommand("Remove Sub-Report");
        this.removeSubReport.addMenuListener(this);
        this.editMenu.add(this.removeSubReport);
        this.removeSubReport.setEnabled(this.reportMain.subReports != null && this.reportMain.subReports.size() > 0);
        this.add(this.editMenu);
    }

    void addInsertMenu() {
        this.insertMenu = new JMenu(LanguageEncoder.getText("Insert"));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Label"), "Insert Label", 76));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Formula"), "Insert Formula", 70));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Column Field"), "Insert Column Field"));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Database Field"), "Insert Database Field"));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Column Header"), "Insert Column Header"));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Parameter Value"), "Insert Parameter Value"));
        this.insertChart = this.newMenuItem(LanguageEncoder.getText("Insert Chart"), "Insert Chart");
        this.insertMenu.add(this.insertChart);
        if (LCKey.isFree()) {
            this.insertChart.setEnabled(false);
            this.insertChart.setText(LanguageEncoder.getText("Insert Chart (Full version only)"));
            this.insertChart.setToolTipText(LanguageEncoder.getText("This feature is only included in full version, please contact sales@quadbase.com for more information."));
        }
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Image"), "Insert Image"));
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Rich Text Field"), "Insert Rich Text Field"));
        this.insertTableOfContents = this.newMenuItem(LanguageEncoder.getText("Insert Table Of Contents"), "Insert Table Of Contents");
        this.insertMenu.add(this.insertTableOfContents);
        this.insertMenu.addSeparator();
        JMenu jmenu = new JMenu(LanguageEncoder.getText("Insert Line"));
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("Horizontal Line"), "Horizontal Line"));
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("Vertical Line"), "Vertical Line"));
        this.insertMenu.add(jmenu);
        this.insertMenu.add(this.newMenuItem(LanguageEncoder.getText("Insert Rectangle"), "Insert Grid"));
        JMenu jmenu3 = new JMenu(LanguageEncoder.getText("Insert Guideline"));
        jmenu3.add(this.newMenuItem(LanguageEncoder.getText("Horizontal"), "Horizontal"));
        jmenu3.add(this.newMenuItem(LanguageEncoder.getText("Vertical"), "Vertical"));
        this.insertMenu.add(jmenu3);
        this.insertMenu.addSeparator();
        JMenu jmenu1 = new JMenu(LanguageEncoder.getText("Today's Date"));
        jmenu1.add(this.newMenuItem(LanguageEncoder.getText("Date"), "Date"));
        jmenu1.add(this.newMenuItem(LanguageEncoder.getText("Date & Time"), "Date & Time"));
        jmenu1.add(this.newMenuItem(LanguageEncoder.getText("Time"), "Time"));
        this.insertMenu.add(jmenu1);
        JMenu jmenu2 = new JMenu(LanguageEncoder.getText("Page Number"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Page Number"), "Page Number"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Page Number Of Total Pages"), "Page Number Of Total Pages"));
        this.insertMenu.add(jmenu2);
        this.insertMenu.addSeparator();
        this.insertSubReport = new JMenu(LanguageEncoder.getText("Insert Sub-Report"));
        this.insertSubReport.setActionCommand("Insert Sub-Report");
        this.insertSubReport.addMenuListener(this);
        this.insertMenu.add(this.insertSubReport);
        this.add(this.insertMenu);
    }

    void addFormatMenu() {
        this.createFormatMenu();
        this.formatMenu.addSeparator();
        this.add(this.formatMenu);
    }

    private void createFormatMenu() {
        this.formatMenu = new JMenu(LanguageEncoder.getText("Format"));
        this.formatMenu.addMenuListener(this);
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Data Format"), "Data Format"));
        this.chartExportFormat = this.newMenuItem(LanguageEncoder.getText("Chart Export Format"), "Chart Export Format");
        this.formatMenu.add(this.chartExportFormat);
        if (LCKey.isFree()) {
            this.chartExportFormat.setEnabled(false);
        }
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Edit Attributes"), "Edit Attributes"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Font Style And Size"), "Font Style And Size"));
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Background Color"), "Background Color"));
        this.dualColors = this.newMenuItem(LanguageEncoder.getText("Dual Colors"), "Dual Colors");
        this.formatMenu.add(this.dualColors);
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Line Color & Thickness"), "Line Color & Thickness"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Border"), "Border"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("HyperLink"), "HyperLink"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Scripting"), "Scripting"));
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Rotation"), "Rotation"));
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Z-index"), "Z-index"));
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Bounds"), "Bounds"));
        JMenu alignMenu = new JMenu(LanguageEncoder.getText("Alignment"));
        JMenu horizontalAlign = new JMenu(LanguageEncoder.getText("Horizontal"));
        JMenu verticalAlign = new JMenu(LanguageEncoder.getText("Vertical"));
        horizontalAlign.add(this.newMenuItem(LanguageEncoder.getText("Left"), "Left"));
        horizontalAlign.add(this.newMenuItem(LanguageEncoder.getText("Center"), "Center"));
        horizontalAlign.add(this.newMenuItem(LanguageEncoder.getText("Right"), "Right"));
        verticalAlign.add(this.newMenuItem(LanguageEncoder.getText("Top"), "Top"));
        verticalAlign.add(this.newMenuItem(LanguageEncoder.getText("Middle"), "Middle"));
        verticalAlign.add(this.newMenuItem(LanguageEncoder.getText("Bottom"), "Bottom"));
        alignMenu.add(horizontalAlign);
        alignMenu.add(verticalAlign);
        this.formatMenu.add(alignMenu);
        this.addWordwrapMenu(this.formatMenu);
        this.addResizeToFitContentMenu(this.formatMenu);
        this.visibleColumnMenu = new JLongMenu(LanguageEncoder.getText("Make Column Visible"));
        this.visibleColumnMenu.addMenuListener(this);
        this.formatMenu.add(this.visibleColumnMenu);
        this.visibleSectionMenu = new JLongMenu(LanguageEncoder.getText("Make Section Visible"));
        this.visibleSectionMenu.addMenuListener(this);
        this.formatMenu.add(this.visibleSectionMenu);
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Invisible"), "Invisible"));
        this.formatMenu.addSeparator();
        this.columnWrap = this.newMenuItem(LanguageEncoder.getText("Column Wrap"), "Column Wrap");
        this.formatMenu.add(this.columnWrap);
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Auto Fit Columns"), "Auto Fit Columns"));
        if (this.reportMain.report == null) {
            this.setColumnWrapEnabled(false);
        } else {
            this.setColumnWrapEnabled(this.reportMain.report.getReportType() == 0 || this.reportMain.report.getReportType() == 4 || this.reportMain.report.getReportType() == 1);
        }
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.newMenuItem(LanguageEncoder.getText("Swap Columns"), "Swap Columns"));
    }

    private void addViewMenu() {
        this.viewMenu = new JMenu(LanguageEncoder.getText("View"));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("First Page"), "First Page"));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Previous Page"), "Previous Page"));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Next Page"), "Next Page"));
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Last Page"), "Last Page"));
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Go To Page..."), "Go To Page..."));
        this.viewMenu.addSeparator();
        this.sortMenu = new JMenu(LanguageEncoder.getText("Sort by (ascend)"));
        this.sortMenu2 = new JMenu(LanguageEncoder.getText("Sort by (descend)"));
        this.sortMenu.addMenuListener(this);
        this.sortMenu2.addMenuListener(this);
        this.viewMenu.add(this.sortMenu);
        this.viewMenu.add(this.sortMenu2);
        this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Sort by ..."), "Sort by ... "));
        if (ServerMessage.useServer) {
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.newMenuItem(LanguageEncoder.getText("Launch PageViewer"), "Launch PageViewer"));
        }
        this.add(this.viewMenu);
    }

    private void addDataMenu() {
        this.dataMenu = new JMenu(LanguageEncoder.getText("Data"));
        this.refresh = this.newMenuItem(LanguageEncoder.getText("Refresh"), "Refresh");
        this.dataMenu.add(this.refresh);
        this.dataMenu.addSeparator();
        this.datamapping = this.newMenuItem(LanguageEncoder.getText("Change Data Mapping"), "Change data mapping");
        this.dataMenu.add(this.datamapping);
        this.datasource = this.newMenuItem(LanguageEncoder.getText("Change Data Source"), "Change data source");
        this.dataMenu.add(this.datasource);
        this.database = this.newMenuItem(LanguageEncoder.getText("Modify Database"), "Modify Database");
        this.dataMenu.add(this.database);
        this.dataquery = this.newMenuItem(LanguageEncoder.getText("Modify Query"), "Modify query");
        this.dataMenu.add(this.dataquery);
        this.dataMenu.addSeparator();
        this.dataMenu.add(this.newMenuItem(LanguageEncoder.getText("View Column Mapping"), "View Column Mapping"));
        this.dataMenu.add(this.newMenuItem(LanguageEncoder.getText("View Table"), "View table"));
        this.dataMenu.add(this.newMenuItem(LanguageEncoder.getText("View Data Source Info"), "View Data Source Info"));
        this.dataMenu.addSeparator();
        this.subReportParamShare = this.newMenuItem(LanguageEncoder.getText("Sub-Report Parameter Sharing"), "Sub-Report Parameter Sharing");
        this.dataMenu.add(this.subReportParamShare);
        this.subReportParamMap = this.newMenuItem(LanguageEncoder.getText("Sub-Report Parameter Mapping..."), "Sub-Report Parameter Mapping...");
        this.dataMenu.add(this.subReportParamMap);
        this.chartParamMap = this.newMenuItem(LanguageEncoder.getText("Chart Parameter Mapping..."), "Chart Parameter Mapping...");
        this.dataMenu.add(this.chartParamMap);
        this.multiDrillDown = this.newMenuItem(LanguageEncoder.getText("Select Multiple Drill-Down Values..."), "Select Multiple Drill-Down Values...");
        this.dataMenu.add(this.multiDrillDown);
        this.dataMenu.addSeparator();
        this.security = this.newMenuItem(LanguageEncoder.getText("Security..."), "Security");
        this.dataMenu.add(this.security);
        this.cellProp = this.newMenuItem(LanguageEncoder.getText("Cell Properties"), "Cell Properties");
        this.dataMenu.add(this.cellProp);
        this.dataMenu.addSeparator();
        this.setSecurityLevel = this.newMenuItem(LanguageEncoder.getText("Set Preview Security Level"), "Set Preview Security Level");
        this.dataMenu.add(this.setSecurityLevel);
        this.setDisplayRow = this.newMenuItem(LanguageEncoder.getText("Set Preview Data Options"), "Set Preview Data Options");
        this.dataMenu.add(this.setDisplayRow);
        this.dataMenu.addSeparator();
        this.setSecuredQuery = this.newMenuItem(LanguageEncoder.getText("Secured Query Parameters..."), "Secured Query Parameters");
        this.dataMenu.add(this.setSecuredQuery);
        boolean isPrevParamPrompt = true;
        if (this.reportMain != null && this.reportMain.report != null) {
            isPrevParamPrompt = this.reportMain.report.isPrevParamPrompt;
        }
        this.prevParamPrompt = new JCheckBoxMenuItem(LanguageEncoder.getText("Preview Parameter Prompt"), isPrevParamPrompt);
        this.prevParamPrompt.addActionListener(this);
        this.prevParamPrompt.setActionCommand("Preview Parameter Prompt");
        this.dataMenu.add(this.prevParamPrompt);
        this.add(this.dataMenu);
    }

    private void addDrillDownMenu() {
        this.drillMenu = new JMenu(LanguageEncoder.getText("Drill-Down"));
        this.drillMenu.add(this.newMenuItem(LanguageEncoder.getText("Navigate"), "Navigate"));
        this.drillDownLink = this.newMenuItem(LanguageEncoder.getText("Drill-Down Link"), "Drill-Down Link");
        this.drillMenu.add(this.drillDownLink);
        this.add(this.drillMenu);
    }

    void setExplorerItemState(boolean b) {
        this.explorerItem.setSelected(b);
    }

    private void addOptionMenu() {
        this.optionMenu = new JMenu(LanguageEncoder.getText("Option"));
        this.explorerItem = new JCheckBoxMenuItem(LanguageEncoder.getText("Report Explorer"), this.reportMain.isExplorerVisible());
        this.explorerItem.addActionListener(this);
        this.explorerItem.setActionCommand("Report Explorer");
        this.optionMenu.add(this.explorerItem);
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Page Setup"), "Page Setup"));
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("HTML Page Title"), "HTML Page Title"));
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Background Color..."), "Report Background Color"));
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Background Image..."), "Report Background Image"));
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Snap To Grid"), "Snap To Grid"));
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Font Mapping..."), "Font Mapping"));
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Viewer Font Setup..."), "Viewer Font Setup"));
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Export Style Sheet..."), "Export Style Sheet"));
        this.optionMenu.addSeparator();
        boolean showOutline = false;
        boolean showFormulaName = false;
        boolean isTocEnabled = false;
        if (this.reportMain.report != null) {
            showOutline = this.reportMain.report.showCellOutline;
            showFormulaName = this.reportMain.report.showFormulaNameSelected;
            isTocEnabled = this.reportMain.report.isTocEnabled();
        }
        this.showCellOutline = new JCheckBoxMenuItem(LanguageEncoder.getText("Show Cell Outline"), showOutline);
        this.showCellOutline.addActionListener(this);
        this.showCellOutline.setActionCommand("CellOutline");
        this.optionMenu.add(this.showCellOutline);
        this.shift = new JCheckBoxMenuItem(LanguageEncoder.getText("Shift"), this.reportMain.isShiftSelected);
        this.shift.addActionListener(this);
        this.shift.setActionCommand("Shift");
        this.optionMenu.add(this.shift);
        this.formulaName = new JCheckBoxMenuItem(LanguageEncoder.getText("Show formula Name"), showFormulaName);
        this.formulaName.addActionListener(this);
        this.formulaName.setActionCommand("FormulaName");
        this.optionMenu.add(this.formulaName);
        this.enableToc = new JCheckBoxMenuItem(LanguageEncoder.getText("Enable Table Of Contents"), isTocEnabled);
        this.enableToc.addActionListener(this);
        this.enableToc.setActionCommand("Enable Toc");
        this.optionMenu.add(this.enableToc);
        this.optionMenu.addSeparator();
        this.allowCrosstabElementMove = new JCheckBoxMenuItem(LanguageEncoder.getText("Allow Crosstab elements to move/delete/insert"), false);
        this.allowCrosstabElementMove.addActionListener(this);
        this.allowCrosstabElementMove.setActionCommand("CrosstabElementMove");
        this.optionMenu.add(this.allowCrosstabElementMove);
        this.optionMenu.addSeparator();
        JMenu jmenu2 = new JMenu(LanguageEncoder.getText("Global Format"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Label"), "Label"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Formula"), "Formula"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Column"), "Column"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Chart"), "Chart"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Image"), "Image"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Line"), "Line"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Rectangle"), "Grid"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Column Header"), "ColumnHeader"));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Title"), "Title"));
        jmenu2.addSeparator();
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Export..."), "Export..."));
        jmenu2.add(this.newMenuItem(LanguageEncoder.getText("Import..."), "Import..."));
        this.optionMenu.add(jmenu2);
        this.optionMenu.addSeparator();
        this.optionMenu.add(this.newMenuItem(LanguageEncoder.getText("Null Data Handler"), "Null Data Handler"));
        this.add(this.optionMenu);
    }

    private void addHelpMenu() {
        JMenu jmenu = new JMenu(LanguageEncoder.getText("Help"));
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("About..."), "About..."));
        jmenu.add(this.newMenuItem(LanguageEncoder.getText("Contents..."), "Contents..."));
        this.add(jmenu);
    }

    void setCopyCutEnabled(boolean flag) {
        this.copy.setEnabled(flag);
        this.cut.setEnabled(flag);
    }

    void setPasteEnabled(boolean flag) {
        this.paste.setEnabled(flag);
    }

    private void setColumnWrapEnabled(boolean flag) {
        this.columnWrap.setEnabled(flag);
    }

    private void setDualColorsEnabled(boolean flag) {
        this.dualColors.setEnabled(flag);
    }

    public void setUndoEnabled(boolean flag) {
        this.undo.setEnabled(flag);
    }

    public void setRedoEnabled(boolean flag) {
        this.redo.setEnabled(flag);
    }

    JMenuItem newMenuItem(String s, String s1, int i) {
        JMenuItem jmenuitem = new JMenuItem(s);
        if (IOUtil.isMac()) {
            jmenuitem.setAccelerator(KeyStroke.getKeyStroke(i, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        } else {
            int byte0 = 2;
            if (i == 127) {
                byte0 = 0;
            }
            jmenuitem.setAccelerator(KeyStroke.getKeyStroke(i, byte0));
        }
        jmenuitem.addActionListener(this);
        jmenuitem.setActionCommand(s1);
        return jmenuitem;
    }

    JMenuItem newMenuItem(String s, String s1) {
        JMenuItem jmenuitem = new JMenuItem(s);
        jmenuitem.addActionListener(this);
        jmenuitem.setActionCommand(s1);
        return jmenuitem;
    }

    private void addWordwrapMenu(JMenu menu) {
        this.wordWrap = new JCheckBoxMenuItem(LanguageEncoder.getText("Wordwrap"));
        this.wordWrap.setActionCommand("Wordwrap");
        this.refreshWordWrapItem();
        this.wordWrap.addItemListener(this);
        menu.add(this.wordWrap);
    }

    private void addResizeToFitContentMenu(JMenu menu) {
        this.resizeToFitContent = new JCheckBoxMenuItem(LanguageEncoder.getText("Resize To Fit Content"));
        this.resizeToFitContent.setActionCommand("Resize To Fit Content");
        this.refreshResizeToFitContentItem();
        this.resizeToFitContent.addItemListener(this);
        menu.add(this.resizeToFitContent);
    }

    private void refreshFormatMenu() {
        this.wordWrap.removeItemListener(this);
        this.resizeToFitContent.removeItemListener(this);
        this.refreshWordWrapItem();
        this.refreshResizeToFitContentItem();
        this.wordWrap.addItemListener(this);
        this.resizeToFitContent.addItemListener(this);
    }

    private void refreshWordWrapItem() {
        ReportElement selectedObject = this.reportMain.selectedObject;
        this.wordWrap.setSelected(this.isSelectedItemValidForWordWrap() && !selectedObject.isNoWrap());
    }

    private void refreshResizeToFitContentItem() {
        ReportElement selectedObject = this.reportMain.selectedObject;
        this.resizeToFitContent.setSelected(this.isSelectedItemValidForResizeToFitContent() && selectedObject.isResizeToFitContent());
    }

    private boolean isSelectedItemValidForWordWrap() {
        ReportElement selectedObject = this.reportMain.selectedObject;
        if (selectedObject == null) {
            return false;
        }
        return !(selectedObject instanceof ReportImage) && (selectedObject instanceof ReportCell || selectedObject instanceof SubReportObject || selectedObject instanceof ReportRTFObject || selectedObject instanceof ReportColumn) || this.reportMain.groupFormatFlag();
    }

    private boolean isSelectedItemValidForResizeToFitContent() {
        ReportElement selectedObject = this.reportMain.selectedObject;
        if (selectedObject == null) {
            return false;
        }
        return !(selectedObject instanceof ReportImage) && (selectedObject instanceof ReportCell || selectedObject instanceof ReportColumn) || this.reportMain.groupFormatFlag();
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        block228: {
            String s;
            block249: {
                block248: {
                    block247: {
                        block246: {
                            block245: {
                                block244: {
                                    block243: {
                                        block242: {
                                            block241: {
                                                block240: {
                                                    block239: {
                                                        block238: {
                                                            block237: {
                                                                block236: {
                                                                    block235: {
                                                                        block234: {
                                                                            block233: {
                                                                                block232: {
                                                                                    block231: {
                                                                                        block230: {
                                                                                            block229: {
                                                                                                block227: {
                                                                                                    if (!this.isReady) {
                                                                                                        return;
                                                                                                    }
                                                                                                    this.reportMain.createBackupReport();
                                                                                                    if (actionevent.getSource() instanceof JMenuItem) {
                                                                                                        if (this.insertSubReport != null && this.insertSubReport.isMenuComponent(((JMenuItem)actionevent.getSource()).getComponent())) {
                                                                                                            this.reportMain.menuBar.setUndoEnabled(false);
                                                                                                            if (((JMenuItem)actionevent.getSource()).getText().equals(LanguageEncoder.getText("New..."))) {
                                                                                                                this.reportMain.addSubReport();
                                                                                                            } else {
                                                                                                                this.reportMain.addSubReport(((JMenuItem)actionevent.getSource()).getText());
                                                                                                            }
                                                                                                            return;
                                                                                                        }
                                                                                                        if (this.removeSubReport != null && this.removeSubReport.isMenuComponent(((JMenuItem)actionevent.getSource()).getComponent())) {
                                                                                                            this.reportMain.removeSubReport(((JMenuItem)actionevent.getSource()).getText());
                                                                                                            this.removeSubReport.setEnabled(this.reportMain.subReports != null && this.reportMain.subReports.size() > 0);
                                                                                                            return;
                                                                                                        }
                                                                                                    }
                                                                                                    if ((s = actionevent.getActionCommand()).equals("Insert Table Of Contents")) {
                                                                                                        this.reportMain.addTableOfContents();
                                                                                                    } else if (s.equals("Exit")) {
                                                                                                        this.reportMain.exit();
                                                                                                    } else if (s.equals("New...")) {
                                                                                                        this.reportMain.newFile();
                                                                                                    } else if (s.equals("Open...")) {
                                                                                                        boolean flag = this.reportMain.openFile();
                                                                                                        if (!flag && this.reportMain.drillDownNavigationFrame != null) {
                                                                                                            this.reportMain.drillDownNavigationFrame.setVisible(false);
                                                                                                            this.reportMain.drillDownNavigationFrame.dispose();
                                                                                                        }
                                                                                                    } else if (s.equals("Close")) {
                                                                                                        this.reportMain.reportFileName = null;
                                                                                                        this.reportMain.setItemName(null);
                                                                                                        this.reportMain.closeReportCompletely();
                                                                                                    } else if (s.equals("Apply Template...")) {
                                                                                                        this.reportMain.applyTemplate();
                                                                                                    } else if (s.equals("Save")) {
                                                                                                        this.reportMain.setSaveWithNoData(false);
                                                                                                        this.reportMain.saveFromReportDesigner();
                                                                                                    } else if (s.equals("Save With No Data")) {
                                                                                                        this.reportMain.setSaveWithNoData(true);
                                                                                                        this.reportMain.saveFromReportDesigner();
                                                                                                        this.reportMain.setSaveWithNoData(false);
                                                                                                    } else if (s.equals("Save As...")) {
                                                                                                        this.reportMain.saveAs();
                                                                                                    } else if (s.equals("Generate DHTML")) {
                                                                                                        this.reportMain.export(4);
                                                                                                    } else if (s.equals("Generate PDF")) {
                                                                                                        this.reportMain.export(2);
                                                                                                    } else if (s.equals("Generate CSV")) {
                                                                                                        this.reportMain.export(3);
                                                                                                    } else if (s.equals("Generate EXCEL (XLS)")) {
                                                                                                        this.reportMain.export(9);
                                                                                                    } else if (s.equals("Generate EXCEL 2007 (XLSX)")) {
                                                                                                        this.reportMain.export(17);
                                                                                                    } else if (s.equals("Generate XML")) {
                                                                                                        this.reportMain.export(6);
                                                                                                    } else if (s.equals("Generate TXT")) {
                                                                                                        this.reportMain.export(5);
                                                                                                    } else if (s.equals("Generate Rich Text")) {
                                                                                                        this.reportMain.export(13);
                                                                                                    } else if (s.equals(GENERATE_PAK_FILE)) {
                                                                                                        this.reportMain.export(10);
                                                                                                    } else if (s.equals("HyperLink")) {
                                                                                                        this.reportMain.setEltWebLink();
                                                                                                    } else if (s.equals("Scripting")) {
                                                                                                        this.reportMain.setEltScript();
                                                                                                    } else if (s.equals("About...")) {
                                                                                                        this.reportMain.aboutReportDesigner();
                                                                                                    } else if (s.equals("Contents...")) {
                                                                                                        this.reportMain.showDocumentation();
                                                                                                    } else if (s.equals("Insert Label")) {
                                                                                                        this.reportMain.setInsertLabel(true);
                                                                                                    } else if (s.equals("Insert Formula")) {
                                                                                                        this.reportMain.setInsertFormula(true);
                                                                                                    } else if (s.equals("Insert Column Field")) {
                                                                                                        this.reportMain.setInsertColumnField();
                                                                                                    } else if (s.equals("Insert Database Field")) {
                                                                                                        this.reportMain.setInsertDatabaseField();
                                                                                                    } else if (s.equals("Insert Column Header")) {
                                                                                                        this.reportMain.setInsertColumnHeader();
                                                                                                    } else if (s.equals("Insert Parameter Value")) {
                                                                                                        this.reportMain.setInsertParameterValue();
                                                                                                    } else if (s.equals("Insert Chart")) {
                                                                                                        this.reportMain.setInsertChart(true);
                                                                                                    } else if (s.equals("Insert Image")) {
                                                                                                        this.reportMain.setInsertImage(true);
                                                                                                    } else if (s.equals("Insert Rich Text Field")) {
                                                                                                        this.reportMain.setInsertRichTextField(true);
                                                                                                    } else if (s.equals("Column Wrap")) {
                                                                                                        this.reportMain.setColumnWrapInfo();
                                                                                                    } else if (s.equals("Auto Fit Columns")) {
                                                                                                        this.reportMain.autoFitColumns();
                                                                                                    } else if (s.equals("Drill-Down Link")) {
                                                                                                        this.reportMain.setEltDrillDownLink();
                                                                                                    } else if (s.equals("Horizontal Line")) {
                                                                                                        this.reportMain.setInsertLine(true);
                                                                                                    } else if (s.equals("Vertical Line")) {
                                                                                                        this.reportMain.setInsertLine(true);
                                                                                                        this.reportMain.setVerticalLine(true);
                                                                                                    } else if (s.equals("Horizontal")) {
                                                                                                        this.reportMain.resetSelectedObject();
                                                                                                        this.reportMain.setInsertGuideLine(true);
                                                                                                    } else if (s.equals("Vertical")) {
                                                                                                        this.reportMain.resetSelectedObject();
                                                                                                        this.reportMain.setInsertGuideLine(true);
                                                                                                        this.reportMain.setVerticalGuideLine(true);
                                                                                                    } else if (s.equals("Insert Grid")) {
                                                                                                        this.reportMain.setInsertGrid(true);
                                                                                                    } else if (s.equals("Swap Columns")) {
                                                                                                        this.reportMain.swapReportCell();
                                                                                                    } else if (s.equals("Navigate")) {
                                                                                                        this.reportMain.showDrillDownNavigationFrame();
                                                                                                    } else if (s.equals("Print")) {
                                                                                                        this.reportMain.printReport();
                                                                                                    } else if (s.equals("Page Setup")) {
                                                                                                        this.reportMain.pageSetup();
                                                                                                    } else if (s.equals("HTML Page Title")) {
                                                                                                        this.reportMain.setHTMLPageTitle();
                                                                                                    } else if (s.equals("Report Background Color")) {
                                                                                                        this.reportMain.setReportBackgroundColor();
                                                                                                    } else if (s.equals("Report Background Image")) {
                                                                                                        this.reportMain.setReportBackgroundImage();
                                                                                                    } else if (s.equals("Font Mapping")) {
                                                                                                        this.reportMain.setFontMapping();
                                                                                                    } else if (s.equals("Viewer Font Setup")) {
                                                                                                        this.reportMain.setViewerFontProperty();
                                                                                                    } else if (s.equals("Export Style Sheet")) {
                                                                                                        this.reportMain.exportStyleSheet();
                                                                                                    } else if (s.equals("Snap To Grid")) {
                                                                                                        this.reportMain.setSnapToGrid();
                                                                                                    } else if (s.equals("Label")) {
                                                                                                        this.reportMain.setGlobalFormatLabel();
                                                                                                    } else if (s.equals("Chart")) {
                                                                                                        this.reportMain.setGlobalFormatChart();
                                                                                                    } else if (s.equals("Column")) {
                                                                                                        this.reportMain.setGlobalFormatColumn();
                                                                                                    } else if (s.equals("Formula")) {
                                                                                                        this.reportMain.setGlobalFormatFormula();
                                                                                                    } else if (s.equals("Image")) {
                                                                                                        this.reportMain.setGlobalFormatImage();
                                                                                                    } else if (s.equals("Grid")) {
                                                                                                        this.reportMain.setGlobalFormatGrid();
                                                                                                    } else if (s.equals("Line")) {
                                                                                                        this.reportMain.setGlobalFormatLine();
                                                                                                    } else if (s.equals("ColumnHeader")) {
                                                                                                        this.reportMain.setGlobalFormatColumnHeader();
                                                                                                    } else if (s.equals("Title")) {
                                                                                                        this.reportMain.setGlobalFormatTitle();
                                                                                                    } else if (s.equals("Null Data Handler")) {
                                                                                                        this.reportMain.setNullDataHandler();
                                                                                                    } else if (s.equals("Export...")) {
                                                                                                        this.reportMain.exportGlobalFormat();
                                                                                                    } else if (s.equals("Import...")) {
                                                                                                        this.reportMain.importGlobalFormat();
                                                                                                    } else if (s.equals("Shift")) {
                                                                                                        this.reportMain.isShiftSelected = this.shift.isSelected();
                                                                                                        this.reportMain.clearBackupReport();
                                                                                                    } else if (s.equals("Enable Toc")) {
                                                                                                        this.reportMain.report.setTocEnabled(this.enableToc.isSelected());
                                                                                                        this.reportMain.setEnableToc(this.enableToc.isSelected());
                                                                                                        this.reportMain.setModified();
                                                                                                        this.reportMain.clearBackupReport();
                                                                                                    } else if (s.equals("CellOutline")) {
                                                                                                        this.reportMain.report.showCellOutline = this.showCellOutline.isSelected();
                                                                                                        this.reportMain.clearBackupReport();
                                                                                                        this.reportMain.repaintPanel();
                                                                                                    } else if (s.equals("CrosstabElementMove")) {
                                                                                                        if (this.allowCrosstabElementMove.isSelected()) {
                                                                                                            this.reportMain.setAllowCrosstabElementMove(true);
                                                                                                        } else {
                                                                                                            this.reportMain.setAllowCrosstabElementMove(false);
                                                                                                        }
                                                                                                        this.reportMain.clearBackupReport();
                                                                                                        this.reportMain.repaintPanel();
                                                                                                    } else if (s.equals("FormulaName")) {
                                                                                                        this.reportMain.report.showFormulaNameSelected = this.formulaName.isSelected();
                                                                                                        this.reportMain.clearBackupReport();
                                                                                                        this.reportMain.repaintPanel();
                                                                                                    } else if (s.equals("Group Set Width")) {
                                                                                                        this.reportMain.groupSetWidth();
                                                                                                    } else if (s.equals("Undo")) {
                                                                                                        this.reportMain.do_undo();
                                                                                                    } else if (s.equals("Redo")) {
                                                                                                        this.reportMain.do_redo();
                                                                                                    } else if (s.equals("Edit")) {
                                                                                                        this.reportMain.setEltText();
                                                                                                    } else if (s.equals("Copy")) {
                                                                                                        this.reportMain.designPanel.rulerPanel.copyToClipBoard();
                                                                                                    } else if (s.equals("Cut")) {
                                                                                                        this.reportMain.designPanel.rulerPanel.cutToClipBoard();
                                                                                                    } else if (s.equals("Paste")) {
                                                                                                        this.reportMain.setIsPasteOp(true);
                                                                                                    } else if (s.equals("Data Format")) {
                                                                                                        this.reportMain.setEltFormat();
                                                                                                    } else if (s.equals("Chart Export Format")) {
                                                                                                        this.reportMain.setEltImageOptions();
                                                                                                    } else if (s.equals("Edit Attributes")) {
                                                                                                        this.reportMain.editEltAttributes();
                                                                                                    } else if (s.equals("Delete")) {
                                                                                                        this.reportMain.deleteElt();
                                                                                                    } else if (s.equals("Font Style And Size")) {
                                                                                                        this.reportMain.setEltFont();
                                                                                                    } else if (s.equals("Background Color")) {
                                                                                                        this.reportMain.setEltBackgroundColor();
                                                                                                    } else if (s.equals("Line Color & Thickness")) {
                                                                                                        this.reportMain.setEltLineThickness();
                                                                                                    }
                                                                                                    if (s.equals("Border")) {
                                                                                                        this.reportMain.setEltBorder();
                                                                                                    } else if (s.equals("Dual Colors")) {
                                                                                                        this.reportMain.setEltDualColors();
                                                                                                    } else if (s.equals("Z-index")) {
                                                                                                        this.reportMain.setEltZIndex();
                                                                                                    } else if (s.equals("Rotation")) {
                                                                                                        this.reportMain.setEltRotation();
                                                                                                    } else if (s.equals("Bounds")) {
                                                                                                        this.reportMain.setEltBounds();
                                                                                                    } else if (s.equals("Left")) {
                                                                                                        this.reportMain.setEltAlign((short)1);
                                                                                                    } else if (s.equals("Center")) {
                                                                                                        this.reportMain.setEltAlign((short)0);
                                                                                                    } else if (s.equals("Right")) {
                                                                                                        this.reportMain.setEltAlign((short)2);
                                                                                                    } else if (s.equals("Top")) {
                                                                                                        this.reportMain.setEltVAlign((short)1);
                                                                                                    } else if (s.equals("Middle")) {
                                                                                                        this.reportMain.setEltVAlign((short)0);
                                                                                                    } else if (s.equals("Bottom")) {
                                                                                                        this.reportMain.setEltVAlign((short)2);
                                                                                                    } else if (s.equals("Invisible")) {
                                                                                                        this.reportMain.setEltVisible(false);
                                                                                                    } else if (s.equals("Design")) {
                                                                                                        this.reportMain.selectDesignPanel();
                                                                                                    } else if (s.equals("Preview")) {
                                                                                                        this.reportMain.selectPreviewPanel();
                                                                                                    } else if (s.equals("First Page")) {
                                                                                                        this.reportMain.previewPanel.goToFirstPage();
                                                                                                    } else if (s.equals("Previous Page")) {
                                                                                                        this.reportMain.previewPanel.goToPreviousPage();
                                                                                                    } else if (s.equals("Next Page")) {
                                                                                                        this.reportMain.previewPanel.goToNextPage();
                                                                                                    } else if (s.equals("Last Page")) {
                                                                                                        this.reportMain.previewPanel.goToLastPage();
                                                                                                    } else if (s.equals("Sort by ... ")) {
                                                                                                        new SortByDialog(this.reportMain).setVisible(true);
                                                                                                    } else if (s.equals("Launch PageViewer")) {
                                                                                                        this.reportMain.launchPageViewer();
                                                                                                    } else if (s.equals("Go To Page...")) {
                                                                                                        this.reportMain.previewPanel.goTo();
                                                                                                    } else if (s.equals("Refresh")) {
                                                                                                        this.reportMain.do_Refresh();
                                                                                                    } else if (s.equals("Change data mapping")) {
                                                                                                        this.reportMain.redoDataMapping();
                                                                                                    } else if (s.equals("Change data source")) {
                                                                                                        this.reportMain.updateDataSource();
                                                                                                    }
                                                                                                    if (!s.equals("Modify Database")) break block227;
                                                                                                    this.reportMain.updateDatabase();
                                                                                                    break block228;
                                                                                                }
                                                                                                if (!s.equals("Modify query")) break block229;
                                                                                                this.reportMain.updateQuery();
                                                                                                break block228;
                                                                                            }
                                                                                            if (!s.equals("View table")) break block230;
                                                                                            this.reportMain.do_ViewRecord();
                                                                                            break block228;
                                                                                        }
                                                                                        if (!s.equals("View Column Mapping")) break block231;
                                                                                        this.reportMain.do_ColInfoRecord();
                                                                                        break block228;
                                                                                    }
                                                                                    if (!s.equals("View Data Source Info")) break block232;
                                                                                    this.reportMain.do_ViewDataSourceInfo();
                                                                                    break block228;
                                                                                }
                                                                                if (!s.equals("Sub-Report Parameter Sharing")) break block233;
                                                                                this.reportMain.setSubReportParameterSharing();
                                                                                break block228;
                                                                            }
                                                                            if (!s.equals("Sub-Report Parameter Mapping...")) break block234;
                                                                            this.reportMain.setSubReportParameters();
                                                                            break block228;
                                                                        }
                                                                        if (!s.equals("Chart Parameter Mapping...")) break block235;
                                                                        this.reportMain.setChartParametersMapping();
                                                                        break block228;
                                                                    }
                                                                    if (!s.equals("Select Multiple Drill-Down Values...")) break block236;
                                                                    try {
                                                                        this.reportMain.previewPanel.viewer.getReportCanvas().setDrillDownParameterValues();
                                                                    }
                                                                    catch (Exception ex) {
                                                                        LOGGER.log(Level.FINE, "Failed to set multiple drill-downs values", ex);
                                                                        new JMessageDialog((Frame)this.reportMain, "Multiple drill-down value", ex.getMessage());
                                                                    }
                                                                    break block228;
                                                                }
                                                                if (!s.equals("Security")) break block237;
                                                                this.reportMain.setEltSecurity();
                                                                break block228;
                                                            }
                                                            if (!s.equals("Cell Properties")) break block238;
                                                            this.reportMain.getEltProperties();
                                                            break block228;
                                                        }
                                                        if (!s.equals("Set Preview Data Options")) break block239;
                                                        this.reportMain.setPreviewDataOptions();
                                                        break block228;
                                                    }
                                                    if (!s.equals("Set Preview Security Level")) break block240;
                                                    this.reportMain.setPreviewSecurityLevel();
                                                    break block228;
                                                }
                                                if (!s.equals("Secured Query Parameters")) break block241;
                                                this.reportMain.setSecuredQueryParameters();
                                                break block228;
                                            }
                                            if (!s.equals("Preview Parameter Prompt")) break block242;
                                            this.reportMain.report.isPrevParamPrompt = this.prevParamPrompt.isSelected();
                                            this.reportMain.setModified(true);
                                            break block228;
                                        }
                                        if (!s.equals("Report Explorer")) break block243;
                                        this.reportMain.setExplorerVisible(this.explorerItem.isSelected());
                                        break block228;
                                    }
                                    if (!s.equals("Date")) break block244;
                                    this.reportMain.menuBar.setUndoEnabled(false);
                                    this.reportMain.setInsertFormula(true, "todaysDate", "getCurrentDate()", 91);
                                    break block228;
                                }
                                if (!s.equals("Date & Time")) break block245;
                                this.reportMain.menuBar.setUndoEnabled(false);
                                this.reportMain.setInsertFormula(true, "todaysDateTime", "getCurrentDateTime()", 93);
                                break block228;
                            }
                            if (!s.equals("Time")) break block246;
                            this.reportMain.menuBar.setUndoEnabled(false);
                            this.reportMain.setInsertFormula(true, "todaysTime", "getCurrentTime()", 92);
                            break block228;
                        }
                        if (!s.equals("Page Number")) break block247;
                        this.reportMain.menuBar.setUndoEnabled(false);
                        this.reportMain.setInsertFormula(true, "pageNumber", "\"Page \"+getPage()", 12);
                        break block228;
                    }
                    if (!s.equals("Page Number Of Total Pages")) break block248;
                    this.reportMain.menuBar.setUndoEnabled(false);
                    this.reportMain.setInsertFormula(true, "pageNumberOfTotalPages", "\"Page \"+getPage()+ \" of \"+getTotalPages()", 12);
                    break block228;
                }
                if (!s.endsWith(" Column")) break block249;
                if (this.reportMain.isDesignMode) {
                    if (this.reportMain.groupFormatFlag()) {
                        this.reportMain.deselectGroupOption();
                    }
                    for (int i = 0; i < this.columnList.size(); ++i) {
                        ReportColumn reportcolumn = (ReportColumn)this.columnList.elementAt(i);
                        if (!s.equals(reportcolumn.getText() + " Column")) continue;
                        reportcolumn.setVisible(true);
                        int colInfoIndex = this.reportMain.report.getColInfoIndex(reportcolumn);
                        this.reportMain.report.colInfo[colInfoIndex].setVisible(true);
                        double reportMinWidth = this.reportMain.report.getMinWidth();
                        if (reportMinWidth > (double)RulerPanel.MAX_XWIDTH) {
                            this.reportMain.setUpdateReport();
                            this.reportMain.updatePanel();
                        }
                        this.reportMain.setModified();
                        this.reportMain.repaintTablePanel();
                        return;
                    }
                } else {
                    Report report = this.reportMain.previewPanel.viewer.getReportCanvas().getReport();
                    ReportTable table = report.getReportTables().elementAt(0);
                    for (int i = 0; i < table.getColumnCount(); ++i) {
                        ReportColumn reportcolumn = table.getColumn(i);
                        if (!s.equals(reportcolumn.getText() + " Column") && !s.equals(report.colInfo[i].getName() + " Column")) continue;
                        table.createIndexArray(i, this.isAsc, report, 0);
                        this.reportMain.previewPanel.viewer.getReportCanvas().setRepaint(report);
                        return;
                    }
                }
                break block228;
            }
            if (!s.endsWith(" Section")) break block228;
            if (this.reportMain.groupFormatFlag()) {
                this.reportMain.deselectGroupOption();
            }
            for (int j = 0; j < this.columnList.size(); ++j) {
                ReportElementPanel reportelementpanel = (ReportElementPanel)this.columnList.elementAt(j);
                if (!s.equals(reportelementpanel.getElementName() + " Section") && !s.equals(reportelementpanel.getElementName())) continue;
                reportelementpanel.setElementVisible(true);
                this.reportMain.setModified();
                this.reportMain.designPanel.rulerPanel.yRuler.updateYRuler();
                this.reportMain.updatePanel();
                return;
            }
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuevent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuevent) {
    }

    @Override
    public void menuSelected(MenuEvent menuevent) {
        if (!this.isReady || this.reportMain.report == null) {
            return;
        }
        if (menuevent.getSource() == this.formatMenu) {
            this.refreshFormatMenu();
        } else if (menuevent.getSource() == this.visibleColumnMenu) {
            this.isReady = false;
            this.visibleColumnMenu.removeAll();
            Vector<ReportTable> vector = this.reportMain.report.getReportTables();
            this.columnList = new Vector();
            for (int k = 0; k < vector.size(); ++k) {
                ReportTable reporttable = vector.elementAt(k);
                for (int i1 = 0; i1 < reporttable.getColumnCount(); ++i1) {
                    if (reporttable.getColumn(i1).isVisible()) continue;
                    this.columnList.addElement(reporttable.getColumn(i1));
                    this.visibleColumnMenu.add(this.newMenuItem(reporttable.getColumn(i1).getText() + " " + LanguageEncoder.getText("Column"), reporttable.getColumn(i1).getText() + " Column"));
                }
            }
            this.isReady = true;
        } else if (menuevent.getSource() == this.visibleSectionMenu) {
            this.isReady = false;
            this.visibleSectionMenu.removeAll();
            Vector<JPanel> vector1 = this.reportMain.designPanel.rulerPanel.panelList;
            if (vector1 == null || vector1.size() <= 0) {
                return;
            }
            this.columnList = new Vector();
            for (int l = 0; l < vector1.size(); ++l) {
                ReportElementPanel reportelementpanel;
                if (!(vector1.elementAt(l) instanceof ReportElementPanel) || (reportelementpanel = (ReportElementPanel)vector1.elementAt(l)).isElementVisible()) continue;
                this.columnList.addElement(reportelementpanel);
                this.visibleSectionMenu.add(this.newMenuItem(reportelementpanel.getElementName() + LanguageEncoder.getText("Section"), reportelementpanel.getElementName() + " Section"));
            }
            ReportElementPanel reportelementpanel1 = this.reportMain.designPanel.rulerPanel.getMasterSectionPanel();
            if (reportelementpanel1 != null && !reportelementpanel1.isElementVisible()) {
                this.columnList.addElement(reportelementpanel1);
                this.visibleSectionMenu.add(this.newMenuItem(reportelementpanel1.getElementName(), reportelementpanel1.getElementName()));
            }
            this.isReady = true;
        } else if (menuevent.getSource() == this.insertSubReport) {
            this.isReady = false;
            this.insertSubReport.removeAll();
            this.insertSubReport.add(this.newMenuItem(LanguageEncoder.getText("New..."), "New..."));
            if (this.reportMain.subReports != null && this.reportMain.subReports.size() > 0) {
                this.insertSubReport.addSeparator();
                for (int i = 0; i < this.reportMain.subReports.size(); ++i) {
                    try {
                        this.insertSubReport.add(this.newMenuItem(this.reportMain.reportDesignerPane.getTitleAt(i + 1), this.reportMain.reportDesignerPane.getTitleAt(i + 1)));
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.FINEST, "Failed to insert sub-report menu items", exception);
                    }
                }
            }
            this.isReady = true;
        } else if (menuevent.getSource() == this.removeSubReport) {
            this.isReady = false;
            this.removeSubReport.removeAll();
            if (this.reportMain.subReports != null && this.reportMain.subReports.size() > 0) {
                for (int j = 0; j < this.reportMain.subReports.size(); ++j) {
                    try {
                        this.removeSubReport.add(this.newMenuItem(this.reportMain.reportDesignerPane.getTitleAt(j + 1), this.reportMain.reportDesignerPane.getTitleAt(j + 1)));
                        continue;
                    }
                    catch (Exception exception1) {
                        LOGGER.log(Level.FINEST, "Failed to remove sub-report menu items", exception1);
                    }
                }
            }
            this.isReady = true;
        } else if (menuevent.getSource() == this.sortMenu || menuevent.getSource() == this.sortMenu2) {
            this.isReady = false;
            JMenu menu = (JMenu)menuevent.getSource();
            if (menu == this.sortMenu) {
                this.isAsc = true;
            }
            if (menu == this.sortMenu2) {
                this.isAsc = false;
            }
            menu.removeAll();
            this.columnList = new Vector();
            Report report = this.reportMain.previewPanel.viewer.getReportCanvas().getReport();
            Vector<ReportTable> vector = report.getReportTables();
            if (report.getReportType() != 2) {
                for (int k = 0; k < vector.size(); ++k) {
                    ReportTable reporttable = vector.elementAt(k);
                    for (int i1 = 0; i1 < reporttable.getColumnCount(); ++i1) {
                        if (!reporttable.getColumn(i1).isVisible() && (report.getReportType() != 3 || !report.colInfo[i1].isMaster())) continue;
                        ReportTable tbl = reporttable;
                        while (tbl instanceof ReportTreeTable) {
                            tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(0);
                        }
                        if (tbl.getColumn(i1).getData(0) instanceof ReportImage || tbl.getColumn(i1).getData(0) instanceof ReportDocument) continue;
                        this.columnList.addElement(reporttable.getColumn(i1));
                        menu.add(this.newMenuItem(reporttable.getColumn(i1).getText() + " " + LanguageEncoder.getText("Column"), reporttable.getColumn(i1).getText() + " Column"));
                    }
                }
            } else {
                ColInfo[] colInfo;
                for (ColInfo element : colInfo = report.colInfo) {
                    if (!element.isVisible() || !element.isRowBreak()) continue;
                    menu.add(this.newMenuItem(element.getName() + " " + LanguageEncoder.getText("Column"), element.getName() + " Column"));
                }
            }
            this.isReady = true;
        }
    }

    public void setDefaultOptions() {
        if (this.formulaName != null) {
            this.formulaName.setSelected(false);
        }
        if (this.shift != null) {
            this.shift.setSelected(this.reportMain.isShiftSelected);
        }
        if (this.enableToc != null) {
            this.enableToc.setSelected(true);
        }
    }

    void updateRecentFiles(String[] files) {
        int origTotalItems;
        int n = origTotalItems = ServerMessage.getApplet() == null ? 11 : 10;
        if (files == null || files.length == 0) {
            return;
        }
        while (this.fileMenu.getItemCount() > origTotalItems) {
            this.fileMenu.remove(origTotalItems - 1);
        }
        for (int i = files.length - 1; i >= 0; --i) {
            if (files[i] == null || files[i].equals("null") || files[i].equals(SaveReport.VERSIONNAME)) continue;
            JMenuItem jmenuitem = new JMenuItem(files[i]);
            jmenuitem.addActionListener(this.recentFileOpener);
            this.fileMenu.insert(jmenuitem, origTotalItems - 1);
        }
        if (this.fileMenu.getItemCount() > origTotalItems) {
            this.fileMenu.insertSeparator(this.fileMenu.getItemCount() - 1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JMenuItem target = (JMenuItem)e.getSource();
        String cmd = target.getActionCommand();
        boolean isGroup = this.reportMain.groupFormatFlag();
        if (cmd.equals("Wordwrap")) {
            if (!this.isSelectedItemValidForWordWrap()) {
                new JMessageDialog((Dialog)new JDialog(), LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a text object first!"));
                return;
            }
            if (isGroup) {
                this.reportMain.designPanel.rulerPanel.groupWordwrap(this.wordWrap.isSelected());
            } else {
                this.reportMain.selectedObject.setNoWrap(!this.wordWrap.isSelected());
            }
            this.reportMain.setModified();
        } else if (cmd.equals("Resize To Fit Content")) {
            if (!this.isSelectedItemValidForResizeToFitContent()) {
                new JMessageDialog((Dialog)new JDialog(), LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a text object first!"));
                return;
            }
            if (isGroup) {
                this.reportMain.designPanel.rulerPanel.groupResizeToFitContent(this.resizeToFitContent.isSelected());
            } else {
                this.reportMain.selectedObject.setResizeToFitContent(this.resizeToFitContent.isSelected());
            }
            this.reportMain.setModified();
        }
    }

    class RecentFileOpener
    implements ActionListener {
        RecentFileOpener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            if (!(actionevent.getSource() instanceof JMenuItem)) {
                return;
            }
            JMenuItem item = (JMenuItem)actionevent.getSource();
            String currentFile = ReportMenuBar.this.reportMain.getReportFile();
            if (currentFile != null && currentFile.equals(item.getText())) {
                return;
            }
            if (ReportMenuBar.this.reportMain.tryClose(null)) {
                ReportMenuBar.this.reportMain.reset_displayOptions();
                ReportMenuBar.this.reportMain.getSubFilesTable().setFileInMemEnabled(item.getText().toLowerCase().endsWith(".pak"));
                ReportMenuBar.this.reportMain.setReportOpenedInPakFormat(item.getText().toLowerCase().endsWith(".pak"));
                ReportMenuBar.this.reportMain.loadFile(null, item.getText(), null);
            }
        }
    }
}

