/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle1;
import quadbase.reportdesigner.designer.ReportStyle2;
import quadbase.reportdesigner.designer.ReportStyle3;
import quadbase.reportdesigner.designer.ReportStyle4;
import quadbase.reportdesigner.designer.ReportStyle5;
import quadbase.reportdesigner.report.GlobalFormat;
import quadbase.reportdesigner.report.ImportFontMapping;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;

public class ReportStyle {
    private static final Logger LOGGER = Logger.getLogger(ReportStyle.class.getName());
    public static final double DEFAULT_CELL_HEIGHT = 0.3;
    public static final double THIN_CELL_HEIGHT = 0.2;
    public static final int REPORT_STYLE_1 = 1;
    public static final int REPORT_STYLE_2 = 2;
    public static final int REPORT_STYLE_3 = 3;
    public static final int REPORT_STYLE_4 = 4;
    public static final int REPORT_STYLE_5 = 5;
    String xmlDir = "Templates/GlobalFormat/";
    ReportMain reportmain;
    Report report;
    double reportHeaderHeight = 0.5;
    double cellWidth;
    double cellHeight;
    double titleWidth;
    double titleHeight;
    double lineHeight;
    Font titleFont;
    Font plainFont;
    Font highlightedFont;
    Color fontColor;
    Color bgColor;

    public static void removeStyle(int style, Report report) {
        switch (style) {
            case 0: {
                ReportStyle1.removeStyle(report);
                break;
            }
            case 1: {
                ReportStyle2.removeStyle(report);
                break;
            }
            case 2: {
                ReportStyle3.removeStyle(report);
                break;
            }
            case 3: {
                ReportStyle4.removeStyle(report);
                break;
            }
            case 4: {
                ReportStyle5.removeStyle(report);
            }
        }
    }

    public void applyFormat(ReportMain reportmain, boolean changingStyle) {
        this.reportmain = reportmain;
        this.report = reportmain.report;
        try {
            this.importGlobalFormat(reportmain);
            this.adjustXPosition(changingStyle);
            this.styleSpecificFormat(changingStyle);
            this.applyFontMapping(this.report);
            reportmain.autoFitColumns();
            reportmain.updateDesignPanelUI();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to apply format", e);
            new JMessageDialog((Frame)reportmain, LanguageEncoder.getText("Error"), e.getMessage());
        }
    }

    public void importGlobalFormat(ReportMain reportmain) throws Exception {
    }

    public void importGlobalFormat(Report report) throws Exception {
    }

    public void styleSpecificFormat(boolean changingStyle) {
    }

    private Vector reorderPanels(Vector panelList) {
        int i;
        Vector newList = new Vector();
        for (i = 0; i < panelList.size(); ++i) {
            if (!(panelList.elementAt(i) instanceof ReportTable)) continue;
            newList.add(panelList.elementAt(i));
            panelList.remove(i);
            --i;
        }
        for (i = 0; i < panelList.size(); ++i) {
            newList.add(panelList.elementAt(i));
        }
        return newList;
    }

    /*
     * Could not resolve type clashes
     */
    private void adjustXPosition(boolean changingStyle) {
        ReportCell[] cell;
        if (this.report.reportType == 4) {
            return;
        }
        GlobalFormat globalFormat = new GlobalFormat(this.report);
        Vector panelList = globalFormat.getSections();
        panelList = this.reorderPanels(panelList);
        for (int i = 0; i < panelList.size(); ++i) {
            int j;
            ReportElement panel = (ReportElement)panelList.elementAt(i);
            if (panel.getID().equals("RPT_HDR")) continue;
            if (panel.getID().startsWith("TBL0_F_SEC") || panel.getID().equals("TBL0_FTR")) {
                ReportCell[] rc = ((ReportSection)panel).getData();
                ReportTable maintbl = this.report.getReportTables().elementAt(0);
                for (ReportCell element : rc) {
                    int colIndex = element.getColIndex(maintbl);
                    if (colIndex < 0) continue;
                    element.setX(maintbl.getColumn(colIndex).getX());
                    element.setFont(FontTable.newFont("Dialog", 1, QbUtil.getAdjustedFont(12, this.report.isAdjustFont())));
                }
            }
            if (this.report.reportType == 3 && !this.report.isSideBySideLayout() && panel.getID().startsWith("TBL0_H_SEC") && !changingStyle) continue;
            if (!panel.getID().equals("TBL0")) {
                ReportElement[] rc1 = ((ReportSection)panel).getData();
                Vector<ReportElement[]> vec = ReportElement.sortElementHorizontally(rc1);
                int colHeaderRowCt = vec.size();
                if (this.report.isColumnAggregationInHeader()) {
                    --colHeaderRowCt;
                }
                for (int kk = 0; kk < colHeaderRowCt; ++kk) {
                    int j2;
                    ReportElement[] rc = vec.elementAt(kk);
                    Object[] shift = new double[rc.length];
                    for (j2 = 1; j2 < rc.length; ++j2) {
                        if (changingStyle && rc[j2] instanceof ReportImage) continue;
                        if (rc[j2].getX() < rc[j2 - 1].getX() + rc[j2 - 1].getWidth() && rc[j2].getX() >= rc[j2 - 1].getX()) {
                            shift[j2] = rc[j2 - 1].getX() + rc[j2 - 1].getWidth() - rc[j2].getX();
                            continue;
                        }
                        if (!changingStyle || !(rc[j2].getX() > rc[j2 - 1].getX() + rc[j2 - 1].getWidth()) || !(rc[j2].getX() >= rc[j2 - 1].getX())) continue;
                        shift[j2] = rc[j2 - 1].getX() + rc[j2 - 1].getWidth() - rc[j2].getX();
                    }
                    for (j2 = 1; j2 < rc.length; ++j2) {
                        if (changingStyle && rc[j2] instanceof ReportImage) continue;
                        double sum = 0.0;
                        for (int k = 1; k <= j2; ++k) {
                            sum += shift[k];
                        }
                        rc[j2].setX(rc[j2].getX() + sum);
                    }
                }
                if (this.report.isColumnAggregationInHeader()) {
                    ReportElement[] rc = vec.elementAt(colHeaderRowCt);
                    ReportTable maintbl = this.report.getReportTables().elementAt(0);
                    for (double element : (Object[])rc) {
                        int colIndex = ((ReportCell)element).getColIndex(maintbl);
                        if (colIndex < 0) continue;
                        element.setX(maintbl.getColumn(colIndex).getX());
                        element.setFont(FontTable.newFont("Dialog", 1, QbUtil.getAdjustedFont(12, this.report.isAdjustFont())));
                    }
                }
                double curPt = 0.0;
                for (int jj = 1; jj < vec.size(); ++jj) {
                    ReportElement[] rc;
                    ReportElement[] prc = vec.elementAt(jj - 1);
                    curPt = this.findMaxY(prc);
                    for (ReportElement element : rc = vec.elementAt(jj)) {
                        element.setY(curPt);
                    }
                }
                if (vec.size() <= 1) continue;
                panel.setHeight(this.findMaxY(vec.lastElement()));
                continue;
            }
            ReportTable table = (ReportTable)panel;
            boolean applyToVisibleColOnly = false;
            if (this.report.isSideBySideLayout()) {
                applyToVisibleColOnly = true;
            }
            ReportElement[] rc = table.getTableElements(applyToVisibleColOnly, true);
            double[] shift = new double[rc.length];
            for (j = 1; j < rc.length; ++j) {
                if (rc[j] == table.getMasterSection() || changingStyle && rc[j] instanceof ReportImage || this.report.reportType == 2 && rc[j].getY() != rc[j - 1].getY()) continue;
                if (rc[j].getX() < rc[j - 1].getX() + rc[j - 1].getWidth() && rc[j].getX() >= rc[j - 1].getX()) {
                    shift[j] = rc[j - 1].getX() + rc[j - 1].getWidth() - rc[j].getX();
                    continue;
                }
                if (!changingStyle || !(rc[j].getX() > rc[j - 1].getX() + rc[j - 1].getWidth()) || !(rc[j].getX() >= rc[j - 1].getX())) continue;
                shift[j] = rc[j - 1].getX() + rc[j - 1].getWidth() - rc[j].getX();
            }
            for (j = 1; j < rc.length; ++j) {
                if (rc[j] == table.getMasterSection() || changingStyle && rc[j] instanceof ReportImage) continue;
                double sum = 0.0;
                for (int k = 1; k <= j; ++k) {
                    sum += shift[k];
                }
                rc[j].setX(rc[j].getX() + sum);
            }
            this.fixCrosstabElementsWithNonZeroY(rc);
        }
        for (ReportCell element : cell = this.report.getPageHeader().getData()) {
            if (!(element.getX() + element.getWidth() > this.report.getActualPageWidth())) continue;
            element.setX(this.report.getActualPageWidth() - element.getWidth());
        }
        for (ReportCell element : cell = this.report.getPageFooter().getData()) {
            if (!(element.getX() + element.getWidth() > this.report.getActualPageWidth())) continue;
            element.setX(this.report.getActualPageWidth() - element.getWidth());
        }
    }

    private void fixCrosstabElementsWithNonZeroY(ReportElement[] rc) {
        if (this.report.isCrossTab()) {
            for (int k = 1; k < rc.length; ++k) {
                if (rc[k] instanceof ReportLine || !(rc[k].getY() > 0.0) || rc[k].getY() % 0.3 != 0.0) continue;
                rc[k].setY(this.cellHeight * rc[k].getY() / 0.3);
            }
        }
    }

    private double findMaxY(ReportElement[] elt) {
        double max = 0.0;
        for (int i = 0; i < elt.length; ++i) {
            double val;
            if (!elt[i].isVisible() || !(max < (val = elt[i].getY() + elt[i].getHeight()))) continue;
            max = val;
        }
        return max;
    }

    public void moveMasterFieldsIn2Columns(ReportCell[] cell) {
        this.moveMasterFieldsIn2Columns(cell, 0.0);
    }

    public void moveMasterFieldsIn2Columns(ReportCell[] cell, double y_offset) {
        int i;
        if (this.report.reportType == 3 && this.report.isSideBySideLayout()) {
            return;
        }
        double width = cell[0].getWidth();
        int masterNum = 0;
        for (ColInfo element : this.report.colInfo) {
            if (!element.isMaster()) continue;
            ++masterNum;
        }
        this.reOrderMasterDetailHeaders(cell);
        int first = (int)Math.ceil((double)masterNum / 2.0);
        for (i = 0; i < first * 2; ++i) {
            if (i % 2 == 1) {
                cell[i].setX(width);
            }
            if (i > 1) {
                cell[i].setY(cell[i - 2].getY() + cell[i - 2].getHeight());
            }
            if (cell[i].getY() != 0.0) continue;
            cell[i].setY(y_offset);
        }
        for (i = first * 2; i < masterNum * 2; ++i) {
            if (i % 2 == 0) {
                cell[i].setX(width * 2.0);
                cell[i].setY(cell[i - first * 2].getY());
            } else {
                cell[i].setX(width * 3.0);
                cell[i].setY(cell[i - first * 2].getY());
            }
            if (cell[i].getY() != 0.0) continue;
            cell[i].setY(y_offset);
        }
        for (i = masterNum * 2; i < cell.length; ++i) {
            cell[i].setY(cell[first * 2 - 1].getY() + cell[first * 2 - 1].getHeight());
            cell[i].setX(cell[i].getX() * cell[i].getWidth());
        }
        ReportTable table = this.report.getReportTables().elementAt(0);
        ReportSection section = ((ReportMultiSectionTable)table).getRowBreakHeader(0);
        double maxHeight = cell[first * 2 - 1].getY() + cell[first * 2 - 1].getHeight() > cell[cell.length - 1].getY() + cell[cell.length - 1].getY() ? cell[first * 2 - 1].getY() + cell[first * 2 - 1].getHeight() : cell[cell.length - 1].getY() + cell[cell.length - 1].getHeight();
        section.setHeight(maxHeight);
    }

    private void reOrderMasterDetailHeaders(ReportCell[] cell) {
        int ct = 0;
        int pos = 0;
        for (ColInfo element : this.report.colInfo) {
            if (element.isMaster()) {
                this.swap(cell, ct, pos);
                this.swap(cell, ct + 1, pos + 1);
                pos += 2;
                ct += 2;
                continue;
            }
            if (!element.isVisible()) continue;
            ++ct;
        }
    }

    private void swap(ReportCell[] cell, int c1, int c2) {
        if (c1 == c2) {
            return;
        }
        ReportCell temp = cell[c1];
        cell[c1] = cell[c2];
        cell[c2] = temp;
    }

    private void applyFontMapping(Report report) throws IOException {
        String fontXml = ServerMessage.getDefaultFontMapping();
        if (fontXml == null) {
            return;
        }
        if (report.getFontMapping() != null && report.getFontMapping().size() > 0) {
            return;
        }
        ImportFontMapping importFontMapping = new ImportFontMapping();
        Hashtable fontMapping = importFontMapping.importXML(fontXml);
        report.setFontMapping(fontMapping);
    }

    public void reApplyStyle(ReportTable table, int reportStyle) {
    }

    void setStyleID(ReportElement styleElt) {
        styleElt.setCustomID("ST_" + styleElt.getID() + "_CUST");
    }

    static boolean isStyleElement(ReportElement styleElt) {
        return styleElt.getCustomID().startsWith("ST_") && styleElt.getCustomID().endsWith("_CUST");
    }

    public static double getDefaultCellHeight(int reportStyle) {
        switch (reportStyle) {
            case 2: 
            case 3: 
            case 5: {
                return 0.2;
            }
        }
        return 0.3;
    }
}

