/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;

public class ReportStyle1
extends ReportStyle {
    Report report;
    Graphics g;
    ImportGlobalFormat import_xml;

    public ReportStyle1() {
        this.cellHeight = ReportStyle1.getDefaultCellHeight(1);
    }

    @Override
    public void importGlobalFormat(ReportMain reportmain) throws Exception {
        this.g = reportmain.getGraphics();
        this.importGlobalFormat(reportmain.report);
        this.import_xml = new ImportGlobalFormat(reportmain);
        this.import_xml.importXML(this.xmlDir + "Style1.xml");
    }

    @Override
    public void importGlobalFormat(Report report) throws Exception {
        this.report = report;
    }

    @Override
    public void styleSpecificFormat(boolean changingStyle) {
        int i;
        ReportCell[] cell;
        this.plainFont = FontTable.newFont("Dialog", 0, 9);
        this.highlightedFont = FontTable.newFont("Dialog", 1, 9);
        this.fontColor = new Color(0, 50, 100);
        this.bgColor = new Color(206, 204, 202);
        this.report.getReportHeader().setHeight(this.reportHeaderHeight);
        ReportTable table = this.report.getReportTables().elementAt(0);
        if (this.report.reportType == 2) {
            int ct = 0;
            for (ColInfo element : this.report.colInfo) {
                if (!element.isColumnBreak()) continue;
                ++ct;
            }
            int countColBreakVal = 0;
            ColInfo[] colInfoArray = this.report.colInfo;
            int n = colInfoArray.length;
            for (int element = 0; element < n; ++element) {
                ColInfo element2 = colInfoArray[element];
                if (element2.isColumnBreakValue()) {
                    ++countColBreakVal;
                }
                if (countColBreakVal <= 1 || !this.report.isShowColumnAggregation()) continue;
                ++ct;
                break;
            }
            if (this.report.isShowColumnAggregation() && this.report.isColumnAggregationInHeader()) {
                ++ct;
            }
            table.getHeader().setHeight(this.cellHeight * (double)ct);
            if (this.report.isAlignCrossTabColBkValHori()) {
                table.setHeight(this.cellHeight);
            } else {
                table.setHeight(this.cellHeight * (double)ct);
            }
        } else {
            table.setHeight(this.cellHeight);
        }
        table.getFooter().setHeight(this.cellHeight);
        if (this.report.reportType == 3) {
            if (!this.report.isSideBySideLayout()) {
                cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData();
                for (int i2 = 0; i2 < cell.length; ++i2) {
                    int colIndex = cell[i2].getColIndex(table);
                    if (!(cell[i2] instanceof ColumnHeader)) {
                        cell[i2].setFont(this.plainFont);
                        cell[i2].setBgColor(Color.white);
                    }
                    if (!(cell[i2] instanceof ColumnHeader) || !this.report.colInfo[colIndex].isMaster()) continue;
                    cell[i2].setFontColor(this.fontColor);
                    cell[i2].setBgColor(Color.white);
                }
                if (!changingStyle) {
                    this.moveMasterFieldsIn2Columns(cell, 0.1);
                }
            } else {
                for (ReportCell element : cell = table.getMasterSection().getData()) {
                    if (element instanceof ColumnHeader) {
                        element.setFontColor(this.fontColor);
                        element.setBgColor(Color.white);
                    } else {
                        element.setFont(this.plainFont);
                        element.setBgColor(Color.white);
                    }
                    element.setWidth(1.0);
                }
                double masterH = this.cellHeight * (double)cell.length / 2.0;
                masterH = Math.ceil((double)QbUtil.getPixelPerInch() * masterH) / (double)QbUtil.getPixelPerInch();
                table.getMasterSection().setHeight(masterH);
            }
        }
        Vector<ReportColumn> col = table.getColumns();
        for (i = 0; i < this.report.colInfo.length; ++i) {
            if (!this.report.colInfo[i].isRowBreak()) continue;
            col.elementAt(i).setFont(this.highlightedFont);
        }
        if (this.report.reportType == 2 && this.report.isShowColumnAggregation()) {
            cell = this.report.isColumnAggregationInHeader() ? table.getHeader().getData() : table.getFooter().getData();
            for (i = 0; i < cell.length; ++i) {
                if (cell[i] instanceof ColumnHeader || cell[i] instanceof RBColumnHeader) continue;
                cell[i].setBgColor(this.bgColor);
            }
        }
        if (this.report.reportType == 1) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i3 = 0; i3 < mtable.countRowBreakFooter(); ++i3) {
                for (ReportCell element : cell = mtable.getRowBreakFooter(i3).getData()) {
                    double d = cell[0].getX();
                    element.setX(element.getX() + d * 0.1);
                    element.setFont(this.highlightedFont);
                }
                mtable.getRowBreakFooter(i3).setHeight(this.cellHeight);
            }
        }
        if (this.report.reportType == 2 && this.report.isShowColumnAggregation()) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i4 = 0; i4 < mtable.countRowBreakFooter(); ++i4) {
                cell = this.report.isColumnAggregationInHeader() ? mtable.getRowBreakHeader(i4).getData() : mtable.getRowBreakFooter(i4).getData();
                for (ReportCell element : cell) {
                    element.setFont(this.highlightedFont);
                }
                if (this.report.isColumnAggregationInHeader()) {
                    mtable.getRowBreakHeader(i4).setHeight(this.cellHeight);
                    continue;
                }
                mtable.getRowBreakFooter(i4).setHeight(this.cellHeight);
            }
        }
        if (this.report.reportType == 1) {
            for (ReportCell element : cell = table.getFooter().getData()) {
                double d = cell[0].getX();
                element.setX(element.getX() + d * 0.1);
                element.setFont(this.highlightedFont);
            }
            table.getFooter().setHeight(this.cellHeight);
        }
        if (this.report.reportType == 2 && this.report.isShowColumnAggregation()) {
            cell = this.report.isColumnAggregationInHeader() ? table.getHeader().getData() : table.getFooter().getData();
            for (int j = 0; j < cell.length; ++j) {
                if (cell[j] instanceof ColumnHeader || cell[j] instanceof RBColumnHeader) continue;
                cell[j].setFont(this.highlightedFont);
            }
            if (!this.report.isColumnAggregationInHeader()) {
                table.getFooter().setHeight(this.cellHeight);
            }
        }
        ReportLine line = new ReportLine(false);
        if (this.report.reportType == 3 && this.report.isSideBySideLayout()) {
            line.setX(2.0);
        }
        this.report.getPageFooter().addData(line);
        this.import_xml.importLine(this.report.lineSetting);
        this.setStyleID(line);
    }

    public static void removeStyle(Report report) {
        ReportImage[] img;
        for (ReportImage element : img = report.getPageFooter().getReportImages()) {
            if (!(element instanceof ReportLine) || !ReportStyle1.isStyleElement(element)) continue;
            report.getPageFooter().removeData(element);
            return;
        }
    }
}

