/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Graphics;
import java.util.Vector;
import quadbase.common.util.internal.FontTable;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;

public class ReportStyle2
extends ReportStyle {
    Report report;
    Graphics g;
    ImportGlobalFormat import_xml;

    public ReportStyle2() {
        this.cellHeight = ReportStyle2.getDefaultCellHeight(2);
    }

    @Override
    public void importGlobalFormat(ReportMain reportmain) throws Exception {
        this.g = reportmain.getGraphics();
        this.importGlobalFormat(reportmain.report);
        this.import_xml = new ImportGlobalFormat(reportmain);
        this.import_xml.importXML(this.xmlDir + "Style2.xml");
    }

    @Override
    public void importGlobalFormat(Report report) throws Exception {
        this.report = report;
    }

    @Override
    public void styleSpecificFormat(boolean changingStyle) {
        this.lineHeight = 0.1;
        this.highlightedFont = FontTable.newFont("Serif", 1, 9);
        ReportCell[] cell = this.report.getReportHeader().getData();
        if (cell.length > 0 && !(cell[0] instanceof ReportImage)) {
            cell[0].setX(1.0);
        }
        this.report.getReportHeader().setHeight(this.reportHeaderHeight);
        ReportTable table = this.report.getReportTables().elementAt(0);
        table.getHeader().setHeight(0.4);
        if (this.report.reportType == 2) {
            int ct = 0;
            for (ColInfo element : this.report.colInfo) {
                if (!element.isColumnBreak()) continue;
                ++ct;
            }
            int countColBreakVal = 0;
            for (ColInfo element : this.report.colInfo) {
                if (element.isColumnBreakValue()) {
                    ++countColBreakVal;
                }
                if (countColBreakVal <= 1 || !this.report.isShowColumnAggregation()) continue;
                ++ct;
                break;
            }
            if (this.report.isColumnAggregationInHeader() && this.report.isShowColumnAggregation()) {
                ++ct;
            }
            table.getHeader().setHeight(this.cellHeight * (double)ct + 0.2);
            if (this.report.isAlignCrossTabColBkValHori()) {
                table.setHeight(this.cellHeight);
            } else {
                table.setHeight(this.cellHeight * (double)ct);
            }
        } else {
            table.setHeight(this.cellHeight);
        }
        int columnCount = 0;
        if (this.report.reportType != 3) {
            columnCount = table.getVisibleColumnCount();
        } else {
            for (int j = 0; j < this.report.colInfo.length; ++j) {
                if (this.report.colInfo[j].isMaster() || !this.report.colInfo[j].isVisible()) continue;
                ++columnCount;
            }
        }
        if (this.report.reportType == 3) {
            cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData();
            if (!changingStyle) {
                this.moveMasterFieldsIn2Columns(cell);
            }
            if (this.report.isSideBySideLayout()) {
                cell = table.getMasterSection().getData();
                for (int i = 0; i < cell.length; ++i) {
                    cell[i].setY((double)(i / 2) * this.cellHeight);
                }
                table.getMasterSection().setHeight(this.cellHeight * (double)table.getMasterSection().getCellCount() / 2.0);
            }
        }
        if (this.report.reportType == 1 || this.report.reportType == 2) {
            table.getHeader().getData()[0].setAlign((short)1);
            Vector<ReportColumn> col = table.getColumns();
            for (int i = 0; i < this.report.colInfo.length; ++i) {
                if (!this.report.colInfo[i].isRowBreak()) continue;
                col.elementAt(i).setFont(this.highlightedFont);
                col.elementAt(i).setAlign((short)1);
            }
        }
        if (this.report.reportType == 1) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtable.countRowBreakFooter(); ++i) {
                for (ReportCell element : cell = mtable.getRowBreakFooter(i).getData()) {
                    element.setFont(this.highlightedFont);
                }
            }
        }
        if (this.report.reportType == 2 || this.report.reportType == 1) {
            cell = this.report.isColumnAggregationInHeader() ? table.getHeader().getData() : table.getFooter().getData();
            for (int j = 0; j < cell.length; ++j) {
                if (cell[j] instanceof ColumnHeader || cell[j] instanceof RBColumnHeader) continue;
                cell[j].setFont(this.highlightedFont);
            }
        }
        ReportLine line = new ReportLine(false);
        if (this.report.reportType == 3 && this.report.isSideBySideLayout()) {
            line.setX(2.0);
        }
        if (this.report.reportType != 3) {
            table.getHeader().addData(line);
            cell = table.getHeader().getData();
        } else {
            ((ReportTreeTable)table).getSubTable(0).getHeader().addData(line);
            cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData();
        }
        for (int i = 0; i < cell.length; ++i) {
            if (cell[i] instanceof ReportLine) continue;
            cell[i].setY(cell[i].getY() + this.lineHeight);
        }
        if (this.report.reportType == 1 || this.report.reportType == 2) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtable.countRowBreakFooter(); ++i) {
                cell = this.report.isColumnAggregationInHeader() ? mtable.getRowBreakHeader(i).getData() : mtable.getRowBreakFooter(i).getData();
                for (ReportCell element : cell) {
                    element.setFont(this.highlightedFont);
                }
                if (this.report.isColumnAggregationInHeader()) {
                    mtable.getRowBreakHeader(i).setHeight(this.cellHeight);
                    continue;
                }
                mtable.getRowBreakFooter(i).setHeight(this.cellHeight);
            }
        }
        if (this.report.reportType == 1 || this.report.reportType == 2) {
            cell = this.report.isColumnAggregationInHeader() ? table.getHeader().getData() : table.getFooter().getData();
            for (int j = 0; j < cell.length; ++j) {
                if (cell[j] instanceof ColumnHeader || cell[j] instanceof RBColumnHeader) continue;
                cell[j].setFont(this.highlightedFont);
            }
            if (!this.report.isColumnAggregationInHeader()) {
                table.getFooter().setHeight(0.4);
            }
        }
        ReportLine line2 = new ReportLine(false);
        if (this.report.reportType != 3) {
            cell = table.getHeader().getData();
            if (cell.length >= 2) {
                line2.setY(cell[cell.length - 2].getY() + cell[cell.length - 2].getHeight());
            } else {
                line2.setY(this.cellHeight + this.lineHeight);
            }
            table.getHeader().addData(line2);
        } else {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            cell = mtable.getRowBreakHeader(0).getData();
            if (cell.length >= 2) {
                line2.setY(cell[cell.length - 2].getY() + cell[cell.length - 2].getHeight());
            } else {
                line2.setY(this.cellHeight + this.lineHeight);
            }
            ((ReportTreeTable)table).getSubTable(0).getHeader().addData(line2);
            ((ReportTreeTable)table).getSubTable(0).getHeader().setHeight(line2.getY() + this.lineHeight);
        }
        ReportLine line3 = new ReportLine(false);
        if (this.report.reportType == 1 || this.report.reportType == 0 || this.report.reportType == 3) {
            table.getFooter().addData(line3);
        }
        cell = table.getFooter().getData();
        for (int i = 0; i < cell.length; ++i) {
            if (cell[i] instanceof ReportLine) continue;
            cell[i].setY(this.lineHeight);
        }
        ReportLine line4 = new ReportLine(false);
        if ((this.report.reportType == 1 || this.report.reportType == 2) && cell.length >= 2) {
            line4.setY(cell[cell.length - 2].getY() + cell[cell.length - 2].getHeight());
            table.getFooter().addData(line4);
            table.getFooter().setHeight(line4.getY() + this.lineHeight);
        }
        this.import_xml.importLine(this.report.lineSetting);
        if (this.report.reportType == 1) {
            ReportSection section = ((ReportMultiSectionTable)table).getRowBreakHeader(0);
            if (section == null) {
                return;
            }
            for (ReportCell element : cell = table.getHeader().getData()) {
                String ID = element.getID();
                ID = "TBL0_H_SEC0_" + ID.substring(9);
                element.setID(ID);
            }
            section.setData(table.getHeader().getData());
            section.setHeight(table.getHeader().getHeight());
            table.getHeader().setData(new ReportCell[0]);
        }
        this.setStyleID(line);
        this.setStyleID(line2);
        this.setStyleID(line3);
        this.setStyleID(line4);
    }

    @Override
    public void reApplyStyle(ReportTable table, int reportStyle) {
        int i;
        this.lineHeight = 0.1;
        if (table.getHeader().isCrossTabFixedFieldHeader()) {
            return;
        }
        ReportCell[] cell = table.getHeader().getData();
        for (i = 0; i < cell.length; ++i) {
            if (cell[i] instanceof ReportLine) continue;
            cell[i].setY(this.lineHeight);
        }
        cell = table.getFooter().getData();
        for (i = 0; i < cell.length; ++i) {
            if (cell[i] instanceof ReportLine) continue;
            cell[i].setY(this.lineHeight);
        }
    }

    public static void removeStyle(Report report) {
        ReportTable table = report.getReportTables().elementAt(0);
        ReportCell[] cell = table.getHeader().getData();
        double lineHeight = 0.1;
        for (ReportCell element : cell) {
            if (element instanceof ReportLine && ReportStyle2.isStyleElement(element)) {
                table.getHeader().removeData(element);
                continue;
            }
            if (element.getY() != lineHeight) continue;
            element.setY(0.0);
        }
        if (table instanceof ReportTreeTable && ((ReportTreeTable)table).countSubTable() > 0) {
            for (ReportCell element : cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData()) {
                if (!(element instanceof ReportLine) || !ReportStyle2.isStyleElement(element)) continue;
                ((ReportTreeTable)table).getSubTable(0).getHeader().removeData(element);
            }
        }
        for (ReportCell element : cell = table.getFooter().getData()) {
            if (element instanceof ReportLine && ReportStyle2.isStyleElement(element)) {
                table.getFooter().removeData(element);
                continue;
            }
            if (element.getY() != lineHeight) continue;
            element.setY(0.0);
        }
    }
}

