/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;

public class ReportStyle3
extends ReportStyle {
    Report report;
    Graphics g;
    ImportGlobalFormat import_xml;

    public ReportStyle3() {
        this.cellHeight = ReportStyle3.getDefaultCellHeight(3);
    }

    @Override
    public void importGlobalFormat(ReportMain reportmain) throws Exception {
        this.g = reportmain.getGraphics();
        this.importGlobalFormat(reportmain.report);
        this.import_xml = new ImportGlobalFormat(reportmain);
        this.import_xml.importXML(this.xmlDir + "Style3.xml");
    }

    @Override
    public void importGlobalFormat(Report report) throws Exception {
        this.report = report;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void styleSpecificFormat(boolean changingStyle) {
        int i;
        this.cellWidth = 1.1;
        this.titleWidth = 4.1;
        this.titleFont = FontTable.newFont("Dialog", 1, 12);
        this.plainFont = FontTable.newFont("Dialog", 0, 8);
        this.highlightedFont = FontTable.newFont("Dialog", 1, 8);
        this.fontColor = new Color(120, 36, 23);
        this.bgColor = new Color(250, 250, 225);
        ReportTable table = this.report.getReportTables().elementAt(0);
        ReportCell[] cell = this.report.getReportHeader().getData();
        if (cell.length > 0 && !(cell[0] instanceof ReportImage)) {
            if (this.report.reportType != 3) {
                this.titleWidth = this.cellWidth * (double)table.getVisibleColumnCount();
                if (this.titleWidth > this.report.getActualPageWidth()) {
                    this.titleWidth = this.report.getActualPageWidth();
                }
                this.titleWidth -= this.cellWidth;
            } else {
                int countDetailFields = 0;
                for (int j = 0; j < this.report.colInfo.length; ++j) {
                    if (this.report.colInfo[j].isMaster()) continue;
                    ++countDetailFields;
                }
                this.titleWidth = this.cellWidth * (double)countDetailFields;
                if (this.titleWidth > this.report.getActualPageWidth()) {
                    this.titleWidth = this.report.getActualPageWidth();
                }
                this.titleWidth -= this.cellWidth;
            }
            FontMetrics fm = this.g.getFontMetrics(QbUtil.resizeViewerFont(this.titleFont, true));
            int pixel = fm.charsWidth(cell[0].getText().toCharArray(), 0, cell[0].getText().length());
            double width = QbUtil.toInch(pixel);
            if (width > this.titleWidth) {
                this.titleWidth = width;
            }
            cell[0].setWidth(this.titleWidth);
            cell[0].setX(this.cellWidth / 2.0);
        }
        this.report.getReportHeader().setHeight(this.reportHeaderHeight);
        if (this.report.reportType == 3) {
            if (!this.report.isSideBySideLayout()) {
                cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData();
                for (int i2 = 0; i2 < cell.length; ++i2) {
                    int colIndex = cell[i2].getColIndex(table);
                    if (!(cell[i2] instanceof ColumnHeader)) {
                        cell[i2].setFont(this.plainFont);
                        cell[i2].setBgColor(Color.white);
                        cell[i2].setBorderThickness(0);
                    }
                    if (!(cell[i2] instanceof ColumnHeader) || !this.report.colInfo[colIndex].isMaster()) continue;
                    cell[i2].setFontColor(this.fontColor);
                    cell[i2].setBgColor(Color.white);
                    cell[i2].setBorderThickness(0);
                    cell[i2].setAlign((short)1);
                }
                if (!changingStyle) {
                    this.moveMasterFieldsIn2Columns(cell, 0.1);
                }
            } else {
                cell = table.getMasterSection().getData();
                for (int i3 = 0; i3 < cell.length; ++i3) {
                    if (cell[i3] instanceof ColumnHeader) {
                        cell[i3].setFontColor(this.fontColor);
                        cell[i3].setBgColor(Color.white);
                        cell[i3].setBorderThickness(0);
                        cell[i3].setAlign((short)1);
                    } else {
                        cell[i3].setFont(this.plainFont);
                        cell[i3].setBgColor(Color.white);
                        cell[i3].setBorderThickness(0);
                    }
                    cell[i3].setY((double)(i3 / 2) * this.cellHeight);
                    cell[i3].setWidth(1.0);
                }
                ReportCell[] headerCells = ((ReportTreeTable)table).getSubTable(0).getHeader().getData();
                if (headerCells != null && headerCells.length > 0 && headerCells[0] != null) {
                    ReportCell[] colIndex = headerCells;
                    int width = colIndex.length;
                    for (int j = 0; j < width; ++j) {
                        ReportCell headerCell = colIndex[j];
                        if (headerCells[0] == null) continue;
                        headerCells[0].setZ(1);
                    }
                }
                for (i = 0; i < table.getColumnCount(); ++i) {
                    if (table.getColumn(i) == null) continue;
                    table.getColumn(i).setZ(1);
                }
                ((ReportTreeTable)table).getSubTable(0).getHeader().setHeight(this.cellHeight);
                table.getMasterSection().setHeight(this.cellHeight * (double)cell.length / 2.0);
            }
        }
        table.getHeader().setHeight(this.cellHeight);
        if (this.report.reportType == 2) {
            int ct = 0;
            for (ColInfo element : this.report.colInfo) {
                if (!element.isColumnBreak()) continue;
                ++ct;
            }
            int countColBreakVal = 0;
            for (ColInfo colInfo : this.report.colInfo) {
                if (colInfo.isColumnBreakValue()) {
                    ++countColBreakVal;
                }
                if (countColBreakVal <= 1 || !this.report.isShowColumnAggregation()) continue;
                ++ct;
                break;
            }
            if (this.report.isColumnAggregationInHeader() && this.report.isShowColumnAggregation()) {
                ++ct;
            }
            table.getHeader().setHeight(this.cellHeight * (double)ct);
            if (this.report.isAlignCrossTabColBkValHori()) {
                table.setHeight(this.cellHeight);
            } else {
                table.setHeight(this.cellHeight * (double)ct);
            }
        } else {
            table.setHeight(this.cellHeight);
        }
        Vector<ReportColumn> col = table.getColumns();
        for (i = 0; i < this.report.colInfo.length; ++i) {
            if (!this.report.colInfo[i].isRowBreak()) continue;
            col.elementAt(i).setFont(FontTable.newFont("Dialog", 3, 8));
        }
        if (this.report.reportType == 1) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i4 = 0; i4 < mtable.countRowBreakFooter(); ++i4) {
                void var9_33;
                ReportCell[] reportCellArray = cell = mtable.getRowBreakFooter(i4).getData();
                int n = reportCellArray.length;
                boolean bl = false;
                while (var9_33 < n) {
                    ReportCell element = reportCellArray[var9_33];
                    double d = cell[0].getX();
                    element.setFont(this.highlightedFont);
                    element.setBgColor(this.bgColor);
                    element.setX(element.getX() + d * 0.1);
                    element.setBorderThickness(1);
                    ++var9_33;
                }
                mtable.getRowBreakFooter(i4).setHeight(this.cellHeight);
            }
            for (ReportCell reportCell : cell = table.getFooter().getData()) {
                double d = cell[0].getX();
                reportCell.setFont(this.highlightedFont);
                reportCell.setBgColor(this.bgColor);
                reportCell.setX(reportCell.getX() + d * 0.1);
                reportCell.setBorderThickness(1);
            }
            table.getFooter().setHeight(this.cellHeight);
        }
        if (this.report.reportType == 2 && this.report.isShowColumnAggregation()) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i5 = 0; i5 < mtable.countRowBreakFooter(); ++i5) {
                void var9_37;
                cell = this.report.isColumnAggregationInHeader() ? table.getRowBreakHeader(i5).getData() : mtable.getRowBreakFooter(i5).getData();
                ReportCell[] reportCellArray = cell;
                int n = reportCellArray.length;
                boolean bl = false;
                while (var9_37 < n) {
                    ReportCell element = reportCellArray[var9_37];
                    element.setFont(this.highlightedFont);
                    element.setBgColor(this.bgColor);
                    element.setBorderThickness(1);
                    ++var9_37;
                }
                if (this.report.isColumnAggregationInHeader()) {
                    mtable.getRowBreakHeader(i5).setHeight(this.cellHeight);
                    continue;
                }
                mtable.getRowBreakFooter(i5).setHeight(this.cellHeight);
            }
            cell = this.report.isColumnAggregationInHeader() ? table.getHeader().getData() : table.getFooter().getData();
            for (int j = 0; j < cell.length; ++j) {
                if (cell[j] instanceof ColumnHeader || cell[j] instanceof RBColumnHeader) continue;
                cell[j].setFont(this.highlightedFont);
                cell[j].setBgColor(this.bgColor);
                cell[j].setBorderThickness(1);
            }
            if (!this.report.isColumnAggregationInHeader()) {
                table.getFooter().setHeight(this.cellHeight);
            }
        }
    }

    public static void removeStyle(Report report) {
    }
}

