/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;

public class ReportStyle4
extends ReportStyle {
    Report report;
    Graphics g;
    ImportGlobalFormat import_xml;

    public ReportStyle4() {
        this.cellHeight = ReportStyle4.getDefaultCellHeight(4);
    }

    @Override
    public void importGlobalFormat(ReportMain reportmain) throws Exception {
        this.g = reportmain.getGraphics();
        this.importGlobalFormat(reportmain.report);
        this.import_xml = new ImportGlobalFormat(reportmain);
        this.import_xml.importXML(this.xmlDir + "Style4.xml");
    }

    @Override
    public void importGlobalFormat(Report report) throws Exception {
        this.report = report;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void styleSpecificFormat(boolean changingStyle) {
        ReportCell rc;
        ReportSection section;
        void var10_34;
        this.cellWidth = 1.1;
        this.lineHeight = 0.03;
        this.plainFont = FontTable.newFont("Dialog", 0, 9);
        this.highlightedFont = FontTable.newFont("Dialog", 1, 9);
        ReportTable table = this.report.getReportTables().elementAt(0);
        ReportCell[] cell = this.report.getReportHeader().getData();
        int columnCount = 0;
        if (this.report.reportType != 3) {
            columnCount = table.getVisibleColumnCount();
        } else {
            for (int j = 0; j < this.report.colInfo.length; ++j) {
                if (this.report.colInfo[j].isMaster() || !this.report.colInfo[j].isVisible()) continue;
                ++columnCount;
            }
        }
        if (cell.length > 0 && !(cell[0] instanceof ReportImage)) {
            cell[0].setX((this.cellWidth * (double)columnCount - cell[0].getWidth()) / 2.0);
        }
        this.report.getReportHeader().setHeight(this.reportHeaderHeight);
        int ct = 1;
        if (this.report.reportType == 2) {
            ct = 0;
            for (ColInfo element : this.report.colInfo) {
                if (!element.isColumnBreak()) continue;
                ++ct;
            }
            int countColBreakVal = 0;
            ColInfo[] colInfoArray = this.report.colInfo;
            int n = colInfoArray.length;
            for (int element = 0; element < n; ++element) {
                ColInfo colInfo = colInfoArray[element];
                if (colInfo.isColumnBreakValue()) {
                    ++countColBreakVal;
                }
                if (countColBreakVal <= 1 || !this.report.isShowColumnAggregation()) continue;
                ++ct;
                break;
            }
            if (this.report.isColumnAggregationInHeader() && this.report.isShowColumnAggregation()) {
                ++ct;
            }
            table.getHeader().setHeight(this.cellHeight * (double)ct);
            if (this.report.isAlignCrossTabColBkValHori()) {
                table.setHeight(this.cellHeight + this.lineHeight);
            } else {
                table.setHeight(this.cellHeight * (double)ct + this.lineHeight);
            }
        } else {
            table.setHeight(this.cellHeight + this.lineHeight);
        }
        if (this.report.reportType == 3) {
            if (!this.report.isSideBySideLayout()) {
                cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData();
                for (int i = 0; i < cell.length; ++i) {
                    int colIndex = cell[i].getColIndex(table);
                    if (!(cell[i] instanceof ColumnHeader)) {
                        cell[i].setFont(this.plainFont);
                    }
                    if (!(cell[i] instanceof ColumnHeader) || !this.report.colInfo[colIndex].isMaster()) continue;
                    cell[i].setBgColor(Color.white);
                }
                if (!changingStyle) {
                    this.moveMasterFieldsIn2Columns(cell);
                }
            } else {
                for (ReportCell element : cell = table.getMasterSection().getData()) {
                    if (element instanceof ColumnHeader) {
                        element.setBgColor(Color.white);
                    } else {
                        element.setFont(this.plainFont);
                    }
                    element.setWidth(1.0);
                }
                table.getMasterSection().setHeight(0.31 * (double)cell.length / 2.0);
            }
        }
        if (this.report.reportType == 1 || this.report.reportType == 2) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtable.countRowBreakHeader(); ++i) {
                if (this.report.isColumnAggregationInHeader()) {
                    mtable.getRowBreakHeader(i).setHeight(0.4);
                    continue;
                }
                mtable.getRowBreakFooter(i).setHeight(0.4);
            }
        }
        Vector<ReportColumn> col = table.getColumns();
        for (int i = 0; i < this.report.colInfo.length; ++i) {
            if (!this.report.colInfo[i].isRowBreak()) continue;
            col.elementAt(i).setFont(this.highlightedFont);
        }
        if (this.report.reportType == 1) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtable.countRowBreakFooter(); ++i) {
                for (ReportCell element : cell = mtable.getRowBreakFooter(i).getData()) {
                    double d = cell[0].getX();
                    element.setX(element.getX() + d * 0.1);
                    element.setFont(this.highlightedFont);
                }
                mtable.getRowBreakFooter(i).setHeight(this.cellHeight);
            }
        }
        if (this.report.reportType == 1) {
            for (ReportCell reportCell : cell = table.getFooter().getData()) {
                double d = cell[0].getX();
                reportCell.setX(reportCell.getX() + d * 0.1);
                reportCell.setFont(this.highlightedFont);
            }
            table.getFooter().setHeight(this.cellHeight);
        }
        int masterNum = 0;
        ColInfo[] i = this.report.colInfo;
        int element = i.length;
        boolean bl = false;
        while (var10_34 < element) {
            ColInfo element2 = i[var10_34];
            if (element2.isMaster()) {
                ++masterNum;
            }
            ++var10_34;
        }
        if (this.report.colInfo.length == masterNum) {
            return;
        }
        ReportLine topLine = new ReportLine(false);
        ReportLine leftLine = new ReportLine(true);
        leftLine.setHeight(this.cellHeight + this.lineHeight);
        ReportLine reportLine = new ReportLine(true);
        reportLine.setHeight(this.cellHeight + this.lineHeight);
        ReportCell[] hcell = table.getHeader().getData();
        double maxX = 0.0;
        if (hcell.length == 0) {
            hcell = ((ReportMultiSectionTable)table).getRowBreakHeader(0).getCells();
        }
        for (int i2 = 0; i2 < hcell.length; ++i2) {
            if (!hcell[i2].isVisible() || hcell[i2] instanceof ReportLine || !(hcell[i2].getX() + hcell[i2].getWidth() > maxX)) continue;
            maxX = hcell[i2].getX() + hcell[i2].getWidth();
        }
        reportLine.setX(maxX);
        ReportLine bottomLine = new ReportLine(false);
        bottomLine.setY(this.cellHeight * (double)ct);
        if (this.report.reportType != 3) {
            table.getHeader().addData(topLine);
            table.getHeader().addData(leftLine);
            table.getHeader().addData(reportLine);
            table.getHeader().addData(bottomLine);
        } else {
            if (this.report.isSideBySideLayout()) {
                topLine.setY(0.0);
                topLine.setX(2.0);
                leftLine.setX(2.0);
                bottomLine.setX(2.0);
            } else {
                int i3 = (int)Math.ceil((double)masterNum / 2.0) * 2 - 1;
                topLine.setY(cell[i3].getY() + cell[i3].getHeight());
            }
            ((ReportTreeTable)table).getSubTable(0).getHeader().addData(topLine);
            leftLine.setY(topLine.getY());
            ((ReportTreeTable)table).getSubTable(0).getHeader().addData(leftLine);
            reportLine.setY(topLine.getY());
            ((ReportTreeTable)table).getSubTable(0).getHeader().addData(reportLine);
            bottomLine.setY(topLine.getY() + this.cellHeight);
            ((ReportTreeTable)table).getSubTable(0).getHeader().addData(bottomLine);
            ((ReportTreeTable)table).getSubTable(0).getHeader().setHeight(((ReportTreeTable)table).getSubTable(0).getHeader().getHeight() + this.lineHeight);
        }
        ReportLine leftLine2 = new ReportLine(true);
        leftLine2.setY(0.0);
        leftLine2.setHeight(leftLine2.getHeight() + 0.01);
        leftLine.setNextLine(leftLine2);
        table.addImage(leftLine2);
        ReportLine leftLine3 = new ReportLine(true);
        leftLine3.setY(0.0);
        leftLine3.setHeight(0.01);
        leftLine2.setNextLine(leftLine3);
        ReportLine rightLine2 = new ReportLine(true);
        rightLine2.applyTemplate(reportLine);
        rightLine2.setY(0.0);
        rightLine2.setHeight(rightLine2.getHeight() + 0.01);
        reportLine.setNextLine(rightLine2);
        table.addImage(rightLine2);
        ReportLine rightLine3 = new ReportLine(true);
        rightLine3.applyTemplate(reportLine);
        rightLine3.setY(0.0);
        rightLine3.setHeight(0.01);
        rightLine2.setNextLine(rightLine3);
        ReportLine topLine2 = new ReportLine(false);
        topLine2.setY(0.0);
        if (this.report.isSideBySideLayout()) {
            topLine2.setX(2.0);
        }
        if (this.report.reportType == 1 || this.report.reportType == 3) {
            if (((ReportMultiSectionTable)table).getRowBreakFooter(0) != null) {
                ((ReportMultiSectionTable)table).getRowBreakFooter(0).addData(topLine2);
                ((ReportMultiSectionTable)table).getRowBreakFooter(0).addData(leftLine3);
                ((ReportMultiSectionTable)table).getRowBreakFooter(0).addData(rightLine3);
            } else {
                table.getFooter().addData(topLine2);
                table.getFooter().addData(leftLine3);
                table.getFooter().addData(rightLine3);
            }
        } else {
            table.getFooter().addData(topLine2);
            table.getFooter().addData(leftLine3);
            table.getFooter().addData(rightLine3);
        }
        this.import_xml.importLine(this.report.lineSetting);
        bottomLine.setLineStyle(2);
        leftLine.setHeight(this.cellHeight * (double)ct + this.lineHeight);
        reportLine.setHeight(this.cellHeight * (double)ct + this.lineHeight);
        if (this.report.reportType == 1) {
            section = ((ReportMultiSectionTable)table).getRowBreakHeader(0);
            if (section == null) {
                return;
            }
            for (ReportCell element3 : cell = table.getHeader().getData()) {
                String ID = element3.getID();
                ID = "TBL0_H_SEC0_" + ID.substring(9);
                element3.setID(ID);
            }
            section.setData(table.getHeader().getData());
            section.setHeight(table.getHeader().getHeight());
            table.getHeader().setData(new ReportCell[0]);
        } else if (this.report.reportType == 3) {
            section = ((ReportTreeTable)table).getSubTable(0).getHeader();
            section.setHeight(QbUtil.toInch(QbUtil.toPixelCeil(((ReportTreeTable)table).getSubTable(0).getHeader().getHeight())));
        }
        for (int i4 = 0; i4 < table.getHeader().getCellCount() && (rc = table.getHeader().getData(i4)) instanceof ReportLine; ++i4) {
        }
        if (this.report.reportType == 1 || this.report.reportType == 2) {
            int i5;
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (i5 = 0; i5 < mtable.countRowBreakHeader(); ++i5) {
                for (ReportCell rc2 : cell = mtable.getRowBreakHeader(i5).getData()) {
                    if (!(rc2 instanceof ReportLine)) break;
                }
            }
            for (i5 = 0; i5 < mtable.countRowBreakFooter(); ++i5) {
                for (ReportCell rc2 : cell = mtable.getRowBreakFooter(i5).getData()) {
                    if (!(rc2 instanceof ReportLine)) break;
                }
            }
        }
        this.setStyleID(topLine);
        this.setStyleID(leftLine);
        this.setStyleID(reportLine);
        this.setStyleID(bottomLine);
        this.setStyleID(leftLine2);
        this.setStyleID(rightLine2);
        this.setStyleID(topLine2);
    }

    @Override
    public void reApplyStyle(ReportTable table, int reportStyle) {
        ReportCell[] cell = table.getHeader().getData();
        double maxX = 0.0;
        for (int i = 0; i < cell.length; ++i) {
            if (!cell[i].isVisible() || cell[i] instanceof ReportLine || !(cell[i].getX() + cell[i].getWidth() > maxX)) continue;
            maxX = cell[i].getX() + cell[i].getWidth();
        }
        for (ReportCell element : cell) {
            if (!(element instanceof ReportLine) || !(element.getX() > 0.0)) continue;
            element.setX(maxX);
        }
        for (ReportCell element : cell = table.getImage()) {
            if (!(element instanceof ReportLine) || !(element.getX() > 0.0)) continue;
            element.setX(maxX);
        }
    }

    public static void removeStyle(Report report) {
        ReportImage[] cell;
        ReportTable table = report.getReportTables().elementAt(0);
        for (ReportImage element : cell = table.getHeader().getReportImages()) {
            if (!(element instanceof ReportLine) || !ReportStyle4.isStyleElement(element)) continue;
            table.getHeader().removeData(element);
        }
        for (ReportImage element : cell = table.getImage()) {
            if (!(element instanceof ReportLine) || !ReportStyle4.isStyleElement(element)) continue;
            table.removeImage(element);
        }
        if (table instanceof ReportTreeTable && ((ReportTreeTable)table).countSubTable() > 0) {
            for (ReportImage element : cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getReportImages()) {
                if (!(element instanceof ReportLine) || !ReportStyle4.isStyleElement(element)) continue;
                ((ReportTreeTable)table).getSubTable(0).getHeader().removeData(element);
            }
        }
        for (ReportImage element : cell = table.getFooter().getReportImages()) {
            if (!(element instanceof ReportLine) || !ReportStyle4.isStyleElement(element)) continue;
            table.getFooter().removeData(element);
        }
    }
}

