/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Graphics;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.util.ColInfo;

public class ReportStyle5
extends ReportStyle {
    Report report;
    Graphics g;
    ImportGlobalFormat import_xml;

    public ReportStyle5() {
        this.cellHeight = ReportStyle5.getDefaultCellHeight(5);
    }

    @Override
    public void importGlobalFormat(ReportMain reportmain) throws Exception {
        this.g = reportmain.getGraphics();
        this.importGlobalFormat(reportmain.report);
        this.import_xml = new ImportGlobalFormat(reportmain);
        this.import_xml.importXML(this.xmlDir + "Style5.xml");
    }

    @Override
    public void importGlobalFormat(Report report) throws Exception {
        this.report = report;
    }

    @Override
    public void styleSpecificFormat(boolean changingStyle) {
        this.cellWidth = 1.0;
        this.lineHeight = QbUtil.toInch(2.0) + 0.02;
        this.plainFont = FontTable.newFont("Dialog", 0, 8);
        this.highlightedFont = FontTable.newFont("Dialog", 1, 8);
        this.fontColor = new Color(63, 63, 76);
        ReportTable table = this.report.getReportTables().elementAt(0);
        ReportCell[] cell = this.report.getReportHeader().getData();
        this.report.getReportHeader().setHeight(this.reportHeaderHeight);
        table.setHeight(this.cellHeight);
        table.getHeader().setHeight(0.24);
        int ct = 1;
        if (this.report.reportType == 2) {
            ct = 0;
            for (ColInfo element : this.report.colInfo) {
                if (!element.isColumnBreak()) continue;
                ++ct;
            }
            int countColBreakVal = 0;
            for (ColInfo element : this.report.colInfo) {
                if (element.isColumnBreakValue()) {
                    ++countColBreakVal;
                }
                if (countColBreakVal <= 1 || !this.report.isShowColumnAggregation()) continue;
                ++ct;
                break;
            }
            if (this.report.isColumnAggregationInHeader() && this.report.isShowColumnAggregation()) {
                ++ct;
            }
            table.getHeader().setHeight(this.cellHeight * (double)ct);
        }
        int columnCount = 0;
        if (this.report.reportType != 3) {
            columnCount = table.getVisibleColumnCount();
        } else {
            for (int j = 0; j < this.report.colInfo.length; ++j) {
                if (this.report.colInfo[j].isMaster() || !this.report.colInfo[j].isVisible()) continue;
                ++columnCount;
            }
        }
        if (this.report.reportType == 3) {
            if (!this.report.isSideBySideLayout()) {
                cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData();
                for (int i = 0; i < cell.length; ++i) {
                    int colIndex = cell[i].getColIndex(table);
                    if (!(cell[i] instanceof ColumnHeader)) {
                        cell[i].setFont(this.plainFont);
                    }
                    if (!(cell[i] instanceof ColumnHeader) || !this.report.colInfo[colIndex].isMaster()) continue;
                    cell[i].setFontColor(this.fontColor);
                }
                if (!changingStyle) {
                    this.moveMasterFieldsIn2Columns(cell);
                }
            } else {
                cell = table.getMasterSection().getData();
                for (int i = 0; i < cell.length; ++i) {
                    if (cell[i] instanceof ColumnHeader) {
                        cell[i].setFontColor(this.fontColor);
                    } else {
                        cell[i].setFont(this.plainFont);
                    }
                    cell[i].setY((double)(i / 2) * this.cellHeight);
                    cell[i].setWidth(1.0);
                }
                table.getMasterSection().setHeight(this.cellHeight * (double)cell.length / 2.0);
            }
        }
        if (this.report.reportType == 1 || this.report.reportType == 2) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtable.countRowBreakFooter(); ++i) {
                cell = this.report.isColumnAggregationInHeader() ? table.getRowBreakHeader(i).getData() : mtable.getRowBreakFooter(i).getData();
                for (ReportCell element : cell) {
                    element.setFont(this.highlightedFont);
                }
                if (this.report.isColumnAggregationInHeader()) {
                    mtable.getRowBreakHeader(i).setHeight(0.24);
                    continue;
                }
                mtable.getRowBreakFooter(i).setHeight(0.24);
            }
        }
        if (this.report.reportType == 1 || this.report.reportType == 2) {
            cell = this.report.isColumnAggregationInHeader() ? table.getHeader().getData() : table.getFooter().getData();
            for (int j = 0; j < cell.length; ++j) {
                if (cell[j] instanceof ColumnHeader || cell[j] instanceof RBColumnHeader) continue;
                cell[j].setFont(this.highlightedFont);
            }
            if (!this.report.isColumnAggregationInHeader()) {
                table.getFooter().setHeight(0.24);
            }
        }
        ReportLine headerLine = new ReportLine(false);
        headerLine.setHeight(this.lineHeight);
        if (!this.report.isCrossTabFixedField() || ct == 1) {
            headerLine.setY(this.cellHeight);
        } else {
            headerLine.setY(0.3 * (double)ct);
        }
        if (this.report.reportType != 3) {
            table.getHeader().addData(headerLine);
        } else {
            if (this.report.isSideBySideLayout()) {
                headerLine.setX(2.0);
            }
            if (cell.length >= 1) {
                headerLine.setY(cell[cell.length - 1].getY() + cell[cell.length - 1].getHeight());
            }
            ((ReportTreeTable)table).getSubTable(0).getHeader().addData(headerLine);
            ((ReportTreeTable)table).getSubTable(0).getHeader().setHeight(((ReportTreeTable)table).getSubTable(0).getHeader().getHeight() + this.lineHeight);
        }
        ReportLine footerLine = new ReportLine(false);
        ReportLine footerLine2 = null;
        if (this.report.reportType == 0) {
            footerLine.setY(0.0);
            table.getFooter().addData(footerLine);
        } else if (this.report.reportType == 1) {
            ReportMultiSectionTable mtable = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtable.countRowBreakFooter(); ++i) {
                for (ReportCell element : cell = mtable.getRowBreakFooter(i).getData()) {
                    element.setFont(this.highlightedFont);
                }
            }
            if (((ReportMultiSectionTable)table).getRowBreakFooter(0) != null) {
                ((ReportMultiSectionTable)table).getRowBreakFooter(0).addData(footerLine);
            }
            footerLine2 = new ReportLine();
            table.getFooter().addData(footerLine2);
        } else if (this.report.reportType == 2) {
            cell = this.report.isColumnAggregationInHeader() ? table.getHeader().getData() : table.getFooter().getData();
            for (int j = 0; j < cell.length; ++j) {
                if (cell[j] instanceof ColumnHeader || cell[j] instanceof RBColumnHeader) continue;
                cell[j].setFont(this.highlightedFont);
            }
            table.getFooter().addData(footerLine);
        } else if (this.report.reportType == 3) {
            if (this.report.isSideBySideLayout()) {
                footerLine.setX(2.0);
            }
            footerLine.setY(0.0);
            if (((ReportMultiSectionTable)table).getRowBreakFooter(0) != null) {
                ((ReportMultiSectionTable)table).getRowBreakFooter(0).addData(footerLine);
            }
        }
        this.import_xml.importLine(this.report.lineSetting);
        this.setStyleID(headerLine);
        this.setStyleID(footerLine);
        if (footerLine2 != null) {
            this.setStyleID(footerLine2);
        }
    }

    public static void removeStyle(Report report) {
        ReportCell[] cell;
        ReportTable table = report.getReportTables().elementAt(0);
        for (ReportCell element : cell = table.getHeader().getData()) {
            if (!(element instanceof ReportLine) || !ReportStyle5.isStyleElement(element)) continue;
            table.getHeader().removeData(element);
            break;
        }
        if (table instanceof ReportTreeTable && ((ReportTreeTable)table).countSubTable() > 0) {
            for (ReportCell element : cell = ((ReportTreeTable)table).getSubTable(0).getHeader().getData()) {
                if (!(element instanceof ReportLine) || !ReportStyle5.isStyleElement(element)) continue;
                ((ReportTreeTable)table).getSubTable(0).getHeader().removeData(element);
                break;
            }
        }
        for (ReportCell element : cell = table.getFooter().getData()) {
            if (!(element instanceof ReportLine) || !ReportStyle5.isStyleElement(element)) continue;
            table.getFooter().removeData(element);
            break;
        }
    }
}

