/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.LoadChart;
import quadbase.chart.SOAPAccess;
import quadbase.chart.SalesForceAccess;
import quadbase.chart.SaveChart;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.DisplayMsgDialog;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.UpdateDialog;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.ColInfoMappingPanel;
import quadbase.reportdesigner.designer.DefaultReportStyle;
import quadbase.reportdesigner.designer.DrillDownColumnMapDialog;
import quadbase.reportdesigner.designer.ProviderRunnerThread;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.ReportStyle1;
import quadbase.reportdesigner.designer.ReportStyle2;
import quadbase.reportdesigner.designer.ReportStyle3;
import quadbase.reportdesigner.designer.ReportStyle4;
import quadbase.reportdesigner.designer.ReportStyle5;
import quadbase.reportdesigner.designer.SaveDialog;
import quadbase.reportdesigner.designer.SelectReportFormat;
import quadbase.reportdesigner.designer.WizardStep1;
import quadbase.reportdesigner.designer.WizardStep41;
import quadbase.reportdesigner.designer.WizardStepMultiData;
import quadbase.reportdesigner.designer.globalformat.ImportGlobalFormat;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.LoadReportStyle;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IDBProvider;
import quadbase.reportdesigner.util.ReportEvent;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class ReportWizard
extends JDialog
implements IDataInterchange {
    private static final Logger LOGGER = Logger.getLogger(ReportWizard.class.getName());
    WizardStep1 step1;
    WizardStep41 step41;
    WizardStep41 stepMerge41;
    WizardStepMultiData stepMulti;
    SelectReportFormat selectFormat;
    ReportMain reportmain;
    quadbase.reportdesigner.report.ColData[] colData;
    ColInfo[] colInfo;
    Vector<quadbase.reportdesigner.report.ColData[]> colDataList = new Vector();
    Vector<Object> sourceInfo = new Vector();
    Vector<Integer> sourceType = new Vector();
    Vector<Boolean> doTranspose = new Vector();
    Vector<Object> transposeColList = new Vector();
    boolean isTransposed;
    boolean[] transposeCol;
    boolean keepDataSourceOrder;
    DBInfoBasic dbInfo;
    String sourceFile;
    XMLFileQueryInfo xmlFileQueryInfo;
    String jndiName;
    String homeName;
    String remoteName;
    String selectedMethodName;
    Object[] selectedMethodParamVal;
    Hashtable<String, String> environment;
    SOAPQueryFileInfo soapInfo;
    SalesForceQueryFileInfo sfQueryInfo;
    ExcelFileInfo excelInfo;
    String queryFilename = "";
    int sourceData;
    Report report;
    int reportType = -1;
    Manager manager;
    private JPanel managerPreviousPanel;
    boolean isRedoDataMappingOp = false;
    private boolean isDrillDownOp = false;
    private boolean crossTabDrillDown = false;
    boolean applyTemplate = true;
    boolean applyFormula = false;
    Vector<QueryInParamSet> sqlParams = null;
    private boolean exitOnCancel = false;
    private boolean fromDesigner = true;
    private int topN;
    private boolean ascending = true;
    public boolean allowPreviewEdit;
    Vector<Parameter> queryParameters;
    private int[] drillDownMapping = null;
    private boolean isSubReportOp = false;
    private ReportElement subReportOpSelectedObject = null;
    private ReportElementPanel subReportOpSelectedPanel = null;
    protected boolean sideBySide = false;
    private boolean crossTabFreeForm = false;
    private boolean reOrderColumns = true;
    private boolean showRowAggregationGrandTotal = true;
    private boolean showRowAggregationSubtotal = true;
    private boolean rowAggregationSubtotalOnLeft = false;
    private boolean rowAggregationGrandTotalOnLeft = false;
    private boolean showColumnAggregation = true;
    private boolean columnAggregationInFooter = true;
    private boolean alignCrossTabColBkValHori = true;
    private IDBProvider dbProvider = null;
    protected boolean modified = false;
    protected int dbSourceType = -1;
    protected byte[][] dbFileBytes = null;
    public String registryID;
    public String dataSourceID;
    public String dataSourceLoc;
    public Vector<SubReportObject> subReports;
    Vector<String> selectedNames;
    Vector<ReportChartObject> charts;
    boolean connectionOnly;
    DisplayMsgDialog displayMsgDialog;
    String filename;
    private boolean isCancelled = false;
    private boolean gotError = false;
    private IDataInterchange toChart;

    public ReportWizard(ReportMain f, String title) {
        super(f, title, true);
        this.reportmain = f;
    }

    public ReportWizard(ReportMain f) {
        this(f, f.getPresetDBInfo(), f.getPresetQueryInParamSet(), false, false);
    }

    public ReportWizard(ReportMain f, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newReport, boolean exit_on_cancel) {
        this(f, dbInfo, inSet, null, newReport, exit_on_cancel, true);
    }

    public ReportWizard(ReportMain f, DBInfoBasic dbInfo, String classFile, QueryInParamSet inSet, boolean newReport, boolean exit_on_cancel, boolean fromDesigner) {
        this(f, f, dbInfo, classFile, inSet, null, newReport, exit_on_cancel, fromDesigner, LanguageEncoder.getText("Report Wizard"), null);
    }

    public ReportWizard(ReportMain f, DBInfoBasic dbInfo, QueryInParamSet inSet, Manager preSetManager, boolean newReport, boolean exit_on_cancel, boolean fromDesigner) {
        this(f, f, dbInfo, inSet, preSetManager, newReport, exit_on_cancel, fromDesigner, LanguageEncoder.getText("Report Wizard"), null);
    }

    public ReportWizard(Frame frame, ReportMain f, DBInfoBasic dbInfo, QueryInParamSet inSet, Manager preSetManager, boolean newReport, boolean exit_on_cancel, boolean fromDesigner, String title, IDataInterchange toChart) {
        this(frame, f, dbInfo, null, inSet, preSetManager, newReport, exit_on_cancel, fromDesigner, title, toChart);
    }

    public ReportWizard(Frame frame, ReportMain f, DBInfoBasic dbInfo, String classFile, QueryInParamSet inSet, Manager preSetManager, boolean newReport, boolean exit_on_cancel, boolean fromDesigner, String title, IDataInterchange toChart) {
        super(frame, title, true);
        this.reportmain = f;
        this.toChart = toChart;
        this.exitOnCancel = exit_on_cancel;
        this.fromDesigner = fromDesigner;
        this.toChart = toChart;
        if (toChart != null) {
            this.reportmain.wizard = this;
        }
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReportWizard.this.cancel();
            }
        });
        if (dbInfo != null) {
            this.dbInfo = dbInfo;
            try {
                this.colData = this.getData(inSet, this.reportmain.getDisplayRow());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot get data", ex);
            }
            this.sourceData = 1;
        } else if (classFile != null) {
            this.sourceFile = classFile;
            try {
                if (ClassFileUtil.isParameterized(this.sourceFile)) {
                    if (ClassFileUtil.isParameterized(this.sourceFile)) {
                        QueryClassFileInfo classInfo = new QueryClassFileInfo(this.sourceFile);
                        QueryInParamSet paramSet = null;
                        paramSet = inSet != null ? inSet : classInfo.getInSet();
                        this.colData = new DataFileInput().readProcessedData(this.sourceFile, false, null, null, null, 0, -1, paramSet);
                        this.dbInfo = classInfo;
                    }
                } else {
                    this.colData = new DataFileInput().readProcessedData(this.sourceFile, false, null, null, null, 0, -1, null, 6);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot use class file as data source", ex);
            }
            this.sourceData = 6;
        }
        if (newReport && (dbInfo != null || this.sourceFile != null)) {
            this.newreportType();
        } else if (newReport) {
            this.newReport(false, true, null);
        } else if (preSetManager != null) {
            this.manager = preSetManager;
            this.next(false, false, null, null);
        } else {
            this.step1 = new WizardStep1(this, dbInfo);
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.setBackground(Color.lightGray);
            contentPane.add("Center", this.step1);
            this.pack();
            this.setPos(false);
        }
    }

    public ReportWizard(ReportMain f, boolean isRedoDataMappingOp) {
        super(f, LanguageEncoder.getText("Report Wizard"), true);
        int i;
        this.modified = false;
        this.reportmain = f;
        this.setBackground(Color.lightGray);
        this.report = this.reportmain.report;
        this.isRedoDataMappingOp = isRedoDataMappingOp;
        this.colData = this.report.colData;
        this.registryID = this.report.registryID;
        this.dataSourceID = this.report.dataSourceID;
        this.dataSourceLoc = this.report.dataSourceLoc;
        this.subReports = this.report.subReports;
        this.isTransposed = this.report.isTransposed;
        this.keepDataSourceOrder = this.report.isKeepDataSourceOrder();
        this.transposeCol = this.report.transposeCol;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReportWizard.this.cancel();
            }
        });
        Vector<ColInfo> temp = new Vector<ColInfo>();
        for (i = 0; i < Array.getLength(this.report.colInfo); ++i) {
            if (this.report.colInfo[i].getFormula() != null) continue;
            temp.addElement(this.report.colInfo[i]);
        }
        this.colInfo = new ColInfo[temp.size()];
        for (int j = 0; j < temp.size(); ++j) {
            this.colInfo[j] = (ColInfo)temp.elementAt(j);
        }
        if (this.report.sourceList != null) {
            for (i = 0; i < Array.getLength(this.report.sourceList); ++i) {
                this.sourceInfo.addElement(Array.get(this.report.sourceList, i));
                this.sourceType.addElement(this.report.sourceType[i]);
                this.doTranspose.addElement(this.report.doTranspose[i]);
                this.transposeColList.addElement(Array.get(this.report.transposeColList, i));
            }
        }
        this.dbInfo = this.report.dbInfo;
        this.sourceFile = this.report.sourceFile;
        this.xmlFileQueryInfo = this.report.getXMLFileQueryInfo();
        this.jndiName = this.report.jndiName;
        this.homeName = this.report.homeName;
        this.remoteName = this.report.remoteName;
        this.selectedMethodName = this.report.selectedMethodName;
        this.selectedMethodParamVal = this.report.selectedMethodParamVal;
        this.environment = this.report.environment;
        this.soapInfo = this.report.soapInfo;
        this.sfQueryInfo = this.report.sfQueryInfo;
        this.excelInfo = this.report.excelInfo;
        this.sourceData = this.report.sourceData;
        this.reportType = this.report.reportType;
        this.sideBySide = this.report.isSideBySideLayout();
        this.reOrderColumns = this.report.isReOrderColumns();
        this.showRowAggregationGrandTotal = this.report.isShowRowAggregationGrandTotal();
        this.crossTabFreeForm = this.report.crossTabFreeForm;
        this.showRowAggregationSubtotal = this.report.isShowRowAggregationSubtotal();
        this.rowAggregationSubtotalOnLeft = this.report.isRowAggregationSubtotalOnLeft();
        this.rowAggregationGrandTotalOnLeft = this.report.isRowAggregationGrandTotalOnLeft();
        this.showColumnAggregation = this.report.isShowColumnAggregation();
        this.columnAggregationInFooter = !this.report.isColumnAggregationInHeader();
        this.alignCrossTabColBkValHori = this.report.isAlignCrossTabColBkValHori();
        this.dbSourceType = this.report.getDBSourceType();
        this.dbFileBytes = this.report.getQueryFileBytes();
        ColInfoMappingPanel col = new ColInfoMappingPanel(this, isRedoDataMappingOp);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBackground(Color.lightGray);
        contentPane.add("Center", col);
        this.pack();
        this.validate();
        this.setPos(true);
    }

    void setModified() {
        this.modified = true;
    }

    boolean isModified() {
        return this.modified;
    }

    @Override
    public boolean isReport() {
        return true;
    }

    @Override
    public void setIsReport(boolean b) {
    }

    @Override
    public boolean isDataRegistryManager() {
        return false;
    }

    public void init() {
        this.setPos(false);
    }

    void setPos() {
        this.setPos(false);
    }

    private void setPos(boolean colInfoMapping) {
        Dimension screensize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if (colInfoMapping) {
            if (this.reportType == 2) {
                dim = new Dimension((int)(dim.getWidth() * 15.0 / 8.0), (int)dim.getHeight());
            } else if (this.reportType == 1) {
                dim = new Dimension((int)(dim.getWidth() * 11.0 / 8.0), (int)dim.getHeight());
            }
            if (dim.getWidth() > screensize.getWidth()) {
                dim = new Dimension((int)(screensize.getWidth() * 9.0 / 10.0), (int)dim.getHeight());
            }
        } else if (dim.getWidth() > screensize.getWidth() * 2.0 / 3.0) {
            dim = new Dimension((int)(screensize.getWidth() * 2.0 / 3.0), (int)dim.getHeight());
        }
        if (dim.getHeight() > screensize.getHeight() * 4.0 / 5.0) {
            dim = new Dimension((int)dim.getWidth(), (int)(screensize.getHeight() * 4.0 / 5.0));
        }
        int x = (screensize.width - dim.width) / 2;
        int y = (screensize.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
        if (!IOUtil.isMac() || IOUtil.isJava14()) {
            this.setSize(dim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openReport() {
        this.setVisible(false);
        this.dispose();
        if (this.isSubReportOp) {
            this.openFileForSubReport();
        } else if (!this.isDrillDownOp) {
            this.reportmain.openFile();
        } else {
            String file = "";
            Cursor currentCursor = this.getCursor();
            try {
                int i;
                String drillDownDirectory = this.reportmain.getBrowseDirectories().getReportTemplatesDirectory();
                OpenFileDialog openDialog = new OpenFileDialog(this.reportmain, LanguageEncoder.getText("Open File..."), "", new String[]{"RPT", "XML", "PAK"}, drillDownDirectory);
                openDialog.setVisible(true);
                if (openDialog.getSelectedFile() == null) {
                    return;
                }
                file = openDialog.getSelectedFile();
                if (this.reportmain.isSubReport() && file.equals(this.reportmain.getRPTFileName())) {
                    new JMessageDialog((Frame)this.reportmain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You cannot insert the main report as a drilldown to the sub report!"));
                    return;
                }
                this.reportmain.getBrowseDirectories().setReportDrillDownDirectory(openDialog.getCurrentDirectory());
                LoadReport lr = new LoadReport(true);
                lr.loadDataHeaderOnly(file);
                this.dbInfo = lr.getDBInfo();
                if (this.crossTabDrillDown) {
                    int paramCt = 0;
                    if (this.dbInfo != null && this.dbInfo instanceof QueryFileInfo) {
                        paramCt = ((QueryFileInfo)this.dbInfo).getInSet().getParameter().length;
                    }
                    if (lr.getSourceDataType() != 7 && this.dbInfo != null && this.dbInfo instanceof QueryXMLFileInfo) {
                        paramCt = ((QueryXMLFileInfo)this.dbInfo).getInSet().getParameter().length;
                    }
                    if (!(this.dbInfo != null && this.dbInfo instanceof QueryFileInfo && paramCt >= 2 || lr.getSourceDataType() == 6 || lr.getSourceDataType() == 7 && this.dbInfo != null && this.dbInfo instanceof QueryXMLFileInfo && paramCt >= 2)) {
                        throw new Exception(LanguageEncoder.getText("Report template must use a parameterized query with at least 2 parameters."));
                    }
                } else if (!(this.dbInfo != null && this.dbInfo instanceof QueryFileInfo || lr.getSourceDataType() == 6 || lr.getSourceDataType() == 7 && this.dbInfo != null && this.dbInfo instanceof QueryXMLFileInfo)) {
                    throw new Exception(LanguageEncoder.getText("Report template must use a parameterized query."));
                }
                DrillDownColumnMapDialog dDialog = new DrillDownColumnMapDialog(this, this.reportmain.report, ((QueryFileInfo)this.dbInfo).getInSet(), this.crossTabDrillDown);
                dDialog.setVisible(true);
                if (!dDialog.isModified()) {
                    throw new Exception("CANCELED");
                }
                DrillDownNode parentNode = this.reportmain.report.currentNode;
                boolean failed = true;
                String reportName = "";
                String text = LanguageEncoder.getText("Drill-Down Report Name:");
                while (failed) {
                    reportName = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter drill-down report name:"), text, -1);
                    if (reportName != null && !reportName.trim().equals("")) {
                        reportName = reportName.trim();
                        boolean ok = true;
                        for (i = 0; i < parentNode.getChildCount(); ++i) {
                            if (!parentNode.getChildAt(i).getUserObject().equals(reportName)) continue;
                            text = "'" + reportName + LanguageEncoder.getText("' already exists. Please enter another name:");
                            ok = false;
                            i = parentNode.getChildCount();
                        }
                        if (!ok) continue;
                        failed = false;
                        continue;
                    }
                    if (reportName != null) continue;
                    throw new Exception("CANCELED");
                }
                this.drillDownMapping = dDialog.getColInfoIndices();
                QueryInParam[] paramArray = new QueryInParam[this.drillDownMapping.length];
                for (i = 0; i < this.drillDownMapping.length; ++i) {
                    Object value = null;
                    try {
                        ReportTable table = this.reportmain.report.getReportTables().elementAt(0);
                        while (table instanceof ReportTreeTable) {
                            table = ((ReportTreeTable)table).getSubTable(0);
                        }
                        if (this.drillDownMapping[i] >= 0 && this.drillDownMapping[i] < 1000) {
                            value = this.crossTabDrillDown ? (this.reportmain.report.colInfo[this.drillDownMapping[i]].isColumnBreak() ? table.getColumn(this.drillDownMapping[i]).getText() : table.getColumn(this.drillDownMapping[i]).getData(0)) : table.getColumn(this.drillDownMapping[i]).getData(0);
                            if (this.crossTabDrillDown) {
                                ReportTable tbl = this.reportmain.report.getReportTables().elementAt(0);
                                if (this.reportmain.report.colInfo[this.drillDownMapping[i]].isColumnBreak()) {
                                    for (int j = 0; j < tbl.getColumnCount(); ++j) {
                                        if (this.reportmain.report.getColInfoIndex(tbl.getColumn(j)) != this.drillDownMapping[i]) continue;
                                        this.reportmain.report.colInfo[this.drillDownMapping[i]].setDrillDownName(reportName);
                                        tbl.getColumn(j).setDrillDownName(reportName);
                                    }
                                } else {
                                    tbl.getColumn(this.reportmain.report.colInfo[this.drillDownMapping[i]].getMapping()).setDrillDownName(reportName);
                                }
                            } else {
                                this.reportmain.report.getReportTables().elementAt(0).getColumn(this.drillDownMapping[i]).setDrillDownName(reportName);
                            }
                        } else {
                            value = this.drillDownMapping[i] >= 1000 && this.drillDownMapping[i] < 2000 ? this.reportmain.report.getQueryParameters().elementAt(this.drillDownMapping[i] - 1000).getValue() : (this.drillDownMapping[i] >= 2000 ? this.reportmain.report.getFormulaParameters().elementAt(this.drillDownMapping[i] - 2000).getValue() : ((QueryFileInfo)this.dbInfo).getInSet().getParameter()[i].getDefaultValue((QueryFileInfo)this.dbInfo));
                        }
                        this.reportmain.setModified();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayEx) {
                        LOGGER.log(Level.FINEST, "Column is empty", arrayEx);
                    }
                    QueryInParam currParam = ((QueryFileInfo)this.dbInfo).getInSet().getParameter()[i];
                    Object defaultValue = currParam.getDefaultValue((QueryFileInfo)this.dbInfo);
                    value = defaultValue != null ? defaultValue : null;
                    if (currParam instanceof QueryMultiValueInParam) {
                        Vector<Object> vs = new Vector<Object>();
                        vs.addElement(value);
                        paramArray[i] = new QueryMultiValueInParam(currParam.getParamIndexMap(), currParam.getParamName(), currParam.getPromptName(), currParam.isMapToColumn(), currParam.getTableName(), currParam.getColumnName(), currParam.getSqlType(), defaultValue, value, vs);
                        continue;
                    }
                    paramArray[i] = new QueryInParam(currParam.getParamIndexMap(), currParam.getParamName(), currParam.getPromptName(), currParam.isMapToColumn(), currParam.getTableName(), currParam.getColumnName(), currParam.getSqlType(), defaultValue, value);
                }
                QueryInParamSet paramSet = new QueryInParamSet(paramArray);
                Vector<QueryInParamSet> params = new Vector<QueryInParamSet>();
                params.add(paramSet);
                LoadReport loadReport = new LoadReport(true);
                loadReport.setSubFilesTable(this.reportmain.report.getSubFilesTable());
                loadReport.setBackupDataUsed(true);
                loadReport.setRelativeDomainPath(this.reportmain.relativeDomainPath);
                Report report = loadReport.loadReportFromFile(file, params);
                report.resetSourceData();
                String oldFile = this.reportmain.getTitle();
                JTree drillDownTree = this.reportmain.getDrillDownTree();
                DrillDownNode newNode = parentNode.createNewChild(reportName, this.reportmain.getSubFilesTable());
                if (file != null) {
                    newNode.setFileName(file);
                }
                newNode.setColumnMapping(this.drillDownMapping);
                newNode.setCrossTabDrillDown(this.crossTabDrillDown);
                DrillDownNode destDDNode = loadReport.getDrillDownNode();
                this.includeDestDrillDownTree(destDDNode, newNode);
                this.reportmain.setModified();
                this.reportmain.save();
                this.reportmain.close();
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.reportmain.setReport(report);
                this.reportmain.report.currentNode = newNode;
                if (!this.reportmain.report.isRootReport()) {
                    this.reportmain.report.rootNode = newNode.getRoot();
                }
                newNode.setSelected(true);
                if (oldFile != null) {
                    this.reportmain.setFileName(oldFile);
                }
                this.reportmain.setDrillDownTree(drillDownTree);
                if (loadReport.getSubReports() != null) {
                    this.reportmain.setSubReports(loadReport.getSubReports());
                } else {
                    this.reportmain.setSubReports(new Vector<SubReportObject>());
                }
                this.reportmain.menuBar.setMenuForDrillDown();
                this.reportmain.designPanel.designToolBar.setToolbarForDrillDown();
                this.reportmain.setModified();
                this.reportmain.save();
                this.reportmain.close();
                newNode.setSelected(false);
                LoadReport rootLoadReport = new LoadReport(true);
                rootLoadReport.setSubFilesTable(this.reportmain.getSubFilesTable());
                rootLoadReport.setRelativeDomainPath(this.reportmain.relativeDomainPath);
                Report rootReport = rootLoadReport.loadReportFromFile(oldFile);
                this.reportmain.setReport(rootReport);
                this.reportmain.report.currentNode = rootLoadReport.getDrillDownNode();
                this.reportmain.report.rootNode = rootLoadReport.getDrillDownNode().getRoot();
                this.reportmain.setDrillDownTree(new JTree(rootLoadReport.getDrillDownNode()));
                this.reportmain.report.rootNode.setSelected(true);
                if (rootReport.subReports != null) {
                    this.reportmain.setSubReports(rootReport.subReports);
                } else if (!this.reportmain.isSubReport()) {
                    this.reportmain.setSubReports(new Vector<SubReportObject>());
                }
                SaveDialog saveAsDialog = new SaveDialog(this.reportmain);
                saveAsDialog.setSaveAllData(false);
                saveAsDialog.setHTML(false);
                saveAsDialog.setXML(false);
                saveAsDialog.setPAK(this.reportmain.isReportOpenedInPakFormat());
                saveAsDialog.setSwing(false);
                saveAsDialog.setPageViewer(false);
                String rootFileNameNoExt = oldFile;
                if (oldFile != null && (oldFile.toUpperCase().endsWith(".RPT") || oldFile.toUpperCase().endsWith(".XML") || oldFile.toUpperCase().endsWith(".PAK"))) {
                    rootFileNameNoExt = oldFile.substring(0, oldFile.length() - 4);
                }
                this.reportmain.setFileName(oldFile);
                this.reportmain.saveAs(rootFileNameNoExt, saveAsDialog, true);
                DrillDownNode ddnode = this.findDrillDownNode(this.reportmain.report, newNode, true);
                for (int i2 = 0; i2 < this.reportmain.report.currentNode.getChildCount(); ++i2) {
                    DrillDownNode cn = this.reportmain.report.currentNode.getChildAt(i2);
                    if (!cn.getName().equals(newNode.getName())) continue;
                    ddnode = cn;
                }
                if (this.reportmain.drillDownNavigationFrame != null) {
                    this.reportmain.drillDownNavigationFrame.doEdit(ddnode);
                }
                this.setVisible(false);
                this.dispose();
            }
            catch (Exception e) {
                this.setCursor(currentCursor);
                if (!"CANCELED".equals(e.getMessage())) {
                    LOGGER.log(Level.WARNING, "Cannot open report", e);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), e.toString());
                } else {
                    LOGGER.log(Level.FINEST, "Open report: canceled", e);
                }
            }
            finally {
                try {
                    IOUtil.releaseFileLock(file);
                }
                catch (Exception exc) {
                    LOGGER.log(Level.FINEST, "Failed to release file lock", exc);
                }
            }
        }
    }

    private DrillDownNode findDrillDownNode(DrillDownNode node, DrillDownNode target, boolean firstLevel) {
        if (node == null) {
            return null;
        }
        if (node.getName().equals(target.getName())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DrillDownNode n = this.findDrillDownNode(node.getChildAt(i), target, false);
            if (n == null) continue;
            return n;
        }
        if (!firstLevel) {
            try {
                LoadReport lr = new LoadReport(true);
                lr.setSubFilesTable(this.reportmain.getSubFilesTable());
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(this.reportmain.relativeDomainPath);
                Report report = lr.loadReportFromFile(node.getFileName());
                DrillDownNode n = this.findDrillDownNode(report, target, false);
                if (n != null) {
                    return n;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load drill-down report", e);
            }
        }
        return null;
    }

    private DrillDownNode findDrillDownNode(Report report, DrillDownNode target, boolean firstLevel) {
        DrillDownNode n;
        if (report == null) {
            return null;
        }
        if (report.currentNode.getName().equals(target.getName())) {
            return report.currentNode;
        }
        if (firstLevel && (n = this.findDrillDownNode(report.currentNode, target, true)) != null) {
            return n;
        }
        Report[] sros = report.getSubReportArray(true);
        for (int i = 0; sros != null && i < sros.length; ++i) {
            Report subreport = sros[i];
            this.reportmain.setDrillDownTree(new JTree(subreport.currentNode));
            DrillDownNode n2 = this.findDrillDownNode(subreport.currentNode, target, true);
            if (n2 == null) continue;
            return n2;
        }
        return null;
    }

    private void includeDestDrillDownTree(DrillDownNode destDDNode, DrillDownNode newNode) throws Exception {
        if (destDDNode == null) {
            return;
        }
        for (int i = 0; i < destDDNode.getChildCount(); ++i) {
            try {
                DrillDownNode cn = destDDNode.getChildAt(i);
                LoadReport ldestChild = new LoadReport(true);
                ldestChild.setSubFilesTable(this.reportmain.getSubFilesTable());
                ldestChild.setBackupDataUsed(true);
                ldestChild.setRelativeDomainPath(this.reportmain.relativeDomainPath);
                Report destChild = ldestChild.loadReportFromFile(cn.getFileName());
                destChild.resetSourceData();
                DrillDownNode newCn = newNode.createNewChild(cn.getName(), destChild.getSubFilesTable());
                newCn.setColumnMapping(cn.getColumnMapping());
                newCn.setCrossTabDrillDown(cn.isCrossTabDrillDown());
                destChild.rootNode = newNode.getRoot();
                SaveReport sr = new SaveReport(destChild);
                sr.setSubFilesTable(this.reportmain.getSubFilesTable());
                sr.setSubReports(ldestChild.getSubReports());
                sr.saveToFile(newCn.getFileName());
                this.includeDestDrillDownTree(cn, newCn);
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to include destination drill-down tree", ex);
            }
        }
    }

    void doneloading(Report report, String file) {
        this.reportmain.setReport(report);
        if (this.reportmain.hasBean()) {
            this.reportmain.setModified();
        }
        this.reportmain.setFileName(file);
        this.reportmain.do_enable();
        this.reportmain.toFront();
        this.setVisible(false);
    }

    public void newReport() {
        this.newReport(true, true, this.managerPreviousPanel != null ? this.managerPreviousPanel : this.step1);
    }

    public void newReport(boolean showStartupBackButton, boolean showBackButton, JPanel prevPanel) {
        if ((this.isSubReportOp || this.isDrillDownOp) && this.dbProvider != null) {
            int op = 0;
            if (this.isSubReportOp) {
                op = 1;
            }
            ReportEvent event = new ReportEvent(op);
            this.setVisible(false);
            ProviderRunnerThread runner = new ProviderRunnerThread(this.dbProvider, event, this);
            runner.start();
            return;
        }
        if (this.manager == null) {
            if (this.reportmain.isChangeDataRegistryEnabled()) {
                if (this.getPresetDataRegistry() == null) {
                    String errorMsg = LanguageEncoder.getText("There are no available data registries.") + " " + LanguageEncoder.getText("Please create a new registry, or modify user privileges");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), errorMsg);
                    return;
                }
                boolean showChangeButton = true;
                this.manager = new Manager(this, this, showChangeButton, this.reportmain.getChangeDataRegObj(), this.reportmain.canModify());
            } else {
                this.manager = new Manager(this, this, showBackButton, false, showStartupBackButton, null);
            }
        }
        this.manager.setCanModify(this.reportmain.canModify());
        this.manager.setDefaultParamNames(this.reportmain.getDefaultParamNames());
        this.manager.setDataSourceManagerListeners(this.reportmain.getDataSourceManagerListeners());
        this.manager.setDefaultValueRequiredForParameters(this.reportmain.isDefaultValueRequiredForParameters());
        this.managerPreviousPanel = prevPanel;
        if (this.manager.initialize(this.getPresetDataRegistry(), this.fromDesigner(), this.getDataRegistryHiddenNodes())) {
            this.setVisible(false);
            this.manager.setVisible(true);
        } else {
            this.manager.setVisible(false);
            this.manager.dispose();
            this.reportmain.toFront();
        }
    }

    @Override
    public void setPresetDataRegistry(String data) {
        this.reportmain.setPresetDataRegistry(data);
    }

    @Override
    public String getPresetDataRegistry() {
        return this.reportmain.getPresetDataRegistry();
    }

    @Override
    public BrowseDirectories getBrowseDirectories() {
        return this.reportmain.getBrowseDirectories();
    }

    public void setDataRegistryHiddenNodes(Vector<String> vec) {
        this.reportmain.setDataRegistryHiddenNodes(vec);
    }

    public Vector<String> getDataRegistryHiddenNodes() {
        return this.reportmain.getDataRegistryHiddenNodes();
    }

    public void providerHook(ReportEvent event) {
        if (event != null && event.getDBInfo() != null) {
            this.dbInfo = event.getDBInfo();
            try {
                this.colData = this.getData(event.getInSet(), this.reportmain.getDisplayRow());
                if (this.colData == null) {
                    this.cancel();
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to get data", ex);
                this.cancel();
                return;
            }
            this.sourceData = 1;
            JPanel contentPane = (JPanel)this.getContentPane();
            if (this.step1 != null) {
                contentPane.remove(this.step1);
            }
            this.newreportType();
            this.pack();
            this.setPos(false);
            this.setVisible(true);
            return;
        }
        this.cancel();
    }

    @Override
    public void toFront() {
        if (this.isVisible()) {
            super.toFront();
        }
        if (this.manager != null && this.manager.isVisible()) {
            this.manager.toFront();
        }
    }

    void getMultiSource(JPanel prevPanel) {
        if (this.stepMulti == null) {
            this.stepMulti = new WizardStepMultiData(this);
        }
        this.swapPanel(prevPanel, this.stepMulti);
    }

    void displayResult(JPanel removedPanel) {
        this.displayResult(removedPanel, this.reportmain.getPresetManager() == null, this.toChart);
    }

    private void displayResult(JPanel removedPanel, boolean showBack, IDataInterchange toChart) {
        this.step41 = new WizardStep41(this, showBack, toChart, this.reportmain.isInReadOnlyFolder());
        if (removedPanel instanceof WizardStep41) {
            this.step41.previousPanel = (WizardStep41)removedPanel;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        if (this.step1 != null) {
            contentPane.remove(this.step1);
        }
        if (this.reportmain.isSkipQueryResultStep()) {
            this.step41.doOK(removedPanel);
        } else {
            this.swapPanel(removedPanel, this.step41);
        }
    }

    void displayMergeResult(JPanel removedPanel) {
        this.stepMerge41 = new WizardStep41(this);
        if (this.reportmain.isSkipQueryResultStep()) {
            this.stepMerge41.doOK(removedPanel);
        } else {
            this.swapPanel(removedPanel, this.stepMerge41);
        }
    }

    private void newreportType() {
        JPanel newPanel = this.newSelectReport(null);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", newPanel);
        this.pack();
        this.validate();
        this.setPos(false);
    }

    void newreportType(JPanel prevPanel) {
        this.swapPanel(prevPanel, this.newSelectReport(prevPanel));
    }

    private JPanel newSelectReport(JPanel prevPanel) {
        if (this.selectFormat == null) {
            this.selectFormat = new SelectReportFormat(this, prevPanel);
        }
        return this.selectFormat;
    }

    void getStep3(JPanel removedPanel) {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.remove(removedPanel);
        this.setVisible(false);
        this.manager.managerPane.updateDataSource(this.dataSourceLoc, false);
        this.manager.setVisible(true);
        this.manager.toFront();
        if (this.dbSourceType == Manager.DATAVIEW && this.dbFileBytes != null && this.dbFileBytes.length == 2) {
            this.manager.openDataViewQuery();
        }
    }

    void getStep3(JPanel removedPanel, JPanel addedPanel) {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.remove(removedPanel);
        this.setVisible(false);
        if (addedPanel != null) {
            contentPane.add("Center", addedPanel);
        }
        this.pack();
        this.validate();
        this.setPos(false);
        this.manager.managerPane.updateDataSource(this.dataSourceLoc, false);
        this.manager.setVisible(true);
    }

    void doMultiDataBack(JPanel oldPanel, JPanel newPanel) {
        if (this.reportmain.isSkipQueryResultStep()) {
            this.getStep3(oldPanel);
        } else {
            this.swapPanel(oldPanel, newPanel);
        }
    }

    void doReportTypeBack(JPanel oldPanel, JPanel newPanel) {
        if (this.reportmain.isSkipQueryResultStep()) {
            this.getStep3(oldPanel);
        } else {
            this.swapPanel(oldPanel, newPanel);
        }
    }

    void swapPanel(JPanel oldPanel, JPanel newPanel) {
        JPanel contentPane = (JPanel)this.getContentPane();
        if (oldPanel != null) {
            contentPane.remove(oldPanel);
        }
        if (oldPanel == this.managerPreviousPanel) {
            this.managerPreviousPanel = null;
        }
        contentPane.add("Center", newPanel);
        this.pack();
        this.validate();
        this.setPos(newPanel instanceof ColInfoMappingPanel);
        this.setVisible(true);
    }

    Report createReport(int reportStyle) throws Exception {
        boolean sorteddata = false;
        if (this.applyFormula && this.report != null) {
            this.colInfo = Report.addFormulaColumn(this.colInfo, this.report.colInfo);
        }
        try {
            if (this.sourceData == 1 && (this.reportType == 1 || this.reportType == 2 || this.reportType == 3)) {
                if (this.keepDataSourceOrder || this.isTransposed) {
                    Vector<QueryInParamSet> params = null;
                    if (this.dbInfo instanceof QueryFileInfo) {
                        params = QueryFileInfo.getParameter((QueryFileInfo)this.dbInfo, false);
                    }
                    if (this.reportmain.useLiveData) {
                        this.colData = DBAccess.retrieveResult(params, this.dbInfo, true, this.isTransposed, this.transposeCol, null, null, false);
                    }
                } else {
                    String sqlstr = this.dbInfo.getQuery();
                    sqlstr = TransformQuery.transform(sqlstr, this.colInfo);
                    DBInfoBasic tempdbInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), sqlstr, this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), sqlstr, this.dbInfo.getAdditionalDb());
                    Vector<QueryInParamSet> params = null;
                    if (this.dbInfo instanceof QueryFileInfo) {
                        tempdbInfo = new QueryFileInfo("", 0, tempdbInfo, ((QueryFileInfo)this.dbInfo).getInSet());
                        QueryFileInfo.setParentFrame(this.reportmain);
                        params = QueryFileInfo.getParameter((QueryFileInfo)this.dbInfo, false);
                    }
                    if (this.reportmain.useLiveData) {
                        try {
                            this.colData = this.reportType == 1 ? DBAccess.retrieveResult(params, tempdbInfo, true, false, null, null, null, 0, this.reportmain.getDisplayRow(), false) : DBAccess.retrieveResult(params, tempdbInfo, true, false, null, null, null, false);
                            sorteddata = true;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.WARNING, "Failed to retrieve live data", ex);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot get data from database", e);
        }
        Report report = new Report(this.colData);
        report.reportStyle = reportStyle;
        report.colDataSorted = sorteddata;
        if (this.reportType == 3 && this.sideBySide) {
            report.setSideBySideLayout(true);
        }
        if (this.reportType == 2 && !this.showRowAggregationGrandTotal) {
            report.setShowRowAggregationGrandTotal(false);
        }
        report.setReOrderColumns(this.reportType == 2 && this.reOrderColumns);
        report.crossTabFreeForm = this.reportType == 2 && this.crossTabFreeForm;
        report.setShowRowAggregationSubtotal(this.reportType == 2 && this.showRowAggregationSubtotal);
        report.setRowAggregationSubtotalOnLeft(this.reportType == 2 && this.rowAggregationSubtotalOnLeft);
        report.setRowAggregationGrandTotalOnLeft(this.reportType == 2 && this.rowAggregationGrandTotalOnLeft);
        report.setColumnAggregationInHeader(this.reportType == 2 && !this.columnAggregationInFooter && this.showColumnAggregation);
        report.setShowColumnAggregation(this.reportType == 2 && this.showColumnAggregation);
        report.setAlignCrossTabColBkValHori(this.reportType == 2 && this.alignCrossTabColBkValHori);
        report.createTable(this.reportType, this.colInfo, true, true);
        report.setTopN(this.topN);
        report.setAscending(this.ascending);
        report.setSnapToGrid(report.snapToGrid, report.gridStepSize, report.cmGridStepSize);
        report.allowPreviewEdit = this.allowPreviewEdit;
        report.registryID = this.registryID;
        report.dataSourceID = this.dataSourceID;
        report.dataSourceLoc = this.dataSourceLoc;
        report.subReports = this.subReports;
        report.setSubFilesTable(this.reportmain.getSubFilesTable());
        return report;
    }

    boolean redoReport() {
        if (!this.applyTemplate) {
            return true;
        }
        return this.report.getReportType() != this.reportType;
    }

    Report reUseReport() {
        this.applyTemplate = false;
        this.report.setTopN(this.topN);
        this.report.setAscending(this.ascending);
        this.report.setKeepDataSourceOrder(this.keepDataSourceOrder);
        this.report.setSnapToGrid(this.report.snapToGrid, this.report.gridStepSize, this.report.cmGridStepSize);
        this.report.allowPreviewEdit = this.allowPreviewEdit;
        this.report.registryID = this.registryID;
        this.report.dataSourceID = this.dataSourceID;
        this.report.dataSourceLoc = this.dataSourceLoc;
        this.report.subReports = this.subReports;
        return this.report;
    }

    void setApplyTemplate(boolean b) {
        this.applyTemplate = b;
    }

    void setApplyFormula(boolean b) {
        this.applyFormula = b;
    }

    void doneWizard(Report report) {
        this.doneWizard(report, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doneWizard(Report report, boolean autoFitColumns) {
        DrillDownNode newNode = null;
        report.registryID = this.registryID;
        report.dataSourceID = this.dataSourceID;
        report.dataSourceLoc = this.dataSourceLoc;
        report.subReports = this.subReports;
        report.sourceData = this.sourceData;
        report.setTransposed(this.isTransposed, this.transposeCol);
        report.setKeepDataSourceOrder(this.keepDataSourceOrder);
        if (this.sourceData == 1) {
            report.dbInfo = this.dbInfo;
            report.setDBSourceType(this.dbSourceType);
            report.setQueryFileBytes(this.dbFileBytes);
        } else if (this.sourceData == 3) {
            report.sourceList = new Object[this.sourceInfo.size()];
            report.sourceType = new int[this.sourceInfo.size()];
            report.doTranspose = new boolean[this.sourceInfo.size()];
            report.transposeColList = new Object[this.sourceInfo.size()];
            for (int i = 0; i < this.sourceInfo.size(); ++i) {
                report.sourceList[i] = this.sourceInfo.elementAt(i);
                report.sourceType[i] = this.sourceType.elementAt(i);
                report.doTranspose[i] = this.doTranspose.elementAt(i);
                report.transposeColList[i] = this.transposeColList.elementAt(i);
            }
        } else if (this.sourceData == 5) {
            report.jndiName = this.jndiName;
            report.homeName = this.homeName;
            report.remoteName = this.remoteName;
            report.selectedMethodName = this.selectedMethodName;
            report.selectedMethodParamVal = this.selectedMethodParamVal;
            report.environment = this.environment;
        } else if (this.sourceData == 7) {
            report.sourceFile = this.sourceFile;
            report.setXMLFileQueryInfo(this.xmlFileQueryInfo);
            report.dbInfo = this.dbInfo;
        } else if (this.sourceData == 12) {
            report.soapInfo = this.soapInfo;
            report.dbInfo = this.dbInfo;
        } else if (this.sourceData == 11) {
            report.sfQueryInfo = this.sfQueryInfo;
            report.dbInfo = this.dbInfo;
        } else if (this.sourceData == 13) {
            report.excelInfo = this.excelInfo;
        } else {
            report.sourceFile = this.sourceFile;
            report.dbInfo = this.dbInfo;
        }
        String oldFile = null;
        Container drillDownTree = null;
        if (this.isDrillDownOp) {
            DrillDownNode parentNode = this.reportmain.report.currentNode;
            if (parentNode.getFileName().equals("")) {
                parentNode.setFileName(this.reportmain.getFileName());
            }
            boolean failed = true;
            String reportName = "";
            String text = LanguageEncoder.getText("Drill-Down Report Name:");
            while (failed) {
                reportName = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter drill-down report name:"), text, -1);
                if (reportName != null && !reportName.trim().equals("")) {
                    reportName = reportName.trim();
                    boolean ok = true;
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        if (!parentNode.getChildAt(i).getUserObject().equals(reportName)) continue;
                        text = "'" + reportName + LanguageEncoder.getText("' already exists. Please enter another name:");
                        ok = false;
                        i = parentNode.getChildCount();
                    }
                    if (!ok) continue;
                    failed = false;
                    continue;
                }
                if (reportName != null) continue;
                this.isCancelled = true;
                return;
            }
            for (int element : this.drillDownMapping) {
                if (element < 0) continue;
                try {
                    if (this.crossTabDrillDown) {
                        ReportTable tbl = this.reportmain.report.getReportTables().elementAt(0);
                        if (this.reportmain.report.colInfo[element].isColumnBreak()) {
                            for (int j = 0; j < tbl.getColumnCount(); ++j) {
                                if (this.reportmain.report.getColInfoIndex(tbl.getColumn(j)) != element) continue;
                                tbl.getColumn(j).setDrillDownName(reportName);
                                this.reportmain.report.colInfo[element].setDrillDownName(reportName);
                            }
                        }
                    } else if (element < 1000) {
                        this.reportmain.report.getReportTables().elementAt(0).getColumn(element).setDrillDownName(reportName);
                    }
                    this.reportmain.setModified();
                }
                catch (ArrayIndexOutOfBoundsException arrayEx) {
                    LOGGER.log(Level.FINEST, "Failed to set column drill-down links", arrayEx);
                }
            }
            try {
                newNode = parentNode.createNewChild(reportName, this.reportmain.report.getSubFilesTable());
                parentNode.setSelected(false);
                newNode.setColumnMapping(this.drillDownMapping);
                newNode.setCrossTabDrillDown(this.crossTabDrillDown);
                ((DefaultTreeModel)this.reportmain.getDrillDownTree().getModel()).insertNodeInto(newNode, (MutableTreeNode)newNode.getParent(), newNode.getParent().getChildCount() - 1);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Cannot create drill-down report", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to create drill-down report.\n") + LanguageEncoder.getText("Please open the root report and try again."));
                return;
            }
            try {
                oldFile = this.reportmain.getFileName();
                drillDownTree = this.reportmain.getDrillDownTree();
                report.currentNode = newNode;
                report.rootNode = this.reportmain.report.rootNode == null ? this.reportmain.report.currentNode : this.reportmain.report.rootNode;
                SaveReport saveReport = new SaveReport(report);
                saveReport.setSubFilesTable(this.reportmain.getSubFilesTable());
                if (!this.reportmain.isReportOpenedInPakFormat() && this.reportmain.isModified()) {
                    saveReport.saveToFile(newNode.getFileName());
                    this.reportmain.save(this.reportmain.getRPTFileName());
                    this.reportmain.close();
                } else {
                    saveReport.saveFileToMemory(newNode.getFileName());
                    saveReport = new SaveReport(this.reportmain.report);
                    saveReport.generatePAKFile(true);
                    saveReport.setSubFilesTable(this.reportmain.getSubFilesTable());
                    saveReport.setSubReports(this.reportmain.report.subReports);
                    if (this.reportmain.report.isRootReport()) {
                        saveReport.setDrillDownNode(this.reportmain.report.currentNode);
                    }
                    saveReport.saveFileToMemory(this.reportmain.report.currentNode.getFileName());
                }
                newNode.setSelected(true);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Cannot close parent report", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to close parent report.\n") + LanguageEncoder.getText("Please make sure parent report is saved."));
                return;
            }
        }
        if (this.isRedoDataMappingOp) {
            int k;
            Vector<Boolean> temp = new Vector<Boolean>();
            for (int j = 0; j < Array.getLength(report.colInfo); ++j) {
                boolean b = report.colInfo[j].isVisible();
                temp.addElement(b);
            }
            boolean[] isVisible = new boolean[temp.size()];
            for (k = 0; k < temp.size(); ++k) {
                isVisible[k] = (Boolean)temp.elementAt(k);
            }
            if (this.applyTemplate) {
                if (report.isCrossTabFixedField() && this.reportmain.report.isCrossTabFixedField()) {
                    report.applyFixedFieldStyle(this.reportmain.report, false, this.applyFormula, true);
                } else {
                    report.applyReport(this.reportmain.report, false, this.applyFormula, true);
                }
                if (this.isTopNReport()) {
                    report.setTopN(this.topN);
                    report.setAscending(this.ascending);
                }
            }
            report.setReOrderColumns(this.reOrderColumns);
            report.setShowRowAggregationGrandTotal(this.showRowAggregationGrandTotal);
            report.crossTabFreeForm = this.crossTabFreeForm;
            report.setShowRowAggregationSubtotal(this.showRowAggregationSubtotal);
            report.setRowAggregationSubtotalOnLeft(this.rowAggregationSubtotalOnLeft);
            report.setRowAggregationGrandTotalOnLeft(this.rowAggregationGrandTotalOnLeft);
            report.setColumnAggregationInHeader(!this.columnAggregationInFooter);
            report.setShowColumnAggregation(this.showColumnAggregation);
            report.setAlignCrossTabColBkValHori(this.alignCrossTabColBkValHori);
            for (k = 0; k < Array.getLength(isVisible); ++k) {
                report.colInfo[k].setVisible(isVisible[k]);
            }
            if (report.getReportType() == 4) {
                for (int i = 0; i < report.getReportTables().size(); ++i) {
                    ReportTable tbl = report.getReportTables().elementAt(i);
                    tbl.getHeader().setVisible(false);
                    tbl.getFooter().setVisible(false);
                }
            }
            newNode = this.reportmain.report.currentNode;
            report.parentNode = this.reportmain.report.parentNode;
            if (!this.applyTemplate) {
                this.reportmain.designPanel.rulerPanel.xRuler.xgl = null;
                this.reportmain.designPanel.rulerPanel.yRuler.ygl = null;
                this.reportmain.designPanel.rulerPanel.xRuler.repaint();
                this.reportmain.designPanel.rulerPanel.yRuler.repaint();
            }
            report.setQueryParameters(this.queryParameters);
        } else {
            if (this.isSubReportOp) {
                this.doneWizardSubReport(report);
                return;
            }
            this.reportmain.setFileName(null);
        }
        if (report.getReportType() != 2) {
            ReportColumn[] column = report.getReportTables().elementAt(0).getColumn();
            for (int i = 0; i < Array.getLength(report.colInfo); ++i) {
                column[i].setVisible(report.colInfo[i].isVisible());
            }
        }
        Cursor currentCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.reportmain.setReport(report);
            if (newNode == null) {
                newNode = new DrillDownNode("ROOT");
                newNode.setDomainPath(this.reportmain.relativeDomainPath);
                this.reportmain.setDrillDownTree(new JTree(newNode));
                this.reportmain.setSubReports(new Vector<SubReportObject>());
            }
            this.reportmain.report.currentNode = newNode;
            if (!this.reportmain.report.isRootReport()) {
                this.reportmain.report.rootNode = newNode.getRoot();
                this.reportmain.report.rootNode.setSelected(false);
            }
            if (drillDownTree != null) {
                drillDownTree.validate();
                drillDownTree.repaint();
            }
            newNode.setSelected(true);
            if (this.isDrillDownOp) {
                if (oldFile != null) {
                    this.reportmain.setFileName(oldFile);
                }
                this.reportmain.setDrillDownTree((JTree)drillDownTree);
                this.reportmain.setSubReports(new Vector<SubReportObject>());
                this.reportmain.menuBar.setMenuForDrillDown();
                this.reportmain.designPanel.designToolBar.setToolbarForDrillDown();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Operation failed", ex);
        }
        finally {
            this.setCursor(currentCursor);
        }
        boolean showOutline = this.reportmain.report.showCellOutline;
        boolean showFormulaName = this.reportmain.report.showFormulaNameSelected;
        this.reportmain.menuBar.showCellOutline.setSelected(showOutline);
        this.reportmain.menuBar.formulaName.setSelected(showFormulaName);
        this.reportmain.menuBar.prevParamPrompt.setSelected(this.reportmain.report.isPrevParamPrompt);
        this.reportmain.menuBar.setUndoEnabled(false);
        this.reportmain.setModified();
        this.reportmain.do_enable();
        this.reportmain.toFront();
        if (this.isDrillDownOp) {
            this.reportmain.save();
        }
        if (this.manager != null) {
            this.manager.setVisible(false);
            this.manager.dispose();
            this.manager = null;
        }
        this.setVisible(false);
        this.dispose();
        if (autoFitColumns) {
            this.reportmain.autoFitColumns();
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean gotError() {
        return this.gotError;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        if (this.isSubReportOp) {
            try {
                if (this.reportmain.selectedObject != null && this.reportmain.selectedObject instanceof SubReportObject && (this.reportmain.selectedObject.getText() == null || this.reportmain.selectedObject.getText().equals("") || !this.reportmain.fileExists(this.reportmain.selectedObject.getText()))) {
                    this.reportmain.deleteElt();
                } else {
                    this.subReportOpSelectedPanel.select(this.subReportOpSelectedObject, false);
                    this.reportmain.deleteElt();
                }
                this.reportmain.setInsertSubReport(false);
                this.reportmain.menuBar.setUndoEnabled(false);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to remove sub-report cell from report", ex);
            }
        }
        this.setVisible(false);
        this.dispose();
        if (this.exitOnCancel) {
            try {
                this.reportmain.softExit();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Exit failed", ex);
                this.reportmain.setVisible(false);
                this.reportmain.dispose();
            }
            return;
        }
    }

    public boolean redoColInfo(ColInfo[] newColInfo) {
        Vector<ColInfo> availColInfo = new Vector<ColInfo>();
        for (ColInfo element : this.report.colInfo) {
            if (element.getMapping() < 0) continue;
            availColInfo.addElement(element);
        }
        if (!this.applyFormula && availColInfo.size() != newColInfo.length) {
            return true;
        }
        Boolean[] availColInfoRPT = new Boolean[availColInfo.size()];
        for (ColInfo element : newColInfo) {
            boolean foundIt = false;
            for (int j = 0; j < availColInfo.size(); ++j) {
                ColInfo tmpColInfo = (ColInfo)availColInfo.elementAt(j);
                if (!element.equals(tmpColInfo, false)) continue;
                availColInfoRPT[j] = element.isRepeatBreakField();
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            return true;
        }
        for (int j = 0; j < availColInfo.size(); ++j) {
            ColInfo tmpColInfo = (ColInfo)availColInfo.elementAt(j);
            if (availColInfoRPT[j] != null) {
                tmpColInfo.setRepeatBreakField(availColInfoRPT[j]);
            }
            tmpColInfo.setTopN(newColInfo[j].isTopN());
        }
        return false;
    }

    @Override
    public void next() {
        this.next(false, false, null, null);
    }

    @Override
    public void next(boolean fromCreateReportChart, boolean isTransposed, boolean[] transposeCol, JPanel previousPanel) {
        this.sourceData = this.manager.getSourceData();
        DefaultMutableTreeNode node = this.manager.getSelectedNode();
        if (node instanceof DefaultDataSourceNode) {
            this.dataSourceID = node instanceof DataViewNode ? this.manager.getLastID() : ((DefaultDataSourceNode)node).getID();
        }
        this.registryID = this.manager.getRegistryID();
        this.dataSourceLoc = this.manager.managerPane.dataSourceLoc;
        quadbase.reportdesigner.report.ColData[] colData2 = null;
        String tmp = this.manager.getTitle();
        this.manager.setTitle(Manager.WAIT_TITLE);
        this.manager.setCursor(Cursor.getPredefinedCursor(3));
        if (this.sourceData == 2 || this.sourceData == 4 || this.sourceData == 6 || this.sourceData == 7) {
            String loc = this.manager.getFileName();
            if (this.sourceData == 6 && ClassFileUtil.isParameterized(loc)) {
                try {
                    QueryClassFileInfo classInfo = new QueryClassFileInfo(loc);
                    Vector<QueryInParamSet> paramV = null;
                    if (this.isDrillDownOp) {
                        QueryInParamSet tempParamSet = classInfo.getInSet();
                        this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.reportmain.report, tempParamSet);
                        paramV = new Vector();
                        paramV.addElement(tempParamSet);
                    } else {
                        QueryFileInfo.setParentDialog(this.manager);
                        paramV = QueryFileInfo.getParameter(classInfo, true);
                    }
                    if (paramV == null) {
                        throw new Exception("CANCELED");
                    }
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, 0, this.reportType == 2 ? -1 : this.reportmain.getDisplayRow(), paramV.elementAt(0));
                    this.colData = colData2;
                    this.dbInfo = classInfo;
                }
                catch (Exception ex) {
                    if (!"CANCELED".equals(ex.getMessage())) {
                        LOGGER.log(Level.FINE, "An error occured with the parameterized class file data source", ex);
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "An error occured with the parameterized class file data source.\n" + ex.getMessage());
                    } else {
                        LOGGER.log(Level.FINEST, "Use parameterized class file: cancelled", ex);
                    }
                    this.backToDataSourceManager(tmp);
                    return;
                }
            }
            if (this.sourceData == 7) {
                XMLFileQueryInfo xmlInfo = this.manager.getXMLFileQueryInfo();
                if (QueryParser.hasParameters(xmlInfo.getCondition())) {
                    try {
                        QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(xmlInfo);
                        Vector<QueryInParamSet> paramV = null;
                        if (this.isDrillDownOp) {
                            QueryInParamSet tempParamSet = xmlFileInfo.getInSet();
                            this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.reportmain.report, tempParamSet);
                            paramV = new Vector();
                            paramV.addElement(tempParamSet);
                        } else {
                            QueryFileInfo.setParentDialog(this.manager);
                            paramV = QueryFileInfo.getParameter(xmlFileInfo, true);
                        }
                        if (paramV == null) {
                            throw new Exception("CANCELED");
                        }
                        colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, 0, -1, xmlInfo, this.sourceData);
                        this.colData = colData2;
                        this.dbInfo = xmlFileInfo;
                    }
                    catch (Exception ex) {
                        if (!"CANCELED".equals(ex.getMessage())) {
                            LOGGER.log(Level.FINE, "An error occured with the parameterized class file data source", ex);
                            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "An error occured with the parameterized class file data source.\n" + ex.getMessage());
                        } else {
                            LOGGER.log(Level.FINEST, "Using parameterized class file: canceled", ex);
                        }
                        this.backToDataSourceManager(tmp);
                        return;
                    }
                }
                try {
                    if (this.isDrillDownOp) {
                        throw new Exception(LanguageEncoder.getText("Drill-down reports require a database query."));
                    }
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, 0, -1, xmlInfo, this.sourceData);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "This is not a supported file format", ex);
                    String message = "This is not a supported file format!";
                    this.gotError = true;
                    message = message + "\n" + ex.getMessage();
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), message);
                    this.backToDataSourceManager(tmp);
                    return;
                }
                this.colData = colData2;
                this.dbInfo = null;
                this.xmlFileQueryInfo = xmlInfo;
            } else {
                try {
                    if (this.isDrillDownOp) {
                        throw new Exception(LanguageEncoder.getText("Drill-down reports require a database query."));
                    }
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, 0, -1, null, this.sourceData);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "This is not a supported file format", ex);
                    String message = "This is not a supported file format!";
                    this.gotError = true;
                    message = message + "\n" + ex.getMessage();
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), message);
                    this.backToDataSourceManager(tmp);
                    return;
                }
                this.colData = colData2;
                this.dbInfo = null;
            }
            this.sourceFile = loc;
        } else if (this.sourceData == 13) {
            this.excelInfo = this.manager.getExcelFileInfo();
            try {
                if (this.isDrillDownOp) {
                    throw new Exception(LanguageEncoder.getText("Drill-down reports require a database query."));
                }
                colData2 = ExcelAccess.getColData(this.excelInfo);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to get excel column data", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 5) {
            this.jndiName = this.manager.getJNDIName();
            this.homeName = this.manager.getHomeName();
            this.remoteName = this.manager.getRemoteName();
            this.selectedMethodName = this.manager.getMethodName();
            this.selectedMethodParamVal = this.manager.getParam();
            this.environment = this.manager.getEnvironment();
            if (this.selectedMethodName == null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "You didn't specify the method name for this EJB component.");
                this.backToDataSourceManager(tmp);
                return;
            }
            try {
                if (this.isDrillDownOp) {
                    throw new Exception(LanguageEncoder.getText("Drill-down reports require a database query."));
                }
                colData2 = EJBAccess.retrieveResult(this.jndiName, this.homeName, this.remoteName, this.selectedMethodName, this.selectedMethodParamVal, this.environment);
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 12) {
            QueryInParamSet inSet;
            String err_msg;
            block109: {
                this.soapInfo = this.manager.getSOAPQueryFileInfo();
                if (this.soapInfo.isParameterized()) {
                    this.dbInfo = this.soapInfo;
                }
                err_msg = "";
                if (this.isDrillDownOp && !this.soapInfo.isParameterized()) {
                    err_msg = LanguageEncoder.getText("Query must be parameterized for drill down reports.");
                }
                try {
                    if (!this.soapInfo.isParameterized()) {
                        this.sqlParams = null;
                    } else if (this.isDrillDownOp) {
                        try {
                            QueryInParamSet tempParamSet = this.soapInfo.getInSet();
                            this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.reportmain.report, tempParamSet);
                            this.sqlParams = new Vector();
                            this.sqlParams.add(tempParamSet);
                            this.soapInfo.setInSet(tempParamSet);
                        }
                        catch (Exception excep) {
                            if (excep.getMessage().equals("CANCELED")) {
                                LOGGER.log(Level.FINEST, "Parameter mapping: canceled", excep);
                                throw excep;
                            }
                            LOGGER.log(Level.FINE, "An error occured while mapping to an existing column", excep);
                            err_msg = LanguageEncoder.getText("An error occured while mapping to an existing column.\n") + excep.toString();
                        }
                    } else {
                        if (this.colDataList.size() > 0) {
                            err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                            throw new Exception();
                        }
                        SOAPQueryFileInfo.setParentDialog(this.manager);
                        this.sqlParams = SOAPQueryFileInfo.getParameter(this.soapInfo, true);
                        if (this.sqlParams == null) {
                            throw new Exception("CANCELED");
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to get parameter values", ex);
                    this.sqlParams = null;
                    if (ex.getMessage() == null || !ex.getMessage().equals("CANCELED")) break block109;
                    err_msg = ex.getMessage();
                }
            }
            if (this.sqlParams != null && (inSet = this.sqlParams.elementAt(0)) != null) {
                QueryInParam[] inParam;
                for (QueryInParam element : inParam = inSet.getParameter()) {
                    if (element instanceof QueryMultiValueInParam) {
                        if (((QueryMultiValueInParam)element).getValues() != null) continue;
                        err_msg = "Invalid parameter values for parameter \"" + element.getParamName() + "\"";
                        continue;
                    }
                    if (element.getValue() != null) continue;
                    err_msg = "Invalid parameter values for parameter \"" + element.getParamName() + "\"";
                }
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = quadbase.reportdesigner.report.SOAPAccess.retrieveResult(this.soapInfo);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result from SOAP service.\n") + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    LOGGER.log(Level.FINE, "Error retrieving results: " + err_msg, ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
                } else {
                    LOGGER.log(Level.FINEST, "Retrieve SOAP results: canceled", ex);
                }
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 11) {
            QueryInParamSet inSet;
            this.sfQueryInfo = this.manager.getSalesForceQueryInfo();
            if (this.sfQueryInfo.isParameterized()) {
                this.dbInfo = this.sfQueryInfo;
            }
            String err_msg = "";
            if (this.isDrillDownOp && !this.sfQueryInfo.isParameterized()) {
                err_msg = LanguageEncoder.getText("Query must be parameterized for drill down reports.");
            }
            try {
                if (!this.sfQueryInfo.isParameterized()) {
                    this.sqlParams = null;
                } else if (this.isDrillDownOp) {
                    try {
                        QueryInParamSet tempParamSet = this.manager.getInSet();
                        this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.reportmain.report, tempParamSet);
                        this.sqlParams = new Vector();
                        this.sqlParams.add(tempParamSet);
                        this.sfQueryInfo.setInSet(tempParamSet);
                    }
                    catch (Exception excep) {
                        if (excep.getMessage().equals("CANCELED")) {
                            LOGGER.log(Level.FINEST, "Mapping: canceled", excep);
                            throw excep;
                        }
                        LOGGER.log(Level.FINE, "An error occured while mapping to an existing column", excep);
                        err_msg = LanguageEncoder.getText("An error occured while mapping to an existing column.\n") + excep.toString();
                    }
                } else {
                    if (this.colDataList.size() > 0) {
                        err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    SalesForceQueryFileInfo.setParentDialog(this.manager);
                    this.sqlParams = QueryFileInfo.getParameter(this.sfQueryInfo, true);
                    if (this.sqlParams == null) {
                        throw new Exception("CANCELED");
                    }
                }
            }
            catch (Exception ex) {
                this.sqlParams = null;
                if (ex.getMessage() != null && ex.getMessage().equals("CANCELED")) {
                    LOGGER.log(Level.FINEST, "Canceled getting param values", ex);
                    err_msg = ex.getMessage();
                }
                LOGGER.log(Level.FINE, "Cannot get parameter values", ex);
            }
            if (this.sqlParams != null && (inSet = this.sqlParams.elementAt(0)) != null) {
                QueryInParam[] inParam;
                for (QueryInParam element : inParam = inSet.getParameter()) {
                    if (element instanceof QueryMultiValueInParam) {
                        if (((QueryMultiValueInParam)element).getValues() != null) continue;
                        err_msg = "Invalid parameter values for parameter \"" + element.getParamName() + "\"";
                        continue;
                    }
                    if (element.getValue() != null) continue;
                    err_msg = "Invalid parameter values for parameter \"" + element.getParamName() + "\"";
                }
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = this.reportType == 2 ? quadbase.reportdesigner.report.SalesForceAccess.getColData(this.sfQueryInfo) : quadbase.reportdesigner.report.SalesForceAccess.getColData(this.sfQueryInfo, 0, 20);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result from SalesForce.\n") + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    LOGGER.log(Level.FINE, "Cannot retrieve data from SalesForce", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
                } else {
                    LOGGER.log(Level.FINEST, "Retrieving data from SalesForce: canceled", ex);
                }
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 1) {
            this.dbSourceType = this.manager.getDBSourceType();
            this.dbFileBytes = this.manager.getFileBytes();
            String query = this.manager.getSQL();
            this.dbInfo = this.manager.isUseJNDIDataSource() ? new DBInfoBasic(this.manager.getLookupName(), query, this.manager.getEnvProperties()) : new DBInfoBasic(this.manager.getURL(), this.manager.getDriver(), this.manager.getUserName(), this.manager.getPassword(), query, this.manager.getAdditionalDb());
            String err_msg = "";
            if (this.isDrillDownOp && !QueryParser.hasParameters(query)) {
                err_msg = LanguageEncoder.getText("Query must be parameterized for drill down reports.");
            }
            try {
                if (!QueryParser.hasParameters(query)) {
                    this.sqlParams = null;
                } else if (this.isDrillDownOp) {
                    try {
                        int paramCt;
                        QueryInParamSet tempParamSet = this.manager.getInSet();
                        if (this.crossTabDrillDown && (paramCt = tempParamSet.getParameter().length) < 2) {
                            throw new Exception(LanguageEncoder.getText("Report template must use a parameterized query with at least 2 parameters."));
                        }
                        this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.reportmain.report, tempParamSet);
                        this.sqlParams = new Vector();
                        this.sqlParams.add(tempParamSet);
                        this.dbInfo = new QueryFileInfo("", 0, this.dbInfo, tempParamSet);
                    }
                    catch (Exception excep) {
                        if (excep.getMessage().equals("CANCELED")) {
                            LOGGER.log(Level.FINEST, "Mapping: canceled", excep);
                            throw excep;
                        }
                        LOGGER.log(Level.FINE, "An error occured while mapping to an existing column", excep);
                        err_msg = LanguageEncoder.getText("An error occured while mapping to an existing column.\n") + excep.toString();
                    }
                } else {
                    QueryInParam[] paramarray;
                    if (this.colDataList.size() > 0) {
                        err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    for (QueryInParam element : paramarray = this.manager.getInSet().getParameter()) {
                        if (element instanceof QueryMultiValueInParam) continue;
                        element.setValue(null);
                    }
                    QueryFileInfo qfInfo = new QueryFileInfo("", 0, this.dbInfo, new QueryInParamSet(this.manager.getInSet().getParameter(), this.manager.getInSet().getParameterInPromptSequence()));
                    QueryFileInfo.setParentDialog(this.manager);
                    this.sqlParams = QueryFileInfo.getParameter(qfInfo, true);
                    if (this.sqlParams == null) {
                        throw new Exception("CANCELED");
                    }
                    this.dbInfo = qfInfo;
                }
            }
            catch (Exception ex) {
                this.sqlParams = null;
                if (ex.getMessage() != null && ex.getMessage().equals("CANCELED")) {
                    LOGGER.log(Level.FINEST, "Getting parameter values: canceled", ex);
                    err_msg = ex.getMessage();
                }
                LOGGER.log(Level.FINE, "Error getting parameter values", ex);
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = this.reportType == 2 ? DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, isTransposed, transposeCol, null, null, false) : DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, isTransposed, transposeCol, null, null, 0, 20, false);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    LOGGER.log(Level.FINE, "Error retrieving data from database", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
                } else {
                    LOGGER.log(Level.FINEST, "Retrieving data from database: canceled", ex);
                }
                this.gotError = true;
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        }
        this.manager.setCursor(Cursor.getDefaultCursor());
        this.manager.setTitle(tmp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ReportWizard.this.manager.setVisible(false);
                ReportWizard.this.manager.dispose();
            }
        });
        this.displayResult(this.managerPreviousPanel);
    }

    private void backToDataSourceManager(String tmp) {
        this.manager.setCursor(Cursor.getDefaultCursor());
        this.manager.setTitle(tmp);
        this.manager.toFront();
    }

    public void formatReport(int style) {
        this.formatReport(style, false);
    }

    public void formatReport(int style, boolean changingStyle) {
        ReportStyle reportStyle = null;
        switch (style) {
            case -1: {
                reportStyle = new DefaultReportStyle();
                break;
            }
            case 0: {
                reportStyle = new ReportStyle1();
                break;
            }
            case 1: {
                reportStyle = new ReportStyle2();
                break;
            }
            case 2: {
                reportStyle = new ReportStyle3();
                break;
            }
            case 3: {
                reportStyle = new ReportStyle4();
                break;
            }
            case 4: {
                reportStyle = new ReportStyle5();
            }
        }
        if (reportStyle != null) {
            ((ReportStyle)reportStyle).applyFormat(this.reportmain, changingStyle);
        }
    }

    public void formatReport(String styleFile) {
        try {
            LoadReportStyle lrs = new LoadReportStyle();
            Report reportStyle = lrs.loadReportFromFile(styleFile);
            ImportGlobalFormat import_global_format = new ImportGlobalFormat(this.reportmain);
            import_global_format.applyGlobalFormat(reportStyle.getSetting());
            this.reportmain.report.applyStyle(reportStyle);
            this.reportmain.updatePanel();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to apply style file", ex);
        }
    }

    public void getAllRows() {
        this.reportmain.setDisplayRow(-1);
        if (this.sourceData == 1) {
            try {
                this.colData = DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, 0, this.reportmain.getDisplayRow(), false);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to retrieve result set from database", ex);
                String err_msg = LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString();
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
            }
        }
    }

    @Override
    public void back() {
        this.setVisible(true);
    }

    public void setDrillDownOp(boolean state) {
        this.isDrillDownOp = state;
        if (this.isDrillDownOp) {
            this.isRedoDataMappingOp = false;
            this.isSubReportOp = false;
        }
    }

    public void setCrossTabDrillDown(boolean state) {
        this.crossTabDrillDown = state;
    }

    boolean fromDesigner() {
        return this.fromDesigner;
    }

    public void setSubReportOp(ReportElement selectedObject, ReportElementPanel selectedPanel) {
        this.subReportOpSelectedObject = selectedObject;
        this.subReportOpSelectedPanel = selectedPanel;
        this.isSubReportOp = true;
        this.isRedoDataMappingOp = false;
        this.isDrillDownOp = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneWizardSubReport(Report report) {
        if (report.getReportType() != 2) {
            ReportColumn[] column = report.getReportTables().elementAt(0).getColumn();
            for (int i = 0; i < Array.getLength(report.colInfo); ++i) {
                column[i].setVisible(report.colInfo[i].isVisible());
            }
        }
        Cursor currentCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DrillDownNode newNode = new DrillDownNode("ROOT");
            newNode.setDomainPath(this.reportmain.relativeDomainPath);
            newNode.setFileName(((SubReportObject)this.subReportOpSelectedObject).getFileName());
            report.currentNode = newNode;
            newNode.setSelected(true);
            this.reportmain.setSubReport(report, (SubReportObject)this.subReportOpSelectedObject);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to set ROOT node", ex);
        }
        finally {
            this.setCursor(currentCursor);
        }
        this.reportmain.menuBar.setUndoEnabled(false);
        this.reportmain.do_enable();
        this.reportmain.toFront();
        if (this.manager != null) {
            this.manager.dispose();
        }
        this.setVisible(false);
        this.dispose();
        try {
            Parameter param;
            LoadReport lr = new LoadReport(true);
            lr.setSubFilesTable(this.reportmain.getSubFilesTable());
            lr.setRelativeDomainPath(this.reportmain.relativeDomainPath);
            Report mainReport = lr.loadReportFromFile(this.reportmain.getFileName());
            Vector<Parameter> queryParam = report.getQueryParameters();
            Vector<Parameter> mainQueryParam = mainReport.getQueryParameters();
            Report[] subReport = mainReport.getSubReportArray();
            for (int i = 0; i < queryParam.size(); ++i) {
                int j;
                Parameter parameter = queryParam.elementAt(i);
                if (report.hasSameDataSource(mainReport)) {
                    for (j = 0; j < mainQueryParam.size(); ++j) {
                        Parameter param2 = mainQueryParam.elementAt(j);
                        if (!parameter.getName().equals(param2.getName()) || parameter.getDatatype(report) != param2.getDatatype(mainReport) || parameter.isMultiValueParam() != param2.isMultiValueParam()) continue;
                        parameter.setShared(true);
                        parameter.setSharedReportName("MAIN_REPORT");
                        parameter.setSharedParamName(param2.getName());
                        param2.incReferenceDegree();
                        report.modified = true;
                        mainReport.modified = true;
                    }
                }
                for (j = 0; j < subReport.length - 1; ++j) {
                    if (!report.hasSameDataSource(subReport[j])) continue;
                    Vector<Parameter> subQueryParam = subReport[j].getQueryParameters();
                    for (int k = 0; k < subQueryParam.size(); ++k) {
                        param = subQueryParam.elementAt(k);
                        if (!parameter.getName().equals(param.getName()) || parameter.getDatatype(report) != param.getDatatype(mainReport) || parameter.isMultiValueParam() != param.isMultiValueParam() || parameter.isShared()) continue;
                        parameter.setShared(true);
                        parameter.setSharedReportName(mainReport.subReports.elementAt(j).getParamShareReportID());
                        parameter.setSharedParamName(param.getName());
                        param.incReferenceDegree();
                        report.modified = true;
                        subReport[j].modified = true;
                    }
                }
            }
            Vector<Parameter> formulaParam = report.getFormulaParameters();
            Vector<Parameter> mainFormulaParam = mainReport.getFormulaParameters();
            for (int i = 0; i < formulaParam.size(); ++i) {
                int j;
                Parameter parameter = formulaParam.elementAt(i);
                for (j = 0; j < mainFormulaParam.size(); ++j) {
                    param = mainFormulaParam.elementAt(j);
                    if (parameter.getName().equals(param.getName()) && parameter.getDatatype(report) == param.getDatatype(mainReport) && parameter.isMultiValueParam() == param.isMultiValueParam()) {
                        parameter.setShared(true);
                    }
                    parameter.setSharedReportName("MAIN_REPORT");
                    parameter.setSharedParamName(param.getName());
                    param.incReferenceDegree();
                    report.modified = true;
                    mainReport.modified = true;
                }
                for (j = 0; j < subReport.length - 1; ++j) {
                    Vector<Parameter> subFormulaParam = subReport[j].getFormulaParameters();
                    for (int k = 0; k < subFormulaParam.size(); ++k) {
                        Parameter param3 = subFormulaParam.elementAt(k);
                        if (!parameter.getName().equals(param3.getName()) || parameter.getDatatype(report) != param3.getDatatype(subReport[j]) || parameter.isMultiValueParam() != param3.isMultiValueParam() || parameter.isShared()) continue;
                        parameter.setShared(true);
                        parameter.setSharedReportName(mainReport.subReports.elementAt(j).getParamShareReportID());
                        parameter.setSharedParamName(param3.getName());
                        report.modified = true;
                        param3.incReferenceDegree();
                        subReport[j].modified = true;
                    }
                }
            }
            if (mainReport.modified) {
                SaveReport saveReport = new SaveReport(mainReport);
                saveReport.setSaveAllData(this.reportmain.saveAllData);
                saveReport.setSubReports(mainReport.subReports);
                saveReport.setDrillDownNode(mainReport.currentNode);
                this.reportmain.saveToFile(saveReport, this.reportmain.getFileName());
            }
            if (report.modified && mainReport.subReports != null && mainReport.subReports.size() > 0) {
                SaveReport sr = new SaveReport(report);
                this.reportmain.saveToFile(sr, mainReport.subReports.elementAt(subReport.length - 1).getFileName(), SaveReport.isPAKFile(mainReport.subReports.elementAt(subReport.length - 1).getFileName()));
            }
            for (int i = 0; i < subReport.length - 1; ++i) {
                if (!subReport[i].modified) continue;
                SaveReport sr = new SaveReport(subReport[i]);
                this.reportmain.saveToFile(sr, this.reportmain.subReports.elementAt(i).getFileName(), SaveReport.isPAKFile(this.reportmain.subReports.elementAt(i).getFileName()));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create sub-report", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFileForSubReport() {
        Cursor currentCursor = this.getCursor();
        try {
            int i;
            OpenFileDialog openDialog = new OpenFileDialog(this.reportmain, LanguageEncoder.getText("Open File..."), "", new String[]{"RPT", "XML", "PAK"}, this.reportmain.getBrowseDirectories().getReportTemplatesDirectory());
            openDialog.setVisible(true);
            if (openDialog.getSelectedFile() == null) {
                throw new Exception("CANCELED");
            }
            String file = openDialog.getSelectedFile();
            if (file != null) {
                this.reportmain.getBrowseDirectories().setSubReportTemplatesDirectory(openDialog.getCurrentDirectory());
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            LoadReport loadReport = new LoadReport(true);
            loadReport.setSubFilesTable(this.reportmain.getSubFilesTable());
            loadReport.setRelativeDomainPath(this.reportmain.relativeDomainPath);
            Report loadedReport = loadReport.loadReportFromFile(file);
            if (loadReport.getSubReports() != null && loadReport.getSubReports().size() > 0) {
                throw new Exception(LanguageEncoder.getText("File cannot be used as a sub-report because it contains sub-reports itself.\n"));
            }
            this.reportmain.setSubReport(loadedReport, (SubReportObject)this.subReportOpSelectedObject);
            if (loadedReport.vGuideLines != null) {
                for (i = 0; i < loadedReport.vGuideLines.size(); ++i) {
                    this.reportmain.designPanel.rulerPanel.xRuler.addGuideLineToXRuler(QbUtil.toPixel(loadedReport.vGuideLines.elementAt(i).getX()));
                }
            }
            if (loadedReport.hGuideLines != null) {
                for (i = 0; i < loadedReport.hGuideLines.size(); ++i) {
                    GuideLine gl = loadedReport.hGuideLines.elementAt(i);
                    int y = QbUtil.toPixel(gl.getY());
                    int index = ReportElementPanel.getPanel(gl, this.reportmain.designPanel.rulerPanel.getVisiblePanel());
                    ReportElementPanel panel = (ReportElementPanel)this.reportmain.designPanel.rulerPanel.panelList.elementAt(index);
                    this.reportmain.designPanel.rulerPanel.yRuler.addGuideLineToYRuler(y += panel.getOffSet(index));
                }
            }
        }
        catch (Exception ex) {
            if (!ex.getMessage().equals("CANCELED")) {
                LOGGER.log(Level.FINE, "Error opening sub-report from file", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
            } else {
                LOGGER.log(Level.FINEST, "Opening sub-report from file: canceled", ex);
            }
            this.cancel();
        }
        finally {
            this.setCursor(currentCursor);
            this.reportmain.menuBar.setUndoEnabled(false);
        }
    }

    private quadbase.reportdesigner.report.ColData[] getData(QueryInParamSet inSet, int displayRow) {
        String query = this.dbInfo.getQuery();
        String err_msg = "";
        if (this.isDrillDownOp && !QueryParser.hasParameters(query)) {
            err_msg = LanguageEncoder.getText("Query must be parameterized for drill down reports.");
        }
        Vector<QueryInParamSet> params = null;
        try {
            if (QueryParser.hasParameters(query)) {
                if (this.isDrillDownOp) {
                    try {
                        this.drillDownMapping = this.setupDrillDownMapping(this.reportmain, this.reportmain.report, inSet);
                        params = new Vector<QueryInParamSet>();
                        params.add(inSet);
                        this.dbInfo = new QueryFileInfo("", 0, this.dbInfo, inSet);
                    }
                    catch (Exception excep) {
                        LOGGER.log(Level.FINE, "An error occured while mapping to an existing column", excep);
                        err_msg = LanguageEncoder.getText("An error occured while mapping to an existing column.\n") + excep.toString();
                    }
                } else {
                    QueryInParam[] paramarray;
                    if (this.colDataList.size() > 0) {
                        err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    for (QueryInParam element : paramarray = inSet.getParameter()) {
                        element.setValue(null);
                    }
                    QueryFileInfo qfInfo = new QueryFileInfo("", 0, this.dbInfo, new QueryInParamSet(inSet.getParameter(), inSet.getParameterInPromptSequence()));
                    QueryFileInfo.setParentFrame(this.reportmain);
                    params = QueryFileInfo.getParameter(qfInfo, true);
                    if (params == null) {
                        throw new Exception("CANCELED");
                    }
                    this.dbInfo = qfInfo;
                }
            }
        }
        catch (Exception ex) {
            params = null;
            if (ex.getMessage().equals("CANCELED")) {
                LOGGER.log(Level.FINEST, "Getting parameter values: canceled", ex);
                err_msg = ex.getMessage();
            }
            LOGGER.log(Level.FINE, "Failed to get parameter values", ex);
        }
        try {
            if (!err_msg.equals("")) {
                throw new Exception();
            }
            return DBAccess.retrieveResult(params, this.dbInfo, true, false, null, null, null, 0, displayRow, false);
        }
        catch (Exception ex) {
            if (err_msg.equals("")) {
                err_msg = LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString();
            }
            if (!err_msg.equals("CANCELED")) {
                LOGGER.log(Level.FINE, "Cannot retrieve results", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), err_msg);
            } else {
                LOGGER.log(Level.FINEST, "Retrieving results: canceled", ex);
            }
            return null;
        }
    }

    public void setDBProvider(IDBProvider provider) {
        this.dbProvider = provider;
    }

    public boolean isTopNReport() {
        return this.topN > 0;
    }

    public void setTopN(int i) {
        this.topN = i;
    }

    public boolean isRowAggregationSubtotalOnLeft() {
        return this.rowAggregationSubtotalOnLeft;
    }

    public void setRowAggregationSubtotalOnLeft(boolean rowAggregationSubtotalOnLeft) {
        this.rowAggregationSubtotalOnLeft = rowAggregationSubtotalOnLeft;
    }

    public boolean isShowRowAggregationSubtotal() {
        return this.showRowAggregationSubtotal;
    }

    public void setShowRowAggregationSubtotal(boolean showRowAggregationSubtotal) {
        this.showRowAggregationSubtotal = showRowAggregationSubtotal;
    }

    public boolean isRowAggregationGrandTotalOnLeft() {
        return this.rowAggregationGrandTotalOnLeft;
    }

    public void setRowAggregationGrandTotalOnLeft(boolean rowAggregationGrandTotalOnLeft) {
        this.rowAggregationGrandTotalOnLeft = rowAggregationGrandTotalOnLeft;
    }

    public boolean isShowRowAggregationGrandTotal() {
        return this.showRowAggregationGrandTotal;
    }

    public boolean isReOrderColumns() {
        return this.reOrderColumns;
    }

    public void setReOrderColumns(boolean reOrderColumns) {
        this.reOrderColumns = reOrderColumns;
    }

    public void setShowRowAggregationGrandTotal(boolean generateGrandTotalColumn) {
        this.showRowAggregationGrandTotal = generateGrandTotalColumn;
    }

    public boolean isShowColumnAggregation() {
        return this.showColumnAggregation;
    }

    public void setShowColumnAggregation(boolean showColumnAggregation) {
        this.showColumnAggregation = showColumnAggregation;
    }

    public boolean isColumnAggregationInFooter() {
        return this.columnAggregationInFooter;
    }

    public void setColumnAggregationInFooter(boolean columnAggregationInFooter) {
        this.columnAggregationInFooter = columnAggregationInFooter;
    }

    public boolean isAlignCrossTabColBkValHori() {
        return this.alignCrossTabColBkValHori;
    }

    public void setAlignCrossTabColBkValHori(boolean alignColBkValHori) {
        this.alignCrossTabColBkValHori = alignColBkValHori;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean b) {
        this.ascending = b;
    }

    private int[] setupDrillDownMapping(JFrame frame, Report report, QueryInParamSet paramSet) throws Exception {
        DrillDownColumnMapDialog dDialog = new DrillDownColumnMapDialog(frame, report, paramSet, this.crossTabDrillDown);
        return this.setupDrillDownMapping(dDialog, report, paramSet);
    }

    private int[] setupDrillDownMapping(JDialog dialog, Report report, QueryInParamSet paramSet) throws Exception {
        DrillDownColumnMapDialog dDialog = new DrillDownColumnMapDialog(dialog, report, paramSet, this.crossTabDrillDown);
        return this.setupDrillDownMapping(dDialog, report, paramSet);
    }

    private int[] setupDrillDownMapping(DrillDownColumnMapDialog drilldownDialog, Report report, QueryInParamSet paramSet) throws Exception {
        drilldownDialog.setVisible(true);
        if (!drilldownDialog.isModified()) {
            throw new Exception("CANCELED");
        }
        int[] ret = drilldownDialog.getColInfoIndices();
        QueryInParam[] paramArray = paramSet.getParameter();
        for (int i = 0; i < ret.length; ++i) {
            Object value = null;
            try {
                ReportTable table = this.reportmain.report.getReportTables().elementAt(0);
                while (table instanceof ReportTreeTable) {
                    table = ((ReportTreeTable)table).getSubTable(0);
                }
                value = ret[i] >= 0 && ret[i] < 1000 ? (this.crossTabDrillDown ? (this.dbInfo instanceof QueryFileInfo ? paramArray[i].getDefaultValue((QueryFileInfo)this.dbInfo) : paramArray[i].getDefaultValue()) : table.getColumn(ret[i]).getData(0)) : (ret[i] >= 1000 && ret[i] < 2000 ? this.reportmain.report.getQueryParameters().elementAt(ret[i] - 1000).getValue() : (ret[i] >= 2000 ? this.reportmain.report.getFormulaParameters().elementAt(ret[i] - 2000).getValue() : (this.dbInfo instanceof QueryFileInfo ? paramArray[i].getDefaultValue((QueryFileInfo)this.dbInfo) : paramArray[i].getDefaultValue())));
            }
            catch (ArrayIndexOutOfBoundsException arrayEx) {
                LOGGER.log(Level.FINEST, "Column is empty", arrayEx);
            }
            Object defaultValue = null;
            defaultValue = this.dbInfo instanceof QueryFileInfo ? paramArray[i].getDefaultValue((QueryFileInfo)this.dbInfo) : paramArray[i].getDefaultValue();
            if (value != null) {
                defaultValue = value;
            }
            paramArray[i].setDefaultValue(defaultValue);
            paramArray[i].setValue(value);
        }
        return ret;
    }

    @Override
    public void updateReports(DefaultMutableTreeNode node) {
        UpdateDialog dialog = new UpdateDialog(this.manager);
        dialog.setCurrentDirectory(this.reportmain.getTemplatesDirectory());
        dialog.setVisible(true);
        if (dialog.isCancelled) {
            return;
        }
        this.reportmain.setTemplatesDirectory(dialog.getCurrentDirectory());
        this.selectedNames = dialog.getSelectedNames();
        this.connectionOnly = dialog.isConnectionOnly();
        this.displayMsgDialog = new DisplayMsgDialog(this.manager);
        this.displayMsgDialog.setVisible(true);
        this.doUpdateReports((DefaultDataSourceNode)node);
        this.doUpdateCharts((DefaultDataSourceNode)node);
    }

    private DefaultDataSourceNode getNode(DefaultDataSourceNode node, String registryID, String dataSourceID) {
        if (node.isLeaf()) {
            if (node.getID() != null && !node.getID().equals("") && node.getID().equals(dataSourceID) && this.manager.getRegistryID().equals(registryID)) {
                return node;
            }
            return null;
        }
        int ct = node.getChildCount();
        for (int i = 0; i < ct; ++i) {
            DefaultDataSourceNode tmp = (DefaultDataSourceNode)node.getChildAt(i);
            DefaultDataSourceNode result = this.getNode(tmp, registryID, dataSourceID);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void doUpdateReports(DefaultDataSourceNode ddsnode) {
        for (int i = 0; this.selectedNames != null && i < this.selectedNames.size(); ++i) {
            this.filename = this.selectedNames.elementAt(i);
            try {
                DefaultMutableTreeNode original;
                quadbase.reportdesigner.report.ColData[] colData;
                String dataSourceID;
                String registryID;
                DefaultDataSourceNode node;
                String[] result = LoadReport.loadDataSourceID(this.filename);
                if (result == null || (node = this.getNode(ddsnode, registryID = result[0], dataSourceID = result[1])) == null) continue;
                LoadReport loadReport = new LoadReport(true);
                Report loadedReport = loadReport.loadReportFromFile(this.filename, null, null, true, false);
                if (loadedReport.sourceData == -1 && loadedReport.getOriginalSourceData() > -1) {
                    loadedReport.sourceData = loadedReport.getOriginalSourceData();
                    loadedReport.setOriginalSourceData(-1);
                }
                Report report = null;
                boolean hasDrillDown = false;
                boolean isDrillDown = false;
                boolean hasSubReport = false;
                if (loadedReport.currentNode != null && loadedReport.currentNode.getChildCount() > 0) {
                    hasDrillDown = true;
                }
                if (loadReport.getDrillDownNode() == null) {
                    isDrillDown = true;
                }
                if (loadedReport.subReports != null && loadedReport.subReports.size() > 0) {
                    hasSubReport = true;
                }
                if (node instanceof QueryNode || node instanceof DataViewQueryNode) {
                    String query = null;
                    DefaultDataSourceNode ddsNode = null;
                    DatabaseNode dbNode = null;
                    JNDIDataSourceNode jndiNode = null;
                    DBInfoBasic dbInfo = null;
                    if (loadedReport.sourceData == 1) {
                        dbInfo = loadedReport.dbInfo;
                    } else if (loadedReport.sourceData == 3) {
                        for (int j = 0; j < loadedReport.sourceType.length; ++j) {
                            if (loadedReport.sourceType[j] != 1) continue;
                            dbInfo = (DBInfoBasic)loadedReport.sourceList[j];
                        }
                    }
                    if (this.connectionOnly) {
                        if (node instanceof QueryNode) {
                            ddsNode = (DefaultDataSourceNode)node.getParent().getParent();
                        } else if (node instanceof DataViewQueryNode) {
                            ddsNode = (DefaultDataSourceNode)node.getParent().getParent().getParent();
                        }
                        if (ddsNode instanceof DatabaseNode) {
                            dbNode = (DatabaseNode)ddsNode;
                            dbInfo.setUseJNDIDataSource(false);
                            dbInfo.setURLString(dbNode.getURL());
                            dbInfo.setDriverName(dbNode.getDriver());
                            dbInfo.setUserID(dbNode.getUserName() != null ? dbNode.getUserName() : "");
                            dbInfo.setPassword(dbNode.getPassword() != null ? dbNode.getPassword() : "");
                        } else if (ddsNode instanceof JNDIDataSourceNode) {
                            jndiNode = (JNDIDataSourceNode)ddsNode;
                            dbInfo.setUseJNDIDataSource(true);
                            dbInfo.setJNDIName(jndiNode.getJNDIName());
                            dbInfo.setEnvProperties(jndiNode.getEnvProperties());
                        }
                        report = loadedReport;
                        if (report.sourceData == 1) {
                            report.dbInfo = dbInfo;
                            report.setOriginalSourceData(-1);
                            report.sourceData = 1;
                            report.originalColDataFromMemSource = null;
                        } else if (report.sourceData == 3) {
                            report.sourceType = loadedReport.sourceType;
                            report.sourceList = loadedReport.sourceList;
                        }
                        report.setDBSourceType(loadedReport.getDBSourceType());
                    } else {
                        Vector<Object> sqlParams;
                        QueryInParamSet paramSet = null;
                        byte[][] queryFileBytes = null;
                        if (node instanceof QueryNode) {
                            query = ((QueryNode)node).getSQL();
                            ddsNode = (DefaultDataSourceNode)node.getParent().getParent();
                            paramSet = ((QueryNode)node).getInSet();
                            queryFileBytes = ((QueryNode)node).getBytes();
                        } else if (node instanceof DataViewQueryNode) {
                            query = ((DataViewQueryNode)node).getSQL();
                            ddsNode = (DefaultDataSourceNode)node.getParent().getParent().getParent();
                            paramSet = ((DataViewQueryNode)node).getInSet();
                            queryFileBytes = ((DataViewQueryNode)node).getBytes();
                        }
                        if (ddsNode instanceof DatabaseNode) {
                            dbNode = (DatabaseNode)ddsNode;
                            dbInfo = new DBInfoBasic(dbNode.getURL(), dbNode.getDriver(), dbNode.getUserName() != null ? dbNode.getUserName() : "", dbNode.getPassword() != null ? dbNode.getPassword() : "", query, dbNode.getAdditionalDb());
                        } else if (ddsNode instanceof JNDIDataSourceNode) {
                            jndiNode = (JNDIDataSourceNode)ddsNode;
                            dbInfo = new DBInfoBasic(jndiNode.getJNDIName(), query, jndiNode.getEnvProperties());
                        }
                        if (!QueryParser.hasParameters(query)) {
                            sqlParams = null;
                            if (isDrillDown) {
                                LOGGER.finest(this.filename + ": update failed. Drill-down report requires query with parameter");
                                this.displayMsgDialog.appendMessage(this.filename + ": update failed.\n\tDrill-down report requires query with parameter.\n");
                                continue;
                            }
                        } else {
                            IQueryInParam[] newParams;
                            IQueryInParam[] oldParams;
                            if (isDrillDown && !this.isParamCompatible(oldParams = ReportUtil.getInParam(loadedReport.dbInfo), newParams = paramSet.getParameter())) {
                                LOGGER.finest(this.filename + ": update failed. Parameter(s) for this drill-down report are not compatible");
                                this.displayMsgDialog.appendMessage(this.filename + ": update failed.\n\tparameter(s) for this drill-down report are not compatible.\n");
                                continue;
                            }
                            sqlParams = new Vector();
                            QueryFileInfo qfInfo = new QueryFileInfo("", 0, dbInfo, new QueryInParamSet(paramSet.getParameter(), paramSet.getParameterInPromptSequence()));
                            sqlParams = QueryFileInfo.getParameter(qfInfo, false, true, false);
                            dbInfo = qfInfo;
                        }
                        if ((report = this.updateReport(loadedReport, colData = DBAccess.retrieveResult(sqlParams, dbInfo, true, false, null, null, null, 0, 1, false))) == null) continue;
                        report.setOriginalSourceData(-1);
                        report.sourceData = 1;
                        report.originalColDataFromMemSource = null;
                        report.dbInfo = dbInfo;
                        report.setDBSourceType(loadedReport.getDBSourceType());
                        report.setQueryFileBytes(queryFileBytes);
                    }
                } else if (node instanceof TextFileNode || node instanceof ClassFileNode || node instanceof XMLFileNode || node instanceof XMLQueryNode) {
                    String sourceFile = null;
                    if (node instanceof TextFileNode) {
                        sourceFile = ((TextFileNode)node).getFile();
                    }
                    if (node instanceof ClassFileNode) {
                        sourceFile = ((ClassFileNode)node).getFile();
                    }
                    if (node instanceof XMLFileNode) {
                        sourceFile = ((XMLFileNode)node).getFile();
                    }
                    if (node instanceof XMLQueryNode) {
                        sourceFile = ((XMLFileNode)node.getParent()).getFile();
                    }
                    QueryFileInfo dbInfo = null;
                    XMLFileQueryInfo xmlInfo = null;
                    if (loadedReport.sourceData == 6 && ClassFileUtil.isParameterized(sourceFile)) {
                        QueryClassFileInfo classInfo = new QueryClassFileInfo(sourceFile);
                        QueryInParamSet paramSet = classInfo.getInSet();
                        colData = new DataFileInput().readProcessedData(sourceFile, false, null, null, null, 0, -1, paramSet);
                        dbInfo = classInfo;
                    } else {
                        if (loadedReport.sourceData == 7) {
                            DefaultMutableTreeNode original2 = this.manager.getSelectedNode();
                            this.manager.setSelectedNode(node);
                            xmlInfo = this.manager.getXMLFileQueryInfo();
                            this.manager.setSelectedNode(original2);
                            if (((XMLQueryNode)node).getInSet() != null) {
                                QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(xmlInfo);
                                dbInfo = xmlFileInfo;
                            }
                        }
                        colData = new DataFileInput().readProcessedData(sourceFile, false, null, null, null, 0, -1, xmlInfo, loadedReport.sourceData);
                    }
                    report = this.updateReport(loadedReport, colData);
                    if (report == null) continue;
                    if (node instanceof TextFileNode) {
                        report.sourceData = 2;
                    }
                    if (node instanceof ClassFileNode) {
                        report.sourceData = 6;
                    }
                    if (node instanceof XMLFileNode) {
                        report.sourceData = 4;
                    }
                    if (node instanceof XMLQueryNode) {
                        report.sourceData = 7;
                    }
                    report.setOriginalSourceData(-1);
                    report.originalColDataFromMemSource = null;
                    report.sourceFile = sourceFile;
                    report.dbInfo = dbInfo;
                    report.setXMLFileQueryInfo(xmlInfo);
                } else if (node instanceof SOAPViewNode) {
                    original = this.manager.getSelectedNode();
                    this.manager.setSelectedNode(node);
                    SOAPQueryFileInfo sqfi = this.manager.getSOAPQueryFileInfo();
                    this.manager.setSelectedNode(original);
                    colData = quadbase.reportdesigner.report.SOAPAccess.retrieveResult(sqfi);
                    report = this.updateReport(loadedReport, colData);
                    if (report == null) continue;
                    report.sourceData = 12;
                    report.soapInfo = sqfi;
                    if (sqfi.isParameterized()) {
                        report.dbInfo = sqfi;
                    }
                } else if (node instanceof EJBNode) {
                    Hashtable environment;
                    Object[] selectedMethodParamVal;
                    String selectedMethodName;
                    String remoteName;
                    String homeName;
                    EJBNode ejbnode = (EJBNode)node;
                    String jndiName = ejbnode.getJNDIName();
                    colData = EJBAccess.retrieveResult(jndiName, homeName = ejbnode.getHomeName(), remoteName = ejbnode.getRemoteName(), selectedMethodName = ejbnode.getSelectedMethod(), selectedMethodParamVal = ejbnode.getParam(selectedMethodName), environment = ejbnode.getEnvironment());
                    report = this.updateReport(loadedReport, colData);
                    if (report == null) continue;
                    report.sourceData = 5;
                    report.jndiName = jndiName;
                    report.homeName = homeName;
                    report.remoteName = remoteName;
                    report.selectedMethodName = selectedMethodName;
                    report.selectedMethodParamVal = selectedMethodParamVal;
                    report.environment = environment;
                } else if (node instanceof SalesForceQueryNode) {
                    original = this.manager.getSelectedNode();
                    this.manager.setSelectedNode(node);
                    SalesForceQueryFileInfo sfQfi = this.manager.getSalesForceQueryInfo();
                    this.manager.setSelectedNode(original);
                    colData = quadbase.reportdesigner.report.SalesForceAccess.getColData(sfQfi);
                    report = this.updateReport(loadedReport, colData);
                    if (report == null) continue;
                    report.sourceData = 11;
                    report.sfQueryInfo = sfQfi;
                    if (sfQfi.isParameterized()) {
                        report.dbInfo = sfQfi;
                    }
                } else if (node instanceof ExcelFileNode) {
                    original = this.manager.getSelectedNode();
                    this.manager.setSelectedNode(node);
                    ExcelFileInfo excelInfo = this.manager.getExcelFileInfo();
                    this.manager.setSelectedNode(original);
                    colData = ExcelAccess.getColData(excelInfo);
                    report = this.updateReport(loadedReport, colData);
                    if (report == null) continue;
                    report.sourceData = 13;
                }
                if (hasDrillDown) {
                    this.updateDrillDown(report.currentNode);
                }
                if (hasSubReport) {
                    this.updateSubReport(report);
                }
                this.addCharts(report);
                SaveReport saveReport = new SaveReport(report);
                saveReport.setSubFilesTable(this.reportmain.getSubFilesTable());
                saveReport.setSubReports(report.subReports);
                if (!isDrillDown) {
                    saveReport.setDrillDownNode(report.currentNode);
                }
                saveReport.saveToFile(this.filename);
                LOGGER.finest(this.filename + ": updated successfully");
                this.displayMsgDialog.appendMessage(this.filename + ": updated successfully.\n");
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot update reports!", ex);
            }
        }
    }

    private void doUpdateCharts(DefaultDataSourceNode node) {
        if (node.isLeaf()) {
            for (int i = 0; this.charts != null && i < this.charts.size(); ++i) {
                ReportChartObject rco = this.charts.elementAt(i);
                if (rco.isReportDataUsed()) continue;
                String templatename = rco.getText();
                try {
                    DefaultMutableTreeNode original;
                    ColData[] colData;
                    QueryInParamSet paramSet;
                    String[] result = LoadChart.loadDataSourceID(templatename);
                    if (result == null) continue;
                    String registryID = result[0];
                    String dataSourceID = result[1];
                    if (node.getID() == null || !node.getID().equals(dataSourceID) || !this.manager.getRegistryID().equals(registryID)) continue;
                    Vector preSetParams = ChartObject.getPresetParams(null, null, rco);
                    LoadChart lc = new LoadChart();
                    Chart loadedChart = lc.loadChartFromFile(IOUtil.getOffScreenComponent(), templatename, preSetParams, true);
                    Chart chart = null;
                    boolean hasDrillDown = false;
                    boolean isDrillDown = false;
                    if (loadedChart.currentNode != null && loadedChart.currentNode.getChildCount() > 0) {
                        hasDrillDown = true;
                    }
                    if (lc.getDrillDownNode() == null) {
                        isDrillDown = true;
                    }
                    if (node instanceof QueryNode || node instanceof DataViewQueryNode) {
                        String query = null;
                        DefaultDataSourceNode ddsNode = null;
                        DatabaseNode dbNode = null;
                        JNDIDataSourceNode jndiNode = null;
                        if (this.connectionOnly) {
                            if (node instanceof QueryNode) {
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent();
                            } else if (node instanceof DataViewQueryNode) {
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent().getParent();
                            }
                            chart = loadedChart;
                            if (ddsNode instanceof DatabaseNode) {
                                dbNode = (DatabaseNode)ddsNode;
                                chart.dbInfo.setURLString(dbNode.getURL());
                                chart.dbInfo.setDriverName(dbNode.getDriver());
                                chart.dbInfo.setUserID(dbNode.getUserName() != null ? dbNode.getUserName() : "");
                                chart.dbInfo.setPassword(dbNode.getPassword() != null ? dbNode.getPassword() : "");
                            } else if (ddsNode instanceof JNDIDataSourceNode) {
                                jndiNode = (JNDIDataSourceNode)ddsNode;
                                chart.dbInfo.setJNDIName(jndiNode.getJNDIName());
                                chart.dbInfo.setEnvProperties(jndiNode.getEnvProperties());
                            }
                        } else {
                            paramSet = null;
                            byte[][] queryFileBytes = null;
                            if (node instanceof QueryNode) {
                                query = ((QueryNode)node).getSQL();
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent();
                                paramSet = ((QueryNode)node).getInSet();
                                queryFileBytes = ((QueryNode)node).getBytes();
                            } else if (node instanceof DataViewQueryNode) {
                                query = ((DataViewQueryNode)node).getSQL();
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent().getParent();
                                paramSet = ((DataViewQueryNode)node).getInSet();
                                queryFileBytes = ((DataViewQueryNode)node).getBytes();
                            }
                            DBInfoBasic dbInfo = null;
                            if (ddsNode instanceof DatabaseNode) {
                                DatabaseNode databaseNode = (DatabaseNode)ddsNode;
                                dbInfo = new DBInfoBasic(databaseNode.getURL(), databaseNode.getDriver(), databaseNode.getUserName() != null ? databaseNode.getUserName() : "", databaseNode.getPassword() != null ? databaseNode.getPassword() : "", query, databaseNode.getAdditionalDb());
                            } else if (ddsNode instanceof JNDIDataSourceNode) {
                                JNDIDataSourceNode jndiDSNode = (JNDIDataSourceNode)ddsNode;
                                dbInfo = new DBInfoBasic(jndiDSNode.getJNDIName(), query, jndiDSNode.getEnvProperties());
                            }
                            Vector<Object> sqlParams = null;
                            if (QueryParser.hasParameters(query)) {
                                sqlParams = new Vector();
                                QueryFileInfo qfInfo = new QueryFileInfo("", 0, dbInfo, new QueryInParamSet(paramSet.getParameter(), paramSet.getParameterInPromptSequence()));
                                sqlParams = QueryFileInfo.getParameter(qfInfo, false, true, false);
                                dbInfo = qfInfo;
                            }
                            if ((chart = this.updateChart(loadedChart, colData = quadbase.chart.DBAccess.retrieveResult(sqlParams, dbInfo, true, false, null, null, null, 0, 1))) == null) continue;
                            chart.dbInfo = dbInfo;
                            chart.setQueryFileBytes(queryFileBytes);
                        }
                        chart.setOriginalSourceData(-1);
                        chart.sourceData = 1;
                        chart.originalColDataFromMemSource = null;
                        chart.setDBSourceType(loadedChart.getDBSourceType());
                    } else if (node instanceof TextFileNode || node instanceof ClassFileNode || node instanceof XMLFileNode || node instanceof XMLQueryNode) {
                        String sourceFile = null;
                        QueryFileInfo dbInfo = null;
                        XMLFileQueryInfo xmlInfo = null;
                        if (node instanceof TextFileNode) {
                            sourceFile = ((TextFileNode)node).getFile();
                        }
                        if (node instanceof ClassFileNode) {
                            sourceFile = ((ClassFileNode)node).getFile();
                        }
                        if (node instanceof XMLFileNode) {
                            sourceFile = ((XMLFileNode)node).getFile();
                        }
                        if (node instanceof XMLQueryNode) {
                            sourceFile = ((XMLFileNode)node.getParent()).getFile();
                        }
                        if (loadedChart.sourceData == 6 && ClassFileUtil.isParameterized(sourceFile)) {
                            QueryClassFileInfo classInfo = new QueryClassFileInfo(sourceFile);
                            paramSet = classInfo.getInSet();
                            colData = new quadbase.chart.DataFileInput().readProcessedData(sourceFile, false, null, null, null, paramSet);
                            dbInfo = classInfo;
                        } else {
                            if (loadedChart.sourceData == 7) {
                                DefaultMutableTreeNode original2 = this.manager.getSelectedNode();
                                this.manager.setSelectedNode(node);
                                xmlInfo = this.manager.getXMLFileQueryInfo();
                                this.manager.setSelectedNode(original2);
                                if (((XMLQueryNode)node).getInSet() != null) {
                                    QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(xmlInfo);
                                    dbInfo = xmlFileInfo;
                                }
                            }
                            colData = new quadbase.chart.DataFileInput().readProcessedData(sourceFile, false, null, null, null, xmlInfo, loadedChart.sourceData);
                        }
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        if (node instanceof TextFileNode) {
                            chart.sourceData = 2;
                        }
                        if (node instanceof ClassFileNode) {
                            chart.sourceData = 6;
                        }
                        if (node instanceof XMLFileNode) {
                            chart.sourceData = 4;
                        }
                        if (node instanceof XMLQueryNode) {
                            chart.sourceData = 7;
                        }
                        chart.setOriginalSourceData(-1);
                        chart.originalColDataFromMemSource = null;
                        chart.sourceFile = sourceFile;
                        chart.dbInfo = dbInfo;
                        chart.setXMLFileQueryInfo(xmlInfo);
                    } else if (node instanceof SOAPViewNode) {
                        original = this.manager.getSelectedNode();
                        this.manager.setSelectedNode(node);
                        SOAPQueryFileInfo sqfi = this.manager.getSOAPQueryFileInfo();
                        this.manager.setSelectedNode(original);
                        colData = SOAPAccess.retrieveResult(sqfi);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 12;
                        chart.soapInfo = sqfi;
                        if (sqfi.isParameterized()) {
                            chart.dbInfo = sqfi;
                        }
                    } else if (node instanceof EJBNode) {
                        Hashtable environment;
                        Object[] selectedMethodParamVal;
                        String selectedMethodName;
                        String remoteName;
                        String homeName;
                        EJBNode ejbnode = (EJBNode)node;
                        String jndiName = ejbnode.getJNDIName();
                        colData = quadbase.chart.EJBAccess.retrieveResult(jndiName, homeName = ejbnode.getHomeName(), remoteName = ejbnode.getRemoteName(), selectedMethodName = ejbnode.getSelectedMethod(), selectedMethodParamVal = ejbnode.getParam(selectedMethodName), environment = ejbnode.getEnvironment(), false, null, null, null);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 5;
                        chart.jndiName = jndiName;
                        chart.homeName = homeName;
                        chart.remoteName = remoteName;
                        chart.selectedMethodName = selectedMethodName;
                        chart.selectedMethodParamVal = selectedMethodParamVal;
                        chart.environment = environment;
                    } else if (node instanceof SalesForceQueryNode) {
                        original = this.manager.getSelectedNode();
                        this.manager.setSelectedNode(node);
                        SalesForceQueryFileInfo sfQfi = this.manager.getSalesForceQueryInfo();
                        this.manager.setSelectedNode(original);
                        colData = SalesForceAccess.getColData(sfQfi);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 11;
                        chart.sfQueryInfo = sfQfi;
                        if (sfQfi.isParameterized()) {
                            chart.dbInfo = sfQfi;
                        }
                    } else if (node instanceof ExcelFileNode) {
                        original = this.manager.getSelectedNode();
                        this.manager.setSelectedNode(node);
                        ExcelFileInfo excelInfo = this.manager.getExcelFileInfo();
                        this.manager.setSelectedNode(original);
                        colData = quadbase.chart.ExcelAccess.getColData(excelInfo);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 13;
                    }
                    if (hasDrillDown) {
                        this.updateDrillDown(chart.currentNode);
                    }
                    SaveChart saveChart = new SaveChart(chart);
                    if (!isDrillDown) {
                        saveChart.setDrillDownNode(chart.currentNode);
                    }
                    saveChart.saveToFile(templatename.substring(0, templatename.length() - 4));
                    LOGGER.finest(templatename + ": updated successfully");
                    this.displayMsgDialog.appendMessage(templatename + ": updated successfully.\n");
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Cannot update charts", ex);
                }
            }
        } else {
            int ct = node.getChildCount();
            for (int i = 0; i < ct; ++i) {
                DefaultDataSourceNode tmp = (DefaultDataSourceNode)node.getChildAt(i);
                this.doUpdateCharts(tmp);
            }
        }
    }

    private Report updateReport(Report loadedReport, quadbase.reportdesigner.report.ColData[] colData) {
        if (quadbase.reportdesigner.report.ColData.isColDataCompatible(loadedReport.colData, colData)) {
            try {
                Report report = this.createReport(loadedReport, colData);
                this.done(report, loadedReport);
                return report;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, this.filename + ": update failed", ex);
                this.displayMsgDialog.appendMessage(this.filename + ": update failed.\n\t" + ex.getMessage() + "\n");
                return null;
            }
        }
        LOGGER.finest(this.filename + ": update failed. Number of columns or data type of columns are not the same as in the report");
        this.displayMsgDialog.appendMessage(this.filename + ": update failed.\n\t.Number of columns or data type of columns are not the same as in the report.\n");
        return null;
    }

    private Chart updateChart(Chart loadedChart, ColData[] colData) {
        if (ColData.isColDataCompatible(loadedChart.colData, colData)) {
            return loadedChart.setNewData(colData);
        }
        return null;
    }

    private boolean isParamCompatible(IQueryInParam[] oldParams, IQueryInParam[] newParams) {
        if (oldParams.length != newParams.length) {
            return false;
        }
        for (int j = 0; j < oldParams.length; ++j) {
            if (oldParams[j].getSqlType() == newParams[j].getSqlType()) continue;
            return false;
        }
        return true;
    }

    private Report createReport(Report loadedReport, quadbase.reportdesigner.report.ColData[] colData) throws Exception {
        Vector<ColInfo> temp = new Vector<ColInfo>();
        for (int i = 0; i < Array.getLength(loadedReport.colInfo); ++i) {
            if (loadedReport.colInfo[i].getFormula() != null) continue;
            temp.addElement(loadedReport.colInfo[i]);
        }
        ColInfo[] colInfo = new ColInfo[temp.size()];
        for (int j = 0; j < temp.size(); ++j) {
            colInfo[j] = (ColInfo)temp.elementAt(j);
            quadbase.reportdesigner.report.ColData tmpCol = colData[colInfo[j].getMapping()];
            colInfo[j].setName(tmpCol.getName());
        }
        colInfo = Report.addFormulaColumn(colInfo, loadedReport.colInfo);
        Report report = new Report(colData);
        report.setReOrderColumns(loadedReport.isReOrderColumns());
        report.setShowRowAggregationGrandTotal(loadedReport.isShowRowAggregationGrandTotal());
        report.crossTabFreeForm = loadedReport.crossTabFreeForm;
        report.setColumnAggregationInHeader(loadedReport.isColumnAggregationInHeader());
        report.setShowRowAggregationSubtotal(loadedReport.isShowRowAggregationSubtotal());
        report.setRowAggregationSubtotalOnLeft(loadedReport.isRowAggregationSubtotalOnLeft());
        report.setRowAggregationGrandTotalOnLeft(loadedReport.isRowAggregationGrandTotalOnLeft());
        report.setAlignCrossTabColBkValHori(loadedReport.isAlignCrossTabColBkValHori());
        report.createTable(loadedReport.reportType, colInfo);
        return report;
    }

    private void done(Report report, Report loadedReport) {
        int k;
        Vector<Boolean> temp = new Vector<Boolean>();
        for (int j = 0; j < Array.getLength(report.colInfo); ++j) {
            boolean b = report.colInfo[j].isVisible();
            temp.addElement(b);
        }
        boolean[] isVisible = new boolean[temp.size()];
        for (k = 0; k < temp.size(); ++k) {
            isVisible[k] = (Boolean)temp.elementAt(k);
        }
        report.copyReport(loadedReport);
        report.setQueryParameters(null);
        for (k = 0; k < Array.getLength(isVisible); ++k) {
            report.colInfo[k].setVisible(isVisible[k]);
        }
        if (report.getReportType() == 4) {
            for (int i = 0; i < report.getReportTables().size(); ++i) {
                ReportTable tbl = report.getReportTables().elementAt(i);
                tbl.getHeader().setVisible(false);
                tbl.getFooter().setVisible(false);
            }
        }
        if (report.getReportType() != 2) {
            ReportColumn[] column = report.getReportTables().elementAt(0).getColumn();
            for (int i = 0; i < Array.getLength(report.colInfo); ++i) {
                column[i].setVisible(report.colInfo[i].isVisible());
            }
        }
    }

    private void updateDrillDown(DrillDownNode parent) {
        int ct = parent.getChildCount();
        for (int i = 0; i < ct; ++i) {
            this.selectedNames.addElement(parent.getChildAt(i).getFileName());
        }
    }

    private void updateDrillDown(quadbase.chart.DrillDownNode parent) {
        int ct = parent.getChildCount();
        for (int i = 0; i < ct; ++i) {
            this.selectedNames.addElement(parent.getChildAt(i).getFileName());
        }
    }

    private void updateSubReport(Report parent) {
        for (int i = 0; i < parent.subReports.size(); ++i) {
            this.selectedNames.addElement(parent.subReports.elementAt(i).getFileName());
        }
    }

    private void addCharts(Report parent) {
        if (this.charts == null) {
            this.charts = new Vector();
        }
        for (int i = 0; i < parent.getAllCharts().size(); ++i) {
            this.charts.addElement(parent.getAllCharts().elementAt(i));
        }
    }
}

