/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.designer.ReportMain;

public class RotationDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    ReportElement elt;
    ReportMain reportMain;
    private JLabel rotLabel;
    JRadioButton none;
    JRadioButton clockwise;
    JRadioButton counterclockwise;
    boolean groupSelect = false;
    Vector tree = null;

    public RotationDialog(ReportMain reportMain, ReportElement elt) {
        super(reportMain, LanguageEncoder.getText("Rotation..."), true);
        this.reportMain = reportMain;
        this.elt = elt;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        this.none = new JRadioButton(LanguageEncoder.getText("None"), this.elt.getRotateAngle() == 0.0);
        this.clockwise = new JRadioButton(LanguageEncoder.getText("Clockwise"), this.elt.getRotateAngle() == 90.0);
        this.counterclockwise = new JRadioButton(LanguageEncoder.getText("Counterclockwise"), this.elt.getRotateAngle() == -90.0);
        ButtonGroup group = new ButtonGroup();
        group.add(this.none);
        group.add(this.clockwise);
        group.add(this.counterclockwise);
        p1.add(new JLabel(LanguageEncoder.getText("Horizontal:")));
        p1.add(this.none);
        p1.add(this.clockwise);
        p1.add(this.counterclockwise);
        JPanel alignPanel = new JPanel();
        alignPanel.setLayout(new BorderLayout());
        alignPanel.add("Center", p1);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.setLayout(new BorderLayout());
        this.add("Center", alignPanel);
        this.add("South", p2);
        this.groupSelect = this.reportMain.groupFormatFlag() && !(this.elt instanceof ReportGrid) && !(this.elt instanceof ReportLine);
        this.pack();
    }

    public double getRotationSelection() {
        if (this.none.isSelected()) {
            return 0.0;
        }
        if (this.clockwise.isSelected()) {
            return 90.0;
        }
        if (this.counterclockwise.isSelected()) {
            return -90.0;
        }
        return 0.0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            double w = -1.0;
            double h = -1.0;
            double r = 0.0;
            boolean match = false;
            double rotation = this.getRotationSelection();
            if (this.groupSelect) {
                this.reportMain.designPanel.rulerPanel.groupFormatSetRotation(rotation);
                this.reportMain.setModified();
                this.reportMain.setIsUndoEnabled(true);
            } else {
                this.elt.setRotateAngle(rotation);
                this.reportMain.setModified();
                this.reportMain.repaintPanel(this.reportMain.selectedPanel);
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

