/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.designer.PopupMenuForReportElement;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.RulerPanel;
import quadbase.reportdesigner.designer.adapter.NormalAdapter;
import quadbase.reportdesigner.report.crosstab.CrossTabHelper;

public class Ruler
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(Ruler.class.getName());
    public static final int INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 19;
    public int orientation;
    public boolean isMetric;
    ReportMain reportMain;
    protected int xL = 0;
    protected int xR = 0;
    protected int yU = 0;
    protected int yD = 0;
    protected int x0 = 0;
    protected int y0 = 0;
    protected boolean dragOp = false;
    protected boolean resizeOp = false;
    protected boolean groupSetWidthOp = false;
    public double xLeft = 0.0;
    public double xRight = 0.0;
    public double groupWidth = 0.0;
    protected Polygon current = null;
    protected Polygon next = null;
    protected Rectangle shade = null;
    protected Vector xgl;
    protected Vector ygl;
    int idx;
    boolean guideLineSelected = false;

    public Ruler(int o, boolean m, ReportMain reportMain) {
        this.orientation = o;
        this.isMetric = m;
        this.reportMain = reportMain;
        if (this.orientation == 0) {
            try {
                if (reportMain.designPanel.rulerPanel.xRuler != null) {
                    this.xgl = reportMain.designPanel.rulerPanel.xRuler.xgl;
                }
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.FINEST, "Cannot get horizontal ruler guideline polygon", e);
            }
            this.addMouseListener(new xRulerMouseInputAdapter());
            this.addMouseMotionListener(new xRulerMouseInputAdapter());
        } else {
            try {
                if (reportMain.designPanel.rulerPanel.yRuler != null) {
                    this.ygl = reportMain.designPanel.rulerPanel.yRuler.ygl;
                }
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.FINEST, "Cannot get vertical ruler guideline polygon", e);
            }
            this.addMouseListener(new yRulerMouseInputAdapter());
            this.addMouseMotionListener(new yRulerMouseInputAdapter());
        }
    }

    public void setIsMetric(boolean isMetric) {
        this.isMetric = isMetric;
        this.repaint();
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    private void repaintGuideLineOnXRuler(int x) {
        this.xL = x;
        this.xR = x;
        int[] xCoordinates = new int[]{x - 4, x - 4, x + 4, x + 4, x};
        int[] yCoordinates = new int[]{11, 0, 0, 11, 18};
        Polygon arrow = new Polygon(xCoordinates, yCoordinates, 5);
        this.xgl.removeElementAt(this.idx);
        this.xgl.insertElementAt(arrow, this.idx);
        this.repaint();
    }

    private void repaintGuideLineOnYRuler(int y) {
        this.yU = y;
        this.yD = y;
        int index = this.reportMain.selectedPanel.getPanelIndex();
        int offSet = this.reportMain.selectedPanel.getOffSet(index);
        int[] xCoordinates = new int[]{0, 0, 11, 18, 11};
        int[] yCoordinates = new int[]{(y += offSet) + 4, y - 4, y - 4, y, y + 4};
        Polygon arrow = new Polygon(xCoordinates, yCoordinates, 5);
        this.ygl.removeElementAt(this.idx);
        this.ygl.insertElementAt(arrow, this.idx);
        this.repaint();
    }

    public void updateYRuler() {
        Vector<GuideLine> vec = this.reportMain.report.hGuideLines;
        if (vec == null) {
            this.ygl = null;
            return;
        }
        for (int i = 0; i < vec.size(); ++i) {
            this.ygl.setElementAt(null, i);
            GuideLine gl = vec.elementAt(i);
            ReportElementPanel panel = this.reportMain.findPanel(gl);
            if (panel == null) continue;
            int index = panel.getPanelIndex();
            int offSet = panel.getOffSet(index);
            int y = QbUtil.toPixel(gl.getY()) + offSet;
            int[] xCoordinates = new int[]{0, 0, 11, 18, 11};
            int[] yCoordinates = new int[]{y + 4, y - 4, y - 4, y, y + 4};
            Polygon arrow = new Polygon(xCoordinates, yCoordinates, 5);
            this.ygl.setElementAt(arrow, i);
        }
        this.repaint();
    }

    public void updateXRuler() {
        Vector<GuideLine> vec = this.reportMain.report.vGuideLines;
        if (vec == null) {
            this.xgl = null;
            return;
        }
    }

    public void addGuideLineToXRuler(int x) {
        this.xL = x;
        this.xR = x;
        int[] xCoordinates = new int[]{x - 4, x - 4, x + 4, x + 4, x};
        int[] yCoordinates = new int[]{11, 0, 0, 11, 18};
        Polygon arrow = new Polygon(xCoordinates, yCoordinates, 5);
        if (this.xgl == null) {
            this.xgl = new Vector();
        }
        this.xgl.addElement(arrow);
        this.repaint();
    }

    public void addGuideLineToYRuler(int y) {
        this.yU = y;
        this.yD = y;
        int[] xCoordinates = new int[]{0, 0, 11, 18, 11};
        int[] yCoordinates = new int[]{y + 4, y - 4, y - 4, y, y + 4};
        Polygon arrow = new Polygon(xCoordinates, yCoordinates, 5);
        if (this.ygl == null) {
            this.ygl = new Vector();
        }
        this.ygl.addElement(arrow);
        this.repaint();
    }

    public void repaintXRuler(int x1, int x2) {
        if (this.reportMain.groupFormatFlag()) {
            return;
        }
        this.xL = x1;
        this.xR = x2;
        int[] xCoordinates = new int[]{x1 - 4, x1 - 4, x1 + 4, x1 + 4, x1};
        int[] yCoordinates = new int[]{11, 0, 0, 11, 18};
        int[] xCoordinates2 = new int[]{x2 - 4, x2 - 4, x2 + 4, x2 + 4, x2};
        int[] yCoordinates2 = new int[]{11, 0, 0, 11, 18};
        this.current = new Polygon(xCoordinates, yCoordinates, 5);
        this.next = new Polygon(xCoordinates2, yCoordinates2, 5);
        this.shade = new Rectangle(x1, 0, x2 - x1, 19);
        this.repaint();
    }

    public void repaintYRuler(int y1, int y2) {
        if (this.reportMain.groupFormatFlag()) {
            return;
        }
        this.yU = y1;
        this.yD = y2;
        int[] xCoordinates = new int[]{0, 0, 11, 18, 11};
        int[] yCoordinates = new int[]{y1 + 4, y1 - 4, y1 - 4, y1, y1 + 4};
        int[] xCoordinates2 = new int[]{0, 0, 11, 18, 11};
        int[] yCoordinates2 = new int[]{y2 + 4, y2 - 4, y2 - 4, y2, y2 + 4};
        this.current = new Polygon(xCoordinates, yCoordinates, 5);
        this.next = new Polygon(xCoordinates2, yCoordinates2, 5);
        this.shade = new Rectangle(0, y1, 19, y2 - y1);
        this.repaint();
    }

    public void repaintNull() {
        this.current = null;
        this.next = null;
        this.shade = null;
        this.repaint();
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(19, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 19));
    }

    @Override
    public void paintComponent(Graphics g) {
        block21: {
            String text;
            int tickLength;
            int end;
            Graphics2D g2;
            block20: {
                int x;
                double i;
                int i2;
                Rectangle drawHere = g.getClipBounds();
                g2 = (Graphics2D)g;
                g2.setColor(Color.white);
                g2.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
                if (this.shade != null) {
                    g2.setColor(Color.gray);
                    g2.fill(this.shade);
                }
                if (this.current != null) {
                    g2.setColor(Color.lightGray);
                    g2.fillPolygon(this.current);
                    g2.setColor(Color.black);
                    g2.drawPolygon(this.current);
                }
                if (this.next != null) {
                    g2.setColor(Color.lightGray);
                    g2.fillPolygon(this.next);
                    g2.setColor(Color.black);
                    g2.drawPolygon(this.next);
                }
                for (i2 = 0; this.xgl != null && i2 < this.xgl.size(); ++i2) {
                    g2.setColor(Color.lightGray);
                    g2.fillPolygon((Polygon)this.xgl.elementAt(i2));
                    g2.setColor(Color.black);
                    g2.drawPolygon((Polygon)this.xgl.elementAt(i2));
                }
                for (i2 = 0; this.ygl != null && i2 < this.ygl.size(); ++i2) {
                    if (this.ygl.elementAt(i2) == null) continue;
                    g2.setColor(Color.lightGray);
                    g2.fillPolygon((Polygon)this.ygl.elementAt(i2));
                    g2.setColor(Color.black);
                    g2.drawPolygon((Polygon)this.ygl.elementAt(i2));
                }
                g2.setFont(new Font("SansSerif", 0, 10));
                g2.setColor(Color.black);
                end = 0;
                int start = 0;
                tickLength = 0;
                text = null;
                double endINCH = 0.0;
                if (this.orientation == 0) {
                    start = drawHere.x;
                    end = drawHere.x + QbUtil.toPixel(RulerPanel.MAX_XWIDTH);
                    endINCH = (double)end / (double)QbUtil.toPixel(1.0) + 1.0;
                } else {
                    start = drawHere.y;
                    end = drawHere.y + QbUtil.toPixel(RulerPanel.MAX_YHEIGHT);
                    endINCH = (double)end / (double)QbUtil.toPixel(1.0) + 1.0;
                }
                if (start == 0) {
                    String string = text = this.isMetric ? "cm" : "in";
                    if (this.orientation == 0) {
                        g2.drawString(text, 3, 8);
                    } else {
                        g2.drawString(text, 1, 9);
                    }
                    text = null;
                }
                if (this.isMetric) break block20;
                int j = 1;
                for (i = 0.1; i < endINCH; i += 0.1) {
                    tickLength = 2;
                    text = null;
                    x = QbUtil.toPixel(i);
                    if (j % 10 != 0) {
                        if (this.orientation == 0) {
                            g2.drawLine(x, 18, x, 19 - tickLength - 1);
                        } else {
                            g2.drawLine(18, x, 19 - tickLength - 1, x);
                        }
                    }
                    ++j;
                }
                for (i = 1.0; i < endINCH; i += 1.0) {
                    x = QbUtil.toPixel(i);
                    tickLength = 4;
                    text = Integer.toString((int)i);
                    if (this.orientation == 0) {
                        if (text != null) {
                            g2.drawString(text, x - 3, 8);
                        }
                        g2.drawLine(x, 18, x, 19 - tickLength - 1);
                        continue;
                    }
                    g2.drawLine(18, x, 19 - tickLength - 1, x);
                    if (text == null) continue;
                    g2.drawString(text, 1, x + 3);
                }
                break block21;
            }
            if (!this.isMetric) break block21;
            int cm = (int)((double)INCH / 2.54);
            int cmUnit = cm / 4;
            for (int i = 1; i < end / cm + 1; ++i) {
                tickLength = 4;
                text = Integer.toString(i);
                int x = cm * i;
                if (this.orientation == 0) {
                    if (text != null) {
                        g2.drawString(text, x - 3, 8);
                    }
                    g2.drawLine(x, 18, x, 19 - tickLength - 1);
                    g2.drawLine(x - cmUnit, 18, x - cmUnit, 19 - tickLength - 1 + 2);
                    g2.drawLine(x - 2 * cmUnit, 18, x - 2 * cmUnit, 19 - tickLength - 1 + 2);
                    g2.drawLine(x - 3 * cmUnit, 18, x - 3 * cmUnit, 19 - tickLength - 1 + 2);
                    continue;
                }
                g2.drawLine(18, x, 19 - tickLength - 1, x);
                g2.drawLine(18, x - cmUnit, 19 - tickLength - 1 + 2, x - cmUnit);
                g2.drawLine(18, x - 2 * cmUnit, 19 - tickLength - 1 + 2, x - 2 * cmUnit);
                g2.drawLine(18, x - 3 * cmUnit, 19 - tickLength - 1 + 2, x - 3 * cmUnit);
                if (text == null) continue;
                g2.drawString(text, 1, x + 3);
            }
        }
    }

    private int getxL() {
        return this.xL;
    }

    private int getxR() {
        return this.xR;
    }

    private int getyU() {
        return this.yU;
    }

    private int getyD() {
        return this.yD;
    }

    public void groupSetWidth() {
        this.reportMain.designPanel.rulerPanel.xRuler.repaintNull();
        this.reportMain.designPanel.rulerPanel.yRuler.repaintNull();
        this.groupSetWidthOp = true;
        this.setOrigin();
        this.repaintXRuler(QbUtil.toPixel(this.xLeft), QbUtil.toPixel(this.xRight));
    }

    public void setOrigin() {
        int i;
        ReportElementPanel p;
        ReportElementPanel panel = p = (ReportElementPanel)this.reportMain.designPanel.rulerPanel.panelList.elementAt(0);
        for (i = 0; i < this.reportMain.designPanel.rulerPanel.panelList.size() - 1; ++i) {
            JPanel obj = this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (obj != null) {
                panel = (ReportElementPanel)obj;
            }
            if (panel.groupFormat.size() != 0) break;
        }
        if (i == this.reportMain.designPanel.rulerPanel.panelList.size()) {
            return;
        }
        ReportElement[] relt = new ReportElement[panel.groupFormat.size()];
        Vector<ReportElement> v = panel.groupFormat;
        for (int j = 0; j < v.size(); ++j) {
            relt[j] = v.elementAt(j);
        }
        Vector<ReportElement[]> temp = ReportElement.sortElementHorizontally(relt);
        ReportElement[] elt = temp.elementAt(0);
        ReportElement r = elt[0];
        this.xLeft = r.getX();
        this.xRight = r.getX() + r.getWidth();
    }

    class yRulerMouseInputAdapter
    extends MouseInputAdapter {
        yRulerMouseInputAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            for (int i = 0; Ruler.this.ygl != null && i < Ruler.this.ygl.size(); ++i) {
                Polygon p;
                Ruler.this.idx = i;
                if (Ruler.this.ygl.elementAt(i) == null || !(p = (Polygon)Ruler.this.ygl.elementAt(i)).contains(x, y)) continue;
                Ruler.this.guideLineSelected = true;
                Ruler.this.y0 = y;
                x = 0;
                Ruler.this.yD = y = QbUtil.toPixel(Ruler.this.reportMain.report.getHGuideLine(Ruler.this.idx).getY());
                Ruler.this.yU = y;
                Ruler.this.setCursor(Cursor.getPredefinedCursor(13));
                Ruler.this.dragOp = true;
                Ruler.this.resizeOp = false;
                ReportElementPanel panel = Ruler.this.reportMain.findPanel(Ruler.this.reportMain.report.getHGuideLine(Ruler.this.idx));
                if (panel != null) {
                    Ruler.this.reportMain.setSelectedPanel(panel);
                }
                Ruler.this.reportMain.setSelectedObject(Ruler.this.reportMain.report.getHGuideLine(Ruler.this.idx), Ruler.this.reportMain.selectedPanel);
                Ruler.this.reportMain.selectedPanel.mousePressedFromRuler(x, y, Ruler.this.dragOp, Ruler.this.resizeOp);
                return;
            }
            if (Ruler.this.current == null || Ruler.this.shade == null || Ruler.this.next == null) {
                return;
            }
            if (Ruler.this.next.contains(x, y)) {
                y = Ruler.this.getyD();
                x = 0;
                Ruler.this.setCursor(Cursor.getPredefinedCursor(9));
                Ruler.this.dragOp = false;
                Ruler.this.resizeOp = true;
                Ruler.this.reportMain.selectedPanel.mousePressedFromRuler(x, y, Ruler.this.dragOp, Ruler.this.resizeOp);
                return;
            }
            if (Ruler.this.current.contains(x, y) || Ruler.this.shade.contains(x, y)) {
                Ruler.this.y0 = y;
                y = Ruler.this.getyU();
                x = 0;
                Ruler.this.setCursor(Cursor.getPredefinedCursor(13));
                Ruler.this.dragOp = true;
                Ruler.this.resizeOp = false;
                Ruler.this.reportMain.selectedPanel.mousePressedFromRuler(x, y, Ruler.this.dragOp, Ruler.this.resizeOp);
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int yU = Ruler.this.getyU();
            int y = e.getY();
            if (Ruler.this.dragOp) {
                if (CrossTabHelper.isElementFromCrossTabSection(Ruler.this.reportMain.report, Ruler.this.reportMain.selectedObject) && !Ruler.this.reportMain.isAllowCrosstabElementMove()) {
                    return;
                }
                int deltaY = y - Ruler.this.y0;
                Ruler.this.y0 = y;
                int shadeLength = Ruler.this.getyD() - Ruler.this.getyU();
                int index = Ruler.this.reportMain.selectedPanel.getPanelIndex();
                int offSet = Ruler.this.reportMain.selectedPanel.getOffSet(index);
                if (!Ruler.this.guideLineSelected) {
                    if (this.isGridLine(Ruler.this.reportMain.selectedObject) || yU + deltaY >= offSet + 1) {
                        Ruler.this.repaintYRuler(yU + deltaY, yU + deltaY + shadeLength);
                    } else {
                        Ruler.this.repaintYRuler(offSet + 1, offSet + 1 + shadeLength);
                    }
                } else {
                    Ruler.this.repaintGuideLineOnYRuler(yU + deltaY);
                }
            } else if (Ruler.this.resizeOp) {
                if (NormalAdapter.isNonMovableElement((ReportElementPanel)Ruler.this.reportMain.selectedPanel)) {
                    ReportElement selectedObject = Ruler.this.reportMain.selectedObject;
                    double deltaInch = QbUtil.toInch(Ruler.this.yD - yU) - (selectedObject.getY() + selectedObject.getHeight());
                    if (selectedObject.getHeight() + deltaInch - 0.1 <= 0.0) {
                        return;
                    }
                }
                if (y >= yU + 3) {
                    Ruler.this.repaintYRuler(yU, y);
                } else {
                    Ruler.this.repaintYRuler(yU, yU + 3);
                }
            }
        }

        private boolean isGridLine(ReportElement elt) {
            return elt instanceof ReportLine || elt instanceof ReportGrid;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int offSet;
            int index;
            int y = 0;
            if (Ruler.this.dragOp) {
                y = Ruler.this.getyU();
            }
            if (Ruler.this.resizeOp) {
                y = Ruler.this.getyD();
            }
            if (Ruler.this.reportMain.report.snapToGrid) {
                if (Ruler.this.reportMain.isCm) {
                    y = QbUtil.getPosAfterSnapToGrid(y);
                } else {
                    double yy = (double)y / (double)QbUtil.getPixelPerInch();
                    yy = (double)Math.round(yy / Ruler.this.reportMain.report.gridStepSize) * Ruler.this.reportMain.report.gridStepSize;
                    y = QbUtil.toPixel(yy);
                }
            }
            if (Ruler.this.dragOp) {
                if (CrossTabHelper.isElementFromCrossTabSection(Ruler.this.reportMain.report, Ruler.this.reportMain.selectedObject) && !Ruler.this.reportMain.isAllowCrosstabElementMove()) {
                    return;
                }
                int shadeLength = Ruler.this.getyD() - Ruler.this.getyU();
                index = Ruler.this.reportMain.selectedPanel.getPanelIndex();
                offSet = Ruler.this.reportMain.selectedPanel.getOffSet(index);
                Ruler.this.yU = Ruler.this.reportMain.selectedObject.getSnap() == 0 ? y : offSet + QbUtil.toPixel(Ruler.this.reportMain.selectedObject.getY());
                if (!Ruler.this.guideLineSelected) {
                    Ruler.this.repaintYRuler(Ruler.this.yU, Ruler.this.yU + shadeLength);
                } else {
                    Ruler.this.repaintGuideLineOnYRuler(Ruler.this.yU);
                }
            }
            if (Ruler.this.resizeOp) {
                Ruler.this.yD = y;
                if (NormalAdapter.isNonMovableElement((ReportElementPanel)Ruler.this.reportMain.selectedPanel)) {
                    ReportElement selectedObject = Ruler.this.reportMain.selectedObject;
                    double deltaInch = QbUtil.toInch(Ruler.this.yD - Ruler.this.yU) - (selectedObject.getY() + selectedObject.getHeight());
                    if (selectedObject.getHeight() + deltaInch - 0.1 <= 0.0) {
                        return;
                    }
                    Ruler.this.reportMain.createBackupReport();
                    CrossTabHelper.adjustReportElementsByDeltaY(Ruler.this.reportMain.selectedPanel, selectedObject, deltaInch);
                    Ruler.this.reportMain.repaintPanel();
                }
                if (Ruler.this.reportMain.selectedObject != null && Ruler.this.reportMain.selectedObject.isLocked() && !Ruler.this.groupSetWidthOp) {
                    ReportElement elt = Ruler.this.reportMain.selectedObject;
                    index = Ruler.this.reportMain.selectedPanel.getPanelIndex();
                    offSet = Ruler.this.reportMain.selectedPanel.getOffSet(index);
                    Ruler.this.yU = QbUtil.toPixel(elt.getY()) + offSet;
                    Ruler.this.repaintYRuler(Ruler.this.yU, Ruler.this.yU + QbUtil.toPixel(elt.getHeight()));
                } else if (Ruler.this.yD >= Ruler.this.yU + 3) {
                    Ruler.this.repaintYRuler(Ruler.this.yU, Ruler.this.yD);
                } else {
                    Ruler.this.repaintYRuler(Ruler.this.yU, Ruler.this.yU + 3);
                }
            }
            if (Ruler.this.reportMain.selectedPanel == null) {
                return;
            }
            Ruler.this.reportMain.selectedPanel.mouseReleasedFromRuler(0, y);
            Ruler.this.dragOp = false;
            Ruler.this.resizeOp = false;
            Ruler.this.setCursor(Cursor.getDefaultCursor());
            Ruler.this.guideLineSelected = false;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (Ruler.this.reportMain.selectedObject == null) {
                return;
            }
            int y = 0;
            if (Ruler.this.dragOp) {
                y = Ruler.this.getyU();
            } else if (Ruler.this.resizeOp) {
                y = Ruler.this.getyD();
            }
            Ruler.this.reportMain.selectedPanel.mouseReleasedFromRuler(0, y);
            Ruler.this.dragOp = false;
            Ruler.this.resizeOp = false;
            Ruler.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int mouseMask = e.getModifiers() & 0xFFFFFFEF;
            if (mouseMask == IOUtil.getRightMouseClickMask()) {
                for (int i = 0; Ruler.this.ygl != null && i < Ruler.this.ygl.size(); ++i) {
                    Polygon p;
                    if (Ruler.this.ygl.elementAt(i) == null || !(p = (Polygon)Ruler.this.ygl.elementAt(i)).contains(e.getX(), e.getY())) continue;
                    PopupMenuForReportElement popupMenu = new PopupMenuForReportElement(Ruler.this.reportMain, Ruler.this.reportMain.getSelectedPanel());
                    Ruler.this.add(popupMenu);
                    popupMenu.addMenu(Ruler.this.reportMain.report.getHGuideLine(i));
                    popupMenu.show(Ruler.this, e.getX(), e.getY());
                    return;
                }
            }
        }
    }

    class xRulerMouseInputAdapter
    extends MouseInputAdapter {
        xRulerMouseInputAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            for (int i = 0; Ruler.this.xgl != null && i < Ruler.this.xgl.size(); ++i) {
                Ruler.this.idx = i;
                Polygon p = (Polygon)Ruler.this.xgl.elementAt(i);
                if (!p.contains(x, y)) continue;
                Ruler.this.guideLineSelected = true;
                Ruler.this.groupSetWidthOp = false;
                Ruler.this.x0 = x;
                Ruler.this.xR = x = QbUtil.toPixel(Ruler.this.reportMain.report.getVGuideLine(Ruler.this.idx).getX());
                Ruler.this.xL = x;
                y = 0;
                Ruler.this.setCursor(Cursor.getPredefinedCursor(13));
                Ruler.this.dragOp = true;
                Ruler.this.resizeOp = false;
                ReportElementPanel panel = (ReportElementPanel)Ruler.this.reportMain.designPanel.rulerPanel.panelList.elementAt(0);
                Ruler.this.reportMain.setSelectedPanel(panel);
                Ruler.this.reportMain.setSelectedObject(Ruler.this.reportMain.report.getVGuideLine(Ruler.this.idx), panel);
                panel.mousePressedFromRuler(x, y, Ruler.this.dragOp, Ruler.this.resizeOp);
                return;
            }
            if (Ruler.this.current != null && Ruler.this.shade != null && Ruler.this.next != null) {
                if (Ruler.this.next.contains(x, y)) {
                    x = Ruler.this.getxR();
                    y = 0;
                    Ruler.this.setCursor(Cursor.getPredefinedCursor(11));
                    Ruler.this.dragOp = false;
                    Ruler.this.resizeOp = true;
                    if (Ruler.this.groupSetWidthOp && Ruler.this.reportMain.groupFormatFlag()) {
                        return;
                    }
                    Ruler.this.reportMain.selectedPanel.mousePressedFromRuler(x, y, Ruler.this.dragOp, Ruler.this.resizeOp);
                    return;
                }
                if (Ruler.this.current.contains(x, y) || Ruler.this.shade.contains(x, y)) {
                    Ruler.this.x0 = x;
                    x = Ruler.this.getxL();
                    y = 0;
                    if (Ruler.this.groupSetWidthOp && Ruler.this.reportMain.groupFormatFlag()) {
                        return;
                    }
                    Ruler.this.setCursor(Cursor.getPredefinedCursor(13));
                    Ruler.this.dragOp = true;
                    Ruler.this.resizeOp = false;
                    Ruler.this.reportMain.selectedPanel.mousePressedFromRuler(x, y, Ruler.this.dragOp, Ruler.this.resizeOp);
                    return;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int xL = Ruler.this.getxL();
            int x = e.getX();
            if (Ruler.this.dragOp) {
                if (CrossTabHelper.isElementFromCrossTabSection(Ruler.this.reportMain.report, Ruler.this.reportMain.selectedObject) && !Ruler.this.reportMain.isAllowCrosstabElementMove()) {
                    return;
                }
                int deltaX = x - Ruler.this.x0;
                Ruler.this.x0 = x;
                int shadeLength = Ruler.this.getxR() - Ruler.this.getxL();
                if (!Ruler.this.guideLineSelected) {
                    if (xL + deltaX >= 1) {
                        Ruler.this.repaintXRuler(xL + deltaX, xL + deltaX + shadeLength);
                    } else {
                        Ruler.this.repaintXRuler(1, 1 + shadeLength);
                    }
                } else {
                    Ruler.this.repaintGuideLineOnXRuler(xL + deltaX);
                }
            }
            if (Ruler.this.resizeOp) {
                if (x >= xL + 3) {
                    Ruler.this.repaintXRuler(xL, x);
                } else {
                    Ruler.this.repaintXRuler(xL, xL + 3);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int x = 0;
            if (Ruler.this.dragOp && Ruler.this.reportMain.report.isCrossTab() && !Ruler.this.reportMain.isAllowCrosstabElementMove()) {
                return;
            }
            if (Ruler.this.groupSetWidthOp && Ruler.this.reportMain.groupFormatFlag()) {
                Ruler.this.xRight = (double)Ruler.this.getxR() / (double)QbUtil.toPixel(1.0);
                if (Ruler.this.reportMain.report.snapToGrid) {
                    Ruler.this.xRight = Ruler.this.reportMain.isCm ? QbUtil.getPosAfterSnapToGrid(Ruler.this.xRight) : (double)Math.round(Ruler.this.xRight / Ruler.this.reportMain.report.gridStepSize) * Ruler.this.reportMain.report.gridStepSize;
                }
                Ruler.this.groupWidth = Ruler.this.xRight - Ruler.this.xLeft;
                Ruler.this.dragOp = false;
                Ruler.this.resizeOp = false;
                Ruler.this.reportMain.designPanel.rulerPanel.setWholeGroupWidth(Ruler.this.groupWidth);
                Ruler.this.reportMain.menuBar.setUndoEnabled(true);
                return;
            }
            if (Ruler.this.dragOp) {
                x = Ruler.this.getxL();
            } else if (Ruler.this.resizeOp) {
                x = Ruler.this.getxR();
            }
            if (Ruler.this.reportMain.report.snapToGrid) {
                if (Ruler.this.reportMain.isCm) {
                    x = QbUtil.getPosAfterSnapToGrid(x);
                } else {
                    double xx = (double)x / (double)QbUtil.getPixelPerInch();
                    xx = (double)Math.round(xx / Ruler.this.reportMain.report.gridStepSize) * Ruler.this.reportMain.report.gridStepSize;
                    x = QbUtil.toPixel(xx);
                }
            }
            if (Ruler.this.dragOp) {
                int shadeLength = Ruler.this.getxR() - Ruler.this.getxL();
                Ruler.this.xL = Ruler.this.reportMain.selectedObject.getVSnap() == 0 ? x : QbUtil.toPixel(Ruler.this.reportMain.selectedObject.getX());
                if (!Ruler.this.guideLineSelected) {
                    if (Ruler.this.xL >= 1) {
                        Ruler.this.repaintXRuler(Ruler.this.xL, Ruler.this.xL + shadeLength);
                    } else {
                        Ruler.this.repaintXRuler(1, 1 + shadeLength);
                    }
                } else {
                    Ruler.this.repaintGuideLineOnXRuler(Ruler.this.xL);
                }
            }
            if (Ruler.this.resizeOp) {
                Ruler.this.xR = x;
                if (NormalAdapter.isNonMovableElement((ReportElementPanel)Ruler.this.reportMain.selectedPanel)) {
                    ReportElement selectedObject = Ruler.this.reportMain.selectedObject;
                    double deltaInch = QbUtil.toInch(Ruler.this.xR) - (selectedObject.getX() + selectedObject.getWidth());
                    if (selectedObject.getWidth() + deltaInch - 0.1 <= 0.0) {
                        return;
                    }
                    Ruler.this.reportMain.createBackupReport();
                    CrossTabHelper.adjustAllElementsWithGreaterX(Ruler.this.reportMain.selectedPanel, Ruler.this.reportMain.selectedObject, deltaInch);
                    Ruler.this.reportMain.repaintPanel();
                }
                if (Ruler.this.reportMain.selectedObject != null && Ruler.this.reportMain.selectedObject.isLocked() && !Ruler.this.groupSetWidthOp) {
                    ReportElement elt = Ruler.this.reportMain.selectedObject;
                    Ruler.this.repaintXRuler(QbUtil.toPixel(elt.getX()), QbUtil.toPixel(elt.getX() + elt.getWidth()));
                } else if (Ruler.this.xR >= Ruler.this.xL + 3) {
                    Ruler.this.repaintXRuler(Ruler.this.xL, Ruler.this.xR);
                } else {
                    Ruler.this.repaintXRuler(Ruler.this.xL, Ruler.this.xL + 3);
                }
            }
            if (Ruler.this.reportMain.selectedObject == null) {
                return;
            }
            Ruler.this.reportMain.selectedPanel.mouseReleasedFromRuler(x, 0);
            Ruler.this.setCursor(Cursor.getDefaultCursor());
            Ruler.this.dragOp = false;
            Ruler.this.resizeOp = false;
            Ruler.this.groupSetWidthOp = false;
            Ruler.this.guideLineSelected = false;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (Ruler.this.reportMain.selectedObject == null) {
                return;
            }
            int x = 0;
            if (Ruler.this.dragOp) {
                x = Ruler.this.getxL();
            } else if (Ruler.this.resizeOp) {
                x = Ruler.this.getxR();
            }
            Ruler.this.reportMain.selectedPanel.mouseReleasedFromRuler(x, 0);
            Ruler.this.setCursor(Cursor.getDefaultCursor());
            Ruler.this.dragOp = false;
            Ruler.this.resizeOp = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int mouseMask = e.getModifiers() & 0xFFFFFFEF;
            if (mouseMask == IOUtil.getRightMouseClickMask()) {
                for (int i = 0; Ruler.this.xgl != null && i < Ruler.this.xgl.size(); ++i) {
                    Polygon p = (Polygon)Ruler.this.xgl.elementAt(i);
                    if (!p.contains(e.getX(), e.getY())) continue;
                    PopupMenuForReportElement popupMenu = new PopupMenuForReportElement(Ruler.this.reportMain, Ruler.this.reportMain.getSelectedPanel());
                    Ruler.this.add(popupMenu);
                    popupMenu.addMenu(Ruler.this.reportMain.report.getVGuideLine(i));
                    popupMenu.show(Ruler.this, e.getX(), e.getY());
                    return;
                }
            }
        }
    }
}

