/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.CBAggrColHeader;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.designer.MasterSectionPanel;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.Ruler;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class RulerPanel
extends JScrollPane
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(RulerPanel.class.getName());
    JPanel mainPanel;
    ReportMain reportMain;
    static int MAX_XWIDTH = 20;
    static int MAX_YHEIGHT = 20;
    public Vector<JPanel> panelList;
    JPanel buttonPanel;
    JPanel rowHeader;
    public static final int PIXEL_PER_INCH = QbUtil.getPixelPerInch();
    public Ruler xRuler;
    public Ruler yRuler;
    private JToggleButton isMetric;
    public boolean isSelecting = false;
    public int selectionOriginX = -1;
    public int selectionOriginY = -1;
    public int selectionEndX = -1;
    public int selectionEndY = -1;
    Vector<ReportElement> clipBoard = new Vector();
    int panelType = 0;
    public static final int REPORTSECTION = 1;
    public static final int REPORTTABLE = 2;
    boolean isCutOp = false;
    int pasteX = 0;
    int pasteY = 0;
    int startPanel = -1;
    boolean pastingSubReport = false;
    private ReportElementPanel masterSectionPanel;
    private JScrollPane masterSectionScrollPane;
    private ReportSection masterSection;
    int dividerSize = -1;
    ButtonGroup sectionButtonGroup = new ButtonGroup();
    public Vector<Formula> pasteToAddFormula = new Vector();

    public RulerPanel(ReportMain reportMain) {
        this.reportMain = reportMain;
        this.initialize();
        try {
            if (reportMain != null && reportMain.designPanel != null && reportMain.designPanel.rulerPanel != null) {
                this.panelType = reportMain.designPanel.rulerPanel.panelType;
                this.clipBoard = reportMain.designPanel.rulerPanel.clipBoard;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to keep old clipboard content", ex);
        }
    }

    protected RulerPanel() {
    }

    private void initialize() {
        this.getVerticalScrollBar().setUnitIncrement(16);
        if (this.reportMain.report == null) {
            this.getViewport().add(new JPanel());
        } else {
            MAX_XWIDTH = this.getToolkit().getScreenSize().width / PIXEL_PER_INCH;
            double reportMinWidth = this.reportMain.report.getMinWidth();
            if (reportMinWidth > (double)MAX_XWIDTH) {
                MAX_XWIDTH = (int)(reportMinWidth + 3.0 + this.reportMain.report.getActualPageWidth());
            }
            if ((reportMinWidth = this.reportMain.report.getActualPageWidth() * 2.0) > (double)MAX_XWIDTH) {
                MAX_XWIDTH = (int)reportMinWidth;
            }
            MAX_YHEIGHT = (int)(this.reportMain.report.getPageHeight() * 1.5);
            this.getViewport().add(this.getMainPanel());
            this.xRuler = new Ruler(0, this.reportMain.isCm, this.reportMain);
            this.xRuler.setPreferredWidth((MAX_XWIDTH + 1) * PIXEL_PER_INCH);
            JPanel xRulerPanel = new JPanel();
            JPanel xTopBorder = new JPanel();
            xTopBorder.setPreferredSize(new Dimension((MAX_XWIDTH + 1) * PIXEL_PER_INCH, 7));
            xTopBorder.setBorder(BorderFactory.createEtchedBorder());
            JPanel xBottomBorder = new JPanel();
            xBottomBorder.setPreferredSize(new Dimension((MAX_XWIDTH + 1) * PIXEL_PER_INCH, 7));
            xBottomBorder.setBorder(BorderFactory.createEtchedBorder());
            xRulerPanel.setLayout(new BorderLayout());
            xRulerPanel.add("North", xTopBorder);
            xRulerPanel.add("South", xBottomBorder);
            xRulerPanel.add("Center", this.xRuler);
            this.setColumnHeaderView(xRulerPanel);
            this.rowHeader = new JPanel();
            this.rowHeader.setLayout(new BorderLayout());
            this.rowHeader.add("Center", this.buttonPanel);
            this.yRuler = new Ruler(1, this.reportMain.isCm, this.reportMain);
            this.yRuler.setPreferredHeight((MAX_YHEIGHT + 1) * PIXEL_PER_INCH);
            JPanel yRulerPanel = new JPanel();
            yRulerPanel.setLayout(new BorderLayout());
            JPanel yLeftBorder = new JPanel();
            yLeftBorder.setPreferredSize(new Dimension(7, (MAX_YHEIGHT + 1) * PIXEL_PER_INCH));
            yLeftBorder.setBorder(BorderFactory.createEtchedBorder());
            JPanel yRightBorder = new JPanel();
            yRightBorder.setPreferredSize(new Dimension(7, (MAX_YHEIGHT + 1) * PIXEL_PER_INCH));
            yRightBorder.setBorder(BorderFactory.createEtchedBorder());
            yRulerPanel.add("West", yLeftBorder);
            yRulerPanel.add("East", yRightBorder);
            yRulerPanel.add("Center", this.yRuler);
            this.rowHeader.add("East", yRulerPanel);
            this.setRowHeaderView(this.rowHeader);
            String choice = "in";
            if (this.reportMain.isCm) {
                choice = "cm";
            }
            this.isMetric = new JToggleButton(choice, this.reportMain.isCm);
            this.isMetric.setFont(new Font("SansSerif", 0, 12));
            this.isMetric.setMargin(new Insets(2, 2, 2, 2));
            this.isMetric.setPreferredSize(new Dimension(26, 26));
            this.isMetric.addItemListener(new UnitsListener());
            JPanel buttonCorner = new JPanel();
            buttonCorner.setLayout(new FlowLayout(2));
            buttonCorner.add(this.isMetric);
            this.setCorner("UPPER_LEFT_CORNER", buttonCorner);
        }
    }

    void updateButtonPanel() {
        this.setRowHeaderView(this.rowHeader);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        this.setPreferredSize(new Dimension(QbUtil.toPixel(MAX_XWIDTH), QbUtil.toPixel(MAX_YHEIGHT)));
        this.drawReport();
        return this.mainPanel;
    }

    private void drawReport() {
        try {
            ReportUI reportUI = new ReportUI(this.reportMain.report, this.reportMain.getGraphics(), false);
            reportUI.setDesignMode(true);
            reportUI.initPageSize();
            this.panelList = new Vector();
            Vector<ReportTable> vec = this.reportMain.report.getReportTables();
            ReportTable table = vec.size() > 0 ? vec.elementAt(0) : null;
            ReportSection section = this.reportMain.report.getReportHeader();
            ReportElementPanel reportHeader = new ReportElementPanel(this.reportMain, reportUI, section, table, LanguageEncoder.getText("Report Header"));
            this.panelList.addElement(reportHeader);
            this.addSubSections(section, this.panelList, reportUI, table, "RH Sub_");
            section = this.reportMain.report.getPageHeader();
            ReportElementPanel pageHeader = new ReportElementPanel(this.reportMain, reportUI, section, table, LanguageEncoder.getText("Page Header"));
            this.panelList.addElement(pageHeader);
            this.addSubSections(section, this.panelList, reportUI, table, "PH Sub_");
            this.drawTable(reportUI, table, this.panelList);
            section = this.reportMain.report.getPageFooter();
            ReportElementPanel pageFooter = new ReportElementPanel(this.reportMain, reportUI, section, table, LanguageEncoder.getText("Page Footer"));
            this.panelList.addElement(pageFooter);
            this.addSubSections(section, this.panelList, reportUI, table, "PF Sub_");
            section = this.reportMain.report.getReportFooter();
            ReportElementPanel reportFooter = new ReportElementPanel(this.reportMain, reportUI, section, table, LanguageEncoder.getText("Report Footer"));
            this.panelList.addElement(reportFooter);
            this.addSubSections(section, this.panelList, reportUI, table, "RF Sub_");
            this.panelList.addElement(this.createEmptyPanel());
            this.createMainPanel(this.panelList);
            if (this.reportMain.report.isSideBySideLayout()) {
                this.createMasterSection(reportUI);
            } else {
                this.masterSectionScrollPane = null;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot draw report panels", ex);
        }
    }

    private JPanel createMainPanel(Vector<JPanel> panelList) {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        Vector<JPanel> visiblePanel = this.getVisiblePanel(panelList);
        JSplitPane jsp = this.createSplitPane(visiblePanel, 0);
        if (jsp.getPreferredSize().getHeight() < (double)QbUtil.toPixel(MAX_YHEIGHT)) {
            Dimension spDimension = jsp.getPreferredSize();
            this.mainPanel.setMinimumSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), QbUtil.toPixel(MAX_YHEIGHT)));
            this.mainPanel.setPreferredSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), QbUtil.toPixel(MAX_YHEIGHT)));
            this.mainPanel.setSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), QbUtil.toPixel(MAX_YHEIGHT)));
        } else {
            Dimension spDimension = jsp.getPreferredSize();
            this.mainPanel.setMinimumSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), Double.valueOf(spDimension.getHeight()).intValue()));
            this.mainPanel.setPreferredSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), Double.valueOf(spDimension.getHeight()).intValue()));
            this.mainPanel.setSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), Double.valueOf(spDimension.getHeight()).intValue()));
        }
        this.mainPanel.add((Component)jsp, "Center");
        this.dividerSize = jsp.getDividerSize();
        this.buttonPanel = this.createButtonPanel(visiblePanel);
        return this.mainPanel;
    }

    public ReportElementPanel getPanel(ReportTableElement elt) {
        for (int i = 0; i < this.panelList.size(); ++i) {
            ReportElementPanel panel;
            if (!(this.panelList.elementAt(i) instanceof ReportElementPanel) || !(panel = (ReportElementPanel)this.panelList.elementAt(i)).getElement().getID().equals(elt.getID())) continue;
            return panel;
        }
        if (this.masterSectionPanel != null && this.masterSectionPanel.getElement().getID().equals(elt.getID())) {
            return this.masterSectionPanel;
        }
        return null;
    }

    public Vector<JPanel> getVisiblePanel() {
        return this.getVisiblePanel(this.panelList);
    }

    private Vector<JPanel> getVisiblePanel(Vector<JPanel> panelList) {
        Vector<JPanel> vec = new Vector<JPanel>();
        if (panelList == null) {
            return vec;
        }
        for (int i = 0; i < panelList.size(); ++i) {
            if (panelList.elementAt(i) instanceof ReportElementPanel) {
                if (!((ReportElementPanel)panelList.elementAt(i)).isElementVisible()) continue;
                vec.addElement(panelList.elementAt(i));
                continue;
            }
            vec.addElement(panelList.elementAt(i));
        }
        return vec;
    }

    ColumnWrap createColumnWrap(double x) {
        Vector<ReportElement> panelElt = this.getPanelElement();
        ReportLine prevCol = null;
        for (int i = 0; i < panelElt.size(); ++i) {
            ReportTableElement panel = (ReportTableElement)panelElt.elementAt(i);
            if (this.isHeaderFooter(panel)) continue;
            ColumnWrap col = new ColumnWrap(x);
            if (panel instanceof ReportSection) {
                ((ReportSection)panel).addData(col);
            } else {
                ((ReportTable)panel).addImage(col);
            }
            if (prevCol != null) {
                prevCol.setNextLine(col);
            }
            prevCol = col;
        }
        if (prevCol != null) {
            return (ColumnWrap)prevCol.getHeadNode();
        }
        return null;
    }

    GuideLine createGuideLine(double x, double y, boolean isVertical, ReportElement elt) {
        if (isVertical) {
            Vector<ReportElement> panelElt = this.getPanelElement();
            ReportLine prev = null;
            for (int i = 0; i < panelElt.size(); ++i) {
                ReportTableElement panel = (ReportTableElement)panelElt.elementAt(i);
                GuideLine gl = null;
                gl = !this.reportMain.isCm ? new GuideLine(x, isVertical, this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize) : new GuideLine(x, isVertical, this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.cmGridStepSize);
                if (panel instanceof ReportSection) {
                    ((ReportSection)panel).addData(gl);
                } else {
                    ((ReportTable)panel).addImage(gl);
                }
                if (prev != null) {
                    prev.setNextLine(gl);
                    gl.setPreviousID(prev.getID());
                }
                prev = gl;
            }
            if (prev != null) {
                return (GuideLine)prev.getHeadNode();
            }
            return null;
        }
        GuideLine gl = null;
        gl = !this.reportMain.isCm ? new GuideLine(y, isVertical, this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize) : new GuideLine(y, isVertical, this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.cmGridStepSize);
        if (elt instanceof ReportSection) {
            ((ReportSection)elt).addData(gl);
        } else {
            ((ReportTable)elt).addImage(gl);
        }
        return gl;
    }

    void removeGuideLine(ReportLine cell) {
        for (cell = cell.getHeadNode(); cell != null; cell = cell.next()) {
            for (int i = 0; i < this.panelList.size() - 1; ++i) {
                ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
                if (panel.getElement() instanceof ReportSection) {
                    ((ReportSection)panel.getElement()).removeData(cell);
                    continue;
                }
                panel.getOriginalReportTable().removeImage(cell);
            }
        }
    }

    private boolean isHeaderFooter(ReportTableElement elt) {
        if (!(elt instanceof ReportSection)) {
            return false;
        }
        return elt == this.reportMain.report.getPageHeader() || elt == this.reportMain.report.getPageFooter() || elt == this.reportMain.report.getReportHeader() || elt == this.reportMain.report.getReportFooter() || elt.getID().startsWith("RPT_HDR") || elt.getID().startsWith("RPT_FTR");
    }

    public Vector<ReportElement> getPanelElement() {
        Vector<ReportElement> vec = new Vector<ReportElement>();
        for (int i = 0; i < this.panelList.size(); ++i) {
            if (!(this.panelList.elementAt(i) instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.getElement() instanceof ReportSection) {
                vec.addElement(panel.getElement());
                continue;
            }
            vec.addElement(panel.getOriginalReportTable());
        }
        return vec;
    }

    private JSplitPane createSplitPane(Vector<JPanel> panel, int index) {
        JSplitPane splitPane = new JSplitPane(0, panel.elementAt(index), panel.size() > index + 2 ? this.createSplitPane(panel, index + 1) : (Component)panel.elementAt(index + 1));
        splitPane.setBorder(null);
        splitPane.setContinuousLayout(false);
        splitPane.addPropertyChangeListener(this);
        return splitPane;
    }

    private JPanel createButtonPanel(Vector<JPanel> panel) {
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BorderLayout());
        bPanel.add("Center", this.createButtonPanel(panel, 0));
        return bPanel;
    }

    private JPanel createButtonPanel(Vector<JPanel> panel, int index) {
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BorderLayout());
        JPanel tmp = panel.elementAt(index);
        if (tmp instanceof ReportElementPanel) {
            bPanel.add("North", ((ReportElementPanel)tmp).getButtonPanel());
            bPanel.add("Center", this.createButtonPanel(panel, index + 1));
        } else {
            Vector<JPanel> tempvect = new Vector<JPanel>();
            for (int i = 0; i < panel.size() - 1; ++i) {
                tempvect.add(panel.elementAt(i));
            }
            bPanel.add("Center", this.createEmptyButton());
        }
        return bPanel;
    }

    private JPanel createEmptyButton() {
        return this.createEmptyPanel(null);
    }

    private JPanel createEmptyPanel() {
        return this.createEmptyPanel(Color.gray);
    }

    private JPanel createEmptyPanel(Color color) {
        JPanel ePanel = new JPanel();
        ePanel.setBorder(null);
        if (color != null) {
            ePanel.setBackground(color);
        }
        return ePanel;
    }

    private void drawTable(ReportUI reportUI, ReportTable tbl, Vector<JPanel> panelList) {
        ReportElementPanel header = new ReportElementPanel(this.reportMain, reportUI, tbl.getHeader(), tbl, LanguageEncoder.getText("Table Header"));
        panelList.addElement(header);
        this.addSubSections(tbl.getHeader(), panelList, reportUI, tbl, "TH Sub_");
        if (tbl instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable mTbl = (ReportMultiSectionTable)tbl;
            for (int i = 0; i < mTbl.countRowBreakHeader(); ++i) {
                ReportElementPanel mheader = new ReportElementPanel(this.reportMain, reportUI, mTbl.getRowBreakHeader(i), mTbl, LanguageEncoder.getText("Group Header") + i);
                panelList.addElement(mheader);
                this.addSubSections(mTbl.getRowBreakHeader(i), panelList, reportUI, mTbl, "GH" + i + " Sub_");
            }
            ReportElementPanel tPanel = new ReportElementPanel(this.reportMain, reportUI, (ReportElement)mTbl.getFirstTable(), tbl, LanguageEncoder.getText("Table Data"));
            panelList.addElement(tPanel);
            for (int i = mTbl.countRowBreakFooter() - 1; i >= 0; --i) {
                ReportElementPanel mfooter = new ReportElementPanel(this.reportMain, reportUI, mTbl.getRowBreakFooter(i), mTbl, LanguageEncoder.getText("Group Footer") + i);
                panelList.addElement(mfooter);
                this.addSubSections(mTbl.getRowBreakFooter(i), panelList, reportUI, mTbl, "GF" + i + " Sub_");
            }
        } else {
            ReportElementPanel tPanel = new ReportElementPanel(this.reportMain, reportUI, tbl, LanguageEncoder.getText("Table Data"));
            panelList.addElement(tPanel);
        }
        ReportElementPanel footer = new ReportElementPanel(this.reportMain, reportUI, tbl.getFooter(), tbl, LanguageEncoder.getText("Table Footer"));
        panelList.addElement(footer);
        this.addSubSections(tbl.getFooter(), panelList, reportUI, tbl, "TF Sub_");
    }

    void setStartPanel(JPanel panel) {
        Vector<JPanel> vec = panel instanceof ReportElementPanel ? ((ReportElementPanel)panel).getVisiblePanels() : this.getVisiblePanel();
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.elementAt(i) != panel) continue;
            this.startPanel = i;
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.reportMain.isUpdating()) {
            return;
        }
        JSplitPane splitPane = (JSplitPane)evt.getSource();
        this.propertyChange(splitPane);
    }

    private synchronized void propertyChange(JSplitPane splitPane) {
        Component topPanel = splitPane.getTopComponent();
        double val = (double)splitPane.getDividerLocation() / (double)QbUtil.getPixelPerInch();
        if (val < 0.0) {
            return;
        }
        if (topPanel instanceof ReportElementPanel) {
            double existingHeight = ((ReportElementPanel)topPanel).getHeight();
            if (existingHeight - 0.001 < (double)splitPane.getDividerLocation() && (double)splitPane.getDividerLocation() < existingHeight + 0.001) {
                return;
            }
            if (((ReportElementPanel)topPanel).isReportSection() ? val == ((ReportElementPanel)topPanel).getElement().getHeight() : val == ((ReportElementPanel)topPanel).getReportTable().getHeight()) {
                return;
            }
            this.reportMain.createBackupReport();
            ((ReportElementPanel)topPanel).setHeight(val);
            this.reportMain.resetSelectedObject(true);
            this.reportMain.setModified();
            this.reportMain.updateYRuler = true;
        }
    }

    public void setIsCm(boolean isCm) {
        this.reportMain.isCm = isCm;
        if (!isCm) {
            this.reportMain.report.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
        } else {
            this.reportMain.report.setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.cmGridStepSize);
        }
    }

    public void repaintPanel() {
        int size = this.panelList.size();
        for (int i = 0; i < size - 1; ++i) {
            JPanel temp = this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
            if (!(temp instanceof ReportElementPanel)) continue;
            ReportElementPanel elt = (ReportElementPanel)temp;
            elt.resetOffScreenImage();
            elt.repaint();
        }
        if (this.masterSectionPanel != null) {
            this.masterSectionPanel.resetOffScreenImage();
            this.masterSectionPanel.repaint();
        }
    }

    private void deselectFormatGroup() {
        Vector<JPanel> temp = this.panelList;
        for (int i = 0; i < temp.size(); ++i) {
            if (!(temp.elementAt(i) instanceof ReportElementPanel)) continue;
            ReportElementPanel panel = (ReportElementPanel)temp.elementAt(i);
            panel.deselectFormatSection();
        }
        if (this.masterSectionPanel != null) {
            this.masterSectionPanel.deselectFormatSection();
        }
        this.xRuler.groupSetWidthOp = false;
        this.xRuler.repaintNull();
        try {
            this.yRuler.groupSetWidthOp = false;
            this.yRuler.repaintNull();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot repaint yRuler", ex);
        }
    }

    public void setWholeGroupWidth(double width) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElement t;
            int j;
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            if (this.reportMain.isShiftSelected) {
                for (j = 0; j < panel.groupFormat.size(); ++j) {
                    t = panel.groupFormat.elementAt(j);
                    double change = width - t.getWidth();
                    if (panel.isReportSection()) {
                        ReportSection rs = (ReportSection)panel.elt;
                        rs.shift(t, true, change);
                        continue;
                    }
                    ReportTable rt = panel.getOriginalReportTable();
                    rt.shift(t, true, change);
                }
            } else {
                for (j = 0; j < panel.groupFormat.size(); ++j) {
                    t = panel.groupFormat.elementAt(j);
                    t.setWidth(width);
                }
            }
            this.repaintPanel();
        }
    }

    public void groupFormatSetZIndex(int z) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                t.setZ(z);
            }
        }
        if (this.masterSection != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                t.setZ(z);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetHeight(double h) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                t.setHeight(h);
            }
        }
        if (this.masterSection != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                t.setHeight(h);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetRotation(double rot) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                t.setRotateAngle(rot);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                t.setRotateAngle(rot);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetBounds(double w, double h) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportTable rt;
            ReportSection rs;
            double change;
            ReportElement t;
            int j;
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            if (w >= 0.0) {
                for (j = 0; j < panel.groupFormat.size(); ++j) {
                    t = panel.groupFormat.elementAt(j);
                    change = w - t.getWidth();
                    if (panel.isReportSection()) {
                        rs = (ReportSection)panel.elt;
                        rs.shift(t, true, change);
                        continue;
                    }
                    rt = panel.getOriginalReportTable();
                    rt.shift(t, true, change);
                }
            }
            if (!(h >= 0.0)) continue;
            for (j = 0; j < panel.groupFormat.size(); ++j) {
                t = panel.groupFormat.elementAt(j);
                change = h - t.getHeight();
                if (panel.isReportSection()) {
                    rs = (ReportSection)panel.elt;
                    rs.shift(t, false, change);
                    continue;
                }
                rt = panel.getOriginalReportTable();
                rt.shift(t, false, change);
            }
        }
        if (this.masterSectionPanel != null) {
            ReportElement[] relt = ((ReportSection)this.masterSectionPanel.getElement()).getData();
            if (w >= 0.0) {
                for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                    ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                    double change = w - t.getWidth();
                    ReportElement.shift(t, relt, true, change);
                }
            }
            if (h >= 0.0) {
                for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                    ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                    double change = h - t.getHeight();
                    ReportElement.shift(t, relt, false, change);
                }
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetFont(Font font) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                t.setFont(font);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                t.setFont(font);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetFontBold(boolean doBold) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                Font font = t.getRefFont();
                int style = 0;
                if (doBold) {
                    ++style;
                }
                if (font.isItalic()) {
                    style += 2;
                }
                t.setFont(FontTable.newFont(font.getName(), style, font.getSize()));
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                Font font = t.getRefFont();
                int style = 0;
                if (doBold) {
                    ++style;
                }
                if (font.isItalic()) {
                    style += 2;
                }
                t.setFont(FontTable.newFont(font.getName(), style, font.getSize()));
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetFontItalic(boolean doItalic) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                Font font = t.getRefFont();
                int style = 0;
                if (doItalic) {
                    style += 2;
                }
                if (font.isBold()) {
                    ++style;
                }
                t.setFont(FontTable.newFont(font.getName(), style, font.getSize()));
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                Font font = t.getRefFont();
                int style = 0;
                if (doItalic) {
                    style += 2;
                }
                if (font.isBold()) {
                    ++style;
                }
                t.setFont(FontTable.newFont(font.getName(), style, font.getSize()));
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetFontUnderline(boolean doUnderline) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                t.setUnderline(doUnderline);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                t.setUnderline(doUnderline);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetFontSize(int size) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                Font font = t.getRefFont();
                t.setFont(FontTable.newFont(font.getName(), font.getStyle(), size));
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                Font font = t.getRefFont();
                t.setFont(FontTable.newFont(font.getName(), font.getStyle(), size));
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetFontFace(String fontFace) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                Font font = t.getRefFont();
                t.setFont(FontTable.newFont(fontFace, font.getStyle(), font.getSize()));
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                Font font = t.getRefFont();
                t.setFont(FontTable.newFont(fontFace, font.getStyle(), font.getSize()));
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetFontColor(Color color) {
        Report backup = this.reportMain.createBackupReport();
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                t.setFontColor(color);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                t.setFontColor(color);
            }
        }
        this.reportMain.markUndoCheckPoint(backup);
        this.repaintPanel();
    }

    public void groupFormatSetBackgroundColor(Color color, boolean forLine) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                if (t instanceof ReportSection) continue;
                ReportUtil.setBgColor(t, color, forLine);
            }
            this.repaintPanel();
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                if (t instanceof ReportSection) continue;
                ReportUtil.setBgColor(t, color, forLine);
            }
        }
    }

    public int getGroupEditElementType() {
        int type1 = -1;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement elt = panel.groupFormat.elementAt(j);
                int type2 = ReportElement.findGroupElementType(elt);
                if (type1 == -1) {
                    type1 = type2;
                }
                if (type1 == type2) continue;
                return -1;
            }
        }
        return type1;
    }

    public Font groupFormatInitFont() {
        Font font1 = null;
        Font font2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    font2 = t.getFont();
                }
                if (font1 == null) {
                    font1 = font2;
                }
                if (this.equals(font1, font2)) continue;
                return null;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    font2 = t.getFont();
                }
                if (font1 == null) {
                    font1 = font2;
                }
                if (this.equals(font1, font2)) continue;
                return null;
            }
        }
        return font1;
    }

    public boolean groupFormatInitFontUnderline() {
        Boolean underline1 = null;
        Boolean underline2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    underline2 = t.isUnderline();
                }
                if (underline1 == null) {
                    underline1 = underline2;
                }
                if (underline1 == null || underline2 == null) {
                    return false;
                }
                if (underline1.booleanValue() == underline2.booleanValue()) continue;
                return false;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    underline2 = t.isUnderline();
                }
                if (underline1 == null) {
                    underline1 = underline2;
                }
                if (underline1 == null || underline2 == null) {
                    return false;
                }
                if (underline1.booleanValue() == underline2.booleanValue()) continue;
                return false;
            }
        }
        if (underline1 != null) {
            return underline1;
        }
        return false;
    }

    public String groupFormatInitFontName() {
        String font1 = null;
        String font2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    font2 = this.getFontName(t.getFont());
                }
                if (font1 == null) {
                    font1 = font2;
                }
                if (this.equals(font1, font2)) continue;
                return null;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    font2 = this.getFontName(t.getFont());
                }
                if (font1 == null) {
                    font1 = font2;
                }
                if (this.equals(font1, font2)) continue;
                return null;
            }
        }
        return font1;
    }

    public int groupFormatInitFontStyle() {
        int font1 = -1;
        int font2 = -1;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    font2 = this.getFontStyle(t.getFont());
                }
                if (font1 == -1) {
                    font1 = font2;
                }
                if (font1 == font2) continue;
                return -1;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    font2 = this.getFontStyle(t.getFont());
                }
                if (font1 == -1) {
                    font1 = font2;
                }
                if (font1 == font2) continue;
                return -1;
            }
        }
        return font1;
    }

    public boolean groupFormatInitFontItalic() {
        Boolean font1 = null;
        Boolean font2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    font2 = this.isFontItalic(t.getFont());
                }
                if (font1 == null && font2 != null) {
                    font1 = font2;
                }
                if (font1 == null || font2 == null || font1.booleanValue() == font2.booleanValue()) continue;
                return false;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    font2 = this.isFontItalic(t.getFont());
                }
                if (font1 == null && font2 != null) {
                    font1 = font2;
                }
                if (font1 == null || font2 == null || font1.booleanValue() == font2.booleanValue()) continue;
                return false;
            }
        }
        if (font1 == null) {
            return false;
        }
        return font1;
    }

    public boolean groupFormatInitFontBold() {
        Boolean font1 = null;
        Boolean font2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    font2 = this.isFontBold(t.getFont());
                }
                if (font1 == null && font2 != null) {
                    font1 = font2;
                }
                if (font1 == null || font2 == null || font1.booleanValue() == font2.booleanValue()) continue;
                return false;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    font2 = this.isFontBold(t.getFont());
                }
                if (font1 == null && font2 != null) {
                    font1 = font2;
                }
                if (font1 == null || font2 == null || font1.booleanValue() == font2.booleanValue()) continue;
                return false;
            }
        }
        if (font1 == null) {
            return false;
        }
        return font1;
    }

    public int groupFormatInitFontSize() {
        int font1 = -1;
        int font2 = -1;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    font2 = this.getFontSize(t.getFont());
                }
                if (font1 == -1) {
                    font1 = font2;
                }
                if (font1 == font2) continue;
                return -1;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    font2 = this.getFontSize(t.getFont());
                }
                if (font1 == -1) {
                    font1 = font2;
                }
                if (font1 == font2) continue;
                return -1;
            }
        }
        return font1;
    }

    public Color groupFormatInitFontColor() {
        Color color1 = null;
        Color color2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    color2 = t.getFontColor();
                }
                if (color1 == null) {
                    color1 = color2;
                }
                if (this.equals(color1, color2)) continue;
                return null;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    color2 = t.getFontColor();
                }
                if (color1 == null) {
                    color1 = color2;
                }
                if (this.equals(color1, color2)) continue;
                return null;
            }
        }
        return color1;
    }

    public Color groupFormatInitBackgroundColor() {
        Color color1 = null;
        Color color2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader" || type == "Title") {
                    color2 = t.getBgColor();
                }
                if (color1 == null) {
                    color1 = color2;
                }
                if (this.equals(color1, color2)) continue;
                return null;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Label" || type == "Formula" || type == "Column" || type == "ColumnHeader") {
                    color2 = t.getBgColor();
                }
                if (color1 == null) {
                    color1 = color2;
                }
                if (this.equals(color1, color2)) continue;
                return null;
            }
        }
        return color1;
    }

    public ReportColumn groupFormatDualColorsInitColumn() {
        ReportColumn col1 = null;
        ReportColumn col2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Column") {
                    col2 = (ReportColumn)t;
                }
                if (col1 == null) {
                    col1 = col2;
                }
                if (this.compareDualColors(col1, col2)) continue;
                return null;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Column") {
                    col2 = (ReportColumn)t;
                }
                if (col1 == null) {
                    col1 = col2;
                }
                if (this.compareDualColors(col1, col2)) continue;
                return null;
            }
        }
        return col1;
    }

    public Color groupFormatInitBorderColor() {
        Color color1 = null;
        Color color2 = null;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                color2 = t instanceof ReportLine ? t.getBgColor() : t.getBorderColor();
                if (color1 == null) {
                    color1 = color2;
                }
                if (this.equals(color1, color2)) continue;
                return null;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                color2 = t instanceof ReportLine ? t.getBgColor() : t.getBorderColor();
                if (color1 == null) {
                    color1 = color2;
                }
                if (this.equals(color1, color2)) continue;
                return null;
            }
        }
        return color1;
    }

    public int groupFormatInitBorderThickness(BorderSide borderSide) {
        int thickness1 = -1;
        int thickness2 = -1;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                thickness2 = t.getBorder(borderSide);
                if (thickness1 == -1) {
                    thickness1 = thickness2;
                }
                if (thickness1 == thickness2) continue;
                return 0;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                thickness2 = t.getBorder(borderSide);
                if (thickness1 == -1) {
                    thickness1 = thickness2;
                }
                if (thickness1 == thickness2) continue;
                return 0;
            }
        }
        if (thickness1 == -1) {
            return 0;
        }
        return thickness1;
    }

    public int groupFormatInitRoundCornerRadius() {
        int roundCornerRadius1 = -1;
        int roundCornerRadius2 = -1;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                roundCornerRadius2 = t.getRoundCornerRadius();
                if (roundCornerRadius1 == -1) {
                    roundCornerRadius1 = roundCornerRadius2;
                }
                if (roundCornerRadius1 == roundCornerRadius2) continue;
                return 0;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                roundCornerRadius2 = t.getRoundCornerRadius();
                if (roundCornerRadius1 == -1) {
                    roundCornerRadius1 = roundCornerRadius2;
                }
                if (roundCornerRadius1 == roundCornerRadius2) continue;
                return 0;
            }
        }
        if (roundCornerRadius1 == -1) {
            return 0;
        }
        return roundCornerRadius1;
    }

    public boolean[] groupFormatInitRoundCornersArray() {
        boolean[] roundCornersArray = new boolean[4];
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            ReportElement t = panel.groupFormat.elementAt(0);
            return t.getRoundCornersArray();
        }
        if (this.masterSectionPanel != null && this.masterSectionPanel.groupFormat.size() > 0) {
            ReportElement t = this.masterSectionPanel.groupFormat.elementAt(0);
            return t.getRoundCornersArray();
        }
        return roundCornersArray;
    }

    public double[] groupFormatInitBounds() {
        double h1 = -1.0;
        double w1 = -1.0;
        double h2 = -1.0;
        double w2 = -1.0;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                w2 = t.getWidth();
                h2 = t.getHeight();
                if (w1 == -1.0) {
                    w1 = w2;
                }
                if (h1 == -1.0) {
                    h1 = h2;
                }
                if (w1 != w2) {
                    return null;
                }
                if (h1 == h2) continue;
                return null;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                w2 = t.getWidth();
                h2 = t.getHeight();
                if (w1 == -1.0) {
                    w1 = w2;
                }
                if (h1 == -1.0) {
                    h1 = h2;
                }
                if (w1 != w2) {
                    return null;
                }
                if (h1 == h2) continue;
                return null;
            }
        }
        if (w1 == -1.0 || h1 == -1.0) {
            return null;
        }
        return new double[]{w1, h1};
    }

    public double groupFormatInitRotation() {
        double rot1 = -1.0;
        double rot2 = -1.0;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                rot2 = t.getRotateAngle();
                if (rot1 == -1.0) {
                    rot1 = rot2;
                }
                if (rot1 == rot2) continue;
                return -1.0;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                rot2 = t.getAlign();
                if (rot1 == -1.0) {
                    rot1 = rot2;
                }
                if (rot1 == rot2) continue;
                return -1.0;
            }
        }
        return rot1;
    }

    public int groupFormatInitHAlignment() {
        int align1 = -1;
        int align2 = -1;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                align2 = t.getAlign();
                if (align1 == -1) {
                    align1 = align2;
                }
                if (align1 == align2) continue;
                return -1;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                align2 = t.getAlign();
                if (align1 == -1) {
                    align1 = align2;
                }
                if (align1 == align2) continue;
                return -1;
            }
        }
        return align1;
    }

    public int groupFormatInitVAlignment() {
        int valign1 = -1;
        int valign2 = -1;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                valign2 = t.getVAlign();
                if (valign1 == -1) {
                    valign1 = valign2;
                }
                if (valign1 == valign2) continue;
                return -1;
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                valign2 = t.getVAlign();
                if (valign1 == -1) {
                    valign1 = valign2;
                }
                if (valign1 == valign2) continue;
                return -1;
            }
        }
        return valign1;
    }

    private boolean compareDualColors(ReportColumn col1, ReportColumn col2) {
        if (col1 == null || col2 == null) {
            return false;
        }
        if (col1.getAlternateRow() != col2.getAlternateRow()) {
            return false;
        }
        if (col1.isDualColorOnRowBreak() != col2.isDualColorOnRowBreak()) {
            return false;
        }
        if (!this.equals(col1.getBgColor2(), col2.getBgColor2())) {
            return false;
        }
        if (!this.equals(col1.getFontColor2(), col2.getFontColor2())) {
            return false;
        }
        if (!this.equals(col1.getFont2(), col2.getFont2())) {
            return false;
        }
        if (col1.isUnderline2() != col2.isUnderline2()) {
            return false;
        }
        int[] index1 = col1.getDualColorColInfoIndex();
        int[] index2 = col2.getDualColorColInfoIndex();
        if (index1 == null && index2 == null) {
            return true;
        }
        if (index1 == null || index2 == null) {
            return false;
        }
        if (index1.length != index2.length) {
            return false;
        }
        for (int i = 0; i < index1.length; ++i) {
            if (index1[i] == index2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equals(Color c1, Color c2) {
        if (c1 == null && c2 == null) {
            return false;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equals(c2);
    }

    private boolean equals(Font f1, Font f2) {
        if (f1 == null && f2 == null) {
            return false;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1.equals(f2);
    }

    private boolean equals(String f1, String f2) {
        if (f1 == null && f2 == null) {
            return false;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1.equals(f2);
    }

    private String getFontName(Font font) {
        if (font == null) {
            return null;
        }
        return font.getName();
    }

    private int getFontStyle(Font font) {
        if (font == null) {
            return -1;
        }
        return font.getStyle();
    }

    private Boolean isFontItalic(Font font) {
        if (font == null) {
            return null;
        }
        return font.isItalic();
    }

    private Boolean isFontBold(Font font) {
        if (font == null) {
            return null;
        }
        return font.isBold();
    }

    private int getFontSize(Font font) {
        if (font == null) {
            return -1;
        }
        return font.getSize();
    }

    public void groupResizeToFitContent(boolean isFit) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                t.setResizeToFitContent(isFit);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                t.setResizeToFitContent(isFit);
            }
        }
        this.repaintPanel();
    }

    public void groupWordwrap(boolean isWrap) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                String type;
                ReportElement t = panel.groupFormat.elementAt(j);
                if (t instanceof SubReportObject || t instanceof ReportRTFObject || (type = ReportElement.getElementType(t)) != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader" && type != "Title") continue;
                t.setNoWrap(!isWrap);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                String type;
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                if (t instanceof SubReportObject || t instanceof ReportRTFObject || (type = ReportElement.getElementType(t)) != "Label" && type != "Formula" && type != "Column" && type != "ColumnHeader") continue;
                t.setNoWrap(!isWrap);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetColumnDualColors(int rowIndex, boolean rowBreak, int[] colInfoIndex, Color bgColor, Color fontColor, Font fontStyle, boolean isUnderline) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Column") continue;
                ReportColumn c = (ReportColumn)t;
                c.setAlternateRow(rowIndex);
                c.setDualColorOnRowBreak(rowBreak);
                c.setDualColorColInfoIndex(colInfoIndex);
                c.setBgColor2(bgColor);
                c.setFontColor2(fontColor);
                c.setFont2(fontStyle);
                c.setUnderline2(isUnderline);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Column") continue;
                ReportColumn c = (ReportColumn)t;
                c.setAlternateRow(rowIndex);
                c.setDualColorOnRowBreak(rowBreak);
                c.setDualColorColInfoIndex(colInfoIndex);
                c.setBgColor2(bgColor);
                c.setFontColor2(fontColor);
                c.setFont2(fontStyle);
                c.setUnderline2(isUnderline);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetWebLink(String link, String hint, String target) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                t.setLink(link);
                t.setHint(hint);
                t.setTarget(target);
                t.setDrillDownName(null);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                t.setLink(link);
                t.setHint(hint);
                t.setTarget(target);
                t.setDrillDownName(null);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetBorderThickness(int thickness, BorderSide borderSide) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                ReportUtil.setBorderThickness(t, thickness, t instanceof ReportLine, borderSide);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                ReportUtil.setBorderThickness(t, thickness, t instanceof ReportLine, borderSide);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetBorderRoundCorners(int thickness, int roundCornerRadius, boolean[] roundCornersArray, boolean forLine, BorderSide borderSide) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                ReportUtil.setBorderThickness(t, thickness, forLine, borderSide);
                t.setRoundCornerRadius(roundCornerRadius);
                t.setRoundCornersArray(roundCornersArray);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                ReportUtil.setBorderThickness(t, thickness, forLine, borderSide);
                t.setRoundCornerRadius(roundCornerRadius);
                t.setRoundCornersArray(roundCornersArray);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetBorderColor(Color color) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                if (t instanceof TableOfContents) continue;
                if (t instanceof ReportLine) {
                    t.setBgColor(color);
                }
                t.setBorderColor(color);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                if (t instanceof TableOfContents) continue;
                if (t instanceof ReportLine) {
                    t.setBgColor(color);
                }
                t.setBorderColor(color);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetAlign(short align) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                t.setAlign(align);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                t.setAlign(align);
            }
        }
        this.repaintPanel();
    }

    public void groupFormatSetVAlign(short align) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                ReportElement t = panel.groupFormat.elementAt(j);
                t.setVAlign(align);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                t.setVAlign(align);
            }
        }
        this.repaintPanel();
    }

    public void deleteGroup() {
        ReportElementPanel panel;
        int i;
        Vector<ReportElement> eltList = new Vector<ReportElement>();
        Vector<ReportElementPanel> plList = new Vector<ReportElementPanel>();
        for (i = 0; i < this.panelList.size() - 1; ++i) {
            panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                eltList.add(panel.groupFormat.elementAt(j));
                plList.add(panel);
            }
        }
        for (i = 0; i < eltList.size(); ++i) {
            this.reportMain.deleteElt((ReportElement)eltList.elementAt(i), (ReportElementPanel)plList.elementAt(i), false);
        }
        for (int j = 0; j < this.panelList.size() - 1; ++j) {
            panel = (ReportElementPanel)this.panelList.elementAt(j);
            if (panel.drawBoundingBox) {
                panel.drawBoundingBox = false;
                panel.isBoundingBoxOp = false;
                continue;
            }
            if (panel.groupFormat.size() <= 0) continue;
            panel.isResizeOp = false;
            panel.isDragOp = false;
        }
        if (this.masterSectionPanel != null) {
            if (this.masterSectionPanel.groupFormat.size() > 0) {
                for (i = 0; i < this.masterSectionPanel.groupFormat.size(); ++i) {
                    ReportElement t = this.masterSectionPanel.groupFormat.elementAt(i);
                    this.reportMain.deleteElt(t, this.masterSectionPanel, false);
                }
            }
            if (this.masterSectionPanel.drawBoundingBox) {
                this.masterSectionPanel.drawBoundingBox = false;
                this.masterSectionPanel.isBoundingBoxOp = false;
            } else if (this.masterSectionPanel.groupFormat.size() > 0) {
                this.masterSectionPanel.isResizeOp = false;
                this.masterSectionPanel.isDragOp = false;
            }
        }
        this.deselectFormatGroup();
    }

    public void groupFormatSetDataFormat(IFormat selectedFormat, IFormat initFormat) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            for (int j = 0; j < panel.groupFormat.size(); ++j) {
                IFormat elementFormat;
                ReportElement t = panel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type == "Formula") {
                    elementFormat = ((ReportCell)t).getDataFormat();
                    if (elementFormat == null) {
                        ((ReportCell)t).setDataFormat(FormatUtil.createFormat(DataType.mapType(((ReportCell)t).getSQLType()), this.reportMain.report.getLocale(), this.reportMain.report.getTimeZone()));
                        elementFormat = ((ReportCell)t).getDataFormat();
                    }
                    if (!FormatUtil.isFormatAppliabled(selectedFormat, elementFormat)) continue;
                    ((ReportCell)t).setDataFormat(initFormat);
                    continue;
                }
                if (type != "Column" || !FormatUtil.isFormatAppliabled(selectedFormat, elementFormat = ((ReportColumn)t).getDataFormat())) continue;
                ((ReportColumn)t).setDataFormat(initFormat);
            }
        }
        if (this.masterSectionPanel != null) {
            for (int j = 0; j < this.masterSectionPanel.groupFormat.size(); ++j) {
                ReportElement t = this.masterSectionPanel.groupFormat.elementAt(j);
                String type = ReportElement.getElementType(t);
                if (type != "Formula") continue;
                IFormat elementFormat = ((ReportCell)t).getDataFormat();
                if (elementFormat == null) {
                    ((ReportCell)t).setDataFormat(FormatUtil.createFormat(DataType.mapType(((ReportCell)t).getSQLType()), this.reportMain.report.getLocale(), this.reportMain.report.getTimeZone()));
                    elementFormat = ((ReportCell)t).getDataFormat();
                }
                if (!FormatUtil.isFormatAppliabled(selectedFormat, elementFormat)) continue;
                ((ReportCell)t).setDataFormat(initFormat);
            }
        }
        this.repaintPanel();
    }

    public boolean isNullSelection() {
        int counter = 0;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            ++counter;
        }
        if (this.masterSectionPanel != null && this.masterSectionPanel.groupFormat.size() != 0) {
            ++counter;
        }
        return counter == 0;
    }

    public boolean isSinglePanel() {
        int counter = 0;
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            ++counter;
        }
        if (this.masterSectionPanel != null && this.masterSectionPanel.groupFormat.size() != 0) {
            ++counter;
        }
        return counter == 1;
    }

    public ReportElementPanel getSinglePanel() {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            return panel;
        }
        if (this.masterSectionPanel != null && this.masterSectionPanel.groupFormat.size() != 0) {
            return this.masterSectionPanel;
        }
        return null;
    }

    public int getStartPanel() {
        int i;
        for (i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() != 0) break;
        }
        return i;
    }

    public int getEndPanel() {
        int selectedPanel = 0;
        for (int i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            selectedPanel = i;
        }
        return selectedPanel;
    }

    public void setGroupAlignment(short align) {
        this.setBoundingBoxForGroupAlign();
        for (int i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.setGroupAlignment(align, false);
        }
        if (this.masterSectionPanel != null) {
            this.masterSectionPanel.setGroupAlignment(align, false);
        }
    }

    public void setGroupVerticalAlignment(short align) {
        this.setBoundingBoxForGroupAlign();
        for (int i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.setGroupVerticalAlignment(align, false);
        }
        if (this.masterSectionPanel != null) {
            this.masterSectionPanel.setGroupVerticalAlignment(align, false);
        }
    }

    public void snapLeft(ReportElement elt) {
        for (int i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.snapLeft(elt);
        }
        this.reportMain.deselectGroupOption();
    }

    public void snapMidlineV(ReportElement elt) {
        for (int i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.snapMidlineV(elt);
        }
        this.reportMain.deselectGroupOption();
    }

    public void snapRight(ReportElement elt) {
        for (int i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.snapRight(elt);
        }
        this.reportMain.deselectGroupOption();
    }

    public void snapAllLeft(ReportElement elt) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.snapAllLeft(elt);
        }
    }

    public void snapAllMidlineV(ReportElement elt) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.snapAllMidlineV(elt);
        }
    }

    public void snapAllRight(ReportElement elt) {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.snapAllRight(elt);
        }
    }

    public void resetDragAndResizeAndPopupOps() {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.isPopupTrigger = false;
            panel.isResizeOp = false;
            panel.isDragOp = false;
        }
        if (this.masterSectionPanel != null) {
            this.masterSectionPanel.isPopupTrigger = false;
            this.masterSectionPanel.isResizeOp = false;
            this.masterSectionPanel.isDragOp = false;
        }
    }

    private void cutToClipBoard(ReportElementPanel panel) {
        ReportElement relt;
        this.reportMain.markUndoCheckPoint();
        if (this.clipBoard.size() != 0) {
            this.panelType = 0;
            this.clipBoard = new Vector();
        }
        this.pasteToAddFormula.clear();
        this.isCutOp = true;
        ReportElement[] rpt = new ReportElement[panel.groupFormat.size()];
        for (int i = 0; i < panel.groupFormat.size(); ++i) {
            rpt[i] = panel.groupFormat.elementAt(i);
        }
        double x0 = QbUtil.toInch(ReportElement.findMinX(rpt));
        double y0 = QbUtil.toInch(ReportElement.findMinY(rpt));
        Vector<ReportElement> temp = panel.groupFormat;
        for (int i = 0; i < temp.size(); ++i) {
            relt = temp.elementAt(i);
            double x = relt.getX();
            double y = relt.getY();
            relt.setX(x - x0);
            relt.setY(y - y0);
        }
        for (int j = 0; j < temp.size(); ++j) {
            relt = temp.elementAt(j);
            if (relt instanceof ReportColumn) {
                ReportColumn column = (ReportColumn)relt;
                ReportCell formula = null;
                formula = this.getFormula(column);
                this.clipBoard.addElement(formula);
                continue;
            }
            this.clipBoard.addElement(relt);
        }
        this.panelType = panel.getElement() instanceof ReportSection ? 1 : 2;
        for (int k = 0; k < temp.size(); ++k) {
            ReportElement relt2 = temp.elementAt(k);
            int tempSize = temp.size();
            this.reportMain.deleteElt(relt2, panel, false);
            if (tempSize <= temp.size()) continue;
            --k;
        }
        panel.deselectFormatSection();
        if (this.clipBoard.size() != 0) {
            this.enablePaste();
        }
    }

    private void copyToClipBoard(ReportElementPanel panel) {
        if (this.clipBoard.size() != 0) {
            this.panelType = 0;
            this.clipBoard = new Vector();
        }
        this.isCutOp = false;
        this.pasteToAddFormula.clear();
        ReportElement[] rpt = new ReportElement[panel.groupFormat.size()];
        for (int i = 0; i < panel.groupFormat.size(); ++i) {
            rpt[i] = panel.groupFormat.elementAt(i);
        }
        double x0 = QbUtil.toInch(ReportElement.findMinX(rpt));
        double y0 = QbUtil.toInch(ReportElement.findMinY(rpt));
        Vector<ReportElement> temp = new Vector<ReportElement>();
        for (int i = 0; i < panel.groupFormat.size(); ++i) {
            ReportElement relt = panel.groupFormat.elementAt(i);
            temp.addElement(relt);
        }
        for (int j = 0; j < temp.size(); ++j) {
            ReportElement element = (ReportElement)temp.elementAt(j);
            ReportCell cell = new ReportCell();
            if (panel.getElement() instanceof ReportSection || panel.getElement() instanceof ReportTable && !(element instanceof ReportColumn)) {
                if (element instanceof ReportGrid) {
                    ReportGrid newGrid = new ReportGrid();
                    newGrid.copy((ReportGrid)element);
                    cell = newGrid;
                } else if (element instanceof ReportLine) {
                    ReportLine newLine = new ReportLine();
                    newLine.copy((ReportLine)element);
                    cell = newLine;
                } else if (element instanceof ReportChartObject) {
                    ReportChartObject newChart = new ReportChartObject();
                    newChart.copy((ReportChartObject)element);
                    cell = newChart;
                } else if (element instanceof ReportImage) {
                    ReportImage newImage = new ReportImage();
                    newImage.copy((ReportImage)element);
                    cell = newImage;
                } else if (element instanceof SubReportObject) {
                    SubReportObject newSubReport = new SubReportObject();
                    newSubReport.copy((SubReportObject)element);
                    cell = newSubReport;
                } else if (element instanceof ReportRTFObject) {
                    ReportRTFObject newrtf = new ReportRTFObject(null);
                    newrtf.copy((ReportRTFObject)element);
                    cell = newrtf;
                } else if (element instanceof CBColumnHeader) {
                    CBColumnHeader newch = new CBColumnHeader();
                    newch.copy((CBColumnHeader)element);
                    cell = newch;
                } else if (element instanceof CBAggrColHeader) {
                    CBAggrColHeader newch = new CBAggrColHeader();
                    newch.copy((CBAggrColHeader)element);
                    cell = newch;
                } else if (element instanceof RBColumnHeader) {
                    RBColumnHeader newch = new RBColumnHeader();
                    newch.copy((RBColumnHeader)element);
                    cell = newch;
                } else if (element instanceof ColumnHeader) {
                    ColumnHeader newch = new ColumnHeader();
                    newch.copy((ColumnHeader)element);
                    cell = newch;
                } else if (element instanceof TableOfContents) {
                    TableOfContents newtoc = new TableOfContents();
                    newtoc.copy((TableOfContents)element);
                    cell = newtoc;
                } else {
                    cell.copy((ReportCell)element);
                }
                double x = cell.getX();
                double y = cell.getY();
                cell.setX(x - x0);
                cell.setY(y - y0);
                this.clipBoard.addElement(cell);
                continue;
            }
            if (!(panel.getElement() instanceof ReportTable) || !(element instanceof ReportColumn)) continue;
            ReportColumn column = (ReportColumn)element;
            ReportCell formula = null;
            cell = formula = this.getFormula(column);
            double x = cell.getX();
            double y = cell.getY();
            cell.setX(x - x0);
            cell.setY(y - y0);
            this.clipBoard.addElement(cell);
        }
        this.panelType = panel.getElement() instanceof ReportSection ? 1 : 2;
        if (this.clipBoard.size() != 0) {
            this.enablePaste();
        }
    }

    private ReportCell getFormula(ReportColumn column) {
        ReportCell formulaCell = new ReportCell();
        formulaCell.setX(column.getX());
        formulaCell.setY(column.getY());
        String tablename = column.getDBTableName();
        String referencename = column.getText();
        if (tablename != null && tablename.length() > 0) {
            referencename = tablename + "." + referencename;
        }
        Formula formula = new Formula(this.nextFormulaName(), "{" + referencename + "}");
        this.pasteToAddFormula.add(formula);
        formulaCell.setFormulaObj(formula);
        return formulaCell;
    }

    private String nextFormulaName() {
        return this.reportMain.selectedPanel.nextFormulaName();
    }

    public ReportElement[] getSelectedGroup(ReportElementPanel panel) {
        if (panel == null) {
            return new ReportElement[0];
        }
        ReportElement[] rpt = new ReportElement[panel.groupFormat.size()];
        for (int i = 0; i < panel.groupFormat.size(); ++i) {
            rpt[i] = panel.groupFormat.elementAt(i);
        }
        panel.deselectFormatSection();
        return rpt;
    }

    public void pasteFromClipBoard(ReportElementPanel panel) {
        this.pasteFromClipBoard(panel, -1.0, -1.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pasteFromClipBoard(ReportElementPanel panel, double w, double h) {
        ReportElement elt = panel.getElement();
        int i = 0;
        while (true) {
            block15: {
                Object cell;
                block19: {
                    ReportElement element;
                    block32: {
                        Object newtoc;
                        block33: {
                            block16: {
                                block17: {
                                    block29: {
                                        block31: {
                                            block30: {
                                                block28: {
                                                    block27: {
                                                        ReportCell newCh;
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block21: {
                                                                                block20: {
                                                                                    block18: {
                                                                                        if (i >= this.clipBoard.size()) break block16;
                                                                                        element = this.clipBoard.elementAt(i);
                                                                                        if (!(elt instanceof ReportSection)) break block17;
                                                                                        cell = new ReportCell();
                                                                                        if (!(element instanceof ReportGrid)) break block18;
                                                                                        ReportGrid newGrid = new ReportGrid();
                                                                                        newGrid.copy((ReportGrid)element);
                                                                                        cell = newGrid;
                                                                                        break block19;
                                                                                    }
                                                                                    if (!(element instanceof ReportLine)) break block20;
                                                                                    ReportLine newLine = new ReportLine();
                                                                                    newLine.copy((ReportLine)element);
                                                                                    cell = newLine;
                                                                                    break block19;
                                                                                }
                                                                                if (!(element instanceof ReportChartObject)) break block21;
                                                                                ReportChartObject newChart = new ReportChartObject();
                                                                                newChart.copy((ReportChartObject)element);
                                                                                cell = newChart;
                                                                                break block19;
                                                                            }
                                                                            if (!(element instanceof ReportImage)) break block22;
                                                                            ReportImage newImage = new ReportImage();
                                                                            newImage.copy((ReportImage)element);
                                                                            cell = newImage;
                                                                            break block19;
                                                                        }
                                                                        if (!(element instanceof SubReportObject)) break block23;
                                                                        SubReportObject newSubReport = new SubReportObject();
                                                                        newSubReport.copy((SubReportObject)element);
                                                                        if (w != -1.0 && h != -1.0 && w != 1.0 && h != 0.3) {
                                                                            newSubReport.setWidth(w);
                                                                            newSubReport.setHeight(h);
                                                                        }
                                                                        cell = newSubReport;
                                                                        break block19;
                                                                    }
                                                                    if (!(element instanceof ReportRTFObject)) break block24;
                                                                    ReportRTFObject newrtf = new ReportRTFObject(null);
                                                                    newrtf.copy((ReportRTFObject)element);
                                                                    cell = newrtf;
                                                                    break block19;
                                                                }
                                                                if (!(element instanceof CBColumnHeader)) break block25;
                                                                newCh = new CBColumnHeader();
                                                                ((CBColumnHeader)newCh).copy((CBColumnHeader)element);
                                                                cell = newCh;
                                                                break block19;
                                                            }
                                                            if (!(element instanceof CBAggrColHeader)) break block26;
                                                            newCh = new CBAggrColHeader();
                                                            ((CBAggrColHeader)newCh).copy((CBAggrColHeader)element);
                                                            cell = newCh;
                                                            break block19;
                                                        }
                                                        if (!(element instanceof RBColumnHeader)) break block27;
                                                        newCh = new RBColumnHeader();
                                                        ((RBColumnHeader)newCh).copy((RBColumnHeader)element);
                                                        cell = newCh;
                                                        break block19;
                                                    }
                                                    if (!(element instanceof ColumnHeader)) break block28;
                                                    ColumnHeader newch = new ColumnHeader();
                                                    newch.copy((ColumnHeader)element);
                                                    cell = newch;
                                                    break block19;
                                                }
                                                if (!(element instanceof TableOfContents)) break block29;
                                                if (RulerPanel.isReportHeader(elt) || RulerPanel.isTableHeader(elt)) break block30;
                                                new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Can only place TableOfContents in Report Header or Table Header section/sub-section."));
                                                break block15;
                                            }
                                            if (this.reportMain.report.getTableOfContentsObject() != null) break block31;
                                            newtoc = new TableOfContents();
                                            ((TableOfContents)newtoc).copy((TableOfContents)element);
                                            cell = newtoc;
                                            break block19;
                                        }
                                        new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Can only have one table of Content Object per report"));
                                        break block15;
                                    }
                                    if (this.pasteToAddFormula.size() == 0) break block32;
                                    newtoc = this.pasteToAddFormula.iterator();
                                    break block33;
                                }
                                if (elt instanceof ReportTable) {
                                    if (element instanceof TableOfContents) {
                                        new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Can only place TableOfContents in Report Header or Table Header section/sub-section."));
                                        break block15;
                                    } else {
                                        if (RulerPanel.isFormulaForTableData(element)) {
                                            String msg = LanguageEncoder.getText("Cannot paste Label or Formula to Table Data section.");
                                            new JMessageDialog((Frame)this.reportMain, LanguageEncoder.getText("Warning"), msg);
                                            return;
                                        }
                                        cell = (ReportCell)element;
                                        ReportTable table = (ReportTable)elt;
                                        if (cell instanceof ReportImage) {
                                            table.addImage((ReportImage)cell);
                                        } else if (cell instanceof ReportRTFObject) {
                                            table.addRTFObject((ReportRTFObject)cell);
                                        } else if (cell instanceof SubReportObject) {
                                            table.addSubReport((SubReportObject)cell);
                                        }
                                        ((ReportElement)cell).setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                                        ((ReportElement)cell).setX(QbUtil.toInch(this.pasteX) + ((ReportElement)cell).getX());
                                        ((ReportElement)cell).setY(QbUtil.toInch(this.pasteY) + ((ReportElement)cell).getY());
                                        ((ReportElement)cell).setID("");
                                        ((ReportElement)cell).setSnap((short)0);
                                        ((ReportElement)cell).setVSnap((short)0);
                                    }
                                }
                                break block15;
                            }
                            panel.repaintPanel();
                            if (this.clipBoard.size() == 0) {
                                this.disablePaste();
                            }
                            return;
                        }
                        while (newtoc.hasNext()) {
                            Object e = newtoc.next();
                            Formula f = (Formula)e;
                            try {
                                this.reportMain.selectedPanel.addFormula(f);
                            }
                            catch (Exception e2) {
                                LOGGER.log(Level.WARNING, "Can't add formula", e2);
                            }
                        }
                        this.pasteToAddFormula.clear();
                    }
                    ((ReportCell)cell).copy((ReportCell)element);
                }
                ((ReportElement)cell).setSnapToGrid(this.reportMain.report.snapToGrid, this.reportMain.isCm, this.reportMain.report.gridStepSize);
                ((ReportElement)cell).setX(QbUtil.toInch(this.pasteX) + ((ReportElement)cell).getX());
                ((ReportElement)cell).setY(QbUtil.toInch(this.pasteY) + ((ReportElement)cell).getY());
                ((ReportElement)cell).setID("");
                ((ReportElement)cell).setSnap((short)0);
                ((ReportElement)cell).setVSnap((short)0);
                ((ReportSection)elt).addData((ReportCell)cell);
            }
            ++i;
        }
    }

    private static boolean isFormulaForTableData(ReportElement cell) {
        return !(cell instanceof ReportImage) && !(cell instanceof ReportRTFObject) && !(cell instanceof SubReportObject);
    }

    void resetClipBoard() {
        this.clipBoard = new Vector();
        this.panelType = 0;
    }

    void enablePaste() {
        this.reportMain.menuBar.setPasteEnabled(true);
        this.reportMain.designPanel.designToolBar.setPasteEnabled(true);
    }

    void disablePaste() {
        this.reportMain.menuBar.setPasteEnabled(false);
        this.reportMain.designPanel.designToolBar.setPasteEnabled(false);
    }

    void cutToClipBoard() {
        ReportElementPanel panel = this.reportMain.selectedPanel;
        this.cutToClipBoard(panel);
        this.resetBoundingBox(panel);
    }

    void copyToClipBoard() {
        this.copyToClipBoard(this.reportMain.selectedPanel);
        this.resetBoundingBox(this.reportMain.selectedPanel);
    }

    private void resetBoundingBox(ReportElementPanel panel) {
        this.reportMain.setModified();
        panel.isResizeBoundingBoxOp = false;
        panel.drawBoundingBox = false;
        this.reportMain.setCopyCutEnabled(false);
        panel.diffY = -1;
        panel.diffX = -1;
        panel.previousY = -1;
        panel.previousX = -1;
        panel.selectionPreviousY = -1;
        panel.selectionPreviousX = -1;
        panel.selectionDiffY = -1;
        panel.selectionDiffX = -1;
        this.isSelecting = false;
    }

    void repaintButtons() {
        for (int i = 0; i < this.panelList.size() - 1; ++i) {
            ReportElementPanel panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.buttonReleased();
        }
    }

    private void createMasterSection(ReportUI reportUI) {
        try {
            ReportTreeTable treeTable = (ReportTreeTable)this.reportMain.report.getReportTables().elementAt(0);
            this.masterSection = treeTable.getMasterSection();
            this.masterSectionPanel = new MasterSectionPanel(this.reportMain, reportUI, this.masterSection, treeTable.getFirstTable(), "Master Section");
            JSplitPane splitPane = new JSplitPane(0, this.masterSectionPanel, this.createEmptyPanel(null));
            splitPane.setBorder(null);
            splitPane.setContinuousLayout(false);
            splitPane.addPropertyChangeListener(this);
            this.masterSectionScrollPane = new JScrollPane();
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            if (splitPane.getPreferredSize().getHeight() < (double)QbUtil.toPixel(MAX_YHEIGHT)) {
                Dimension spDimension = splitPane.getPreferredSize();
                mainPanel.setMinimumSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), QbUtil.toPixel(MAX_YHEIGHT)));
                mainPanel.setPreferredSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), QbUtil.toPixel(MAX_YHEIGHT)));
                mainPanel.setSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), QbUtil.toPixel(MAX_YHEIGHT)));
            } else {
                Dimension spDimension = splitPane.getPreferredSize();
                mainPanel.setMinimumSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), Double.valueOf(spDimension.getHeight()).intValue()));
                mainPanel.setPreferredSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), Double.valueOf(spDimension.getHeight()).intValue()));
                mainPanel.setSize(new Dimension(Double.valueOf(spDimension.getWidth()).intValue(), Double.valueOf(spDimension.getHeight()).intValue()));
            }
            mainPanel.add((Component)splitPane, "Center");
            this.dividerSize = splitPane.getDividerSize();
            this.masterSectionScrollPane.getViewport().add(mainPanel);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create master section", ex);
            this.masterSectionScrollPane = null;
        }
    }

    JScrollPane getMasterSectionScrollPane() {
        return this.masterSectionScrollPane;
    }

    ReportElementPanel getMasterSectionPanel() {
        return this.masterSectionPanel;
    }

    private void addSubSections(ReportSection parent, Vector<JPanel> panellist, ReportUI reportUI, ReportTable table, String prefix) {
        ReportElementPanel epanel = null;
        if (parent.getSectionCount() > 0) {
            for (int i = 0; i < parent.getSectionCount(); ++i) {
                try {
                    epanel = new ReportElementPanel(this.reportMain, reportUI, parent.getSection(i), table, prefix + i);
                    panellist.addElement(epanel);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Cannot add subsection panel", ex);
                }
            }
        }
    }

    int getDividerSize() {
        return this.dividerSize;
    }

    private void setBoundingBoxForGroupAlign() {
        ReportElementPanel panel;
        int i;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        for (i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            panel = (ReportElementPanel)this.panelList.elementAt(i);
            if (panel.groupFormat.size() == 0) continue;
            panel.setBoundingBoxForGroupAlign();
            if (panel.boundingX < minX) {
                minX = panel.boundingX;
            }
            if (panel.boundingY < minY) {
                minY = panel.boundingY;
            }
            if (panel.boundingX + panel.boundingWidth > maxX) {
                maxX = panel.boundingX + panel.boundingWidth;
            }
            if (panel.boundingY + panel.boundingHeight <= maxY) continue;
            maxY = panel.boundingY + panel.boundingWidth;
        }
        if (this.masterSectionPanel != null && this.masterSectionPanel.groupFormat.size() > 0) {
            this.masterSectionPanel.setBoundingBoxForGroupAlign();
            if (this.masterSectionPanel.boundingX < minX) {
                minX = this.masterSectionPanel.boundingX;
            }
            if (this.masterSectionPanel.boundingY < minY) {
                minY = this.masterSectionPanel.boundingY;
            }
            if (this.masterSectionPanel.boundingX + this.masterSectionPanel.boundingWidth > maxX) {
                maxX = this.masterSectionPanel.boundingX + this.masterSectionPanel.boundingWidth;
            }
            if (this.masterSectionPanel.boundingY + this.masterSectionPanel.boundingHeight > maxY) {
                maxY = this.masterSectionPanel.boundingY + this.masterSectionPanel.boundingWidth;
            }
        }
        for (i = this.getStartPanel(); i < this.panelList.size() - 1; ++i) {
            panel = (ReportElementPanel)this.panelList.elementAt(i);
            panel.boundingX = minX;
            panel.boundingWidth = maxX - minX;
            panel.boundingY = minY;
            panel.boundingHeight = maxY - minY;
        }
        if (this.masterSectionPanel != null && this.masterSectionPanel.groupFormat.size() > 0) {
            this.masterSectionPanel.boundingX = minX;
            this.masterSectionPanel.boundingWidth = maxX - minX;
            this.masterSectionPanel.boundingY = minY;
            this.masterSectionPanel.boundingHeight = maxY - minY;
        }
    }

    public void setViewPosition(ReportElementPanel panel, ReportElement element) {
        int resY;
        int x = element.getXPos();
        int y = 0;
        Vector<JPanel> panels = this.getVisiblePanel();
        for (JPanel obj : panels) {
            if (!(obj instanceof ReportElementPanel)) continue;
            ReportElementPanel p = (ReportElementPanel)obj;
            if (p == panel) break;
            y += p.getHeight();
            y += this.getDividerSize();
        }
        if (element.getYPos() < panel.getHeight()) {
            y += element.getYPos();
        }
        JViewport viewport = this.getViewport();
        Point pt = viewport.getViewPosition();
        Rectangle rect = viewport.getBounds();
        if ((double)x >= pt.getX() && (double)y >= pt.getY() && (double)(x + element.getWidthOfElement()) <= pt.getX() + (double)rect.width && (double)(y + element.getHeightOfElement()) <= pt.getY() + (double)rect.height) {
            return;
        }
        int resX = x - rect.width / 2 + element.getWidthOfElement() / 2;
        if (resX < 0) {
            resX = 0;
        }
        if ((resY = y - rect.height / 2 + element.getHeightOfElement() / 2) < 0) {
            resY = 0;
        }
        viewport.setViewPosition(new Point(resX, resY));
    }

    private static boolean isReportHeader(ReportElement e) {
        return e.getID().startsWith("RPT_HDR");
    }

    private static boolean isTableHeader(ReportElement e) {
        return e.getID().startsWith("TBL") && e.getID().indexOf("HDR") != -1;
    }

    class UnitsListener
    implements ItemListener {
        UnitsListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                RulerPanel.this.isMetric.setText("cm");
                RulerPanel.this.xRuler.setIsMetric(true);
                RulerPanel.this.yRuler.setIsMetric(true);
                RulerPanel.this.setIsCm(true);
                int size = RulerPanel.this.reportMain.designPanel.rulerPanel.panelList.size();
                for (int i = 0; i < size; ++i) {
                    JPanel ele = RulerPanel.this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
                    if (ele == null || !(ele instanceof ReportElementPanel)) continue;
                    ReportElementPanel rep = (ReportElementPanel)ele;
                    boolean isVisible = rep.isElementVisible();
                    if (isVisible) {
                        rep.drawGridAndPointInCM();
                    }
                    if (RulerPanel.this.masterSectionPanel == null) continue;
                    RulerPanel.this.masterSectionPanel.drawGridAndPointInCM();
                }
            } else {
                RulerPanel.this.isMetric.setText("in");
                RulerPanel.this.xRuler.setIsMetric(false);
                RulerPanel.this.yRuler.setIsMetric(false);
                RulerPanel.this.setIsCm(false);
                int size = RulerPanel.this.reportMain.designPanel.rulerPanel.panelList.size();
                for (int i = 0; i < size; ++i) {
                    JPanel ele = RulerPanel.this.reportMain.designPanel.rulerPanel.panelList.elementAt(i);
                    if (ele == null || !(ele instanceof ReportElementPanel)) continue;
                    ReportElementPanel rep = (ReportElementPanel)ele;
                    boolean isVisible = rep.isElementVisible();
                    if (isVisible) {
                        rep.drawGridAndPointInINCH();
                    }
                    if (RulerPanel.this.masterSectionPanel == null) continue;
                    RulerPanel.this.masterSectionPanel.drawGridAndPointInINCH();
                }
            }
        }
    }
}

