/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.util.IDelimiterConstants;
import quadbase.reportdesigner.util.IExportConstants;

public class SaveDialog
extends JDialog
implements WindowListener,
ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SaveDialog.class.getName());
    private JTextField filenameTextField;
    private JTextField dbtf;
    private JButton browseButton;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton singlePageButton;
    private JRadioButton multiPageButton;
    private JRadioButton singlePageWPagination;
    private boolean isExportToMultiPages = false;
    private boolean isExportToSingleWPagination = false;
    private int exportDelimiter = 0;
    private int exportNewlineDelim = 0;
    private boolean isUseInternalStyleSheet = false;
    private boolean isUseExternalStyleSheet = false;
    private boolean using16Colors = false;
    private String externalStyleSheetName = null;
    private JPanel p3;
    private JPanel p4;
    private JPanel delimPanel;
    private JPanel newlineDelimPanel;
    private JPanel excelFormatPanel;
    private JPanel excelFitCellPanel;
    private JPanel excelStreamingPanel;
    private JPanel createHTMLPanel;
    private JPanel pdfOptionPanel;
    private JPanel pdfPassFieldPanel;
    private JPanel cssOptionPanel;
    private JPanel externalCSSPanel;
    private JPanel rtfOptionPanel;
    private JPanel xmlTypePanel;
    private JPanel expandAndCollapsePanel;
    private JPanel saveToDBPanel;
    private JPanel xlsxPanel;
    private JFileChooser fileChooser;
    private BrowseDialog browseDialog;
    private String selectedFile = "";
    private String dbLabel = null;
    private ReportMain reportMain;
    private String[] ext;
    private int type = 10;
    private JCheckBox createHTML = null;
    private JCheckBox createXML = null;
    private JCheckBox useSwing = null;
    private JCheckBox usePageViewer = null;
    private JCheckBox createSTL = null;
    private JCheckBox saveAllData = null;
    private JCheckBox chkExpandAndCollapse = null;
    private JCheckBox chkAnimationOn = null;
    private boolean isPAK = true;
    private boolean isXML = false;
    private boolean isHTML = false;
    private boolean isSwing = false;
    private boolean isPageViewer = false;
    private boolean isStyle = false;
    private boolean isSaveAllData = false;
    private boolean isExpandAndCollapseEnabled = false;
    private boolean isDefaultToExpandAll = false;
    private boolean isAnimationOn = false;
    private JRadioButton saveToDatabase = null;
    private JRadioButton saveToFile = null;
    private int expandGroupLevelTo = -1;
    private JCheckBox chkExcelFormat = null;
    private boolean isApplyExcelFormat = true;
    private JCheckBox chkExcelFitCell = null;
    private JCheckBox chkExcelNonNumericFitCell = null;
    private boolean isExcelFitCell = false;
    private boolean isExcelNonNumericFitCell = false;
    private JCheckBox chkEncodePDF = null;
    private JTextField userPassField = null;
    private JTextField ownerPassField = null;
    private boolean isEncodePDF = false;
    private JCheckBox chkExternalStyleSheet = null;
    private JTextField externalStyleSheetField = null;
    private JCheckBox chkUsing16Colors = null;
    private JPanel exportOptionPanel = null;
    private JComboBox typeList;
    private JComboBox xmlTypes;
    private JComboBox delimiterList;
    private JComboBox newlineDelimList;
    private JComboBox expandLevelList;
    private String currentDir = null;
    private JCheckBox chkExcelStreaming = null;
    private boolean isExcelStreaming = false;
    private JTextField tfWindowSize = null;
    private int ExcelWindowSize = 100;
    private static HashMap<Integer, String> supportedSaveFileExtensions = new HashMap();

    SaveDialog(ReportMain reportMain) {
        super(reportMain, "INTERNAL USE", true);
        this.reportMain = reportMain;
    }

    public SaveDialog(ReportMain reportMain, String title, String fileName, int type, String[] ext, String currentDir) {
        this(reportMain, title, fileName, type, ext, currentDir, false);
    }

    public SaveDialog(ReportMain reportMain, String title, String fileName, int type, String[] ext, String currentDir, boolean saveData) {
        super(reportMain, title, true);
        this.setResizable(false);
        this.reportMain = reportMain;
        this.ext = ext;
        this.type = type;
        this.isSaveAllData = saveData;
        if (reportMain.isFromOrganizer() && (fileName.endsWith("\\") || fileName.endsWith("/"))) {
            fileName = "";
        }
        if (currentDir != null) {
            currentDir = currentDir.replace('\\', '/');
        }
        if (fileName != null) {
            fileName = fileName.replace('\\', '/');
        }
        if (ServerMessage.getForcedSaveDirectory() != null) {
            this.selectedFile = "";
            this.currentDir = "";
        } else {
            this.currentDir = currentDir;
            this.selectedFile = fileName.equals("") && currentDir != null ? (!currentDir.endsWith("/") ? currentDir + "/" : currentDir) : fileName;
        }
        this.init();
        this.setPosition();
        this.addWindowListener(this);
    }

    public String getDialogTitle() {
        return this.getTitle();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        if (this.selectedFile != null) {
            String textFile = this.selectedFile;
            if (SaveReport.isRPTFile(textFile)) {
                textFile = textFile.substring(0, textFile.length() - 4) + ".pak";
            }
            textFile = QbUtil.replace(textFile, "*", "");
            this.filenameTextField = new JTextField(textFile, 30);
        } else {
            this.filenameTextField = new JTextField(30);
        }
        this.filenameTextField.addActionListener(this);
        JPanel filePathPanel = new JPanel();
        filePathPanel.setLayout(new BorderLayout());
        filePathPanel.setBorder(new TitledBorder(""));
        filePathPanel.add("West", new JLabel(LanguageEncoder.getText("Path")));
        filePathPanel.add("Center", this.filenameTextField);
        if (this.reportMain.getItemName() != null && !this.reportMain.getItemName().equals("")) {
            this.dbtf = new JTextField(this.reportMain.getItemName(), 30);
        } else if (this.selectedFile != null) {
            int idx = this.selectedFile.lastIndexOf(47);
            String textFile = "";
            if (idx < this.selectedFile.length()) {
                textFile = this.selectedFile.substring(idx + 1);
            }
            textFile = QbUtil.replace(textFile, "*", "");
            this.dbtf = new JTextField(textFile, 30);
        } else {
            this.dbtf = new JTextField(30);
        }
        JPanel pdb1 = new JPanel();
        pdb1.setLayout(new BorderLayout());
        pdb1.setBorder(new TitledBorder(""));
        pdb1.add("West", new JLabel(LanguageEncoder.getText("Name")));
        pdb1.add("Center", this.dbtf);
        this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
        this.browseButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.singlePageButton = new JRadioButton(LanguageEncoder.getText("Single Page"), true);
        this.singlePageButton.addActionListener(this);
        this.multiPageButton = new JRadioButton(LanguageEncoder.getText("Multi-Page"), false);
        this.multiPageButton.addActionListener(this);
        this.singlePageWPagination = new JRadioButton(LanguageEncoder.getText("Paginated Single Page"), false);
        this.singlePageWPagination.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.singlePageButton);
        group.add(this.singlePageWPagination);
        group.add(this.multiPageButton);
        this.p4 = new JPanel();
        this.p4.setLayout(new BorderLayout());
        this.p4.add("West", this.singlePageButton);
        this.p4.add("East", this.multiPageButton);
        this.chkUsing16Colors = new JCheckBox(LanguageEncoder.getText("Using 16 Colors"), false);
        this.rtfOptionPanel = new JPanel();
        this.rtfOptionPanel.setLayout(new FlowLayout());
        this.rtfOptionPanel.add(this.chkUsing16Colors);
        this.createHTML = new JCheckBox(LanguageEncoder.getText("Create HTML"), false);
        this.useSwing = new JCheckBox(LanguageEncoder.getText("Use Swing"), false);
        this.usePageViewer = new JCheckBox(LanguageEncoder.getText("Use PageViewer"), false);
        this.enableHTMLOptionBoxs(false);
        this.createHTML.addItemListener(this);
        this.createXML = new JCheckBox(LanguageEncoder.getText("Create XML"), this.selectedFile.toLowerCase().endsWith(".xml"));
        this.createSTL = new JCheckBox(LanguageEncoder.getText("Create Style"), false);
        this.saveAllData = new JCheckBox(LanguageEncoder.getText("Save All Data"), this.isSaveAllData);
        this.saveToFile = new JRadioButton(LanguageEncoder.getText("Save To File"), true);
        this.saveToDatabase = new JRadioButton(LanguageEncoder.getText("Save To Database"), false);
        this.saveToDBPanel = new JPanel();
        this.saveToDBPanel.setLayout(new BorderLayout());
        this.saveToDBPanel.add("North", this.saveToDatabase);
        this.saveToDBPanel.add("Center", pdb1);
        this.saveAllData.addItemListener(this);
        this.createXML.addItemListener(this);
        this.createSTL.addItemListener(this);
        this.saveToFile.addItemListener(this);
        this.saveToDatabase.addItemListener(this);
        this.typeList = new JComboBox();
        for (int i = 0; i < IExportConstants.EXPORTTYPE.length; ++i) {
            if (IExportConstants.EXPORTTYPE[i].equalsIgnoreCase("PAK") && this.reportMain.isMainReport()) continue;
            this.typeList.addItem(IExportConstants.EXPORTTYPE[i]);
        }
        this.typeList.setSelectedIndex(4);
        this.typeList.addActionListener(this);
        this.xmlTypePanel = new JPanel();
        this.xmlTypes = new JComboBox();
        this.xmlTypes.addItem(LanguageEncoder.getText("Data & Format"));
        this.xmlTypes.addItem(LanguageEncoder.getText("Pure Data"));
        this.xmlTypes.addActionListener(this);
        this.xmlTypePanel.setLayout(new BorderLayout());
        this.xmlTypePanel.add("West", new JLabel(LanguageEncoder.getText("Option")));
        this.xmlTypePanel.add("Center", this.xmlTypes);
        this.newlineDelimPanel = new JPanel();
        this.newlineDelimList = new JComboBox();
        for (String element : IDelimiterConstants.NEWLINEDELIMLIST) {
            this.newlineDelimList.addItem(element);
        }
        this.newlineDelimList.addActionListener(this);
        this.newlineDelimPanel.setLayout(new FlowLayout(0));
        this.newlineDelimPanel.add(new JLabel(LanguageEncoder.getText("Newline Delimiter")));
        this.newlineDelimPanel.add(this.newlineDelimList);
        this.delimPanel = new JPanel();
        this.delimiterList = new JComboBox();
        for (String element : IDelimiterConstants.DELIMLIST) {
            this.delimiterList.addItem(element);
        }
        this.delimiterList.addActionListener(this);
        this.delimPanel.setLayout(new FlowLayout(0));
        this.delimPanel.add(new JLabel(LanguageEncoder.getText("Delimiter")));
        this.delimPanel.add(this.delimiterList);
        this.excelFormatPanel = new JPanel();
        this.chkExcelFormat = new JCheckBox(LanguageEncoder.getText("Apply Formatting"), true);
        this.excelFormatPanel.setLayout(new FlowLayout());
        this.excelFormatPanel.add(this.chkExcelFormat);
        this.excelFitCellPanel = new JPanel();
        this.chkExcelFitCell = new JCheckBox(LanguageEncoder.getText("Fit numeric value into a single cell"), false);
        this.chkExcelNonNumericFitCell = new JCheckBox(LanguageEncoder.getText("Fit Non Numeric value into a single cell"), false);
        this.excelFitCellPanel.setLayout(new FlowLayout());
        this.excelFitCellPanel.add(this.chkExcelFitCell);
        this.excelFitCellPanel.add(this.chkExcelNonNumericFitCell);
        this.excelStreamingPanel = new JPanel();
        this.excelStreamingPanel.setLayout(new BoxLayout(this.excelStreamingPanel, 1));
        this.chkExcelStreaming = new JCheckBox(LanguageEncoder.getText("Use Streaming"), false);
        this.chkExcelStreaming.setAlignmentX(0.0f);
        this.excelStreamingPanel.add(this.chkExcelStreaming);
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        this.tfWindowSize = new JTextField(4);
        aPanel.add((Component)this.tfWindowSize, "Center");
        aPanel.add((Component)new JLabel(LanguageEncoder.getText(" rows kept in memory")), "East");
        aPanel.setAlignmentX(0.0f);
        this.excelStreamingPanel.add(aPanel);
        this.tfWindowSize.setText("100");
        this.cssOptionPanel = new JPanel(new BorderLayout());
        JPanel cssChkBoxPanel = new JPanel(new GridLayout(1, 2));
        this.chkExternalStyleSheet = new JCheckBox(LanguageEncoder.getText("Use External Style Sheet"), this.reportMain.report.getExternalStyleSheetName() != null);
        this.chkExternalStyleSheet.addItemListener(this);
        cssChkBoxPanel.add(this.chkExternalStyleSheet);
        this.externalCSSPanel = new JPanel(new FlowLayout(0));
        this.externalCSSPanel.add(new JLabel(LanguageEncoder.getText("External CSS")));
        this.externalStyleSheetName = this.reportMain.report.getExternalStyleSheetName();
        this.externalStyleSheetField = new JTextField(this.externalStyleSheetName == null ? "" : this.externalStyleSheetName, 25);
        this.externalCSSPanel.add(this.externalStyleSheetField);
        this.externalCSSPanel.setVisible(this.chkExternalStyleSheet.isSelected());
        this.cssOptionPanel.add("North", cssChkBoxPanel);
        this.cssOptionPanel.add("Center", this.externalCSSPanel);
        this.expandAndCollapsePanel = new JPanel(new GridLayout(2, 2));
        this.chkExpandAndCollapse = new JCheckBox(LanguageEncoder.getText("Enable Expand and Collapse Option"), false);
        this.chkAnimationOn = new JCheckBox(LanguageEncoder.getText("Enable Animation"), false);
        this.expandLevelList = new JComboBox();
        this.expandLevelList.addItem(LanguageEncoder.getText("Collapse All"));
        for (int i = 0; i < this.getLevelCount(); ++i) {
            this.expandLevelList.addItem(LanguageEncoder.getText("Expand to Group Level") + " " + i);
        }
        this.expandLevelList.addItem(LanguageEncoder.getText("Expand All"));
        this.chkExpandAndCollapse.addItemListener(this);
        this.expandAndCollapsePanel.add(this.chkExpandAndCollapse);
        this.expandAndCollapsePanel.add(this.chkAnimationOn);
        this.expandAndCollapsePanel.add(this.expandLevelList);
        this.expandAndCollapsePanel.add(new JLabel());
        this.expandLevelList.setEnabled(this.chkExpandAndCollapse.isSelected());
        this.chkAnimationOn.setEnabled(this.chkAnimationOn.isSelected());
        if (this.isExpandFeatureSupported()) {
            this.cssOptionPanel.add("South", this.expandAndCollapsePanel);
        }
        this.pdfOptionPanel = new JPanel();
        this.chkEncodePDF = new JCheckBox(LanguageEncoder.getText("Encrypt PDF Export"), false);
        this.pdfOptionPanel.setLayout(new FlowLayout(2));
        this.chkEncodePDF.addItemListener(this);
        this.pdfOptionPanel.add(this.chkEncodePDF);
        this.pdfPassFieldPanel = new JPanel();
        this.pdfPassFieldPanel.setLayout(new BorderLayout());
        JPanel userPassPanel = new JPanel();
        userPassPanel.setLayout(new BorderLayout());
        userPassPanel.add("Center", new JLabel(LanguageEncoder.getText("User Password")));
        this.userPassField = new JPasswordField("", 10);
        userPassPanel.add("East", this.userPassField);
        JPanel ownerPassPanel = new JPanel();
        ownerPassPanel.setLayout(new BorderLayout());
        ownerPassPanel.add("Center", new JLabel(LanguageEncoder.getText("Owner Password")));
        this.ownerPassField = new JPasswordField("", 10);
        ownerPassPanel.add("East", this.ownerPassField);
        this.pdfPassFieldPanel.add("North", userPassPanel);
        this.pdfPassFieldPanel.add("South", ownerPassPanel);
        this.createHTMLPanel = new JPanel();
        this.createHTMLPanel.setBorder(new TitledBorder(""));
        this.createHTMLPanel.setLayout(new FlowLayout(0));
        if (ServerMessage.useServer) {
            if (this.type == 1 || this.type == 10) {
                this.createHTMLPanel.add(this.createHTML);
                this.createHTMLPanel.add(this.usePageViewer);
                this.createHTMLPanel.add(this.useSwing);
            } else {
                this.createHTMLPanel.add(this.createHTML);
                this.createHTMLPanel.add(this.useSwing);
            }
        }
        this.p3 = null;
        switch (this.type) {
            case 8: {
                this.p3 = new JPanel();
                this.p3.setLayout(new GridLayout(1, 0, 5, 5));
                if (ServerMessage.useServer) {
                    this.createHTMLPanel.add(this.createHTML);
                    this.createHTMLPanel.add(this.useSwing);
                }
                this.p3.add(this.createXML);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 1: 
            case 10: {
                JPanel createXMLPanel = new JPanel();
                createXMLPanel.setLayout(new FlowLayout(0));
                createXMLPanel.setBorder(new TitledBorder(""));
                createXMLPanel.add(this.createXML);
                createXMLPanel.add(this.saveAllData);
                JPanel createStylePanel = new JPanel();
                createStylePanel.setLayout(new FlowLayout(0));
                createStylePanel.setBorder(new TitledBorder(""));
                createStylePanel.add(this.createSTL);
                if (ServerMessage.useServer) {
                    this.p3 = new JPanel();
                    this.p3.setLayout(new BorderLayout());
                    this.p3.add("Center", createXMLPanel);
                    this.p3.add("South", createStylePanel);
                    break;
                }
                this.p3 = new JPanel();
                this.p3.setLayout(new BorderLayout());
                this.p3.add("Center", createXMLPanel);
                this.p3.add("South", createStylePanel);
                break;
            }
            default: {
                this.p3 = new JPanel();
                this.p3.setLayout(new FlowLayout(0));
                this.p3.add(new JLabel(LanguageEncoder.getText("Type")));
                this.p3.add(this.typeList);
                this.p4.add("Center", this.singlePageWPagination);
                this.p4.add("South", this.cssOptionPanel);
            }
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        if (ServerMessage.getForcedSaveDirectory() == null) {
            buttonPanel.add(this.browseButton);
        }
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        if (this.getTitle().equals(LanguageEncoder.getText("Export File"))) {
            JPanel temp;
            if (this.p3 == null) {
                if (this.type == 4) {
                    this.p4.add("Center", this.singlePageWPagination);
                    temp = new JPanel(new BorderLayout());
                    temp.add("North", this.p4);
                    temp.add("Center", this.cssOptionPanel);
                    temp.setVisible(true);
                    mainPanel.add("North", filePathPanel);
                    mainPanel.add("East", temp);
                } else if (this.type == 13) {
                    mainPanel.add("North", filePathPanel);
                    mainPanel.add("East", this.rtfOptionPanel);
                } else if (this.type == 5 || this.type == 3) {
                    mainPanel.add("North", filePathPanel);
                    mainPanel.add("West", this.newlineDelimPanel);
                    mainPanel.add("East", this.delimPanel);
                    if (this.type == 3) {
                        this.delimiterList.setSelectedIndex(3);
                    }
                } else if (this.type == 9 || this.type == 17) {
                    mainPanel.add("North", filePathPanel);
                    mainPanel.add("West", this.excelFitCellPanel);
                    if (this.type == 17) {
                        mainPanel.add("East", this.excelStreamingPanel);
                    }
                } else if (this.type == 2) {
                    mainPanel.add("North", filePathPanel);
                    JPanel pdfPanel = new JPanel();
                    pdfPanel.setLayout(new BorderLayout());
                    pdfPanel.add("North", this.pdfOptionPanel);
                    pdfPanel.add("Center", this.pdfPassFieldPanel);
                    this.pdfPassFieldPanel.setVisible(false);
                    mainPanel.add("East", pdfPanel);
                } else if (this.type == 10) {
                    mainPanel.add("North", filePathPanel);
                } else if (this.type == 6 || this.type == 7) {
                    if (this.type == 6) {
                        this.xmlTypes.setSelectedIndex(0);
                        this.p4.setVisible(true);
                    } else {
                        this.xmlTypes.setSelectedIndex(1);
                        this.p4.setVisible(false);
                    }
                    mainPanel.add("North", filePathPanel);
                    mainPanel.add("West", this.xmlTypePanel);
                    mainPanel.add("East", this.p4);
                } else {
                    mainPanel.add("Center", filePathPanel);
                }
            } else {
                this.exportOptionPanel = new JPanel();
                this.exportOptionPanel.setLayout(new BorderLayout());
                this.exportOptionPanel.add("West", this.p3);
                this.exportOptionPanel.add("East", this.p4);
                temp = new JPanel();
                temp.setLayout(new FlowLayout(2));
                temp.add(this.pdfPassFieldPanel);
                this.pdfPassFieldPanel.setVisible(false);
                this.exportOptionPanel.add("South", temp);
                mainPanel.add("North", filePathPanel);
                mainPanel.add("Center", this.exportOptionPanel);
            }
        } else if (this.p3 == null) {
            mainPanel.add("Center", filePathPanel);
        } else {
            mainPanel.add("North", filePathPanel);
            mainPanel.add("West", this.p3);
        }
        if (this.reportMain.isFromOrganizer() && !this.getTitle().equals(LanguageEncoder.getText("Export File"))) {
            ButtonGroup group2 = new ButtonGroup();
            group2.add(this.saveToFile);
            group2.add(this.saveToDatabase);
            JPanel selectPanel1 = new JPanel();
            selectPanel1.setBorder(new TitledBorder("Save To File"));
            selectPanel1.setLayout(new BorderLayout());
            selectPanel1.add("Center", mainPanel);
            JPanel selectPanel2 = new JPanel();
            selectPanel2.setLayout(new BorderLayout());
            selectPanel2.setBorder(new TitledBorder("Save To Database"));
            contentPane.add("Center", selectPanel1);
            contentPane.add("South", buttonPanel);
        } else {
            contentPane.add("Center", mainPanel);
            contentPane.add("South", buttonPanel);
        }
        this.pack();
        this.filenameTextField.requestFocus();
    }

    private String loadFile() {
        String originalFileName;
        if (this.filenameTextField.getText() != null) {
            int slashIndex = this.filenameTextField.getText().lastIndexOf(47);
            if (slashIndex < this.filenameTextField.getText().lastIndexOf(92)) {
                slashIndex = this.filenameTextField.getText().lastIndexOf(92);
            }
            originalFileName = slashIndex >= this.filenameTextField.getText().length() - 1 ? "" : this.filenameTextField.getText().substring(slashIndex + 1);
        } else {
            originalFileName = "";
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                ExtensionFilter fileFilter = new ExtensionFilter(this.ext);
                this.fileChooser.addChoosableFileFilter(fileFilter);
                if (this.currentDir == null) {
                    this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                } else {
                    this.fileChooser.setCurrentDirectory(new File(this.currentDir));
                }
            }
            this.fileChooser.showDialog(this.reportMain, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            this.currentDir = this.fileChooser.getCurrentDirectory().getAbsolutePath();
            if (this.fileChooser.getSelectedFile().isDirectory()) {
                return this.browseDialog.getSelectedFile() + originalFileName;
            }
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.reportMain, this.currentDir, this.ext);
        }
        this.browseDialog.setVisible(true);
        this.currentDir = this.browseDialog.getCurrentDirectory();
        if (this.currentDir.equalsIgnoreCase(this.browseDialog.getSelectedFile(false))) {
            return this.currentDir + originalFileName;
        }
        return this.browseDialog.getSelectedFile(false);
    }

    private int getLevelCount() {
        ReportTable orgTbl = this.reportMain.report.getReportTables().elementAt(0);
        if (orgTbl instanceof ReportMultiSectionTable) {
            return ((ReportMultiSectionTable)orgTbl).countRowBreakFooter();
        }
        return 0;
    }

    private boolean isExpandFeatureSupported() {
        return this.reportMain.report.getReportType() == 1 || this.reportMain.report.getReportType() == 2 || this.reportMain.report.getReportType() == 3 && !this.reportMain.report.isSideBySideLayout();
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    public String getDBLabel() {
        return this.saveToDatabase == null ? null : (this.saveToDatabase.isSelected() ? this.dbLabel : null);
    }

    public boolean isSaveAllData() {
        return this.isSaveAllData;
    }

    public boolean useSwing() {
        return this.isSwing;
    }

    public boolean isUsingAllColorsForRTF() {
        return !this.using16Colors;
    }

    public boolean usePageViewer() {
        return this.isPageViewer;
    }

    public boolean isApplyExcelFormat() {
        return this.isApplyExcelFormat;
    }

    public boolean isExcelFitCell() {
        return this.isExcelFitCell;
    }

    public boolean isExcelNonNumericFitCell() {
        return this.isExcelNonNumericFitCell;
    }

    public boolean isExcelStreaming() {
        return this.isExcelStreaming;
    }

    public int getExcelWindowSize() {
        return this.ExcelWindowSize;
    }

    public boolean isEncodePDF() {
        return this.isEncodePDF;
    }

    public String getPDFUserPass() {
        return this.userPassField.getText().trim().equals("") ? null : this.userPassField.getText().trim();
    }

    public String getPDFOwnerPass() {
        return this.ownerPassField.getText().trim().equals("") ? null : this.ownerPassField.getText().trim();
    }

    public int getExportType() {
        return this.type;
    }

    public boolean isUseInternalStyleSheet() {
        return this.isUseInternalStyleSheet;
    }

    public boolean isUseExternalStyleSheet() {
        return this.isUseExternalStyleSheet;
    }

    public String getExternalStyleSheetName() {
        if (!this.isUseExternalStyleSheet) {
            return null;
        }
        return this.externalStyleSheetField.getText().trim().equals("") ? null : this.externalStyleSheetField.getText().trim();
    }

    public boolean isExportToMultiPages() {
        return this.isExportToMultiPages;
    }

    public boolean isExportToSingleWPagination() {
        return this.isExportToSingleWPagination;
    }

    public boolean isExpandAndCollapseEnabled() {
        return this.isExpandAndCollapseEnabled;
    }

    public boolean isDefaultToExpandAll() {
        return this.isDefaultToExpandAll;
    }

    public int getExpandGroupLevelTo() {
        return this.expandGroupLevelTo;
    }

    public boolean isAnimationOn() {
        return this.isAnimationOn;
    }

    public int getExportDelimiter() {
        return this.exportDelimiter;
    }

    public int getExportNewlineDelim() {
        return this.exportNewlineDelim;
    }

    public boolean isSaveToDatabase() {
        return this.saveToDatabase.isSelected();
    }

    public void setSaveToDatabase(boolean b) {
        this.saveToDatabase.setSelected(b);
    }

    private void enableHTMLOptionBoxs(boolean b) {
        if (this.useSwing != null) {
            this.useSwing.setEnabled(b);
        }
        if (this.usePageViewer != null) {
            this.usePageViewer.setEnabled(b);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename = this.filenameTextField.getText();
        if (e.getSource() == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null) {
                this.filenameTextField.setText(fileText);
            }
            return;
        }
        if (e.getSource() == this.singlePageButton || e.getSource() == this.multiPageButton || e.getSource() == this.singlePageWPagination) {
            this.isExportToMultiPages = this.multiPageButton.isSelected();
            this.isExportToSingleWPagination = this.singlePageWPagination.isSelected();
            if (this.isExpandFeatureSupported()) {
                this.expandAndCollapsePanel.setVisible(this.singlePageButton.isSelected());
            }
            this.pack();
            return;
        }
        if (e.getSource() == this.delimiterList) {
            this.exportDelimiter = this.delimiterList.getSelectedIndex();
            this.exportNewlineDelim = this.newlineDelimList.getSelectedIndex();
            return;
        }
        if (e.getSource() == this.newlineDelimList) {
            this.exportNewlineDelim = this.newlineDelimList.getSelectedIndex();
            return;
        }
        if (e.getSource() == this.typeList) {
            int exportType = this.type;
            this.p4.remove(this.singlePageWPagination);
            this.cssOptionPanel.setVisible(false);
            this.exportOptionPanel.removeAll();
            this.exportOptionPanel.add("West", this.p3);
            exportType = this.getExportType(this.typeList.getSelectedIndex());
            if (exportType == 6) {
                this.exportOptionPanel.add("East", this.p4);
                this.p4.setVisible(true);
            } else if (exportType == 4) {
                this.p4.add("Center", this.singlePageWPagination);
                this.exportOptionPanel.add("East", this.p4);
                this.p4.add("South", this.cssOptionPanel);
                this.p4.setVisible(true);
                this.cssOptionPanel.setVisible(true);
            }
            if (exportType == 5 || exportType == 3) {
                JPanel tmpPanel = new JPanel();
                tmpPanel.setLayout(new BorderLayout());
                tmpPanel.add("Center", this.delimPanel);
                tmpPanel.add("South", this.newlineDelimPanel);
                this.exportOptionPanel.add("East", tmpPanel);
                this.delimPanel.setVisible(true);
                this.newlineDelimPanel.setVisible(true);
                if (exportType == 3) {
                    this.delimiterList.setSelectedIndex(3);
                }
            }
            if (exportType == 13) {
                this.exportOptionPanel.add("East", this.rtfOptionPanel);
                this.rtfOptionPanel.setVisible(true);
            }
            if (exportType == 9) {
                this.exportOptionPanel.add("East", this.excelFitCellPanel);
                this.excelFitCellPanel.setVisible(true);
            }
            if (exportType == 17) {
                this.xlsxPanel = new JPanel();
                this.xlsxPanel.setLayout(new BoxLayout(this.xlsxPanel, 1));
                this.excelFitCellPanel.setAlignmentX(0.0f);
                this.excelStreamingPanel.setAlignmentX(0.0f);
                this.xlsxPanel.add(this.excelFitCellPanel);
                this.xlsxPanel.add(this.excelStreamingPanel);
                this.exportOptionPanel.add("East", this.xlsxPanel);
                this.xlsxPanel.setVisible(true);
            }
            if (exportType == 2) {
                this.exportOptionPanel.add("East", this.pdfOptionPanel);
                this.pdfOptionPanel.setVisible(true);
                JPanel temp = new JPanel();
                temp.setLayout(new FlowLayout(2));
                temp.add(this.pdfPassFieldPanel);
                this.pdfPassFieldPanel.setVisible(false);
                this.exportOptionPanel.add("South", temp);
                this.pdfPassFieldPanel.setVisible(this.chkEncodePDF.isSelected());
            }
            if (exportType == 14) {
                // empty if block
            }
            this.pack();
            this.repaint();
            return;
        }
        if (e.getSource() == this.xmlTypes) {
            if (this.xmlTypes.getSelectedIndex() == 0) {
                this.p4.setVisible(true);
            } else {
                this.p4.setVisible(false);
            }
            return;
        }
        if (e.getSource() == this.okButton || e.getSource() == this.filenameTextField) {
            if (this.saveToDatabase.isSelected()) {
                this.dbLabel = this.dbtf.getText();
                if (this.dbLabel.equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please enter a database file name!"));
                    return;
                }
                if (QbUtil.containInvalidChar(this.dbLabel)) {
                    String msg = LanguageEncoder.getText("A database file name cannot contain any of the following characters:") + " " + QbUtil.invalidCharSet;
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                if (this.reportMain.isFileNameExisted(this.dbLabel) && !this.dbLabel.equalsIgnoreCase(this.reportMain.getItemName())) {
                    String msg = LanguageEncoder.getText("A file with the name you specified already exists in the organizer folder.  Do you want specify a different file name?");
                    JMessageDialog dialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg, 1);
                    int response = dialog.getResponse();
                    if (response == 4) {
                        return;
                    }
                    if (response == 7) {
                        this.selectedFile = null;
                        this.dbLabel = null;
                        this.setVisible(false);
                        this.dispose();
                        return;
                    }
                }
                this.setVisible(false);
                this.dispose();
                return;
            }
            if (filename == null || filename.equals("")) {
                return;
            }
            try {
                filename = filename.replace('\\', '/').trim();
                if (ServerMessage.getForcedSaveDirectory() != null) {
                    String forcedSaveDir = ServerMessage.getForcedSaveDirectory();
                    if (!forcedSaveDir.endsWith("/")) {
                        forcedSaveDir = forcedSaveDir + "/";
                    }
                    filename = forcedSaveDir + filename;
                }
                if (filename.endsWith("/") && new FileInfo(filename).isDirectory()) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please enter a file name!"));
                    return;
                }
                int index = filename.lastIndexOf(47);
                String fname = filename;
                if (index != -1) {
                    fname = filename.substring(index + 1);
                }
                if ((fname = fname.trim()).equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please enter a file name!"));
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Save dialog: cannot check file name", ex);
            }
            this.isEncodePDF = this.chkEncodePDF.isSelected();
            this.isUseExternalStyleSheet = this.chkExternalStyleSheet.isSelected();
            this.isExpandAndCollapseEnabled = this.chkExpandAndCollapse.isSelected();
            this.isDefaultToExpandAll = this.expandLevelList.getSelectedIndex() - 1 == this.getLevelCount();
            this.expandGroupLevelTo = this.expandLevelList.getSelectedIndex() - 1;
            this.isAnimationOn = this.chkAnimationOn.isSelected();
            if (this.isEncodePDF && this.userPassField.getText().trim().equals("")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please input the user password!"));
                return;
            }
            if (this.isUseExternalStyleSheet && this.externalStyleSheetField.getText().trim().equals("")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please input external style sheet name!"));
                return;
            }
            this.selectedFile = filename;
            this.isHTML = this.createHTML.isSelected();
            this.isXML = this.createXML.isSelected() && this.selectedFile.toLowerCase().endsWith(".xml");
            this.isPAK = this.isPAK() && !this.selectedFile.toLowerCase().endsWith(".rpt");
            this.isStyle = this.createSTL.isSelected() && this.selectedFile.toLowerCase().endsWith(".stl");
            this.isSaveAllData = this.saveAllData.isSelected();
            this.using16Colors = this.chkUsing16Colors.isSelected();
            this.isSwing = this.useSwing.isSelected();
            this.isPageViewer = this.usePageViewer.isSelected();
            this.isApplyExcelFormat = this.chkExcelFormat.isSelected();
            this.isExcelFitCell = this.chkExcelFitCell.isSelected();
            this.isExcelNonNumericFitCell = this.chkExcelNonNumericFitCell.isSelected();
            this.isExcelStreaming = this.chkExcelStreaming.isSelected();
            this.ExcelWindowSize = Integer.parseInt(this.tfWindowSize.getText());
            if (this.type == 8 || this.type == 10 || this.type == 16 || this.type == 1) {
                if (filename.toLowerCase().endsWith(".xml")) {
                    this.type = 8;
                } else if (filename.toLowerCase().endsWith(".pak")) {
                    this.type = 10;
                } else if (filename.toLowerCase().endsWith(".stl")) {
                    this.type = 16;
                } else if (filename.toLowerCase().endsWith(".rpt")) {
                    this.type = 1;
                } else if (this.isXML()) {
                    this.type = 8;
                } else if (this.isPAK) {
                    this.type = 10;
                }
                try {
                    StringTokenizer st = new StringTokenizer(filename, ".");
                    String token = st.nextToken();
                    String ext = "";
                    int extCount = 0;
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        if (!token.equalsIgnoreCase("xml") && !token.equalsIgnoreCase("stl") && !token.equalsIgnoreCase("pak") && !token.equalsIgnoreCase("rpt")) continue;
                        ++extCount;
                        ext = ext + "." + token + " and ";
                    }
                    if (extCount > 1) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please do not use") + " " + ext.substring(0, ext.length() - 4) + " " + LanguageEncoder.getText("at the same time."));
                        return;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to check for multiple extensions", ex);
                }
            }
            int exportType = this.type;
            if (this.type < 0) {
                exportType = this.getExportType(this.typeList.getSelectedIndex());
            } else if (this.type == 6 || this.type == 7) {
                exportType = 6 + this.xmlTypes.getSelectedIndex();
            }
            filename = this.reportMain.getPath(Report.getFullName(filename, exportType));
            if (this.createSTL.isSelected() && !filename.toLowerCase().endsWith(".stl")) {
                filename = filename + ".stl";
            }
            this.setVisible(false);
            if (!OverWriteDialog.continueSave(this.reportMain, filename)) {
                this.setVisible(true);
                return;
            }
            this.type = exportType;
        } else if (e.getSource() == this.cancelButton) {
            this.selectedFile = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getItem();
        JCheckBox cb = null;
        if (obj instanceof JCheckBox) {
            cb = (JCheckBox)obj;
        }
        if (obj == this.saveToDatabase || obj == this.saveToFile) {
            if (this.filenameTextField != null) {
                this.filenameTextField.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.dbtf != null) {
                this.dbtf.setEnabled(this.saveToDatabase.isSelected());
            }
            if (this.createHTML != null) {
                this.createHTML.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.useSwing != null) {
                this.useSwing.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.usePageViewer != null) {
                this.usePageViewer.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.createXML != null) {
                this.createXML.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.saveAllData != null) {
                this.saveAllData.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.createSTL != null) {
                this.createSTL.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.browseButton != null) {
                this.browseButton.setEnabled(!this.saveToDatabase.isSelected());
            }
        } else if (cb != null) {
            if (cb == this.createHTML) {
                this.enableHTMLOptionBoxs(cb.isSelected());
            } else if (cb == this.chkEncodePDF) {
                this.pdfPassFieldPanel.setVisible(cb.isSelected());
                this.pack();
            } else if (cb == this.chkExpandAndCollapse) {
                this.expandLevelList.setEnabled(this.chkExpandAndCollapse.isSelected());
                this.chkAnimationOn.setEnabled(this.chkExpandAndCollapse.isSelected());
            } else if (cb == this.chkExternalStyleSheet) {
                this.externalCSSPanel.setVisible(cb.isSelected());
                this.pack();
            } else if (cb.isSelected() && cb == this.createXML) {
                this.isPAK = false;
                this.createSTL.setSelected(false);
                this.type = 8;
                this.setFileNameExtension(this.type, this.filenameTextField.getText());
            } else if (cb.isSelected() && cb == this.createSTL) {
                this.createXML.setSelected(false);
                this.isPAK = false;
                this.type = 16;
                this.setFileNameExtension(this.type, this.filenameTextField.getText());
            } else if (cb != this.saveAllData) {
                this.type = 10;
                this.setFileNameExtension(this.type, this.filenameTextField.getText());
            }
        }
    }

    private void setFileNameExtension(int extension, String filename) {
        if (!supportedSaveFileExtensions.containsKey(extension)) {
            return;
        }
        String fnLC = filename.toLowerCase();
        Set<Integer> keys = supportedSaveFileExtensions.keySet();
        String newExt = supportedSaveFileExtensions.get(extension);
        for (Integer integer2 : keys) {
            Integer key = integer2;
            if (key == extension || !fnLC.endsWith(supportedSaveFileExtensions.get(key))) continue;
            this.filenameTextField.setText(filename.substring(0, filename.length() - 4) + newExt);
            return;
        }
        if (fnLC.endsWith(".")) {
            this.filenameTextField.setText(filename + newExt.substring(1));
        } else if (!fnLC.endsWith(newExt)) {
            this.filenameTextField.setText(filename + newExt);
        }
    }

    private int getExportType(int selectedId) {
        if (selectedId == 0) {
            return 2;
        }
        if (selectedId == 1) {
            return 3;
        }
        if (selectedId == 2) {
            return 9;
        }
        if (selectedId == 3) {
            return 17;
        }
        if (selectedId == 4) {
            return 4;
        }
        if (selectedId == 5) {
            return 5;
        }
        if (selectedId == 6) {
            return 6;
        }
        if (selectedId == 7) {
            return 7;
        }
        if (selectedId == 8) {
            return 13;
        }
        if (selectedId == 9) {
            return 10;
        }
        LOGGER.warning("Save Dialog: not supported export format");
        return -1;
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }

    public void setSaveAllData(boolean isSaveAllData) {
        this.isSaveAllData = isSaveAllData;
    }

    public void setHTML(boolean isHTML) {
        this.isHTML = isHTML;
    }

    public void setXML(boolean isXML) {
        this.isXML = isXML;
    }

    public boolean isXML() {
        return this.isXML;
    }

    public boolean isHTML() {
        return this.isHTML;
    }

    public boolean isStyle() {
        return this.isStyle;
    }

    public void setPAK(boolean isPAK) {
        this.isPAK = isPAK;
    }

    public boolean isPAK() {
        return this.isPAK;
    }

    public void setPageViewer(boolean isPageViewer) {
        this.isPageViewer = isPageViewer;
    }

    public void setSwing(boolean isSwing) {
        this.isSwing = isSwing;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.selectedFile = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    static {
        supportedSaveFileExtensions.put(8, ".xml");
        supportedSaveFileExtensions.put(1, ".rpt");
        supportedSaveFileExtensions.put(16, ".stl");
        supportedSaveFileExtensions.put(10, ".pak");
    }
}

