/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.designer.NewEditDialog;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Script;

public class ScriptDialog
extends JDialog
implements ActionListener,
WindowListener {
    private static final Logger LOGGER = Logger.getLogger(ScriptDialog.class.getName());
    JButton editButton;
    JButton newButton;
    JButton renameButton;
    JButton deleteButton;
    JButton applyButton;
    JButton cancelButton;
    JButton removeButton;
    JButton viewAllButton;
    JButton findNextButton;
    JButton findPrevButton;
    JList scriptList;
    JScrollPane scrollPane;
    JPanel buttonPanel;
    ReportMain reportMain;
    Report report;
    boolean isModified = false;
    ReportElement elt;
    private Script[] referencedScripts = null;
    private String[] securedScripts = null;
    private Vector<Script> scripts;

    public ScriptDialog(ReportMain reportMain) {
        super(reportMain, LanguageEncoder.getText("Script"), false);
        this.reportMain = reportMain;
        this.report = reportMain.report;
        this.elt = reportMain.selectedObject;
        this.init();
        this.setPosition();
    }

    public void update(ReportMain reportMain) {
        this.reportMain = reportMain;
        this.report = reportMain.report;
        this.elt = reportMain.selectedObject;
        int idx = this.scriptList.getSelectedIndex();
        if (idx >= 0) {
            Script script = this.scripts.get(idx);
            if (this.elt != null && script.getName().equals(this.elt.getScriptName())) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        this.scriptList.validate();
        this.scriptList.repaint();
    }

    private void refreshList() {
        this.scripts = new Vector<Script>(this.report.scripts);
        Collections.sort(this.scripts);
        this.scriptList.setListData(this.scripts);
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.securedScripts = this.report.getSecuredScripts();
        this.scriptList = new JList();
        MyMouseListener addListener = new MyMouseListener();
        this.scriptList.addMouseListener(addListener);
        this.scriptList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Script script = (Script)value;
                String name = script.getName();
                boolean secured = false;
                for (int j = 0; ScriptDialog.this.securedScripts != null && j < ScriptDialog.this.securedScripts.length && !secured; ++j) {
                    if (!name.equals(ScriptDialog.this.securedScripts[j])) continue;
                    secured = true;
                }
                if (secured) {
                    name = name + " (Secured)";
                }
                if (name != null && ScriptDialog.this.elt != null && name.equals(ScriptDialog.this.elt.getScriptName())) {
                    name = name + "*";
                }
                this.setText(name);
                return component;
            }
        });
        this.refreshList();
        this.scrollPane = new JScrollPane(this.scriptList);
        contentPane.add((Component)this.scrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(10, 1, 5, 5));
        this.editButton = new JButton(LanguageEncoder.getText("EDIT"));
        this.buttonPanel.add(this.editButton);
        this.newButton = new JButton(LanguageEncoder.getText("NEW"));
        this.buttonPanel.add(this.newButton);
        this.renameButton = new JButton(LanguageEncoder.getText("RENAME"));
        this.buttonPanel.add(this.renameButton);
        this.deleteButton = new JButton(LanguageEncoder.getText("DELETE"));
        this.buttonPanel.add(this.deleteButton);
        this.applyButton = new JButton(LanguageEncoder.getText("APPLY"));
        this.buttonPanel.add(this.applyButton);
        this.removeButton = new JButton(LanguageEncoder.getText("REMOVE"));
        this.buttonPanel.add(this.removeButton);
        this.viewAllButton = new JButton(LanguageEncoder.getText("VIEW ALL"));
        this.buttonPanel.add(this.viewAllButton);
        this.findNextButton = new JButton(LanguageEncoder.getText("FIND NEXT"));
        this.buttonPanel.add(this.findNextButton);
        this.findPrevButton = new JButton(LanguageEncoder.getText("FIND PREV"));
        this.buttonPanel.add(this.findPrevButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("CLOSE"));
        this.buttonPanel.add(this.cancelButton);
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.renameButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.viewAllButton.addActionListener(this);
        this.viewAllButton.setEnabled(false);
        this.findNextButton.addActionListener(this);
        this.findNextButton.setEnabled(false);
        this.findPrevButton.addActionListener(this);
        this.findPrevButton.setEnabled(false);
        this.cancelButton.addActionListener(this);
        contentPane.add((Component)this.buttonPanel, "East");
        this.addWindowListener(this);
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.45);
        dim.width = (int)((double)screenSize.width * 0.35);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.editButton) {
            int size = this.scripts.size();
            int idx = this.scriptList.getSelectedIndex();
            if (idx >= 0 && this.scripts.size() > 0) {
                Script selectedScript = this.scripts.elementAt(idx);
                String title = "Edit Script " + selectedScript.getName();
                if (this.reportMain.isSecureMode() && this.securedScripts != null) {
                    for (String securedScript : this.securedScripts) {
                        if (!selectedScript.getName().equals(securedScript)) continue;
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot edit secured scripts when report designer is running in secured mode."));
                        return;
                    }
                }
                int reportIdx = this.report.scripts.indexOf(this.scripts.get(idx));
                NewEditDialog dialog = new NewEditDialog(this.reportMain, reportIdx, false, title);
                dialog.setVisible(true);
                if (dialog.isModified) {
                    this.isModified = true;
                }
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a script first"));
            }
            this.refreshList();
            if (size < this.report.scripts.size()) {
                this.scriptList.setSelectedIndex(size);
            } else {
                this.scriptList.setSelectedIndex(idx);
            }
        } else if (src == this.newButton) {
            String inputValue = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter script name"), LanguageEncoder.getText("Script Name"), -1);
            while (this.report.scriptExists(inputValue) || "".equals(inputValue)) {
                if (this.report.scriptExists(inputValue)) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("already exists!"));
                } else {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + LanguageEncoder.getText("Script name can not be empty!"));
                }
                inputValue = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter script name"), LanguageEncoder.getText("Script Name"), -1);
            }
            if (inputValue == null) {
                return;
            }
            Script sc = new Script(inputValue);
            NewEditDialog dialog = new NewEditDialog(this.reportMain, null, sc, null, "Edit Script " + inputValue);
            dialog.setVisible(true);
            if (dialog.isModified) {
                this.isModified = true;
            }
            this.refreshList();
            this.scriptList.setSelectedValue(inputValue, true);
        } else if (src == this.renameButton) {
            int idx = this.scriptList.getSelectedIndex();
            if (idx >= 0 && this.scripts.size() > 0) {
                String inputValue = (String)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter script name"), LanguageEncoder.getText("Script Name"), -1, null, null, this.scripts.elementAt(idx).getName());
                while (this.report.scriptExists(inputValue) || "".equals(inputValue)) {
                    if (this.report.scriptExists(inputValue)) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + " " + LanguageEncoder.getText("already exists!"));
                    } else {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), inputValue + LanguageEncoder.getText("Script name can not be empty!"));
                    }
                    inputValue = (String)JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter script name"), LanguageEncoder.getText("Script Name"), -1, null, null, this.report.scripts.elementAt(idx).getName());
                }
                if (inputValue == null) {
                    return;
                }
                this.scripts.elementAt(idx).setName(inputValue);
                this.securedScripts = this.report.getSecuredScripts();
                this.isModified = true;
                boolean secured = false;
                for (int j = 0; this.securedScripts != null && j < this.securedScripts.length && !secured; ++j) {
                    if (!inputValue.equals(this.securedScripts[j])) continue;
                    secured = true;
                }
                this.refreshList();
                this.scriptList.setSelectedValue(inputValue, true);
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a script first"));
            }
        } else if (src == this.deleteButton) {
            int idx = this.scriptList.getSelectedIndex();
            if (idx < 0 || this.scripts.size() == 0) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a script first"));
                return;
            }
            Script deleteScript = this.scripts.elementAt(idx);
            boolean internalReferenced = false;
            if (this.referencedScripts != null) {
                for (int i = 0; i < this.referencedScripts.length && !internalReferenced; ++i) {
                    if (deleteScript != this.referencedScripts[i]) continue;
                    internalReferenced = true;
                }
            }
            if (!internalReferenced) {
                internalReferenced = this.report.securityScriptReferenced(this.report.scripts.elementAt(idx));
            }
            boolean delete_Script = false;
            if (internalReferenced) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot delete this script because it is referenced by at least one report elements"));
            } else if (this.report.scriptReferenced(this.report.scripts.elementAt(idx))) {
                JMessageDialog prompt = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("This script is referenced by at least one report elements, remove anyway?"), 3);
                if (prompt.getResponse() == 6) {
                    delete_Script = true;
                    this.report.removeScriptReferenced(this.report.scripts.elementAt(idx));
                    this.reportMain.repaint();
                }
            } else {
                delete_Script = true;
            }
            if (delete_Script) {
                this.report.scripts.remove(this.scripts.get(idx));
                this.isModified = true;
                for (int i = 0; i < this.report.getFormulaParameters().size(); ++i) {
                    Parameter param = this.report.getFormulaParameters().elementAt(i);
                    param.removeFormula((String)this.scriptList.getSelectedValue());
                    if (param.getFormulaNames() == null || param.getFormulaNames().size() != 0) continue;
                    this.report.getFormulaParameters().remove(param);
                }
                this.refreshList();
            }
        } else if (src == this.applyButton) {
            if (this.reportMain.selectedObject == null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please select a cell first!"));
                return;
            }
            int idx = this.scriptList.getSelectedIndex();
            if (idx >= 0 && this.scripts.size() > 0) {
                try {
                    int datatype = -1;
                    Script script = this.scripts.elementAt(idx);
                    this.elt = this.reportMain.getSelectedObject();
                    if (this.elt.getScript() != null) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("This cell already has a script applied, cannot apply script again!"));
                        return;
                    }
                    if (this.reportMain.report.isCrossTab() && this.elt instanceof ColumnBreakColumn && (script.getText().toLowerCase().contains("value=") || script.getText().toLowerCase().contains("value ="))) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please do NOT change Column Break Value's value!"));
                        return;
                    }
                    ReportCell cell = null;
                    Object dataobj = null;
                    ReportTableElement tableElt = null;
                    ReportTable tbl = this.report.getReportTables().elementAt(0);
                    if (this.elt instanceof ReportImage) {
                        cell = ReportCell.clone((ReportCell)this.elt);
                    } else if (this.elt instanceof ReportCell) {
                        datatype = Operand.mapToOperandType(((ReportCell)this.elt).getSQLType());
                        script.setThisDataType(datatype);
                        cell = ReportCell.clone((ReportCell)this.elt);
                        dataobj = ((ReportCell)this.elt).getFormulaObj() != null ? ((ReportCell)this.elt).getFormulaObj().getValue(tbl, 0, 1, 1, 1, 1, this.report, cell, dataobj) : this.elt.getText();
                    } else if (this.elt instanceof ReportColumn) {
                        datatype = Operand.mapToOperandType(this.report.getSQLType(this.report.getColInfoIndex((ReportColumn)this.elt)));
                        script.setThisDataType(datatype);
                        cell = new ReportCell((ReportColumn)this.elt, 0);
                        dataobj = ((ReportColumn)this.elt).getData(0);
                    } else if (this.elt instanceof ReportSection) {
                        tableElt = new ReportSection((ReportSection)this.elt);
                    } else if (this.elt instanceof ReportTable) {
                        tableElt = new ReportTable();
                        tableElt.copy((ReportTable)this.elt);
                    }
                    if (this.elt instanceof ReportTableElement) {
                        script.testApplyScript(tbl, 1, 1, 1, 1, this.report, tableElt);
                    } else {
                        script.testApplyScript(tbl, 0, 1, 1, 1, 1, this.report, cell, dataobj, null);
                    }
                    this.reportMain.setSelectedScript(script);
                    this.reportMain.doneSetEltScript();
                    this.refreshList();
                    this.reportMain.selectedPanel.repaintFromScratch();
                    this.isModified = true;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "The script can not be applied to the cell", ex);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("The script can not be applied to the cell, please check the script again"));
                }
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Select a script first"));
            }
        } else if (src == this.removeButton) {
            int idx = this.scriptList.getSelectedIndex();
            this.elt.setScriptObj(null);
            this.elt.setScriptName(null);
            this.elt.setScript(null);
            this.refreshList();
            this.removeButton.setEnabled(false);
            this.scriptList.setSelectedIndex(idx);
            this.reportMain.selectedPanel.repaintFromScratch();
            this.isModified = true;
        } else if (src == this.viewAllButton) {
            int idx = this.scriptList.getSelectedIndex();
            if (idx >= 0 && this.scripts.size() > 0) {
                Script script;
                this.reportMain.currentScript = script = this.scripts.elementAt(idx);
                boolean found = this.reportMain.findFirstElementWithCurrentScript();
                if (found) {
                    this.removeButton.setEnabled(true);
                }
            }
            this.elt = this.reportMain.getSelectedObject();
            this.refreshList();
        } else if (src == this.findNextButton) {
            int idx = this.scriptList.getSelectedIndex();
            if (idx >= 0 && this.scripts.size() > 0) {
                Script script;
                this.reportMain.currentScript = script = this.scripts.elementAt(idx);
                boolean found = this.reportMain.findNextElementWithCurrentScript();
                if (found) {
                    this.removeButton.setEnabled(true);
                }
            }
            this.elt = this.reportMain.getSelectedObject();
            this.refreshList();
        } else if (src == this.findPrevButton) {
            int idx = this.scriptList.getSelectedIndex();
            if (idx >= 0 && this.scripts.size() > 0) {
                Script script;
                this.reportMain.currentScript = script = this.scripts.elementAt(idx);
                boolean found = this.reportMain.findPreviousElementWithCurrentScript();
                if (found) {
                    this.removeButton.setEnabled(true);
                }
            }
            this.elt = this.reportMain.getSelectedObject();
            this.refreshList();
        } else if (src == this.cancelButton) {
            if (this.reportMain.isModified()) {
                this.reportMain.menuBar.setUndoEnabled(true);
            }
            this.reportMain.currentScript = null;
            this.setVisible(false);
            this.dispose();
        }
    }

    protected void setReferencedScripts(Script[] scripts) {
        this.referencedScripts = scripts;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.reportMain.isModified()) {
            this.reportMain.menuBar.setUndoEnabled(true);
        }
        this.reportMain.currentScript = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        if (this.isModified) {
            this.reportMain.setModified();
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int size = ScriptDialog.this.scripts.size();
                int idx = ScriptDialog.this.scriptList.locationToIndex(e.getPoint());
                if (idx < 0 || size == 0) {
                    return;
                }
                Script selectedScript = (Script)ScriptDialog.this.scripts.elementAt(idx);
                String title = "Edit Script " + selectedScript.getName();
                if (ScriptDialog.this.reportMain.isSecureMode() && ScriptDialog.this.securedScripts != null) {
                    for (String securedScript : ScriptDialog.this.securedScripts) {
                        if (!selectedScript.getName().equals(securedScript)) continue;
                        new JMessageDialog((Dialog)ScriptDialog.this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Cannot edit secured scripts when report designer is running in secured mode."));
                        return;
                    }
                }
                int reportIdx = ScriptDialog.this.report.scripts.indexOf(ScriptDialog.this.scripts.get(idx));
                NewEditDialog dialog = new NewEditDialog(ScriptDialog.this.reportMain, reportIdx, false, title);
                dialog.setVisible(true);
                if (dialog.isModified) {
                    ScriptDialog.this.isModified = true;
                }
                ScriptDialog.this.refreshList();
                if (size < ScriptDialog.this.report.scripts.size()) {
                    ScriptDialog.this.scriptList.setSelectedIndex(size);
                } else {
                    ScriptDialog.this.scriptList.setSelectedIndex(idx);
                }
            } else {
                int idx = ScriptDialog.this.scriptList.locationToIndex(e.getPoint());
                if (idx >= 0) {
                    ScriptDialog.this.viewAllButton.setEnabled(true);
                    ScriptDialog.this.findPrevButton.setEnabled(true);
                    ScriptDialog.this.findNextButton.setEnabled(true);
                    ScriptDialog.this.update(ScriptDialog.this.reportMain);
                }
            }
        }
    }
}

