/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.ScriptDialog;
import quadbase.reportdesigner.report.NewScriptParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Script;

public class SecurityDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SecurityDialog.class.getName());
    private ReportMain reportMain = null;
    private ReportElement element = null;
    private JList allSecurityLevels = null;
    private Vector<ReportElement> securityLevels = null;
    private JComboBox levelComboBox = null;
    private JTextField textField;
    private JTextField scriptText;
    private JRadioButton trueButton;
    private JRadioButton falseButton;
    private JCheckBox textEnable;
    private JCheckBox scriptEnable;
    private JCheckBox shiftColX;
    private JCheckBox includeHandF;
    private JLabel textLabel;
    private JLabel scriptLabel;
    private JButton changeButton;
    private int currentSelectedIndex = -1;
    private boolean modified = false;
    private JButton applyBut;
    private boolean isTableSection = false;

    public SecurityDialog(ReportMain rm, ReportElement element) {
        super((Frame)rm, true);
        this.reportMain = rm;
        if (rm.selectedPanel != null && rm.selectedPanel.getElement() instanceof ReportTable) {
            this.isTableSection = true;
        }
        this.element = element;
        this.init(rm.report);
        this.setPosition();
    }

    private void init(Report report) {
        Vector<String> ls2;
        String[] ls;
        this.setDefaultCloseOperation(2);
        this.setTitle(LanguageEncoder.getText("Security Controls"));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel listPanel = new JPanel(gbl);
        listPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Security Levels")));
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String element2 : ls = report.getSecurityLevels()) {
            model.addElement(element2);
        }
        if (this.reportMain.isFromOrganizer() && (ls2 = this.reportMain.getPresetSecurityLevels()) != null) {
            for (int i = 0; i < ls2.size(); ++i) {
                String val = ls2.elementAt(i);
                if (this.exists(ls, val)) continue;
                model.addElement(val);
            }
        }
        this.allSecurityLevels = new JList(model);
        JScrollPane scroll = new JScrollPane(this.allSecurityLevels);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(200, (int)d.getHeight()));
        gbl.setConstraints(scroll, gbc);
        listPanel.add(scroll);
        if (!this.reportMain.isFromOrganizer()) {
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 15, 10, 10);
            JButton button = new JButton(LanguageEncoder.getText("Add New"));
            gbl.setConstraints(button, gbc);
            listPanel.add(button);
            button.setActionCommand("New Security");
            button.addActionListener(this);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(10, 10, 10, 15);
            button = new JButton(LanguageEncoder.getText("Rename"));
            gbl.setConstraints(button, gbc);
            listPanel.add(button);
            button.setActionCommand("Rename Security");
            button.addActionListener(this);
        }
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel propertiesPanel = new JPanel(gbl);
        propertiesPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Security Properties")));
        String[] levelNames = this.element.getSecurityLevels();
        this.securityLevels = new Vector();
        for (String levelName : levelNames) {
            ReportCell cell = new ReportCell();
            cell.copy(this.element.getSecurityLevel(levelName));
            this.securityLevels.add(cell);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 5;
        gbc.insets = new Insets(5, 20, 20, 20);
        gbc.fill = 2;
        DefaultComboBoxModel<String> levelNameModel = new DefaultComboBoxModel<String>(levelNames);
        this.levelComboBox = new JComboBox<String>(levelNameModel);
        gbl.setConstraints(this.levelComboBox, gbc);
        propertiesPanel.add(this.levelComboBox);
        this.levelComboBox.addItemListener(this);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 5, 10);
        gbc.fill = 0;
        gbc.anchor = 13;
        JLabel label = new JLabel(LanguageEncoder.getText("Visible:"));
        gbl.setConstraints(label, gbc);
        propertiesPanel.add(label);
        gbc.gridx = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 10;
        ButtonGroup bgroup = new ButtonGroup();
        this.trueButton = new JRadioButton(LanguageEncoder.getText("True"));
        bgroup.add(this.trueButton);
        gbl.setConstraints(this.trueButton, gbc);
        propertiesPanel.add(this.trueButton);
        this.trueButton.addItemListener(this);
        gbc.gridx = 3;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.falseButton = new JRadioButton(LanguageEncoder.getText("False"));
        bgroup.add(this.falseButton);
        gbl.setConstraints(this.falseButton, gbc);
        propertiesPanel.add(this.falseButton);
        this.falseButton.addItemListener(this);
        if (!this.isTableSection) {
            gbc.gridx = 4;
            gbc.weightx = 0.0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            this.shiftColX = new JCheckBox(LanguageEncoder.getText("Shift Column X"));
            gbl.setConstraints(this.shiftColX, gbc);
            propertiesPanel.add(this.shiftColX);
        } else {
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 0.0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            this.shiftColX = new JCheckBox(LanguageEncoder.getText("Shift Column X"));
            gbl.setConstraints(this.shiftColX, gbc);
            propertiesPanel.add(this.shiftColX);
            gbc.gridx = 3;
            gbc.weightx = 0.0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            this.includeHandF = new JCheckBox(LanguageEncoder.getText("Include Header and Footer"));
            gbl.setConstraints(this.includeHandF, gbc);
            propertiesPanel.add(this.includeHandF);
            this.shiftColX.addItemListener(this);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 10, 5, 0);
        this.textEnable = new JCheckBox();
        gbl.setConstraints(this.textEnable, gbc);
        propertiesPanel.add(this.textEnable);
        this.textEnable.addItemListener(this);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 5, 10);
        gbc.anchor = 13;
        this.textLabel = new JLabel(LanguageEncoder.getText("Text:"));
        gbl.setConstraints(this.textLabel, gbc);
        propertiesPanel.add(this.textLabel);
        this.textLabel.setEnabled(false);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(0, 0, 5, 10);
        gbc.fill = 2;
        this.textField = new JTextField();
        gbl.setConstraints(this.textField, gbc);
        propertiesPanel.add(this.textField);
        this.textField.setEnabled(false);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 10, 0, 0);
        this.scriptEnable = new JCheckBox();
        gbl.setConstraints(this.scriptEnable, gbc);
        propertiesPanel.add(this.scriptEnable);
        this.scriptEnable.addItemListener(this);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 10);
        gbc.fill = 0;
        gbc.anchor = 13;
        this.scriptLabel = new JLabel(LanguageEncoder.getText("Script:"));
        gbl.setConstraints(this.scriptLabel, gbc);
        propertiesPanel.add(this.scriptLabel);
        this.scriptLabel.setEnabled(false);
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 2;
        this.scriptText = new JTextField(15);
        gbl.setConstraints(this.scriptText, gbc);
        propertiesPanel.add(this.scriptText);
        this.scriptText.setEditable(false);
        gbc.gridx = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.changeButton = new JButton(LanguageEncoder.getText("Change..."));
        gbl.setConstraints(this.changeButton, gbc);
        propertiesPanel.add(this.changeButton);
        this.changeButton.setActionCommand("Change");
        this.changeButton.addActionListener(this);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(20, 5, 0, 0);
        JLabel b = new JLabel(LanguageEncoder.getText("Click the button below to apply these properties"));
        b.setVerticalAlignment(3);
        gbl.setConstraints(b, gbc);
        propertiesPanel.add(b);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 5, 0, 0);
        b = new JLabel(LanguageEncoder.getText("to all cells with the same security level defined."));
        b.setVerticalAlignment(1);
        gbl.setConstraints(b, gbc);
        propertiesPanel.add(b);
        ++gbc.gridy;
        gbc.anchor = 10;
        gbc.insets = new Insets(10, 0, 10, 0);
        this.applyBut = new JButton(LanguageEncoder.getText("Apply All"));
        this.applyBut.setActionCommand("Apply All");
        this.applyBut.addActionListener(this);
        gbl.setConstraints(this.applyBut, gbc);
        propertiesPanel.add(this.applyBut);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        d = new Dimension(1, 1);
        Box.Filler filler = new Box.Filler(d, d, d);
        gbl.setConstraints(filler, gbc);
        propertiesPanel.add(filler);
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel topPanel = new JPanel(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 4;
        gbc.fill = 1;
        gbl.setConstraints(listPanel, gbc);
        topPanel.add(listPanel);
        gbc.gridx = 1;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        d = new Dimension(1, 40);
        filler = new Box.Filler(d, d, d);
        gbl.setConstraints(filler, gbc);
        topPanel.add(filler);
        gbc.gridy = 1;
        gbc.insets = new Insets(10, 5, 0, 5);
        JButton addButton = new JButton(LanguageEncoder.getText("ADD >>"));
        gbl.setConstraints(addButton, gbc);
        topPanel.add(addButton);
        addButton.setActionCommand("Add");
        addButton.addActionListener(this);
        gbc.gridy = 2;
        JButton removeButton = new JButton(LanguageEncoder.getText("<< REMOVE"));
        gbl.setConstraints(removeButton, gbc);
        topPanel.add(removeButton);
        removeButton.setActionCommand("Remove");
        removeButton.addActionListener(this);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(propertiesPanel, gbc);
        topPanel.add(propertiesPanel);
        contentPane.add((Component)topPanel, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(LanguageEncoder.getText("OK"));
        bottomPanel.add(okButton);
        JButton cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        bottomPanel.add(cancelButton);
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        contentPane.add((Component)bottomPanel, "South");
        if (this.securityLevels.size() > 0) {
            this.levelComboBox.setSelectedIndex(0);
            this.updateProperties();
        }
        this.updateTextScriptEnable();
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.levelComboBox.getModel();
        if (this.applyBut != null) {
            this.applyBut.setEnabled(model2.getSize() > 0);
        }
    }

    private void updateTextScriptEnable() {
        if (this.reportMain.selectedObject instanceof SubReportObject || this.reportMain.selectedObject instanceof TableOfContents || this.reportMain.selectedObject instanceof ReportImage && !(this.reportMain.selectedObject instanceof ReportChartObject) || this.reportMain.selectedObject instanceof ReportRTFObject) {
            this.textEnable.setSelected(false);
            this.scriptEnable.setSelected(false);
            this.textEnable.setEnabled(false);
            this.scriptEnable.setEnabled(false);
            this.textLabel.setEnabled(false);
            this.scriptLabel.setEnabled(false);
            this.textField.setText("");
            this.scriptText.setText("");
            this.textField.setEnabled(false);
            this.scriptText.setEnabled(false);
        }
    }

    private boolean exists(String[] listStr, String str) {
        for (String element2 : listStr) {
            if (!element2.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("New Security".equals(command)) {
            boolean OK = false;
            JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter New Name:"), 3, 2);
            String tmp = "";
            while (!OK) {
                optionPane.setInputValue(tmp);
                optionPane.setWantsInput(true);
                JDialog dialog = optionPane.createDialog(this, LanguageEncoder.getText("New Security Level Name"));
                dialog.setVisible(true);
                dialog.dispose();
                if (!Integer.valueOf(0).equals(optionPane.getValue())) {
                    return;
                }
                tmp = (String)optionPane.getInputValue();
                DefaultListModel model = (DefaultListModel)this.allSecurityLevels.getModel();
                if (tmp != null && !tmp.trim().equals("")) {
                    boolean error = false;
                    tmp = tmp.trim();
                    for (int i = 0; i < model.size() && !error; ++i) {
                        if (!tmp.equals(model.get(i))) continue;
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Security level already exists:") + " " + tmp);
                        error = true;
                    }
                    if (error) continue;
                    model.addElement(tmp);
                    this.doAdd(tmp);
                    OK = true;
                    continue;
                }
                OK = true;
            }
            this.repaint();
        } else if ("Rename Security".equals(command)) {
            String toBeRenamed = (String)this.allSecurityLevels.getSelectedValue();
            if (toBeRenamed == null || toBeRenamed.trim().equals("")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please select a security level first"));
                return;
            }
            boolean OK = false;
            JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter New Name:"), 3, 2);
            String tmp = "";
            while (!OK) {
                optionPane.setInputValue(tmp);
                optionPane.setWantsInput(true);
                JDialog dialog = optionPane.createDialog(this, LanguageEncoder.getText("Rename Security Level"));
                dialog.setVisible(true);
                dialog.dispose();
                if (!Integer.valueOf(0).equals(optionPane.getValue())) {
                    return;
                }
                tmp = (String)optionPane.getInputValue();
                DefaultListModel model = (DefaultListModel)this.allSecurityLevels.getModel();
                if (tmp != null && !tmp.trim().equals("")) {
                    boolean error = false;
                    tmp = tmp.trim();
                    for (int i = 0; i < model.size() && !error; ++i) {
                        if (!tmp.equals(model.get(i))) continue;
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Security level already exists:") + " " + tmp);
                        error = true;
                    }
                    if (error) continue;
                    model.removeElement(toBeRenamed);
                    model.addElement(tmp);
                    this.doRename(toBeRenamed, tmp);
                    OK = true;
                    continue;
                }
                OK = true;
            }
            this.repaint();
        } else if ("Add".equals(command)) {
            Object[] objs = this.allSecurityLevels.getSelectedValues();
            if (objs != null) {
                for (Object obj : objs) {
                    if (obj == null) continue;
                    this.doAdd(obj.toString());
                }
            }
        } else if ("Remove".equals(command)) {
            this.doRemove();
        } else if ("Change".equals(command)) {
            this.doChange();
        } else if ("OK".equals(command)) {
            this.updateProperties();
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if ("Cancel".equals(command)) {
            this.setVisible(false);
            this.dispose();
        } else if ("Apply All".equals(command)) {
            this.doApplyProperties();
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
        if (this.applyBut != null) {
            this.applyBut.setEnabled(model.getSize() > 0);
        }
    }

    private void doAdd(String levelName) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
        int i = 0;
        for (i = 0; i < model.getSize(); ++i) {
            if (!levelName.equals(model.getElementAt(i))) continue;
            i = model.getSize() + 1;
        }
        if (i == model.getSize()) {
            ReportElement newLevel = this.element.addSecurityLevel(levelName);
            this.element.removeSecurityLevel(levelName);
            this.securityLevels.add(newLevel);
            model.addElement(levelName);
        }
        this.levelComboBox.setSelectedItem(levelName);
        this.updateProperties();
    }

    private void doRemove() {
        int index = this.levelComboBox.getSelectedIndex();
        if (index >= 0) {
            this.currentSelectedIndex = -1;
            this.securityLevels.removeElementAt(index);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
            model.removeElementAt(index);
            this.updateProperties();
        }
    }

    private void doChange() {
        ReportElement level = null;
        try {
            Vector<Script> referencedScripts = new Vector<Script>();
            if (this.element.getScriptObj() != null) {
                referencedScripts.add(this.element.getScriptObj());
            }
            for (int i = 0; i < this.securityLevels.size(); ++i) {
                ReportElement l = this.securityLevels.elementAt(i);
                if (l.getScriptObj() == null) continue;
                referencedScripts.add(l.getScriptObj());
            }
            int index = this.levelComboBox.getSelectedIndex();
            if (index >= 0 && index < this.securityLevels.size()) {
                level = this.securityLevels.elementAt(index);
                referencedScripts.removeElement(level.getScriptObj());
                this.element.switchSecurityProperties(level);
                Script[] rs = new Script[referencedScripts.size()];
                for (int i = 0; i < rs.length; ++i) {
                    rs[i] = (Script)referencedScripts.elementAt(i);
                }
                this.reportMain.setSelectedScript(null);
                ScriptDialog sdialog = new ScriptDialog(this.reportMain);
                sdialog.setModal(true);
                sdialog.setReferencedScripts(rs);
                sdialog.setVisible(true);
                if (this.reportMain.getSelectedScript() != null) {
                    this.element.setScriptObj(this.reportMain.getSelectedScript());
                    this.reportMain.setSelectedScript(null);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot change security properties", ex);
        }
        this.element.switchSecurityProperties(level);
        this.updateProperties();
    }

    private void updateProperties() {
        String scripttext;
        ReportElement level;
        if (this.currentSelectedIndex >= 0 && this.currentSelectedIndex < this.securityLevels.size()) {
            level = this.securityLevels.elementAt(this.currentSelectedIndex);
            level.setVisible(this.trueButton.isSelected());
            if (this.trueButton.isSelected()) {
                if (this.textEnable.isSelected()) {
                    scripttext = this.textField.getText();
                    if (scripttext == null) {
                        scripttext = "";
                    }
                    scripttext = scripttext.trim();
                    scripttext = QbUtil.replace(scripttext, "\"", "\\\"");
                    scripttext = "\"" + scripttext + "\";";
                    Script script = new Script("Quadbase Internal Text Script");
                    try {
                        NewScriptParser parser = new NewScriptParser(new InputStreamReader((InputStream)new ByteArrayInputStream(scripttext.getBytes("UTF-8")), "UTF-8"));
                        script.setScript(parser.parse(null, null, null, script.getName(), this.reportMain.report));
                        script.setText(scripttext);
                        level.setSecurityTextScript(true);
                        level.setScriptObj(script);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Cannot update security properties", ex);
                        level.setSecurityTextScript(false);
                        level.setScriptObj(null);
                    }
                } else {
                    level.setSecurityTextScript(false);
                    if (!this.scriptEnable.isSelected()) {
                        level.setScriptObj(null);
                        level.setScriptName(null);
                        level.setScript(null);
                    }
                }
            } else {
                level.setShiftSecuredColX(this.shiftColX.isSelected());
                if (this.isTableSection) {
                    level.setShiftSecuredColXIncludeHeaderAndFooter(this.includeHandF.isSelected());
                }
                level.setSecurityTextScript(false);
                level.setScriptObj(null);
                level.setScriptName(null);
                level.setScript(null);
            }
        }
        this.currentSelectedIndex = this.levelComboBox.getSelectedIndex();
        this.textField.setText("");
        this.scriptText.setText("");
        if (this.currentSelectedIndex >= 0 && this.currentSelectedIndex < this.securityLevels.size()) {
            level = this.securityLevels.elementAt(this.currentSelectedIndex);
            if (level.isVisible()) {
                this.trueButton.setSelected(true);
            } else {
                this.falseButton.setSelected(true);
            }
            this.shiftColX.setSelected(level.isShiftSecuredColX());
            if (this.isTableSection) {
                this.includeHandF.setSelected(level.isShiftSecuredColXIncludeHeaderAndFooter());
            }
            if (level.isSecurityTextScript()) {
                scripttext = level.getScript();
                if (scripttext != null && scripttext.trim().startsWith("\"") && scripttext.trim().endsWith("\";")) {
                    scripttext = scripttext.trim().substring(1);
                    scripttext = scripttext.trim().substring(0, scripttext.length() - 2);
                    this.textField.setText(scripttext);
                    this.textEnable.setSelected(true);
                } else {
                    this.textEnable.setSelected(false);
                    this.scriptEnable.setSelected(false);
                }
            } else {
                this.textEnable.setSelected(false);
                if (level.getScriptName() != null) {
                    this.scriptText.setText(level.getScriptName());
                    this.scriptEnable.setSelected(true);
                } else {
                    this.scriptEnable.setSelected(false);
                }
            }
        } else {
            this.falseButton.setSelected(true);
            this.textEnable.setSelected(false);
            this.scriptEnable.setSelected(false);
        }
        this.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.levelComboBox) {
            this.updateProperties();
            return;
        }
        if (e.getItem() == this.falseButton && this.falseButton.isSelected()) {
            this.textEnable.setEnabled(false);
            this.scriptEnable.setEnabled(false);
            this.textLabel.setEnabled(false);
            this.textField.setEnabled(false);
            this.scriptLabel.setEnabled(false);
            this.scriptText.setEnabled(false);
            this.changeButton.setEnabled(false);
            this.shiftColX.setEnabled(true);
            if (this.isTableSection) {
                this.includeHandF.setEnabled(this.shiftColX.isSelected());
            }
            return;
        }
        if (e.getItem() == this.trueButton && this.trueButton.isSelected()) {
            this.textEnable.setEnabled(true);
            this.scriptEnable.setEnabled(true);
            this.shiftColX.setEnabled(false);
            if (this.isTableSection) {
                this.includeHandF.setEnabled(false);
            }
        } else if (e.getItem() == this.shiftColX && this.isTableSection) {
            this.includeHandF.setEnabled(this.shiftColX.isSelected() && this.shiftColX.isEnabled());
        }
        if (this.textEnable.isSelected() && this.scriptEnable.isSelected()) {
            if (e.getItem() == this.textEnable) {
                this.scriptEnable.setSelected(false);
            } else if (e.getItem() == this.scriptEnable) {
                this.textEnable.setSelected(false);
            }
        }
        this.textLabel.setEnabled(this.trueButton.isSelected() && this.textEnable.isSelected());
        this.textField.setEnabled(this.trueButton.isSelected() && this.textEnable.isSelected());
        this.scriptLabel.setEnabled(this.trueButton.isSelected() && this.scriptEnable.isSelected());
        this.scriptText.setEnabled(this.trueButton.isSelected() && this.scriptEnable.isSelected());
        this.changeButton.setEnabled(this.trueButton.isSelected() && this.scriptEnable.isSelected());
        this.updateTextScriptEnable();
    }

    public boolean isModified() {
        return this.modified;
    }

    public Hashtable<String, ReportElement> getSecurityMap() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
        if (model.getSize() > 0) {
            Hashtable<String, ReportElement> table = new Hashtable<String, ReportElement>();
            for (int i = 0; i < model.getSize(); ++i) {
                table.put(model.getElementAt(i).toString(), this.securityLevels.elementAt(i));
            }
            return table;
        }
        return null;
    }

    private void doApplyProperties() {
        this.updateProperties();
        if (this.currentSelectedIndex >= 0 && this.currentSelectedIndex < this.securityLevels.size()) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
            String levelstring = (String)model.getElementAt(this.currentSelectedIndex);
            ReportElement level = this.securityLevels.elementAt(this.currentSelectedIndex);
            this.reportMain.report.setSecurityLevelProperties(levelstring, level);
            this.reportMain.setModified();
        }
    }

    private void doRename(String oldName, String newName) {
        this.reportMain.report.renameSecurityLevel(oldName, newName);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
        int index = -1;
        for (int i = 0; i < model.getSize(); ++i) {
            String levelName = (String)model.getElementAt(i);
            if (!levelName.equals(oldName)) continue;
            index = i;
        }
        if (index >= 0) {
            model.removeElementAt(index);
            model.insertElementAt(newName, index);
            this.updateProperties();
            model.setSelectedItem(newName);
        }
    }
}

