/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.OurPanel;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.Report;

public class SecurityQueryParameterDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SecurityQueryParameterDialog.class.getName());
    private ReportMain reportMain = null;
    private JList allSecurityLevels = null;
    private Vector securityLevels = null;
    private JComboBox levelComboBox = null;
    private int currentSelectedIndex = -1;
    private boolean modified = false;
    private QueryFileInfo fileInfo = null;
    private JComboBox[] choiceArray = null;
    private JTextField[] textArray = null;
    private JList[] listArray = null;
    private JCheckBox[] checkboxArray = null;
    private JButton[] selectAllButtonArray;
    private JButton[] unselectAllButtonArray;

    public SecurityQueryParameterDialog(ReportMain rm, QueryFileInfo dbinfo, Hashtable oldSettings) {
        super((Frame)rm, true);
        this.reportMain = rm;
        this.fileInfo = dbinfo;
        this.init(rm.report, oldSettings);
        this.setPosition();
    }

    private void init(Report report, Hashtable oldSettings) {
        Vector<String> ls2;
        String[] ls;
        this.setDefaultCloseOperation(2);
        this.setTitle(LanguageEncoder.getText("Security Controls"));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel listPanel = new JPanel(gbl);
        listPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Security Levels")));
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String element : ls = report.getSecurityLevels()) {
            model.addElement(element);
        }
        if (this.reportMain.isFromOrganizer() && (ls2 = this.reportMain.getPresetSecurityLevels()) != null) {
            for (int i = 0; i < ls2.size(); ++i) {
                String val = ls2.elementAt(i);
                if (this.exists(ls, val)) continue;
                model.addElement(val);
            }
        }
        this.allSecurityLevels = new JList(model);
        JScrollPane scroll = new JScrollPane(this.allSecurityLevels);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(200, (int)d.getHeight()));
        gbl.setConstraints(scroll, gbc);
        listPanel.add(scroll);
        if (!this.reportMain.isFromOrganizer()) {
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 15, 10, 10);
            JButton button = new JButton(LanguageEncoder.getText("Add New"));
            gbl.setConstraints(button, gbc);
            listPanel.add(button);
            button.setActionCommand("New Security");
            button.addActionListener(this);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(10, 10, 10, 15);
            button = new JButton(LanguageEncoder.getText("Rename"));
            gbl.setConstraints(button, gbc);
            listPanel.add(button);
            button.setActionCommand("Rename Security");
            button.addActionListener(this);
        }
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel propertiesPanel = new JPanel(gbl);
        propertiesPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Security Properties")));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 20, 20, 20);
        gbc.fill = 2;
        DefaultComboBoxModel levelNameModel = new DefaultComboBoxModel();
        this.levelComboBox = new JComboBox(levelNameModel);
        gbl.setConstraints(this.levelComboBox, gbc);
        propertiesPanel.add(this.levelComboBox);
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        JPanel container = new JPanel();
        scroll = new JScrollPane(container);
        this.createParamPanel(container);
        d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(300, (int)d.getHeight()));
        gbl.setConstraints(scroll, gbc);
        propertiesPanel.add(scroll);
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel topPanel = new JPanel(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 4;
        gbc.fill = 1;
        gbl.setConstraints(listPanel, gbc);
        topPanel.add(listPanel);
        gbc.gridx = 1;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        d = new Dimension(1, 40);
        Box.Filler filler = new Box.Filler(d, d, d);
        gbl.setConstraints(filler, gbc);
        topPanel.add(filler);
        gbc.gridy = 1;
        gbc.insets = new Insets(10, 5, 0, 5);
        JButton addButton = new JButton(LanguageEncoder.getText("ADD >>"));
        gbl.setConstraints(addButton, gbc);
        topPanel.add(addButton);
        addButton.setActionCommand("Add");
        addButton.addActionListener(this);
        gbc.gridy = 2;
        JButton removeButton = new JButton(LanguageEncoder.getText("<< REMOVE"));
        gbl.setConstraints(removeButton, gbc);
        topPanel.add(removeButton);
        removeButton.setActionCommand("Remove");
        removeButton.addActionListener(this);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(propertiesPanel, gbc);
        topPanel.add(propertiesPanel);
        contentPane.add((Component)topPanel, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(LanguageEncoder.getText("OK"));
        bottomPanel.add(okButton);
        JButton cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        bottomPanel.add(cancelButton);
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        contentPane.add((Component)bottomPanel, "South");
        QueryInParam[] masterParams = null;
        masterParams = this.fileInfo == null ? new QueryInParam[]{} : this.fileInfo.getInSet().getParameter();
        this.securityLevels = new Vector();
        Vector<String> levelNames = null;
        Vector<String> errorLevelNames = new Vector<String>();
        if (oldSettings != null) {
            levelNames = new Vector<String>();
            Enumeration enum1 = oldSettings.keys();
            while (enum1.hasMoreElements()) {
                String levelname = (String)enum1.nextElement();
                QueryInParam[] map = QueryParser.verifyAndCopyParameters(masterParams, (QueryInParam[])oldSettings.get(levelname));
                this.securityLevels.add(map);
                if (map == null) {
                    errorLevelNames.add(levelname);
                }
                levelNames.add(levelname);
            }
        }
        if (levelNames != null) {
            DefaultComboBoxModel cmodel = (DefaultComboBoxModel)this.levelComboBox.getModel();
            for (int i = 0; i < levelNames.size(); ++i) {
                cmodel.addElement(levelNames.elementAt(i));
            }
        }
        if (errorLevelNames.size() > 0) {
            String errorMsg = LanguageEncoder.getText("The following security levels need to be\nupdated because the datasource has changed:");
            for (int i = 0; i < errorLevelNames.size(); ++i) {
                errorMsg = errorMsg + "\n" + errorLevelNames.elementAt(i);
            }
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), errorMsg);
        }
        if (this.securityLevels.size() > 0) {
            this.levelComboBox.setSelectedIndex(0);
            try {
                this.updateProperties();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot update security properties", ex);
            }
        }
        this.levelComboBox.addItemListener(this);
    }

    private boolean exists(String[] listStr, String str) {
        for (String element : listStr) {
            if (!element.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block26: {
            String command;
            block29: {
                block28: {
                    block27: {
                        command = e.getActionCommand();
                        if (!"New Security".equals(command)) break block27;
                        boolean OK = false;
                        JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter New Name:"), 3, 2);
                        String tmp = "";
                        while (!OK) {
                            optionPane.setInputValue(tmp);
                            optionPane.setWantsInput(true);
                            JDialog dialog = optionPane.createDialog(this, LanguageEncoder.getText("New Security Level Name"));
                            dialog.setVisible(true);
                            dialog.dispose();
                            if (!Integer.valueOf(0).equals(optionPane.getValue())) {
                                return;
                            }
                            tmp = (String)optionPane.getInputValue();
                            DefaultListModel model = (DefaultListModel)this.allSecurityLevels.getModel();
                            if (tmp != null && !tmp.trim().equals("")) {
                                boolean error = false;
                                tmp = tmp.trim();
                                for (int i = 0; i < model.size() && !error; ++i) {
                                    if (!tmp.equals(model.get(i))) continue;
                                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Security level already exists:") + " " + tmp);
                                    error = true;
                                }
                                if (error) continue;
                                model.addElement(tmp);
                                this.doAdd(tmp);
                                OK = true;
                                continue;
                            }
                            OK = true;
                        }
                        this.repaint();
                        break block26;
                    }
                    if (!"Rename Security".equals(command)) break block28;
                    String toBeRenamed = (String)this.allSecurityLevels.getSelectedValue();
                    if (toBeRenamed == null || toBeRenamed.trim().equals("")) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please select a security level first"));
                        return;
                    }
                    boolean OK = false;
                    JOptionPane optionPane = new JOptionPane(LanguageEncoder.getText("Enter New Name:"), 3, 2);
                    String tmp = "";
                    while (!OK) {
                        optionPane.setInputValue(tmp);
                        optionPane.setWantsInput(true);
                        JDialog dialog = optionPane.createDialog(this, LanguageEncoder.getText("Rename Security Level"));
                        dialog.setVisible(true);
                        dialog.dispose();
                        if (!Integer.valueOf(0).equals(optionPane.getValue())) {
                            return;
                        }
                        tmp = (String)optionPane.getInputValue();
                        DefaultListModel model = (DefaultListModel)this.allSecurityLevels.getModel();
                        if (tmp != null && !tmp.trim().equals("")) {
                            boolean error = false;
                            tmp = tmp.trim();
                            for (int i = 0; i < model.size() && !error; ++i) {
                                if (!tmp.equals(model.get(i))) continue;
                                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Security level already exists:") + " " + tmp);
                                error = true;
                            }
                            if (error) continue;
                            model.removeElement(toBeRenamed);
                            model.addElement(tmp);
                            this.doRename(toBeRenamed, tmp);
                            OK = true;
                            continue;
                        }
                        OK = true;
                    }
                    this.repaint();
                    break block26;
                }
                if (!"Add".equals(command)) break block29;
                Object[] objs = this.allSecurityLevels.getSelectedValues();
                if (objs == null) break block26;
                for (Object obj : objs) {
                    if (obj == null) continue;
                    this.doAdd(obj.toString());
                }
                break block26;
            }
            if ("Remove".equals(command)) {
                this.doRemove();
            } else if ("OK".equals(command)) {
                try {
                    this.updateProperties();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "An error occured while processing the parameter values", ex);
                    String errorMessage = ex.getMessage();
                    if (errorMessage == null) {
                        errorMessage = LanguageEncoder.getText("An error occured while processing the parameter values:\n") + ex.toString();
                    }
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), errorMessage);
                    return;
                }
                Vector<String> errorLevelNames = new Vector<String>();
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
                for (int i = 0; i < this.securityLevels.size(); ++i) {
                    if (this.securityLevels.elementAt(i) != null) continue;
                    errorLevelNames.add(model.getElementAt(i).toString());
                }
                if (errorLevelNames.size() > 0) {
                    String msg = LanguageEncoder.getText("The following security levels are not initialized:\n");
                    for (int i = 0; i < errorLevelNames.size(); ++i) {
                        msg = msg + "\n" + errorLevelNames.elementAt(i).toString();
                    }
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                this.modified = true;
                this.setVisible(false);
                this.dispose();
            } else if ("Cancel".equals(command)) {
                this.setVisible(false);
                this.dispose();
            } else {
                Object source = e.getSource();
                for (int i = 0; i < this.selectAllButtonArray.length; ++i) {
                    if (this.listArray[i] == null) continue;
                    int cnt = this.listArray[i].getModel().getSize();
                    if (i >= this.checkboxArray.length || !this.checkboxArray[i].isSelected()) continue;
                    if (source == this.selectAllButtonArray[i]) {
                        int[] idices = new int[cnt];
                        for (int k = 0; k < idices.length; ++k) {
                            idices[k] = k;
                        }
                        this.listArray[i].setSelectedIndices(idices);
                    } else {
                        if (source != this.unselectAllButtonArray[i]) continue;
                        this.listArray[i].clearSelection();
                    }
                    break;
                }
            }
        }
    }

    private void doAdd(String levelName) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
        int i = 0;
        for (i = 0; i < model.getSize(); ++i) {
            if (!levelName.equals(model.getElementAt(i))) continue;
            i = model.getSize() + 1;
        }
        if (i == model.getSize()) {
            this.securityLevels.add(null);
            model.addElement(levelName);
        }
        this.levelComboBox.setSelectedItem(levelName);
    }

    private void doRemove() {
        int index = this.levelComboBox.getSelectedIndex();
        if (index >= 0) {
            this.currentSelectedIndex = -1;
            this.securityLevels.removeElementAt(index);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
            model.removeElementAt(index);
            try {
                this.updateProperties();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to update security properties", ex);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateProperties() throws Exception {
        if (this.currentSelectedIndex >= 0 && this.currentSelectedIndex < this.securityLevels.size()) {
            values = new Vector<Object>();
            parameters = null;
            parameters = this.fileInfo == null ? new QueryInParam[]{} : this.fileInfo.getInSet().getParameter();
            for (i = 0; i < parameters.length; ++i) {
                obj = null;
                if (this.checkboxArray[i].isSelected() && (obj = this.getParameterValue(i)) == null) {
                    throw new Exception("No value entered for parameter '" + parameters[i].getPromptName() + "'.");
                }
                values.add(obj);
            }
            level = (QueryInParam[])this.securityLevels.elementAt(this.currentSelectedIndex);
            if (level == null) {
                level = new QueryInParam[parameters.length];
            }
            for (i = 0; i < parameters.length; ++i) {
                if (level[i] == null || !level[i].equals((Object)parameters[i])) {
                    level[i] = QueryInParam.create(parameters[i]);
                }
                if (this.checkboxArray[i].isSelected()) {
                    if (parameters[i] instanceof QueryMultiValueInParam) {
                        ((QueryMultiValueInParam)level[i]).setValues((Vector)values.elementAt(i));
                        continue;
                    }
                    level[i].setValue(values.elementAt(i));
                    continue;
                }
                if (parameters[i] instanceof QueryMultiValueInParam) {
                    ((QueryMultiValueInParam)level[i]).setValues(null);
                    continue;
                }
                level[i].setValue(null);
            }
            this.securityLevels.setElementAt(level, this.currentSelectedIndex);
        }
        this.currentSelectedIndex = this.levelComboBox.getSelectedIndex();
        if (this.currentSelectedIndex >= 0 && this.currentSelectedIndex < this.securityLevels.size()) {
            level = (QueryInParam[])this.securityLevels.elementAt(this.currentSelectedIndex);
            parameters = null;
            parameters = this.fileInfo == null ? new QueryInParam[]{} : this.fileInfo.getInSet().getParameter();
            ** if (level == null) goto lbl104
            for (i = 0; i < parameters.length; ++i) {
                currParam = parameters[i];
                if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null) {
                    if (currParam instanceof QueryMultiValueInParam) {
                        values = ((QueryMultiValueInParam)level[i]).getValues();
                        this.listArray[i].clearSelection();
                        if (values != null) {
                            model = (DefaultListModel)this.listArray[i].getModel();
                            indices = new Vector<Integer>();
                            for (k = 0; k < values.size(); ++k) {
                                idx = model.indexOf(values.elementAt(k));
                                if (idx < 0 || idx >= model.size()) continue;
                                if (indices.size() == 0) {
                                    this.listArray[i].setSelectedValue(values.elementAt(k), true);
                                }
                                indices.add(idx);
                            }
                            idices = new int[indices.size()];
                            for (k = 0; k < idices.length; ++k) {
                                idices[k] = (Integer)indices.elementAt(k);
                            }
                            this.listArray[i].setSelectedIndices(idices);
                        }
                    } else {
                        this.choiceArray[i].setSelectedItem(level[i].getValue());
                    }
                } else if (currParam instanceof QueryMultiValueInParam) {
                    vect = ((QueryMultiValueInParam)level[i]).getValues();
                    if (vect == null || vect.toString().equals("[null]")) {
                        this.textArray[i].setText("To be filled in");
                    } else {
                        this.textArray[i].setText(this.getMultiValueString(vect, level[i].getDateFormat()));
                    }
                } else {
                    defaultValue = level[i].getValue();
                    if (defaultValue == null || defaultValue.toString().equals("")) {
                        this.textArray[i].setText("To be filled in");
                    } else {
                        this.textArray[i].setText(DataType.toString(defaultValue, level[i].getDateFormat()));
                    }
                }
                if (currParam instanceof QueryMultiValueInParam && ((QueryMultiValueInParam)level[i]).getValues() == null || !(currParam instanceof QueryMultiValueInParam) && level[i].getValue() == null) {
                    if (this.textArray[i] != null) {
                        this.textArray[i].setEnabled(false);
                    }
                    if (this.choiceArray[i] != null) {
                        this.choiceArray[i].setEnabled(false);
                    }
                    if (this.listArray[i] != null) {
                        this.listArray[i].setEnabled(false);
                    }
                    this.checkboxArray[i].setSelected(false);
                } else {
                    if (this.textArray[i] != null) {
                        this.textArray[i].setEnabled(true);
                    }
                    if (this.choiceArray[i] != null) {
                        this.choiceArray[i].setEnabled(true);
                    }
                    if (this.listArray[i] != null) {
                        this.listArray[i].setEnabled(true);
                    }
                    this.checkboxArray[i].setSelected(true);
                }
                if (this.textArray[i] != null && this.textArray[i].getText().equals("To be filled in")) {
                    this.textArray[i].selectAll();
                }
                if (i != 0) continue;
                if (this.textArray[i] != null) {
                    this.textArray[i].requestFocusInWindow();
                    continue;
                }
                if (this.choiceArray[i] != null) {
                    this.choiceArray[i].requestFocusInWindow();
                    continue;
                }
                if (this.listArray[i] == null) continue;
                this.listArray[i].requestFocusInWindow();
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl104:
        // 4 sources

        this.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.levelComboBox) {
            if (e.getStateChange() == 2) {
                return;
            }
            this.levelComboBox.removeItemListener(this);
            try {
                this.updateProperties();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "An error occured while processing the parameter values", ex);
                String errorMessage = ex.getMessage();
                if (errorMessage == null) {
                    errorMessage = LanguageEncoder.getText("An error occured while processing the parameter values:\n") + ex.toString();
                }
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), errorMessage);
                this.levelComboBox.setSelectedIndex(this.currentSelectedIndex);
            }
            this.levelComboBox.addItemListener(this);
        } else {
            Object source = e.getSource();
            for (int i = 0; i < this.checkboxArray.length; ++i) {
                if (source != this.checkboxArray[i]) continue;
                if (this.checkboxArray[i].isSelected()) {
                    if (this.textArray[i] != null) {
                        this.textArray[i].setEnabled(true);
                    }
                    if (this.choiceArray[i] != null) {
                        this.choiceArray[i].setEnabled(true);
                    }
                    if (this.listArray[i] == null) break;
                    this.listArray[i].setEnabled(true);
                    break;
                }
                if (this.textArray[i] != null) {
                    this.textArray[i].setEnabled(false);
                }
                if (this.choiceArray[i] != null) {
                    this.choiceArray[i].setEnabled(false);
                }
                if (this.listArray[i] == null) break;
                this.listArray[i].setEnabled(false);
                break;
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    private Object getParameterValue(int index) throws Exception {
        QueryInParam[] parameters = null;
        parameters = this.fileInfo == null ? new QueryInParam[]{} : this.fileInfo.getInSet().getParameter();
        QueryInParam currParam = parameters[index];
        String[] valueString = new String[1];
        boolean multiValue = false;
        if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null) {
            if (currParam instanceof QueryMultiValueInParam) {
                multiValue = true;
                Object[] objs = this.listArray[index].getSelectedValues();
                if (objs.length == 0) {
                    return null;
                }
                Vector<Object> vect = new Vector<Object>();
                for (Object obj : objs) {
                    vect.add(obj);
                }
                return vect;
            }
            if (this.choiceArray[index].getSelectedIndex() < 0) {
                return null;
            }
            return this.choiceArray[index].getSelectedItem();
        }
        valueString[0] = this.textArray[index].getText();
        if (currParam instanceof QueryMultiValueInParam) {
            multiValue = true;
            valueString = this.readMultiValues(valueString[0]);
        }
        Vector<Object> valueObject = new Vector<Object>();
        for (String element : valueString) {
            valueObject.addElement(DataType.createObject(element, DataType.mapType(currParam.getSqlType()), currParam.getDateFormat()));
        }
        if (multiValue) {
            if (valueObject.size() == 0) {
                return null;
            }
            return valueObject;
        }
        return valueObject.elementAt(0);
    }

    public Hashtable getSecurityMap() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
        if (model.getSize() > 0) {
            Hashtable table = new Hashtable();
            for (int i = 0; i < model.getSize(); ++i) {
                table.put(model.getElementAt(i), this.securityLevels.elementAt(i));
            }
            return table;
        }
        return null;
    }

    private String[] readMultiValues(String valueString) {
        if (valueString == null) {
            return null;
        }
        try {
            Vector<String> vect = new Vector<String>();
            StreamTokenizer st = new StreamTokenizer(new StringReader(valueString));
            int ttype = st.nextToken();
            while (ttype != -1) {
                if (ttype == -2) {
                    vect.addElement(st.nval + "");
                } else if (st.sval != null) {
                    vect.addElement(st.sval);
                }
                ttype = st.nextToken();
            }
            if (vect.size() == 0) {
                return null;
            }
            String[] ret = new String[vect.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (String)vect.elementAt(i);
            }
            return ret;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot read multi values", ex);
            return null;
        }
    }

    private String getMultiValueString(Vector vect, String dateFormat) {
        if (vect == null) {
            return "";
        }
        String ret = "";
        for (int i = 0; i < vect.size(); ++i) {
            Object obj = vect.elementAt(i);
            if (obj == null) continue;
            String str = DataType.toString(obj, dateFormat);
            ret = str.indexOf(39) >= 0 ? ret + ", \"" + str + "\"" : ret + ", '" + str + "'";
        }
        if (ret.length() > 0) {
            ret = ret.substring(2);
        }
        return ret;
    }

    private void createParamPanel(JPanel container) {
        QueryInParam[] parameters = null;
        parameters = this.fileInfo == null ? new QueryInParam[]{} : this.fileInfo.getInSet().getParameter();
        int nParam = parameters.length;
        int gridY = 0;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        container.setLayout(gbl);
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.gridy = gridY;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel heading = new JLabel(LanguageEncoder.getText("Select Parameter:"));
        gbl.setConstraints(heading, gbc);
        container.add(heading);
        this.choiceArray = new JComboBox[nParam];
        this.textArray = new JTextField[nParam];
        this.listArray = new JList[nParam];
        this.checkboxArray = new JCheckBox[nParam];
        this.selectAllButtonArray = new JButton[nParam];
        this.unselectAllButtonArray = new JButton[nParam];
        for (int i = 0; i < nParam; ++i) {
            QueryInParam currParam = parameters[i];
            boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
            ++gridY;
            if (isMultiValue) {
                gbc.insets = new Insets(0, 5, 0, 0);
                gbc.gridx = 0;
                gbc.gridwidth = 3;
                gbc.weighty = 0.0;
                gbc.weightx = 0.0;
                gbc.gridy = gridY;
                gbc.fill = 0;
                gbc.anchor = 13;
                OurPanel selectUnselectAllPanel = this.createSelectUnselectAllPanel(i);
                gbl.setConstraints(selectUnselectAllPanel, gbc);
                container.add(selectUnselectAllPanel);
            }
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            if (isMultiValue) {
                // empty if block
            }
            gbc.gridy = ++gridY;
            gbc.fill = 0;
            gbc.anchor = 10;
            this.checkboxArray[i] = new JCheckBox();
            gbl.setConstraints(this.checkboxArray[i], gbc);
            container.add(this.checkboxArray[i]);
            this.checkboxArray[i].addItemListener(this);
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            gbc.anchor = 17;
            Component comp = new JLabel(currParam.getPromptName());
            gbl.setConstraints(comp, gbc);
            container.add(comp);
            gbc.gridx = 2;
            gbc.fill = 2;
            if (currParam.getSelectionChoices() != null) {
                JComponent[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    gbc.weighty = 1.0;
                    gbc.fill = 1;
                }
                comp = this.createComponent(isMultiValue, currParam.getSelectionChoices(), array, i);
            } else if (currParam.isMapToColumn()) {
                Vector<Object> distinctValue = new Vector<Object>();
                try {
                    distinctValue = this.fileInfo instanceof QueryXMLFileInfo ? QueryParser.getDistinctValues(((QueryXMLFileInfo)this.fileInfo).getXMLFileQueryInfo(), currParam.getColumnName()) : QueryParser.getDistinctValues(this.fileInfo, currParam.getTableName(), currParam.getColumnName());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to parse query", ex);
                }
                JComponent[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    gbc.weighty = 1.0;
                    gbc.fill = 1;
                }
                comp = this.createComponent(isMultiValue, distinctValue, array, i);
            } else {
                this.textArray[i] = new JTextField("To be filled in", 20);
                comp = this.textArray[i];
            }
            if (this.textArray[i] != null) {
                this.textArray[i].setEnabled(false);
            }
            if (this.choiceArray[i] != null) {
                this.choiceArray[i].setEnabled(false);
            }
            if (this.listArray[i] != null) {
                this.listArray[i].setEnabled(false);
            }
            gbl.setConstraints(comp, gbc);
            container.add(comp);
        }
    }

    private OurPanel createSelectUnselectAllPanel(int paramIndex) {
        OurPanel selectionPanel = new OurPanel(new FlowLayout(2));
        String allStr = ServerMessage.imagesPath + "selectAll.png";
        String noneStr = ServerMessage.imagesPath + "unselectAll.png";
        this.selectAllButtonArray[paramIndex] = new JButton(IOUtil.getImageIcon(allStr));
        selectionPanel.add(this.selectAllButtonArray[paramIndex]);
        this.unselectAllButtonArray[paramIndex] = new JButton(IOUtil.getImageIcon(noneStr));
        selectionPanel.add(this.unselectAllButtonArray[paramIndex]);
        this.selectAllButtonArray[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.selectAllButtonArray[paramIndex].setContentAreaFilled(false);
        this.selectAllButtonArray[paramIndex].addActionListener(this);
        this.unselectAllButtonArray[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.unselectAllButtonArray[paramIndex].setContentAreaFilled(false);
        this.unselectAllButtonArray[paramIndex].addActionListener(this);
        selectionPanel.add(this.selectAllButtonArray[paramIndex]);
        selectionPanel.add(this.unselectAllButtonArray[paramIndex]);
        return selectionPanel;
    }

    private Component createComponent(boolean isMultiValue, Vector values, Object[] array, int index) {
        if (isMultiValue) {
            DefaultListModel model = new DefaultListModel();
            if (values != null) {
                for (int j = 0; j < values.size(); ++j) {
                    if (values.elementAt(j) == null) continue;
                    model.addElement(values.elementAt(j));
                }
            }
            JList list = new JList(model);
            JScrollPane scroll = new JScrollPane(list);
            Dimension d = scroll.getPreferredSize();
            scroll.setPreferredSize(new Dimension((int)d.getWidth(), 100));
            array[index] = list;
            return scroll;
        }
        JComboBox choice = new JComboBox();
        if (values != null) {
            for (int j = 0; j < values.size(); ++j) {
                if (values.elementAt(j) == null) continue;
                choice.addItem(values.elementAt(j));
            }
        }
        array[index] = choice;
        return choice;
    }

    private void doRename(String oldName, String newName) {
        this.reportMain.report.renameQueryParameterSecurityLevel(oldName, newName);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.levelComboBox.getModel();
        int index = -1;
        for (int i = 0; i < model.getSize(); ++i) {
            String levelName = (String)model.getElementAt(i);
            if (!levelName.equals(oldName)) continue;
            index = i;
        }
        if (index >= 0) {
            model.removeElementAt(index);
            model.insertElementAt(newName, index);
            model.setSelectedItem(newName);
        }
    }
}

