/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.ColorButton;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportMain;

public class SelectFontDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(SelectFontDialog.class.getName());
    TableOfContents toc;
    ReportMain reportMain;
    int level;
    String[] fontList;
    String[] styleList = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    JComboBox levelBox;
    JComboBox fontNameBox;
    JComboBox styleNameBox;
    JCheckBox useTopLevelBox;
    JCheckBox underlineBox;
    JCheckBox transparentBox;
    JTextField fontSizeField;
    ColorButton colorButton;
    JButton applyButton;
    JButton closeButton;
    Font currentFont;
    Color currentColor;
    boolean isUnderline;
    boolean isTransparent;

    public SelectFontDialog(ReportMain parent, TableOfContents toc) {
        super(parent, LanguageEncoder.getText("Set Font"), true);
        this.reportMain = parent;
        this.toc = toc;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new BoxLayout(gridpanel, 1));
        JPanel levelPanel = new JPanel(new FlowLayout(0));
        levelPanel.add(new Label(LanguageEncoder.getText("Select a level")));
        String[] s = new String[this.toc.getLevels()];
        s[0] = "Top Level";
        for (int i = 1; i < this.toc.getLevels(); ++i) {
            s[i] = "level " + (i + 1);
        }
        this.levelBox = new JComboBox<String>(s);
        this.levelBox.addItemListener(this);
        this.level = 0;
        this.levelBox.setSelectedIndex(this.level);
        levelPanel.add(this.levelBox);
        gridpanel.add(levelPanel);
        JPanel useTopLevelPanel = new JPanel(new FlowLayout(0));
        this.useTopLevelBox = new JCheckBox(LanguageEncoder.getText("Use Top Level"), false);
        this.useTopLevelBox.setEnabled(false);
        this.useTopLevelBox.addItemListener(this);
        useTopLevelPanel.add(this.useTopLevelBox);
        gridpanel.add(useTopLevelPanel);
        JPanel fontPanel = new JPanel(new BorderLayout());
        fontPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Font")));
        JPanel upperPanel = new JPanel(new FlowLayout(0));
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        labelPanel.add(new Label(LanguageEncoder.getText("Name")));
        labelPanel.add(new Label(LanguageEncoder.getText("Style")));
        labelPanel.add(new Label(LanguageEncoder.getText("Size")));
        JPanel mainPanel = new JPanel(new GridLayout(0, 1));
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontNameBox = new JComboBox<String>(this.fontList);
        mainPanel.add(this.fontNameBox);
        this.fontNameBox.setMaximumRowCount(6);
        this.styleNameBox = new JComboBox<String>(this.styleList);
        mainPanel.add(this.styleNameBox);
        this.fontSizeField = new JTextField();
        mainPanel.add(this.fontSizeField);
        upperPanel.add(labelPanel);
        upperPanel.add(mainPanel);
        JPanel lowerPanel = new JPanel(new FlowLayout(0));
        this.underlineBox = new JCheckBox(LanguageEncoder.getText("Underline Text"));
        lowerPanel.add(this.underlineBox);
        fontPanel.add((Component)upperPanel, "North");
        fontPanel.add((Component)lowerPanel, "South");
        gridpanel.add(fontPanel);
        this.currentFont = this.toc.getFont(0);
        this.isUnderline = this.toc.isUnderline(0);
        this.setFont(this.currentFont, this.isUnderline);
        JPanel fontColorPanel = new JPanel(new FlowLayout(0));
        fontColorPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Font Color")));
        fontColorPanel.add(new Label(LanguageEncoder.getText("Current Color :")));
        this.colorButton = new ColorButton(LanguageEncoder.getText("Click"));
        fontColorPanel.add(this.colorButton);
        this.currentColor = this.toc.getFontColor(0);
        this.setColor(this.currentColor);
        this.isTransparent = this.currentColor == null;
        this.colorButton.setEnabled(!this.isTransparent);
        this.colorButton.addActionListener(this);
        this.transparentBox = new JCheckBox(LanguageEncoder.getText("Transparent"), this.isTransparent);
        fontColorPanel.add(this.transparentBox);
        this.transparentBox.addItemListener(this);
        gridpanel.add(fontColorPanel);
        JPanel applyPanel = new JPanel(new FlowLayout(1));
        this.applyButton = new JButton(LanguageEncoder.getText("Apply"));
        applyPanel.add(this.applyButton);
        this.applyButton.addActionListener(this);
        gridpanel.add(applyPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.closeButton = new JButton(LanguageEncoder.getText("Close"));
        buttonPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)gridpanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    private void setFont(Font font, boolean isUnderline) {
        if (font == null) {
            return;
        }
        this.fontNameBox.setSelectedIndex(this.getName(font.getName()));
        this.styleNameBox.setSelectedIndex(font.getStyle());
        this.fontSizeField.setText(font.getSize() + "");
        this.underlineBox.setSelected(isUnderline);
    }

    private int getName(String str) {
        for (int i = 0; i < this.fontList.length; ++i) {
            if (!this.fontList[i].equals(str)) continue;
            return i;
        }
        return 0;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.colorButton.setColor(color);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item = e.getSource();
        if (item == this.levelBox) {
            this.level = this.levelBox.getSelectedIndex();
            if (this.level == 0) {
                this.useTopLevelBox.setEnabled(false);
            } else {
                this.useTopLevelBox.setEnabled(true);
                this.useTopLevelBox.setSelected(this.toc.isUseTopLevel(this.level));
            }
            if (!this.toc.isUseTopLevel(this.level)) {
                this.currentFont = this.toc.getFont(this.level);
                this.isUnderline = this.toc.isUnderline(this.level);
                this.currentColor = this.toc.getFontColor(this.level);
                this.setFont(this.currentFont, this.isUnderline);
                this.setColor(this.currentColor);
                this.isTransparent = this.currentColor == null;
                this.colorButton.setEnabled(!this.isTransparent);
                this.transparentBox.setSelected(this.isTransparent);
            }
        } else if (item == this.transparentBox) {
            this.isTransparent = this.transparentBox.isSelected();
            this.colorButton.setEnabled(!this.isTransparent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.applyButton) {
            this.toc.setUseTopLevel(this.level, this.useTopLevelBox.isSelected());
            String name = (String)this.fontNameBox.getSelectedItem();
            int style = this.styleNameBox.getSelectedIndex();
            int size = 0;
            try {
                size = Integer.parseInt(this.fontSizeField.getText());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Font size: Invalid number", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Font Size : Integer Only!"), 6);
                return;
            }
            if (size < 3 || size > 99) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Font Size : can't be smaller than 3 or bigger than 99!"), 6);
                return;
            }
            this.currentFont = new Font(name, style, size);
            this.isUnderline = this.underlineBox.isSelected();
            this.isTransparent = this.transparentBox.isSelected();
            this.currentColor = this.colorButton.getColor();
            if (this.isTransparent) {
                this.colorButton.setColor(Color.lightGray);
                this.colorButton.setEnabled(!this.isTransparent);
                this.currentColor = null;
            }
            this.toc.setFont(this.level, this.currentFont);
            this.toc.setUnderline(this.level, this.isUnderline);
            this.toc.setFontColor(this.level, this.currentColor);
        } else {
            if (source == this.colorButton) {
                Color initColor = this.currentColor == null ? Color.lightGray : this.currentColor;
                this.currentColor = ColorDialog.showDialog(this.reportMain, LanguageEncoder.getText("Set Font Color ..."), initColor);
                this.reportMain.addRecentColor(this.currentColor);
                this.setColor(this.currentColor);
                return;
            }
            if (source == this.closeButton) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }
}

