/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMapping;
import quadbase.reportdesigner.designer.ReportWizard;
import quadbase.reportdesigner.util.IReportTypeConstants;

public class SelectReportFormat
extends JPanel
implements ActionListener,
IReportTypeConstants {
    private static final Logger LOGGER = Logger.getLogger(SelectReportFormat.class.getName());
    private JButton next;
    private JButton cancel;
    private JButton back;
    private JRadioButton columnar;
    private JRadioButton summaryBK;
    private JRadioButton crossTab;
    private JRadioButton masterDetails;
    private JRadioButton mailingLabels;
    private ButtonGroup bg;
    private int selectedItem = 0;
    private ReportWizard reportWizard;
    private JPanel prevPanel;
    private boolean isRedoDataMappingOp = false;

    public SelectReportFormat(ReportWizard reportWizard, JPanel prevPanel) {
        this.reportWizard = reportWizard;
        this.prevPanel = prevPanel;
        this.init();
    }

    public SelectReportFormat(ReportWizard reportWizard, boolean isRedoDataMappingOp) {
        this.reportWizard = reportWizard;
        this.selectedItem = reportWizard.reportType;
        this.isRedoDataMappingOp = isRedoDataMappingOp;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Select Report Format")));
        topPanel.setLayout(new GridLayout(2, 3, 0, 0));
        this.bg = new ButtonGroup();
        this.columnar = this.addNewButton(LanguageEncoder.getText("Simple Columnar"), LanguageEncoder.getText("simple columnar report"), "COLUMNAR", "simpleColumnar.gif");
        this.summaryBK = this.addNewButton(LanguageEncoder.getText("Summary Break"), LanguageEncoder.getText("sumary break report"), "SUMMARY", "summaryBreak.gif");
        this.crossTab = this.addNewButton(LanguageEncoder.getText("CrossTab"), LanguageEncoder.getText("cross tab report"), "CROSSTAB", "crossTab.gif");
        this.masterDetails = this.addNewButton(LanguageEncoder.getText("Master and Details"), LanguageEncoder.getText("master and details report"), "MASTERDETAILS", "masterDetails.gif");
        this.mailingLabels = this.addNewButton(LanguageEncoder.getText("Mailing Labels"), LanguageEncoder.getText("mailing labels report"), "MAILINGLABELS", "mailingLabels.gif");
        this.bg.add(this.columnar);
        this.bg.add(this.summaryBK);
        this.bg.add(this.crossTab);
        this.bg.add(this.masterDetails);
        this.bg.add(this.mailingLabels);
        topPanel.add(this.columnar);
        topPanel.add(this.summaryBK);
        topPanel.add(this.crossTab);
        topPanel.add(this.masterDetails);
        topPanel.add(this.mailingLabels);
        topPanel.add(new JLabel(""));
        this.add("Center", topPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new FlowLayout(2));
        this.next = new JButton(LanguageEncoder.getText("Next >>"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.back = new JButton(LanguageEncoder.getText("<< Back"));
        if (!this.isRedoDataMappingOp && this.prevPanel != null) {
            buttonPanel.add(this.back);
        }
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.next);
        this.next.addActionListener(this);
        this.cancel.addActionListener(this);
        this.back.addActionListener(this);
        this.add("South", buttonPanel);
        this.setValues();
    }

    private JRadioButton addNewButton(String name, String tip, String command, String img) {
        String selImg = ServerMessage.reportImagesPath + "sel_" + img;
        img = ServerMessage.reportImagesPath + img;
        JRadioButton newBtn = new JRadioButton(name, IOUtil.getImageIcon(img));
        newBtn.setSelectedIcon(IOUtil.getImageIcon(selImg));
        newBtn.setText(name);
        newBtn.setHorizontalTextPosition(0);
        newBtn.setVerticalTextPosition(1);
        newBtn.setFont(new Font(null, 1, 18));
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
        return newBtn;
    }

    private boolean setValues() {
        if (this.selectedItem == 0) {
            this.columnar.setSelected(true);
        } else if (this.selectedItem == 4) {
            this.mailingLabels.setSelected(true);
        } else if (this.selectedItem == 1) {
            this.summaryBK.setSelected(true);
        } else if (this.selectedItem == 3) {
            this.masterDetails.setSelected(true);
        } else {
            this.selectedItem = 2;
            this.crossTab.setSelected(true);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        String command = e.getActionCommand();
        if (command != null) {
            if (command.equals("COLUMNAR")) {
                this.selectedItem = 0;
            } else if (command.equals("SUMMARY")) {
                this.selectedItem = 1;
            } else if (command.equals("CROSSTAB")) {
                this.selectedItem = 2;
            } else if (command.equals("MASTERDETAILS")) {
                this.selectedItem = 3;
            } else if (command.equals("MAILINGLABELS")) {
                this.selectedItem = 4;
            }
        }
        if (target == this.cancel) {
            this.reportWizard.cancel();
        }
        if (target == this.back) {
            if (!this.isRedoDataMappingOp) {
                this.reportWizard.doReportTypeBack(this, this.prevPanel);
            }
        } else if (target == this.next) {
            if (this.selectedItem < 0) {
                String str = LanguageEncoder.getText("Please select a report format!");
                new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Warning"), str);
                return;
            }
            if (this.isRedoDataMappingOp) {
                if (this.reportWizard.reportType != this.selectedItem) {
                    this.reportWizard.setModified();
                    this.reportWizard.reportType = this.selectedItem;
                }
                this.reportWizard.swapPanel(this, new ReportMapping(this.reportWizard, this.isRedoDataMappingOp));
            } else {
                this.reportWizard.reportType = this.selectedItem;
                this.reportWizard.swapPanel(this, new ReportMapping(this.reportWizard, this));
            }
        }
    }
}

