/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.RecentFiles;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.ReportWizard;

public class SelectReportStyle
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final Logger LOGGER = Logger.getLogger(SelectReportStyle.class.getName());
    private JButton done;
    private JButton cancel;
    private JButton back;
    private JRadioButton style1;
    private JRadioButton style2;
    private JRadioButton style3;
    private JRadioButton style4;
    private JRadioButton style5;
    private JRadioButton style6;
    private ButtonGroup bg;
    private int selectedItem;
    private ReportWizard reportWizard;
    private JPanel prevPanel;
    private JList styleList;
    private String[] recentFiles;
    private JButton browse;
    public static final int CUSTOM_STYLE = 5;

    public SelectReportStyle(ReportWizard reportWizard, JPanel prevPanel) {
        this.reportWizard = reportWizard;
        this.prevPanel = prevPanel;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Select Report Style")));
        topPanel.setLayout(new GridLayout(2, 3, 0, 0));
        this.bg = new ButtonGroup();
        this.style1 = this.addNewButton(LanguageEncoder.getText("Block Left-Align"), LanguageEncoder.getText("Style1 tip"), "STYLE1", "style1.gif");
        this.style2 = this.addNewButton(LanguageEncoder.getText("Break Right-Align"), LanguageEncoder.getText("Style2 tip"), "STYLE2", "style2.gif");
        this.style3 = this.addNewButton(LanguageEncoder.getText("Center Table"), LanguageEncoder.getText("Style3 tip"), "STYLE3", "style3.gif");
        this.style4 = this.addNewButton(LanguageEncoder.getText("List Left-Align"), LanguageEncoder.getText("Style4 tip"), "STYLE4", "style4.gif");
        this.style5 = this.addNewButton(LanguageEncoder.getText("List Break-left"), LanguageEncoder.getText("Style5 tip"), "STYLE5", "style5.gif");
        this.style6 = new JRadioButton();
        this.bg.add(this.style1);
        this.bg.add(this.style2);
        this.bg.add(this.style3);
        this.bg.add(this.style4);
        this.bg.add(this.style5);
        this.bg.add(this.style6);
        JPanel customPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        JLabel label = new JLabel("Custom Style");
        label.setFont(new Font(null, 1, 18));
        labelPanel.add(label);
        JScrollPane scrollPane = new JScrollPane(21, 30);
        this.recentFiles = RecentFiles.getFilePaths(null, 3);
        this.styleList = new JList<String>(this.recentFiles);
        this.styleList.setVisibleRowCount(4);
        this.styleList.setSelectionMode(0);
        this.styleList.addListSelectionListener(this);
        JViewport port = scrollPane.getViewport();
        port.setPreferredSize(new Dimension(100, 50));
        port.add(this.styleList);
        this.browse = new JButton(LanguageEncoder.getText("Browse"));
        this.browse.addActionListener(this);
        JPanel stylePanel = new JPanel(new BorderLayout());
        stylePanel.setBorder(new TitledBorder(""));
        stylePanel.add((Component)scrollPane, "Center");
        stylePanel.add((Component)this.browse, "South");
        customPanel.add("North", labelPanel);
        customPanel.add("Center", stylePanel);
        topPanel.add(this.style1);
        topPanel.add(this.style2);
        topPanel.add(this.style3);
        topPanel.add(this.style4);
        topPanel.add(this.style5);
        topPanel.add(customPanel);
        this.add("Center", topPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new FlowLayout(2));
        this.done = new JButton(LanguageEncoder.getText("Done >>"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.back = new JButton(LanguageEncoder.getText("<< Back"));
        buttonPanel.add(this.back);
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.done);
        this.done.addActionListener(this);
        this.cancel.addActionListener(this);
        this.back.addActionListener(this);
        this.add("South", buttonPanel);
        if (this.reportWizard.report != null) {
            this.selectedItem = this.reportWizard.report.reportStyle;
        }
        if (this.selectedItem < 0) {
            this.selectedItem = 0;
        }
        this.setValues();
    }

    private JRadioButton addNewButton(String name, String tip, String command, String img) {
        String selImg = ServerMessage.reportImagesPath + "sel_" + img;
        img = ServerMessage.reportImagesPath + img;
        JRadioButton newBtn = new JRadioButton(name, IOUtil.getImageIcon(img));
        newBtn.setSelectedIcon(IOUtil.getImageIcon(selImg));
        newBtn.setText(name);
        newBtn.setHorizontalTextPosition(0);
        newBtn.setVerticalTextPosition(1);
        newBtn.setFont(new Font(null, 1, 18));
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
        return newBtn;
    }

    private boolean setValues() {
        if (this.selectedItem == 0) {
            this.style1.setSelected(true);
        } else if (this.selectedItem == 1) {
            this.style2.setSelected(true);
        } else if (this.selectedItem == 2) {
            this.style3.setSelected(true);
        } else if (this.selectedItem == 3) {
            this.style4.setSelected(true);
        } else if (this.selectedItem == 4) {
            this.style5.setSelected(true);
        }
        for (int i = 0; i < this.recentFiles.length; ++i) {
            String s = this.reportWizard.report.customStyleFile;
            if (s == null || !s.equals(this.recentFiles[i])) continue;
            this.styleList.setSelectedIndex(i);
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.styleList.isSelectionEmpty()) {
            this.style6.setSelected(true);
            this.selectedItem = 5;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        String command = e.getActionCommand();
        if (command != null) {
            if (command.equals("STYLE1")) {
                this.selectedItem = 0;
            } else if (command.equals("STYLE2")) {
                this.selectedItem = 1;
            } else if (command.equals("STYLE3")) {
                this.selectedItem = 2;
            } else if (command.equals("STYLE4")) {
                this.selectedItem = 3;
            } else if (command.equals("STYLE5")) {
                this.selectedItem = 4;
            }
            this.styleList.clearSelection();
        }
        if (target == this.cancel) {
            this.reportWizard.cancel();
        } else if (target == this.back) {
            this.reportWizard.swapPanel(this, this.prevPanel);
        } else if (target == this.browse) {
            String[] ext = new String[]{"STL"};
            if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                JFileChooser fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                ExtensionFilter fileFilter = new ExtensionFilter(ext);
                fileChooser.addChoosableFileFilter(fileFilter);
                fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                fileChooser.showDialog(this.reportWizard.reportmain, null);
                if (fileChooser.getSelectedFile() == null) {
                    return;
                }
                String fn = fileChooser.getSelectedFile().getPath();
                RecentFiles.insertFilePath(null, 3, fn);
                this.recentFiles = RecentFiles.getFilePaths(null, 3);
                this.styleList.setListData(this.recentFiles);
                this.styleList.setSelectedIndex(0);
            } else {
                BrowseDialog browseDialog = BrowseDialog.create(this.reportWizard.reportmain, this.reportWizard.reportmain.getBrowseDirectories().getApplyTemplateDir(), ext);
                browseDialog.setVisible(true);
                String fn = browseDialog.getSelectedFile();
                RecentFiles.insertFilePath(null, 3, fn);
                this.recentFiles = RecentFiles.getFilePaths(null, 3);
                this.styleList.setListData(this.recentFiles);
                this.styleList.setSelectedIndex(0);
            }
        } else if (target == this.done) {
            if (this.selectedItem < 0) {
                String str = LanguageEncoder.getText("Please select a report style!");
                new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Warning"), str);
                return;
            }
            if (this.selectedItem == 5) {
                String fileName = (String)this.styleList.getSelectedValue();
                if (fileName == null || fileName.equals("")) {
                    String str = LanguageEncoder.getText("Please enter a style file!");
                    new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Warning"), str);
                    return;
                }
                FileInfo fInfo = new FileInfo(fileName);
                try {
                    if (!fInfo.exists() || fInfo.isDirectory()) {
                        String str = LanguageEncoder.getText("File \"" + fileName + "\" does not exist!");
                        new JMessageDialog((Dialog)this.reportWizard, LanguageEncoder.getText("Warning"), str);
                        return;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to check if file exists already", ex);
                }
            }
            boolean changingStyle = false;
            if (this.reportWizard.report.reportStyle != -1 && this.reportWizard.report.reportStyle != this.selectedItem) {
                try {
                    ReportStyle.removeStyle(this.reportWizard.report.reportStyle, this.reportWizard.report);
                    changingStyle = true;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to remove current report style", ex);
                }
            }
            this.reportWizard.report.reportStyle = this.selectedItem;
            this.reportWizard.doneWizard(this.reportWizard.report, false);
            if (!this.reportWizard.isCancelled()) {
                if (this.selectedItem >= 0 && this.selectedItem < 5) {
                    this.reportWizard.formatReport(this.selectedItem, changingStyle);
                    this.reportWizard.report.customStyleFile = null;
                } else if (this.selectedItem == 5) {
                    this.reportWizard.report.customStyleFile = (String)this.styleList.getSelectedValue();
                    this.reportWizard.formatReport((String)this.styleList.getSelectedValue());
                }
                if (!this.reportWizard.reportmain.isDesignMode() && this.reportWizard.reportmain.report.isCrossTabFixedField()) {
                    this.reportWizard.reportmain.do_retrieveWithoutDataUpdate(false);
                }
            }
        }
    }
}

