/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ServerPortDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ServerPortDialog.class.getName());
    private JButton okButton;
    private JButton cancelButton;
    private JTextField serverText;
    private JTextField portText;
    private JTextField directoryText;
    private String server = "";
    private String servletDirectory = "";
    private int port = -1;
    private boolean modified = false;

    public ServerPortDialog(JFrame frame) {
        super((Frame)frame, true);
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Servlet Location"));
        JPanel bpanel = (JPanel)this.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        bpanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel comp = new JLabel(LanguageEncoder.getText("Please specify the location of the drill-down servlet:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        comp = new JLabel(LanguageEncoder.getText("Server Name:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridx = 0;
        gbc.gridy = 2;
        comp = new JLabel(LanguageEncoder.getText("Port Number:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridx = 0;
        gbc.gridy = 3;
        comp = new JLabel(LanguageEncoder.getText("Servlet Directory:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.serverText = new JTextField("127.0.0.1", 15);
        Dimension d = this.serverText.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.serverText.setMinimumSize(d);
        gbl.setConstraints(this.serverText, gbc);
        bpanel.add(this.serverText);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        this.portText = new JTextField("8080", 15);
        d = this.portText.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.portText.setMinimumSize(d);
        gbl.setConstraints(this.portText, gbc);
        bpanel.add(this.portText);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        this.directoryText = new JTextField("servlet/", 15);
        d = this.directoryText.getPreferredSize();
        d.setSize(5.0, d.getHeight());
        this.directoryText.setMinimumSize(d);
        gbl.setConstraints(this.directoryText, gbc);
        bpanel.add(this.directoryText);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new FlowLayout());
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        okpanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        okpanel.add(this.cancelButton);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbl.setConstraints(okpanel, gbc);
        bpanel.add(okpanel);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.server = this.serverText.getText().trim();
            this.servletDirectory = this.directoryText.getText().trim();
            try {
                this.port = Integer.parseInt(this.portText.getText().trim());
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Port number: Invalid number", ex);
            }
            if (this.server == null || this.server.equals("") || this.port < 0 || this.port > 50000) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Invalid server name and/or port number."));
                return;
            }
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.modified = false;
            this.setVisible(false);
            this.dispose();
        }
    }

    public String getServerName() {
        return this.server;
    }

    public int getPortNumber() {
        return this.port;
    }

    public String getServletDirectory() {
        return this.servletDirectory;
    }

    public boolean isModified() {
        return this.modified;
    }
}

