/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.designer.SetBorderPanel;
import quadbase.reportdesigner.designer.SetRoundCornersPanel;

public class SetBorderDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private ReportMain reportMain;
    private SetRoundCornersPanel setRoundCornersPanel;
    private SetBorderPanel setBorderPanel;
    private boolean forLinesOnly;

    public SetBorderDialog(ReportMain reportMain, boolean forLinesOnly) {
        super(reportMain, forLinesOnly ? LanguageEncoder.getText("Set Line ...") : LanguageEncoder.getText("Set Border ..."), true);
        this.forLinesOnly = forLinesOnly;
        this.reportMain = reportMain;
        this.init();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        if (this.forLinesOnly) {
            this.setBorderPanel = new SetBorderPanel(this.reportMain, false);
        } else {
            this.setRoundCornersPanel = new SetRoundCornersPanel(this.reportMain);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.forLinesOnly ? this.setBorderPanel : this.setRoundCornersPanel);
        contentPane.add("South", buttonPanel);
        this.setPosition();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.forLinesOnly) {
                this.setBorderPanel.saveChanges();
            } else {
                this.setRoundCornersPanel.saveChanges();
            }
            this.reportMain.setModified();
            this.reportMain.designPanel.rulerPanel.repaintPanel();
        }
        this.setVisible(false);
        this.dispose();
    }
}

