/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.JTextFieldLimit;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.designer.ColorDialog;
import quadbase.reportdesigner.designer.ReportMain;

public class SetBorderPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final Logger LOGGER = Logger.getLogger(SetBorderPanel.class.getName());
    private ReportMain reportMain;
    private ReportElement elt;
    private Color borderColor;
    private ColorButton colorButton;
    private boolean isTransparent;
    private int borderThickness;
    private JTextField borderThicknessField;
    private boolean showApplyButton;
    private JButton applyButton;

    public SetBorderPanel(ReportMain reportMain, boolean showApplyButton) {
        this.reportMain = reportMain;
        this.showApplyButton = showApplyButton;
        this.elt = null;
        this.borderThickness = reportMain.designPanel.rulerPanel.groupFormatInitBorderThickness(BorderSide.TOP);
        this.borderColor = reportMain.designPanel.rulerPanel.groupFormatInitBorderColor();
        this.init();
    }

    public SetBorderPanel(ReportMain reportMain, ReportElement elt, boolean showApplyButton) {
        this.elt = elt;
        this.reportMain = reportMain;
        this.showApplyButton = showApplyButton;
        this.borderColor = elt.getBorderColor();
        this.borderThickness = elt.getBorder(BorderSide.TOP);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Set Border")));
        JPanel thicknessPanel = new JPanel();
        thicknessPanel.setLayout(new FlowLayout(0));
        thicknessPanel.add(new JLabel(LanguageEncoder.getText("Thickness")));
        this.borderThicknessField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.borderThicknessField.setDocument(new JTextFieldLimit(2));
        this.borderThicknessField.setColumns(2);
        this.borderThicknessField.setText(this.borderThickness + "");
        this.borderThicknessField.addActionListener(this);
        this.borderThicknessField.addFocusListener(this);
        thicknessPanel.add(this.borderThicknessField);
        thicknessPanel.add(new JLabel(LanguageEncoder.getText("Current Color :")));
        this.colorButton = new ColorButton(LanguageEncoder.getText("Click"));
        thicknessPanel.add(this.colorButton);
        this.borderColor = this.borderColor == null ? new Color(0, 0, 0) : this.borderColor;
        this.colorButton.setEnabled(!this.isTransparent);
        this.colorButton.addActionListener(this);
        this.setColor(this.borderColor);
        if (this.showApplyButton) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            this.applyButton = new JButton(LanguageEncoder.getText("Apply"));
            this.applyButton.addActionListener(this);
            buttonPanel.add(this.applyButton);
            this.add("South", buttonPanel);
        }
        this.add("Center", thicknessPanel);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object eventSrc = arg0.getSource();
        if (this.showApplyButton && eventSrc == this.applyButton) {
            this.saveChanges();
            this.reportMain.designPanel.rulerPanel.repaintPanel();
            this.reportMain.setModified();
        } else if (eventSrc == this.colorButton) {
            Color initColor = this.borderColor == null ? Color.lightGray : this.borderColor;
            this.borderColor = ColorDialog.showDialog(this.reportMain, LanguageEncoder.getText("Set Border Color..."), initColor);
            this.reportMain.addRecentColor(this.borderColor);
            this.setColor(this.borderColor);
        } else {
            this.borderColor = this.colorButton.getColor();
            this.refreshBorderThickness();
        }
    }

    public void saveChanges() {
        if (this.elt != null) {
            this.elt.setBorderColor(this.getBorderColor());
            this.elt.setBorderThickness(this.getBorderThickness());
        } else {
            this.reportMain.designPanel.rulerPanel.groupFormatSetBorderThickness(this.getBorderThickness(), BorderSide.TOP);
            this.reportMain.designPanel.rulerPanel.groupFormatSetBorderColor(this.getBorderColor());
        }
    }

    int getBorderThickness() {
        this.refreshBorderThickness();
        return this.borderThickness;
    }

    private void refreshBorderThickness() {
        try {
            this.borderThickness = Math.abs(Integer.parseInt(this.borderThicknessField.getText()));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, "Border thickness: Invalid number, using 0", e);
            this.borderThickness = 0;
        }
        this.borderThicknessField.setText(Integer.toString(this.borderThickness));
    }

    public Color getBorderColor() {
        return this.isTransparent ? null : this.borderColor;
    }

    public void addListeners(JPanel jpanel) {
        this.borderThicknessField.addActionListener((ActionListener)((Object)jpanel));
        this.colorButton.addActionListener((ActionListener)((Object)jpanel));
        this.borderThicknessField.addFocusListener((FocusListener)((Object)jpanel));
    }

    private void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.colorButton.setColor(color);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        Object srcObj = arg0.getSource();
        if (srcObj == this.borderThicknessField) {
            this.refreshBorderThickness();
        }
    }
}

